package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ubsidi.R;
import com.ubsidi.epos_2021.models.DepositType;

import java.util.ArrayList;

public class ReservationDepositAdapter extends ArrayAdapter<DepositType> {

    private Context context;
    private ArrayList<DepositType> reservationDepositList;

    public ReservationDepositAdapter(@NonNull Context context, int resource, @NonNull ArrayList<DepositType> objects) {
        super(context, resource, objects);
        this.context = context;
        this.reservationDepositList = objects;
    }

    @Override
    public int getCount() {
        return reservationDepositList.size();
    }

    @Nullable
    @Override
    public DepositType getItem(int position) {
        return reservationDepositList.get(position);
    }

    @Override
    public long getItemId(int position){
        return position;
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        // I created a dynamic TextView here, but you can reference your own  custom layout for each spinner item
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());

        View view;
        if (convertView == null) {
            view = layoutInflater.inflate(R.layout.custom_spinner_item, parent, false);
        } else {
            view = convertView;
        }
        TextView label = (TextView) view.findViewById(R.id.tvDeposit);
        ImageView icon = (ImageView) view.findViewById(R.id.ivDeposit);

        // Then you can get the current item using the values array (Users array) and the current position
        // You can NOW reference each method you has created in your bean object (User class)
        label.setText(reservationDepositList.get(position).type);

        // And finally return your dynamic (or custom) view for each spinner item
        return view;
    }


    @Override
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());
        View view;
        if (convertView == null) {
            view = layoutInflater.inflate(R.layout.custom_spinner_item, parent, false);
        } else {
            view = convertView;
        }
        TextView label = (TextView) view.findViewById(R.id.tvDeposit);
        ImageView icon = (ImageView) view.findViewById(R.id.ivDeposit);
        icon.setVisibility(View.INVISIBLE);
        label.setText(reservationDepositList.get(position).type);

        return view;
    }

}
