package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewVoucherClickListener;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.online.models.OnlineReservation;

import java.util.ArrayList;

public class ReservationListAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    public ArrayList<Object> objects;
    private RecyclerviewVoucherClickListener itemClickListener;

    public ReservationListAdapter(ArrayList<Object> objects, RecyclerviewVoucherClickListener itemClickListener) {
        this.objects = objects;
        this.itemClickListener = itemClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        if (objects.size() > 0) {
            if (objects.get(position) instanceof OnlineReservation) {
                return R.layout.item_reservations_online;
            } else {
                return R.layout.item_reservations;
            }
        } else return super.getItemViewType(position);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false);
        return new ReservationViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_reservations) {

                ReservationViewHolder holder = (ReservationViewHolder) viewHolder;
                Reservation reservation = (Reservation) objects.get(position);
              /*  if (reservation.past_days >= 7) {
                    holder.tvDelete.setVisibility(View.VISIBLE);
                } else {
                    holder.tvDelete.setVisibility(View.GONE);
                }*/
                holder.tvSitOnTable.setVisibility(View.VISIBLE);
                if (Validators.isNullOrEmpty(reservation.special_instruction))
                    holder.tvInstruction.setText("None");
                else holder.tvInstruction.setText(reservation.special_instruction);

                if (reservation.customer_name == null) holder.tvName.setText("");
                else holder.tvName.setText(reservation.customer_name);

                if (reservation.table_number == null) holder.tvTable.setText("-");
                else holder.tvTable.setText(reservation.table_number);

                if (!Validators.isNullOrEmpty(reservation.reservation_date_time)) {
                    holder.tvDate.setText(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd-MM-yyyy\nhh:mm a"));
                }
                holder.tvGuest.setText(reservation.diners + "");

                if (reservation.customer == null) {
                    holder.tvContactNo.setText("-");
                } else {
                    holder.tvContactNo.setText(reservation.customer.mobile);
                }

               /* holder.tvDelete.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "delete", reservation);
                });*/
                holder.tvView.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "view", reservation);
                });

                holder.tvPrint.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "print", reservation);
                });

                holder.tvCancel.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "cancel", reservation);
                });
                holder.tvSitOnTable.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "sit_on_table", reservation);
                });
                holder.tvAccept.setVisibility(View.GONE);
                if (reservation.reservation_status_id.equalsIgnoreCase("2")) {
                    holder.tvCancel.setVisibility(View.GONE);
                    holder.tvSitOnTable.setVisibility(View.GONE);
                } else {
                    holder.tvCancel.setVisibility(View.VISIBLE);
                }

            }
            if (getItemViewType(position) == R.layout.item_reservations_online) {
                ReservationViewHolder holder = (ReservationViewHolder) viewHolder;
                OnlineReservation onlineReservation = (OnlineReservation) objects.get(position);
                holder.tvDelete.setChecked(onlineReservation.isDeleteSelected);
                holder.tvDelete.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                    @Override
                    public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                        if(compoundButton.isPressed()){
                            onlineReservation.isDeleteSelected = true;
                            itemClickListener.onItemClick(position, "delete", onlineReservation);
                        }
                    }
                });
                if (onlineReservation.past_days >= 7) {
                    holder.tvDelete.setVisibility(View.VISIBLE);
                } else {
                    holder.tvDelete.setVisibility(View.GONE);
                }
                holder.tvSitOnTable.setVisibility(View.GONE);
                if (Validators.isNullOrEmpty(onlineReservation.booking_instruction))
                    holder.tvInstruction.setText("None");
                else holder.tvInstruction.setText(onlineReservation.booking_instruction);

                if (Validators.isNullOrEmpty(onlineReservation.customer_name))
                    holder.tvName.setText("");
                else holder.tvName.setText(onlineReservation.customer_name);

                holder.tvTable.setText("-");

                if (!Validators.isNullOrEmpty(onlineReservation.booking_date)) {
                    holder.tvDate.setText(CommonFunctions.formatUnknownDateTime(onlineReservation.booking_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n" + onlineReservation.booking_time);
                }

                holder.tvGuest.setText(onlineReservation.guest_count);

                if (Validators.isNullOrEmpty(onlineReservation.booking_phone)) {
                    holder.tvContactNo.setText("-");
                } else {
                    holder.tvContactNo.setText(onlineReservation.booking_phone);
                }


                if (onlineReservation.status.equalsIgnoreCase("pending")) {
                    holder.tvCancel.setVisibility(View.VISIBLE);
                    holder.tvAccept.setVisibility(View.VISIBLE);
                } else {
                    holder.tvCancel.setVisibility(View.GONE);
                    holder.tvAccept.setVisibility(View.GONE);
                }

               /* holder.tvDelete.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "delete", onlineReservation);
                });*/
                holder.tvView.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "view", onlineReservation);
                });

                holder.tvPrint.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "print", onlineReservation);
                });

                holder.tvCancel.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "cancel", onlineReservation);
                });
                holder.tvAccept.setOnClickListener(v -> {
                    itemClickListener.onItemClick(position, "accept", onlineReservation);
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return objects.size();
    }

    private class ReservationViewHolder extends RecyclerView.ViewHolder {

        TextView tvCancel, tvPrint, tvView, tvInstruction, tvContactNo, tvTable, tvGuest, tvDate, tvName, tvAccept, tvSitOnTable;
        CheckBox tvDelete;

        public ReservationViewHolder(@NonNull View itemView) {
            super(itemView);
            tvAccept = itemView.findViewById(R.id.tvAccept);
            tvName = itemView.findViewById(R.id.tvName);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvGuest = itemView.findViewById(R.id.tvGuest);
            tvTable = itemView.findViewById(R.id.tvTable);
            tvContactNo = itemView.findViewById(R.id.tvContactNo);
            tvInstruction = itemView.findViewById(R.id.tvInstruction);
            tvView = itemView.findViewById(R.id.tvView);
            tvPrint = itemView.findViewById(R.id.tvPrint);
            tvCancel = itemView.findViewById(R.id.tvCancel);
            tvSitOnTable = itemView.findViewById(R.id.tvSitOnTable);
            tvDelete = itemView.findViewById(R.id.tvDelete);
        }
    }

}
