package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ubsidi.epos_2021.models.ReservationType;

import java.util.ArrayList;

public class ReservationTypeAdapter extends ArrayAdapter<ReservationType> {

    private Context context;
    private ArrayList<ReservationType> reservationTypeList;

    public ReservationTypeAdapter(@NonNull Context context, int resource, @NonNull ArrayList<ReservationType> objects) {
        super(context, resource, objects);
        this.context = context;
        this.reservationTypeList = objects;
    }

    @Override
    public int getCount() {
        return reservationTypeList.size();
    }

    @Nullable
    @Override
    public ReservationType getItem(int position) {
        return reservationTypeList.get(position);
    }

    @Override
    public long getItemId(int position){
        return position;
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        // I created a dynamic TextView here, but you can reference your own  custom layout for each spinner item
        TextView label = (TextView) super.getView(position, convertView, parent);
        label.setTextColor(Color.BLACK);
        // Then you can get the current item using the values array (Users array) and the current position
        // You can NOW reference each method you has created in your bean object (User class)
        label.setText(reservationTypeList.get(position).type);

        // And finally return your dynamic (or custom) view for each spinner item
        return label;
    }

    @Override
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        TextView label = (TextView) super.getDropDownView(position, convertView, parent);
        label.setTextColor(Color.BLACK);
        label.setText(reservationTypeList.get(position).type);

        return label;
    }

}
