package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.interfaces.RecyclerviewVoucherClickListener;
import com.ubsidi.epos_2021.models.Reservation;

import java.util.ArrayList;

public class ReservationsMiniAdapter extends RecyclerView.Adapter<ReservationsMiniAdapter.ViewHolder> {

    private ArrayList<Reservation> reservationArrayList;
    private RecyclerviewVoucherClickListener itemClickListener;

    public ReservationsMiniAdapter(ArrayList<Reservation> reservationArrayList, RecyclerviewVoucherClickListener itemClickListener) {
        this.reservationArrayList = reservationArrayList;
        this.itemClickListener = itemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_reservations_mini, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ReservationsMiniAdapter.ViewHolder holder, int position) {
        try {
            Reservation reservation = reservationArrayList.get(position);

            holder.tvDiners.setText(String.valueOf(reservation.diners));

            if (reservation.customer_name == null)
                holder.tvName.setText("");
            else
                holder.tvName.setText(reservation.customer_name);


            holder.tvTime.setText(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return reservationArrayList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {

        TextView tvName, tvTime, tvDiners;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tvName);
            tvTime = itemView.findViewById(R.id.tvTime);
            tvDiners = itemView.findViewById(R.id.tvDiners);

        }
    }

}
