package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.SalesReport;

import java.util.ArrayList;

public class SalesReportAdapter extends RecyclerView.Adapter<SalesReportAdapter.ViewHolder> {

    private ArrayList<Object> reports;
    private RecyclerviewItemClickListener itemClickListener;

    public SalesReportAdapter(ArrayList<Object> reports, RecyclerviewItemClickListener itemClickListener) {
        this.reports = reports;
        this.itemClickListener = itemClickListener;
    }

    @NonNull
    @Override
    public SalesReportAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_sales_report, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull SalesReportAdapter.ViewHolder holder, int position) {
        try {
            SalesReport report = (SalesReport) reports.get(position);

            if (Validators.isNullOrEmpty(report.product_name) && Validators.isNullOrEmpty(report.category_name)) {
                holder.tvTitle.setText("-");
            } else {
                if (!Validators.isNullOrEmpty(report.product_name)) {
                    holder.tvTitle.setText(report.product_name);
                } else {
                    holder.tvTitle.setText(report.category_name);
                }
            }

            holder.tvValue.setText(report.total);
            holder.tvCount.setText(report.count);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return reports.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvTitle, tvValue, tvCount;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTitle = itemView.findViewById(R.id.tvTitle);
            tvValue = itemView.findViewById(R.id.tvValue);
            tvCount = itemView.findViewById(R.id.tvCount);
        }
    }
}
