package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Business;

import java.util.ArrayList;

/**
 * Created by Amrish on 23-04-2021.
 */
public class SelectBusinessAdapter extends RecyclerView.Adapter<SelectBusinessAdapter.BusinessViewHolder> {
    public ArrayList<Business> businesses;
    private final RecyclerviewItemClickListener recyclerviewItemClickListener;
    public String selectedBusinessId = "";
    public RadioButton checkedRadioButton;

    public SelectBusinessAdapter(ArrayList<Business> businesses, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.businesses = businesses;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public BusinessViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new BusinessViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_business, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull BusinessViewHolder holder, int position) {
        try {
            if (selectedBusinessId != null)
                holder.rbBusiness.setChecked(selectedBusinessId.equalsIgnoreCase(businesses.get(position).id));
            else holder.rbBusiness.setChecked(false);

            holder.tvBusiness.setText(businesses.get(position).name);
            holder.itemView.setOnClickListener(view -> {
                selectedBusinessId = businesses.get(position).id;
                notifyDataSetChanged();
                if (checkedRadioButton != null) checkedRadioButton.setChecked(false);
                checkedRadioButton = holder.rbBusiness;
                holder.rbBusiness.setChecked(true);
                if (recyclerviewItemClickListener != null)
                    recyclerviewItemClickListener.onItemClick(position, businesses.get(position));
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return businesses.size();
    }

    protected static class BusinessViewHolder extends RecyclerView.ViewHolder {
        private TextView tvBusiness;
        private RadioButton rbBusiness;

        public BusinessViewHolder(@NonNull View itemView) {
            super(itemView);
            tvBusiness = itemView.findViewById(R.id.tvBusiness);
            rbBusiness = itemView.findViewById(R.id.rbBusiness);
        }
    }
}
