package com.ubsidi.epos_2021.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListenerWithTag;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListenerWithTagAndModel;
import com.ubsidi.epos_2021.models.ProductAddon;

import java.util.ArrayList;

public class SelectedAddonAdapter extends RecyclerView.Adapter<SelectedAddonAdapter.ViewHolder> {

    private ArrayList<ProductAddon> productAddons;
    private RecyclerviewItemClickListenerWithTagAndModel itemClickListenerWithTag;

    public SelectedAddonAdapter(ArrayList<ProductAddon> productAddons, RecyclerviewItemClickListenerWithTagAndModel itemClickListenerWithTag) {
        this.productAddons = productAddons;
        this.itemClickListenerWithTag = itemClickListenerWithTag;
    }

    public void notifyList(ArrayList<ProductAddon> objects, Activity activity){
        this.productAddons= objects;
        activity.runOnUiThread(()->{
            notifyDataSetChanged();
        });
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_selectedaddon, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull SelectedAddonAdapter.ViewHolder holder, int position) {
        try {
            ProductAddon orderItemAddon = productAddons.get(position);
            if(orderItemAddon.selectedQuantity>0){
                holder.llMain.setVisibility(View.VISIBLE);
                holder.rvAddonsList.setAdapter( new SelectedAddonItemsAdapter(orderItemAddon.selectedOrderItemAddon,
                        (position1, tag, data,productAddon1) -> {
                            itemClickListenerWithTag.onItemClick(position1,tag,data,orderItemAddon);
                        }
                ));
            }else {
                holder.llMain.setVisibility(View.GONE);
                holder.rvAddonsList.setAdapter( new SelectedAddonItemsAdapter(new ArrayList<>(),
                        (position1, tag, data,productAddon1) -> {
                            itemClickListenerWithTag.onItemClick(position1,tag,data,orderItemAddon);
                        }
                ));
            }
           /* holder.tvSelectedAddons.setText(orderItemAddon.addon_name + " ( " + MyApp.currencySymbol + MyApp.df.format(orderItemAddon.price) + " ) ");
            holder.ivDelete.setOnClickListener(v -> {
                if (deleteClickListener != null) {
                    deleteClickListener.onItemClick(position, orderItemAddon);
                }
            });*/
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return productAddons.size();
    }


    public static class ViewHolder extends RecyclerView.ViewHolder {
//        TextView tvSelectedAddons;
//        ImageView ivDelete;
            RecyclerView rvAddonsList;
            LinearLayout llMain;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
          /*  ivDelete = itemView.findViewById(R.id.ivDelete);
            tvSelectedAddons = itemView.findViewById(R.id.tvSelectedAddons);*/
            llMain = itemView.findViewById(R.id.llMain);
            rvAddonsList = itemView.findViewById(R.id.rvAddonsList);
        }
    }
}
