package com.ubsidi.epos_2021.adapters;

import static com.ubsidi.epos_2021.utils.Constants.QUANTITY_MODIFIED_ADD;
import static com.ubsidi.epos_2021.utils.Constants.QUANTITY_MODIFIED_MINUS;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.daimajia.swipe.SwipeLayout;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListenerWithTag;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListenerWithTagAndModel;
import com.ubsidi.epos_2021.models.OrderItemAddon;

import java.util.ArrayList;

public class SelectedAddonItemsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Activity activity;
    private ArrayList<OrderItemAddon> objects;
    private ArrayList<OrderItemAddon> products;
    private RecyclerviewItemClickListenerWithTagAndModel itemClickListenerWithTag;
    //  public boolean shouldEdit;

    public void notifyList(ArrayList<OrderItemAddon> objects){
        this.objects= objects;
        notifyDataSetChanged();
    }
    public SelectedAddonItemsAdapter(ArrayList<OrderItemAddon> orderItems, RecyclerviewItemClickListenerWithTagAndModel itemClickListener) {
        this.objects = orderItems;
        this.itemClickListenerWithTag = itemClickListener;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_cart_selected_addons, parent, false));
    }


    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        try {
                ViewHolder holder = (ViewHolder) viewHolder;
            OrderItemAddon orderItem = objects.get(position);
                if(orderItem.quantity>0){
                    holder.llMain.setVisibility(View.VISIBLE);
                    holder.tvItemName.setText(orderItem.addon_name);

                    holder.tvPrice.setText(MyApp.currencySymbol + MyApp.df.format(orderItem.price));
                    holder.tvModifyQty.setText(orderItem.quantity + "");
                    holder.rlPlusModify.setOnClickListener(v -> {
                        if (itemClickListenerWithTag != null) {
                            itemClickListenerWithTag.onItemClick(position, QUANTITY_MODIFIED_ADD, orderItem,null);
                        }
                    });
                    holder.rlMinusModify.setOnClickListener(v -> {
                        try {
                            if (orderItem.quantity > 1) {
                               /* orderItem.quantity--;
                                holder.tvModifyQty.setText(orderItem.quantity + "");*/
                                if (itemClickListenerWithTag != null)
                                    itemClickListenerWithTag.onItemClick(position, QUANTITY_MODIFIED_MINUS, orderItem,null);

                            } else {
                                holder.ivMinus.setImageResource(R.drawable.ic_delete_black_24dp);
                                if (!objects.isEmpty()) {
                                    objects.remove(position);
                                    //notifyItemRemoved(position); - For Testing
                                }
                                // notifyItemRemoved(position);
                                if (itemClickListenerWithTag != null) {
                                    itemClickListenerWithTag.onItemClick(position, QUANTITY_MODIFIED_MINUS, orderItem,null);
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                    if (orderItem.quantity == 1) {
                        holder.ivMinus.setImageResource(R.drawable.ic_delete_black_24dp);
                    } else {
                        holder.ivMinus.setImageResource(R.drawable.ic_baseline_remove);
                    }

                    holder.llDelete.setOnClickListener(view -> {
                        try {
                            holder.swipeRevealLayout.close(true);
                            if (itemClickListenerWithTag != null) {
                                itemClickListenerWithTag.onItemClick(position, QUANTITY_MODIFIED_MINUS, orderItem,null);
                            }
                            objects.remove(position);
                            // notifyItemRemoved(position);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });

                    holder.llProduct.setOnClickListener(view -> {
                        try {
                            if (itemClickListenerWithTag != null)
                                itemClickListenerWithTag.onItemClick(position, "view", orderItem,null);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }else {
                    holder.llMain.setVisibility(View.GONE);
                }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return objects.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        TextView tvItemName, tvPrice, tvModifyQty;
        ImageView ivPlus, ivMinus;
        LinearLayout llMain;
        SwipeLayout swipeRevealLayout;
        LinearLayout llEditQty, llProduct;
        LinearLayout llDelete;
        RelativeLayout rlPlusModify, rlMinusModify;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvItemName = itemView.findViewById(R.id.tvItemName);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            llMain = itemView.findViewById(R.id.llMain);
            swipeRevealLayout = itemView.findViewById(R.id.swipeRevealLayout);
            llEditQty = itemView.findViewById(R.id.llEditQty);
            tvModifyQty = itemView.findViewById(R.id.tvModifiedQuantity);
            rlPlusModify = itemView.findViewById(R.id.rlPlusModified);
            rlMinusModify = itemView.findViewById(R.id.rlMinusModified);
            ivPlus = itemView.findViewById(R.id.ivPlusModified);
            ivMinus = itemView.findViewById(R.id.ivMinusModified);
            llDelete = itemView.findViewById(R.id.llDelete);
            llProduct = itemView.findViewById(R.id.llProduct);
        }
    }
}
