package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ubsidi.R;
import com.ubsidi.epos_2021.models.User;

import java.util.ArrayList;

public class SelectedUserAdapter extends ArrayAdapter<User> {

    private Context context;
    private ArrayList<User> users;

    public SelectedUserAdapter(@NonNull Context context, int resource, @NonNull ArrayList<User> objects) {
        super(context, resource, objects);
        this.context = context;
        this.users = objects;
    }

    @Override
    public int getCount() {
        return users.size();
    }

    @Nullable
    @Override
    public User getItem(int position) {
        return users.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());

        View view;
        if (convertView == null) {
            view = layoutInflater.inflate(R.layout.custom_spinner_useritem, parent, false);
        } else {
            view = convertView;
        }

        TextView label = (TextView) view.findViewById(R.id.tvDeposit);
        ImageView icon = (ImageView) view.findViewById(R.id.ivDeposit);
        icon.setVisibility(View.VISIBLE);
        label.setText(users.get(position).username);
        return view;
    }


    @Override
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());
        View view;
        if (convertView == null) {
            view = layoutInflater.inflate(R.layout.custom_spinner_useritem, parent, false);
        } else {
            view = convertView;
        }

        TextView label = (TextView) view.findViewById(R.id.tvDeposit);
        ImageView icon = (ImageView) view.findViewById(R.id.ivDeposit);
        icon.setVisibility(View.GONE);
        label.setText(users.get(position).username);

        return view;
    }

}
