package com.ubsidi.epos_2021.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.OrderSplit;

import java.util.ArrayList;

public class SplitGroupAdapter extends RecyclerView.Adapter<SplitGroupAdapter.ViewHolder> {
    private Activity activity;
    private ArrayList<OrderSplit> orderSplits;
    private RecyclerviewItemClickListener recyclerviewItemClickListener;
    private RadioButton checkedRadio;
    public int selectedSplitId = 0;

    public SplitGroupAdapter(ArrayList<OrderSplit> orderSplits, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.orderSplits = orderSplits;
        this.activity = activity;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public SplitGroupAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_split_group, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull SplitGroupAdapter.ViewHolder holder, int position) {
        try {
            OrderSplit split = orderSplits.get(position);
            holder.rbTitle.setChecked(selectedSplitId == (split._id));

            holder.rbTitle.setText(split.group_name);
            holder.rbTitle.setOnClickListener((view) -> {
                if (selectedSplitId == (split._id)) {

                } else {
                    selectedSplitId = split._id;
                    if (checkedRadio != null) checkedRadio.setChecked(false);
                    checkedRadio = holder.rbTitle;
                    holder.rbTitle.setChecked(true);
                    notifyDataSetChanged();
                    if (recyclerviewItemClickListener != null)
                        recyclerviewItemClickListener.onItemClick(position, split);
                }


            });
            if (CommonFunctions.orderPaymentStatus(split.total, split.paid_amount) == 1) {
                holder.rbTitle.setAlpha(0.4f);
            } else {
                holder.rbTitle.setAlpha(1f);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return orderSplits.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private RadioButton rbTitle;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            rbTitle = itemView.findViewById(R.id.rbTitle);
        }
    }
}
