package com.ubsidi.epos_2021.adapters;

import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;

import java.util.ArrayList;

public class SplitOrderItemsAdapter extends RecyclerView.Adapter<SplitOrderItemsAdapter.ViewHolder> {
    private ArrayList<OrderItem> products;
    private RecyclerviewItemClickListener itemClickListener;


    public SplitOrderItemsAdapter(ArrayList<OrderItem> orderItems, RecyclerviewItemClickListener itemClickListener) {
        this.products = orderItems;
        this.itemClickListener = itemClickListener;
    }

    @NonNull
    @Override
    public SplitOrderItemsAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_split_order_item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull SplitOrderItemsAdapter.ViewHolder holder, int position) {
        try {
            OrderItem orderItem = products.get(position);
            if(orderItem.is_delete){
                holder.tvItemName.setPaintFlags(holder.tvItemName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                holder.tvQuantity.setPaintFlags(holder.tvItemName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                holder.tvPrice.setPaintFlags(holder.tvItemName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
            }else {
                holder.tvItemName.setPaintFlags(0);
                holder.tvQuantity.setPaintFlags(0);
                holder.tvPrice.setPaintFlags(0);
            }
            holder.tvItemName.setText(orderItem.product_name);

            holder.tvQuantity.setText(orderItem.quantity + "x");
            holder.tvPrice.setText(MyApp.currencySymbol + MyApp.df.format(orderItem.sub_total));

            StringBuilder selectedProductAddons = new StringBuilder();
            if (orderItem.order_item_addons != null && orderItem.order_item_addons.size() > 0) {
                for (OrderItemAddon orderItemAddon : orderItem.order_item_addons) {
                    if (selectedProductAddons.length() > 0)
                        selectedProductAddons.append("\n");
                    selectedProductAddons.append(orderItemAddon.addon_name);
                }
            }
            if (orderItem.order_item_ingredients != null && orderItem.order_item_ingredients.size() > 0) {
                for (OrderItemIngredient orderItemIngredient : orderItem.order_item_ingredients) {
                    if (selectedProductAddons.length() > 0)
                        selectedProductAddons.append("\n");
                    if (orderItemIngredient.with) {
                        selectedProductAddons.append("Add ");
                    }
                    if (orderItemIngredient.without) {
                        selectedProductAddons.append("Remove ");
                    }
                    selectedProductAddons.append(orderItemIngredient.quantity).append(" ");
                    selectedProductAddons.append(orderItemIngredient.ingredient_name);
                }
            }
            if (!Validators.isNullOrEmpty(orderItem.special_instruction)) {
                if (selectedProductAddons.length() > 0)
                    selectedProductAddons.append("\n");
                selectedProductAddons.append(orderItem.special_instruction);
            }

            holder.tvCategory.setText(selectedProductAddons.toString());
            if (selectedProductAddons.length() > 0) {
                holder.tvCategory.setVisibility(View.VISIBLE);
            } else {
                holder.tvCategory.setVisibility(View.GONE);
            }
            holder.itemView.setOnClickListener(view -> {
                if(!orderItem.is_delete){
                    itemClickListener.onItemClick(position, orderItem);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return products.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        TextView tvQuantity, tvItemName, tvPrice, tvCategory;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvQuantity = itemView.findViewById(R.id.tvQuantity);
            tvItemName = itemView.findViewById(R.id.tvProduct);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            tvCategory = itemView.findViewById(R.id.tvInfo);

        }
    }
}
