package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewSubAddonItemClickListener;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.ProductAddon;

import java.util.ArrayList;

public class SubAddonAdapter extends RecyclerView.Adapter<SubAddonAdapter.ViewHolder> {
    private final ArrayList<Addon> subAddons;
    private ProductAddon productAddon;
    private final RecyclerviewSubAddonItemClickListener itemClickListener;

    public SubAddonAdapter(ArrayList<Addon> subAddons, RecyclerviewSubAddonItemClickListener itemClickListener) {
        this.subAddons = subAddons;
        this.itemClickListener = itemClickListener;
    }

    public void notifyList(ArrayList<Addon> subAddons, ProductAddon productAddon) {
        this.productAddon = productAddon;
        this.subAddons.clear();
        this.subAddons.addAll(subAddons);
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_subaddon, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        try {
            Addon addon = subAddons.get(position);
            Context context = holder.itemView.getContext();
            holder.tvSubAddon.setText(addon.name);
            holder.tvAddonQty.setText("" + addon.quantity);
            holder.tvPrice.setText(MyApp.currencySymbol + MyApp.df.format(addon.price));
            if (addon.quantity == 0) {
                holder.rlMinusModified.setVisibility(View.GONE);
            } else {
                holder.rlMinusModified.setVisibility(View.VISIBLE);
            }
            if(addon.contain){
                holder.cvSubAddon.setCardBackgroundColor(ContextCompat.getColor(context, R.color.persian_green));
            }else {
                if (Validators.isNullOrEmpty(addon.top_color)) {
                    holder.cvSubAddon.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                    holder.tvSubAddon.setTextColor(ContextCompat.getColor(context, R.color.black));
                    holder.tvPrice.setTextColor(ContextCompat.getColor(context, R.color.black));
                } else {
                    holder.cvSubAddon.setCardBackgroundColor(Color.parseColor(addon.top_color));
                    if (Validators.isNullOrEmpty(addon.bottom_color)) {
                        holder.tvSubAddon.setTextColor(Color.parseColor("#ffffff"));
                        holder.tvPrice.setTextColor(Color.parseColor("#ffffff"));
                    } else {
                        holder.tvSubAddon.setTextColor(Color.parseColor(addon.bottom_color));
                        holder.tvPrice.setTextColor(Color.parseColor(addon.bottom_color));
                    }
                }
            }
            holder.cvSubAddon.setOnClickListener(v -> {
                if (itemClickListener != null) {
                    itemClickListener.onAddAddonClick(position, addon, productAddon);
                }
            });
            holder.rlPlusModified.setOnClickListener(v -> {
                if (itemClickListener != null) {
                    itemClickListener.onAddAddonClick(position, addon, productAddon);
                }
            });
            holder.rlMinusModified.setOnClickListener(v -> {
                if (itemClickListener != null) {
                    itemClickListener.onMinusAddonClick(position, addon, productAddon);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return subAddons.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        private TextView tvSubAddon, tvPrice, tvAddonQty;
        private MaterialCardView cvSubAddon;
        private RelativeLayout rlMinusModified, rlPlusModified;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvSubAddon = itemView.findViewById(R.id.tvSubAddon);
            rlMinusModified = itemView.findViewById(R.id.rlMinusModified);
            rlPlusModified = itemView.findViewById(R.id.rlPlusModified);
            tvAddonQty = itemView.findViewById(R.id.tvAddonQty);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            cvSubAddon = itemView.findViewById(R.id.cvSubAddon);
        }
    }
}
