package com.ubsidi.epos_2021.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Category;

import java.util.ArrayList;

public class SubCategoryAdapter extends RecyclerView.Adapter<SubCategoryAdapter.ViewHolder> {

    private Activity activity;
    private ArrayList<Category> subcategories;
    private RecyclerviewItemClickListener recyclerviewItemClickListener;
    private RadioButton checkedRadio;
    public String selectedSubCategoryId;
    public int itemWidth = 0;

    public SubCategoryAdapter(ArrayList<Category> subcategories, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.subcategories = subcategories;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_category, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull SubCategoryAdapter.ViewHolder holder, int position) {

        try {
            Category category = subcategories.get(position);
            Context context = holder.itemView.getContext();

            if (selectedSubCategoryId != null && selectedSubCategoryId.equalsIgnoreCase(category.id)) {
                holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.white));
                holder.tvName.setBackground(ContextCompat.getDrawable(context, R.drawable.green_shadow_12));
            } else {
                holder.tvName.setBackgroundResource(R.drawable.shadow_12);
                holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.reason_normal_text));
                try {
                    GradientDrawable gd = new GradientDrawable(
                            GradientDrawable.Orientation.TOP_BOTTOM,
                            new int[]{Color.parseColor(category.top_color), Color.parseColor(category.bottom_color)});
                    gd.setCornerRadius(12f);
                    holder.tvName.setBackground(gd);
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (Validators.isNullOrEmpty(category.font_color)) {
                    holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.white));
                } else
                    holder.tvName.setTextColor(Color.parseColor(category.font_color));

            }


            holder.tvName.setText(category.name);
            holder.tvName.setOnClickListener((view) -> {
                selectedSubCategoryId = category.id;
                notifyDataSetChanged();
                if (recyclerviewItemClickListener != null)
                    recyclerviewItemClickListener.onItemClick(position, category);

            });

            if (itemWidth > 0) {
                /*ViewGroup.LayoutParams layoutParams = holder.itemView.getLayoutParams();
                layoutParams.width = itemWidth;
                holder.itemView.setLayoutParams(layoutParams);*/
            } else {
               /* ViewGroup.LayoutParams layoutParams = holder.itemView.getLayoutParams();
                layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
                holder.itemView.setLayoutParams(layoutParams);*/
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return subcategories.size();
    }


    public class ViewHolder extends RecyclerView.ViewHolder {

        private TextView tvName;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);

            tvName = itemView.findViewById(R.id.tvName);
        }
    }
}
