package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;

/**
 * Created by Amrish on 18-06-2021.
 */
public class TableLockingAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<Object> objects;
    TableStatus takingOrderStatus = MyApp.getInstance().findStatus("Taking Order");
    TableStatus vacantOrderStatus = MyApp.getInstance().findStatus("Vacant");
    RecyclerviewItemClickListener recyclerviewItemClickListener;

    public TableLockingAdapter(ArrayList<Object> objects, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.objects = objects;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        if (objects.get(position) instanceof Table) {
            return R.layout.item_table_with_status;
        } else {
            return super.getItemViewType(position);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false);
        return new TableViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_table_with_status) {
                TableViewHolder viewHolder = (TableViewHolder) holder;
                Table table = (Table) objects.get(position);
                Context context = viewHolder.itemView.getContext();
                viewHolder.tvTableNumber.setText(table.number);
                viewHolder.tvFloorNumber.setText(table.floor_name);
                if(table.table_status_id==null) {
                    if (!table.table_status_id.equalsIgnoreCase(vacantOrderStatus.id) && table.locked) {
                        viewHolder.btnFreeTable.setText("Unlock Table");
                        viewHolder.tvFreeTable.setText("Unlock Table");
                    } else {
                        viewHolder.btnFreeTable.setText(table.status);
                        viewHolder.tvFreeTable.setText(table.status);
                    }
                    viewHolder.btnFreeTable.setEnabled(!table.table_status_id.equalsIgnoreCase(vacantOrderStatus.id) && table.locked);
                    if (!table.table_status_id.equalsIgnoreCase(vacantOrderStatus.id) && table.locked) {
                        viewHolder.cvFreeTable.setCardBackgroundColor(ContextCompat.getColor(context, R.color.orders_card_bg_green));
                        viewHolder.cvFreeTable.setClickable(true);
                        viewHolder.cvFreeTable.setEnabled(true);
                    } else {
                        viewHolder.cvFreeTable.setCardBackgroundColor(ContextCompat.getColor(context, R.color.view_disable));
                        viewHolder.cvFreeTable.setClickable(false);
                        viewHolder.cvFreeTable.setEnabled(false);
                    }
                    viewHolder.btnFreeTable.setOnClickListener(view -> {
                        if (recyclerviewItemClickListener != null) {
                            recyclerviewItemClickListener.onItemClick(position, table);
                        }
                    });
                    viewHolder.cvFreeTable.setOnClickListener(view -> {
                        if (recyclerviewItemClickListener != null) {
                            recyclerviewItemClickListener.onItemClick(position, table);
                        }
                    });
                }
                else {
                    viewHolder.btnFreeTable.setText(table.status);
                    viewHolder.tvFreeTable.setText(table.status);
                    if (!table.table_status_id.equalsIgnoreCase(vacantOrderStatus.id) && table.locked) {
                        viewHolder.cvFreeTable.setCardBackgroundColor(ContextCompat.getColor(context, R.color.orders_card_bg_green));
                        viewHolder.cvFreeTable.setClickable(true);
                        viewHolder.cvFreeTable.setEnabled(true);
                    } else {
                        viewHolder.cvFreeTable.setCardBackgroundColor(ContextCompat.getColor(context, R.color.view_disable));
                        viewHolder.cvFreeTable.setClickable(false);
                        viewHolder.cvFreeTable.setEnabled(false);
                    }
                    viewHolder.btnFreeTable.setEnabled(!table.table_status_id.equalsIgnoreCase(vacantOrderStatus.id) && table.locked);
                    viewHolder.btnFreeTable.setOnClickListener(view -> {
                        if (recyclerviewItemClickListener != null) {
                            recyclerviewItemClickListener.onItemClick(position, table);
                        }
                    });
                    viewHolder.cvFreeTable.setOnClickListener(view -> {
                        if (recyclerviewItemClickListener != null) {
                            recyclerviewItemClickListener.onItemClick(position, table);
                        }
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return objects.size();
    }

    private static class TableViewHolder extends RecyclerView.ViewHolder {
        private TextView tvTableNumber, tvFloorNumber, tvFreeTable;
        ;
        private MaterialButton btnFreeTable;
        private MaterialCardView cvFreeTable;

        public TableViewHolder(@NonNull @NotNull View itemView) {
            super(itemView);
            tvTableNumber = itemView.findViewById(R.id.tvTableNumber);
            tvFloorNumber = itemView.findViewById(R.id.tvFloorNumber);
            btnFreeTable = itemView.findViewById(R.id.btnFreeTable);
            cvFreeTable = itemView.findViewById(R.id.cvFreeTable);
            tvFreeTable = itemView.findViewById(R.id.tvFreeTable);
        }
    }
}
