package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ubsidi.R;
import com.ubsidi.epos_2021.models.Table;

import java.util.List;

public class TableWiseFilterAdapter extends ArrayAdapter<Table> {

    private Context context;
    private List<Table> tables;

    public TableWiseFilterAdapter(@NonNull Context context, int resource, @NonNull List<Table> objects) {
        super(context, resource, objects);
        this.context = context;
        this.tables = objects;
    }

    @Override
    public int getCount() {
        return tables.size();
    }

    @Nullable
    @Override
    public Table getItem(int position) {
        return tables.get(position);
    }

    @Override
    public long getItemId(int position){
        return position;
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());

        View view;
        if (convertView == null) {
            view = layoutInflater.inflate(R.layout.custom_spinner_item, parent, false);
        } else {
            view = convertView;
        }
        TextView label = (TextView) view.findViewById(R.id.tvDeposit);
        ImageView icon = (ImageView) view.findViewById(R.id.ivDeposit);
        icon.setVisibility(View.VISIBLE);
        label.setText(tables.get(position).number);

        return view;
    }

    @Override
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());
        View view;
        if (convertView == null) {
            view = layoutInflater.inflate(R.layout.custom_spinner_item, parent, false);
        } else {
            view = convertView;
        }
        TextView label = (TextView) view.findViewById(R.id.tvDeposit);
        ImageView icon = (ImageView) view.findViewById(R.id.ivDeposit);
        icon.setVisibility(View.INVISIBLE);
        label.setText(tables.get(position).number);
        return view;
    }
}
