package com.ubsidi.epos_2021.adapters;

import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListenerWithTag;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.utils.Constants;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class TablesAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<Table> tables;
    private boolean fromTheme2;
    private boolean isTheme3;
    public RecyclerviewItemClickListener itemClickListener, actionClick;
    public RecyclerviewItemClickListenerWithTag homeActionClickListener;
    private List<ViewHolder> lstHolders;
    private List<HomeViewHolder> lstHomeHolders;
    public Handler handler = new Handler();
    public MyApp myApp = MyApp.getInstance();

    TableStatus vacantStatus = myApp.findStatus("Vacant");
    TableStatus mergedStatus = myApp.findStatus("Merged");
    TableStatus takingOrderStatus = myApp.findStatus("Taking Order");
    TableStatus orderTakenStatus = myApp.findStatus("Order Taken");
    TableStatus servedStatus = myApp.findStatus("Served");
    TableStatus servedPaidStatus = myApp.findStatus("Served and paid");
    public Timer tmr = new Timer();
    public Runnable updateTime = new Runnable() {
        @Override
        public void run() {
            synchronized (lstHolders) {
                long currentTime = System.currentTimeMillis();
                for (ViewHolder holder : lstHolders) {
                    holder.updateTimeRemaining(currentTime);
                }
            }
            synchronized (lstHomeHolders) {
                long currentTime = System.currentTimeMillis();
                for (HomeViewHolder holder : lstHomeHolders) {
                    holder.updateTimeRemaining(currentTime);
                }
            }

        }
    };

    private void startUpdateTimer() {
        if(tmr!=null){
            tmr.schedule(new TimerTask() {
                @Override
                public void run() {
                    handler.post(updateTime);
                }
            }, 1000, 1000);
        }
    }

    public TablesAdapter(ArrayList<Table> tables, boolean fromTheme2,boolean isTheme3, RecyclerviewItemClickListener itemClickListener, RecyclerviewItemClickListenerWithTag actionClick) {
        this.isTheme3 = isTheme3;
        this.tables = tables;
        this.itemClickListener = itemClickListener;
        this.homeActionClickListener = actionClick;
        this.fromTheme2 = fromTheme2;
        lstHolders = new ArrayList<>();
        lstHomeHolders = new ArrayList<>();
        startUpdateTimer();
    }


    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == R.layout.item_table) {
            return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else {
            return new HomeViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        try {
            @LayoutRes
            int layoutId = isTheme3 ? R.layout.item_home_tables:R.layout.item_home_tables_theme3;
            if (getItemViewType(position) == R.layout.item_table) {
                ViewHolder holder = (ViewHolder) viewHolder;
                Table table = tables.get(position);

                synchronized (lstHolders) {
                    lstHolders.add(holder);
                }
                holder.setData(table);

                String action = "";
                if (table.status != null && (vacantStatus != null && takingOrderStatus != null && orderTakenStatus != null && servedStatus != null && servedPaidStatus != null && mergedStatus != null)) {

                    if (table.status.equalsIgnoreCase(vacantStatus.status)) {
                        holder.tvTotal.setVisibility(View.INVISIBLE);
                        holder.tvTimeDiff.setVisibility(View.INVISIBLE);
                        holder.cvAction.setVisibility(View.INVISIBLE);
                    } else if (table.status.equalsIgnoreCase(mergedStatus.status)) {
                        holder.tvTotal.setVisibility(View.INVISIBLE);
                        holder.cvAction.setVisibility(View.INVISIBLE);
                    } else if (table.status.equalsIgnoreCase(takingOrderStatus.status)) {
                        //Can cancel order only if permitted.
                        action = "cancel_order";
                        holder.tvAction.setText("Cancel Order");
                        holder.cvAction.setVisibility(View.VISIBLE);
                    } else if (table.status.equalsIgnoreCase(orderTakenStatus.status)) {
                        // Now we can perform served order status
                        action = "serve_order";
                        holder.tvAction.setText("Serve Order");
                        holder.cvAction.setVisibility(View.VISIBLE);
                    } else if (table.status.equalsIgnoreCase(servedStatus.status)) {
                        // No we need pay order button
                        action = "pay_order";
                        holder.tvAction.setText("Pay order");
                        holder.cvAction.setVisibility(View.VISIBLE);
                    } else if (table.status.equalsIgnoreCase(servedPaidStatus.status)) {
                        //Now we can complete or vacant the table
                        action = "complete_order";
                        holder.tvAction.setText("Mark as Vacant");
                        holder.cvAction.setVisibility(View.VISIBLE);
                    }
                    if (!table.status.equalsIgnoreCase(vacantStatus.status.toLowerCase())) {
                        if (table.last_order_total > 0) {
                            holder.tvTotal.setVisibility(View.VISIBLE);
                            holder.tvTotal.setText("Total: " + MyApp.currencySymbol + MyApp.df.format(table.last_order_total));
                        } else {
                            holder.tvTotal.setVisibility(View.INVISIBLE);
                        }
                    } else {
                        holder.tvTotal.setVisibility(View.INVISIBLE);
                    }
                } else {
                    holder.tvTotal.setVisibility(View.INVISIBLE);
                    holder.tvTimeDiff.setVisibility(View.INVISIBLE);
                    holder.cvAction.setVisibility(View.INVISIBLE);
                }

                holder.cvTable.setOnClickListener(v -> {
                    v.setEnabled(false);
                    if (itemClickListener != null) {
                        itemClickListener.onItemClick(position, table);
                    }
                    // prevent rapid clicks
                    new Handler().postDelayed(() -> v.setEnabled(true), 1500);
                });
                String finalAction = action;
                holder.tvAction.setOnClickListener(view -> {
                    if (homeActionClickListener != null)
                        homeActionClickListener.onItemClick(position, finalAction, table);
                });
            } else if (getItemViewType(position) == layoutId) {
                HomeViewHolder holder = (HomeViewHolder) viewHolder;
                Table table = tables.get(position);

                synchronized (lstHomeHolders) {
                    lstHomeHolders.add(holder);
                }
                holder.setData(table);
                holder.cvTable.setOnClickListener(v -> {
                    v.setEnabled(false);
                    if (itemClickListener != null) {
                        itemClickListener.onItemClick(position, table);
                    }
                    // prevent rapid clicks
                    new Handler().postDelayed(() -> v.setEnabled(true), 1500);
                });
                String action = "";
                if (table.status != null) {
                    if (table.status.equalsIgnoreCase(vacantStatus.status)) {
                        holder.ivAction.setVisibility(View.GONE);
                    } else if (table.status.equalsIgnoreCase(takingOrderStatus.status)) {
                        //Can cancel order only if permitted.
                        action = "cancel_order";
                        holder.ivAction.setImageResource(R.drawable.ic_baseline_close_24);
                        holder.ivAction.setVisibility(View.VISIBLE);
                    } else if (table.status.equalsIgnoreCase(orderTakenStatus.status)) {
                        // Now we can perform served order status
                        action = "serve_order";
                        holder.ivAction.setImageResource(R.drawable.icon_serving);
                        holder.ivAction.setVisibility(View.VISIBLE);
                    } else if (table.status.equalsIgnoreCase(servedStatus.status)) {
                        // No we need pay order button
                        action = "pay_order";
                        holder.ivAction.setImageResource(R.drawable.icon_pound_sign);
                        holder.ivAction.setVisibility(View.VISIBLE);
                    } else if (table.status.equalsIgnoreCase(servedPaidStatus.status)) {
                        //Now we can complete or vacant the table
                        action = "complete_order";
                        holder.ivAction.setImageResource(R.drawable.ic_baseline_black_done_24);
                        holder.ivAction.setVisibility(View.VISIBLE);
                    } else if (table.status.equalsIgnoreCase(mergedStatus.status)) {
                        holder.tvTimeDiff.setVisibility(View.GONE);
                        holder.ivAction.setVisibility(View.GONE);
                    }
                }

                String finalAction = action;
                holder.ivAction.setOnClickListener(view -> {
                    if (homeActionClickListener != null)
                        homeActionClickListener.onItemClick(position, finalAction, table);
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemViewType(int position) {
        if (fromTheme2) {
            if(isTheme3){
                return R.layout.item_home_tables;
            }else {
                return R.layout.item_home_tables_theme3;
            }
        } else {
            return R.layout.item_table;
        }
    }

    @Override
    public int getItemCount() {
        return tables.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        LinearLayout llTable;
        TextView tvTableStatus, tvTable, tvAction, tvTotal, tvTimeDiff;
        MaterialCardView cvTable, cvAction;
        Table table;
        MyApp myApp = MyApp.getInstance();
        public TableStatus vacantStatus = myApp.findStatus("Vacant");
        TableStatus mergedStatus = myApp.findStatus("Merged");

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTotal = itemView.findViewById(R.id.tvTotalItemTab);
            llTable = itemView.findViewById(R.id.llTableItem);
            tvTableStatus = itemView.findViewById(R.id.tvTableStatusItemTab);
            cvTable = itemView.findViewById(R.id.cvTablesItemTab);
            tvTable = itemView.findViewById(R.id.tvTableItemTab);
            tvAction = itemView.findViewById(R.id.tvActionItemTab);
            tvTimeDiff = itemView.findViewById(R.id.tvTimerItemTab);
            cvAction = itemView.findViewById(R.id.cvActionItemTab);
        }

        public void setData(Table data) {
            try {
                table = data;
                tvTable.setText(table.number);
                cvAction.setVisibility(View.INVISIBLE);
                tvTotal.setVisibility(View.INVISIBLE);
                tvTimeDiff.setVisibility(View.VISIBLE);


                if (table.table_status != null) {
                    table.table_status_id = table.table_status.id;
                    table.status = table.table_status.status;
                    if (table.table_status.status.equalsIgnoreCase(mergedStatus.status)) {
                        tvTableStatus.setText(table.table_status.status + " With Table " + table.merge_table_id);
                    } else {
                        tvTableStatus.setText(table.table_status.status);
                    }

                    GradientDrawable gd = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM,
                            new int[]{Color.parseColor(table.table_status.top_color),
                                    Color.parseColor(table.table_status.bottom_color)});

                    gd.setCornerRadius(4f);
                    llTable.setBackground(gd);
                    if (table.status.toLowerCase().equalsIgnoreCase("vacant")) {
                        tvTimeDiff.setVisibility(View.INVISIBLE);
                    } else {
                        tvTimeDiff.setVisibility(View.VISIBLE);
                    }
                } else {
                    tvTimeDiff.setVisibility(View.INVISIBLE);
                }
                updateTimeRemaining(System.currentTimeMillis());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void updateTimeRemaining(long currentTime) {
            try {
                if (table._last_order_id > 0 && !Validators.isNullOrEmpty(table.last_order_created_at)) {
                    tvTimeDiff.setText("Ongoing - " + calculatedTime(CommonFunctions.convertToDate(table.last_order_created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU), new Date()));
                } else {
                    tvTimeDiff.setText("");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String calculatedTime(Date created, Date current) {

        if (created == null) return "";
        long diff = current.getTime() - created.getTime();

        long diffSeconds = diff / 1000 % 60;
        long diffMinutes = diff / (60 * 1000) % 60;
        long diffHours = diff / (60 * 60 * 1000);
        int diffInDays = (int) diff / (1000 * 60 * 60 * 24);


        String formate = String.valueOf((diffHours > 9 ? diffHours : "0" + diffHours) + ":" + (diffMinutes > 9 ? diffMinutes : "0" + diffMinutes) + ":" + (diffSeconds > 9 ? diffSeconds : "0" + diffSeconds));
        return formate;
    }

    public class HomeViewHolder extends RecyclerView.ViewHolder {

        private MaterialCardView cvTable;
        private TextView tvTable, tvTimeDiff, tvTableStatus;
        private ImageView ivAction;
        private LinearLayout llTable, llTimeDiff;
        Table table;
        TableStatus mergedStatus = MyApp.getInstance().findStatus("Merged");

        public HomeViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTableStatus = itemView.findViewById(R.id.tvTableStatus);
            llTable = itemView.findViewById(R.id.llTableHome);
            cvTable = itemView.findViewById(R.id.cvTables);
            tvTable = itemView.findViewById(R.id.tvTableHomeTab);
            tvTimeDiff = itemView.findViewById(R.id.tvTimeDiffHomeTab);
            llTimeDiff = itemView.findViewById(R.id.llTimeDiff);
            ivAction = itemView.findViewById(R.id.ivActionHomeTab);
        }

        public void setData(Table data) {
            try {
                table = data;
                tvTable.setText(table.number);

                llTimeDiff.setVisibility(View.VISIBLE);
                tvTableStatus.setVisibility(View.VISIBLE);


                if (table.table_status != null) {
                    if (table.table_status.status.equalsIgnoreCase(mergedStatus.status)) {
                        Table mergedTable = MyApp.getInstance().appDatabase.tableDao().view(table.merge_table_id);
                        tvTableStatus.setText(table.table_status.status + " With " + mergedTable.number);
                    } else {
                        tvTableStatus.setText(table.table_status.status);
                    }
                    table.status = table.table_status.status;
                    table.table_status_id = table.table_status.id;

                    GradientDrawable gd = new GradientDrawable(
                            GradientDrawable.Orientation.TOP_BOTTOM,
                            new int[]{Color.parseColor(table.table_status.top_color), Color.parseColor(table.table_status.bottom_color)});
                    gd.setCornerRadius(4f);
                    llTable.setBackground(gd);
                    if (table.status.toLowerCase().equalsIgnoreCase("vacant")) {
                        llTimeDiff.setVisibility(View.INVISIBLE);
                    } else {
                        llTimeDiff.setVisibility(View.VISIBLE);
                    }
                } else {
                    llTimeDiff.setVisibility(View.INVISIBLE);
                }
                updateTimeRemaining(System.currentTimeMillis());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void updateTimeRemaining(long currentTime) {
            try {
                if (table.status != null && !table.status.equalsIgnoreCase("vacant") && table._last_order_id > 0 && !Validators.isNullOrEmpty(table.last_order_created_at)) {
                    llTimeDiff.setVisibility(View.VISIBLE);
                    tvTimeDiff.setText(calculatedTime(CommonFunctions.convertToDate(table.last_order_created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU), new Date()));
                } else {
                    tvTimeDiff.setText("");
                    llTimeDiff.setVisibility(View.INVISIBLE);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }

    @Override
    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        handler.removeCallbacks(updateTime);
    }

}
