package com.ubsidi.epos_2021.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.ExclusionModel;

import java.util.ArrayList;

public class TopMenuAdapter extends RecyclerView.Adapter<TopMenuAdapter.ViewHolder> {
    private Activity activity;
    private ArrayList<ExclusionModel> menuItems;
    private RecyclerviewItemClickListener itemClickListener;
    private RadioButton checkedRadio;
    public boolean checkable;
    public String selectedId;

    public TopMenuAdapter(Activity activity, ArrayList<ExclusionModel> menuItems, RecyclerviewItemClickListener itemClickListener) {
        this.menuItems = menuItems;
        this.activity = activity;
        this.itemClickListener = itemClickListener;
    }

    @NonNull
    @Override
    public TopMenuAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_top_menu, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull TopMenuAdapter.ViewHolder holder, int position) {
        try {
            ExclusionModel userModel = menuItems.get(position);
            holder.rbMenu.setText(userModel.name);
            holder.tvMenu.setText(userModel.name);
            holder.tvCount.setText(userModel.count + "");
            if (userModel.count > 0) {
                holder.tvCount.setVisibility(View.VISIBLE);
            } else {
                holder.tvCount.setVisibility(View.GONE);
            }
            if (userModel.id.equalsIgnoreCase(selectedId) && userModel.isCheckable) {
                holder.rbMenu.setChecked(true);
                holder.tvMenu.setTextColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.white));
                holder.cvItem.setCardBackgroundColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.persian_green));
            } else {
                holder.rbMenu.setChecked(false);
                holder.tvMenu.setTextColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.dark_grey_color));
                holder.cvItem.setCardBackgroundColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.white));
            }
            holder.rbMenu.setOnClickListener((view) -> {
                if (checkedRadio != null) {
                    checkedRadio.setChecked(false);
                }
                selectedId = userModel.id;
                checkedRadio = (RadioButton) view;
                ((RadioButton) view).setChecked(true);
                if (itemClickListener != null) itemClickListener.onItemClick(position, userModel);
                notifyDataSetChanged();
            });


            holder.cvItem.setOnClickListener(view -> {
                if (userModel.isCheckable) {
                    selectedId = userModel.id;
                }
                if (itemClickListener != null) itemClickListener.onItemClick(position, userModel);
                notifyDataSetChanged();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return menuItems.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvMenu, tvCount;
        private MaterialCardView cvItem;
        RadioButton rbMenu;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            cvItem = itemView.findViewById(R.id.cvItem);
            tvMenu = itemView.findViewById(R.id.tvItemName);
            tvCount = itemView.findViewById(R.id.tvCount);
            rbMenu = itemView.findViewById(R.id.rbMenu);

        }
    }
}
