package com.ubsidi.epos_2021.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.models.PaymentLink;
import com.ubsidi.epos_2021.online.interfaces.RecyclerViewItemClickListener;
import com.ubsidi.epos_2021.utils.Constants;

import java.util.ArrayList;


public class TransactionsAndStatementsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Activity activity;
    private ArrayList<Object> items;
    private RecyclerViewItemClickListener viewItemClickListener, downloadItemClickListener, archiveSelectionClickListener, printClickListener;
    public boolean showCheck = false,isFromQRCode=false;
    private int merchantRole = MyApp.getInstance().myPreferences.getMerchantRole();

    public TransactionsAndStatementsAdapter(Activity activity, ArrayList<Object> items, RecyclerViewItemClickListener viewItemClickListener, RecyclerViewItemClickListener downloadItemClickListener) {
        this.activity = activity;
        this.items = items;
        this.viewItemClickListener = viewItemClickListener;
        this.downloadItemClickListener = downloadItemClickListener;
    }

    public TransactionsAndStatementsAdapter(Activity activity, ArrayList<Object> items, RecyclerViewItemClickListener viewItemClickListener, RecyclerViewItemClickListener downloadItemClickListener, RecyclerViewItemClickListener printClickListener) {
        this.activity = activity;
        this.items = items;
        this.viewItemClickListener = viewItemClickListener;
        this.downloadItemClickListener = downloadItemClickListener;
        this.printClickListener = printClickListener;
    }

    public TransactionsAndStatementsAdapter(Activity activity, ArrayList<Object> items, RecyclerViewItemClickListener archiveSelectionClickListener) {
        this.activity = activity;
        this.items = items;
        this.archiveSelectionClickListener = archiveSelectionClickListener;
    }

    public TransactionsAndStatementsAdapter(boolean isFromQRCode, Activity activity, ArrayList<Object> items, RecyclerViewItemClickListener archiveSelectionClickListener) {
        this.activity = activity;
        this.isFromQRCode = isFromQRCode;
        this.items = items;
        this.archiveSelectionClickListener = archiveSelectionClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        return R.layout.item_payment_link;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false);
        return new PaymentLinksViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (getItemViewType(position) == R.layout.item_payment_link) {
            PaymentLink paymentLink = (PaymentLink) items.get(position);
            PaymentLinksViewHolder viewHolder = (PaymentLinksViewHolder) holder;
            viewHolder.tvAmount.setText(MyApp.currencySymbol + MyApp.df.format(paymentLink.amount));
            viewHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(paymentLink.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd MMM hh:mm a"));
            viewHolder.tvStatus.setText(paymentLink.status);
            viewHolder.tvPhone.setText(paymentLink.phone);
            viewHolder.btnResend.setVisibility(View.GONE);
            if (paymentLink.status.equalsIgnoreCase("failed")) {
                viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_remove_24);
                viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.red));
            } else if (paymentLink.status.equalsIgnoreCase("pending")) {
                viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_access_time_24);
                viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.orders_card_bg_orange));
                viewHolder.btnResend.setVisibility(View.VISIBLE);
            } else {
                viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.persian_green));
                viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_green_done_24);
            }
            viewHolder.btnResend.setOnClickListener(view -> {
                if (archiveSelectionClickListener != null) {
                    archiveSelectionClickListener.onItemClick(position, paymentLink);
                }
            });
            if(isFromQRCode){
                viewHolder.btnResend.setText("Show");
            }
//            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
//            layoutParams.setMargins(CommonFunctions.pxToDp(activity, 16), CommonFunctions.pxToDp(activity, 8), CommonFunctions.pxToDp(activity, 16), CommonFunctions.pxToDp(activity, 8));
//            viewHolder.llMain.setLayoutParams(layoutParams);
//

        }
    }


    @Override
    public int getItemCount() {
        return items.size();
    }

    protected static class PaymentLinksViewHolder extends RecyclerView.ViewHolder {
        private TextView tvStatus, tvDate, tvAmount, tvPhone;
        private MaterialButton btnResend;
        private ImageView ivEntry;
        private LinearLayout llMain;

        public PaymentLinksViewHolder(@NonNull View itemView) {
            super(itemView);
            ivEntry = itemView.findViewById(R.id.ivEntry);
            tvStatus = itemView.findViewById(R.id.tvStatus);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            llMain = itemView.findViewById(R.id.llMainLayout);
            btnResend = itemView.findViewById(R.id.btnResend);
            tvPhone = itemView.findViewById(R.id.tvPhone);

        }
    }
}
