package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewVoucherClickListener;
import com.ubsidi.epos_2021.models.Voucher;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VoucherHistoryAdapter extends RecyclerView.Adapter<VoucherHistoryAdapter.ViewHolder> {

    private ArrayList<Voucher> voucherList;
    private RecyclerviewVoucherClickListener itemClickListener;
    private StringBuffer getDays;
    private StringBuffer getOrderType;

    public VoucherHistoryAdapter(ArrayList<Voucher> voucherList, RecyclerviewVoucherClickListener itemClickListener) {
        this.voucherList = voucherList;
        this.itemClickListener = itemClickListener;
    }

    @NotNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_voucher_history, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        try {
            Voucher voucher = voucherList.get(position);
            getOrderType = new StringBuffer();
            getDays = new StringBuffer();

            if (!Validators.isNullOrEmpty(voucher.customer_name)) {
                holder.tvCustomerName.setText(voucher.customer_name);
            } else {
                holder.tvCustomerName.setText("-");
            }

            if (!Validators.isNullOrEmpty(voucher.customer_mobile)) {
                holder.tvContact.setText(voucher.customer_mobile);
            } else {
                holder.tvContact.setText("-");
            }
            // comment by arbaz as kamal sir asked to change email to code 20-12-2022
            /*if (!Validators.isNullOrEmpty(voucher.customer_email)) {
                holder.tvEmail.setText(voucher.customer_email);
            } else {
                holder.tvEmail.setText("-");
            }*/

            if (!Validators.isNullOrEmpty(voucher.voucher_code)) {
                holder.tvEmail.setText(voucher.voucher_code);
            } else {
                holder.tvEmail.setText("-");
            }

            if (!Validators.isNullOrEmpty(voucher.start_date)) {
                holder.tvStartDate.setText(CommonFunctions.formatUnknownDateTime(voucher.start_date, "yyyy-MM-dd", "dd/MM/yyyy"));
            } else {
                holder.tvStartDate.setText("-");
            }

            if (!Validators.isNullOrEmpty(voucher.end_date)) {
                if (voucher.end_date.contains("203")) {
                    holder.tvEndDate.setText("No Expiry");
                } else {
                    holder.tvEndDate.setText(CommonFunctions.formatUnknownDateTime(voucher.end_date, "yyyy-MM-dd", "dd/MM/yyyy"));
                }
            } else {
                holder.tvEndDate.setText("No Expiry");
            }


            if (!Validators.isNullOrEmpty(voucher.order_type_id)) {
                List<String> orderList = Arrays.asList(voucher.order_type_id.split(","));
                for (String str : orderList) {
                    setOrders(str);
                }
                holder.tvType.setText(getOrderType.toString());
            } else {
                holder.tvType.setText("-");
            }

            if (voucher.voucher_amount != 0) {
                holder.tvAmount.setText(MyApp.getInstance().currencySymbol + MyApp.df.format(voucher.voucher_amount));
            } else {
                holder.tvAmount.setText(" ");
            }

            holder.tvView.setOnClickListener(v -> {
                itemClickListener.onItemClick(position, "view", voucher);
            });

            holder.tvPrint.setOnClickListener(v -> {
                itemClickListener.onItemClick(position, "print", voucher);
            });
            holder.tvCopy.setOnClickListener(v -> {
                itemClickListener.onItemClick(position, "copy", voucher);
            });
            holder.tvDelete.setOnClickListener(v -> {
                itemClickListener.onItemClick(position, "cancel", voucher);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return voucherList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {

        TextView tvCustomerName, tvDelete, tvView, tvEndDate, tvStartDate, tvPrint,tvCopy;
        TextView tvEmail, tvType, tvAmount, tvContact;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvCustomerName = itemView.findViewById(R.id.tvCustomerName);
            tvEmail = itemView.findViewById(R.id.tvEmail);
            tvType = itemView.findViewById(R.id.tvType);
            tvStartDate = itemView.findViewById(R.id.tvStartDate);
            tvEndDate = itemView.findViewById(R.id.tvEndDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvContact = itemView.findViewById(R.id.tvContact);

            tvCopy = itemView.findViewById(R.id.tvCopy);
            tvPrint = itemView.findViewById(R.id.tvPrint);
            tvView = itemView.findViewById(R.id.tvEdit);
            tvDelete = itemView.findViewById(R.id.tvDelete);

        }
    }

    public void setDays(String string) {
        switch (string) {
            case "0":
                getDays.append("Monday, ");
                break;
            case "1":
                getDays.append("Tuesday, ");
                break;
            case "2":
                getDays.append("Wednesday, ");
                break;
            case "3":
                getDays.append("Thursday, ");
                break;
            case "4":
                getDays.append("Friday, ");
                break;
            case "5":
                getDays.append("Saturday, ");
                break;
            case "6":
                getDays.append("Sunday, ");
                break;
        }
    }

    public void setOrders(String string) {
        switch (string) {
            case "1":
                getOrderType.append("Dine In, ");
                break;
            case "2":
                getOrderType.append("Collection, ");
                break;
            case "3":
                getOrderType.append("Delivery, ");
                break;
            case "4":
                getOrderType.append("Bar, ");
                break;
            case "5":
                getOrderType.append("Waiting, ");
                break;
            case "6":
                getOrderType.append("Web Order, ");
                break;
        }
    }

}
