package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.OrderType;

import java.util.ArrayList;

public class VoucherOrderType extends RecyclerView.Adapter<VoucherOrderType.ViewHolder> {

    private ArrayList<OrderType> orderTypeList;
    private RecyclerviewItemClickListener recyclerviewItemClickListener;

    public VoucherOrderType(ArrayList<OrderType> orderTypeList, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.orderTypeList = orderTypeList;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.exclusive_item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull VoucherOrderType.ViewHolder holder, int position) {
        try {
            OrderType orderType = orderTypeList.get(position);
            holder.chkExclusive.setText(orderType.type);

            holder.chkExclusive.setChecked(orderType.isChecked);

            holder.chkExclusive.setOnClickListener(v -> {
                if (recyclerviewItemClickListener != null) {
                    recyclerviewItemClickListener.onItemClick(position, orderType);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return orderTypeList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private CheckBox chkExclusive;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            chkExclusive = itemView.findViewById(R.id.chkExclusive);
        }
    }
}
