package com.ubsidi.epos_2021.base;

import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.NetworkWatcher;

public class BaseActivity extends AppCompatActivity {
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        manageIntents();
        setXML();

        initViews();

       try {
            new NetworkWatcher(this).observe(this, aBoolean -> {
                if (!aBoolean) {
                    changeStatusBarColor(Color.RED);
                } else {
                    changeStatusBarColor(Color.BLACK);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    protected void manageIntents() {
        Bundle bundle = getIntent().getExtras();
        if (bundle != null) {
            for (String key : bundle.keySet()) {
                LogUtils.w("##EXTRAS##", key + " : " + (bundle.get(key) != null ? bundle.get(key) : "NULL"));
            }
        }
    }

    protected void setXML() {

    }

    protected void initViews() {

    }

    @Override
    public boolean onSupportNavigateUp() {
        onBackPressed();
        return super.onSupportNavigateUp();
    }

    protected void changeStatusBarColor(int color) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(color);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        /*if (!myApp.isConnected(this)) {
            changeStatusBarColor(Color.RED);
        } else {
            changeStatusBarColor(Color.BLACK);
        }*/
    }
}
