package com.ubsidi.epos_2021.base;

import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.LogUtils;

public class BaseFragment extends Fragment {
    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public AppDatabase appDatabase = myApp.appDatabase;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        manageIntents();
    }

    protected void manageIntents() {
        try {
            Bundle bundle = getArguments();
            if (bundle != null) {
                for (String key : bundle.keySet()) {
                    LogUtils.w("##EXTRAS##", key + " : " + (bundle.get(key) != null ? bundle.get(key) : "NULL"));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void changeStatusBarColor(int color) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = getActivity().getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(color);
        }
    }

}
