package com.ubsidi.epos_2021.callerid;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.util.Log;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.google.gson.Gson;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Customer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CALLERID {
    private static CALLERID callerid = new CALLERID();
    CidEasyBridge hBridge;
    Context context;
    LocalBroadcastManager localBroadcastManager;
    MyApp myApp = MyApp.getInstance();

    public static CALLERID getInstance() {
        return callerid;
    }

    int count = 1;

    public void ConnectCallerId(Context context) {
        try {
            this.context = context;
            hBridge = new CidEasyBridge(context);
            localBroadcastManager = LocalBroadcastManager.getInstance(context);

            hBridge.setCidEasyBridgeListener(new CidEasyBridge.CidEasyBridgeListener() {
                @Override
                public void onDeviceArrival() {
                    Log.d("CID BRIDGE", "DEVICE ARRIVAL");
                }

                @Override
                public void onDeviceRemove() {
                    Log.d("CID BRIDGE", "DEVICE REMOVE");
                }

                @Override
                public void onCliReceived(char thePort, String theDateTime, String theCallerId) {
                    myApp.notifyCallReceived(context, new Intent("log").putExtra("log", "Number " + count + " event time " + CommonFunctions.getCurrentTimeFormatted("hh:mm ss a")));
                    count++;
                    try {
                        String onlyNumber = getOnlyDigits(theCallerId);
                        if (onlyNumber.length() > 8) {
                            if (myApp.myPreferences.getLoggedInUser() != null)
                                saveCallerid(onlyNumber);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    //TextView1.setText("P:"+thePort+" DT:"+theDateTime+" CID:"+theCallerId+"\r\n"+TextView1.getText().toString());
                }
            });
            if (hBridge.OpenDevice()) {
                hBridge.StartReadingThread();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public CALLERID() {

    }

    public static String getOnlyDigits(String s) {
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(s);
        String number = matcher.replaceAll("");
        return number;
    }

    private void saveCallerid(String number) {
        new SaveCallerIdAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, number);
    }

    class SaveCallerIdAsyncTask extends AsyncTask<String, String, CallLogs> {

        @Override
        protected CallLogs doInBackground(String... strings) {
            String number = strings[0];
            Customer dbCustomer = myApp.appDatabase.customerDao().find(number);
            CallLogs callLogs = new CallLogs();
            if (dbCustomer != null) {
                callLogs.customer_id = dbCustomer.id;
                callLogs.customer_name = dbCustomer.name;
                callLogs.customer = dbCustomer;
            } else {
                dbCustomer = new Customer();
                dbCustomer.mobile = number;
                callLogs.customer = dbCustomer;
            }
            callLogs.number = number;
            callLogs.device_id = myApp.myPreferences.getRegisteredDevice().id;
            callLogs.status = "pending";
            int id = (int) myApp.appDatabase.calllogDao().insert(callLogs);
            callLogs._id = id;
            return callLogs;
        }

        @Override
        protected void onPostExecute(CallLogs s) {
            super.onPostExecute(s);
            myApp.notifyCallReceived(context, new Intent("call_received").putExtra("calllogs", new Gson().toJson(s)));
        }
    }
}