package com.ubsidi.epos_2021.callerid;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;

import java.util.HashMap;
import java.util.Iterator;

public class CidEasyBridge {
    private Context _context;

    private byte[] ackBytes = {'A', 'C', 'K', 13, 10};
    private byte[] dckBytes = {'D', 'C', 'K', 13, 10};
    private byte[] nakBytes = {'N', 'A', 'K', 13, 10};

    private static final String ACTION_USB_PERMISSION = "com.ubsidi.USB_PERMISSION";

    private Object _locker = new Object();
    private Thread _readingThread = null;
    private String _devicePath;

    private UsbManager _usbManager;
    private UsbDevice _usbDevice;

    private char sPort = 0;
    private String sDateTime = "";
    private String sNumber = "";
    private String sOther = "";

    private char thePort = 0;
    private String theDateTime = "";
    private String theCallerId = "";


    public interface CidEasyBridgeListener {
        public void onDeviceArrival();

        public void onDeviceRemove();

        public void onCliReceived(char thePort, String theDateTime, String theCallerId);
    }

    private CidEasyBridgeListener listener;

    public CidEasyBridge(Context context) {
        _context = context;
        this.listener = null;
    }

    private void Log(String message) {
        Log.d("CID Easy Bridge ", message);
    }

    public void setCidEasyBridgeListener(CidEasyBridgeListener listener) {
        this.listener = listener;
    }

    public boolean OpenDevice() {
        try {
            _usbManager = (UsbManager) _context.getSystemService(Context.USB_SERVICE);
            HashMap<String, UsbDevice> deviceList = _usbManager.getDeviceList();

            Iterator<UsbDevice> deviceIterator = deviceList.values().iterator();
            _usbDevice = null;

            while (deviceIterator.hasNext()) {
                UsbDevice device = deviceIterator.next();
                if (device.getProductId() == 1 && device.getVendorId() == 0x1234) {
                    _usbDevice = device;
                    _devicePath = _usbDevice.getDeviceName();
                    if (listener != null) listener.onDeviceArrival();
                }
            }

            if (_usbDevice == null) {
                if (listener != null) listener.onDeviceRemove();
                return false;
            }

            PendingIntent mPermissionIntent = PendingIntent.getBroadcast(_context, 0, new Intent(ACTION_USB_PERMISSION), PendingIntent.FLAG_MUTABLE);
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            _context.registerReceiver(mUsbReceiver, filter);

            _usbManager.requestPermission(_usbDevice, mPermissionIntent);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void CloseTheDevice() {
        StopReadingThread();
    }

    public void StartReadingThread() {
        if (_readingThread == null) {
            _readingThread = new Thread(readerReceiver);
            _readingThread.start();
        } else {
        }
    }

    @SuppressWarnings("deprecation")
    public void StopReadingThread() {
        if (_readingThread != null) {
            _readingThread.stop();
            _readingThread = null;
        } else {
        }
    }

    public boolean WriteData(byte[] bytes) {
        try {
            synchronized (_locker) {
                UsbInterface writeIntf = _usbDevice.getInterface(0);
                UsbEndpoint writeEp = writeIntf.getEndpoint(1);
                UsbDeviceConnection writeConnection = _usbManager.openDevice(_usbDevice);

                writeConnection.claimInterface(writeIntf, true);

                int r = writeConnection.bulkTransfer(writeEp, bytes, bytes.length, 0);
                if (r != -1) {
                    //Log("DATA SENDED");
                } else {
                    //Log("NO ACK");
                }

                writeConnection.releaseInterface(writeIntf);
                writeConnection.close();
            }

        } catch (NullPointerException e) {
            Log("Error happend while writing. Could not connect to the device or interface is busy?");
            Log(Log.getStackTraceString(e));
            return false;
        }
        return true;
    }


    private Runnable readerReceiver = new Runnable() {
        public void run() {
            try {
                if (_usbDevice == null) {
                    Log("No device to read from");
                    return;
                }

                UsbEndpoint readEp;
                UsbDeviceConnection readConnection = null;
                UsbInterface readIntf = null;
                boolean readerStartedMsgWasShown = false;

                while (true) {
                    synchronized (_locker) {
                        try {
                            if (_usbDevice == null) {
                                OpenDevice();
                                Log("No device. Recheking in 10 sec...");

                                Sleep(10000);
                                continue;
                            }

                            readIntf = _usbDevice.getInterface(0);
                            readEp = readIntf.getEndpoint(0);
                            if (!_usbManager.getDeviceList().containsKey(_devicePath)) {
                                Log("Failed to connect to the device. Retrying to acquire it.");
                                OpenDevice();
                                if (!_usbManager.getDeviceList().containsKey(_devicePath)) {
                                    Log("No device. Recheking in 10 sec...");

                                    Sleep(10000);
                                    continue;
                                }
                            }

                            try {

                                readConnection = _usbManager.openDevice(_usbDevice);

                                if (readConnection == null) {
                                    Log("Cannot start reader because the user didn't gave me permissions or the device is not present. Retrying in 2 sec...");
                                    Sleep(2000);
                                    continue;
                                }

                                readConnection.claimInterface(readIntf, true);
                            } catch (SecurityException e) {
                                Log("Cannot start reader because the user didn't gave me permissions. Retrying in 2 sec...");

                                Sleep(2000);
                                continue;
                            }

                            if (!readerStartedMsgWasShown) {
                                Log("!!! Reader was started !!!");
                                readerStartedMsgWasShown = true;
                            }

                            int packetSize = readEp.getMaxPacketSize();
                            byte[] bytes = new byte[packetSize];
                            int r = readConnection.bulkTransfer(readEp, bytes, packetSize, 50);
                            if (r >= 0) {
                                byte[] trancatedBytes = new byte[r];

                                int i = 0;
                                for (byte b : bytes) {
                                    trancatedBytes[i] = b;
                                    i++;
                                }

                                AnalyzePackage(bytes);
                            }

                            readConnection.releaseInterface(readIntf);
                            readConnection.close();
                        } catch (NullPointerException e) {
                            Log("Error happened while reading. No device or the connection is busy");
                            Log(Log.getStackTraceString(e));
                        } catch (ThreadDeath e) {
                            if (readConnection != null) {
                                readConnection.releaseInterface(readIntf);
                                readConnection.close();
                            }

                            throw e;
                        }
                    }

                    Sleep(10);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private void Sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver() {

        public void onReceive(Context context, Intent intent) {
            try {
                String action = intent.getAction();
                if (ACTION_USB_PERMISSION.equals(action)) {
                    synchronized (this) {
                        UsbDevice device = (UsbDevice) intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);

                        if (intent.getBooleanExtra(UsbManager.EXTRA_PERMISSION_GRANTED, false)) {
                            if (device != null) {
                            }
                        } else {
                            Log("permission denied for the device " + device);
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };


    private String composeString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            if (b > 0) {
                char c = (char) b;
                builder.append(c);
            }
        }
        String strPackage = builder.toString();
        return strPackage;
    }

    private void AnalyzePackage(byte[] bytes) {
        try {
            String strPackage = composeString(bytes);

            if (strPackage.contains("ENQ")) {
                WriteData(ackBytes);
            } else {
                if (strPackage.contains("ETB")) {
                    WriteData(ackBytes);
                } else {
                    if (TestCliPackage(bytes)) {
                        WriteData(dckBytes);
                    } else {
                        WriteData(nakBytes);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean TestCliPackage(byte[] Package) {
        char pPort = (char) Package[0];
        int pType = Math.abs((int) Package[1]);
        int pLen = Math.abs((int) Package[2]);

        int InvalidCharIndex = 0;
        byte loopAgain = 2;
        boolean tacp = false;

        String rawPackage = "";
        try {
            for (int i = 0; i < pLen + 5; i++) {
                rawPackage = rawPackage + "-" + (Package[i] & 0xFF);
            }
            Log("RAW CLI PACKAGE : " + rawPackage);

            //Package[22] = 'z';
            //Package[12] = 'z';

            if ((pPort >= 'A') && (pPort <= 'D')) {
                if (pLen < 65) {
                    do {
                        loopAgain--;
                        if (pType == 0x80) {
                            InvalidCharIndex = AnalyzeMDMF(Package);
                        }
                        if (pType == 0x04) {
                            InvalidCharIndex = AnalyzeSDMF(Package);
                        }
                        tacp = TestAndCorrectPackage(InvalidCharIndex, Package);

                    } while ((InvalidCharIndex != 0) && (loopAgain > 0));

                    CLI_Received((char) sPort, sDateTime, sNumber);
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.e("CALLER_ID", "" + e);
        }


        //Log("Invalid Char Index : "+InvalidCharIndex);
        return true;
    }

    private boolean TestAndCorrectPackage(int invalidCharIndex, byte[] inputReport) {
        byte theChar = 48;
        boolean rtn = false;

        if ((invalidCharIndex > 0) && (invalidCharIndex < 64)) {
            //Log("--------------------------->>>>"+inputReport[invalidCharIndex]);
            while (theChar < 58) {
                inputReport[invalidCharIndex] = theChar;
                if (Test_Check_Digit(inputReport)) theChar = 99;
                theChar++;
                rtn = true;
            }
        }

        return rtn;
    }


    private boolean Test_Check_Digit(byte[] inputReport) {
        byte pDigit = 0;
        byte sayaca = 0;
        int pckLen = 0;

        pckLen = inputReport[2] + 4;
        //Log("(1)--------------------------->>>>"+pckLen);
        for (sayaca = 1; sayaca < pckLen; sayaca++) {
            pDigit = (byte) (pDigit + inputReport[sayaca]);
        }

        pDigit = (byte) (0x100 - pDigit);

        return pDigit == inputReport[pckLen];
    }

    private int AnalyzeMDMF(byte[] Package) {
        int packlength = 0;
        int datalength = 0;
        int Sayaca;

        int invalidChar = 0;
        int icCount = 0;
        char theChar = 0;

        packlength = Package[2] + 4;
        sPort = (char) Package[0];
        sNumber = "";
        sDateTime = "";
        sOther = "";

        if (packlength > Package.length) {
            packlength = Package.length;
        }

        if (packlength > 0) {
            Sayaca = 3;
            datalength = 0;
            while (Sayaca < Package.length) {

                if (Package[Sayaca] == 1) // Date Field
                {
                    Sayaca++;
                    if (Sayaca < packlength - 1) {
                        datalength = Package[Sayaca];
                        if (datalength != 8) datalength = 8;
                        if (datalength == 8) {
                            while ((datalength > 0) && (datalength < packlength)) {
                                Sayaca++;
                                theChar = (char) Package[Sayaca];
                                if ((theChar > '9') || (theChar < '0')) {
                                    invalidChar = (icCount * 10000) + Sayaca;
                                    icCount++;
                                }
                                sDateTime = sDateTime + theChar;
                                datalength--;
                            }
                        }
                    }
                }

                if (Package[Sayaca] == 2)  // Number Field
                {
                    Sayaca++;
                    if (Sayaca < packlength - 1) {
                        datalength = Package[Sayaca];
                        if (datalength > (packlength - Sayaca - 1))
                            datalength = (packlength - Sayaca - 1);
                        while ((datalength > 0) && (datalength < packlength)) {
                            Sayaca++;
                            theChar = (char) Package[Sayaca];
                            if ((theChar > '9') || (theChar < '0')) {
                                invalidChar = (icCount * 10000) + Sayaca;
                                icCount++;
                            }
                            sNumber = sNumber + theChar;
                            datalength--;
                        }
                    }
                }

                if (Package[Sayaca] == 3)  // Other Fields
                {
                    Sayaca++;
                    if (Sayaca < packlength - 1) {
                        datalength = Package[Sayaca];
                        while ((datalength > 0) && (datalength < packlength)) {
                            Sayaca++;
                            theChar = (char) Package[Sayaca];
                            if ((theChar > '9') || (theChar < '0')) {
                                invalidChar = (icCount * 10000) + Sayaca;
                                icCount++;
                            }
                            sOther = sOther + theChar;
                            datalength--;
                        }
                    }
                }
                Sayaca++;
            }

        }
        return invalidChar;
    }

    private int AnalyzeSDMF(byte[] Package) {
        int packlength = 0;
        int datalength = 0;
        int Sayaca;

        int invalidChar = 0;
        int icCount = 0;
        char theChar = 0;

        packlength = Package[2] + 4;
        sPort = (char) Package[0];
        sNumber = "";
        sDateTime = "";
        sOther = "";

        for (Sayaca = 3; Sayaca <= packlength - 2; Sayaca++) {
            if (Sayaca < Package.length) {
                theChar = (char) Package[Sayaca];
                if ((theChar > '9') || (theChar < '0')) {
                    invalidChar = (icCount * 10000) + Sayaca;
                    icCount++;
                }
                if (Sayaca < 11) {
                    sDateTime = sDateTime + (char) Package[Sayaca];
                } else {
                    sNumber = sNumber + theChar;
                }
            }
        }

        return invalidChar;
    }

    private void CLI_Received(char Port, String DateTime, String CallerId) {
        runThread(Port, DateTime, CallerId);
        Log("Port : " + Port + " ---- Date/Time:" + DateTime + " ---- Caller Id:" + CallerId);
    }

    private void runThread(char Port, String DateTime, String CallerId) {
        thePort = Port;
        theDateTime = DateTime;
        theCallerId = CallerId;

        if (listener != null) listener.onCliReceived(thePort, theDateTime, theCallerId);
    }

}