package com.ubsidi.epos_2021.callerid;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.google.gson.Gson;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.storageutils.MyPreferences;

import java.util.HashMap;
import java.util.Iterator;

public class NewCidEasyBridge {
    private static final String ACTION_USB_PERMISSION = "com.ubsidi.USB_PERMISSION";
    private static final long DEVICE_VENDOR_ID = 4660;
    private static final long DEVICE_PRODUCT_ID = 1;

    private HashMap<UsbDevice, UsbDataBinder> mHashMap = new HashMap<UsbDevice, UsbDataBinder>();
    private UsbManager mUsbManager;
    private PendingIntent mPermissionIntent;
    UsbDevice theDevice = null;

    private AppCompatActivity context;
    private MyApp myApp = MyApp.getInstance();
    private TextView textView;
    public MyPreferences myPreferences = myApp.myPreferences;
    int initCount = 0;

    public NewCidEasyBridge(AppCompatActivity _ctx) {
        context = _ctx;
        mUsbManager = (UsbManager) context.getSystemService(Context.USB_SERVICE);
        Connect();
        initCount++;
        //textView = (TextView) ((HomeActivity) ctx).findViewById(R.id.textView);
    }

    protected void Connect() {
        IntentFilter filter = new IntentFilter(UsbManager.ACTION_USB_DEVICE_ATTACHED);
        context.registerReceiver(mUsbAttachReceiver, filter);
        filter = new IntentFilter(UsbManager.ACTION_USB_DEVICE_DETACHED);
        context.registerReceiver(mUsbDetachReceiver, filter);

        mPermissionIntent = PendingIntent.getBroadcast(context, 0, new Intent(ACTION_USB_PERMISSION), PendingIntent.FLAG_MUTABLE);
        filter = new IntentFilter(ACTION_USB_PERMISSION);
        context.registerReceiver(mUsbReceiver, filter);

        traceUsbDevices();
    }

    protected void Disconnect() {
        if (theDevice != null) {
            UsbDataBinder binder = mHashMap.get(theDevice);
            if (binder != null) {
                binder.onDestroy();
            }
        }

        context.unregisterReceiver(mUsbDetachReceiver);
        context.unregisterReceiver(mUsbAttachReceiver);
        context.unregisterReceiver(mUsbReceiver);
    }

    protected void Reconnect() {
        if (theDevice != null) {
            UsbDataBinder binder = mHashMap.get(theDevice);
            if (binder != null) {
                binder.onDestroy();
                mHashMap.remove(theDevice);

                Sleep(1000);

                mUsbManager.requestPermission(theDevice, mPermissionIntent);

                context.runOnUiThread(new Runnable() {
                    public void run() {
                        //textView.append("**** RECONNECT ****");
                        //Toast.makeText((HomeActivity) ctx,"**** RECONNECT ****", Toast.LENGTH_SHORT).show();
                    }
                });
            }
        }
    }

    BroadcastReceiver mUsbDetachReceiver = new BroadcastReceiver() {
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();

            if (UsbManager.ACTION_USB_DEVICE_DETACHED.equals(action)) {
                UsbDevice device = (UsbDevice) intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
                if (device != null) {
                    UsbDataBinder binder = mHashMap.get(device);
                    if (binder != null) {
                        theDevice = null;
                        binder.onDestroy();
                        mHashMap.remove(device);

                        Log.d("CidEasyBridge", "DEVICE DETACHED ");
                    }
                }
            }
        }
    };

    BroadcastReceiver mUsbAttachReceiver = new BroadcastReceiver() {
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();

            if (UsbManager.ACTION_USB_DEVICE_ATTACHED.equals(action)) {
                traceUsbDevices();
                Log.d("CidEasyBridge", "DEVICE ATTACHED ");
            }
        }
    };

    private void traceUsbDevices() {
        HashMap<String, UsbDevice> deviceList = mUsbManager.getDeviceList();
        Iterator<UsbDevice> deviceIterator = deviceList.values().iterator();
        while (deviceIterator.hasNext()) {
            UsbDevice device = deviceIterator.next();
            if ((device.getVendorId() == DEVICE_VENDOR_ID) && ((device.getProductId() == DEVICE_PRODUCT_ID))) {
                mUsbManager.requestPermission(device, mPermissionIntent);
            }
        }
    }

    UsbDataBinder binder;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver() {

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (ACTION_USB_PERMISSION.equals(action)) {
                synchronized (this) {
                    UsbDevice device = (UsbDevice) intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
                    if (intent.getBooleanExtra(UsbManager.EXTRA_PERMISSION_GRANTED, false)) {
                        if (device != null) {
                            theDevice = device;
                            if (binder == null)
                                binder = new UsbDataBinder(mUsbManager, device);
                            mHashMap.put(device, binder);

                            binder.StartCidEasyThread(NewCidEasyBridge.this.context);

                            binder.setBinderListener(new UsbDataBinder.binderListener() {
                                @Override
                                public void onBinderLineEvent(char thePort, String theEvent) {
                                    final String sMessage = "LINE EVENT " + theEvent + " ON PORT : " + thePort + "\r\n";
                                }

                                @Override
                                public void onBinderCliReceived(char thePort, String theDateTime, String theCaller, String theCallee) {
                                    myApp.notifyCallReceived(context, new Intent("log").putExtra("log", "InitCount : " + initCount + " event time " + CommonFunctions.getCurrentTimeFormatted("hh:mm ss a")));

                                    if (myPreferences.getCallerIdEnableStatus())
                                        saveCallerid(theCaller);
                                }

                            });
                        }
                    }
                }
            }
        }
    };

    private void Sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void saveCallerid(String number) {
        new SaveCallerIdAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, number);
    }

    class SaveCallerIdAsyncTask extends AsyncTask<String, String, CallLogs> {

        @Override
        protected CallLogs doInBackground(String... strings) {
            String number = strings[0];
            Customer dbCustomer = myApp.appDatabase.customerDao().find(number);
            CallLogs callLogs = new CallLogs();
            if (dbCustomer != null) {
                callLogs.customer_id = dbCustomer.id;
                callLogs.customer_name = dbCustomer.name;
            } else {
                dbCustomer = new Customer();
                dbCustomer.mobile = number;
            }
            callLogs.customer = dbCustomer;
            callLogs.number = number;
            callLogs.device_id = myPreferences.getRegisteredDevice().id;
            callLogs.status = "pending";
            callLogs._id = (int) myApp.appDatabase.calllogDao().insert(callLogs);
            return callLogs;
        }

        @Override
        protected void onPostExecute(CallLogs s) {
            super.onPostExecute(s);
            if (myPreferences.getCallerIdEnableStatus())
                myApp.notifyCallReceived(context, new Intent("call_received").putExtra("calllogs", new Gson().toJson(s)));
        }
    }
}
