package com.ubsidi.epos_2021.callerid;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.AsyncTask;
import android.util.Log;


public class UsbDataBinder {

	private static final boolean enableCheckDigitControl  = true;

	private static class AsyncReader extends AsyncTask<String, String, String> {

		public String doInBackground(String... params) {
			Log.d("CidEasyBridge","BEGIN READ... ");
			int r = mConnection.bulkTransfer(rEndpoint, bytes, bytes.length, TIMEOUT);
			if (r >= 0) {
				int i = 0;
				for (byte b : bytes) {
					trancatedBytes[i] = bytes[i];
					i++;
				}
			}
			return null;
		}

		public void onPostExecute(String result) {
			Log.d("CidEasyBridge","ON POST EXECUTE.");
			analyzePackage(trancatedBytes);
			_standby = false;
			_sleept = 50;
		}
	}

	private static class AsyncWriter extends AsyncTask<String, String, String> {

		protected String doInBackground(String... Answer) {
			byte[] bytes = Answer[0].getBytes();
			if (mConnection.claimInterface(mIntf, forceClaim)) {
				mConnection.bulkTransfer(wEndpoint, bytes, bytes.length, TIMEOUT); //do in another thread
			}
			return null;
		}

		protected void onPostExecute() {
		}
	}

	private static final String ackAnswer = "ACK\r\n";
	private static final String dckAnswer = "DCK\r\n";
	private static final String nakAnswer = "NAK\r\n";

	private static byte[] bytes = new byte[64];
	private static byte[] trancatedBytes = new byte[64];
	private static int TIMEOUT = 0;
	private static boolean forceClaim = true;
	private static Boolean _standby = false;
	private static int _sleept = 1000;

	private UsbDevice mDevice;
	private UsbManager mUsbManager;
	private static UsbDeviceConnection mConnection;
	private static UsbInterface mIntf;
	private static UsbEndpoint rEndpoint;
	private static UsbEndpoint wEndpoint;

	private Thread _readingThread = null;
	private boolean runReadThread = false;

	private Context ctx;

	private static char sPort = 0;
	private static String sDateTime = "";
	private static String sCaller = "";
	private static String sCallee = "";
	private static String sOther = "";

	private static char thePort = 0;
	private static String theDateTime = "";
	private static String theCallerId = "";


	public interface binderListener {
		public void onBinderLineEvent(char thePort, String theEvent);
		public void onBinderCliReceived(char thePort, String theDateTime, String theCaller, String theCallee);
	}

	private static binderListener listener;

	public void setBinderListener(binderListener listener) {
		this.listener = listener;
	}

	public UsbDataBinder(UsbManager manager, UsbDevice device) {
		// TODO Auto-generated constructor stub
		mUsbManager = manager;
		mDevice = device;
		mIntf = mDevice.getInterface(0);
		rEndpoint = mIntf.getEndpoint(0);
		wEndpoint = mIntf.getEndpoint(1);
		mConnection = mUsbManager.openDevice(mDevice);
	}

	public void onDestroy() {
		if (mConnection != null) {
			runReadThread = false;
			mConnection.releaseInterface(mIntf);
			mConnection.close();
			mConnection = null;
		}
	}

	public void StartCidEasyThread(Context _ctx) {
		ctx = _ctx;
		this.listener = null;
		_standby = false;

		if (_readingThread == null) {
			_readingThread = new Thread(readerReceiver);
			runReadThread = true;
			_readingThread.start();
		}
	}

	private Runnable readerReceiver = new Runnable() {
		public void run() {
			while (runReadThread) {
				try {
					if (!_standby) {
						_standby = true;
						if (mConnection.claimInterface(mIntf, forceClaim)) {
							new AsyncReader().execute(new String[]{""});
						} else {
							Log.d("CidEasyBridge", "CANT CLAIM USB");
						}
					}
				} catch (Exception e) {
					Log.d("CEBridge - readReceiver",Log.getStackTraceString(e));
				}
			}

			Sleep(_sleept);
		}
	};

	private static void sendData(final String sendString) {
		try {
			Log.d("CidEasyBridge", "ANSWER -->  "+sendString);
			new AsyncWriter().execute(new String[]{sendString});
		} catch (Exception e) {
			Log.d("CEBridge - sendData",Log.getStackTraceString(e));
		}
	}

	private static void analyzePackage(byte[] bytes) {
		try {
			final String strPackage = composeString(bytes);
			Log.d("CidEasyBridge","RECEIVE  <-- "+strPackage);

			if (strPackage.contains("ENQ") ) {
				sendData(ackAnswer);
			}
			else {
				if (strPackage.contains("ETB")) {
					sendData(ackAnswer);
				} else {
					if (strPackage.contains("STA")) {
						echoLineEvent(strPackage);
					} else {
						if (testCliPackage(bytes)) {
							sendData(dckAnswer);
						} else {
							sendData(nakAnswer);
						}
					}
				}
			}
		} catch (Exception e) {
			Log.d("CEBridge - analyzePackage",Log.getStackTraceString(e));
		}
	}

	private static void echoLineEvent(String strPackage) {
		try {
			char thePort = strPackage.substring(4,5).charAt(0);
			String theEvent = strPackage.substring(6,strPackage.length()-2);

			if (listener != null) listener.onBinderLineEvent(thePort, theEvent);
		} catch (Exception e) {
			Log.d("CEBridge - echoLineEvent",Log.getStackTraceString(e));
		}
	}

	private static boolean testCliPackage(byte[] Package) {
		try {
			char pPort = (char) Package[0];
			int pType = Math.abs((int) Package[1]);
			int pLen  = Math.abs((int) Package[2]);

			if ((pLen < 65) && (pPort >= 'A') && (pPort <='S')) {
				if (pType == 0x80) { parseMDMF(Package); }
				if (pType == 0x04) { parseSDMF(Package); }

				if (!enableCheckDigitControl || testCheckDigit(Package)) cliReceived((char) sPort, sDateTime, sCaller, sCallee);
			}
		} catch (Exception e) {
			Log.d("CEBridge - testCliPackage",Log.getStackTraceString(e));
		}

		return true;
	}

	private static boolean testCheckDigit(byte[] inputReport)
	{
		int pLen = 0;
		int cDigit = 123;
		int pDigit = 0;

		try {
			pLen = inputReport[2] + 3;
			cDigit = inputReport[pLen] & 255;
			for (int i=1;i<pLen;i++) pDigit = (pDigit + Math.abs((int) inputReport[i] & 255)) & 255;
			pDigit = Math.abs((int) (0x100 - pDigit)) & 255;
		} catch (Exception e) {
			Log.d("CEBridge - testCheckDigit",Log.getStackTraceString(e));
		}

		return pDigit == cDigit;
	}

	private static void parseMDMF(byte[] Package) {
		int packlength = 0;
		int datalength = 0;
		int Sayaca;
		char theChar = 0;

		try {
			packlength = Package[2] + 4;
			sPort = (char) Package[0];
			sCaller = "";
			sCallee = "";
			sDateTime = "";
			sOther = "";

			if (packlength > Package.length) { packlength = Package.length; }

			if (packlength > 0) {
				Sayaca = 3;
				datalength = 0;
				while (Sayaca < Package.length)	{
					if (Package[Sayaca] == 1) // Date Field
					{
						Sayaca++;
						if (Sayaca < packlength - 1) {
							datalength = Package[Sayaca];
							if (datalength != 8) datalength = 8;
							if (datalength == 8) {
								while ((datalength > 0) && (datalength < packlength)) {
									Sayaca++;
									theChar = (char) Package[Sayaca];
									sDateTime = sDateTime + theChar;
									datalength--;
								}
							}
						}
					}
					else if (Package[Sayaca] == 2)  // Number Field
					{
						Sayaca++;
						if (Sayaca < packlength - 1) {
							datalength = Package[Sayaca];
							if (datalength > (packlength - Sayaca - 1)) datalength = (packlength - Sayaca - 1);
							while ((datalength > 0) && (datalength < packlength)) {
								Sayaca++;
								theChar = (char) Package[Sayaca];
								sCaller = sCaller + theChar;
								datalength--;
							}
						}
					}
					else if (Package[Sayaca] == 34)  //Callee field
					{
						// Other Fields
						Sayaca++;
						if (Sayaca < packlength - 1) {
							datalength = Package[Sayaca];
							while ((datalength > 0) && (datalength < packlength)) {
								Sayaca++;
								theChar = (char) Package[Sayaca];
								sCallee = sCallee + theChar;
								datalength--;
							}
						}
					}
					else   //Other fields
					{
						// Other Fields
						Sayaca++;
						if (Sayaca < packlength - 1) {
							datalength = Package[Sayaca];
							while ((datalength > 0) && (datalength < packlength)) {
								Sayaca++;
								theChar = (char) Package[Sayaca];
								sOther = sOther + theChar;
								datalength--;
							}
						}
					}
					Sayaca++;
				}
			}
		} catch (Exception e) {
			Log.d("CEBridge - parseMDMF",Log.getStackTraceString(e));
		}
	}

	private static void parseSDMF(byte[] Package) {
		int packlength = 0;
		int Sayaca;
		char theChar = 0;

		try {
			packlength = Package[2] + 4;
			sPort = (char)Package[0];
			sCaller = "";
			sCallee = "";
			sDateTime = "";
			sOther = "";

			for (Sayaca = 3; Sayaca <= packlength - 2; Sayaca++) {
				if (Sayaca < Package.length) {
					theChar = (char) Package[Sayaca];
					if (Sayaca < 11) { sDateTime = sDateTime + (char) Package[Sayaca]; }
					else { sCaller = sCaller + theChar; }
				}
			}
		} catch (Exception e) {
			Log.d("CEBridge - parsesDMF",Log.getStackTraceString(e));
		}
	}

	private static void cliReceived(char Port, String DateTime, String Caller, String Callee) {
		try {
			if (listener != null) listener.onBinderCliReceived(Port, DateTime, Caller, Callee);
		} catch (Exception e) {
			Log.d("CEBridge - cliReceived",Log.getStackTraceString(e));
		}
	}


	private void Sleep(int milliseconds) {
		try {
			Thread.sleep(milliseconds);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	private static String composeString(byte[] bytes) {
		String strPackage = "";

		try {
			StringBuilder builder = new StringBuilder();
			for (byte b: bytes) {
				if (b > 0) {
					char c = (char) b;
					builder.append(c);
				}
			}
			strPackage = builder.toString();
		} catch (Exception e) {
			Log.d("CEBridge - composeString",Log.getStackTraceString(e));
		}

		return strPackage;
	}




}
