package com.ubsidi.epos_2021.comman;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;

import com.google.android.material.snackbar.Snackbar;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.utils.Constants;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class CommonFunctions {

    public static void writeToDownloadFile(String text, String fileName) {
        try {
            // Find the root of the external storage.
            // See http://developer.android.com/guide/topics/data/data-  storage.html#filesExternal
            File root = android.os.Environment.getExternalStorageDirectory();
            // See http://stackoverflow.com/questions/3551821/android-write-to-sd-card-folder
            File dir = new File(root.getAbsolutePath() + "/download");
            dir.mkdirs();
            File file = new File(dir, fileName);
            FileOutputStream f = new FileOutputStream(file);
            PrintWriter pw = new PrintWriter(f);
            pw.println(text);
            pw.flush();
            pw.close();
            f.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String StringAppender(String... s) {
        StringBuilder builder = new StringBuilder();
        for (String string : s) {
            builder.append(string).append(" ");
        }
        return builder.toString();
    }

    public static void functionThatDelay(long ms) {
        try {
            Thread.sleep(ms);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void hideKeyboard(@Nullable Activity activity, View view) {
        if (activity != null) {
            activity.runOnUiThread(() -> {
                InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            });
        }
    }

    public static AlertDialog customProgressDialog(Context context, String title) {
        AlertDialog alertDialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View dialogView = inflater.inflate(R.layout.progress_dialog_layout, null);

        TextView tvMessage = dialogView.findViewById(R.id.tvMessage);
        if (!Validators.isNullOrEmpty(title)) {
            tvMessage.setText(title);
        }

        builder.setView(dialogView);
        builder.setCancelable(false);
        alertDialog = builder.create();
        alertDialog.getWindow().getDecorView().setBackgroundResource(android.R.color.transparent);
        alertDialog.getWindow().setDimAmount(0.0f);
        return alertDialog;
    }

    public static AlertDialog customProgressDialog(Context context) {
        return customProgressDialog(context, "");
    }

    public static String convertMsToDesiredFormat(long ms, String dateFormat) {
        DateFormat outputFormat = new SimpleDateFormat(dateFormat, Locale.getDefault());
        Date outputDate = new Date(ms);
        return outputFormat.format(outputDate);
    }

    public static Date convertToDate(String date1, String dateFormat) {
        Date outputDate = null;
        try {
            DateFormat outputFormat = new SimpleDateFormat(dateFormat, Locale.getDefault());
            outputDate = outputFormat.parse(date1);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return outputDate;
    }

    public static Date stringToDate(String date, String dateFormat) {
        Date date1 = null;
        try {
            date1 = new SimpleDateFormat(dateFormat, Locale.getDefault()).parse(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return date1;
    }

    public static String getCurrentTimeFormatted(String desiredFormat) {
        DateFormat outputFormat = new SimpleDateFormat(desiredFormat, Locale.getDefault());
        Date date = new Date();
        return outputFormat.format(date);
    }

    public static String getTimeFormatted(String time) {
        DateFormat outputFormat = new SimpleDateFormat(Constants.PHP_DATE_TIME_FORMAT, Locale.getDefault());
        DateFormat outputFormat1 = new SimpleDateFormat(Constants.DATE_FORMAT, Locale.getDefault());
        Date date = null;
        try {
            date = outputFormat.parse(time);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return outputFormat1.format(date);
    }

    public static String formatUnknownDateTime(final String date, final String currentFormat, final String desireFormat) {

        DateFormat inputFormat = new SimpleDateFormat(currentFormat, Locale.getDefault());
        DateFormat outputFormat = new SimpleDateFormat(desireFormat, Locale.getDefault());

        String formattedDate = null;

        try {
            Date inputDate = inputFormat.parse(date);
            formattedDate = outputFormat.format(inputDate);
            Date outputDate = outputFormat.parse(formattedDate);
            if (desireFormat.equalsIgnoreCase("dd MMM yyyy")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("d'st' MMM yyyy").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("d'nd' MMM yyyy").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("d'rd' MMM yyyy").format(inputDate);
                        default:
                            return new SimpleDateFormat("d'th' MMM yyyy").format(inputDate);
                    }
                return new SimpleDateFormat("d'th' MMM yyyy").format(inputDate);
            }
            if (desireFormat.equalsIgnoreCase("dd MMM")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("d'st' MMM").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("d'nd' MMM").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("d'rd' MMM").format(inputDate);
                        default:
                            return new SimpleDateFormat("d'th' MMM").format(inputDate);
                    }
                return new SimpleDateFormat("d'th' MMM").format(inputDate);
            }
            if (desireFormat.equalsIgnoreCase("EEE dd MMM")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("EEE d'st' MMM").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("EEE d'nd' MMM").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("EEE d'rd' MMM").format(inputDate);
                        default:
                            return new SimpleDateFormat("EEE d'th' MMM").format(inputDate);
                    }
                return new SimpleDateFormat("EEE d'th' MMM").format(inputDate);
            }
            if (desireFormat.equalsIgnoreCase("EEE dd MMM, yyyy")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("EEE d'st' MMM, yyyy").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("EEE d'nd' MMM, yyyy").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("EEE d'rd' MMM, yyyy").format(inputDate);
                        default:
                            return new SimpleDateFormat("EEE d'th' MMM, yyyy").format(inputDate);
                    }
                return new SimpleDateFormat("EEE d'th' MMM, yyyy").format(inputDate);
            }
            if (desireFormat.equalsIgnoreCase("EEE dd MMM 'at' hh:mm a")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);

                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("EEE d'st' MMM 'at' hh:mm a").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("EEE d'nd' MMM 'at' hh:mm a").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("EEE d'rd' MMM 'at' hh:mm a").format(inputDate);
                        default:
                            return new SimpleDateFormat("EEE d'th' MMM 'at' hh:mm a").format(inputDate);
                    }
                return new SimpleDateFormat("EEE d'th' MMM 'at' hh:mm a").format(inputDate);
            }
            if (desireFormat.equalsIgnoreCase("dd MMM, hh:mm a")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(outputDate);
                //2nd of march 2015
                int day = cal.get(Calendar.DATE);
                if (!((day > 10) && (day < 19)))
                    switch (day % 10) {
                        case 1:
                            return new SimpleDateFormat("d'st' MMM 'at' hh:mm a").format(inputDate);
                        case 2:
                            return new SimpleDateFormat("d'nd' MMM 'at' hh:mm a").format(inputDate);
                        case 3:
                            return new SimpleDateFormat("d'rd' MMM 'at' hh:mm a").format(inputDate);
                        default:
                            return new SimpleDateFormat("d'th' MMM 'at' hh:mm a").format(inputDate);
                    }
                return new SimpleDateFormat("d'th' MMM 'at' hh:mm a").format(inputDate);

            }
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return formattedDate;
    }

    public static Date convertStringDateToDate(String date, String inputFormat) {
        DateFormat format = new SimpleDateFormat(inputFormat, Locale.getDefault());
//        format.setTimeZone(TimeZone.getTimeZone("Europe/London"));
        Date formattedDate = new Date();
        try {
            formattedDate = format.parse(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return formattedDate;
    }

    public static Date convertStringDateToDate1(String date, String inputFormat) {
        DateFormat format = new SimpleDateFormat(inputFormat, Locale.getDefault());
        Date formattedDate = new Date();
        try {
            formattedDate = format.parse(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return formattedDate;
    }

    public static String formatMiliToDesireFormat(final long timestamp, final String desireFormat) {

        DateFormat outputFormat = new SimpleDateFormat(desireFormat, Locale.getDefault());
//        outputFormat.setTimeZone(TimeZone.getTimeZone("Europe/London"));
        String formattedDate = null;

        formattedDate = outputFormat.format(timestamp);

        return formattedDate;
    }

    static Date todayDate = CommonFunctions.convertStringDateToDate(CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy"), "dd-MM-yyyy");

    public static boolean isPreOrder(String orderDeliveryDate, String status) {
        Date orderDate = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(orderDeliveryDate, "yyyy-MM-dd", "dd-MM-yyyy"), "dd-MM-yyyy");
        if (orderDate.before(todayDate) || orderDate.equals(todayDate)) {
            return false;
        } else {
            if (status.equalsIgnoreCase("pending")) {
                return true; // For Pre order
            } else {
                return false;
            }
        }
    }

    public static boolean isPreOrderWithoutStatus(String orderDeliveryDate) {
        Date orderDate = CommonFunctions.convertStringDateToDate(CommonFunctions.formatUnknownDateTime(orderDeliveryDate, "yyyy-MM-dd", "dd-MM-yyyy"), "dd-MM-yyyy");
        if (orderDate.before(todayDate) || orderDate.equals(todayDate)) {
            return true;
        } else return false;
    }


    public static void showSnackBar(Context context, View coordinatorLayout, String message, int length, int color) {
        Snackbar greySnackBar = Snackbar.make(coordinatorLayout, message, length);
        greySnackBar.setBackgroundTint(ContextCompat.getColor(context, color));
        greySnackBar.show();
    }

    public static void showSnackBar(Context context, View coordinatorLayout, String message, int length) {
        Snackbar greySnackBar = Snackbar.make(coordinatorLayout, message, length);
        greySnackBar.setBackgroundTint(ContextCompat.getColor(context, R.color.eclipse_color));
        greySnackBar.show();
    }

    public static void showSnackBar(Context context, View coordinatorLayout, String message) {
        Snackbar greySnackBar = Snackbar.make(coordinatorLayout, message, Snackbar.LENGTH_LONG);
        greySnackBar.setBackgroundTint(ContextCompat.getColor(context, R.color.eclipse_color));
        greySnackBar.show();
    }

    public static boolean isConnected(Context context) {
        return MyApp.getInstance().isConnected(context);
    }

    public static String getOrderType(int type) {
        if (type == 1) {
            return "Dine in";
        } else if (type == 2) {
            return "Collection";
        } else if (type == 3) {
            return "Delivery";
        } else if (type == 4) {
            return "Bar";
        } else if (type == 5) {
            return "Waiting";
        } else if (type == 6) {
            return "Web Order";
        } else
            return "";
    }

    public static String getOnlineOrderType(int type) {
        if (type == 0) {
            return "Dine in";
        } else if (type == 1) {
            return "Delivery";
        } else if (type == 2) {
            return "Pickup";
        } else
            return "";
    }

    public static int orderPaymentStatus(float total, float paid_amount) {
        // 1= paid, 0=partial paid, -1 = unpaid
        if (total == 0) return -1;
        if (MyApp.df.format(total).equalsIgnoreCase(MyApp.df.format(paid_amount))) return 1;
        if (Float.parseFloat(MyApp.df.format(total)) == Float.parseFloat(MyApp.df.format(paid_amount)))
            return 1;
        if (paid_amount > 0 && paid_amount > total) return 1;
        if (paid_amount > 0) return 0;
        return -1;
    }

    public static Bitmap resizeImage(Bitmap bitmap, int w, int h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = (float) w / (float) width;
        float scaleHeight = (float) h / (float) height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap(bitmap, 0, 0, width, height, matrix, true);
        return resizedBitmap;
    }

    public static Bitmap toGrayscale(Bitmap bmpOriginal) {
//        if (true) return bmpOriginal;
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0F);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter(f);
        c.drawBitmap(bmpOriginal, 0.0F, 0.0F, paint);
        return bmpGrayscale;
    }

    public static byte[] thresholdToBWPic(Bitmap mBitmap) {
        int[] pixels = new int[mBitmap.getWidth() * mBitmap.getHeight()];
        byte[] data = new byte[mBitmap.getWidth() * mBitmap.getHeight()];
        mBitmap.getPixels(pixels, 0, mBitmap.getWidth(), 0, 0, mBitmap.getWidth(), mBitmap.getHeight());
        format_K_threshold(pixels, mBitmap.getWidth(), mBitmap.getHeight(), data);
        return data;
    }

    private static void format_K_threshold(int[] orgpixels, int xsize, int ysize, byte[] despixels) {
        int graytotal = 0;
        //int grayave = true;
        int k = 0;

        int i;
        int j;
        int gray;
        for (i = 0; i < ysize; ++i) {
            for (j = 0; j < xsize; ++j) {
                gray = orgpixels[k] & 255;
                graytotal += gray;
                ++k;
            }
        }

        int grayave = graytotal / ysize / xsize;
        k = 0;

        for (i = 0; i < ysize; ++i) {
            for (j = 0; j < xsize; ++j) {
                gray = orgpixels[k] & 255;
                if (gray > grayave) {
                    despixels[k] = 0;
                } else {
                    despixels[k] = 1;
                }

                ++k;
            }
        }

    }

    public static byte[] eachLinePixToCmd(byte[] src, int nWidth, int nMode) {
        int nHeight = src.length / nWidth;
        int nBytesPerLine = nWidth / 8;
        byte[] data = new byte[nHeight * (8 + nBytesPerLine)];
        //int offset = false;
        int k = 0;
        int[] p0 = new int[]{0, 128};
        int[] p1 = new int[]{0, 64};
        int[] p2 = new int[]{0, 32};
        int[] p3 = new int[]{0, 16};
        int[] p4 = new int[]{0, 8};
        int[] p5 = new int[]{0, 4};
        int[] p6 = new int[]{0, 2};
        for (int i = 0; i < nHeight; ++i) {
            int offset = i * (8 + nBytesPerLine);
            data[offset + 0] = 29;
            data[offset + 1] = 118;
            data[offset + 2] = 48;
            data[offset + 3] = (byte) (nMode & 1);
            data[offset + 4] = (byte) (nBytesPerLine % 256);
            data[offset + 5] = (byte) (nBytesPerLine / 256);
            data[offset + 6] = 1;
            data[offset + 7] = 0;

            for (int j = 0; j < nBytesPerLine; ++j) {
                data[offset + 8 + j] = (byte) (p0[src[k]] + p1[src[k + 1]] + p2[src[k + 2]] + p3[src[k + 3]] + p4[src[k + 4]] + p5[src[k + 5]] + p6[src[k + 6]] + src[k + 7]);
                k += 8;
            }
        }

        return data;
    }
}
