package com.ubsidi.epos_2021.comman;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.ANResponse;
import com.stripe.stripeterminal.external.callable.ConnectionTokenCallback;
import com.stripe.stripeterminal.external.callable.ConnectionTokenProvider;
import com.stripe.stripeterminal.external.models.ConnectionTokenException;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.LogUtils;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * A simple implementation of the [ConnectionTokenProvider] interface. We just request a
 * new token from our backend simulator and forward any exceptions along to the SDK.
 */
public class CustomTokenProvider implements ConnectionTokenProvider {
    String s_location_id, business_id;

    public CustomTokenProvider(String s_location_id, String business_id) {
        this.s_location_id = s_location_id;
        this.business_id = business_id;
    }

    @Override
    public void fetchConnectionToken(ConnectionTokenCallback callback) {
        try {
            ANRequest tokenRequest = AndroidNetworking.post(ApiEndPoints.CARD_READER_TOKEN).addBodyParameter("s_location_id", s_location_id).addBodyParameter("business_id", business_id).build();
            ANResponse jsonObject = tokenRequest.executeForJSONObject();
            if (jsonObject.isSuccess()) {
                try {
                    String token = ((JSONObject) (jsonObject.getResult())).getString("token");
                    LogUtils.e("Token Retrived: " + token);
                    callback.onSuccess(token);
                } catch (JSONException e) {
                    e.printStackTrace();
                    LogUtils.e("Token Error");
                    callback.onFailure(new ConnectionTokenException(e.getMessage()));
                }
            } else {
                LogUtils.e(jsonObject.getOkHttpResponse().message());
                LogUtils.e(jsonObject.getError().getErrorAsObject(ApiError.class).getMessage());
                callback.onFailure(new ConnectionTokenException("API error"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
