package com.ubsidi.epos_2021.comman;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;

import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;

public class MoneyTextWatcher implements TextWatcher {
    DecimalFormat doubleFormat;
    private final WeakReference<EditText> editTextWeakReference;
    private RecyclerviewItemClickListener listener;

    public MoneyTextWatcher(EditText mEditText) {
        doubleFormat = new DecimalFormat("###,###,##0.00");
        doubleFormat.setMinimumFractionDigits(2);
        editTextWeakReference = new WeakReference<EditText>(mEditText);
    }

    public MoneyTextWatcher(EditText mEditText, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        doubleFormat = new DecimalFormat("###,###,##0.00");
        doubleFormat.setMinimumFractionDigits(2);
        editTextWeakReference = new WeakReference<EditText>(mEditText);
        this.listener = recyclerviewItemClickListener;
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {

        try {
            EditText editTex = editTextWeakReference.get();
            if (!s.toString().equals(editTex.getText())) {
                try {
                    editTex.removeTextChangedListener(this);
                    if (!Validators.isNullOrEmpty(s.toString())) {
                        String cleanString = s.toString().replaceAll("[£,.]", "");
                        double parsed = Double.parseDouble(cleanString.replaceAll("[^\\d]", ""));
                        String new_string = doubleFormat.format(parsed / 100);
                        editTex.setText(new_string);
                        editTex.setSelection(new_string.length());
                        editTex.addTextChangedListener(this);
                    } else {
                        String new_string = doubleFormat.format(0 / 100);
                        editTex.setText(new_string);
                        editTex.setSelection(new_string.length());
                        editTex.addTextChangedListener(this);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
            if (listener != null) listener.onItemClick(-1, editTex.getText().toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void afterTextChanged(Editable s) {

    }
}
