package com.ubsidi.epos_2021.comman;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;

import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.SplashActivity;
import com.ubsidi.epos_2021.utils.LogUtils;

public class MyExceptionHandler implements Thread.UncaughtExceptionHandler {
    private Context activity;

    public MyExceptionHandler(Context a) {
        activity = a;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        try {
            LogUtils.e("Crashing start, Now we start splash again");
            ex.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException(ex);
            Intent intent = new Intent(activity, SplashActivity.class);
            intent.putExtra("crash", true);
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP
                    | Intent.FLAG_ACTIVITY_CLEAR_TASK
                    | Intent.FLAG_ACTIVITY_NEW_TASK);
            PendingIntent pendingIntent = PendingIntent.getActivity(MyApp.getInstance(), 0, intent, PendingIntent.FLAG_ONE_SHOT);
            AlarmManager mgr = (AlarmManager) MyApp.getInstance().getSystemService(Context.ALARM_SERVICE);
            mgr.set(AlarmManager.RTC, System.currentTimeMillis() + 2000, pendingIntent);
            System.exit(2);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}