package com.ubsidi.epos_2021.comman.bluetoothprinter;

import static com.ubsidi.epos_2021.comman.printer.WifiPrinterUtil.Alignment.CENTER;
import static com.ubsidi.epos_2021.comman.printer.WifiPrinterUtil.Alignment.LEFT;
import static com.ubsidi.epos_2021.comman.printer.WifiPrinterUtil.Alignment.RIGHT;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.util.Log;

import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.printer.WifiPrinterUtil;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.ReportTextModel;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SalesReport;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderProductDetail;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.zqprintersdk.PrinterConst;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class BluetoothPrinter {

    BluetoothDevice connectedPrinter;
    Context mContext;
    String tip = "";
    String actual = "";
    String grand = "";
    private SiteSetting printBlockBill = MyApp.getInstance().findSetting("print_block_bill");

    public BluetoothPrinter(Context context) {
        mContext = context;
    }

    public BluetoothDevice getConnectedPrinter() {
        connectedPrinter = Printama.with(mContext).getConnectedPrinter();
        if (connectedPrinter == null) return null;
        return connectedPrinter;
    }

    public void closeBTPrinter() {
        try {
            if (getConnectedPrinter() != null) {
                try {
                    Printama.with(mContext).connect(Printama::close, this::displayErrorMessage);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);

    public void printOrderZoneRich(Bitmap tiffintomLogo, OrderDetail orderDetail, boolean kitchenCopy) {
        //tip = tip_amount;
        //actual= actual_amount;
        // grand= grand_total;
        new Thread(() -> {

            try {
                Printama.with(mContext).connect(printama -> {
                    int orderType = -1;
                    if (Validators.isNullOrEmpty(orderDetail.order_type)) {
                        orderType = 0;
                    } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
                        orderType = 1;
                    } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
                        orderType = 2;
                    }
                    formatter.applyPattern("0.00");
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (tiffintomLogo != null) {
                        printama.printImage(tiffintomLogo);
                        printama.addNewLine();
                    }

                    String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                    String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    if (!todayDate.equalsIgnoreCase(orderDateString)) {
                        //  zonerich.Prn_PrintText("This order is not for today" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
                        printama.printTextEpos("This order is not for today" + "\n", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                    }
                    // zonerich.Prn_PrintText("Tiffintom.com sent you order\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    printama.printTextEpos("Tiffintom.com sent you order", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    // zonerich.Prn_PrintText(CommonFunctions.getOnlineOrderType(orderType) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos(CommonFunctions.getOnlineOrderType(orderType), WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);


                    //zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);


                    //  zonerich.Prn_PrintText("ORDER NO:" + orderDetail.order_number + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos("ORDER NO:" + orderDetail.order_number, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    if (orderType > 0) {
                        if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                            //  zonerich.Prn_PrintText("ASAP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                            printama.printTextEpos("ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                        } else {
                            printama.printTextEpos(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                            //  zonerich.Prn_PrintText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                        }
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        // zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }
                    String itemName = "", price = "", qty = "";
                    for (OrderProductDetail productDetail : orderDetail.cart_view) {
                        String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                        String productQty = String.valueOf(productDetail.quantity);
                        // Here we need 16 characters in product name so we send 16 in
                        // @params charactersInLine
                        price = (!kitchenCopy) ? formatter.format(productDetail.total_price) : "";
                        if (kitchenCopy)
                            itemName = productName;
                        else
                            itemName = getProductNameWithPad(productName, price, 35);
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + " ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "";
                        }
                        String printItem;
                        printItem = qty + itemName + "\n";
                        if (!kitchenCopy) {
                            printama.printTextEpos(printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        } else {
                            //  zonerich.Prn_PrintText(printItem, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
                            printama.printTextEpos(printItem, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                        }

                        if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                            try {
                                //String[] parts = menus.get(position).getSubaddonsName().split(",");
                                String[] parts = productDetail.subaddons_name.split(",");

                                for (String subAddonPart : parts) {
                                    if (!kitchenCopy) {
                                        String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                        //    zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                                        printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                                    } else {
                                        String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                        //zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
                                        printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);

                                    }
                                }
                            } catch (Exception e) {
                                Log.e("Addon_Error", e.getMessage());
                            }
                        }
                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    //zonerich.Prn_PrintText(padRightSpaces("SubTotal:", 20) + MyApp.df.format(orderDetail.order_sub_total) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(padRightSpaces("SubTotal:", 20) + MyApp.df.format(orderDetail.order_sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    if (orderDetail.delivery_charge > 0) {
                        // zonerich.Prn_PrintText(padRightSpaces("Delivery Charge:", 20) + MyApp.df.format(orderDetail.delivery_charge) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos(padRightSpaces("Delivery Charge:", 20) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if (orderDetail.offer_amount > 0) {
                        printama.printTextEpos(padRightSpaces("Offer:", 20) + MyApp.df.format(orderDetail.offer_amount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // zonerich.Prn_PrintText(padRightSpaces("Offer:", 20) + MyApp.df.format(orderDetail.offer_amount) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                    if (orderDetail.service_charge > 0) {
                        if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                            printama.printTextEpos(padRightSpaces("Service Charge:", 20) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            // zonerich.Prn_PrintText(padRightSpaces("Service Charge:", 20) + MyApp.df.format(orderDetail.service_charge) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                    }
                    if (orderDetail.driver_tip > 0) {
                        printama.printTextEpos(padRightSpaces("Driver Tip:", 20) + MyApp.df.format(orderDetail.driver_tip), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // zonerich.Prn_PrintText(padRightSpaces("Driver Tip:", 20) + MyApp.df.format(orderDetail.driver_tip) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                    if (orderDetail.reward_offer > 0) {
                        printama.printTextEpos(padRightSpaces("Loyalty Point Discount:", 20) + MyApp.df.format(orderDetail.reward_offer), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //zonerich.Prn_PrintText(padRightSpaces("Loyalty Point Discount:", 20) + MyApp.df.format(orderDetail.reward_offer) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                    //  zonerich.Prn_PrintText("Grand Total: " + MyApp.df.format(orderDetail.order_grand_total) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos("Grand Total: " + MyApp.df.format(orderDetail.order_grand_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);


                    //zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                        if (kitchenCopy) {
                            printama.printTextEpos("Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);

                            // zonerich.Prn_PrintText("Comments: " + orderDetail.order_description + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                        } else {
                            // zonerich.Prn_PrintText("Comments: " + orderDetail.order_description + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                            printama.printTextEpos("Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                        printama.printTextEpos("------------------------------------------------\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //  zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                        //  zonerich.Prn_PrintText("Delivery Instructions: " + orderDetail.delivery_instruction + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos("Delivery Instructions: " + orderDetail.delivery_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);


                        // zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos("------------------------------------------------\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    }
                    // zonerich.Prn_PrintText("Cust Name:" + orderDetail.customer_name + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("Cust Name:" + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                        //  zonerich.Prn_PrintText("Cust No:" + orderDetail.customer_phone + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos("Cust No:" + orderDetail.customer_phone, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    }
                    //  zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    if (orderType == 1) {

                        String address = orderDetail.address + "\n";
                        String[] parts = address.split("[\\\\s,]+");
                        StringBuilder str = new StringBuilder();

                        for (String name : parts) {
                            str.append(name).append("\n");
                        }
                        // zonerich.Prn_PrintText("Del. address:" + address + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                        // zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos("Del. address:" + address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        printama.printTextEpos("------------------------------------------------\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }

                    if (orderType >= 0) {
                        printama.printTextEpos("Requested for:", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                        if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                            printama.printTextEpos("ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                            printama.printTextEpos("------------------------------------------------\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        } else {
                            printama.printTextEpos(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                            printama.printTextEpos("------------------------------------------------\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                        if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                            //   zonerich.Prn_PrintText("Confirmed for:" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                            //zonerich.Prn_PrintText(orderDetail.preparation + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                            printama.printTextEpos("Confirmed for:", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                            printama.printTextEpos(orderDetail.preparation, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                            printama.printTextEpos("------------------------------------------------\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                        // zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }
                    // zonerich.Prn_PrintText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);

                    String paymentName = "";
                    if (orderDetail.payment_method.equalsIgnoreCase("stripe"))
                        paymentName = "ONLINE";
                    if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                    if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                        paymentName = "WALLET";
                    if (orderDetail.payment_method.equalsIgnoreCase("paypal"))
                        paymentName = "PAYPAL";

                    //zonerich.Prn_PrintText("Payment Type:  " + paymentName + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos("Payment Type:  " + paymentName, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);


                    //zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    // zonerich.Prn_PrintText("Receipt Time:\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos("Receipt Time:\n", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);


                    //zonerich.Prn_PrintText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);

                    // zonerich.Prn_PrintText("Order status: " + orderDetail.status + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos("Order status: " + orderDetail.status, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);

                    if (orderDetail.status.equalsIgnoreCase("failed")) {
                        //  zonerich.Prn_PrintText("Reason: " + orderDetail.failed_reason + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                        printama.printTextEpos("Reason: " + orderDetail.failed_reason, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);

                    }

                    //zonerich.Prn_PrintText(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);

                    //   zonerich.Prn_PrintText("Thanks!" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    printama.printTextEpos("Thanks!", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);

                    printama.addNewLine(1);
                    //   zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    //            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.addNewLine(1);
                    //  zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    //            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.addNewLine(1);

                    //WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                    printama.setCutPaper();
                    printama.close();

                }, this::displayErrorMessage);

            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
            }
        }).start();

    }

    public void printCardReaderReceiptZoneRich(Bitmap tiffintomLogo, String rePrintTitle, String title, String header, int headerAlignment, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1) {
        tip = tip_amount;
        actual = actual_amount;
        grand = grand_total;
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (tiffintomLogo != null) {
                        printama.printImageLeft(tiffintomLogo, 320);
                        printama.addNewLine();
                    }
                    if (headerAlignment < 2) {
                        printama.printTextEpos(header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                    } else {
                        String[] headers = header.split("\n");
                        for (String h : headers) {
                            printama.printTextEpos(padLeftSpace(h, 35), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            // zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                    }
                    //zonerich.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    if (!Validators.isNullOrEmpty(rePrintTitle)) {
                        printama.printTextEpos(rePrintTitle, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    }
                    printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);

                    //zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    if (!Validators.isNullOrEmpty(tip)) {
                        actual = actual.replace("£", "");
                        actual = actual + " GBP";
                        //  zonerich.Prn_PrintText(actual_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos(actual, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        tip = tip.replace("£", "");
                        tip = tip + " GBP";
                        // zonerich.Prn_PrintText(tip_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
                        printama.printTextEpos(tip, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    }
                    grand = grand.replace("£", "");
                    grand = grand + " GBP";
                    //    zonerich.Prn_PrintText(grand_total + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    printama.printTextEpos(grand, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);

                    printama.printTextEpos(main_content, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //zonerich.Prn_PrintText(main_content + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    //zonerich.Prn_PrintText(please + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(please, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //    zonerich.Prn_PrintText(final_date + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(final_date, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    // zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    // zonerich.Prn_PrintText(footer + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(footer, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    //  zonerich.Prn_PrintText(footer1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.printTextEpos(footer1, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //    zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    //            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.addNewLine(1);
                    //   zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    //            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.addNewLine(1);
                    //  zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    //            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    printama.addNewLine(1);

                    //WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                    printama.setCutPaper();
                    printama.close();
                }, this::displayErrorMessage);

            } catch (Exception e) {
                e.printStackTrace();
                FirebaseCrashlytics.getInstance().recordException(e);
            }
        }).start();

    }

    public void printCardReaderReceipt(Bitmap bitmap, String title, String header, String header1, int headerAlignment, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1, boolean close) {
        actual_amount = actual_amount.replace(MyApp.currencySymbol, "");
        if (!Validators.isNullOrEmpty(tip_amount)) {
            tip_amount = tip_amount.replace(MyApp.currencySymbol, "");
        }
        grand_total = grand_total.replace(MyApp.currencySymbol, "");
        String finalActual_amount = actual_amount;
        String finalTip_amount = tip_amount;
        String finalGrand_total = grand_total;
        new Thread(() -> {
            MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Card Reader Called: " + title));
            try {
                Printama.with(mContext).connect(printama -> {
                    MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Card Reader start : " + title));
                    // wifiCommunication.sndByte(ByteCommand.ESC_Init);
                    // printingStatus = 1;
                    //  WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (bitmap != null) {
                        printama.printImage(bitmap, 320);
                        //WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 340, 0);
                    }
                    //if (bitmap != null)
                    //   WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, bitmap, 320, 0);
                    if (!Validators.isNullOrEmpty(header)) {
                        printama.printTextEpos(header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                    }
                    if (!Validators.isNullOrEmpty(header1)) {
                        printama.printTextEpos(header1, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                    }
                    printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    if (!Validators.isNullOrEmpty(finalTip_amount)) {
                        printama.printTextEpos(finalActual_amount, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                        printama.printTextEpos(finalTip_amount, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    }
                    printama.printTextEpos(finalGrand_total + " GBP", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    printama.printTextEpos(main_content, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    printama.printTextEpos(please, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(final_date, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(footer, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(footer1, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    //WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                    printama.setCutPaper();
                    if (close) {
                        //   printingStatus = 0;
                        //   disconnect();
                        printama.close();
                        MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Card Reader disconnect: " + title));
                    }
                }, this::displayErrorMessage);
            } catch (Exception e) {
                e.printStackTrace();
                FirebaseCrashlytics.getInstance().recordException(e);
            }
        }).start();
    }

    public void printMotoReceipt(Bitmap bitmap, String title, String header, int headerAlignment, final String amount, String main_content, String date_final, String please, String footer, String footer1, boolean close) {
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Moto Called : " + title));
                    MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Moto start : " + title));
                    //  wifiCommunication.sndByte(ByteCommand.ESC_Init);
                    //   printingStatus = 1;
                    //   WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (bitmap != null) {
                        printama.printImage(bitmap, 320);
                        //WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 340, 0);
                    }
                    // if (bitmap != null)
                    //    WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, bitmap, 320, 0);

                    printama.printTextEpos(header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                    printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    String amt = amount;
                    amt = amt.replace("£", "");
                    amt = amt.replace("\n", "");
                    amt = amt + " GBP";
                    printama.printTextEpos(amt, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    printama.printTextEpos(main_content.replace(" :", ": "), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    printama.printTextEpos(date_final, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(please, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(footer, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(footer1, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.setCutPaper();
                    // WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                    if (close) {
                        //    printingStatus = 0;
                        //     disconnect();
                        printama.close();
                        MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Moto disconnect: " + title));
                    }
                    // printingStatus = 0;
                }, this::displayErrorMessage);
            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
            }
        }).start();
    }

    public void printReservationList(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, ArrayList<Object> allReservations, String footerA, String footerB, String fromdate, String todate) {
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Reservation called : " + title));
                    MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Reservation started : " + title));
                    //  wifiCommunication.sndByte(ByteCommand.ESC_Init);
                    //  printingStatus = 1;
                    //   WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (tiffintomLogo != null) {
                        printama.printImage(tiffintomLogo, 320);
                        // WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                    }
                    printama.printTextEpos(ticket_header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                    if (!Validators.isNullOrEmpty(title)) {
                        printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    String date = "";
                    if (fromdate != null) {
                        if (fromdate.equalsIgnoreCase("0") && todate.equalsIgnoreCase("0")) {
                            date = "Show All";
                        } else if (fromdate.equalsIgnoreCase(todate)) {
                            date = fromdate;
                        } else {
                            date = fromdate + " - " + todate;
                        }
                    } else {
                        date = "All";
                    }

                    printama.printTextEpos(date, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);


                    for (Object obj : allReservations) {
                        StringBuilder sb = new StringBuilder();
                        if (obj instanceof Reservation) {
                            sb = new StringBuilder();
                            Reservation reservation = (Reservation) obj;
                            sb.append(padRightSpaces("Name: " + reservation.customer_name, 30))
                                    .append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy"));

                            if (!Validators.isNullOrEmpty(reservation.telephone)) {
                                if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                                    sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 30)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                                } else {
                                    sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 30)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                                }
                            } else {
                                if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                                    sb.append("\n").append(padRightSpaces("", 20)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                                } else {
                                    sb.append("\n").append(padRightSpaces("", 20)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                                }
                            }

                            if (!Validators.isNullOrEmpty(reservation.table_number)) {
                                sb.append("\n").append("Table: ").append(reservation.table_number);
                            }
                            sb.append("\n").append(padRightSpaces("Dinner: " + reservation.diners, 30)).append("Status: ").append(reservation.reservation_status);

                            if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                                sb.append("\n").append("Special Instruction: ").append(reservation.special_instruction);
                            }
                        }
                        if (obj instanceof OnlineReservation) {

                            sb = new StringBuilder();
                            OnlineReservation reservation = (OnlineReservation) obj;
                            sb.append(padRightSpaces("Name: " + reservation.customer_name, 30))
                                    .append(CommonFunctions.formatUnknownDateTime(reservation.booking_date, "yyyy-MM-dd", "dd/MM/yyyy"));

                            if (!Validators.isNullOrEmpty(reservation.booking_phone)) {
                                sb.append("\n").append(padRightSpaces("Number: " + reservation.booking_phone, 30)).append(reservation.booking_time);
                            } else {
                                sb.append("\n").append(padRightSpaces("", 30)).append(reservation.booking_time).append("\n");
                            }
                            sb.append("\n").append(padRightSpaces("Dinner: " + reservation.guest_count, 30)).append("Status: ").append(reservation.status);
                            if (reservation.status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                                sb.append("\n").append("Reason: ").append(reservation.cancel_reason);
                            }
                            if (!Validators.isNullOrEmpty(reservation.booking_instruction) && !reservation.status.equalsIgnoreCase("cancel")) {
                                sb.append("\n").append("Booking Instruction: ").append(reservation.booking_instruction);
                            }

                        }
                        if (sb.toString().length() > 0) {
                            printama.printTextEpos(sb.toString(), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                        }

                    }
                    printama.printTextEpos(footerA, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos(footerB, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    // WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                    printama.setCutPaper();
                    //printingStatus = 0;
                    //disconnect();
                    printama.close();
                    MyApp.getInstance().notifyCallReceived(mContext, new Intent("log").putExtra("log", "Printing Reservation disconnect : " + title));
                }, this::displayErrorMessage);
            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
            }
        }).start();
    }

    public void printReservation(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Reservation reservation, String footerA, String footerB) {
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    //wifiCommunication.sndByte(ByteCommand.ESC_Init);
                    /*WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    if (tiffintomLogo != null) {
                        WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                    }*/
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (tiffintomLogo != null) {
                        printama.printImage(tiffintomLogo, 320);
                        // WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                    }
                    printama.printTextEpos(ticket_header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);

                    if (!Validators.isNullOrEmpty(title)) {
                        printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                    String customername = "Customer Name: " + reservation.customer_name;
                    printama.printTextEpos(customername, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    if (!Validators.isNullOrEmpty(reservation.telephone)) {
                        String customerno = "Customer Number: " + reservation.telephone;
                        printama.printTextEpos(customerno, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                    if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                        printama.printTextEpos("Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd/MM/yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        printama.printTextEpos("Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    } else {
                        printama.printTextEpos("Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        printama.printTextEpos("Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    printama.printTextEpos("No of Diners     : " + reservation.diners, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    if (!reservation.online_reservation) {
                        if (!Validators.isNullOrEmpty(reservation.deposit_type))
                            printama.printTextEpos("Deposit Type     : " + reservation.deposit_type, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        printama.printTextEpos("Deposit Amount   : " + reservation.deposit_amount, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                    if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                        printama.printTextEpos("Special Instructions : " + reservation.special_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    }
                    printama.printTextEpos(footerA, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos(footerB, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.setCutPaper();
                    printama.close();
                }, this::displayErrorMessage);
            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
            }
        }).start();
    }

    public void printVoucher(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Voucher voucher, String footerA, String footerB) {
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (tiffintomLogo != null) {
                        printama.printImage(tiffintomLogo, 320);
                    }
                    printama.printTextEpos(ticket_header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);

                    if (!Validators.isNullOrEmpty(title)) {
                        printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    }
                    printama.printTextEpos(voucher.voucher_code, WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);

                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(MyApp.df.format(voucher.voucher_amount) + " GBP", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);

                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                    StringBuilder sb = new StringBuilder();

                    sb.append("Name: ").append(voucher.customer_name).append("\n");

                    sb.append("VALIDITY\n");

                    sb.append("VALID FROM : ").append(CommonFunctions.formatUnknownDateTime(voucher.start_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");

                    if (Validators.isNullOrEmpty(voucher.end_date) || voucher.end_date.contains("203")) {
                        sb.append("VALID Till : No Expiry\n");
                    } else {
                        sb.append("VALID Till : ").append(CommonFunctions.formatUnknownDateTime(voucher.end_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");
                    }


                    if (!Validators.isNullOrEmpty(voucher.week_day)) {
                        String[] daystList = voucher.week_day.split(",");
                        StringBuilder daysBuilder = new StringBuilder();
                        for (String str : daystList) {
                            if (Validators.isNullOrEmpty(str)) continue;
                            if (str.equalsIgnoreCase("0")) {
                                daysBuilder.append("Monday");
                            }
                            if (str.equalsIgnoreCase("0")) {
                                daysBuilder.append("Tuesday");
                            }
                            if (str.equalsIgnoreCase("0")) {
                                daysBuilder.append("Wednesday");
                            }
                            if (str.equalsIgnoreCase("0")) {
                                daysBuilder.append("Thursday");
                            }
                            if (str.equalsIgnoreCase("0")) {
                                daysBuilder.append("Friday");
                            }
                            if (str.equalsIgnoreCase("0")) {
                                daysBuilder.append("Saturday");
                            }
                            if (str.equalsIgnoreCase("0")) {
                                daysBuilder.append("Sunday");
                            }
                            if (daysBuilder.length() > 0) {
                                daysBuilder.append(", ");
                            }

                        }
                        sb.append("Not Valid on: ").append(daysBuilder.toString()).append("\n");
                    }

                    if (!Validators.isNullOrEmpty(voucher.order_type_id)) {
                        String[] orderList = voucher.order_type_id.split(",");
                        StringBuilder ordersBuilder = new StringBuilder();
                        for (String str : orderList) {
                            if (Validators.isNullOrEmpty(str)) continue;
                            if (str.equalsIgnoreCase("1"))
                                ordersBuilder.append("Dine In");

                            if (str.equalsIgnoreCase("2"))
                                ordersBuilder.append("Collection");

                            if (str.equalsIgnoreCase("3"))
                                ordersBuilder.append("Delivery");

                            if (str.equalsIgnoreCase("4"))
                                ordersBuilder.append("Bar");

                            if (str.equalsIgnoreCase("5"))
                                ordersBuilder.append("Waiting");

                            if (str.equalsIgnoreCase("6"))
                                ordersBuilder.append("Web Order");

                            if (ordersBuilder.length() > 0) {
                                ordersBuilder.append(", ");
                            }
                        }
                        sb.append("Not Valid on: ").append(ordersBuilder.toString()).append("\n");
                    }
                    printama.printTextEpos(sb.toString(), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                    printama.printTextEpos(footerA, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos(footerB, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.setCutPaper();
                    printama.close();
                }, this::displayErrorMessage);
            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
            }
        }).start();
    }

    public void printFullReport(Bitmap tiffintomLogo, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB) {
        new Thread(() -> {

            try {
                Printama.with(mContext).connect(printama -> {
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (tiffintomLogo != null) {
                        printama.printImage(tiffintomLogo, 320);
                    }
                    // wifiCommunication.sndByte(ByteCommand.ESC_Init);
                    //  printingStatus = 1;
                    //  WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos(header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                    if (!Validators.isNullOrEmpty(title))
                        printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    if (!Validators.isNullOrEmpty(date)) {
                        printama.printTextEpos("Date: " + date, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    if (!Validators.isNullOrEmpty(user)) {
                        printama.printTextEpos("User name: " + user, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    for (Object objct : data) {
                        if (objct instanceof ReportTextModel) {
                            ReportTextModel textModel = (ReportTextModel) objct;

                            String printText;
                            if (!textModel.isHeader) {
                                if (!Validators.isNullOrEmpty(textModel.value)) {
                                    if (textModel.value.contains(MyApp.currencySymbol)) {
                                        printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 36);
                                    } else {
                                        printText = getProductNameWithPad(textModel.title, textModel.value, 40);
                                    }
                                } else printText = getProductNameWithPad(textModel.title, "", 40);
                            } else {
                                printText = "\n" + textModel.title;
                            }
                            printama.printTextEpos(printText, textModel.isHeader ? WifiPrinterUtil.FontSize.SIZE0 : WifiPrinterUtil.FontSize.SIZE0, textModel.isHeader ? WifiPrinterUtil.FontSize.SIZE1 : WifiPrinterUtil.FontSize.SIZE0, textModel.isHeader, false, LEFT);

                        }
                        if (objct instanceof SalesReport) {
                            SalesReport salesReport = (SalesReport) objct;
                            String name = salesReport.product_name;
                            if (Validators.isNullOrEmpty(name)) {
                                name = salesReport.category_name;
                            }
                            String printText;
                            printText = getProductNameWithPad(name + " (" + salesReport.count + ")", salesReport.total, 40);
                            printama.printTextEpos(printText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                        }
                    }

                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    printama.printTextEpos(footerA, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.printTextEpos(footerB, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    printama.setCutPaper();
                    printama.close();
                }, this::displayErrorMessage);
            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
            }
        }).start();
    }

    public void printEposOrder(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, boolean printTotalInPrint, String footerA, String footerB, String footerHeading, boolean kitchenCopy, boolean isCashDrawerOpen) {
        if (connectedPrinter == null) return;

        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    int orderType = -1;
                    if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
                        orderType = 0;
                    } else {
                        orderType = Integer.parseInt(orderDetail.order_type_id);
                    }
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (!kitchenCopy && tiffintomLogo != null) {
                        printama.printImage(tiffintomLogo, 340);
                        //WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 340, 0);
                    }
                    if (!kitchenCopy) {
                        printama.printTextEpos(ticket_header, 0, 0, true, false, headerAlignment);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, ticket_header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                    }
                    if (kitchenCopy) {
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "** " + orderDetail.order_type + " **", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                        printama.printTextEpos(ticket_header, WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                        //  LogUtils.e("PRINT::", "** " + orderDetail.order_type + " **");
                        if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, false, false, CENTER);
                            printama.printTextEpos(orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, false, false, CENTER);
                        }
                        //  LogUtils.e("PRINT::", orderDetail.customer_name);
                    }
                    if (!Validators.isNullOrEmpty(title)) {
                        //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                        printama.printTextEpos(title, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);

                    }

                    String tableNumberOrderIdText = "";
                    if (tableNumberOrderIdMode != null) {
                        if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                            if (Validators.isNullOrEmpty(orderDetail.id)) {
                                tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                            } else
                                tableNumberOrderIdText = "Order ID: " + orderDetail.id;

                        }
                        if (orderType == 1 && (tableNumberOrderIdMode.equalsIgnoreCase("table_number") || tableNumberOrderIdMode.equalsIgnoreCase("both"))) {
                            if (tableNumberOrderIdText.length() > 1) {
                                tableNumberOrderIdText = tableNumberOrderIdText + "\n";
                            }
                            tableNumberOrderIdText = tableNumberOrderIdText + "Table No: " + orderDetail.table_number + "  No of Diners:  " + orderDetail.no_guest;

                        }
                        if (tableNumberOrderIdMode.equalsIgnoreCase("none")) {
                            tableNumberOrderIdText = "";
                        }
                        if (tableNumberOrderIdText.length() > 0) {
                            if (!Validators.isNullOrEmpty(title))
                                printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                            printama.printTextEpos(tableNumberOrderIdText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        }
                    }

                    if (!Validators.isNullOrEmpty(dateTimeMode)) {
                        String dateFormat = "dd-MM-yyyy hh:mm a";
                        String dateFormatTitle = "Order Date Time: ";
                        if (dateTimeMode.equalsIgnoreCase("date_time")) {
                            dateFormat = "dd-MM-yyyy hh:mm a";
                            dateFormatTitle = "Order Date Time: ";
                        }
                        if (dateTimeMode.equalsIgnoreCase("time")) {
                            dateFormat = "hh:mm a";
                            dateFormatTitle = "Order Time: ";
                        }
                        if (dateTimeMode.equalsIgnoreCase("date")) {
                            dateFormat = "dd-MM-yyyy";
                            dateFormatTitle = "Order Date: ";
                        }
                        printama.printTextEpos(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }

                    if (orderType > 1 && !kitchenCopy) {
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order Type: " + orderDetail.order_type, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        printama.printTextEpos("Order Type: " + orderDetail.order_type, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    }
                    //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);


                    //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Qty Name", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    printama.printTextEpos("Qty Name", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    String itemName = "", price = "", qty = "";

                    String lastBlockId = null;
                    boolean lastItemWasMisc = false;

                    for (OrderItem productDetail : orderDetail.order_items) {
                        String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                        String productQty = String.valueOf(productDetail.quantity);
                        // Here we need 16 characters in product name so we send 16 in
                        // @params charactersInLine
                        price = (!kitchenCopy) ? MyApp.df.format(productDetail.total) : "";
                        if (!kitchenCopy)
                            itemName = getProductNameWithPad(productName, price, 35);
                        else
                            itemName = productName;
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + " ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + "  ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "";
                        }
                        if (lastBlockId != null) {
                            if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes"))) {
                                    printama.printTextEpos("---------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                                }
                            }
                        } else {
                            if (lastItemWasMisc && !productDetail.misc) {
                                if (kitchenCopy)
                                    printama.printTextEpos("---------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                            }
                        }

                        String printItem;
                        printItem = qty + itemName;
                        if (!kitchenCopy) {
                            printama.printTextEpos(printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                printama.printTextEpos("  " + "Instruction: " + productDetail.special_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "  " + "Instruction: " + productDetail.special_instruction, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        } else {
                            printama.printTextEpos(printItem, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                            //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                printama.printTextEpos("  " + "Instruction: " + productDetail.special_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "  " + "Instruction: " + productDetail.special_instruction, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        }

                        for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                            List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                            if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                continue;
                            }
                            if (!kitchenCopy) {
                                String subdomainPrintText = "   " + orderItemAddon.addon_name.replace(MyApp.currencySymbol, "");
                                //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            } else {
                                String subdomainPrintText = "   " + orderItemAddon.addon_name.replace(MyApp.currencySymbol, "");
                                // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                                printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            }
                        }

                        for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                            String ingredientName = orderItemIngredient.ingredient_name;
                            if (orderItemIngredient.with) {
                                ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                            }
                            if (orderItemIngredient.without) {
                                ingredientName = "  " + "No " + ingredientName;
                            }
                            String subdomainPrintText = ingredientName;
                            if (!kitchenCopy) {
                                printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            } else {
                                printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                                // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            }
                        }
                        lastItemWasMisc = productDetail.misc;
                        lastBlockId = productDetail.block_id;
                    }

                    if (printTotalInPrint) {
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        printama.printTextEpos(padRightSpaces("SubTotal :", 1) + MyApp.df.format(orderDetail.sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("SubTotal :", 1) + MyApp.df.format(orderDetail.sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        if (orderDetail.delivery_charge > 0) {
                            printama.printTextEpos(padRightSpaces("Delivery charge :", 1) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                            //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Delivery charge :", 1) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        }
                        if (orderDetail.gratuity > 0) {
                            printama.printTextEpos(padRightSpaces("Gratuity :", 1) + MyApp.df.format(orderDetail.gratuity), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Gratuity :", 1) + MyApp.df.format(orderDetail.gratuity), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        }
                        if (orderDetail.service_charge > 0) {
                            printama.printTextEpos(padRightSpaces("Service charge :", 1) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                            //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Service charge :", 1) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        }
                        if (orderDetail.discount > 0) {
                            printama.printTextEpos(padRightSpaces("Discount :", 1) + MyApp.df.format(orderDetail.discount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Discount :", 1) + MyApp.df.format(orderDetail.discount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        }
                        printama.printTextEpos("Grand Total : " + MyApp.df.format(orderDetail.total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                        //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Grand Total : " + MyApp.df.format(orderDetail.total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                        //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }

                    if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                        printama.printTextEpos("Payment Details:", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Details:", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                        for (OrderPayment orderPayment : orderDetail.order_payments) {
                            printama.printTextEpos(orderPayment.payment_method_name + " Payment : " + orderPayment.amount, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderPayment.payment_method_name + " Payment : " + orderPayment.amount, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }

                    String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                    printama.printTextEpos(toprint, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, toprint, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        printama.printTextEpos("Cust Name:" + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust Name:" + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }

                    if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                        printama.printTextEpos("Cust No:" + orderDetail.customer.mobile, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust No:" + orderDetail.customer.mobile, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if (orderType == 3) {
                        String fulladdress = "Address : " + orderDetail.customer.house_no + ","
                                + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                        printama.printTextEpos(fulladdress, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, fulladdress, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                        printama.printTextEpos("Payment Status: Unpaid", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Status: Unpaid", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                        printama.printTextEpos("Payment Status: Paid", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Status: Paid", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                        printama.printTextEpos("Payment Status: Partially Paid", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Status: Partially Paid", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                        if (kitchenCopy) {
                            printama.printTextEpos("Comment: " + orderDetail.comment, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comment: " + orderDetail.comment, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                        } else {
                            printama.printTextEpos("Comment: " + orderDetail.comment, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comment: " + orderDetail.comment, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    if (kitchenCopy) {
                        if (!Validators.isNullOrEmpty(footerHeading)) {
                            printama.printTextEpos("** " + footerHeading + " **", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                        }
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "** " + orderDetail.order_type + " **", WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                    }

                    if (!Validators.isNullOrEmpty(footerA)) {
                        printama.printTextEpos(footerA, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerA, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    if (!Validators.isNullOrEmpty(footerB)) {
                        printama.printTextEpos(footerB, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerB, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    printama.setCutPaper();
                    if (isCashDrawerOpen) {
                        // TODO open cash drawer
                        openCashDrawer(false);
                    }
                    printama.close();
                }, this::displayErrorMessage);
            } catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
                LogUtils.e("PRINT::", "error while bluetooth printing epos order");
                LogUtils.e(Log.getStackTraceString(e));
            }
        }).start();

    }

    public void printOrder(Bitmap tiffintomLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean disconnect) {
        new Thread(() -> {
            try {
                Printama.with(mContext).connect(printama -> {
                    int orderType = -1;
                    if (Validators.isNullOrEmpty(orderDetail.order_type)) {
                        orderType = 0;
                    } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
                        orderType = 1;
                    } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
                        orderType = 2;
                    }
                    printama.addNewLine(1);
                    printama.setNormalText();
                    if (tiffintomLogo != null) {
                        //  WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                        printama.printImage(tiffintomLogo);
                    } else {
                        LogUtils.e("PRINT::", "Tiffintom Logo null");
                    }
                    String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                    String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    if (!todayDate.equalsIgnoreCase(orderDateString)) {
                        printama.printTextEpos("This order is not for today", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "This order is not for today", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    printama.printTextEpos("Tiffintom.com sent you order", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos(CommonFunctions.getOnlineOrderType(orderType), WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos("ORDER NO:" + orderDetail.order_number, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Tiffintom.com sent you order", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, CommonFunctions.getOnlineOrderType(orderType), WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                    //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "ORDER NO:" + orderDetail.order_number, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    if (orderType > 0) {
                        if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                            printama.printTextEpos("ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        } else {
                            printama.printTextEpos(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            //    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    String itemName = "", price = "", qty = "";
                    for (OrderProductDetail productDetail : orderDetail.cart_view) {
                        String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                        String productQty = String.valueOf(productDetail.quantity);
                        // Here we need 16 characters in product name so we send 16 in
                        // @params charactersInLine
                        price = (!kitchenCopy) ? MyApp.df.format(productDetail.total_price) : "";
                        if (kitchenCopy)
                            itemName = getProductNameWithPad(productName, price, 15);
                        else
                            itemName = getProductNameWithPad(productName, price, 35);
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + " ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + "  ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "";
                        }
                        String printItem;
                        printItem = qty + itemName;

                        printItem = printItem.replace(MyApp.currencySymbol, "");
                        if (!kitchenCopy)
                            printama.printTextEpos(printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        else
                            printama.printTextEpos(printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);

                        if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                            try {
                                //String[] parts = menus.get(position).getSubaddonsName().split(",");
                                String[] parts = productDetail.subaddons_name.split(",");

                                for (String subAddonPart : parts) {
                                    if (!kitchenCopy) {
                                        String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                        subdomainPrintText = subdomainPrintText.replace(MyApp.currencySymbol, "");
                                        printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                    } else {
                                        String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                        subdomainPrintText = subdomainPrintText.replace(MyApp.currencySymbol, "");
                                        printama.printTextEpos(subdomainPrintText, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                                    }
                                }
                            } catch (Exception e) {
                                Log.e("Addon_Error", e.getMessage());
                            }
                        }
                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    printama.printTextEpos(padRightSpaces("SubTotal:", 40) + MyApp.df.format(orderDetail.order_sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("SubTotal:", 40) + MyApp.df.format(orderDetail.order_sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    if (orderDetail.delivery_charge > 0) {
                        printama.printTextEpos(padRightSpaces("Delivery Charge:", 40) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Delivery Charge:", 40) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if (orderDetail.offer_amount > 0) {
                        printama.printTextEpos(padRightSpaces("Offer:", 40) + MyApp.df.format(orderDetail.offer_amount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Offer:", 40) + MyApp.df.format(orderDetail.offer_amount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if (orderDetail.service_charge > 0) {
                        if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                            printama.printTextEpos(padRightSpaces("Service Charge:", 40) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Service Charge:", 40) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                    }
                    if (orderDetail.driver_tip > 0) {
                        printama.printTextEpos(padRightSpaces("Driver Tip:", 40) + MyApp.df.format(orderDetail.driver_tip), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Driver Tip:", 40) + MyApp.df.format(orderDetail.driver_tip), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    if (orderDetail.reward_offer > 0) {
                        printama.printTextEpos(padRightSpaces("Loyalty Point Discount:", 40) + MyApp.df.format(orderDetail.reward_offer), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Loyalty Point Discount:", 40) + MyApp.df.format(orderDetail.reward_offer), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    printama.printTextEpos("Grand Total: " + MyApp.df.format(orderDetail.order_grand_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Grand Total: " + MyApp.df.format(orderDetail.order_grand_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                        if (kitchenCopy) {
                            printama.printTextEpos("Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                        } else {
                            printama.printTextEpos("Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            //  WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        }
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                        printama.printTextEpos("Delivery Instructions: " + orderDetail.delivery_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        //     WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Delivery Instructions: " + orderDetail.delivery_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    printama.printTextEpos("Cust Name: " + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust Name: " + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                        printama.printTextEpos("Cust No: " + orderDetail.customer_phone, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        //     WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust No: " + orderDetail.customer_phone, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    if (orderType == 1) {

                        String address = orderDetail.address + "\n";
                        String[] parts = address.split("[\\\\s,]+");
                        StringBuilder str = new StringBuilder();

                        for (String name : parts) {
                            str.append(name).append("\n");
                        }
                        printama.printTextEpos("Del. address: " + orderDetail.address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Del. address: " + orderDetail.address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }

                    if (orderType >= 0) {
                        if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                            printama.printTextEpos("Requested for: " + "ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                        } else {
                            printama.printTextEpos("Requested for: " + orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                        }

                        if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                            printama.printTextEpos("Confirmed for: " + orderDetail.preparation, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Confirmed for: " + orderDetail.preparation, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                            // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        }
                    }
                    printama.printTextEpos("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                    String paymentName = "";
                    if (orderDetail.payment_method.equalsIgnoreCase("stripe"))
                        paymentName = "ONLINE";
                    if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                    if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                        paymentName = "WALLET";
                    if (orderDetail.payment_method.equalsIgnoreCase("paypal"))
                        paymentName = "PAYPAL";
                    printama.printTextEpos("Payment Type:  " + paymentName, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //     WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Type:  " + paymentName, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    printama.printTextEpos("------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                    printama.printTextEpos("Receipt Time:  " + CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    printama.printTextEpos("Order status: " + orderDetail.status, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Receipt Time:  " + CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    //   WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order status: " + orderDetail.status, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    if (orderDetail.status.equalsIgnoreCase("failed")) {
                        printama.printTextEpos("Reason: " + orderDetail.failed_reason, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        // WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Reason: " + orderDetail.failed_reason, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    printama.printTextEpos(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    printama.printTextEpos("Thanks", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                    //WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Thanks", WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                    //WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);

                    printama.setCutPaper();
                    printama.close();
                }, this::displayErrorMessage);

            } catch (Exception e) {
                e.printStackTrace();
                FirebaseCrashlytics.getInstance().recordException(e);
            }
        }).start();
        CommonFunctions.functionThatDelay(100);
    }

    public void openCashDrawer() {
        try {
            new Thread(() -> {
                try {
                    Printama.with(mContext).connect(printama -> {
                        printama.openCashDrawer();
                        printama.close();
                    }, this::displayErrorMessage);
                } catch (Exception e) {
                    FirebaseCrashlytics.getInstance().recordException(e);
                    e.printStackTrace();
                }
            }).start();
            CommonFunctions.functionThatDelay(200);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openCashDrawer(boolean close) {
        try {
            new Thread(() -> {
                try {
                    Printama.with(mContext).connect(Printama::openCashDrawer, this::displayErrorMessage);
                    if (close) {
                        Printama.with(mContext).close();
                    }
                } catch (Exception e) {
                    FirebaseCrashlytics.getInstance().recordException(e);
                    e.printStackTrace();
                }
            }).start();
            CommonFunctions.functionThatDelay(200);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                }
                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(parts1[1].trim(), charatersInLine);
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                }
                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(part.trim(), charatersInLine);

            }

        }
        return subAddonName;
    }

    public static String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    public static String padLeftSpace(String str, int n) {
        return String.format("%1$" + n + "s", str);
    }

    private static List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    private void displayErrorMessage(String message) {

    }

}
