package com.ubsidi.epos_2021.comman.printer;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

import woyou.aidlservice.jiuiv5.ICallback;
import woyou.aidlservice.jiuiv5.IWoyouService;


public class AidlUtil {

    private static final String SERVICE＿PACKAGE = "woyou.aidlservice.jiuiv5";
    private static final String SERVICE＿ACTION = "woyou.aidlservice.jiuiv5.IWoyouService";

    private IWoyouService woyouService;
    private static AidlUtil mAidlUtil = new AidlUtil();

    public static final class Alignment {
        public static final int LEFT = 0;
        public static final int CENTER = 1;
        public static final int RIGHT = 2;

        public Alignment() {
        }
    }

    private AidlUtil() {
    }

    public static AidlUtil getInstance() {
        return mAidlUtil;
    }

    public void connectPrinterService(Activity context) {
        Intent intent = new Intent();
        intent.setPackage(SERVICE＿PACKAGE);
        intent.setAction(SERVICE＿ACTION);
        context.getApplicationContext().startService(intent);
        context.getApplicationContext().bindService(intent, connService, Context.BIND_AUTO_CREATE);
    }

    public boolean isConnect() {
        return woyouService != null;
    }

    private ServiceConnection connService = new ServiceConnection() {

        @Override
        public void onServiceDisconnected(ComponentName name) {
            woyouService = null;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            woyouService = IWoyouService.Stub.asInterface(service);
        }
    };


    public void printText(String content, float size, boolean isBold, boolean isUnderLine, int alligment) {
        if (woyouService == null) {
            Log.e("PRINTER_NOT_CONNECT", "PRINTER DISCONNECTED");
            return;
        }

        try {
            if (isBold) {
                woyouService.sendRAWData(ESCUtil.boldOn(), null);
            } else {
                woyouService.sendRAWData(ESCUtil.boldOff(), null);
            }

            if (isUnderLine) {
                woyouService.sendRAWData(ESCUtil.underlineWithOneDotWidthOn(), null);
            } else {
                woyouService.sendRAWData(ESCUtil.underlineOff(), null);
            }
            woyouService.setAlignment(alligment, null);
            woyouService.printTextWithFont(content, null, size, null);
            woyouService.lineWrap(1, null);
        } catch (RemoteException e) {
            e.printStackTrace();
        }

    }

    public static final class Size {
        public static final float SIZE0 = 30;
        public static final float SIZE1 = 40;
        public static final float SIZE2 = 50;
        public static final float SIZE3 = 60;
        public static final float SIZE4 = 70;
        public static final float SIZE5 = 80;
    }

    public void openCashDrawer() {
        if (woyouService == null) {
            Log.e("SUNMI_PRINTER_LOG", "Printer Not Connected");
            return;
        }
        try {
            woyouService.openDrawer(new ICallback() {
                @Override
                public void onRunResult(boolean isSuccess) throws RemoteException {

                }

                @Override
                public void onReturnString(String result) throws RemoteException {

                }

                @Override
                public void onRaiseException(int code, String msg) throws RemoteException {

                }

                @Override
                public void onPrintResult(int code, String msg) throws RemoteException {

                }

                @Override
                public IBinder asBinder() {
                    return null;
                }
            });
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void CutPaper() {
        if (woyouService == null) {
            Log.e("SUNMI_PRINTER_LOG", "Printer Not Connected");
            return;
        }

        try {
            woyouService.lineWrap(4, null);
            woyouService.cutPaper(null);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void printBitmap(Bitmap bitmap) {
        try {
            if (woyouService == null) {
                return;
            }
            try {
                woyouService.setAlignment(1, null);
                woyouService.printBitmap(bitmap, null);
                woyouService.lineWrap(2, null);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnectPrinterService(Context context) {
        if (woyouService != null) {
            context.getApplicationContext().unbindService(connService);
            woyouService = null;
        }
    }

    public void printBitmap(Bitmap bitmap, int orientation) {
        if (woyouService == null) {
            return;
        }

        try {
//            if(orientation == 0){
//                woyouService.printBitmap(bitmap, null);
//                woyouService.printText("横向排列\n", null);
//                woyouService.printBitmap(bitmap, null);
//                woyouService.printText("横向排列\n", null);
//            }else{
            woyouService.printBitmap(bitmap, null);
            //woyouService.printText("\n纵向排列\n", null);
            //woyouService.printBitmap(bitmap, null);
            //woyouService.printText("\n纵向排列\n", null);
            //}
            woyouService.lineWrap(2, null);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}
