package com.ubsidi.epos_2021.comman.printer;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;

import com.imin.library.SystemPropManager;
import com.imin.printerlib.IminPrintUtils;
import com.sunmi.printerx.enums.Align;
import com.sunmi.printerx.style.TextStyle;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.merchant.models.RestaurantUser;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.ReportTextModel;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SendOrderWifiModel;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.SurChargesModel;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderProductDetail;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.zqprintersdk.PrinterConst;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;

public class IMinPrinterUtils {
    private IminPrintUtils mIminPrintUtils;
    private RestaurantUser loggedInRestaurant;

    public IMinPrinterUtils(Context currentActivity) {
        initIMinPrinter(currentActivity);
    }

    private void initIMinPrinter(Context currentActivity) {
        if (mIminPrintUtils == null) {
            mIminPrintUtils = IminPrintUtils.getInstance(currentActivity);

        }
        mIminPrintUtils.resetUSBDevice();
        final String deviceModel = SystemPropManager.getModel();
        if (TextUtils.equals("M2-202", deviceModel) || TextUtils.equals("M2-203", deviceModel) || TextUtils.equals("M2-Pro", deviceModel)) {
            mIminPrintUtils.initPrinter(IminPrintUtils.PrintConnectType.SPI);
        } else if (TextUtils.equals("S1-701", deviceModel) || TextUtils.equals("S1-702", deviceModel)) {
            mIminPrintUtils.initPrinter(IminPrintUtils.PrintConnectType.USB);
        } else if (TextUtils.equals("D1p-601", deviceModel) || TextUtils.equals("D1p-602", deviceModel)
                || TextUtils.equals("D1p-603", deviceModel) || TextUtils.equals("D1p-604", deviceModel)
                || TextUtils.equals("D1w-701", deviceModel) || TextUtils.equals("D1w-702", deviceModel)
                || TextUtils.equals("D1w-703", deviceModel) || TextUtils.equals("D1w-704", deviceModel)
                || TextUtils.equals("D4-501", deviceModel) || TextUtils.equals("D4-502", deviceModel)
                || TextUtils.equals("D4-503", deviceModel) || TextUtils.equals("D4-504", deviceModel)
                || deviceModel.startsWith("D4-505") || TextUtils.equals("M2-Max", deviceModel)
                || TextUtils.equals("D1", deviceModel) || TextUtils.equals("D1-Pro", deviceModel)
                || TextUtils.equals("Swift 1", deviceModel) || TextUtils.equals("I22T01", deviceModel)
                || TextUtils.equals("TF1-11", deviceModel) || TextUtils.equals("D3-510", deviceModel)) {
            mIminPrintUtils.initPrinter(IminPrintUtils.PrintConnectType.USB);
        }
        loggedInRestaurant = MyApp.getInstance().myPreferences.getLoggedInRestaurant();
    }

    DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);

    public void printOrderEpos(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, MyPreferences myPreferences) {
        SiteSetting printBlockBill = MyApp.getInstance().findSetting("print_block_bill");
        int style = 0, widthSize = 0, heightSize = 0, alignment = 0;

        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");

        try {
            if (!kitchenCopy && tiffintomLogo != null) {
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
            }

            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(0);
            if (!kitchenCopy) {
                if (headerAlignment < 2)
                    mIminPrintUtils.printText(ticket_header, PrinterConst.Alignment.CENTER);
                else {
                    String[] headers = ticket_header.split("\n");
                    for (String h : headers) {
                        mIminPrintUtils.printText(padLeftSpace(h, 35), PrinterConst.Alignment.CENTER);
                    }
                }
            }

            if (structure.header_order_type.visibility && kitchenCopy) {
                switch (structure.header_order_type.style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.header_order_type.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.header_order_type.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("** " + orderTypeHeading + " **", PrinterConst.Alignment.CENTER);
                    //zonerich.Prn_PrintText("** " + orderTypeHeading + " **" + "\n", alignment, style, widthSize | heightSize);
                }

            }

            if (structure.header_customer_name != null) {
                if (structure.header_customer_name.visibility && kitchenCopy) {
                    switch (structure.header_customer_name.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) {
                        mIminPrintUtils.printText(orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                    }
                }
            }
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);

            if (structure.title.visibility && kitchenCopy) {
                switch (structure.title.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.title.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.title.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(title)) {
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("" + title + "", PrinterConst.Alignment.CENTER);
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }
            }

            if (structure.order_no.visibility) {
                switch (structure.order_no.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.order_no.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.order_no.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.setAlignment(0);
                if(Validators.isNullOrEmpty(orderDetail.display_order_id)){
                    mIminPrintUtils.printText("Order No: " + orderDetail._id, PrinterConst.Alignment.CENTER);
                }else {
                    mIminPrintUtils.printText("Order No: " + orderDetail.display_order_id, PrinterConst.Alignment.CENTER);
                }
                if (kitchenCopy)
                    mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }

            if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                switch (structure.table_no.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.table_no.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.table_no.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.setAlignment(0);

                switch (structure.no_of_diners.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.no_of_diners.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.no_of_diners.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                mIminPrintUtils.printText("Table No: " + orderDetail.table_number + "  No of Diner: " + orderDetail.no_guest, PrinterConst.Alignment.CENTER);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            } else if (structure.table_no.visibility && orderType == 1) {
                switch (structure.table_no.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.table_no.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.table_no.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.printText("Table No: " + orderDetail.table_number, PrinterConst.Alignment.CENTER);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            } else if (structure.no_of_diners.visibility && orderType == 1) {
                switch (structure.no_of_diners.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.no_of_diners.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.no_of_diners.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.printText("No of Diner: " + orderDetail.no_guest, PrinterConst.Alignment.CENTER);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }
            String orderDate = null, orderTime = null;
            if (orderDetail.created_at.contains("Z")) {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
            } else {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
            }
            if (structure.order_date != null) {
                if (structure.order_date.visibility) {
                    switch (structure.order_date.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_date.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_date.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDate)) {
                       /* mIminPrintUtils.setAlignment(0);
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);*/
                    }
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    if (structure.order_time != null && structure.order_time.visibility) {
                        mIminPrintUtils.printText("Date :" + orderDate + " " + " Time :" + orderTime, PrinterConst.Alignment.CENTER);
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    } else {
                        mIminPrintUtils.printText("Date :" + orderDate + " ", PrinterConst.Alignment.CENTER);
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);

                    }
                }

            }
            if (structure.order_time != null) {
                if (structure.order_time.visibility) {
                    switch (structure.order_time.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_time.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderTime)) {
                        if (structure.order_date != null && !structure.order_date.visibility) {
                            mIminPrintUtils.setAlignment(0);
                            mIminPrintUtils.setTextSize(25);
                            mIminPrintUtils.sethaveBold(false);
                            mIminPrintUtils.printText("Time :" + orderTime, PrinterConst.Alignment.CENTER);
                            mIminPrintUtils.setTextSize(30);
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                        }
                    }
                }

            }

/*
            else {
                if (!Validators.isNullOrEmpty(dateTimeMode)) {
                    String dateFormat = "dd-MM-yyyy hh:mm a";
                    String dateFormatTitle = "Order Date Time: ";
                    if (dateTimeMode.equalsIgnoreCase("date_time")) {
                        dateFormat = "dd-MM-yyyy hh:mm a";
                        dateFormatTitle = "Order Date Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("time")) {
                        dateFormat = "hh:mm a";
                        dateFormatTitle = "Order Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("date")) {
                        dateFormat = "dd-MM-yyyy";
                        dateFormatTitle = "Order Date: ";
                    }
                    if (orderDetail.created_at.contains("Z")) {
                        zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat) + "\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);

                    } else {
                        zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, dateFormat) + "\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }
                }

            }
*/
            if (orderType > 1 && !kitchenCopy) {
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.printText("Order Type: " + orderDetail.order_type, PrinterConst.Alignment.CENTER);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }

            if (structure.items_header.visibility) {
                switch (structure.items_header.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items_header.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items_header.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.printText("Qty  Name", PrinterConst.Alignment.CENTER);
            }

            if (structure.items.visibility) {
                switch (structure.items.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                String itemName = "", price = "", qty = "";
                String lastBlockId = null;
                boolean lastItemWasMisc = false;
                int position = 1;
                for (OrderItem productDetail : orderDetail.order_items) {
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                    String productQty;
                    if (kitchenCopy) {
                        productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                    } else {
                        productQty = String.valueOf(productDetail.quantity);
                    }

                    qty = productQty;

                    if (productQty.length() <= 1) {
                        qty = productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }

                    int length = String.valueOf(formatter.format(productDetail.total)).length();
                    String format = null;
                    if (length <= 7 && length > 2) {
                        if (length == 4) {
                            format = "    " + formatter.format(productDetail.total);
                        }
                        if (length == 5) {
                            format = "   " + formatter.format(productDetail.total);
                        }

                        if (length == 6) {
                            format = "  " + formatter.format(productDetail.total);
                        }
                        if (length == 7) {
                            format = " " + formatter.format(productDetail.total);
                        }
                    } else {
                        format = formatter.format(productDetail.total);
                    }
                    price = (!kitchenCopy) ? format : "";
                    if (kitchenCopy)
                        itemName = qty + productName;
                    else {
                        position = position + 1;
                        String[] strings3 = new String[]{"", qty + productName, price};
                        int[] colsWidthArr3 = new int[]{0, 8, 2};
                        int[] colsAlign3 = new int[]{0, 0, 2};
                        int[] colsSize3 = new int[]{26, 26, 26};
                        mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                                colsAlign3, colsSize3);
                       /* if (length == 3)
                            itemName = getProductNameWithPad(qty + productName, price, 40);
                        else if (length <= 8 && length >= 4)
                            itemName = getProductNameWithPad(qty + productName, price, 39);
                        else
                            itemName = getProductNameWithPad(qty + productName, price, 38);*/
                    }

                    if (lastBlockId != null) {
                        if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                            if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                mIminPrintUtils.setTextSize(30);
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                        }
                    } else {
                        if (lastItemWasMisc && !productDetail.misc) {
                            if (kitchenCopy)
                                mIminPrintUtils.setTextSize(30);
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                        }
                    }

                    String printItem;
                    printItem = itemName + "";

                    if (kitchenCopy) {
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.sethaveBold(true);
                    } else {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                    }
                    mIminPrintUtils.setAlignment(0);
                    if (kitchenCopy) {
                        mIminPrintUtils.setTextSize(38);
                        mIminPrintUtils.printText(printItem, PrinterConst.Alignment.CENTER);
                    }
                    if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                        mIminPrintUtils.printText("  " + "Instruction: " + productDetail.special_instruction, PrinterConst.Alignment.CENTER);

                    if (productDetail.order_item_addons.size() > 0) {
                        if (structure.items_subaddon.visibility) {
                            int subStyle, subWidthSize, subHeightSize, subAlignment;
                            switch (structure.items_subaddon.style) {
                                case "default":
                                    subStyle = PrinterConst.Font.DEFAULT;
                                    break;
                                case "bold":
                                    subStyle = PrinterConst.Font.BOLD;
                                    break;
                                case "underline":
                                    subStyle = PrinterConst.Font.UNDERLINE;
                                    break;
                                case "reverse":
                                    subStyle = PrinterConst.Font.REVERSE;
                                    break;
                                default:
                                    subStyle = PrinterConst.Font.DEFAULT;
                                    break;
                            }

                            switch (structure.items_subaddon.size) {
                                case "size0":
                                    subWidthSize = PrinterConst.WidthSize.SIZE0;
                                    subHeightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                                case "size1":
                                    subWidthSize = PrinterConst.WidthSize.SIZE1;
                                    subHeightSize = PrinterConst.HeightSize.SIZE1;
                                    break;
                                case "size2":
                                    subWidthSize = PrinterConst.WidthSize.SIZE2;
                                    subHeightSize = PrinterConst.HeightSize.SIZE2;
                                    break;
                                case "size3":
                                    subWidthSize = PrinterConst.WidthSize.SIZE3;
                                    subHeightSize = PrinterConst.HeightSize.SIZE3;
                                    break;
                                default:
                                    subWidthSize = PrinterConst.WidthSize.SIZE0;
                                    subHeightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                            }

                            switch (structure.items_subaddon.alignment) {
                                case "left":
                                    subAlignment = PrinterConst.Alignment.LEFT;
                                    break;
                                case "center":
                                    subAlignment = PrinterConst.Alignment.CENTER;
                                    break;
                                case "right":
                                    subAlignment = PrinterConst.Alignment.RIGHT;
                                    break;
                                default:
                                    subAlignment = PrinterConst.Alignment.LEFT;
                                    break;
                            }
                            mIminPrintUtils.printText("Choose Your Base:", PrinterConst.Alignment.CENTER);
                        }

                        for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                            List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                            if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                continue;
                            }

                            String subdomainPrintText;
                            if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                // commenting the condition as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                /*if (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                } else {*/
                                if (orderItemAddon.quantity > 1) {
                                    subdomainPrintText = "  " + orderItemAddon.quantity + " " + orderItemAddon.addon_name + "\n";
                                } else {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                }
                                //}
                            } else {
                                length = String.valueOf(formatter.format(orderItemAddon.total)).length();
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        format = "    " + formatter.format(orderItemAddon.total);
                                    }
                                    if (length == 5) {
                                        format = "   " + formatter.format(orderItemAddon.total);
                                    }

                                    if (length == 6) {
                                        format = "  " + formatter.format(orderItemAddon.total);
                                    }
                                    if (length == 7) {
                                        format = " " + formatter.format(orderItemAddon.total);
                                    }
                                } else {
                                    format = formatter.format(orderItemAddon.total);
                                }
                                productName = orderItemAddon.addon_name;
                                price = (!kitchenCopy) ? format : "";
                                productQty = "" + orderItemAddon.quantity;
                                qty = productQty;

                                if (productQty.length() <= 1) {
                                    qty = productQty + " ";
                                } else if (productQty.length() <= 2) {
                                    qty = productQty + " ";

                                } else if (productQty.length() <= 3) {
                                    qty = productQty + " ";

                                } else if (productQty.length() <= 4) {
                                    qty = productQty + "";
                                }

                                if (kitchenCopy)
                                    itemName = qty + productName;
                                else {
                                    if (length == 3)
                                        itemName = getProductNameWithPad(qty + productName, price, 40);
                                    else if (length <= 8 && length >= 4)
                                        itemName = getProductNameWithPad(qty + productName, price, 39);
                                    else
                                        itemName = getProductNameWithPad(qty + productName, price, 38);
                                }
                                subdomainPrintText = itemName;
                            }
                            mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                        }
                    }

                    for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                        String ingredientName = orderItemIngredient.ingredient_name;
                        if (orderItemIngredient.with) {
                            ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                        }
                        if (orderItemIngredient.without) {
                            ingredientName = "  " + "No " + ingredientName;
                        }
                        String subdomainPrintText = ingredientName + "\n";
                        mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                    }

                    lastItemWasMisc = productDetail.misc;
                    lastBlockId = productDetail.block_id;
                }
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }

            if (printTotalInPrint) {
                if (structure.subtotal.visibility) {
                    switch (structure.subtotal.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.subtotal.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.subtotal.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.setAlignment(2);
                    mIminPrintUtils.printText("Sub Total: " + MyApp.df.format(orderDetail.sub_total), PrinterConst.Alignment.CENTER);
                }

                if (structure.gratuity.visibility) {
                    switch (structure.gratuity.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.gratuity.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.gratuity.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.gratuity > 0) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.setAlignment(2);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.printText("Gratuity: " + MyApp.df.format(orderDetail.gratuity), PrinterConst.Alignment.CENTER);
                    }
                }

                if (structure.discount.visibility) {
                    switch (structure.discount.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.discount.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.discount.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.discount > 0) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.setAlignment(2);
                        mIminPrintUtils.printText("Discount: " + MyApp.df.format(orderDetail.discount), PrinterConst.Alignment.CENTER);
                    }
                }

                if (structure.delivery_charge.visibility) {
                    switch (structure.delivery_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.delivery_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.delivery_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.delivery_charge > 0) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.setAlignment(2);
                        mIminPrintUtils.printText("Delivery Charge: " + MyApp.df.format(orderDetail.delivery_charge), PrinterConst.Alignment.CENTER);
                    }
                }

                if (structure.service_charge.visibility) {
                    switch (structure.service_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.service_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.service_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.service_charge > 0) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.setAlignment(2);
                        mIminPrintUtils.printText("Service Charge: " + MyApp.df.format(orderDetail.service_charge), PrinterConst.Alignment.CENTER);
                    }
                }

                if (structure.grand_total.visibility) {
                    switch (structure.grand_total.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.grand_total.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.grand_total.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.printText("Total: " + MyApp.df.format(orderDetail.total), PrinterConst.Alignment.CENTER);
                }

                if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                        structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility)
                    mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }
            if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                if (structure.payment_detail_header != null)
                    if (structure.payment_detail_header.visibility) {
                        switch (structure.payment_detail_header.style) {
                            case "default":
                                style = PrinterConst.Font.DEFAULT;
                                break;
                            case "bold":
                                style = PrinterConst.Font.BOLD;
                                break;
                            case "underline":
                                style = PrinterConst.Font.UNDERLINE;
                                break;
                            case "reverse":
                                style = PrinterConst.Font.REVERSE;
                                break;
                            default:
                                style = PrinterConst.Font.DEFAULT;
                                break;
                        }

                        switch (structure.payment_detail_header.size) {
                            case "size0":
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                            case "size1":
                                widthSize = PrinterConst.WidthSize.SIZE1;
                                heightSize = PrinterConst.HeightSize.SIZE1;
                                break;
                            case "size2":
                                widthSize = PrinterConst.WidthSize.SIZE2;
                                heightSize = PrinterConst.HeightSize.SIZE2;
                                break;
                            case "size3":
                                widthSize = PrinterConst.WidthSize.SIZE3;
                                heightSize = PrinterConst.HeightSize.SIZE3;
                                break;
                            default:
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                        }

                        switch (structure.payment_detail_header.alignment) {
                            case "left":
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = PrinterConst.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = PrinterConst.Alignment.RIGHT;
                                break;
                            default:
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                        }
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("Payment Details: " + MyApp.df.format(orderDetail.total), PrinterConst.Alignment.CENTER);

                    }

                if (structure.payment_detail != null)
                    if (structure.payment_detail.visibility) {
                        switch (structure.payment_detail.style) {
                            case "default":
                                style = PrinterConst.Font.DEFAULT;
                                break;
                            case "bold":
                                style = PrinterConst.Font.BOLD;
                                break;
                            case "underline":
                                style = PrinterConst.Font.UNDERLINE;
                                break;
                            case "reverse":
                                style = PrinterConst.Font.REVERSE;
                                break;
                            default:
                                style = PrinterConst.Font.DEFAULT;
                                break;
                        }

                        switch (structure.payment_detail.size) {
                            case "size0":
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                            case "size1":
                                widthSize = PrinterConst.WidthSize.SIZE1;
                                heightSize = PrinterConst.HeightSize.SIZE1;
                                break;
                            case "size2":
                                widthSize = PrinterConst.WidthSize.SIZE2;
                                heightSize = PrinterConst.HeightSize.SIZE2;
                                break;
                            case "size3":
                                widthSize = PrinterConst.WidthSize.SIZE3;
                                heightSize = PrinterConst.HeightSize.SIZE3;
                                break;
                            default:
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                        }

                        switch (structure.payment_detail.alignment) {
                            case "left":
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = PrinterConst.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = PrinterConst.Alignment.RIGHT;
                                break;
                            default:
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                        }


                        for (OrderPayment orderPayment : orderDetail.order_payments) {
                            String paymentDetailToPrint = null;
                            if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                            } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                            } else {
                                paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                            }
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.setTextSize(25);
                            mIminPrintUtils.sethaveBold(true);
                            mIminPrintUtils.printText(paymentDetailToPrint, PrinterConst.Alignment.CENTER);
                        }
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    } else {
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    }
            }

            if (structure.serve_by.visibility) {
                switch (structure.serve_by.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.serve_by.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.serve_by.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.printText("Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username, PrinterConst.Alignment.CENTER);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }

            if (structure.customer_detail != null)
                if (structure.customer_detail.visibility) {
                    switch (structure.customer_detail.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.customer_detail.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.customer_detail.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.printText("Cust Name: " + orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                    }

                    if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                        mIminPrintUtils.printText("Cust No: " + orderDetail.customer.mobile, PrinterConst.Alignment.CENTER);
                    }

                    String fulladdress = null;
                    if (orderType == 3) {
                        fulladdress = "Address: " + orderDetail.customer.house_no + ","
                                + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                        mIminPrintUtils.printText(fulladdress, PrinterConst.Alignment.CENTER);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)) {
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    }

                }


            if (structure.payment_status.visibility) {
                switch (structure.payment_status.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.payment_status.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.payment_status.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.setAlignment(0);
                if (orderDetail.total_paid == 0) {
                    mIminPrintUtils.printText("Payment Status: " + settingMap.get("unpaid_payment_title"), PrinterConst.Alignment.CENTER);
                } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                    mIminPrintUtils.printText("Payment Status: " + settingMap.get("paid_payment_title"), PrinterConst.Alignment.CENTER);
                } else if (orderDetail.total_paid > 0) {
                    mIminPrintUtils.printText("Payment Status: " + settingMap.get("partial_payment_title"), PrinterConst.Alignment.CENTER);
                }
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }
            if (structure.order_comment != null) {
                if (structure.order_comment.visibility) {
                    switch (structure.order_comment.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_comment.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_comment.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.printText("Comment: " + orderDetail.comment, PrinterConst.Alignment.CENTER);
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    }
                }
            } else {
                if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    if (kitchenCopy) {
                        mIminPrintUtils.printText("Comment: " + orderDetail.comment, PrinterConst.Alignment.CENTER);
                    } else {
                        mIminPrintUtils.printText("Comment: " + orderDetail.comment, PrinterConst.Alignment.CENTER);
                    }
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }
            }
            if (structure.footer_order_type.visibility && kitchenCopy) {
                switch (structure.footer_order_type.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_order_type.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_order_type.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                    ///mIminPrintUtils.setTextSize(30);
                    //mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    if (kitchenCopy) {
                        mIminPrintUtils.setTextSize(35);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.sethaveBold(true);
                        mIminPrintUtils.printText("** " + orderTypeHeading + " **", PrinterConst.Alignment.CENTER);
                    }
                }
            }
            // footer table number
            if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                switch (structure.footer_table_number.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_table_number.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_table_number.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.printText("Table No: " + orderDetail.table_number, PrinterConst.Alignment.CENTER);
                }
            }
            // footer order number
            if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                switch (structure.footer_order_number.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_order_number.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_order_number.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.printText("Order No: " + orderDetail.display_order_id, PrinterConst.Alignment.CENTER);
                }else {
                    if (orderDetail._id != 0) {
                        mIminPrintUtils.setTextSize(35);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.sethaveBold(true);
                        mIminPrintUtils.printText("Order No: " + orderDetail._id, PrinterConst.Alignment.CENTER);
                    }
                }
            }
            if (structure.header_customer_name != null) {
                if (structure.header_customer_name.visibility && kitchenCopy) {
                    switch (structure.header_customer_name.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.printText(orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                    }
                }
            }
            if (structure.footer.visibility) {
                switch (structure.footer.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.sethaveBold(false);
                if (!Validators.isNullOrEmpty(footerA)) {
                    mIminPrintUtils.printText(footerA, PrinterConst.Alignment.CENTER);
                }
                if (!Validators.isNullOrEmpty(footerB)) {
                    mIminPrintUtils.printText(footerB, PrinterConst.Alignment.CENTER);
                }
            }

            if(!kitchenCopy && MyApp.getInstance().paymentLinkBitmap!=null){
                mIminPrintUtils.printText("\n", PrinterConst.Alignment.LEFT);
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printSingleBitmap(MyApp.getInstance().paymentLinkBitmap, 2500);
            }
            mIminPrintUtils.printText("\n\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.partialCut();
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    public void printSeparator() {
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.setAlignment(1);
        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
    }

    public void setTextStyle(int textSize, int style, int alignment) {
        mIminPrintUtils.setTextSize(textSize);
        mIminPrintUtils.sethaveBold(style == 2);
        mIminPrintUtils.setAlignment(alignment);
    }

    public void setTotalView(String title,String price){
        String[] strings3 = new String[]{"", title, price };
        int[] colsWidthArr3 = new int[]{0, 8, 2};
        int[] colsAlign3 = new int[]{0, 0, 2};
        int[] colsSize3 = new int[]{26, 26, 26};
        mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                colsAlign3, colsSize3);
    }

    public void printOrderEposFoodHubSeqeunce(ArrayList<PrintStyle> listPrintStructure, Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy) {
        SiteSetting printBlockBill = MyApp.getInstance().findSetting("print_block_bill");
        int style = 0, alignment = 0, textSize = 0,widthSize;

        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");

        try {
            String orderDate = null, orderTime = null;
            if (orderDetail.created_at.contains("Z")) {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
            } else {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
            }
            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                switch (listPrintStructure.get(i).style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }
                switch (listPrintStructure.get(i).size) {
                    case "size1":
                    case "size3":
                    case "size2":
                        textSize = 35;
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        textSize = 25;
                        break;
                }
                switch (listPrintStructure.get(i).alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                boolean isSpeartor = listPrintStructure.get(i).separator;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean isBlockName = listPrintStructure.get(i).block_name;
                boolean priceInItems = listPrintStructure.get(i).price;
                setTextStyle(textSize, style, alignment);
                switch (key) {
                    case "logo": {
                        if (!kitchenCopy && tiffintomLogo != null) {
                            mIminPrintUtils.setAlignment(0);
                            mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                            mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "ticket_header": {
                        setTextStyle(textSize, style, alignment);
                        if (!kitchenCopy) {
                            if (headerAlignment < 2)
                                mIminPrintUtils.printText(ticket_header, PrinterConst.Alignment.CENTER);
                            else {
                                String[] headers = ticket_header.split("\n");
                                for (String h : headers) {
                                    mIminPrintUtils.printText(padLeftSpace(h, 35), PrinterConst.Alignment.CENTER);
                                }
                            }
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "header_order_type": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                                setTextStyle(textSize, style, alignment);
                                mIminPrintUtils.printText("" + orderTypeHeading + "", PrinterConst.Alignment.CENTER);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }

                        }
                        break;
                    }
                    case "header_customer_name": {
                        if (kitchenCopy) {
                            if (orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) {
                                setTextStyle(textSize, style, alignment);
                                mIminPrintUtils.printText(orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "title": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(title)) {
                                setTextStyle(textSize, style, alignment);
                                mIminPrintUtils.printText("" + title + "", PrinterConst.Alignment.CENTER);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "order_no": {
                        setTextStyle(textSize, style, alignment);
                        if(Validators.isNullOrEmpty(orderDetail.display_order_id)){
                            mIminPrintUtils.printText("Order No: " + orderDetail._id, PrinterConst.Alignment.CENTER);
                        }else {
                            mIminPrintUtils.printText("Order No: " + orderDetail.display_order_id, PrinterConst.Alignment.CENTER);
                        }
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "table_no": {
                        if (orderType == 1) {
                            setTextStyle(textSize, style, alignment);
                            mIminPrintUtils.printText("Table No: " + orderDetail.table_number, PrinterConst.Alignment.CENTER);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "no_of_diners": {
                        if (orderType == 1) {
                            setTextStyle(textSize, style, alignment);
                            mIminPrintUtils.printText("No of Diner: " + orderDetail.no_guest, PrinterConst.Alignment.CENTER);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_date": {
                        if (!Validators.isNullOrEmpty(orderDate)) {
                            setTextStyle(textSize, style, alignment);
                            if (structure.order_time != null && structure.order_time.visibility) {
                                mIminPrintUtils.printText("Date :" + orderDate + " " + " Time :" + orderTime, PrinterConst.Alignment.CENTER);
                            } else {
                                mIminPrintUtils.printText("Date :" + orderDate + " ", PrinterConst.Alignment.CENTER);
                            }
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_time": {
                        if (structure.order_date != null && !structure.order_date.visibility) {
                            setTextStyle(textSize, style, alignment);
                            mIminPrintUtils.printText("Time :" + orderTime, PrinterConst.Alignment.CENTER);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "items_header": {
                        if (orderType > 1 && !kitchenCopy) {
                            mIminPrintUtils.setAlignment(0);
                            mIminPrintUtils.setTextSize(25);
                            mIminPrintUtils.sethaveBold(false);
                            mIminPrintUtils.printText("Order Type: " + orderDetail.order_type, PrinterConst.Alignment.CENTER);
                            printSeparator();
                        }
                        setTextStyle(textSize, style, alignment);
                        mIminPrintUtils.printText("Qty  Name", PrinterConst.Alignment.CENTER);
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "items": {
                        String itemName = "", price = "", qty = "";
                        String lastBlockId = null;
                        boolean lastItemWasMisc = false;
                        int position = 0;
                        for (OrderItem productDetail : orderDetail.order_items) {
                            position = position + 1;
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                            String productQty;
                            if (kitchenCopy) {
                                productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                            } else {
                                productQty = String.valueOf(productDetail.quantity);
                            }

                            qty = productQty;

                            if (productQty.length() <= 1) {
                                qty = productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }

                            int length = String.valueOf(formatter.format(productDetail.total)).length();
                            String format = null;
                            if (length <= 7 && length > 2) {
                                if (length == 4) {
                                    format = "    " + formatter.format(productDetail.total);
                                }
                                if (length == 5) {
                                    format = "   " + formatter.format(productDetail.total);
                                }

                                if (length == 6) {
                                    format = "  " + formatter.format(productDetail.total);
                                }
                                if (length == 7) {
                                    format = " " + formatter.format(productDetail.total);
                                }
                            } else {
                                format = formatter.format(productDetail.total);
                            }
                            setTextStyle(textSize, style, alignment);
                            price = (priceInItems) ? format : "";
                            if (!priceInItems)
                                itemName = qty + productName;
                            else {
                                String[] strings3 = new String[]{"", qty + productName, price};
                                int[] colsWidthArr3 = new int[]{0, 8, 2};
                                int[] colsAlign3 = new int[]{0, 0, 2};
                                int[] colsSize3 = new int[]{26, 26, 26};
                                mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                                        colsAlign3, colsSize3);
                            }
                            if (!all_separator) {
                                if (lastBlockId != null) {
                                    if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                        if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes"))){
                                            printBlockText(productDetail,isBlockName);
                                        }
                                    }
                                } else {
                                    if (lastItemWasMisc && !productDetail.misc) {
                                        if (kitchenCopy)
                                            printBlockText(productDetail,isBlockName);
                                    }
                                }
                            }

                            String printItem;
                            printItem = itemName + "";

                            if (!priceInItems) {
                                mIminPrintUtils.printText(printItem, PrinterConst.Alignment.CENTER);
                            }
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                mIminPrintUtils.printText("  " + "Instruction: " + productDetail.special_instruction, PrinterConst.Alignment.CENTER);

                            if (productDetail.order_item_addons.size() > 0) {
                                int subStyle, subWidthSize, subTextSize, subAlignment;
                                switch (structure.items_subaddon.style) {
                                    case "bold":
                                        subStyle = PrinterConst.Font.BOLD;
                                        break;
                                    case "underline":
                                        subStyle = PrinterConst.Font.UNDERLINE;
                                        break;
                                    case "reverse":
                                        subStyle = PrinterConst.Font.REVERSE;
                                        break;
                                    default:
                                        subStyle = PrinterConst.Font.DEFAULT;
                                        break;
                                }

                                switch (structure.items_subaddon.size) {
                                    case "size1":
                                    case "size3":
                                    case "size2":
                                        subTextSize = 35;
                                        break;
                                    default:
                                        subTextSize = 25;
                                        break;
                                }

                                switch (structure.items_subaddon.alignment) {
                                    case "center":
                                        subAlignment = PrinterConst.Alignment.CENTER;
                                        break;
                                    case "right":
                                        subAlignment = PrinterConst.Alignment.RIGHT;
                                        break;
                                    default:
                                        subAlignment = PrinterConst.Alignment.LEFT;
                                        break;
                                }
                                if (structure.items_subaddon.visibility) {
                                    setTextStyle(subTextSize, subStyle, subAlignment);
                                    mIminPrintUtils.printText("Choose Your Base:", PrinterConst.Alignment.CENTER);
                                }
                                setTextStyle(subTextSize, subStyle, subAlignment);
                                for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                    List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                    if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                        continue;
                                    }

                                    String subdomainPrintText;
                                    if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                        // commenting the condition as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                /*if (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                } else {*/
                                        if (orderItemAddon.quantity > 1) {
                                            subdomainPrintText = "- " + orderItemAddon.quantity + "x " + orderItemAddon.addon_name + "\n";
                                        } else {
                                            if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()){
                                                subdomainPrintText = "" + orderItemAddon.addon_name + "\n";
                                            }else {
                                                subdomainPrintText = "- 1x " + orderItemAddon.addon_name + "\n";
                                            }
                                        }
                                        //}
                                    } else {
                                        length = String.valueOf(formatter.format(orderItemAddon.total)).length();
                                        if (length <= 7 && length > 2) {
                                            if (length == 4) {
                                                format = "    " + formatter.format(orderItemAddon.total);
                                            }
                                            if (length == 5) {
                                                format = "   " + formatter.format(orderItemAddon.total);
                                            }

                                            if (length == 6) {
                                                format = "  " + formatter.format(orderItemAddon.total);
                                            }
                                            if (length == 7) {
                                                format = " " + formatter.format(orderItemAddon.total);
                                            }
                                        } else {
                                            format = formatter.format(orderItemAddon.total);
                                        }
                                        productName = orderItemAddon.addon_name;
                                        price = (!kitchenCopy) ? format : "";
                                        productQty = "-" + orderItemAddon.quantity;
                                        qty = productQty;

                                        if (productQty.length() <= 1) {
                                            qty = productQty + "x ";
                                        } else if (productQty.length() <= 2) {
                                            qty = productQty + "x ";

                                        } else if (productQty.length() <= 3) {
                                            qty = productQty + "x ";

                                        } else if (productQty.length() <= 4) {
                                            qty = productQty + "x";
                                        }

                                        if (kitchenCopy)
                                            itemName = qty + productName;
                                        else {
                                            if (length == 3)
                                                itemName = getProductNameWithPad(qty + productName, price, 40);
                                            else if (length <= 8 && length >= 4)
                                                itemName = getProductNameWithPad(qty + productName, price, 39);
                                            else
                                                itemName = getProductNameWithPad(qty + productName, price, 38);
                                        }
                                        subdomainPrintText = itemName;
                                    }
                                    mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                                }
                            }

                            for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                                String ingredientName = orderItemIngredient.ingredient_name;
                                if (orderItemIngredient.with) {
                                    ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                                }
                                if (orderItemIngredient.without) {
                                    ingredientName = "  " + "No " + ingredientName;
                                }
                                String subdomainPrintText = ingredientName + "\n";
                                mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                            }

                            lastItemWasMisc = productDetail.misc;
                            lastBlockId = productDetail.block_id;
                            if(all_separator && orderDetail.order_items.size()>position){
                              printSeparator();
                            }
                            if (!all_separator && isBlockName) {
                                mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
                            }
                        }
                        if(isSpeartor){
                            printSeparator();
                        }
                        break;
                    }
                    case "subtotal":
                    case "gratuity":
                    case "delivery_charge":
                    case "service_charge":
                    case "grand_total":
                    case "discount":{
                        if(printTotalInPrint){
                            setTextStyle(textSize, style, alignment);
                            String formattedValue="" ;
                            String titleOfTotal="" ;
                            if(key.equalsIgnoreCase("gratuity")){
                                if (orderDetail.gratuity > 0){
                                    formattedValue = MyApp.df.format(orderDetail.gratuity);
                                }
                                titleOfTotal ="GRATUITY";
                            }else  if(key.equalsIgnoreCase("discount")){
                                if (orderDetail.discount > 0)
                                    formattedValue = MyApp.df.format(orderDetail.discount);
                                titleOfTotal ="DISCOUNT";
                            }else  if(key.equalsIgnoreCase("grand_total")){
                                if (orderDetail.total > 0)
                                    formattedValue = MyApp.df.format(orderDetail.total );
                                titleOfTotal ="TOTAL";
                            }else  if(key.equalsIgnoreCase("service_charge")){
                                if (orderDetail.service_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.service_charge);
                                titleOfTotal ="SERVICE CHARGE";
                            }else  if(key.equalsIgnoreCase("delivery_charge")){
                                if (orderDetail.delivery_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.delivery_charge);
                                titleOfTotal ="DELIVERY CHARGE";
                            }else if(key.equalsIgnoreCase("subtotal")){
                                formattedValue = MyApp.df.format(orderDetail.sub_total);
                                titleOfTotal ="SUB TOTAL";
                            }
                            if(!Validators.isNullOrEmpty(formattedValue)){
                                int length = formattedValue.length();
                                String price = null;
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        price = "    " + formattedValue;
                                    }
                                    if (length == 5) {
                                        price = "   " + formattedValue;
                                    }

                                    if (length == 6) {
                                        price = "  " + formattedValue;
                                    }
                                    if (length == 7) {
                                        price = " " + formattedValue;
                                    }
                                } else {
                                    price = formatter.format(orderDetail.sub_total);
                                }
                                String[] strings3 = new String[]{"", titleOfTotal, price};
                                int[] colsWidthArr3 = new int[]{0, 8, 2};
                                int[] colsAlign3 = new int[]{0, 0, 2};
                                int[] colsSize3 = new int[]{26, 26, 26};
                                mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                                        colsAlign3, colsSize3);
                                if(isSpeartor){
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "payment_detail_header":{
                        setTextStyle(textSize, style, alignment);
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("Payment Details: " + MyApp.df.format(orderDetail.total), PrinterConst.Alignment.CENTER);
                        if(isSpeartor){
                            printSeparator();
                        }
                        break;
                    }
                    case "order_payments":{
                        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                            setTextStyle(textSize, style, alignment);
                            for (OrderPayment orderPayment : orderDetail.order_payments) {
                                String paymentDetailToPrint = null;
                                if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                    paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                    paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else {
                                    paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                }
                                mIminPrintUtils.setAlignment(1);
                                mIminPrintUtils.setTextSize(25);
                                mIminPrintUtils.sethaveBold(true);
                                mIminPrintUtils.printText(paymentDetailToPrint, PrinterConst.Alignment.CENTER);
                            }
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "serve_by":{
                        setTextStyle(textSize, style, alignment);
                        mIminPrintUtils.printText("Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username, PrinterConst.Alignment.CENTER);
                        if(isSpeartor){
                            printSeparator();
                        }
                        break;
                    }
                    case "customer_detail":{
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            mIminPrintUtils.setTextSize(25);
                            mIminPrintUtils.sethaveBold(false);
                            mIminPrintUtils.printText("" + orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                        }
                        String fulladdress = null;
                        if (orderType == 3) {
                            fulladdress = formatAddress(orderDetail);
                            mIminPrintUtils.printText(fulladdress, PrinterConst.Alignment.CENTER);
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                            mIminPrintUtils.printText("" + orderDetail.customer.mobile, PrinterConst.Alignment.CENTER);
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)){
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_status":{
                        if (orderDetail.total_paid == 0) {
                            mIminPrintUtils.printText("" + settingMap.get("unpaid_payment_title").toUpperCase(), PrinterConst.Alignment.CENTER);
                        } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                            mIminPrintUtils.printText("" + settingMap.get("paid_payment_title").toUpperCase(), PrinterConst.Alignment.CENTER);
                        } else if (orderDetail.total_paid > 0) {
                            mIminPrintUtils.printText("" + settingMap.get("partial_payment_title").toUpperCase(), PrinterConst.Alignment.CENTER);
                        }
                        if(isSpeartor){
                            printSeparator();
                        }
                        break;
                    }
                    case "order_comment":{
                        if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                            mIminPrintUtils.printText("Comment: " + orderDetail.comment, PrinterConst.Alignment.CENTER);
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "footer_order_type":{
                        if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                            if (kitchenCopy) {
                                mIminPrintUtils.printText("" + orderTypeHeading + "", PrinterConst.Alignment.CENTER);
                                if(isSpeartor){
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer_table_number":{
                        if (!Validators.isNullOrEmpty(orderDetail.table_number) && kitchenCopy) {
                            mIminPrintUtils.printText("Table No: " + orderDetail.table_number, PrinterConst.Alignment.CENTER);
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "footer_order_number":{
                        if (!Validators.isNullOrEmpty(orderDetail.display_order_id) && kitchenCopy) {
                            mIminPrintUtils.printText("Order No: " + orderDetail.display_order_id, PrinterConst.Alignment.CENTER);
                        }else {
                            if (orderDetail._id != 0 && kitchenCopy) {
                                mIminPrintUtils.printText("Order No: " + orderDetail._id, PrinterConst.Alignment.CENTER);
                            }
                        }
                        break;
                    }
                    case "footer":{
                        if (!Validators.isNullOrEmpty(footerA)) {
                            mIminPrintUtils.printText(footerA, PrinterConst.Alignment.CENTER);
                        }
                        if (!Validators.isNullOrEmpty(footerB)) {
                            mIminPrintUtils.printText(footerB, PrinterConst.Alignment.CENTER);
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                }
            }
            if(!kitchenCopy && MyApp.getInstance().paymentLinkBitmap!=null){
                mIminPrintUtils.printText("\n", PrinterConst.Alignment.LEFT);
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printSingleBitmap(MyApp.getInstance().paymentLinkBitmap, 2500);
            }
            mIminPrintUtils.printText("\n\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.partialCut();
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    private void printBlockText(OrderItem productDetail,boolean isBlockName){
        try {
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            if(Validators.isNullOrEmpty(productDetail.block_name) || !isBlockName){
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }else {
                mIminPrintUtils.printText(MyApp.getInstance().getBlockText(48,productDetail.block_name)+"\n", PrinterConst.Alignment.CENTER);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private String formatAddress(Order orderDetail){
        String fulladdress = "";
        if(orderDetail.customer!=null) {

            if (Validators.isNullOrEmpty(orderDetail.customer.house_no)) {
                fulladdress = orderDetail.customer.street + "\n";
            } else {
                fulladdress = "" + orderDetail.customer.house_no + " " + orderDetail.customer.street + "\n";
            }
            if (!Validators.isNullOrEmpty(orderDetail.customer.city)) {
                fulladdress = fulladdress + "" + orderDetail.customer.city;

                if (!Validators.isNullOrEmpty(orderDetail.customer.postcode)) {
                    fulladdress = fulladdress + " " + orderDetail.customer.postcode;
                }
            }
        }
        return fulladdress;
    }

    private String formatTotal(float widthSize,String titleOfTotal,String totalValue){
        int lengthForSize =(widthSize==PrinterConst.WidthSize.SIZE0?39:27) - (titleOfTotal.length()+totalValue.length());
        StringBuilder finalTitle = new StringBuilder(titleOfTotal);
        for (int space=0;space<lengthForSize;space++){
            finalTitle.append(" ");
        }
        finalTitle.append(totalValue);
        return finalTitle.toString();
    }

    public void printOrderEposNew(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, PrintStructure structure, boolean printTotalInPrint, String footerA, String footerB, String orderTypeHeader, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        int style = 0, widthSize = 0, heightSize = 0, alignment = 0;
        SiteSetting printBlockBill = MyApp.getInstance().findSetting("print_block_bill");
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");
        try {
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(0);
            if (!kitchenCopy && tiffintomLogo != null) {
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
            }

            if (!kitchenCopy) {

                if (headerAlignment < 2)
                    mIminPrintUtils.printText(ticket_header, PrinterConst.Alignment.CENTER);
                else {
                    String[] headers = ticket_header.split("\n");
                    for (String h : headers) {
                        mIminPrintUtils.printText(padLeftSpace(h, 35), PrinterConst.Alignment.CENTER);
                    }
                }
            }
            if (kitchenCopy) {
                if (structure.header_order_type.visibility && kitchenCopy) {
                    switch (structure.header_order_type.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_order_type.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_order_type.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderTypeHeader)) {
                        mIminPrintUtils.setTextSize(35);
                        mIminPrintUtils.sethaveBold(true);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("** " + orderTypeHeader + " **", PrinterConst.Alignment.CENTER);
                    }

                }
                // footer table number
                if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                    switch (structure.footer_table_number.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.footer_table_number.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.footer_table_number.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                        mIminPrintUtils.setTextSize(35);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.sethaveBold(true);
                        mIminPrintUtils.printText("Table No: " + orderDetail.table_number, PrinterConst.Alignment.CENTER);
                    }
                }
                // footer order number
                if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                    switch (structure.footer_order_number.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.footer_order_number.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.footer_order_number.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        mIminPrintUtils.setTextSize(35);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.sethaveBold(true);
                        mIminPrintUtils.printText("Order No: " + orderDetail.display_order_id, PrinterConst.Alignment.CENTER);
                    }else {
                        if (orderDetail._id != 0) {
                            mIminPrintUtils.setTextSize(35);
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.sethaveBold(true);
                            mIminPrintUtils.printText("Order No: " + orderDetail._id, PrinterConst.Alignment.CENTER);
                        }
                    }
                }
                if (structure.header_customer_name != null) {
                    if (structure.header_customer_name.visibility && kitchenCopy) {
                        switch (structure.header_customer_name.style) {
                            case "default":
                                style = PrinterConst.Font.DEFAULT;
                                break;
                            case "bold":
                                style = PrinterConst.Font.BOLD;
                                break;
                            case "underline":
                                style = PrinterConst.Font.UNDERLINE;
                                break;
                            case "reverse":
                                style = PrinterConst.Font.REVERSE;
                                break;
                            default:
                                style = PrinterConst.Font.DEFAULT;
                                break;
                        }

                        switch (structure.header_customer_name.size) {
                            case "size0":
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                            case "size1":
                                widthSize = PrinterConst.WidthSize.SIZE1;
                                heightSize = PrinterConst.HeightSize.SIZE1;
                                break;
                            case "size2":
                                widthSize = PrinterConst.WidthSize.SIZE2;
                                heightSize = PrinterConst.HeightSize.SIZE2;
                                break;
                            case "size3":
                                widthSize = PrinterConst.WidthSize.SIZE3;
                                heightSize = PrinterConst.HeightSize.SIZE3;
                                break;
                            default:
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                        }

                        switch (structure.header_customer_name.alignment) {
                            case "left":
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = PrinterConst.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = PrinterConst.Alignment.RIGHT;
                                break;
                            default:
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                        }
                        if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            mIminPrintUtils.setTextSize(25);
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.sethaveBold(false);
                            mIminPrintUtils.printText(orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                        }
                    }
                }
            }
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);

            if (structure.title.visibility) {
                switch (structure.title.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.title.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.title.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(title)) {
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("\n" + title + "\n", PrinterConst.Alignment.CENTER);
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }
            }
            if (structure.order_no != null) {
                if (structure.order_no.visibility) {
                    switch (structure.order_no.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_no.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_no.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    String orderIdText = null;
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        orderIdText = "Order ID: " + orderDetail._id;
                    } else
                        orderIdText = "Order ID: " + orderDetail.display_order_id;

                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText(orderIdText, PrinterConst.Alignment.CENTER);
                    if (kitchenCopy)
                        mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }
            } else {
                if (tableNumberOrderIdMode != null) {
                    String tableNumberOrderIdText = "";
                    if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                        } else
                            tableNumberOrderIdText = "Order ID: " + orderDetail.display_order_id;
                    }
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText(tableNumberOrderIdText, PrinterConst.Alignment.CENTER);
                }
            }

            if (structure.table_no != null && structure.no_of_diners != null) {
                if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                    switch (structure.table_no.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.table_no.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.table_no.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("Table No: " + orderDetail.table_number, PrinterConst.Alignment.CENTER);

                    switch (structure.no_of_diners.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.no_of_diners.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.no_of_diners.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("No of Diner: " + orderDetail.no_guest, PrinterConst.Alignment.CENTER);
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }
            } else {
                if (tableNumberOrderIdMode != null) {
                    String tableNumberOrderIdText = "";
                    if (orderType == 1 && (tableNumberOrderIdMode.equalsIgnoreCase("table_number") || tableNumberOrderIdMode.equalsIgnoreCase("both"))) {
                        if (tableNumberOrderIdText.length() > 1) {
                            tableNumberOrderIdText = tableNumberOrderIdText + "\n";
                        }
                        tableNumberOrderIdText = tableNumberOrderIdText + "Table No: " + orderDetail.table_number + "  No of Diners:  " + orderDetail.no_guest;
                    }

                    if (tableNumberOrderIdMode.equalsIgnoreCase("none")) {
                        tableNumberOrderIdText = "";
                    }

                    if (tableNumberOrderIdMode.length() > 0) {
                        if (!Validators.isNullOrEmpty(title)) {
                            tableNumberOrderIdText = "\n------------------------------------------------\n" + tableNumberOrderIdText + "\n------------------------------------------------\n";
                        } else {
                            tableNumberOrderIdText = tableNumberOrderIdText + "\n------------------------------------------------\n";
                        }

                        mIminPrintUtils.setTextSize(35);
                        mIminPrintUtils.sethaveBold(true);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText(tableNumberOrderIdText, PrinterConst.Alignment.CENTER);
                    }

                }

            }
            String orderDate = null, orderTime = null;
            if (orderDetail.created_at.contains("Z")) {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
            } else {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
            }

            if (structure.order_date != null) {
                if (structure.order_date.visibility) {
                    switch (structure.order_date.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_date.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_date.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    if (!Validators.isNullOrEmpty(orderDate))
                        if (structure.order_time != null && structure.order_time.visibility) {
                            mIminPrintUtils.printText("Date :" + orderDate + " ", PrinterConst.Alignment.CENTER);
                        } else {
                            mIminPrintUtils.printText("Date :" + orderDate + " ", PrinterConst.Alignment.CENTER);
                            mIminPrintUtils.setTextSize(30);
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);

                        }
                }

            }
            if (structure.order_time != null) {
                if (structure.order_time.visibility) {
                    switch (structure.order_time.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_time.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }
                    switch (structure.order_time.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    if (!Validators.isNullOrEmpty(orderTime)) {
                        mIminPrintUtils.setAlignment(0);
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.printText("Time :" + orderTime, PrinterConst.Alignment.CENTER);
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    }
                }
            }

/*
            if (!Validators.isNullOrEmpty(dateTimeMode)) {
                String dateFormat = "dd-MM-yyyy hh:mm a";
                String dateFormatTitle = "Order Date Time: ";
                if (dateTimeMode.equalsIgnoreCase("date_time")) {
                    dateFormat = "dd-MM-yyyy hh:mm a";
                    dateFormatTitle = "Order Date Time: ";
                }
                if (dateTimeMode.equalsIgnoreCase("time")) {
                    dateFormat = "hh:mm a";
                    dateFormatTitle = "Order Time: ";
                }
                if (dateTimeMode.equalsIgnoreCase("date")) {
                    dateFormat = "dd-MM-yyyy";
                    dateFormatTitle = "Order Date: ";
                }
                if (orderDetail.created_at.contains("Z")) {
                    zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                } else {
                    zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, dateFormat) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
*/
            if (orderType > 1 && !kitchenCopy) {
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.printText("Order Type: " + orderDetail.order_type, PrinterConst.Alignment.CENTER);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }

            if (structure.items_header.visibility) {
                switch (structure.items_header.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items_header.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items_header.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.printText("Qty  Name" + orderDetail.order_type, PrinterConst.Alignment.CENTER);
            }

            if (structure.items.visibility) {
                switch (structure.items.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                String itemName = "", price = "", qty = "";
                String lastBlockId = null;
                boolean lastItemWasMisc = false;

                for (OrderItem productDetail : orderDetail.order_items) {
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                    String productQty = String.valueOf(productDetail.quantity);
                    qty = productQty;

                    if (productQty.length() <= 1) {
                        qty = productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }

                    int length = String.valueOf(formatter.format(productDetail.total)).length();
                    String format = null;
                    if (length <= 7 && length > 2) {
                        if (length == 4) {
                            format = "    " + formatter.format(productDetail.total);
                        }
                        if (length == 5) {
                            format = "   " + formatter.format(productDetail.total);
                        }

                        if (length == 6) {
                            format = "  " + formatter.format(productDetail.total);
                        }
                        if (length == 7) {
                            format = " " + formatter.format(productDetail.total);
                        }
                    } else {
                        format = formatter.format(productDetail.total);
                    }
                    price = (!kitchenCopy) ? format : "";
                    if (kitchenCopy)
                        itemName = qty + productName;
                    else {
                        if (length == 3)
                            itemName = getProductNameWithPad(qty + productName, price, 40);
                        else if (length <= 8 && length >= 4)
                            itemName = getProductNameWithPad(qty + productName, price, 39);
                        else
                            itemName = getProductNameWithPad(qty + productName, price, 38);
                    }

                    if (lastBlockId != null) {
                        if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                            if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                mIminPrintUtils.setTextSize(30);
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                        }
                    } else {
                        if (lastItemWasMisc && !productDetail.misc) {
                            if (kitchenCopy) {
                                mIminPrintUtils.setTextSize(30);
                                mIminPrintUtils.setAlignment(1);
                                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                            }
                        }
                    }

                    String printItem;
                    printItem = itemName + "\n";


                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.printText(printItem, PrinterConst.Alignment.CENTER);
                    if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                        mIminPrintUtils.printText("  " + "Instruction: " + productDetail.special_instruction, PrinterConst.Alignment.CENTER);

                    if (productDetail.order_item_addons.size() > 0) {
                        if (structure.items_subaddon.visibility) {
                            int subStyle, subWidthSize, subHeightSize, subAlignment;
                            switch (structure.items_subaddon.style) {
                                case "default":
                                    subStyle = PrinterConst.Font.DEFAULT;
                                    break;
                                case "bold":
                                    subStyle = PrinterConst.Font.BOLD;
                                    break;
                                case "underline":
                                    subStyle = PrinterConst.Font.UNDERLINE;
                                    break;
                                case "reverse":
                                    subStyle = PrinterConst.Font.REVERSE;
                                    break;
                                default:
                                    subStyle = PrinterConst.Font.DEFAULT;
                                    break;
                            }

                            switch (structure.items_subaddon.size) {
                                case "size0":
                                    subWidthSize = PrinterConst.WidthSize.SIZE0;
                                    subHeightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                                case "size1":
                                    subWidthSize = PrinterConst.WidthSize.SIZE1;
                                    subHeightSize = PrinterConst.HeightSize.SIZE1;
                                    break;
                                case "size2":
                                    subWidthSize = PrinterConst.WidthSize.SIZE2;
                                    subHeightSize = PrinterConst.HeightSize.SIZE2;
                                    break;
                                case "size3":
                                    subWidthSize = PrinterConst.WidthSize.SIZE3;
                                    subHeightSize = PrinterConst.HeightSize.SIZE3;
                                    break;
                                default:
                                    subWidthSize = PrinterConst.WidthSize.SIZE0;
                                    subHeightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                            }

                            switch (structure.items_subaddon.alignment) {
                                case "left":
                                    subAlignment = PrinterConst.Alignment.LEFT;
                                    break;
                                case "center":
                                    subAlignment = PrinterConst.Alignment.CENTER;
                                    break;
                                case "right":
                                    subAlignment = PrinterConst.Alignment.RIGHT;
                                    break;
                                default:
                                    subAlignment = PrinterConst.Alignment.LEFT;
                                    break;
                            }
                            mIminPrintUtils.printText("Choose Your Base:", PrinterConst.Alignment.CENTER);

                            for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                    continue;
                                }

                                String subdomainPrintText;
                                if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                    if (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                        subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                    } else {
                                        subdomainPrintText = "  " + orderItemAddon.quantity + " " + orderItemAddon.addon_name + "\n";
                                    }
                                } else {
                                    length = String.valueOf(formatter.format(orderItemAddon.total)).length();
                                    if (length <= 7 && length > 2) {
                                        if (length == 4) {
                                            format = "    " + formatter.format(orderItemAddon.total);
                                        }
                                        if (length == 5) {
                                            format = "   " + formatter.format(orderItemAddon.total);
                                        }

                                        if (length == 6) {
                                            format = "  " + formatter.format(orderItemAddon.total);
                                        }
                                        if (length == 7) {
                                            format = " " + formatter.format(orderItemAddon.total);
                                        }
                                    } else {
                                        format = formatter.format(orderItemAddon.total);
                                    }
                                    productName = orderItemAddon.addon_name;
                                    price = (!kitchenCopy) ? format : "";
                                    productQty = "" + orderItemAddon.quantity;
                                    qty = productQty;

                                    if (productQty.length() <= 1) {
                                        qty = productQty + " ";
                                    } else if (productQty.length() <= 2) {
                                        qty = productQty + " ";

                                    } else if (productQty.length() <= 3) {
                                        qty = productQty + " ";

                                    } else if (productQty.length() <= 4) {
                                        qty = productQty + "";
                                    }

                                    if (kitchenCopy)
                                        itemName = qty + productName;
                                    else {
                                        if (length == 3)
                                            itemName = getProductNameWithPad(qty + productName, price, 40);
                                        else if (length <= 8 && length >= 4)
                                            itemName = getProductNameWithPad(qty + productName, price, 39);
                                        else
                                            itemName = getProductNameWithPad(qty + productName, price, 38);
                                    }
                                    subdomainPrintText = itemName;
                                }

                                //String subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                            }
                        }
                    }

                    for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                        String ingredientName = orderItemIngredient.ingredient_name;
                        if (orderItemIngredient.with) {
                            ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                        }
                        if (orderItemIngredient.without) {
                            ingredientName = "  " + "No " + ingredientName;
                        }
                        String subdomainPrintText = ingredientName + "\n";
                        mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                    }

                    lastItemWasMisc = productDetail.misc;
                    lastBlockId = productDetail.block_id;
                }
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }

            if (printTotalInPrint) {
                if (structure.subtotal.visibility) {
                    switch (structure.subtotal.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.subtotal.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.subtotal.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.printText("Sub Total: " + MyApp.df.format(orderDetail.sub_total), PrinterConst.Alignment.CENTER);
                }
                if (structure.delivery_charge.visibility) {
                    switch (structure.delivery_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.delivery_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.delivery_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.delivery_charge > 0)
                        mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.printText("Delivery Charge: " + MyApp.df.format(orderDetail.delivery_charge), PrinterConst.Alignment.CENTER);
                }
                if (structure.gratuity.visibility) {
                    switch (structure.gratuity.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.gratuity.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.gratuity.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.gratuity > 0)
                        mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.printText("Gratuity: " + MyApp.df.format(orderDetail.gratuity), PrinterConst.Alignment.CENTER);
                }
                if (structure.service_charge.visibility) {
                    switch (structure.service_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.service_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.service_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.service_charge > 0)
                        mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.printText("Service Charge: " + MyApp.df.format(orderDetail.service_charge), PrinterConst.Alignment.CENTER);
                }
                if (structure.discount.visibility) {
                    switch (structure.discount.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.discount.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.discount.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.discount > 0)
                        mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.printText("Discount: " + MyApp.df.format(orderDetail.discount), PrinterConst.Alignment.CENTER);
                }
                if (structure.grand_total.visibility) {
                    switch (structure.grand_total.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.grand_total.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.grand_total.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.printText("Total: " + MyApp.df.format(orderDetail.total), PrinterConst.Alignment.CENTER);
                }

                if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                        structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility) {
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }

            }

            if (structure.payment_detail != null) {
                if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                    if (structure.payment_detail_header != null)
                        if (structure.payment_detail_header.visibility) {
                            switch (structure.payment_detail_header.style) {
                                case "default":
                                    style = PrinterConst.Font.DEFAULT;
                                    break;
                                case "bold":
                                    style = PrinterConst.Font.BOLD;
                                    break;
                                case "underline":
                                    style = PrinterConst.Font.UNDERLINE;
                                    break;
                                case "reverse":
                                    style = PrinterConst.Font.REVERSE;
                                    break;
                                default:
                                    style = PrinterConst.Font.DEFAULT;
                                    break;
                            }

                            switch (structure.payment_detail_header.size) {
                                case "size0":
                                    widthSize = PrinterConst.WidthSize.SIZE0;
                                    heightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                                case "size1":
                                    widthSize = PrinterConst.WidthSize.SIZE1;
                                    heightSize = PrinterConst.HeightSize.SIZE1;
                                    break;
                                case "size2":
                                    widthSize = PrinterConst.WidthSize.SIZE2;
                                    heightSize = PrinterConst.HeightSize.SIZE2;
                                    break;
                                case "size3":
                                    widthSize = PrinterConst.WidthSize.SIZE3;
                                    heightSize = PrinterConst.HeightSize.SIZE3;
                                    break;
                                default:
                                    widthSize = PrinterConst.WidthSize.SIZE0;
                                    heightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                            }

                            switch (structure.payment_detail_header.alignment) {
                                case "left":
                                    alignment = PrinterConst.Alignment.LEFT;
                                    break;
                                case "center":
                                    alignment = PrinterConst.Alignment.CENTER;
                                    break;
                                case "right":
                                    alignment = PrinterConst.Alignment.RIGHT;
                                    break;
                                default:
                                    alignment = PrinterConst.Alignment.LEFT;
                                    break;
                            }
                            mIminPrintUtils.setTextSize(25);
                            mIminPrintUtils.sethaveBold(false);
                            mIminPrintUtils.printText("Payment Details: " + MyApp.df.format(orderDetail.total), PrinterConst.Alignment.CENTER);
                        }

                    if (structure.payment_detail != null)
                        if (structure.payment_detail.visibility) {
                            switch (structure.payment_detail.style) {
                                case "default":
                                    style = PrinterConst.Font.DEFAULT;
                                    break;
                                case "bold":
                                    style = PrinterConst.Font.BOLD;
                                    break;
                                case "underline":
                                    style = PrinterConst.Font.UNDERLINE;
                                    break;
                                case "reverse":
                                    style = PrinterConst.Font.REVERSE;
                                    break;
                                default:
                                    style = PrinterConst.Font.DEFAULT;
                                    break;
                            }

                            switch (structure.payment_detail.size) {
                                case "size0":
                                    widthSize = PrinterConst.WidthSize.SIZE0;
                                    heightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                                case "size1":
                                    widthSize = PrinterConst.WidthSize.SIZE1;
                                    heightSize = PrinterConst.HeightSize.SIZE1;
                                    break;
                                case "size2":
                                    widthSize = PrinterConst.WidthSize.SIZE2;
                                    heightSize = PrinterConst.HeightSize.SIZE2;
                                    break;
                                case "size3":
                                    widthSize = PrinterConst.WidthSize.SIZE3;
                                    heightSize = PrinterConst.HeightSize.SIZE3;
                                    break;
                                default:
                                    widthSize = PrinterConst.WidthSize.SIZE0;
                                    heightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                            }

                            switch (structure.payment_detail.alignment) {
                                case "left":
                                    alignment = PrinterConst.Alignment.LEFT;
                                    break;
                                case "center":
                                    alignment = PrinterConst.Alignment.CENTER;
                                    break;
                                case "right":
                                    alignment = PrinterConst.Alignment.RIGHT;
                                    break;
                                default:
                                    alignment = PrinterConst.Alignment.LEFT;
                                    break;
                            }


                            for (OrderPayment orderPayment : orderDetail.order_payments) {
                                String paymentDetailToPrint = null;
                                if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                    paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                    paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else {
                                    paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                }
                                mIminPrintUtils.setTextSize(25);
                                mIminPrintUtils.sethaveBold(true);
                                mIminPrintUtils.printText(paymentDetailToPrint, PrinterConst.Alignment.CENTER);
                            }
                            mIminPrintUtils.setTextSize(30);
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                        } else {
                            mIminPrintUtils.setTextSize(30);
                            mIminPrintUtils.setAlignment(1);
                            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                        }
                }

            } else {
                if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.printText("Payment Details: " + MyApp.df.format(orderDetail.total), PrinterConst.Alignment.CENTER);
                    for (OrderPayment orderPayment : orderDetail.order_payments) {
                        String paymentDetailToPrint = null;
                        if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                            paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                        } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                            paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                        } else {
                            paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                        }
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(true);
                        mIminPrintUtils.printText(paymentDetailToPrint, PrinterConst.Alignment.CENTER);
                    }
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }

            }
            if (structure.serve_by != null) {
                if (structure.serve_by.visibility) {
                    switch (structure.serve_by.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.serve_by.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.serve_by.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.printText("Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username, PrinterConst.Alignment.CENTER);
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }
            } else {
                String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.printText(toprint, PrinterConst.Alignment.CENTER);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }

            if (structure.customer_detail != null) {
                if (structure.customer_detail.visibility) {
                    switch (structure.customer_detail.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.customer_detail.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.customer_detail.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.printText("Cust Name: " + orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                        mIminPrintUtils.printText("Cust No: " + orderDetail.customer.mobile, PrinterConst.Alignment.CENTER);
                    }

                    String fulladdress = null;
                    if (orderType == 3) {
                        fulladdress = "Address: " + orderDetail.customer.house_no + ","
                                + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                        mIminPrintUtils.printText(fulladdress, PrinterConst.Alignment.CENTER);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)) {
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    }
                }
            } else {
                if (!Validators.isNullOrEmpty(orderDetail.customer_name))
                    mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.printText("Cust Name: " + orderDetail.customer_name, PrinterConst.Alignment.CENTER);

                if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                    mIminPrintUtils.printText("Cust No: " + orderDetail.customer.mobile, PrinterConst.Alignment.CENTER);
                }
                String fulladdress = null;
                if (orderType == 3) {
                    fulladdress = "Address : " + orderDetail.customer.house_no + ","
                            + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                            orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                    mIminPrintUtils.printText(fulladdress, PrinterConst.Alignment.CENTER);
                }

                if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)) {
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }
            }

            if (structure.payment_status != null) {
                if (structure.payment_status.visibility) {
                    switch (structure.payment_status.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.payment_status.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.payment_status.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    if (orderDetail.total_paid == 0) {
                        mIminPrintUtils.printText("Payment Status: " + settingMap.get("unpaid_payment_title"), PrinterConst.Alignment.CENTER);
                    } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                        mIminPrintUtils.printText("Payment Status: " + settingMap.get("paid_payment_title"), PrinterConst.Alignment.CENTER);
                    } else if (orderDetail.total_paid > 0) {
                        mIminPrintUtils.printText("Payment Status: " + settingMap.get("partial_payment_title"), PrinterConst.Alignment.CENTER);
                    }
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }

            }
            if (structure.order_comment != null) {
                if (structure.order_comment.visibility) {
                    switch (structure.order_comment.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_comment.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_comment.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.printText("Comment: " + orderDetail.comment, PrinterConst.Alignment.CENTER);
                        mIminPrintUtils.setTextSize(30);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                    }
                }
            } else {
                if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                    mIminPrintUtils.setTextSize(25);
                    mIminPrintUtils.sethaveBold(false);
                    if (kitchenCopy) {
                        mIminPrintUtils.printText("Comment: " + orderDetail.comment, PrinterConst.Alignment.CENTER);
                    } else {
                        mIminPrintUtils.printText("Comment: " + orderDetail.comment, PrinterConst.Alignment.CENTER);
                    }
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
                }
            }

            if (structure.footer_order_type.visibility && kitchenCopy) {
                switch (structure.footer_order_type.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_order_type.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_order_type.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTypeHeader)) {
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.printText("** " + orderTypeHeader + " **", PrinterConst.Alignment.CENTER);
                }
            }
            if (structure.header_customer_name != null) {
                if (structure.header_customer_name.visibility && kitchenCopy) {
                    switch (structure.header_customer_name.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.printText(orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                    }
                }
            }

            if (structure.footer.visibility) {
                switch (structure.footer.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.sethaveBold(false);
                if (!Validators.isNullOrEmpty(footerA)) {
                    mIminPrintUtils.printText(footerA, PrinterConst.Alignment.CENTER);
                }
                if (!Validators.isNullOrEmpty(footerB)) {
                    mIminPrintUtils.printText(footerB, PrinterConst.Alignment.CENTER);
                }
            }

            mIminPrintUtils.printText("\n\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.partialCut();

            if (isCashDrawerOpen) {
                //mIminPrintUtils.Prn_OpenCashbox();
            }
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    public void printOrderEposNewFoodHub(ArrayList<PrintStyle> listPrintStructure,Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode,Order orderDetail, PrintStructure structure, boolean printTotalInPrint, String footerA, String footerB, String orderTypeHeader, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen) {
        int style = 0, alignment = 0, textSize = 0,widthSize=0;
        SiteSetting printBlockBill = MyApp.getInstance().findSetting("print_block_bill");
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");
        try {

            String orderDate = null, orderTime = null;
            if (orderDetail.created_at.contains("Z")) {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
            } else {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
            }
            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                switch (listPrintStructure.get(i).style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }
                switch (listPrintStructure.get(i).size) {
                    case "size1":
                    case "size3":
                    case "size2":
                        textSize = 35;
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        textSize = 25;
                        break;
                }
                switch (listPrintStructure.get(i).alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                boolean isSpeartor = listPrintStructure.get(i).separator;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean isBlockName = listPrintStructure.get(i).block_name;
                boolean priceInItems = listPrintStructure.get(i).price;
                setTextStyle(textSize, style, alignment);
                switch (key) {
                    case "logo": {
                        if (!kitchenCopy && tiffintomLogo != null) {
                            mIminPrintUtils.setAlignment(0);
                            mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                            mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "ticket_header": {
                        if (!kitchenCopy) {
                            if (headerAlignment < 2)
                                mIminPrintUtils.printText(ticket_header, PrinterConst.Alignment.CENTER);
                            else {
                                String[] headers = ticket_header.split("\n");
                                for (String h : headers) {
                                    mIminPrintUtils.printText(padLeftSpace(h, 35), PrinterConst.Alignment.CENTER);
                                }
                            }
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "header_order_type": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(orderTypeHeader)) {
                                mIminPrintUtils.printText("" + orderTypeHeader + "", PrinterConst.Alignment.CENTER);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }

                        }
                        break;
                    }
                    case "footer_order_number":{
                        if (!Validators.isNullOrEmpty(orderDetail.display_order_id) && kitchenCopy) {
                            mIminPrintUtils.printText("Order No: " + orderDetail.display_order_id, PrinterConst.Alignment.CENTER);
                        }else {
                            if (orderDetail._id != 0 && kitchenCopy) {
                                mIminPrintUtils.printText("Order No: " + orderDetail._id, PrinterConst.Alignment.CENTER);
                            }
                        }
                        break;
                    }
                    case "header_customer_name": {
                        if (kitchenCopy) {
                            if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                                mIminPrintUtils.printText(orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "title": {
                            if (!Validators.isNullOrEmpty(title)) {
                                mIminPrintUtils.printText("" + title + "", PrinterConst.Alignment.CENTER);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                        break;
                    }
                    case "order_no": {
                        String orderIdText = null;
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            orderIdText = "Order ID: " + orderDetail._id;
                        } else
                            orderIdText = "Order ID: " + orderDetail.display_order_id;
                        mIminPrintUtils.printText(orderIdText, PrinterConst.Alignment.CENTER);
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "table_no": {
                        if (orderType == 1) {
                            mIminPrintUtils.printText("Table No: " + orderDetail.table_number, PrinterConst.Alignment.CENTER);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "no_of_diners": {
                        if (orderType == 1) {
                            mIminPrintUtils.printText("No of Diner: " + orderDetail.no_guest, PrinterConst.Alignment.CENTER);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_date": {
                        if (!Validators.isNullOrEmpty(orderDate)) {
                            if (structure.order_time != null && structure.order_time.visibility) {
                                mIminPrintUtils.printText("Date :" + orderDate + " " + " Time :" + orderTime, PrinterConst.Alignment.CENTER);
                            } else {
                                mIminPrintUtils.printText("Date :" + orderDate + " ", PrinterConst.Alignment.CENTER);
                            }
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_time": {
                        if (structure.order_date != null && !structure.order_date.visibility) {
                            mIminPrintUtils.printText("Time :" + orderTime, PrinterConst.Alignment.CENTER);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "items_header": {
                        if (orderType > 1 && !kitchenCopy) {
                            mIminPrintUtils.setAlignment(0);
                            mIminPrintUtils.setTextSize(25);
                            mIminPrintUtils.sethaveBold(false);
                            mIminPrintUtils.printText("Order Type: " + orderDetail.order_type, PrinterConst.Alignment.CENTER);
                            printSeparator();
                        }
                        mIminPrintUtils.printText("Qty  Name", PrinterConst.Alignment.CENTER);
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "items": {
                        String itemName = "", price = "", qty = "";
                        String lastBlockId = null;
                        boolean lastItemWasMisc = false;
                        int position = 0;
                        for (OrderItem productDetail : orderDetail.order_items) {
                            position = position + 1;
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                            String productQty;
                            if (kitchenCopy) {
                                productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                            } else {
                                productQty = String.valueOf(productDetail.quantity);
                            }

                            qty = productQty;

                            if (productQty.length() <= 1) {
                                qty = productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }

                            int length = String.valueOf(formatter.format(productDetail.total)).length();
                            String format = null;
                            if (length <= 7 && length > 2) {
                                if (length == 4) {
                                    format = "    " + formatter.format(productDetail.total);
                                }
                                if (length == 5) {
                                    format = "   " + formatter.format(productDetail.total);
                                }

                                if (length == 6) {
                                    format = "  " + formatter.format(productDetail.total);
                                }
                                if (length == 7) {
                                    format = " " + formatter.format(productDetail.total);
                                }
                            } else {
                                format = formatter.format(productDetail.total);
                            }
                            setTextStyle(textSize, style, alignment);
                            price = (priceInItems) ? format : "";
                            if (!priceInItems)
                                itemName = qty + productName;
                            else {
                                String[] strings3 = new String[]{"", qty + productName, price};
                                int[] colsWidthArr3 = new int[]{0, 8, 2};
                                int[] colsAlign3 = new int[]{0, 0, 2};
                                int[] colsSize3 = new int[]{26, 26, 26};
                                mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                                        colsAlign3, colsSize3);
                            }
                            if (!all_separator) {
                                if (lastBlockId != null) {
                                    if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                        if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                            printBlockText(productDetail,isBlockName);
                                    }
                                } else {
                                    if (lastItemWasMisc && !productDetail.misc) {
                                        if (kitchenCopy)
                                            printBlockText(productDetail,isBlockName);
                                    }
                                }
                            }

                            String printItem;
                            printItem = itemName + "";

                            if (!priceInItems) {
                                mIminPrintUtils.printText(printItem, PrinterConst.Alignment.CENTER);
                            }
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                mIminPrintUtils.printText("  " + "Instruction: " + productDetail.special_instruction, PrinterConst.Alignment.CENTER);

                            if (productDetail.order_item_addons.size() > 0) {
                                int subStyle, subWidthSize, subTextSize, subAlignment;
                                switch (structure.items_subaddon.style) {
                                    case "bold":
                                        subStyle = PrinterConst.Font.BOLD;
                                        break;
                                    case "underline":
                                        subStyle = PrinterConst.Font.UNDERLINE;
                                        break;
                                    case "reverse":
                                        subStyle = PrinterConst.Font.REVERSE;
                                        break;
                                    default:
                                        subStyle = PrinterConst.Font.DEFAULT;
                                        break;
                                }

                                switch (structure.items_subaddon.size) {
                                    case "size1":
                                    case "size3":
                                    case "size2":
                                        subTextSize = 35;
                                        break;
                                    default:
                                        subTextSize = 25;
                                        break;
                                }

                                switch (structure.items_subaddon.alignment) {
                                    case "center":
                                        subAlignment = PrinterConst.Alignment.CENTER;
                                        break;
                                    case "right":
                                        subAlignment = PrinterConst.Alignment.RIGHT;
                                        break;
                                    default:
                                        subAlignment = PrinterConst.Alignment.LEFT;
                                        break;
                                }
                                if (structure.items_subaddon.visibility) {
                                    setTextStyle(subTextSize, subStyle, subAlignment);
                                    mIminPrintUtils.printText("Choose Your Base:", PrinterConst.Alignment.CENTER);
                                }
                                setTextStyle(subTextSize, subStyle, subAlignment);
                                for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                    List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                    if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                        continue;
                                    }

                                    String subdomainPrintText;
                                    if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                        // commenting the condition as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                /*if (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                } else {*/
                                        if (orderItemAddon.quantity > 1) {
                                            subdomainPrintText = "- " + orderItemAddon.quantity + "x " + orderItemAddon.addon_name + "\n";
                                        } else {
                                            if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()){
                                                subdomainPrintText = "" + orderItemAddon.addon_name + "\n";
                                            }else {
                                                subdomainPrintText = "- 1x " + orderItemAddon.addon_name + "\n";
                                            }
                                        }
                                        //}
                                    } else {
                                        length = String.valueOf(formatter.format(orderItemAddon.total)).length();
                                        if (length <= 7 && length > 2) {
                                            if (length == 4) {
                                                format = "    " + formatter.format(orderItemAddon.total);
                                            }
                                            if (length == 5) {
                                                format = "   " + formatter.format(orderItemAddon.total);
                                            }

                                            if (length == 6) {
                                                format = "  " + formatter.format(orderItemAddon.total);
                                            }
                                            if (length == 7) {
                                                format = " " + formatter.format(orderItemAddon.total);
                                            }
                                        } else {
                                            format = formatter.format(orderItemAddon.total);
                                        }
                                        productName = orderItemAddon.addon_name;
                                        price = (!kitchenCopy) ? format : "";
                                        productQty = "-" + orderItemAddon.quantity;
                                        qty = productQty;

                                        if (productQty.length() <= 1) {
                                            qty = productQty + "x ";
                                        } else if (productQty.length() <= 2) {
                                            qty = productQty + "x ";

                                        } else if (productQty.length() <= 3) {
                                            qty = productQty + "x ";

                                        } else if (productQty.length() <= 4) {
                                            qty = productQty + "x";
                                        }

                                        if (kitchenCopy)
                                            itemName = qty + productName;
                                        else {
                                            if (length == 3)
                                                itemName = getProductNameWithPad(qty + productName, price, 40);
                                            else if (length <= 8 && length >= 4)
                                                itemName = getProductNameWithPad(qty + productName, price, 39);
                                            else
                                                itemName = getProductNameWithPad(qty + productName, price, 38);
                                        }
                                        subdomainPrintText = itemName;
                                    }
                                    mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                                }
                            }

                            for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                                String ingredientName = orderItemIngredient.ingredient_name;
                                if (orderItemIngredient.with) {
                                    ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                                }
                                if (orderItemIngredient.without) {
                                    ingredientName = "  " + "No " + ingredientName;
                                }
                                String subdomainPrintText = ingredientName + "\n";
                                mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                            }

                            lastItemWasMisc = productDetail.misc;
                            lastBlockId = productDetail.block_id;
                            if(all_separator && orderDetail.order_items.size()>position){
                                printSeparator();
                            }
                            if (!all_separator && isBlockName) {
                                mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
                            }
                        }
                        if(isSpeartor){
                            printSeparator();
                        }
                        break;
                    }
                    case "subtotal":
                    case "gratuity":
                    case "delivery_charge":
                    case "service_charge":
                    case "grand_total":
                    case "discount":{
                        if(printTotalInPrint){
                            setTextStyle(textSize, style, alignment);
                            String formattedValue="" ;
                            String titleOfTotal="" ;
                            if(key.equalsIgnoreCase("gratuity")){
                                if (orderDetail.gratuity > 0){
                                    formattedValue = MyApp.df.format(orderDetail.gratuity);
                                }
                                titleOfTotal ="GRATUITY";
                            }else  if(key.equalsIgnoreCase("discount")){
                                if (orderDetail.discount > 0)
                                    formattedValue = MyApp.df.format(orderDetail.discount);
                                titleOfTotal ="DISCOUNT";
                            }else  if(key.equalsIgnoreCase("grand_total")){
                                if (orderDetail.total > 0)
                                    formattedValue = MyApp.df.format(orderDetail.total );
                                titleOfTotal ="TOTAL";
                            }else  if(key.equalsIgnoreCase("service_charge")){
                                if (orderDetail.service_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.service_charge);
                                titleOfTotal ="SERVICE CHARGE";
                            }else  if(key.equalsIgnoreCase("delivery_charge")){
                                if (orderDetail.delivery_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.delivery_charge);
                                titleOfTotal ="DELIVERY CHARGE";
                            }else if(key.equalsIgnoreCase("subtotal")){
                                formattedValue = MyApp.df.format(orderDetail.sub_total);
                                titleOfTotal ="SUB TOTAL";
                            }
                            if(!Validators.isNullOrEmpty(formattedValue)){
                                int length = formattedValue.length();
                                String price = null;
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        price = "    " + formattedValue;
                                    }
                                    if (length == 5) {
                                        price = "   " + formattedValue;
                                    }

                                    if (length == 6) {
                                        price = "  " + formattedValue;
                                    }
                                    if (length == 7) {
                                        price = " " + formattedValue;
                                    }
                                } else {
                                    price = formatter.format(orderDetail.sub_total);
                                }
                                String[] strings3 = new String[]{"", titleOfTotal, price};
                                int[] colsWidthArr3 = new int[]{0, 8, 2};
                                int[] colsAlign3 = new int[]{0, 0, 2};
                                int[] colsSize3 = new int[]{26, 26, 26};
                                mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                                        colsAlign3, colsSize3);
                                if(isSpeartor){
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "payment_detail_header":{
                        setTextStyle(textSize, style, alignment);
                        mIminPrintUtils.setTextSize(25);
                        mIminPrintUtils.sethaveBold(false);
                        mIminPrintUtils.setAlignment(1);
                        mIminPrintUtils.printText("Payment Details: " + MyApp.df.format(orderDetail.total), PrinterConst.Alignment.CENTER);
                        if(isSpeartor){
                            printSeparator();
                        }
                        break;
                    }
                    case "order_payments":{
                        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                            setTextStyle(textSize, style, alignment);
                            for (OrderPayment orderPayment : orderDetail.order_payments) {
                                String paymentDetailToPrint = null;
                                if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                    paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                    paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else {
                                    paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                }
                                mIminPrintUtils.setAlignment(1);
                                mIminPrintUtils.setTextSize(25);
                                mIminPrintUtils.sethaveBold(true);
                                mIminPrintUtils.printText(paymentDetailToPrint, PrinterConst.Alignment.CENTER);
                            }
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "serve_by":{
                        setTextStyle(textSize, style, alignment);
                        mIminPrintUtils.printText("Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username, PrinterConst.Alignment.CENTER);
                        if(isSpeartor){
                            printSeparator();
                        }
                        break;
                    }
                    case "customer_detail":{
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            mIminPrintUtils.setTextSize(25);
                            mIminPrintUtils.sethaveBold(false);
                            mIminPrintUtils.printText("" + orderDetail.customer_name, PrinterConst.Alignment.CENTER);
                        }
                        String fulladdress = null;
                        if (orderType == 3) {
                            fulladdress = formatAddress(orderDetail);
                            mIminPrintUtils.printText(fulladdress, PrinterConst.Alignment.CENTER);
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                            mIminPrintUtils.printText("" + orderDetail.customer.mobile, PrinterConst.Alignment.CENTER);
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)){
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_status":{
                        if (orderDetail.total_paid == 0) {
                            mIminPrintUtils.printText("" + settingMap.get("unpaid_payment_title").toUpperCase(), PrinterConst.Alignment.CENTER);
                        } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                            mIminPrintUtils.printText("" + settingMap.get("paid_payment_title").toUpperCase(), PrinterConst.Alignment.CENTER);
                        } else if (orderDetail.total_paid > 0) {
                            mIminPrintUtils.printText("" + settingMap.get("partial_payment_title").toUpperCase(), PrinterConst.Alignment.CENTER);
                        }
                        if(isSpeartor){
                            printSeparator();
                        }
                        break;
                    }
                    case "order_comment":{
                        if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                            mIminPrintUtils.printText("Comment: " + orderDetail.comment, PrinterConst.Alignment.CENTER);
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "footer_order_type":{
                        if (!Validators.isNullOrEmpty(orderTypeHeader)) {
                            if (kitchenCopy) {
                                mIminPrintUtils.printText("" + orderTypeHeader + "", PrinterConst.Alignment.CENTER);
                                if(isSpeartor){
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer_table_number":{
                        if (!Validators.isNullOrEmpty(orderDetail.table_number) && kitchenCopy) {
                            mIminPrintUtils.printText("Table No: " + orderDetail.table_number, PrinterConst.Alignment.CENTER);
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "footer":{
                        if (!Validators.isNullOrEmpty(footerA)) {
                            mIminPrintUtils.printText(footerA, PrinterConst.Alignment.CENTER);
                        }
                        if (!Validators.isNullOrEmpty(footerB)) {
                            mIminPrintUtils.printText(footerB, PrinterConst.Alignment.CENTER);
                            if(isSpeartor){
                                printSeparator();
                            }
                        }
                        break;
                    }
                }
            }
            mIminPrintUtils.printText("\n\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.partialCut();
            if (isCashDrawerOpen) {
                //mIminPrintUtils.Prn_OpenCashbox();
            }
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    public void printReservation(Reservation reservation, String title, String ticket_header, Bitmap tiffintomLogo) {
        try {
            if (tiffintomLogo != null) {
                mIminPrintUtils.setAlignment(0);
                mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printSingleBitmap(tiffintomLogo, 1500);
            }

            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText(title, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(ticket_header, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.setTextSize(35);
            if (!Validators.isNullOrEmpty(reservation.reservation_date_time)) {
                mIminPrintUtils.printText(reservation.reservation_date_time, PrinterConst.Alignment.CENTER);
            }
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("Reservation Id: #" + reservation.id, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.printText("Customer name     : " + reservation.customer_name, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Guest Count       : " + reservation.customer.no_guest, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Booking Email     : " + reservation.customer.email, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Booking Phone     : " + reservation.telephone, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Booking Status    : " + reservation.reservation_status, PrinterConst.Alignment.CENTER);
            if (reservation.reservation_status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                mIminPrintUtils.printText("Reason            : " + reservation.cancel_reason, PrinterConst.Alignment.CENTER);
            }
            mIminPrintUtils.printText("Booking Date/Time : \n" + reservation.reservation_date_time, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("Instructions      :" + reservation.special_instruction + "\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("\n\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.partialCut();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /*public void printMerchantPaymentReport(TransactionSummary transactionSummary, Bitmap bm, String header_a, String header_b, String footer_a, String footer_b) {
        if (bm != null) {
            mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printSingleBitmap(bm,2500);
        }
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.printText(header_a + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText(header_b + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.printText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        mIminPrintUtils.setTextSize(35);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.printText("Tiffintom Partner", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.printText("Transaction Report", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setAlignment(0);
        if (!Validators.isNullOrEmpty(transactionSummary.date_range)) {
            mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(transactionSummary.date_range+"\n", PrinterConst.Alignment.CENTER);
        }else{
            mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
        }
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.printText("Total Transaction              :" + transactionSummary.totalTransaction, PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("Total Refund Amount            :" + MyApp.df.format(transactionSummary.totalRefundAmount) + " GBP" , PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("Total Refund Transactions      :" + transactionSummary.totalRefundTransactions , PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("Total Successful Amount        :" + MyApp.df.format(transactionSummary.totalSuccessfulAmount) + " GBP"  , PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("Total Successful Transactions  :" + transactionSummary.totalSuccessfulTransactions   , PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.printText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.setAlignment(1);
        mIminPrintUtils.printText(footer_a + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText(footer_b + "\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printAndFeedPaper(3);
        mIminPrintUtils.fullCut();
    }*/

    public void printMotoReceipt(Bitmap bm, String title, String header, String header1, String address, String amount, String main_content, String date_final, String please, String footer, String footer1) {
        try {
            if (bm != null) {
                mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printSingleBitmap(bm, 2500);
                //mIminPrintUtils.printText("\n", PrinterConst.Alignment.LEFT);
            }
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(header + "", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            if (!Validators.isNullOrEmpty(address)) {
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.printText(header1, PrinterConst.Alignment.CENTER);
                mIminPrintUtils.printText(address + "\n", PrinterConst.Alignment.CENTER);
            } else {
                mIminPrintUtils.printText(header1 + "\n", PrinterConst.Alignment.CENTER);
            }
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.printText(title, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------ " + "\n", PrinterConst.Alignment.LEFT);
            amount = amount.replace("£", "");
            amount = amount.replace("\n", "");
            amount = amount + " GBP";
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(amount + "", PrinterConst.Alignment.CENTER);

            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.printText(main_content + "\n");
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText(date_final + "\n");
            mIminPrintUtils.printText(please + "", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.printText(footer + "", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText(footer1 + "\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.partialCut();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printCardReaderReceipt(Bitmap tiffintomLogo, String rePrintTitle, String title, String header, String header1, String address, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1) {
        if (tiffintomLogo != null) {
            mIminPrintUtils.setAlignment(PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
            //mIminPrintUtils.printText("\n", PrinterConst.Alignment.LEFT);
        }
        if (!Validators.isNullOrEmpty(header)) {
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(header + "", PrinterConst.Alignment.CENTER);
        }
        mIminPrintUtils.sethaveBold(true);
        if (!Validators.isNullOrEmpty(address)) {
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(header1 + "", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printText(address + "\n", PrinterConst.Alignment.CENTER);
        } else {
            mIminPrintUtils.printText(header1 + "\n", PrinterConst.Alignment.CENTER);
        }
        if (!Validators.isNullOrEmpty(rePrintTitle)) {
            mIminPrintUtils.printText(rePrintTitle + "", PrinterConst.Alignment.CENTER);
        }
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.setTextSize(35);
        mIminPrintUtils.printText(title + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.printText("------------------------------------------------ " + "\n", PrinterConst.Alignment.LEFT);
        if (!Validators.isNullOrEmpty(tip_amount)) {
            actual_amount = actual_amount.replace("£", "");
            actual_amount = actual_amount + " GBP";
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(actual_amount + "", PrinterConst.Alignment.CENTER);

            tip_amount = tip_amount.replace("£", "");
            tip_amount = tip_amount + " GBP";
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText(tip_amount + "", PrinterConst.Alignment.CENTER);
        }
        grand_total = grand_total.replace("£", "");
        grand_total = grand_total + " GBP";
        mIminPrintUtils.printText(grand_total + "", PrinterConst.Alignment.CENTER);

        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.setAlignment(0);
        mIminPrintUtils.printText(main_content + "\n");

        mIminPrintUtils.setAlignment(1);
        mIminPrintUtils.printText(please + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText(final_date + "\n");
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.printText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.printText(footer + "", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText(footer1 + "\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printAndFeedPaper(3);
        mIminPrintUtils.partialCut();
    }

    public void printOrderFoodHub(ArrayList<PrintStyle> listPrintStructure,Bitmap tiffintomLogo, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo, String onlineOrderPrintCount, Callable<Void> nextMethod) {
        int style = 0, alignment = 0, textSize = 0,widthSize=0;
        IminPrintUtils mIminPrintUtils = this.mIminPrintUtils;
        DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);
        int orderType = -1;
        String orderName = "";
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
            orderName = "Dine in";
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
            orderName = "Delivery";
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
            orderName = "Pickup";
        }
        formatter.applyPattern("00.00");
        try {
            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                switch (listPrintStructure.get(i).style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }
                switch (listPrintStructure.get(i).size) {
                    case "size1":
                    case "size3":
                    case "size2":
                        textSize = 35;
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        textSize = 25;
                        break;
                }
                switch (listPrintStructure.get(i).alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                boolean isSeparator = listPrintStructure.get(i).separator;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean priceInItems = listPrintStructure.get(i).price;
                setTextStyle(textSize, style, alignment);
                switch (key) {
                    case "logo": {
                        if (!orderTiffinTomLogo) {
                            if (tiffintomLogo != null) {
                                mIminPrintUtils.setAlignment(0);
                                mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
                                if(isSeparator){
                                    printSeparator();
                                }
                            }
                        } else {
                            if (businessLogo != null) {
                                mIminPrintUtils.setAlignment(0);
                                mIminPrintUtils.printSingleBitmap(businessLogo, 2500);
                                if(isSeparator){
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "online_title": {
                        String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                        String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy");
                        if (!todayDate.equalsIgnoreCase(orderDateString)) {
                            mIminPrintUtils.printText("This order is not for today", PrinterConst.Alignment.CENTER);
                            if(isSeparator){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_site": {
                        mIminPrintUtils.printText("Tiffintom.com sent you order", PrinterConst.Alignment.CENTER);
                        mIminPrintUtils.printText(orderName, PrinterConst.Alignment.CENTER);
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_no": {
                        mIminPrintUtils.printText("ORDER NO:" + orderDetail.order_number, PrinterConst.Alignment.CENTER);
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_type": {
                        if (orderType > 0) {
                            if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                                mIminPrintUtils.printText("ASAP", PrinterConst.Alignment.CENTER);
                            } else {
                                mIminPrintUtils.printText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", PrinterConst.Alignment.CENTER);
                            }
                            if(isSeparator){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_items":{
                        String itemName = "", price = "", qty = "",printBlockId=null;
                        int position =0;
                        int productPosition=0;
                        boolean isLastContainsLine=false;
                        for (OrderProductDetail productDetail : orderDetail.cart_view) {
                            productPosition = productPosition+1;
                            if (printBlockId == null) {
                                printBlockId = productDetail.print_block_id;
                            }
                            if (productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                                printBlockId = productDetail.print_block_id;
                                if (orderDetail.cart_view.size()-1 == productPosition) {
                                    isLastContainsLine = true;
                                }
                                printSeparator();
                            }
                            position = position+1;
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                            String productQty = String.valueOf(productDetail.quantity);
                            // Here we need 16 characters in product name so we send 16 in
                            // @params charactersInLine
                            price = (!kitchenCopy) ? formatter.format(productDetail.total_price) : "";
               /* if (kitchenCopy)
                    itemName = getProductNameWithPad(productName, price, 20);
                else
                    itemName = getProductNameWithPad(productName, price, 35);*/
                            qty = productQty;
                            if (productQty.length() <= 1) {
                                qty = " " + productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }
                            String printItem;
                            printItem = qty + itemName;
                            if (priceInItems) {
                                mIminPrintUtils.sethaveBold(false);
                                mIminPrintUtils.setAlignment(0);
                                mIminPrintUtils.setTextSize(25);
                                String[] strings3 = new String[]{"", qty + productName, price};
                                int[] colsWidthArr3 = new int[]{0, 8, 2};
                                int[] colsAlign3 = new int[]{0, 0, 2};
                                int[] colsSize3 = new int[]{26, 26, 26};
                                mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                                        colsAlign3, colsSize3);
                                //mIminPrintUtils.printText(printItem, PrinterConst.Alignment.CENTER);
                            } else {
                                printItem = printItem + productName;
                                mIminPrintUtils.sethaveBold(true);
                                mIminPrintUtils.setAlignment(0);
                                mIminPrintUtils.setTextSize(35);
                                mIminPrintUtils.printText(printItem, PrinterConst.Alignment.CENTER);
                            }

                            if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                                try {
                                    //String[] parts = menus.get(position).getSubaddonsName().split(",");
                                    String[] parts = productDetail.subaddons_name.split(",");

                                    for (String subAddonPart : parts) {
                                        if (!kitchenCopy) {
                                            mIminPrintUtils.sethaveBold(true);
                                            String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                            mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                                        } else {
                                            mIminPrintUtils.sethaveBold(true);
                                            String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                            mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                                        }
                                    }
                                } catch (Exception e) {
                                    Log.e("Addon_Error", e.getMessage());
                                }
                            }
                            if(all_separator && orderDetail.cart_view.size()>position){
                                printSeparator();
                            }
                        }
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_sub_total": {
                        setTotalView("SubTotal:", MyApp.df.format(orderDetail.order_sub_total));
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_delivery_charge": {
                        if (orderDetail.delivery_charge > 0) {
                           setTotalView("Delivery Charge:", MyApp.df.format(orderDetail.delivery_charge));
                            if(isSeparator){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_service_charge": {
                        if (orderDetail.service_charge > 0) {
                            if (loggedInRestaurant != null && !Validators.isNullOrEmpty(loggedInRestaurant.service_charge_status)) {
                                if (!"no".equalsIgnoreCase(loggedInRestaurant.service_charge_status)) {
                                    setTotalView("Service Charge:", MyApp.df.format(orderDetail.service_charge));
                                    if(isSeparator){
                                        printSeparator();
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case "online_offer": {
                        if (orderDetail.offer_amount > 0) {
                            setTotalView("Offer:", MyApp.df.format(orderDetail.offer_amount));
                            if(isSeparator){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_driver_tip": {
                        if (orderDetail.driver_tip > 0) {
                            setTotalView("Driver Tip:", MyApp.df.format(orderDetail.driver_tip));
                            if(isSeparator){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_loyalty": {
                        if (orderDetail.reward_offer > 0) {
                            setTotalView("Loyalty Point Discount:", MyApp.df.format(orderDetail.reward_offer));
                            if(isSeparator){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_grand_total": {
                        if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                            for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                                if (surChargesModel.surcharge_amount > 0) {
                                    mIminPrintUtils.printText(padRightSpaces(surChargesModel.surcharge_name, 20) + MyApp.df.format(surChargesModel.surcharge_amount), PrinterConst.Alignment.CENTER);
                                }
                            }
                        }
                        setTotalView("Grand Total: ", MyApp.df.format(orderDetail.order_grand_total));
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_comment": {
                        if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                            mIminPrintUtils.printText("Comments:" + orderDetail.order_description, PrinterConst.Alignment.LEFT);
                            if(isSeparator){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_customer_details": {
                        mIminPrintUtils.printText("" + orderDetail.customer_name + "\n", PrinterConst.Alignment.LEFT);
                        if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                            mIminPrintUtils.printText("" + orderDetail.customer_phone + "\n", PrinterConst.Alignment.LEFT);
                        }
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_delivery_address": {
                            if (orderType == 1 && !Validators.isNullOrEmpty(orderDetail.address)) {

                                String address = orderDetail.address;
                                String[] parts = address.split("[\\\\s,]+");
                                StringBuilder str = new StringBuilder();

                                for (String name : parts) {
                                    str.append(name).append("\n");
                                }
                                if(!Validators.isNullOrEmpty(address)){
                                    mIminPrintUtils.printText("" + address, PrinterConst.Alignment.LEFT);
                                    if(isSeparator){
                                        printSeparator();
                                    }
                                }
                            }
                        break;
                    }
                    case "online_requested_for": {
                        if (orderType >= 0) {
                            if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                                mIminPrintUtils.printText("Confirmed for:", PrinterConst.Alignment.LEFT);
                                mIminPrintUtils.printText(orderDetail.preparation + "\n", PrinterConst.Alignment.LEFT);
                                if(isSeparator){
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "online_payment_status": {
                        mIminPrintUtils.printText("" + (orderDetail.payment_status.equalsIgnoreCase("np") ? "UNPAID" : "PAID") + "\n", PrinterConst.Alignment.LEFT);
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_payment_method": {
                        String paymentName = "";
                        if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
                        if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                        if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                            paymentName = "WALLET";
                        if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";
                        mIminPrintUtils.printText("Payment Type:  " + paymentName + "\n", PrinterConst.Alignment.LEFT);
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_receipt_time": {
                        mIminPrintUtils.printText("Receipt Time:", PrinterConst.Alignment.LEFT);
                        mIminPrintUtils.printText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", PrinterConst.Alignment.LEFT);
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_status": {
                        mIminPrintUtils.printText("Order status: " + orderDetail.status + "\n", PrinterConst.Alignment.LEFT);
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                    case "online_failed_reason": {
                        if (orderDetail.status.equalsIgnoreCase("failed")) {
                            mIminPrintUtils.printText("Reason: " + orderDetail.failed_reason + "\n", PrinterConst.Alignment.LEFT);
                            if(isSeparator){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_restaurant_address": {
                        if (MyApp.getInstance().myPreferences.getLoggedInRestaurant() != null) {
                            mIminPrintUtils.printText(MyApp.getInstance().myPreferences.getLoggedInRestaurant().restaurant_name + ", " + MyApp.getInstance().myPreferences.getLoggedInRestaurant().contact_address + "\n", PrinterConst.Alignment.LEFT);
                            if(isSeparator){
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_footer": {
                        mIminPrintUtils.printText("Thanks!" + "\n", PrinterConst.Alignment.LEFT);
                        if(isSeparator){
                            printSeparator();
                        }
                        break;
                    }
                }
            }
            mIminPrintUtils.printText("\n\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.partialCut();
            //mIminPrintUtils.resetUSBDevice();
            if (kitchenCopy) {
                if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                    //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                    //zonerich.Prn_Disconnect();
                 /*   CommonFunctions.functionThatDelay(400);
                    CommonFunctions.functionThatDelay(400);*/
                    int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                    onlineOrderPrint = onlineOrderPrint - 1;
                    printOrderFoodHub(listPrintStructure,tiffintomLogo, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);

                    //}
                } else {
                    //zonerich.Prn_Disconnect();
                    if (nextMethod != null) {
                        nextMethod.call();
                    }
                }
            } else {
                if (nextMethod != null) {
                    nextMethod.call();
                }
                //zonerich.Prn_Disconnect();
            }
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public void printOrder(Bitmap tiffintomLogo, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo, String onlineOrderPrintCount, Callable<Void> nextMethod) {
        IminPrintUtils mIminPrintUtils = this.mIminPrintUtils;
        DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);
        int orderType = -1;
        String orderName = "";
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
            orderName = "Dine in";
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
            orderName = "Delivery";
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
            orderName = "Pickup";
        }
        formatter.applyPattern("00.00");
        try {
            if (!orderTiffinTomLogo) {
                if (tiffintomLogo != null) {
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.printSingleBitmap(tiffintomLogo, 2500);
                }
            } else {
                if (businessLogo != null) {
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.printSingleBitmap(businessLogo, 2500);
                }
            }
            String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
            String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy");
            if (!todayDate.equalsIgnoreCase(orderDateString)) {
                mIminPrintUtils.setTextSize(35);
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("This order is not for today", PrinterConst.Alignment.CENTER);
            }
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("Tiffintom.com sent you order", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.printText(orderName, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText("ORDER NO:" + orderDetail.order_number, PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            if (orderType > 0) {
                if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                    mIminPrintUtils.printText("ASAP", PrinterConst.Alignment.CENTER);
                } else {
                    mIminPrintUtils.printText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", PrinterConst.Alignment.CENTER);
                }
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }
            String itemName = "", price = "", qty = "",printBlockId=null;
            int productPosition=0;
            boolean isLastContainsLine=false;
            for (OrderProductDetail productDetail : orderDetail.cart_view) {
                productPosition = productPosition+1;
                if (printBlockId == null) {
                    printBlockId = productDetail.print_block_id;
                }
                if (productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                    printBlockId = productDetail.print_block_id;
                    if (orderDetail.cart_view.size()-1 == productPosition) {
                        isLastContainsLine = true;
                    }
                    printSeparator();
                }
                String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                String productQty = String.valueOf(productDetail.quantity);
                // Here we need 16 characters in product name so we send 16 in
                // @params charactersInLine
                price = (!kitchenCopy) ? formatter.format(productDetail.total_price) : "";
               /* if (kitchenCopy)
                    itemName = getProductNameWithPad(productName, price, 20);
                else
                    itemName = getProductNameWithPad(productName, price, 35);*/
                qty = productQty;
                if (productQty.length() <= 1) {
                    qty = " " + productQty + " ";
                } else if (productQty.length() <= 2) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 3) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 4) {
                    qty = productQty + "";
                }
                String printItem;
                printItem = qty + itemName;
                if (!kitchenCopy) {
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.setTextSize(25);
                    String[] strings3 = new String[]{"", qty + productName, price};
                    int[] colsWidthArr3 = new int[]{0, 8, 2};
                    int[] colsAlign3 = new int[]{0, 0, 2};
                    int[] colsSize3 = new int[]{26, 26, 26};
                    mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                            colsAlign3, colsSize3);
                    //mIminPrintUtils.printText(printItem, PrinterConst.Alignment.CENTER);
                } else {
                    printItem = printItem + productName;
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.setAlignment(0);
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.printText(printItem, PrinterConst.Alignment.CENTER);
                }

                if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                    try {
                        //String[] parts = menus.get(position).getSubaddonsName().split(",");
                        String[] parts = productDetail.subaddons_name.split(",");

                        for (String subAddonPart : parts) {
                            if (!kitchenCopy) {
                                mIminPrintUtils.sethaveBold(true);
                                String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                            } else {
                                mIminPrintUtils.sethaveBold(true);
                                String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                mIminPrintUtils.printText(subdomainPrintText, PrinterConst.Alignment.CENTER);
                            }
                        }
                    } catch (Exception e) {
                        Log.e("Addon_Error", e.getMessage());
                    }
                }
            }
            if(!isLastContainsLine){
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.setAlignment(1);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            }
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText(padRightSpaces("SubTotal:", 20) + MyApp.df.format(orderDetail.order_sub_total), PrinterConst.Alignment.CENTER);
            if (orderDetail.delivery_charge > 0) {
                mIminPrintUtils.printText(padRightSpaces("Delivery Charge:", 20) + MyApp.df.format(orderDetail.delivery_charge), PrinterConst.Alignment.CENTER);
            }
            if (orderDetail.offer_amount > 0) {
                mIminPrintUtils.printText(padRightSpaces("Offer:", 20) + MyApp.df.format(orderDetail.offer_amount), PrinterConst.Alignment.CENTER);
            }
            if (orderDetail.service_charge > 0) {
                if (loggedInRestaurant != null && !Validators.isNullOrEmpty(loggedInRestaurant.service_charge_status)) {
                    if (!"no".equalsIgnoreCase(loggedInRestaurant.service_charge_status)) {
                        mIminPrintUtils.printText(padRightSpaces("Service Charge:", 20) + MyApp.df.format(orderDetail.service_charge), PrinterConst.Alignment.CENTER);
                    }
                }
            }
            if (orderDetail.driver_tip > 0) {
                mIminPrintUtils.printText(padRightSpaces("Driver Tip::", 20) + MyApp.df.format(orderDetail.driver_tip), PrinterConst.Alignment.CENTER);
            }
            if (orderDetail.reward_offer > 0) {
                mIminPrintUtils.printText(padRightSpaces("Loyalty Point Discount:", 20) + MyApp.df.format(orderDetail.reward_offer), PrinterConst.Alignment.CENTER);
            }
            if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                    if (surChargesModel.surcharge_amount > 0) {
                        mIminPrintUtils.printText(padRightSpaces(surChargesModel.surcharge_name, 20) + MyApp.df.format(surChargesModel.surcharge_amount), PrinterConst.Alignment.CENTER);
                    }
                }
            }
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText("Grand Total: " + MyApp.df.format(orderDetail.order_grand_total), PrinterConst.Alignment.CENTER);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.setAlignment(0);
            if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                mIminPrintUtils.printText("Comments:" + orderDetail.order_description, PrinterConst.Alignment.LEFT);
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setTextSize(30);
                mIminPrintUtils.printText("------------------------------------------------", PrinterConst.Alignment.LEFT);
            }
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText("Cust Name:" + orderDetail.customer_name + "\n", PrinterConst.Alignment.LEFT);
            if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                mIminPrintUtils.printText("Cust No:" + orderDetail.customer_phone + "\n", PrinterConst.Alignment.LEFT);
            }
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT);

            if (orderType == 1 && !Validators.isNullOrEmpty(orderDetail.address)) {

                String address = orderDetail.address;
                String[] parts = address.split("[\\\\s,]+");
                StringBuilder str = new StringBuilder();

                for (String name : parts) {
                    str.append(name).append("\n");
                }
                mIminPrintUtils.setTextSize(25);
                mIminPrintUtils.sethaveBold(false);
                mIminPrintUtils.printText("Del. address:" + address, PrinterConst.Alignment.LEFT);
                mIminPrintUtils.sethaveBold(true);
                mIminPrintUtils.setTextSize(30);
                //mIminPrintUtils.printText("---------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
            }

            if (orderType >= 0) {

                if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                    mIminPrintUtils.setTextSize(35);
                    mIminPrintUtils.sethaveBold(false);
                    mIminPrintUtils.printText("Confirmed for:", PrinterConst.Alignment.LEFT);
                    mIminPrintUtils.sethaveBold(true);
                    mIminPrintUtils.printText(orderDetail.preparation + "\n", PrinterConst.Alignment.LEFT);

                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.setAlignment(1);
                    mIminPrintUtils.printText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
                }
            }
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n", PrinterConst.Alignment.LEFT);
            String paymentName = "";
            if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
            if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
            if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                paymentName = "WALLET";
            if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.printText("Payment Type:  " + paymentName + "", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.printText("Receipt Time:", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", PrinterConst.Alignment.LEFT);
            mIminPrintUtils.printText("Order status: " + orderDetail.status + "\n", PrinterConst.Alignment.LEFT);
            if (orderDetail.status.equalsIgnoreCase("failed")) {
                mIminPrintUtils.printText("Reason: " + orderDetail.failed_reason + "\n", PrinterConst.Alignment.LEFT);
            }

            if (MyApp.getInstance().myPreferences.getLoggedInRestaurant() != null) {
                mIminPrintUtils.printText(MyApp.getInstance().myPreferences.getLoggedInRestaurant().restaurant_name + ", " + MyApp.getInstance().myPreferences.getLoggedInRestaurant().contact_address + "\n", PrinterConst.Alignment.LEFT);
            }
            mIminPrintUtils.printText("Thanks!" + "\n", PrinterConst.Alignment.LEFT);

            mIminPrintUtils.printText("\n\n", PrinterConst.Alignment.CENTER);
            mIminPrintUtils.printAndFeedPaper(3);
            mIminPrintUtils.partialCut();
            //mIminPrintUtils.resetUSBDevice();
            if (kitchenCopy) {
                if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                    //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                    //zonerich.Prn_Disconnect();
                 /*   CommonFunctions.functionThatDelay(400);
                    CommonFunctions.functionThatDelay(400);*/
                    int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                    onlineOrderPrint = onlineOrderPrint - 1;
                    printOrder(tiffintomLogo, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);

                    //}
                } else {
                    //zonerich.Prn_Disconnect();
                    if (nextMethod != null) {
                        nextMethod.call();
                    }
                }
            } else {
                if (nextMethod != null) {
                    nextMethod.call();
                }
                //zonerich.Prn_Disconnect();
            }
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    public static String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    public static String padLeftSpace(String str, int n) {
        return String.format("%1$" + n + "s", str);
    }

    private static List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("");
                    }
                }
                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(parts1[1].trim(), charatersInLine)).append("");
                subAddonName = sb.toString();
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("");
                    }
                }

                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(part.trim(), charatersInLine)).append("");
                subAddonName = sb.toString();

            }

        }
        return subAddonName;
    }

    public void printFoodHubFullReport(Bitmap bm, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        if (bm != null) {
            mIminPrintUtils.setAlignment(0);
            mIminPrintUtils.printSingleBitmap(bm, 2500);
        }
        /*if (headerAlignment < 2) {
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText(header, PrinterConst.Alignment.CENTER);
        } else {
            String[] headers = header.split("\n");
            mIminPrintUtils.setTextSize(35);
            mIminPrintUtils.sethaveBold(true);
            mIminPrintUtils.setAlignment(1);
            for (String h : headers) {
                mIminPrintUtils.printText(h, PrinterConst.Alignment.CENTER);
            }
        }*/

        mIminPrintUtils.setTextSize(35);
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.setAlignment(1);
        if (!Validators.isNullOrEmpty(title))
            mIminPrintUtils.printText(title, PrinterConst.Alignment.CENTER);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);

        if (!Validators.isNullOrEmpty(date)) {
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText(date, PrinterConst.Alignment.LEFT);
            //zonerich.Prn_PrintText("" + CommonFunctions.formatMiliToDesireFormat(Calendar.getInstance().getTimeInMillis(),"hh:mm a") + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        }
        if (!Validators.isNullOrEmpty(myPreferences.getRegisteredDevice().name)) {
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText(myPreferences.getRegisteredDevice().name, PrinterConst.Alignment.LEFT);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        }
        //reportHeader(PrinterConst.WidthSize.SIZE0);
        if (!Validators.isNullOrEmpty(user)) {
            mIminPrintUtils.setTextSize(25);
            mIminPrintUtils.sethaveBold(false);
            mIminPrintUtils.printText("User name: " + user, PrinterConst.Alignment.LEFT);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        }
        reportHeader();
        mIminPrintUtils.setAlignment(1);
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        for (Object objct : data) {
            if (objct instanceof ReportTextModel) {
                ReportTextModel textModel = (ReportTextModel) objct;

                String printText;
                if (!textModel.isHeader) {
                    if (!Validators.isNullOrEmpty(textModel.value)) {
                        if (textModel.value.contains(MyApp.getInstance().currencySymbol)) {
                            //printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 35);
                            reportDetail("  -  ", Validators.isNullOrEmpty(textModel.value) ? "  -  " : textModel.value, textModel.title, false);
                        } else {
                            //printText = getProductNameWithPad(textModel.title, textModel.value, 35);
                            reportDetail(Validators.isNullOrEmpty(textModel.value) ? "  -  " : textModel.value, "", textModel.title, false);
                        }
                    } else {
                        if (!Validators.isNullOrEmpty(textModel.totalPrice) || !Validators.isNullOrEmpty(textModel.orderCount)) {
                            reportDetail(Validators.isNullOrEmpty(textModel.orderCount) ? "  -  " : textModel.orderCount, Validators.isNullOrEmpty(textModel.totalPrice) ? "  -  " : textModel.totalPrice, textModel.title, false);
                        } else {
                            getProductNameWithPad(textModel.title, "", 35);
                        }
                    }
                } else {
                    //printText = textModel.title;
                    reportDetail(textModel.value, "", textModel.title, true);
                }
                /*if (textModel.isHeader) {
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    mIminPrintUtils.setTextSize(30);
                    mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
                } else {
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }*/
            }
        }

        /*mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.sethaveBold(false);
        mIminPrintUtils.setAlignment(1);
        if(!Validators.isNullOrEmpty(footerA)){
            mIminPrintUtils.printText(footerA + "", PrinterConst.Alignment.CENTER);
        }
        if(!Validators.isNullOrEmpty(footerB)){
            mIminPrintUtils.printText(footerB + "\n", PrinterConst.Alignment.CENTER);
        }*/
        mIminPrintUtils.setTextSize(30);
        mIminPrintUtils.setAlignment(1);
        mIminPrintUtils.printText("--------------------------------------" + "\n\n\n\n", PrinterConst.Alignment.LEFT);
        mIminPrintUtils.printText("\n", PrinterConst.Alignment.CENTER);
        mIminPrintUtils.printAndFeedPaper(3);
        mIminPrintUtils.fullCut();
    }

    private void reportDetail(String ordersValue, String priceValue, String titleValue, boolean isHeader) {
        if (isHeader) {
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        }
        String[] strings3 = new String[]{titleValue, ordersValue, priceValue};
        int[] colsWidthArr3 = isHeader ? new int[]{12, 0, 0} : new int[]{10, 7, 7};
        int[] colsAlign3 = new int[]{0, 2, 2};
        int[] colsSize3 = new int[]{26, 26, 26};
        if (isHeader) {
            mIminPrintUtils.sethaveBold(true);
        } else {
            mIminPrintUtils.sethaveBold(false);
        }
        mIminPrintUtils.setAlignment(0);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                colsAlign3, colsSize3);
        if (isHeader) {
            mIminPrintUtils.setAlignment(1);
            mIminPrintUtils.setTextSize(30);
            mIminPrintUtils.printText("--------------------------------------" + "\n", PrinterConst.Alignment.LEFT);
        }
    }

    private void reportHeader() {
        String orderTitle = "Orders";
        String priceTitle = "Price";
        String[] strings3 = new String[]{"", orderTitle, priceTitle};
        int[] colsWidthArr3 = new int[]{0, 8, 4};
        int[] colsAlign3 = new int[]{0, 2, 2};
        int[] colsSize3 = new int[]{0, 26, 26};
        mIminPrintUtils.sethaveBold(true);
        mIminPrintUtils.setAlignment(0);
        mIminPrintUtils.setTextSize(25);
        mIminPrintUtils.printColumnsText(strings3, colsWidthArr3,
                colsAlign3, colsSize3);
    }
}
