package com.ubsidi.epos_2021.comman.printer;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.os.IBinder;
import android.text.Html;
import android.util.Log;

import com.google.gson.Gson;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.ReportTextModel;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SalesReport;
import com.ubsidi.epos_2021.models.SendOrderWifiModel;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.SurChargesModel;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderProductDetail;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.Logger;
import com.zqprintersdk.PrinterConst;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;

import woyou.aidlservice.jiuiv5.IWoyouService;

/**
 * Created by Amrish on 04-12-2020.
 */
public class SunmiPrinter {
    private Context context;
    public IWoyouService woyouService;
    public MyApp myApp = MyApp.getInstance();
    public SiteSetting printBlockBill = myApp.findSetting("print_block_bill");

    ServiceConnection connService = new ServiceConnection() {

        @Override
        public void onServiceDisconnected(ComponentName name) {
            woyouService = null;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            woyouService = IWoyouService.Stub.asInterface(service);
        }
    };

    public void unBindService(Context context) {
        context.unbindService(connService);
    }

    public SunmiPrinter(Context context) {
        this.context = context;
        startService(context);

    }

    private void startService(Context context) {
        Intent intent = new Intent();
        intent.setPackage("woyou.aidlservice.jiuiv5");
        intent.setAction("woyou.aidlservice.jiuiv5.IWoyouService");
        context.startService(intent);//Start printer service
        context.bindService(intent, connService, Context.BIND_AUTO_CREATE);
    }

    public void openCashDrawer() {
        AidlUtil.getInstance().openCashDrawer();
    }

    public void printCardReaderReceipt(Bitmap bm, String rePrintTitle, String title, String header, String header1, int headerAlignment, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1, MyPreferences myPreferences) {
        try {
            if (bm != null)
                AidlUtil.getInstance().printBitmap(bm);
            if (!Validators.isNullOrEmpty(header)) {
                AidlUtil.getInstance().printText(header, 32, true, false, headerAlignment);
            }
            if (!Validators.isNullOrEmpty(header1)) {
                AidlUtil.getInstance().printText(header1, 32, true, false, headerAlignment);
            }
            if (!Validators.isNullOrEmpty(rePrintTitle)) {
                AidlUtil.getInstance().printText(rePrintTitle, 40, true, false, AidlUtil.Alignment.CENTER);
            }
            AidlUtil.getInstance().printText(title, 40, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("--------------------------------", 24, true, false, AidlUtil.Alignment.CENTER);
            if (!Validators.isNullOrEmpty(tip_amount)) {
                AidlUtil.getInstance().printText(actual_amount, 36, true, false, AidlUtil.Alignment.CENTER);
                AidlUtil.getInstance().printText(tip_amount, 36, true, false, AidlUtil.Alignment.CENTER);
            }
            AidlUtil.getInstance().printText(grand_total, 52, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(main_content, 26, true, false, AidlUtil.Alignment.LEFT);
            AidlUtil.getInstance().printText(please, 26, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(final_date, 26, true, false, AidlUtil.Alignment.LEFT);
            AidlUtil.getInstance().printText("--------------------------------", 24, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(footer, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(footer1, 32, true, false, AidlUtil.Alignment.CENTER);
            // set print true for local device
            setPrint(myPreferences, true);
            AidlUtil.getInstance().CutPaper();

            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title);
            sendOrderWifiModel.setOrderTypeHeading(header);
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setAmount(actual_amount);
            sendOrderWifiModel.setTip_amount(tip_amount);
            sendOrderWifiModel.setGrand_total(grand_total);
            sendOrderWifiModel.setMain_content(main_content);
            sendOrderWifiModel.setPlease(please);
            sendOrderWifiModel.setDateTimeModeInPrint(final_date);
            sendOrderWifiModel.setFooterB(footer1);
            sendOrderWifiModel.setFooterA(footer);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTCARDREADERRECEIPT);
            sendOrderToWifi(sendOrderWifiModel);
        } catch (Exception e) {
            e.printStackTrace();
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title);
            sendOrderWifiModel.setOrderTypeHeading(header);
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setAmount(actual_amount);
            sendOrderWifiModel.setTip_amount(tip_amount);
            sendOrderWifiModel.setGrand_total(grand_total);
            sendOrderWifiModel.setMain_content(main_content);
            sendOrderWifiModel.setPlease(please);
            sendOrderWifiModel.setDateTimeModeInPrint(final_date);
            sendOrderWifiModel.setFooterB(footer1);
            sendOrderWifiModel.setFooterA(footer);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTCARDREADERRECEIPT);
            sendOrderToWifi(sendOrderWifiModel);
        }

    }

    private void setPrint(MyPreferences myPreferences, boolean isPrint) {
        myPreferences.saveIsPrintBill(isPrint);
    }

    public void printMotoReceipt(Bitmap bm, String title, String header, int headerAlignment, String amount, String main_content, String date_final, String please, String footer, String footer1, MyPreferences myPreferences) {
        try {
            if (bm != null) {
                AidlUtil.getInstance().printBitmap(bm);
            }
            AidlUtil.getInstance().printText(header, 32, true, false, headerAlignment);
            AidlUtil.getInstance().printText(title, 40, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

            amount = amount.replace("£", "");
            amount = amount.replace("\n", "");
            amount = amount + " GBP";
            AidlUtil.getInstance().printText(amount, 52, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(main_content.replace(" :", ": "), 22, true, false, AidlUtil.Alignment.LEFT);

            AidlUtil.getInstance().printText(date_final, 26, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(please, 26, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("--------------------------------", 24, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(footer, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(footer1, 32, true, false, AidlUtil.Alignment.CENTER);
            // set print true for local device
            setPrint(myPreferences, true);
            AidlUtil.getInstance().CutPaper();

            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title);
            sendOrderWifiModel.setOrderTypeHeading(header);
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setAmount(amount);
            sendOrderWifiModel.setMain_content(main_content);
            sendOrderWifiModel.setDateTimeModeInPrint(date_final);
            sendOrderWifiModel.setPlease(please);
            sendOrderWifiModel.setFooterB(footer1);
            sendOrderWifiModel.setFooterA(footer);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTMOTORECEIPT);
            sendOrderToWifi(sendOrderWifiModel);
        } catch (Exception e) {
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title);
            sendOrderWifiModel.setOrderTypeHeading(header);
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setAmount(amount);
            sendOrderWifiModel.setMain_content(main_content);
            sendOrderWifiModel.setDateTimeModeInPrint(date_final);
            sendOrderWifiModel.setPlease(please);
            sendOrderWifiModel.setFooterB(footer1);
            sendOrderWifiModel.setFooterA(footer);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTMOTORECEIPT);
            sendOrderToWifi(sendOrderWifiModel);
            e.printStackTrace();
        }
    }

    public void printOrderFoodHub(ArrayList<PrintStyle> listPrintStructure, List<PrintSetting> printSettings, Bitmap tiffintomBitmap, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo, String onlineOrderPrintCount, Callable<Void> nextMethod) {
        int style = 0, alignment = 0;
        float size = 0;
        boolean isbold = false, isUnderline = false;
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }

        try {
            if (!orderTiffinTomLogo) {
                if (tiffintomBitmap != null) {
                    AidlUtil.getInstance().printBitmap(tiffintomBitmap);
                    AidlUtil.getInstance().printText("\n", size, isbold, isUnderline, alignment);
                }
            } else {
                if (businessLogo != null) {
                    AidlUtil.getInstance().printBitmap(businessLogo);
                    AidlUtil.getInstance().printText("\n", size, isbold, isUnderline, alignment);
                }
            }

            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean priceInItems = listPrintStructure.get(i).price;
                switch (listPrintStructure.get(i).style) {
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }
                switch (listPrintStructure.get(i).size) {
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }
                switch (listPrintStructure.get(i).alignment) {
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                boolean isSeparator = listPrintStructure.get(i).separator;
                switch (key) {
                    case "online_title": {
                        String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                        String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                        if (!todayDate.equalsIgnoreCase(orderDateString)) {
                            AidlUtil.getInstance().printText("This Order Is Not For Today\n\n", size, isbold, isUnderline, alignment);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_site": {
                        AidlUtil.getInstance().printText("Tiffintom.com sent you order\n", size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_type": {
                        AidlUtil.getInstance().printText(CommonFunctions.getOnlineOrderType(orderType), size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_no": {
                        AidlUtil.getInstance().printText("ORDER NO: " + orderDetail.order_number + "", size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_date": {
                        if (orderType > 0) {
                            if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                                AidlUtil.getInstance().printText("ASAP" + "", size, isbold, isUnderline, alignment);
                            } else {
                                AidlUtil.getInstance().printText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", size, isbold, isUnderline, alignment);
                            }
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_items": {

                        String itemName = "", price = "", qty = "", printBlockId = null;
                        int position = 0, productPosition = 0;
                        boolean isLastContainsLine = false;
                        for (OrderProductDetail productDetail : orderDetail.cart_view) {
                            position = position + 1;
                            productPosition = productPosition + 1;
                            if (printBlockId == null) {
                                printBlockId = productDetail.print_block_id;
                            }
                            if (productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                                printBlockId = productDetail.print_block_id;
                                if (orderDetail.cart_view.size() - 1 == productPosition) {
                                    isLastContainsLine = true;
                                }
                                printSeparator();
                            }
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                            String productQty = String.valueOf(productDetail.quantity);
                            String totalPrice = String.valueOf(productDetail.total_price);
                            // Here we need 16 characters in product name so we send 16 in
                            // @params charactersInLine
                            price = (priceInItems) ? MyApp.df.format(productDetail.total_price) : "";
                            //itemName = getProductNameWithPad(productName, price, kitchenCopy ? 20 : 28);
                            qty = productQty;
                            if (productQty.length() <= 1) {
                                qty = " " + productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }
                            String printItem;
                            printItem = qty + itemName + "";
                            int fontSize = 30;
                            if (kitchenCopy) fontSize = 36;
                            if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                                String[] productNameSplit = productName.split(" ");
                                String finalPrice = "  " + price;
                                String secondLine = qty;
                                int lengthForSize;
                                if (size == AidlUtil.Size.SIZE0) {
                                    lengthForSize = 38;
                                } else if (size == AidlUtil.Size.SIZE1) {
                                    lengthForSize = 28;
                                } else {
                                    lengthForSize = 23;
                                }
                                int multiplyLength = 1;
                                int index = 0;
                                for (String s : productNameSplit) {
                                    index = index + 1;
                                    Log.e("finalPrice", "finalPrice " + finalPrice + "string to apend " + s.length());
                                    if (secondLine.length() < (multiplyLength * lengthForSize)) {
                                        if ((secondLine + " " + s + finalPrice).length() > (multiplyLength * lengthForSize)) {
                                            //secondLine = secondLine+secondLine.replace(,"");
                                            int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                                            if (multiplyLength == 1) {
                                                emptySpaceLength = emptySpaceLength - finalPrice.length();
                                                for (int space = 0; space < emptySpaceLength; space++) {
                                                    secondLine = secondLine + (" ");
                                                }
                                                secondLine = secondLine + finalPrice;
                                            } else {
                                                for (int space = 0; space < emptySpaceLength; space++) {
                                                    secondLine = secondLine + (" ");
                                                }
                                            }
                                            multiplyLength = multiplyLength + 1;
                                            secondLine = secondLine + ("\n");
                                            for (int j = 0; j < qty.length(); j++) {
                                                secondLine = secondLine + (" ");
                                            }
                                        }
                                    } else {
                                        multiplyLength = multiplyLength + 1;
                                        secondLine = secondLine + ("\n");
                                        for (int j = 0; j < qty.length(); j++) {
                                            secondLine = secondLine + (" ");
                                        }
                                    }
                                    secondLine = secondLine + " " + s;
                                    if (productNameSplit.length == index && multiplyLength == 1 && secondLine.length() < (multiplyLength * lengthForSize)) {
                                        if (multiplyLength == 1) {
                                            int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                                            emptySpaceLength = emptySpaceLength - finalPrice.length();
                                            for (int space = 0; space < emptySpaceLength; space++) {
                                                secondLine = secondLine + (" ");
                                            }
                                            secondLine = secondLine + finalPrice;
                                        }
                                    }
                                }
                                itemName = secondLine;
                                printItem = itemName;
                            }

                            AidlUtil.getInstance().printText(printItem, size, isbold, isUnderline, alignment);

                            if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                                try {
                                    //String[] parts = menus.get(position).getSubaddonsName().split(",");
                                    String[] parts = productDetail.subaddons_name.split(",");

                                    for (String subAddonPart : parts) {
                                        int fontSizeSub = 30;
                                        int charactersInLine = 20;
                                        if (kitchenCopy) {
                                            fontSizeSub = 36;
                                            charactersInLine = 16;
                                        }
                                        String printedItem = getSubaddonWithPadOnline(" - " + subAddonPart, charactersInLine);
                                        AidlUtil.getInstance().printText(printedItem, size, isbold, isUnderline, alignment);
                                    }
                                } catch (Exception e) {
                                    Log.e("Addon_Error", e.getMessage());
                                }
                            }
                            if (all_separator && orderDetail.cart_view.size() > position) {
                                printSeparator();
                            }
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_sub_total": {
                        AidlUtil.getInstance().printText(formatTotal(size, "SubTotal:", MyApp.currencySymbol + MyApp.df.format(orderDetail.order_sub_total)), size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_delivery_charge": {
                        if (orderDetail.delivery_charge > 0) {
                            AidlUtil.getInstance().printText(formatTotal(size, "Delivery Charge:", MyApp.currencySymbol + MyApp.df.format(orderDetail.delivery_charge)), size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_service_charge": {
                        if (orderDetail.service_charge > 0) {
                            if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                                AidlUtil.getInstance().printText(formatTotal(size, "Service Charge:", MyApp.currencySymbol + MyApp.df.format(orderDetail.service_charge)), size, isbold, isUnderline, alignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "online_driver_tip": {
                        if (orderDetail.driver_tip > 0) {
                            AidlUtil.getInstance().printText(formatTotal(size, "Driver Tip:", MyApp.currencySymbol + MyApp.df.format(orderDetail.driver_tip)), size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_loyalty": {
                        if (orderDetail.reward_offer > 0) {
                            AidlUtil.getInstance().printText(formatTotal(size, "Loyalty Point Discount:", MyApp.currencySymbol + MyApp.df.format(orderDetail.reward_offer)), size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_offer": {
                        if (orderDetail.offer_amount > 0) {
                            AidlUtil.getInstance().printText(formatTotal(size, "Offer:", MyApp.currencySymbol + MyApp.df.format(orderDetail.offer_amount)), size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_grand_total": {
                        AidlUtil.getInstance().printText(formatTotal(size, "Total:  ", MyApp.currencySymbol + MyApp.df.format(orderDetail.order_grand_total) + ""), size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_comment": {
                        if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                            AidlUtil.getInstance().printText("Comments: " + orderDetail.order_description, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_delivery_instruction": {
                        if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                            AidlUtil.getInstance().printText("Delivery Instructions: " + orderDetail.delivery_instruction, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_customer_details": {
                        AidlUtil.getInstance().printText("" + orderDetail.customer_name + "", size, isbold, isUnderline, alignment);
                        if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                            AidlUtil.getInstance().printText("" + orderDetail.customer_phone + "", size, isbold, isUnderline, alignment);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_delivery_address": {
                        if (orderType == 1) {
                            String address = orderDetail.address + "\n";
                            String[] parts = address.split("[\\\\s,]+");
                            StringBuilder str = new StringBuilder();

                            for (String name : parts) {
                                str.append(name).append("\n");
                            }
                            if (!Validators.isNullOrEmpty(address)) {
                                AidlUtil.getInstance().printText("" + address, size, isbold, isUnderline, alignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "online_requested_for": {
                       /* if (orderType >= 0) {
                            AidlUtil.getInstance().printText("Requested for: ", size, isbold, isUnderline, alignment);
                        }*/
                        if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                            AidlUtil.getInstance().printText("Requested for: ASAP", size, isbold, isUnderline, alignment);
                        } else {
                            AidlUtil.getInstance().printText("Requested for: "+orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "", size, isbold, isUnderline, alignment);
                        }
                        //AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                        if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                            AidlUtil.getInstance().printText("Confirmed for: "+orderDetail.preparation, size, isbold, isUnderline, alignment);
                            //AidlUtil.getInstance().printText("" + orderDetail.preparation, size, isbold, isUnderline, alignment);
                            //AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_payment_status": {
                        AidlUtil.getInstance().printText(" " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "UNPAID" : "PAID"), size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_payment_method": {
                        String paymentName = "";
                        if (orderDetail.payment_method.equalsIgnoreCase("stripe"))
                            paymentName = "ONLINE";
                        if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                        if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                            paymentName = "WALLET";
                        if (orderDetail.payment_method.equalsIgnoreCase("paypal"))
                            paymentName = "PAYPAL";
                        if (!Validators.isNullOrEmpty(paymentName)) {
                            AidlUtil.getInstance().printText(" Payment Type : " + paymentName, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_receipt_time": {
                        AidlUtil.getInstance().printText("Receipt Time:", size, isbold, isUnderline, alignment);
                        AidlUtil.getInstance().printText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "", size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_status": {
                        AidlUtil.getInstance().printText("Order status: " + orderDetail.status + "", size, isbold, isUnderline, alignment);
                        if (orderDetail.status.equalsIgnoreCase("failed")) {
                            AidlUtil.getInstance().printText("Reason: " + orderDetail.failed_reason + "", size, isbold, isUnderline, alignment);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_restaurant_address": {
                        if (!kitchenCopy) {
                        AidlUtil.getInstance().printText(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address + "", size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }}
                        break;
                    }
                    case "online_failed_reason": {
                        if (orderDetail.status.equalsIgnoreCase("failed")) {
                            AidlUtil.getInstance().printText("Reason: " + orderDetail.failed_reason + "", size, isbold, isUnderline, alignment);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_footer": {
                        if(!kitchenCopy){
                            AidlUtil.getInstance().printText("Thanks!", size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                }
            }

            woyouService.lineWrap(2, null);
            woyouService.sendRAWData(ESCUtil.cutPaper(), null);

            if (kitchenCopy) {
                if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                    //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                    CommonFunctions.functionThatDelay(100);
                    int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                    onlineOrderPrint = onlineOrderPrint - 1;
                    printOrderFoodHub(listPrintStructure, printSettings, tiffintomBitmap, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);
                } else {
                    nextMethod.call();
                }
            } else {
                nextMethod.call();
            }
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            sendOrderWifiModel.setOrderDetailModel(orderDetail);
            sendOrderWifiModel.setPrintSettings(printSettings);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
            if (kitchenCopy) {
                sendOrderToWifi(sendOrderWifiModel);
            }
        } catch (Exception e) {
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            sendOrderWifiModel.setOrderDetailModel(orderDetail);
            sendOrderWifiModel.setPrintSettings(printSettings);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
            if (kitchenCopy) {
                sendOrderToWifi(sendOrderWifiModel);
            }
            System.out.println(e);
            try {
                if (kitchenCopy) {
                    if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                        //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                        CommonFunctions.functionThatDelay(100);
                        int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                        onlineOrderPrint = onlineOrderPrint - 1;
                        printOrderFoodHub(listPrintStructure, printSettings, tiffintomBitmap, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);
                    } else {
                        nextMethod.call();
                    }
                } else {
                    nextMethod.call();
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private String formatTotal(float widthSize, String titleOfTotal, String totalValue) {
        int lengthForSize = (widthSize == AidlUtil.Size.SIZE0 ? 38 : 28) - (titleOfTotal.length() + totalValue.length());
        StringBuilder finalTitle = new StringBuilder(titleOfTotal);
        for (int space = 0; space < lengthForSize; space++) {
            finalTitle.append(" ");
        }
        finalTitle.append(totalValue);
        return finalTitle.toString();
    }

    public void printOrder(PrintStructure structure, List<PrintSetting> printSettings, Bitmap tiffintomBitmap, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo, String onlineOrderPrintCount, Callable<Void> nextMethod) {
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }

        try {
            woyouService.sendRAWData(ESCUtil.boldOn(), null);

            if (!orderTiffinTomLogo) {
                if (tiffintomBitmap != null) {
                    woyouService.setAlignment(1, null);
                    woyouService.printBitmap(tiffintomBitmap, null);
                    woyouService.printText("\n", null);
                }
            } else {
                if (businessLogo != null) {
                    woyouService.setAlignment(1, null);
                    woyouService.printBitmap(businessLogo, null);
                    woyouService.printText("\n", null);
                }
            }

            if (structure.online_title.visibility) {
                String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                if (!todayDate.equalsIgnoreCase(orderDateString)) {
                    woyouService.setFontSize(40, null);
                    woyouService.setAlignment(1, null);//Right
                    woyouService.printText("This Order Is Not For Today\n\n", null);
                }
            }

            if (structure.online_site.visibility) {
                woyouService.setAlignment(1, null);//Right
                woyouService.setFontSize(26, null);
                woyouService.printText("Tiffintom.com sent you order\n\n", null);
            }

            if (structure.online_order_type.visibility) {
                woyouService.setAlignment(1, null);//Right
                woyouService.setFontSize(36, null);
                woyouService.printText(CommonFunctions.getOnlineOrderType(orderType) + "\n", null);

                woyouService.setAlignment(1, null);//Right
                woyouService.setFontSize(30, null);
                woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);
            }

            if (structure.online_order_no.visibility) {
                woyouService.setFontSize(36, null);
                woyouService.printText("ORDER NO: " + orderDetail.order_number + "\n", null);
            }

            if (structure.online_order_date.visibility) {
                if (orderType > 0) {
                    if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                        woyouService.printText("ASAP" + "\n", null);
                    } else {
                        woyouService.printText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", null);
                    }
                }
                woyouService.setFontSize(30, null);
                woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);
            }

            if (structure.online_items.visibility) {
                if (kitchenCopy)
                    woyouService.setFontSize(40, null);
                else woyouService.setFontSize(30, null);
                woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);

                String itemName = "", price = "", qty = "", printBlockId = null;
                int productPosition = 0;
                boolean isLastContainsLine = false;
                for (OrderProductDetail productDetail : orderDetail.cart_view) {
                    productPosition = productPosition + 1;
                    if (printBlockId == null) {
                        printBlockId = productDetail.print_block_id;
                    }
                    if (productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                        printBlockId = productDetail.print_block_id;
                        if (orderDetail.cart_view.size() - 1 == productPosition) {
                            isLastContainsLine = true;
                        }
                        printSeparator();
                    }
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                    String productQty = String.valueOf(productDetail.quantity);
                    String totalPrice = String.valueOf(productDetail.total_price);
                    // Here we need 16 characters in product name so we send 16 in
                    // @params charactersInLine
                    price = (!kitchenCopy) ? MyApp.df.format(productDetail.total_price) : "";
                    itemName = getProductNameWithPad(productName, price, kitchenCopy ? 20 : 28);
                    qty = productQty;
                    if (productQty.length() <= 1) {
                        qty = " " + productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }
                    String printItem;
                    printItem = qty + itemName + "\n";
                    int fontSize = 30;
                    if (kitchenCopy) fontSize = 36;
                    woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                    woyouService.setFontSize(fontSize, null);
                    woyouService.printText(printItem, null);

                    if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                        try {
                            //String[] parts = menus.get(position).getSubaddonsName().split(",");
                            String[] parts = productDetail.subaddons_name.split(",");

                            for (String subAddonPart : parts) {
                                int fontSizeSub = 30;
                                int charactersInLine = 20;
                                if (kitchenCopy) {
                                    fontSizeSub = 36;
                                    charactersInLine = 16;
                                }
                                String printedItem = getSubaddonWithPadOnline(subAddonPart, charactersInLine);
                                woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                                woyouService.setFontSize(fontSizeSub, null);
                                woyouService.printText(printedItem, null);

                            }
                        } catch (Exception e) {
                            Log.e("Addon_Error", e.getMessage());
                        }
                    }
                }
                if (!isLastContainsLine) {
                    woyouService.setAlignment(AidlUtil.Alignment.CENTER, null);
                    woyouService.setFontSize(30, null);
                    woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);
                }
            }

            if (structure.online_sub_total.visibility) {
                woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                woyouService.setFontSize(32, null);
                woyouService.printText(padRightSpaces("SubTotal:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.order_sub_total) + "\n", null);
            }

            if (structure.online_delivery_charge.visibility) {
                if (orderDetail.delivery_charge > 0) {
                    woyouService.printText(padRightSpaces("Delivery Charge:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.delivery_charge) + "\n", null);
                }
            }

            if (structure.online_service_charge.visibility) {
                if (orderDetail.service_charge > 0) {
                    if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                        woyouService.printText(padRightSpaces("Service Charge:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.service_charge) + "\n", null);
                    }
                }
            }

            if (structure.online_driver_tip.visibility) {
                if (orderDetail.driver_tip > 0) {
                    woyouService.printText(padRightSpaces("Driver Tip:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.driver_tip) + "\n", null);
                }
            }

            if (structure.online_loyalty.visibility) {
                if (orderDetail.reward_offer > 0) {
                    woyouService.printText(padRightSpaces("Loyalty Point Discount:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.reward_offer) + "\n", null);
                }
            }

            if (structure.online_offer.visibility) {
                if (orderDetail.offer_amount > 0) {
                    woyouService.printText(padRightSpaces("Offer:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.offer_amount) + "\n", null);
                }
            }
            if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                    if (surChargesModel.surcharge_amount > 0) {
                        woyouService.printText(padRightSpaces(surChargesModel.surcharge_name, 16) + MyApp.currencySymbol + MyApp.df.format(surChargesModel.surcharge_amount) + "\n", null);
                    }
                }
            }
            if (structure.online_grand_total.visibility) {
                woyouService.setFontSize(36, null);
                woyouService.printText(padRightSpaces("Total:  ", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.order_grand_total) + "\n", null);
                woyouService.setFontSize(30, null);
                woyouService.setAlignment(1, null);
                woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);
            }

            if (structure.online_comment.visibility) {
                woyouService.setAlignment(0, null);
                if (!Validators.isNullOrEmpty(orderDetail.order_description)) {

                    woyouService.sendRAWData(ESCUtil.boldOn(), null);
                    woyouService.setFontSize(kitchenCopy ? 40 : 32, null);
                    woyouService.printText("Comments: " + orderDetail.order_description + "\n", null);
                    woyouService.sendRAWData(ESCUtil.boldOff(), null);

                    woyouService.setAlignment(1, null);
                    woyouService.setFontSize(26, null);
                    woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);
                }
            }

            if (structure.online_delivery_instruction.visibility) {
                if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {

                    woyouService.sendRAWData(ESCUtil.boldOn(), null);
                    woyouService.setFontSize(32, null);
                    woyouService.printText("Delivery Instructions: " + orderDetail.delivery_instruction + "\n", null);
                    woyouService.sendRAWData(ESCUtil.boldOff(), null);
                    woyouService.setAlignment(1, null);
                    woyouService.setFontSize(26, null);
                    woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
                }
            }

            if (structure.online_customer_details.visibility) {
                woyouService.setAlignment(0, null);
                woyouService.setFontSize(32, null);
                woyouService.sendRAWData(ESCUtil.boldOn(), null);
                woyouService.printText("Cust Name: " + orderDetail.customer_name + "\n", null);

                if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                    woyouService.printText("Cust No: " + orderDetail.customer_phone + "\n", null);
                }
                woyouService.sendRAWData(ESCUtil.boldOff(), null);
                woyouService.setAlignment(1, null);
                woyouService.setFontSize(30, null);
                woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
            }

            if (structure.online_delivery_address.visibility) {
                if (orderType == 1) {
                    String address = orderDetail.address + "\n";
                    String[] parts = address.split("[\\\\s,]+");
                    StringBuilder str = new StringBuilder();

                    for (String name : parts) {
                        str.append(name).append("\n");
                    }
                    woyouService.setFontSize(32, null);
                    woyouService.sendRAWData(ESCUtil.boldOn(), null);
                    woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                    woyouService.printText("Del. address: " + address, null);
                    woyouService.sendRAWData(ESCUtil.boldOff(), null);

                    woyouService.setFontSize(26, null);
                    woyouService.setAlignment(1, null);
                    woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
                }
            }

            if (structure.online_requested_for.visibility) {
                if (orderType >= 0) {
                    woyouService.setAlignment(0, null);
                    woyouService.setFontSize(36, null);
                    woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                    woyouService.printText("Requested for: ", null);
                    if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                        woyouService.printText("ASAP" + "\n", null);
                    } else {
                        woyouService.printText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", null);
                    }
                    woyouService.setFontSize(26, null);
                    woyouService.setAlignment(1, null);
                    woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

                    woyouService.setAlignment(0, null);
                    if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                        woyouService.setFontSize(36, null);
                        woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                        woyouService.printText("Confirmed for: ", null);
                        woyouService.printText("" + orderDetail.preparation + "\n", null);
                        woyouService.setFontSize(26, null);
                        woyouService.setAlignment(1, null);
                        woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
                    }
                }
            }

            if (structure.online_payment_status.visibility) {
                woyouService.setAlignment(0, null);
                woyouService.setFontSize(36, null);
                woyouService.sendRAWData(ESCUtil.boldOn(), null);
                woyouService.printText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n", null);
                woyouService.sendRAWData(ESCUtil.boldOff(), null);
            }

            if (structure.online_payment_method.visibility) {
                woyouService.setFontSize(26, null);
                String paymentName = "";
                if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
                if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                    paymentName = "WALLET";
                if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";
                woyouService.printText(" Payment Type : " + paymentName + "\n", null);

                woyouService.setFontSize(30, null);
                woyouService.setAlignment(1, null);
                woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
            }

            if (structure.online_receipt_time.visibility) {
                woyouService.sendRAWData(ESCUtil.boldOn(), null);
                woyouService.setAlignment(0, null);
                woyouService.setFontSize(32, null);
                woyouService.printText("Receipt Time:\n", null);
                woyouService.printText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", null);
                woyouService.sendRAWData(ESCUtil.boldOff(), null);
            }

            if (structure.online_order_status.visibility) {
                woyouService.printText("Order status: " + orderDetail.status + "\n", null);
                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    woyouService.printText("Reason: " + orderDetail.failed_reason + "\n", null);
                }
            }

            if (structure.online_restaurant_address.visibility) {
                woyouService.sendRAWData(ESCUtil.boldOn(), null);
                woyouService.setFontSize(28, null);
                woyouService.printText(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address + "\n", null);
            }

            if (structure.online_failed_reason.visibility) {
                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    woyouService.printText("Reason: " + orderDetail.failed_reason + "\n", null);
                }
            }

            if (structure.online_footer.visibility) {
                woyouService.printText("Thanks!\n", null);
            }

            woyouService.lineWrap(3, null);
            woyouService.sendRAWData(ESCUtil.cutPaper(), null);

            if (kitchenCopy) {
                if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                    //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                    CommonFunctions.functionThatDelay(100);
                    int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                    onlineOrderPrint = onlineOrderPrint - 1;
                    printOrder(structure, printSettings, tiffintomBitmap, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);
                } else {
                    nextMethod.call();
                }
            } else {
                nextMethod.call();
            }
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            sendOrderWifiModel.setOrderDetailModel(orderDetail);
            sendOrderWifiModel.setPrintSettings(printSettings);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
            if (kitchenCopy) {
                sendOrderToWifi(sendOrderWifiModel);
            }
        } catch (Exception e) {
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            sendOrderWifiModel.setOrderDetailModel(orderDetail);
            sendOrderWifiModel.setPrintSettings(printSettings);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
            if (kitchenCopy) {
                sendOrderToWifi(sendOrderWifiModel);
            }
            System.out.println(e);
            try {
                if (kitchenCopy) {
                    if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                        //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                        CommonFunctions.functionThatDelay(100);
                        int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                        onlineOrderPrint = onlineOrderPrint - 1;
                        printOrder(structure, printSettings, tiffintomBitmap, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);
                    } else {
                        nextMethod.call();
                    }
                } else {
                    nextMethod.call();
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void printOrder(Bitmap tiffintomBitmap, OrderDetail orderDetail, boolean kitchenCopy) {
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }

        try {
            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            if (tiffintomBitmap != null) {
                woyouService.setAlignment(1, null);
                woyouService.printBitmap(tiffintomBitmap, null);
                woyouService.printText("\n", null);
            }

            String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
            String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
            if (!todayDate.equalsIgnoreCase(orderDateString)) {
                woyouService.setFontSize(40, null);
                woyouService.setAlignment(1, null);//Right
                woyouService.printText("This Order Is Not For Today\n\n", null);
            }

            //woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.setAlignment(1, null);//Right
            woyouService.setFontSize(26, null);
            woyouService.printText("\n\n", null);

            //woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.printText("Tiffintom.com sent you order\n\n", null);

            woyouService.setAlignment(1, null);//Right
            woyouService.setFontSize(36, null);
            woyouService.printText(CommonFunctions.getOnlineOrderType(orderType) + "\n", null);

            woyouService.setAlignment(1, null);//Right
            woyouService.setFontSize(30, null);
            woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);

            woyouService.setFontSize(36, null);
            woyouService.printText("ORDER NO: " + orderDetail.order_number + "\n", null);

            if (orderType > 0) {
                if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                    woyouService.printText("ASAP" + "\n", null);
                } else {
                    woyouService.printText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", null);
                }
            }
            woyouService.setFontSize(30, null);
            woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);

            if (kitchenCopy)
                woyouService.setFontSize(40, null);
            else woyouService.setFontSize(30, null);
            woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
            String itemName = "", price = "", qty = "";
            for (OrderProductDetail productDetail : orderDetail.cart_view) {
                String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                String productQty = String.valueOf(productDetail.quantity);
                String totalPrice = String.valueOf(productDetail.total_price);
                // Here we need 16 characters in product name so we send 16 in
                // @params charactersInLine
                price = (!kitchenCopy) ? MyApp.df.format(productDetail.total_price) : "";
                itemName = getProductNameWithPad(productName, price, kitchenCopy ? 20 : 28);
                qty = productQty;
                if (productQty.length() <= 1) {
                    qty = " " + productQty + " ";
                } else if (productQty.length() <= 2) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 3) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 4) {
                    qty = productQty + "";
                }
                String printItem;
                printItem = qty + itemName + "\n";
                int fontSize = 30;
                if (kitchenCopy) fontSize = 36;
                woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                woyouService.setFontSize(fontSize, null);
                woyouService.printText(printItem, null);

                if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                    try {
                        //String[] parts = menus.get(position).getSubaddonsName().split(",");
                        String[] parts = productDetail.subaddons_name.split(",");

                        for (String subAddonPart : parts) {
                            int fontSizeSub = 30;
                            int charactersInLine = 20;
                            if (kitchenCopy) {
                                fontSizeSub = 36;
                                charactersInLine = 16;
                            }
                            String printedItem = getSubaddonWithPadOnline(subAddonPart, charactersInLine);
                            woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                            woyouService.setFontSize(fontSizeSub, null);
                            woyouService.printText(printedItem, null);

                        }
                    } catch (Exception e) {
                        Log.e("Addon_Error", e.getMessage());
                    }
                }
            }
            woyouService.setAlignment(AidlUtil.Alignment.CENTER, null);
            woyouService.setFontSize(30, null);
            woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);

            woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
            woyouService.setFontSize(32, null);
            woyouService.printText(padRightSpaces("SubTotal:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.order_sub_total) + "\n", null);

            if (orderDetail.delivery_charge > 0) {
                woyouService.printText(padRightSpaces("Delivery Charge:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.delivery_charge) + "\n", null);
            }
            if (orderDetail.offer_amount > 0) {
                woyouService.printText(padRightSpaces("Offer:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.offer_amount) + "\n", null);
            }
            if (orderDetail.service_charge > 0) {
                if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                    woyouService.printText(padRightSpaces("Service Charge:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.service_charge) + "\n", null);
                }
            }
            if (orderDetail.driver_tip > 0) {
                woyouService.printText(padRightSpaces("Driver Tip:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.driver_tip) + "\n", null);
            }
            if (orderDetail.reward_offer > 0) {
                woyouService.printText(padRightSpaces("Loyalty Point Discount:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.reward_offer) + "\n", null);
            }
            woyouService.setFontSize(36, null);
            woyouService.printText(padRightSpaces("Total:  ", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.order_grand_total) + "\n", null);

            woyouService.setFontSize(30, null);
            woyouService.setAlignment(1, null);
            woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);
            woyouService.setAlignment(0, null);
            if (!Validators.isNullOrEmpty(orderDetail.order_description)) {

                woyouService.sendRAWData(ESCUtil.boldOn(), null);
                woyouService.setFontSize(kitchenCopy ? 40 : 32, null);
                woyouService.printText("Comments: " + orderDetail.order_description + "\n", null);
                woyouService.sendRAWData(ESCUtil.boldOff(), null);

                woyouService.setAlignment(1, null);
                woyouService.setFontSize(26, null);
                woyouService.printText("" + Html.fromHtml("------------------------------------<br>"), null);

            }
            if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {

                woyouService.sendRAWData(ESCUtil.boldOn(), null);
                woyouService.setFontSize(32, null);
                woyouService.printText("Delivery Instructions: " + orderDetail.delivery_instruction + "\n", null);
                woyouService.sendRAWData(ESCUtil.boldOff(), null);
                woyouService.setAlignment(1, null);
                woyouService.setFontSize(26, null);
                woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            }
            woyouService.setAlignment(0, null);
            woyouService.setFontSize(32, null);
            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.printText("Cust Name: " + orderDetail.customer_name + "\n", null);

            if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                woyouService.printText("Cust No: " + orderDetail.customer_phone + "\n", null);
            }
            woyouService.sendRAWData(ESCUtil.boldOff(), null);
            woyouService.setAlignment(1, null);
            woyouService.setFontSize(30, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            if (orderType == 1) {

                String address = orderDetail.address + "\n";
                String[] parts = address.split("[\\\\s,]+");
                StringBuilder str = new StringBuilder();

                for (String name : parts) {
                    str.append(name).append("\n");
                }
                woyouService.setFontSize(32, null);
                woyouService.sendRAWData(ESCUtil.boldOn(), null);
                woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                woyouService.printText("Del. address: " + address, null);
                woyouService.sendRAWData(ESCUtil.boldOff(), null);

                woyouService.setFontSize(26, null);
                woyouService.setAlignment(1, null);
                woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
            }

            if (orderType >= 0) {
                woyouService.setAlignment(0, null);
                woyouService.setFontSize(36, null);
                woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                woyouService.printText("Requested for: ", null);
                if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                    woyouService.printText("ASAP" + "\n", null);
                } else {
                    woyouService.printText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", null);
                }
                woyouService.setFontSize(26, null);
                woyouService.setAlignment(1, null);
                woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

                woyouService.setAlignment(0, null);
                if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                    woyouService.setFontSize(36, null);
                    woyouService.setAlignment(AidlUtil.Alignment.LEFT, null);
                    woyouService.printText("Confirmed for: ", null);
                    woyouService.printText("" + orderDetail.preparation + "\n", null);
                    woyouService.setFontSize(26, null);
                    woyouService.setAlignment(1, null);
                    woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);
                }
            }
            woyouService.setAlignment(0, null);
            woyouService.setFontSize(36, null);
            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.printText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n", null);
            woyouService.sendRAWData(ESCUtil.boldOff(), null);


            woyouService.setFontSize(26, null);
            String paymentName = "";
            if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
            if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
            if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                paymentName = "WALLET";
            if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";
            woyouService.printText(" Payment Type : " + paymentName + "\n", null);

            woyouService.setFontSize(30, null);
            woyouService.setAlignment(1, null);
            woyouService.printText("" + Html.fromHtml("--------------------------------------<br>"), null);

            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.setAlignment(0, null);
            woyouService.setFontSize(32, null);
            woyouService.printText("Receipt Time:\n", null);
            woyouService.printText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", null);
            woyouService.sendRAWData(ESCUtil.boldOff(), null);

            woyouService.printText("Order status: " + orderDetail.status + "\n", null);
            if (orderDetail.status.equalsIgnoreCase("failed")) {
                woyouService.printText("Reason: " + orderDetail.failed_reason + "\n", null);
            }

            woyouService.sendRAWData(ESCUtil.boldOn(), null);
            woyouService.setFontSize(28, null);

            woyouService.printText(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address + "\n", null);
            woyouService.printText("Thanks!\n", null);

            woyouService.lineWrap(3, null);
            woyouService.sendRAWData(ESCUtil.cutPaper(), null);

        } catch (Exception e) {
            System.out.println(e);
        }

    }

    public void printOrderEpos(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, MyPreferences myPreferences, float voucherPaymentDoneAmount) {
        int style = 0, alignment = 0;
        float size = 0;
        boolean isbold = false, isUnderline = false;
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }
        try {
            if (!kitchenCopy && tiffintomLogo != null) {
                AidlUtil.getInstance().printBitmap(tiffintomLogo);
            }
            if (!Validators.isNullOrEmpty(ticket_header))
                if (!kitchenCopy) {
                    AidlUtil.getInstance().printText(ticket_header, AidlUtil.Size.SIZE0, true, false, headerAlignment);
                }

            if (structure.header_order_type.visibility && kitchenCopy) {
                switch (structure.header_order_type.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.header_order_type.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.header_order_type.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }

                if (!Validators.isNullOrEmpty(orderTypeHeading))
                    AidlUtil.getInstance().printText("** " + orderTypeHeading + " **", size, isbold, isUnderline, alignment);

            }
            // footer table number
            if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                switch (structure.footer_table_number.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.footer_table_number.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.footer_table_number.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }

                if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.CENTER);
                    AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number, size, isbold, isUnderline, alignment);
                }
            }
            // footer order number
            if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                switch (structure.footer_order_number.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.footer_order_number.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.footer_order_number.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }

                if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    if (orderDetail._id != 0) {
                        AidlUtil.getInstance().printText("Order No: " + orderDetail._id, size, isbold, isUnderline, alignment);
                    }
                } else {
                    AidlUtil.getInstance().printText("Order No: " + orderDetail.display_order_id, size, isbold, isUnderline, alignment);
                }
            }
            if (structure.header_customer_name.visibility) {
                switch (structure.header_customer_name.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.header_customer_name.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.header_customer_name.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                    AidlUtil.getInstance().printText(orderDetail.customer_name, size, isbold, isUnderline, alignment);
                }
            }
            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);

            if (structure.title.visibility && kitchenCopy) {
                switch (structure.title.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.title.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.title.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(title)) {
                    AidlUtil.getInstance().printText(title, size, isbold, isUnderline, alignment);
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }
            }

            if (structure.order_no.visibility) {
                switch (structure.order_no.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.order_no.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.order_no.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    if (orderDetail._id > 0)
                        AidlUtil.getInstance().printText("Order No: " + orderDetail._id, size, isbold, isUnderline, alignment);
                } else {
                    AidlUtil.getInstance().printText("Order No: " + orderDetail.display_order_id, size, isbold, isUnderline, alignment);
                }
                if (kitchenCopy) {
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }
            }

            if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                switch (structure.table_no.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.table_no.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.table_no.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.table_number))
                    AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number, size, isbold, isUnderline, alignment);

                switch (structure.no_of_diners.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.no_of_diners.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.no_of_diners.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.no_guest))
                    AidlUtil.getInstance().printText((("   No of Diners: ") + orderDetail.no_guest), size, isbold, isUnderline, alignment);

                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            } else if (structure.table_no.visibility && orderType == 1) {
                switch (structure.table_no.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.table_no.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.table_no.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                AidlUtil.getInstance().printText(("Table No: " + orderDetail.table_number), size, isbold, isUnderline, alignment);
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            } else if (structure.no_of_diners.visibility && orderType == 1) {
                switch (structure.no_of_diners.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.no_of_diners.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.no_of_diners.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.no_guest)) {
                    AidlUtil.getInstance().printText(("No of Diners: " + orderDetail.no_guest), size, isbold, isUnderline, alignment);
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }
            }
            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (orderDetail.updated_at.contains("Z")) {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                } else {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                }
            }
            if (structure.order_date != null) {
                if (structure.order_date.visibility) {
                    switch (structure.order_date.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.order_date.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.order_date.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                   /* if (!Validators.isNullOrEmpty(orderDate))
                        AidlUtil.getInstance().printText("Date :" + orderDate + " ", size, isbold, isUnderline, alignment);*/

                    if (!Validators.isNullOrEmpty(orderDate))
                        if (structure.order_time != null && structure.order_time.visibility) {
                            AidlUtil.getInstance().printText("Date :" + orderDate + " ", size, isbold, isUnderline, alignment);
                        } else {
                            AidlUtil.getInstance().printText("Date :" + orderDate + " ", size, isbold, isUnderline, alignment);
                            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                        }
                }
            }
            if (structure.order_time != null) {
                if (structure.order_time.visibility) {
                    switch (structure.order_time.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.order_time.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.order_time.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderTime)) {
                        AidlUtil.getInstance().printText("Time :" + orderTime, size, isbold, isUnderline, alignment);
                        AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                    }
                }
            }
/*
            else {
                if (!Validators.isNullOrEmpty(dateTimeMode)) {
                    String dateFormat = "dd-MM-yyyy hh:mm a";
                    String dateFormatTitle = "Order Date Time: ";
                    if (dateTimeMode.equalsIgnoreCase("date_time")) {
                        dateFormat = "dd-MM-yyyy hh:mm a";
                        dateFormatTitle = "Order Date Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("time")) {
                        dateFormat = "hh:mm a";
                        dateFormatTitle = "Order Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("date")) {
                        dateFormat = "dd-MM-yyyy";
                        dateFormatTitle = "Order Date: ";
                    }
                    if (orderDetail.created_at.contains("Z")) {
                        AidlUtil.getInstance().printText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat),
                                32, false, false, AidlUtil.Alignment.LEFT);
                    } else {
                        AidlUtil.getInstance().printText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, dateFormat),
                                32, false, false, AidlUtil.Alignment.LEFT);
                    }
                }
            }
*/

            if (orderType > 1 && !kitchenCopy) {
                if (!Validators.isNullOrEmpty(orderDetail.order_type))
                    AidlUtil.getInstance().printText("Order Type: " + orderDetail.order_type, AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }

            if (structure.items_header.visibility) {
                switch (structure.items_header.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.items_header.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.items_header.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                AidlUtil.getInstance().printText("Qty Name", size, isbold, isUnderline, alignment);
            }

            if (structure.items.visibility) {
                switch (structure.items.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.items.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.items.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                String itemName = "", price = "", qty = "";
                String lastBlockId = null;
                boolean lastItemWasMisc = false;

                for (OrderItem productDetail : orderDetail.order_items) {
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                    //String productQty = String.valueOf(productDetail.quantity);

                    String productQty;
                    if (kitchenCopy) {
                        productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                    } else {
                        productQty = String.valueOf(productDetail.quantity);
                    }
                    // Here we need 16 characters in product name so we send 16 in
                    // @params charactersInLine
                    price = (!kitchenCopy) ? MyApp.df.format(productDetail.total) : "";
                    if (kitchenCopy)
                        itemName = getProductNameWithPad(productName, price, 25);
                    else
                        itemName = getProductNameWithPad(productName, price, 28);
                    qty = productQty;
                    if (productQty.length() <= 1) {
                        qty = " " + productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }
                    if (lastBlockId != null) {
                        if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                            if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.CENTER);
                        }
                    } else {
                        if (lastItemWasMisc && !productDetail.misc) {
                            if (kitchenCopy)
                                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, isbold, isUnderline, AidlUtil.Alignment.CENTER);
                        }
                    }

                    String printItem;
                    printItem = qty + itemName.trim();
                    if (!kitchenCopy) {
                        AidlUtil.getInstance().printText(printItem, size, isbold, isUnderline, alignment);
                        if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                            AidlUtil.getInstance().printText("   Instruction: " + productDetail.special_instruction, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                    } else {
                        AidlUtil.getInstance().printText(printItem, size, isbold, isUnderline, alignment);
                        if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                            AidlUtil.getInstance().printText("   Instruction: " + productDetail.special_instruction, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                    }

                    if (productDetail.order_item_addons.size() > 0) {
                        if (structure.items_subaddon.visibility) {
                            switch (structure.items_header.style) {
                                case "default":
                                    isbold = false;
                                    isUnderline = false;
                                    break;
                                case "bold":
                                    isbold = true;
                                    isUnderline = false;
                                    break;
                                case "underline":
                                    isbold = false;
                                    isUnderline = true;
                                    break;
                                default:
                                    isbold = false;
                                    isUnderline = false;
                                    break;
                            }

                            switch (structure.items_header.size) {
                                case "size0":
                                    size = AidlUtil.Size.SIZE0;
                                    break;
                                case "size1":
                                    size = AidlUtil.Size.SIZE1;
                                    break;
                                case "size2":
                                    size = AidlUtil.Size.SIZE2;
                                    break;
                                case "size3":
                                    size = AidlUtil.Size.SIZE3;
                                    break;
                                case "size4":
                                    size = AidlUtil.Size.SIZE4;
                                    break;
                                case "size5":
                                    size = AidlUtil.Size.SIZE5;
                                    break;
                                default:
                                    size = AidlUtil.Size.SIZE0;
                                    break;
                            }

                            switch (structure.items_header.alignment) {
                                case "left":
                                    alignment = AidlUtil.Alignment.LEFT;
                                    break;
                                case "center":
                                    alignment = AidlUtil.Alignment.CENTER;
                                    break;
                                case "right":
                                    alignment = AidlUtil.Alignment.RIGHT;
                                    break;
                                default:
                                    alignment = AidlUtil.Alignment.LEFT;
                                    break;
                            }
                            AidlUtil.getInstance().printText("Choose Your Base:", size, isbold, isUnderline, alignment);
                        }

                        for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                            List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                            if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                continue;
                            }
                            productQty = orderItemAddon.quantity + "";
                            productName = orderItemAddon.addon_name + "";
                            price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                            if (kitchenCopy)
                                itemName = getProductNameWithPad(productName, price, 25);
                            else
                                itemName = getProductNameWithPad(productName, price, 28);
                            qty = productQty;
                            if (productQty.length() <= 1) {
                                qty = " " + productQty + " ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + " ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + " ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "";
                            }
                            //printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? itemName.trim() : qty + itemName.trim();
                            // adding qty when total or price is zero as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                            if (orderItemAddon.quantity > 1) {
                                printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? qty + itemName.trim() : qty + itemName.trim();
                            } else {
                                printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? itemName.trim() : itemName.trim();
                            }
                            AidlUtil.getInstance().printText(printItem, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                           /* if (!kitchenCopy) {
                                String subdomainPrintText = getSubaddonWithPad(orderItemAddon.addon_name, 30);
                                AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                            } else {
                                String subdomainPrintText = getSubaddonWithPad(orderItemAddon.addon_name, 30);
                                AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                            }*/
                        }
                    }

                    for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                        String ingredientName = orderItemIngredient.ingredient_name;
                        if (orderItemIngredient.with) {
                            ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                        }
                        if (orderItemIngredient.without) {
                            ingredientName = "No " + ingredientName;
                        }
                        if (!kitchenCopy) {
                            String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                            AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                        } else {
                            String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                            AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                        }
                    }

                    lastItemWasMisc = productDetail.misc;
                    lastBlockId = productDetail.block_id;
                }
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }

            if (printTotalInPrint) {
                if (structure.subtotal.visibility) {
                    switch (structure.subtotal.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.subtotal.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.subtotal.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    AidlUtil.getInstance().printText(("SubTotal :") + MyApp.df.format(orderDetail.sub_total), size, isbold, isUnderline, alignment);
                }

                if (structure.gratuity.visibility) {
                    switch (structure.gratuity.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.gratuity.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.gratuity.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.gratuity > 0) {
                        AidlUtil.getInstance().printText(("Gratuity :") + MyApp.df.format(orderDetail.gratuity), size, isbold, isUnderline, alignment);
                    }
                }

                if (structure.discount.visibility) {
                    switch (structure.discount.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.discount.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.discount.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.discount > 0) {
                        AidlUtil.getInstance().printText(("Discount :") + MyApp.df.format(orderDetail.discount), size, isbold, isUnderline, alignment);
                    }
                }

                if (structure.delivery_charge.visibility) {
                    switch (structure.delivery_charge.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.delivery_charge.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.delivery_charge.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.delivery_charge > 0) {
                        AidlUtil.getInstance().printText(("Delivery charge :") + MyApp.df.format(orderDetail.delivery_charge), size, isbold, isUnderline, alignment);
                    }
                }

                if (structure.service_charge.visibility) {
                    switch (structure.service_charge.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.service_charge.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.service_charge.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.service_charge > 0) {
                        AidlUtil.getInstance().printText(("Service charge :") + MyApp.df.format(orderDetail.service_charge), size, isbold, isUnderline, alignment);
                    }
                }

                if (structure.grand_total.visibility) {
                    switch (structure.grand_total.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.grand_total.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.grand_total.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    AidlUtil.getInstance().printText("Total : " + MyApp.df.format(orderDetail.total - voucherPaymentDoneAmount), size, isbold, isUnderline, alignment);
                }

                if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                        structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility) {
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }
            }
            if (structure.payment_detail_header != null)
                if (structure.payment_detail_header.visibility) {
                    switch (structure.payment_detail_header.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.payment_detail_header.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.payment_detail_header.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    AidlUtil.getInstance().printText("Payment Details: ", size, isbold, isUnderline, alignment);
                }

            if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                if (structure.payment_detail != null) {
                    if (structure.payment_detail.visibility) {
                        switch (structure.payment_detail.style) {
                            case "default":
                                isbold = false;
                                isUnderline = false;
                                break;
                            case "bold":
                                isbold = true;
                                isUnderline = false;
                                break;
                            case "underline":
                                isbold = false;
                                isUnderline = true;
                                break;
                            default:
                                isbold = false;
                                isUnderline = false;
                                break;
                        }

                        switch (structure.payment_detail.size) {
                            case "size0":
                                size = AidlUtil.Size.SIZE0;
                                break;
                            case "size1":
                                size = AidlUtil.Size.SIZE1;
                                break;
                            case "size2":
                                size = AidlUtil.Size.SIZE2;
                                break;
                            case "size3":
                                size = AidlUtil.Size.SIZE3;
                                break;
                            case "size4":
                                size = AidlUtil.Size.SIZE4;
                                break;
                            case "size5":
                                size = AidlUtil.Size.SIZE5;
                                break;
                            default:
                                size = AidlUtil.Size.SIZE0;
                                break;
                        }

                        switch (structure.payment_detail.alignment) {
                            case "left":
                                alignment = AidlUtil.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = AidlUtil.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = AidlUtil.Alignment.RIGHT;
                                break;
                            default:
                                alignment = AidlUtil.Alignment.LEFT;
                                break;
                        }
                        for (OrderPayment orderPayment : orderDetail.order_payments) {
                            String paymentDetailToPrint = null;
                            if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                            } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                            } else {
                                paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                            }
                            AidlUtil.getInstance().printText(paymentDetailToPrint, size, isbold, isUnderline, alignment);
                        }
                        AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                    } else
                        AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                } else {
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }
            }
            if (structure.serve_by.visibility) {
                switch (structure.serve_by.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.serve_by.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.serve_by.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                AidlUtil.getInstance().printText(toprint, size, isbold, isUnderline, alignment);
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }

            if (structure.customer_detail != null)
                if (structure.customer_detail.visibility) {
                    switch (structure.customer_detail.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.customer_detail.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.customer_detail.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        AidlUtil.getInstance().printText("Cust Name:" + orderDetail.customer_name, size, isbold, isUnderline, alignment);
                    }

                    if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                        AidlUtil.getInstance().printText("Cust No:" + orderDetail.customer.mobile, size, isbold, isUnderline, alignment);
                    }
                    String fulladdress = null;
                    if (orderType == 3) {
                        fulladdress = "Address : " + orderDetail.customer.house_no + ","
                                + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                        AidlUtil.getInstance().printText(fulladdress, size, isbold, isUnderline, alignment);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress))
                        AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }

            if (structure.payment_status != null)
                if (structure.payment_status.visibility) {
                    switch (structure.payment_status.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.payment_status.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.payment_status.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                        AidlUtil.getInstance().printText("Payment Status: " + settingMap.get("unpaid_payment_title"), size, isbold, isUnderline, alignment);
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                        AidlUtil.getInstance().printText("Payment Status: " + settingMap.get("paid_payment_title"), size, isbold, isUnderline, alignment);
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                        AidlUtil.getInstance().printText("Payment Status: " + settingMap.get("partial_payment_title"), size, isbold, isUnderline, alignment);
                    }
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }

            if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                AidlUtil.getInstance().printText("Comment: " + orderDetail.comment, kitchenCopy ? AidlUtil.Size.SIZE1 : AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }

            if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                AidlUtil.getInstance().printText("Requested Time" + orderDetail.delivery_collection_time_slot, AidlUtil.Size.SIZE1, true, false, AidlUtil.Alignment.LEFT);
            }
            if (structure.footer_order_type != null)
                if (structure.footer_order_type.visibility && kitchenCopy) {
                    switch (structure.footer_order_type.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.footer_order_type.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.footer_order_type.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                        AidlUtil.getInstance().printText("** " + orderTypeHeading + " **", size, isbold, isUnderline, alignment);
                    }

                }
            // footer table number
            if (structure.footer_table_number != null)
                if (structure.footer_table_number.visibility && kitchenCopy) {
                    switch (structure.footer_table_number.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.footer_table_number.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.footer_table_number.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                        AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                        AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number + "\n", size, isbold, isUnderline, alignment);
                    }

                }
            // footer order number
            if (structure.footer_order_number != null)
                if (structure.footer_order_number.visibility && kitchenCopy) {
                    switch (structure.footer_order_number.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.footer_order_number.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.footer_order_number.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        if (orderDetail._id != 0) {
                            AidlUtil.getInstance().printText("Order No: " + orderDetail._id + "\n", size, isbold, isUnderline, alignment);
                        }
                    } else {
                        AidlUtil.getInstance().printText("Order No: " + orderDetail.display_order_id + "\n", size, isbold, isUnderline, alignment);
                    }
                }
            if (structure.header_customer_name != null)
                if (structure.header_customer_name.visibility) {
                    switch (structure.header_customer_name.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        AidlUtil.getInstance().printText(orderDetail.customer_name, size, isbold, isUnderline, alignment);
                    }
                }

            if (structure.receipt_time != null && structure.receipt_time.visibility && !Validators.isNullOrEmpty(receiptDate)) {
                switch (structure.receipt_time.style) {
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.receipt_time.size) {
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.receipt_time.alignment) {
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                AidlUtil.getInstance().printText("Receipt Date :" + receiptDate, size, isbold, isUnderline, alignment);
            }

            if (structure.footer != null)
                if (structure.footer.visibility) {
                    switch (structure.footer.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.footer.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.footer.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(footerA)) {
                        AidlUtil.getInstance().printText(footerA, size, isbold, isUnderline, alignment);
                    }
                    if (!Validators.isNullOrEmpty(footerB)) {
                        AidlUtil.getInstance().printText(footerB, size, isbold, isUnderline, alignment);
                    }
                }

            if(!kitchenCopy && MyApp.getInstance().paymentLinkBitmap!=null){
                AidlUtil.getInstance().printText("\n\n", size, isbold, isUnderline, alignment);
                AidlUtil.getInstance().printBitmap(MyApp.getInstance().paymentLinkBitmap);
            }
            // set print true for local device
            setPrint(myPreferences, true);
            AidlUtil.getInstance().CutPaper();

            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title != null ? title : "");
            sendOrderWifiModel.setTicketHeaderSetting(ticket_header != null ? ticket_header : "");
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
            sendOrderWifiModel.setOrderDetail(orderDetail);
            sendOrderWifiModel.setPrintStructure(structure);
            sendOrderWifiModel.setFooterA(footerA != null ? footerA : "");
            sendOrderWifiModel.setFooterB(footerB != null ? footerB : "");
            sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading != null ? orderTypeHeading : "");
            sendOrderWifiModel.setSettingsMap(settingMap);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            if (printBlockBill != null) {
                sendOrderWifiModel.setPrintBlockBill(printBlockBill);
            }
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOS);
            sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username != null ? MyApp.getInstance().myPreferences.getLoggedInUser().username : "");
            sendOrderToWifi(sendOrderWifiModel);
        } catch (Exception e) {
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title != null ? title : "");
            sendOrderWifiModel.setTicketHeaderSetting(ticket_header != null ? ticket_header : "");
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
            sendOrderWifiModel.setOrderDetail(orderDetail);
            sendOrderWifiModel.setPrintStructure(structure);
            sendOrderWifiModel.setFooterA(footerA != null ? footerA : "");
            sendOrderWifiModel.setFooterB(footerB != null ? footerB : "");
            sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading != null ? orderTypeHeading : "");
            sendOrderWifiModel.setSettingsMap(settingMap);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            if (printBlockBill != null) {
                sendOrderWifiModel.setPrintBlockBill(printBlockBill);
            }
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOS);
            sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username != null ? MyApp.getInstance().myPreferences.getLoggedInUser().username : "");
            sendOrderToWifi(sendOrderWifiModel);
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);

    public void printSeparator() {
        AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
    }

    public void printOrderEposFoodHubSeqeunce(ArrayList<PrintStyle> listPrintStructure, Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, MyPreferences myPreferences, float voucherPaymentDoneAmount) {
        int style = 0, alignment = 0;
        float size = 0;
        boolean isbold = false, isUnderline = false;
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }
        try {
            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (orderDetail.updated_at.contains("Z")) {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                } else {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                }
            }
            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                boolean priceInItems = listPrintStructure.get(i).price;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean isBlockName = listPrintStructure.get(i).block_name;
                switch (listPrintStructure.get(i).style) {
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }
                switch (listPrintStructure.get(i).size) {
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }
                switch (listPrintStructure.get(i).alignment) {
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                boolean isSeparator = listPrintStructure.get(i).separator;
                switch (key) {
                    case "logo": {
                        if (!kitchenCopy && tiffintomLogo != null) {
                            AidlUtil.getInstance().printBitmap(tiffintomLogo);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "ticket_header": {
                        if (!Validators.isNullOrEmpty(ticket_header))
                            if (!kitchenCopy) {
                                AidlUtil.getInstance().printText(ticket_header, AidlUtil.Size.SIZE0, true, false, headerAlignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        break;
                    }
                    case "header_order_type":
                    case "footer_order_type": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                                AidlUtil.getInstance().printText("" + orderTypeHeading.toUpperCase() + "", size, isbold, isUnderline, alignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer_table_number": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                                //AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.CENTER);
                                AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number, size, isbold, isUnderline, alignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer_order_number": {
                        if (kitchenCopy) {
                            if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                                if (orderDetail._id != 0) {
                                    AidlUtil.getInstance().printText("Order No: " + orderDetail._id, size, isbold, isUnderline, alignment);
                                    if (isSeparator) {
                                        printSeparator();
                                    }
                                }
                            } else {
                                AidlUtil.getInstance().printText("Order No: " + orderDetail.display_order_id, size, isbold, isUnderline, alignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "header_customer_name": {
                        if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            AidlUtil.getInstance().printText(orderDetail.customer_name, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "title": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(title)) {
                                AidlUtil.getInstance().printText(title, size, isbold, isUnderline, alignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "order_no": {
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            if (orderDetail._id > 0)
                                AidlUtil.getInstance().printText("" + orderDetail._id, size, isbold, isUnderline, alignment);
                        } else {
                            AidlUtil.getInstance().printText("" + orderDetail.display_order_id, size, isbold, isUnderline, alignment);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "table_no": {
                        if (orderType == 1) {
                            AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number + "\n", size, isbold, isUnderline, alignment);
                            if (!structure.no_of_diners.visibility) {
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "no_of_diners": {
                        if (orderType == 1) {
                            AidlUtil.getInstance().printText("   No of Diner: " + orderDetail.no_guest, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_date": {
                        if (!Validators.isNullOrEmpty(orderDate))
                            if (structure.order_time != null && structure.order_time.visibility) {
                                AidlUtil.getInstance().printText("Date :" + orderDate + " ", size, isbold, isUnderline, alignment);
                            } else {
                                AidlUtil.getInstance().printText("Date :" + orderDate + " ", size, isbold, isUnderline, alignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        break;
                    }
                    case "order_time": {
                        if (!Validators.isNullOrEmpty(orderTime)) {
                            AidlUtil.getInstance().printText("Time :" + orderTime, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "receipt_time": {
                        if (!Validators.isNullOrEmpty(receiptDate)) {
                            AidlUtil.getInstance().printText("Receipt Date :" + receiptDate, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_type": {
                        if (orderType > 1) {
                            if (!Validators.isNullOrEmpty(orderDetail.order_type)) {
                                AidlUtil.getInstance().printText("Order Type: " + orderDetail.order_type + "", size, isbold, isUnderline, alignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "items_header": {
                        AidlUtil.getInstance().printText("Qty Name", size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "items": {
                        String itemName = "", price = "", qty = "";
                        String lastBlockId = null;
                        boolean lastItemWasMisc = false;
                        int position = 0;
                        for (OrderItem productDetail : orderDetail.order_items) {
                            switch (structure.items.style) {
                                case "bold":
                                    isbold = true;
                                    isUnderline = false;
                                    break;
                                case "underline":
                                    isbold = false;
                                    isUnderline = true;
                                    break;
                                default:
                                    isbold = false;
                                    isUnderline = false;
                                    break;
                            }
                            switch (structure.items.size) {
                                case "size1":
                                    size = AidlUtil.Size.SIZE1;
                                    break;
                                case "size2":
                                    size = AidlUtil.Size.SIZE2;
                                    break;
                                case "size3":
                                    size = AidlUtil.Size.SIZE3;
                                    break;
                                case "size4":
                                    size = AidlUtil.Size.SIZE4;
                                    break;
                                case "size5":
                                    size = AidlUtil.Size.SIZE5;
                                    break;
                                default:
                                    size = AidlUtil.Size.SIZE0;
                                    break;
                            }
                            switch (structure.items.alignment) {
                                case "center":
                                    alignment = AidlUtil.Alignment.CENTER;
                                    break;
                                case "right":
                                    alignment = AidlUtil.Alignment.RIGHT;
                                    break;
                                default:
                                    alignment = AidlUtil.Alignment.LEFT;
                                    break;
                            }

                            position = position + 1;
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                            //String productQty = String.valueOf(productDetail.quantity);

                            String productQty;
                            if (kitchenCopy) {
                                productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                            } else {
                                productQty = String.valueOf(productDetail.quantity);
                            }
                            // Here we need 16 characters in product name so we send 16 in
                            // @params charactersInLine
                            price = (priceInItems) ? MyApp.df.format(productDetail.total) : "";
                           /* if (kitchenCopy)
                                itemName = getProductNameWithPad(productName, price, 25);
                            else
                                itemName = getProductNameWithPad(productName, price, 28);*/
                            itemName = getProductNameWithPad(productName, price, 28);
                            qty = productQty;
                            if (productQty.length() <= 1) {
                                qty = " " + productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }

                            if (!all_separator) {
                                if (lastBlockId != null) {
                                    if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                        if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                            printBlockText(productDetail,isBlockName);
                                    }
                                } else {
                                    if (lastItemWasMisc && !productDetail.misc) {
                                        if (kitchenCopy)
                                            printBlockText(productDetail,isBlockName);
                                    }
                                }
                            }


                            String printItem;
                            printItem = qty + itemName.trim();
                            // if size 0 or 1 format product name
                            if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                                String finalPrice = "  " + price;
                                itemName = calculteNumberOfLines(productName, finalPrice, size, qty);
                                printItem = itemName;
                            }
                            AidlUtil.getInstance().printText(printItem, size, isbold, isUnderline, alignment);
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                AidlUtil.getInstance().printText("   Instruction: " + productDetail.special_instruction, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);

                            if (productDetail.order_item_addons.size() > 0) {
                                switch (structure.items_subaddon.style) {
                                    case "bold":
                                        isbold = true;
                                        isUnderline = false;
                                        break;
                                    case "underline":
                                        isbold = false;
                                        isUnderline = true;
                                        break;
                                    default:
                                        isbold = false;
                                        isUnderline = false;
                                        break;
                                }
                                switch (structure.items_subaddon.size) {
                                    case "size1":
                                        size = AidlUtil.Size.SIZE1;
                                        break;
                                    case "size2":
                                        size = AidlUtil.Size.SIZE2;
                                        break;
                                    case "size3":
                                        size = AidlUtil.Size.SIZE3;
                                        break;
                                    case "size4":
                                        size = AidlUtil.Size.SIZE4;
                                        break;
                                    case "size5":
                                        size = AidlUtil.Size.SIZE5;
                                        break;
                                    default:
                                        size = AidlUtil.Size.SIZE0;
                                        break;
                                }
                                switch (structure.items_subaddon.alignment) {
                                    case "center":
                                        alignment = AidlUtil.Alignment.CENTER;
                                        break;
                                    case "right":
                                        alignment = AidlUtil.Alignment.RIGHT;
                                        break;
                                    default:
                                        alignment = AidlUtil.Alignment.LEFT;
                                        break;
                                }

                                if (structure.items_subaddon.visibility) {
                                    AidlUtil.getInstance().printText("Choose Your Base:", size, isbold, isUnderline, alignment);
                                }
                                for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                    List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                    if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                        continue;
                                    }
                                    productQty = orderItemAddon.quantity + "";
                                    productName = orderItemAddon.addon_name + "";
                                    price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                                    if (kitchenCopy)
                                        itemName = getProductNameWithPad(productName, price, 25);
                                    else
                                        itemName = getProductNameWithPad(productName, price, 28);
                                    qty = productQty;
                                    /*if (productQty.length() <= 1) {
                                        qty = " " + productQty + "x ";
                                    } else if (productQty.length() <= 2) {
                                        qty = productQty + "x ";

                                    } else if (productQty.length() <= 3) {
                                        qty = productQty + "x ";

                                    } else if (productQty.length() <= 4) {
                                        qty = productQty + "x";
                                    }*/
                                    //printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? itemName.trim() : qty + itemName.trim();
                                    // adding qty when total or price is zero as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                    if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                                        if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                            if (orderItemAddon.quantity > 1) {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "  - " + orderItemAddon.quantity + "x");
                                            } else {
                                                if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                    printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "");
                                                } else {
                                                    printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "  -   ");
                                                }
                                            }
                                        } else {
                                            if (orderItemAddon.quantity > 1) {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), size, "  - " + orderItemAddon.addon_name + "x");
                                            } else {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), size, "  -   ");
                                            }
                                        }
                                        AidlUtil.getInstance().printText(printItem + "", size, isbold, isUnderline, alignment);
                                    } else {
                                        if (orderItemAddon.quantity > 1) {
                                            //printItem = qty + itemName.trim();
                                            printItem = "- " + qty + "x " + itemName.trim();
                                        } else {
                                            if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                printItem = "" + itemName.trim();
                                            } else {
                                                printItem = "- 1x " + itemName.trim();
                                            }
                                        }
                                        AidlUtil.getInstance().printText(printItem, size, isbold, isUnderline, alignment);
                                    }
                           /* if (!kitchenCopy) {
                                String subdomainPrintText = getSubaddonWithPad(orderItemAddon.addon_name, 30);
                                AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                            } else {
                                String subdomainPrintText = getSubaddonWithPad(orderItemAddon.addon_name, 30);
                                AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                            }*/
                                }
                            }

                            for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                                String ingredientName = orderItemIngredient.ingredient_name;
                                if (orderItemIngredient.with) {
                                    ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                                }
                                if (orderItemIngredient.without) {
                                    ingredientName = "No " + ingredientName;
                                }
                                if (!kitchenCopy) {
                                    String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                                    AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                                } else {
                                    String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                                    AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                                }
                            }

                            lastItemWasMisc = productDetail.misc;
                            lastBlockId = productDetail.block_id;

                            if (all_separator && orderDetail.order_items.size() > position) {
                                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                            }
                            if (!all_separator && isBlockName) {
                                AidlUtil.getInstance().printText("\n", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                            }
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "subtotal":
                    case "gratuity":
                    case "delivery_charge":
                    case "service_charge":
                    case "grand_total":
                    case "discount": {
                        if (printTotalInPrint) {
                            String formattedValue = "";
                            String titleOfTotal = "";
                            if (key.equalsIgnoreCase("gratuity")) {
                                if (orderDetail.gratuity > 0) {
                                    formattedValue = MyApp.df.format(orderDetail.gratuity);
                                }
                                titleOfTotal = "GRATUITY";
                            } else if (key.equalsIgnoreCase("discount")) {
                                if (orderDetail.discount > 0)
                                    formattedValue = MyApp.df.format(orderDetail.discount);
                                titleOfTotal = "DISCOUNT";
                            } else if (key.equalsIgnoreCase("grand_total")) {
                                if (orderDetail.total > 0) {
                                    formattedValue = MyApp.df.format(orderDetail.total - voucherPaymentDoneAmount);
                                }
                                titleOfTotal = "TOTAL";
                            } else if (key.equalsIgnoreCase("service_charge")) {
                                if (orderDetail.service_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.service_charge);
                                titleOfTotal = "SERVICE CHARGE";
                            } else if (key.equalsIgnoreCase("delivery_charge")) {
                                if (orderDetail.delivery_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.delivery_charge);
                                titleOfTotal = "DELIVERY CHARGE";
                            } else if (key.equalsIgnoreCase("subtotal")) {
                                formattedValue = MyApp.df.format(orderDetail.sub_total);
                                titleOfTotal = "SUB TOTAL";
                            }
                            if (!Validators.isNullOrEmpty(formattedValue)) {
                                int length = formattedValue.length();
                                String price = null;
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        price = "    " + formattedValue;
                                    }
                                    if (length == 5) {
                                        price = "   " + formattedValue;
                                    }

                                    if (length == 6) {
                                        price = "  " + formattedValue;
                                    }
                                    if (length == 7) {
                                        price = " " + formattedValue;
                                    }
                                } else {
                                    price = formatter.format(orderDetail.sub_total);
                                }
                                String finalTitleToPrint = "";
                                finalTitleToPrint = formatTotal(size, titleOfTotal, price);
                                /*if (length == 3){
                                    if(size==AidlUtil.Size.SIZE1){
                                        padRightSpaces(titleOfTotal+price, 24);
                                    }else {
                                        finalTitleToPrint = getProductNameWithPad( titleOfTotal , price, 44);
                                    }
                                }
                                else if (length <= 8 && length >= 4){
                                    if(size==AidlUtil.Size.SIZE1){
                                        finalTitleToPrint= padRightSpaces(titleOfTotal, 20)+""+price;
                                    }else{
                                        finalTitleToPrint = getProductNameWithPad( titleOfTotal , price, 43);
                                    }
                                }
                                else{
                                    finalTitleToPrint = getProductNameWithPad( titleOfTotal , price, 38);
                                }*/
                                AidlUtil.getInstance().printText(finalTitleToPrint, size, isbold, isUnderline, alignment);
                            }
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_detail_header": {
                        AidlUtil.getInstance().printText("Payment Details: ", size, isbold, isUnderline, alignment);
                        break;
                    }
                    case "payment_detail": {
                        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                            for (OrderPayment orderPayment : orderDetail.order_payments) {
                                String paymentDetailToPrint = null;
                                if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                    paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                                } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                    paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else {
                                    paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                                }
                                AidlUtil.getInstance().printText(paymentDetailToPrint, size, isbold, isUnderline, alignment);
                            }
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "serve_by": {
                        String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                        AidlUtil.getInstance().printText(toprint, size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "customer_detail": {
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            AidlUtil.getInstance().printText("" + orderDetail.customer_name, size, isbold, isUnderline, alignment);
                        }
                        String fulladdress = null;
                        if (orderType == 3) {
                            fulladdress = formatAddress(orderDetail);
                            AidlUtil.getInstance().printText(fulladdress, size, isbold, isUnderline, alignment);
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                            AidlUtil.getInstance().printText("" + orderDetail.customer.mobile, size, isbold, isUnderline, alignment);
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)) {
                            //AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_status": {
                        if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                            AidlUtil.getInstance().printText("" + settingMap.get("unpaid_payment_title").toUpperCase(), size, isbold, isUnderline, alignment);
                        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                            AidlUtil.getInstance().printText("" + settingMap.get("paid_payment_title").toUpperCase(), size, isbold, isUnderline, alignment);
                        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                            AidlUtil.getInstance().printText("" + settingMap.get("partial_payment_title").toUpperCase(), size, isbold, isUnderline, alignment);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "footer": {
                        if (!Validators.isNullOrEmpty(footerA)) {
                            AidlUtil.getInstance().printText(footerA, size, isbold, isUnderline, alignment);
                        }
                        if (!Validators.isNullOrEmpty(footerB)) {
                            AidlUtil.getInstance().printText(footerB, size, isbold, isUnderline, alignment);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                AidlUtil.getInstance().printText("Comment: " + orderDetail.comment, kitchenCopy ? AidlUtil.Size.SIZE1 : AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }
            if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                AidlUtil.getInstance().printText("Requested Time" + orderDetail.delivery_collection_time_slot, AidlUtil.Size.SIZE1, true, false, AidlUtil.Alignment.LEFT);
            }
            if(!kitchenCopy && MyApp.getInstance().paymentLinkBitmap!=null){
                AidlUtil.getInstance().printText("\n\n", size, isbold, isUnderline, alignment);
                AidlUtil.getInstance().printBitmap(MyApp.getInstance().paymentLinkBitmap);
            }
            // set print true for local device
            setPrint(myPreferences, true);
            AidlUtil.getInstance().CutPaper();

            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title != null ? title : "");
            sendOrderWifiModel.setTicketHeaderSetting(ticket_header != null ? ticket_header : "");
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
            sendOrderWifiModel.setOrderDetail(orderDetail);
            sendOrderWifiModel.setPrintStructure(structure);
            sendOrderWifiModel.setFooterA(footerA != null ? footerA : "");
            sendOrderWifiModel.setFooterB(footerB != null ? footerB : "");
            sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading != null ? orderTypeHeading : "");
            sendOrderWifiModel.setSettingsMap(settingMap);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            if (printBlockBill != null) {
                sendOrderWifiModel.setPrintBlockBill(printBlockBill);
            }
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOS);
            sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username != null ? MyApp.getInstance().myPreferences.getLoggedInUser().username : "");
            sendOrderToWifi(sendOrderWifiModel);
        } catch (Exception e) {
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title != null ? title : "");
            sendOrderWifiModel.setTicketHeaderSetting(ticket_header != null ? ticket_header : "");
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
            sendOrderWifiModel.setOrderDetail(orderDetail);
            sendOrderWifiModel.setPrintStructure(structure);
            sendOrderWifiModel.setFooterA(footerA != null ? footerA : "");
            sendOrderWifiModel.setFooterB(footerB != null ? footerB : "");
            sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading != null ? orderTypeHeading : "");
            sendOrderWifiModel.setSettingsMap(settingMap);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            if (printBlockBill != null) {
                sendOrderWifiModel.setPrintBlockBill(printBlockBill);
            }
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOS);
            sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username != null ? MyApp.getInstance().myPreferences.getLoggedInUser().username : "");
            sendOrderToWifi(sendOrderWifiModel);
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    private void printBlockText(OrderItem productDetail,boolean isBlockName){
        if(Validators.isNullOrEmpty(productDetail.block_name) || !isBlockName){
            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.CENTER);
        }else {
            AidlUtil.getInstance().printText(myApp.getBlockText(37,productDetail.block_name)+"\n", AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.CENTER);
        }
    }

    private String calculteNumberOfLines(String productName, String price, float size, String qty) {
        String[] productNameSplit = productName.split(" ");
        String finalPrice = "  " + price;
        String secondLine = qty;
        int lengthForSize = size == AidlUtil.Size.SIZE0 ? 38 : 28;
        if (size == AidlUtil.Size.SIZE0) {
            lengthForSize = 38;
        } else if (size == AidlUtil.Size.SIZE1) {
            lengthForSize = 28;
        } else {
            lengthForSize = 22;
        }
        int multiplyLength = 1;
        int index = 0;
        for (String s : productNameSplit) {
            index = index + 1;
            Log.e("finalPrice", "finalPrice " + finalPrice + "string to apend " + s.length());
            if (secondLine.length() < (multiplyLength * lengthForSize)) {
                if ((secondLine + " " + s + finalPrice).length() > (multiplyLength * lengthForSize)) {
                    //secondLine = secondLine+secondLine.replace(,"");
                    int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                    if (multiplyLength == 1) {
                        emptySpaceLength = emptySpaceLength - finalPrice.length();
                        for (int space = 0; space < emptySpaceLength; space++) {
                            secondLine = secondLine + (" ");
                        }
                        secondLine = secondLine + finalPrice;
                    } else {
                        for (int space = 0; space < emptySpaceLength; space++) {
                            secondLine = secondLine + (" ");
                        }
                    }
                    multiplyLength = multiplyLength + 1;
                    secondLine = secondLine + ("\n");
                    for (int j = 0; j < qty.length(); j++) {
                        secondLine = secondLine + (" ");
                    }
                }
            } else {
                multiplyLength = multiplyLength + 1;
                secondLine = secondLine + ("\n");
                for (int j = 0; j < qty.length(); j++) {
                    secondLine = secondLine + (" ");
                }
            }
            secondLine = secondLine + " " + s;
            if (productNameSplit.length == index && multiplyLength == 1 && secondLine.length() < (multiplyLength * lengthForSize)) {
                if (multiplyLength == 1) {
                    int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                    emptySpaceLength = emptySpaceLength - finalPrice.length();
                    for (int space = 0; space < emptySpaceLength; space++) {
                        secondLine = secondLine + (" ");
                    }
                    secondLine = secondLine + finalPrice;
                }
            }
        }
        return secondLine;
    }

    private String formatAddress(Order orderDetail) {
        String fulladdress = null;
        if (Validators.isNullOrEmpty(orderDetail.customer.house_no)) {
            fulladdress = orderDetail.customer.street + "\n";
        } else {
            fulladdress = "" + orderDetail.customer.house_no + " " + orderDetail.customer.street + "\n";
        }
        if (!Validators.isNullOrEmpty(orderDetail.customer.city)) {
            fulladdress = fulladdress + "" + orderDetail.customer.city;

            if (!Validators.isNullOrEmpty(orderDetail.customer.postcode)) {
                fulladdress = fulladdress + " " + orderDetail.customer.postcode;
            }
        }
        return fulladdress;
    }

    public void printOrderEposNew(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, PrintStructure structure, boolean printTotalInPrint, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        int style = 0, alignment = 0;
        float size = 0;
        boolean isbold = false, isUnderline = false;

        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        if (!kitchenCopy && tiffintomLogo != null) {
            AidlUtil.getInstance().printBitmap(tiffintomLogo);
        }
        if (!kitchenCopy) {
            AidlUtil.getInstance().printText(ticket_header, AidlUtil.Size.SIZE0, true, false, headerAlignment);
        }
        if (kitchenCopy) {
            if (structure.header_order_type.visibility) {
                switch (structure.header_order_type.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.header_order_type.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.header_order_type.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }

                if (!Validators.isNullOrEmpty(orderTypeHeading))
                    AidlUtil.getInstance().printText("** " + orderTypeHeading + " **", size, isbold, isUnderline, alignment);

            }
            // footer table number
            if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                switch (structure.footer_table_number.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.footer_table_number.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.footer_table_number.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }

                if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.CENTER);
                    AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number, size, isbold, isUnderline, alignment);
                }
            }
            // footer order number
            if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                switch (structure.footer_order_number.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.footer_order_number.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.footer_order_number.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }

                if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    if (orderDetail._id != 0) {
                        AidlUtil.getInstance().printText("Order No: " + orderDetail._id, size, isbold, isUnderline, alignment);
                    }
                } else {
                    AidlUtil.getInstance().printText("Order No: " + orderDetail.display_order_id, size, isbold, isUnderline, alignment);
                }
            }
            if (structure.header_customer_name.visibility) {
                switch (structure.header_customer_name.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.header_customer_name.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.header_customer_name.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                    AidlUtil.getInstance().printText(orderDetail.customer_name, size, isbold, isUnderline, alignment);
                }
            }
            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.CENTER);

            if (structure.title.visibility) {
                switch (structure.title.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.title.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.title.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(title)) {
                    AidlUtil.getInstance().printText(title, size, isbold, isUnderline, alignment);
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }
            }

        }

        if (structure.order_no != null) {
            if (structure.order_no.visibility) {
                switch (structure.order_no.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.order_no.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.order_no.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                String orderIdText = null;
                if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    orderIdText = "Order ID: " + orderDetail._id;
                } else
                    orderIdText = "Order ID: " + orderDetail.display_order_id;

                AidlUtil.getInstance().printText(orderIdText, size, isbold, isUnderline, alignment);

                if (kitchenCopy)
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }
        } else {
            if (tableNumberOrderIdMode != null) {
                String tableNumberOrderIdText = "";
                if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                    } else
                        tableNumberOrderIdText = "Order ID: " + orderDetail.display_order_id;
                }
                AidlUtil.getInstance().printText(tableNumberOrderIdText, AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }
        }

        if (structure.table_no != null && structure.no_of_diners != null) {
            if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                switch (structure.table_no.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.table_no.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.table_no.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }

                AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number, size, isbold, isUnderline, alignment);

                switch (structure.no_of_diners.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }
                switch (structure.no_of_diners.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }
                switch (structure.no_of_diners.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }

                AidlUtil.getInstance().printText("   No of Diner: " + orderDetail.no_guest + "\n", size, isbold, isUnderline, alignment);
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }
        } else {
            if (tableNumberOrderIdMode != null) {
                String tableNumberOrderIdText = "";
                if (orderType == 1 && (tableNumberOrderIdMode.equalsIgnoreCase("table_number") || tableNumberOrderIdMode.equalsIgnoreCase("both"))) {
                    if (tableNumberOrderIdText.length() > 1) {
                        tableNumberOrderIdText = tableNumberOrderIdText + "\n";
                    }
                    tableNumberOrderIdText = tableNumberOrderIdText + "Table No: " + orderDetail.table_number + "  No of Diners:  " + orderDetail.no_guest;

                }
                if (tableNumberOrderIdMode.equalsIgnoreCase("none")) {
                    tableNumberOrderIdText = "";
                }
                if (tableNumberOrderIdText.length() > 0) {
                    if (!Validators.isNullOrEmpty(title))
                        AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                    AidlUtil.getInstance().printText(tableNumberOrderIdText, AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }
            }
        }

        String orderDate = null, orderTime = null;
        String receiptDate = null;
        if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
            if (orderDetail.created_at.contains("Z")) {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
            } else {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
            }
        }
        if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
            if (orderDetail.updated_at.contains("Z")) {
                receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
            } else {
                receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
            }
        }

        if (structure.order_date != null) {
            if (structure.order_date.visibility) {
                switch (structure.order_date.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.order_date.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.order_date.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }

                if (!Validators.isNullOrEmpty(orderDate))
                    if (structure.order_time != null && structure.order_time.visibility) {
                        AidlUtil.getInstance().printText("Date " + orderDate + " ", size, isbold, isUnderline, alignment);
                    } else {
                        AidlUtil.getInstance().printText("Date :" + orderDate + " ", size, isbold, isUnderline, alignment);
                        AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                    }
            }

        }
        if (structure.order_time != null) {
            if (structure.order_time.visibility) {
                switch (structure.order_time.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.order_time.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.order_time.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTime)) {
                    AidlUtil.getInstance().printText("Time :" + orderTime + "\n", size, isbold, isUnderline, alignment);
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }
            }
        }

      /*  if (!Validators.isNullOrEmpty(dateTimeMode)) {
            String dateFormat = "dd-MM-yyyy hh:mm a";
            String dateFormatTitle = "Order Date Time: ";
            if (dateTimeMode.equalsIgnoreCase("date_time")) {
                dateFormat = "dd-MM-yyyy hh:mm a";
                dateFormatTitle = "Order Date Time: ";
            }
            if (dateTimeMode.equalsIgnoreCase("time")) {
                dateFormat = "hh:mm a";
                dateFormatTitle = "Order Time: ";
            }
            if (dateTimeMode.equalsIgnoreCase("date")) {
                dateFormat = "dd-MM-yyyy";
                dateFormatTitle = "Order Date: ";
            }
            if (orderDetail.created_at.contains("Z")) {
                AidlUtil.getInstance().printText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat), 32, false, false, AidlUtil.Alignment.LEFT);
            } else {
                AidlUtil.getInstance().printText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, dateFormat), 32, false, false, AidlUtil.Alignment.LEFT);
            }

        }*/
        if (orderType > 1 && !kitchenCopy) {
            AidlUtil.getInstance().printText("Order Type: " + orderDetail.order_type, 32, false, false, AidlUtil.Alignment.LEFT);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }
        if (structure.items_header != null) {
            if (structure.items_header.visibility) {
                switch (structure.items_header.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.items_header.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.items_header.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                AidlUtil.getInstance().printText("Qty Name", size, isbold, isUnderline, alignment);
            }
        } else
            AidlUtil.getInstance().

                    printText("Qty Name", 32, false, false, AidlUtil.Alignment.LEFT);

        if (structure.items.visibility) {
            switch (structure.items.style) {
                case "default":
                    isbold = false;
                    isUnderline = false;
                    break;
                case "bold":
                    isbold = true;
                    isUnderline = false;
                    break;
                case "underline":
                    isbold = false;
                    isUnderline = true;
                    break;
                default:
                    isbold = false;
                    isUnderline = false;
                    break;
            }

            switch (structure.items.size) {
                case "size0":
                    size = AidlUtil.Size.SIZE0;
                    break;
                case "size1":
                    size = AidlUtil.Size.SIZE1;
                    break;
                case "size2":
                    size = AidlUtil.Size.SIZE2;
                    break;
                case "size3":
                    size = AidlUtil.Size.SIZE3;
                    break;
                case "size4":
                    size = AidlUtil.Size.SIZE4;
                    break;
                case "size5":
                    size = AidlUtil.Size.SIZE5;
                    break;
                default:
                    size = AidlUtil.Size.SIZE0;
                    break;
            }

            switch (structure.items.alignment) {
                case "left":
                    alignment = AidlUtil.Alignment.LEFT;
                    break;
                case "center":
                    alignment = AidlUtil.Alignment.CENTER;
                    break;
                case "right":
                    alignment = AidlUtil.Alignment.RIGHT;
                    break;
                default:
                    alignment = AidlUtil.Alignment.LEFT;
                    break;
            }
            String itemName = "", price = "", qty = "";

            String lastBlockId = null;
            boolean lastItemWasMisc = false;
            for (OrderItem productDetail : orderDetail.order_items) {
                String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                String productQty = String.valueOf(productDetail.quantity);
                // Here we need 16 characters in product name so we send 16 in
                // @params charactersInLine
                price = (!kitchenCopy) ? MyApp.df.format(productDetail.total) : "";
                if (kitchenCopy)
                    itemName = getProductNameWithPad(productName, price, 25);
                else
                    itemName = getProductNameWithPad(productName, price, 28);
                qty = productQty;
                if (productQty.length() <= 1) {
                    qty = " " + productQty + " ";
                } else if (productQty.length() <= 2) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 3) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 4) {
                    qty = productQty + "";
                }
                if (lastBlockId != null) {
                    if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                        if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.CENTER);
                    }
                } else {
                    if (lastItemWasMisc && !productDetail.misc) {
                        if (kitchenCopy)
                            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, isbold, isUnderline, AidlUtil.Alignment.CENTER);
                    }
                }

                String printItem;
                printItem = qty + itemName.trim();
                if (!kitchenCopy) {
                    AidlUtil.getInstance().printText(printItem, size, isbold, isUnderline, alignment);
                    if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                        AidlUtil.getInstance().printText("   Instruction: " + productDetail.special_instruction, 30, true, false, AidlUtil.Alignment.LEFT);
                } else {
                    AidlUtil.getInstance().printText(printItem, size, isbold, isUnderline, alignment);
                    if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                        AidlUtil.getInstance().printText("   Instruction: " + productDetail.special_instruction, 40, true, false, AidlUtil.Alignment.LEFT);
                }
                if (productDetail.order_item_addons.size() > 0) {
                    if (structure.items_subaddon.visibility) {
                        switch (structure.items_header.style) {
                            case "default":
                                isbold = false;
                                isUnderline = false;
                                break;
                            case "bold":
                                isbold = true;
                                isUnderline = false;
                                break;
                            case "underline":
                                isbold = false;
                                isUnderline = true;
                                break;
                            default:
                                isbold = false;
                                isUnderline = false;
                                break;
                        }

                        switch (structure.items_header.size) {
                            case "size0":
                                size = AidlUtil.Size.SIZE0;
                                break;
                            case "size1":
                                size = AidlUtil.Size.SIZE1;
                                break;
                            case "size2":
                                size = AidlUtil.Size.SIZE2;
                                break;
                            case "size3":
                                size = AidlUtil.Size.SIZE3;
                                break;
                            case "size4":
                                size = AidlUtil.Size.SIZE4;
                                break;
                            case "size5":
                                size = AidlUtil.Size.SIZE5;
                                break;
                            default:
                                size = AidlUtil.Size.SIZE0;
                                break;
                        }

                        switch (structure.items_header.alignment) {
                            case "left":
                                alignment = AidlUtil.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = AidlUtil.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = AidlUtil.Alignment.RIGHT;
                                break;
                            default:
                                alignment = AidlUtil.Alignment.LEFT;
                                break;
                        }
                        AidlUtil.getInstance().printText("Choose Your Base:", size, isbold, isUnderline, alignment);
                    }

                    for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                        List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                        if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                            continue;
                        }
                        productQty = orderItemAddon.quantity + "";
                        productName = orderItemAddon.addon_name + "";
                        price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                        if (kitchenCopy)
                            itemName = getProductNameWithPad(productName, price, 25);
                        else
                            itemName = getProductNameWithPad(productName, price, 28);
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + " ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "";
                        }
                        printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? itemName.trim() : qty + itemName.trim();
                        AidlUtil.getInstance().printText(printItem, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                      /*  if (!kitchenCopy) {
                            String subdomainPrintText = getSubaddonWithPad(orderItemAddon.addon_name, 30);
                            AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                        } else {
                            String subdomainPrintText = getSubaddonWithPad(orderItemAddon.addon_name, 30);
                            AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                        }*/
                    }
                }

                for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                    String ingredientName = orderItemIngredient.ingredient_name;
                    if (orderItemIngredient.with) {
                        ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                    }
                    if (orderItemIngredient.without) {
                        ingredientName = "No " + ingredientName;
                    }
                    if (!kitchenCopy) {
                        String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                        AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                    } else {
                        String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                        AidlUtil.getInstance().printText(subdomainPrintText, 30, true, false, AidlUtil.Alignment.LEFT);
                    }
                }

                lastItemWasMisc = productDetail.misc;
                lastBlockId = productDetail.block_id;
            }
            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
        }

        if (printTotalInPrint) {
            if (structure.subtotal.visibility) {
                switch (structure.subtotal.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.subtotal.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.subtotal.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                AidlUtil.getInstance().printText(("SubTotal :") + MyApp.df.format(orderDetail.sub_total), size, isbold, isUnderline, alignment);
            }

            if (structure.gratuity.visibility) {
                switch (structure.gratuity.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.gratuity.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.gratuity.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (orderDetail.gratuity > 0) {
                    AidlUtil.getInstance().printText(("Gratuity :") + MyApp.df.format(orderDetail.gratuity), size, isbold, isUnderline, alignment);
                }
            }

            if (structure.discount.visibility) {
                switch (structure.discount.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.discount.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.discount.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (orderDetail.discount > 0) {
                    AidlUtil.getInstance().printText(("Discount :") + MyApp.df.format(orderDetail.discount), size, isbold, isUnderline, alignment);
                }
            }

            if (structure.service_charge.visibility) {
                switch (structure.service_charge.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.service_charge.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.service_charge.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (orderDetail.service_charge > 0) {
                    AidlUtil.getInstance().printText(("Service charge :") + MyApp.df.format(orderDetail.service_charge), size, isbold, isUnderline, alignment);
                }
            }
            if (structure.discount.visibility) {
                switch (structure.discount.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.discount.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.discount.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (orderDetail.discount > 0) {
                    AidlUtil.getInstance().printText(("Discount :") + MyApp.df.format(orderDetail.discount), size, isbold, isUnderline, alignment);
                }
            }

            if (structure.grand_total.visibility) {
                switch (structure.grand_total.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.grand_total.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.grand_total.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                AidlUtil.getInstance().printText("Total : " + MyApp.df.format(orderDetail.total), size, isbold, isUnderline, alignment);
            }
            if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                    structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility) {
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }
        }

        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
            if (structure.payment_detail_header != null)
                if (structure.payment_detail_header.visibility) {
                    switch (structure.payment_detail_header.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.payment_detail_header.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.payment_detail_header.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    AidlUtil.getInstance().printText("Payment Details: ", size, isbold, isUnderline, alignment);
                }

            if (structure.payment_detail != null) {
                if (structure.payment_detail.visibility) {
                    switch (structure.payment_detail.style) {
                        case "default":
                            isbold = false;
                            isUnderline = false;
                            break;
                        case "bold":
                            isbold = true;
                            isUnderline = false;
                            break;
                        case "underline":
                            isbold = false;
                            isUnderline = true;
                            break;
                        default:
                            isbold = false;
                            isUnderline = false;
                            break;
                    }

                    switch (structure.payment_detail.size) {
                        case "size0":
                            size = AidlUtil.Size.SIZE0;
                            break;
                        case "size1":
                            size = AidlUtil.Size.SIZE1;
                            break;
                        case "size2":
                            size = AidlUtil.Size.SIZE2;
                            break;
                        case "size3":
                            size = AidlUtil.Size.SIZE3;
                            break;
                        case "size4":
                            size = AidlUtil.Size.SIZE4;
                            break;
                        case "size5":
                            size = AidlUtil.Size.SIZE5;
                            break;
                        default:
                            size = AidlUtil.Size.SIZE0;
                            break;
                    }

                    switch (structure.payment_detail.alignment) {
                        case "left":
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = AidlUtil.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = AidlUtil.Alignment.RIGHT;
                            break;
                        default:
                            alignment = AidlUtil.Alignment.LEFT;
                            break;
                    }
                    for (OrderPayment orderPayment : orderDetail.order_payments) {
                        String paymentDetailToPrint = null;
                        if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                            paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                        } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                            paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                        } else {
                            paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                        }
                        AidlUtil.getInstance().printText(paymentDetailToPrint, size, isbold, isUnderline, alignment);
                    }
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                } else
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            } else {
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }
        }

        if (structure.serve_by.visibility) {
            switch (structure.serve_by.style) {
                case "default":
                    isbold = false;
                    isUnderline = false;
                    break;
                case "bold":
                    isbold = true;
                    isUnderline = false;
                    break;
                case "underline":
                    isbold = false;
                    isUnderline = true;
                    break;
                default:
                    isbold = false;
                    isUnderline = false;
                    break;
            }

            switch (structure.serve_by.size) {
                case "size0":
                    size = AidlUtil.Size.SIZE0;
                    break;
                case "size1":
                    size = AidlUtil.Size.SIZE1;
                    break;
                case "size2":
                    size = AidlUtil.Size.SIZE2;
                    break;
                case "size3":
                    size = AidlUtil.Size.SIZE3;
                    break;
                case "size4":
                    size = AidlUtil.Size.SIZE4;
                    break;
                case "size5":
                    size = AidlUtil.Size.SIZE5;
                    break;
                default:
                    size = AidlUtil.Size.SIZE0;
                    break;
            }

            switch (structure.serve_by.alignment) {
                case "left":
                    alignment = AidlUtil.Alignment.LEFT;
                    break;
                case "center":
                    alignment = AidlUtil.Alignment.CENTER;
                    break;
                case "right":
                    alignment = AidlUtil.Alignment.RIGHT;
                    break;
                default:
                    alignment = AidlUtil.Alignment.LEFT;
                    break;
            }
            String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
            AidlUtil.getInstance().printText(toprint, size, isbold, isUnderline, alignment);
            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
        }
        if (structure.customer_detail != null)
            if (structure.customer_detail.visibility) {
                switch (structure.customer_detail.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.customer_detail.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.customer_detail.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                    AidlUtil.getInstance().printText("Cust Name:" + orderDetail.customer_name, size, isbold, isUnderline, alignment);
                }

                if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                    AidlUtil.getInstance().printText("Cust No:" + orderDetail.customer.mobile, size, isbold, isUnderline, alignment);
                }
                String fulladdress = null;
                if (orderType == 3) {
                    fulladdress = "Address : " + orderDetail.customer.house_no + ","
                            + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                            orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                    AidlUtil.getInstance().printText(fulladdress, size, isbold, isUnderline, alignment);
                }
                if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress))
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }


        if (structure.payment_status != null)
            if (structure.payment_status.visibility) {
                switch (structure.payment_status.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.payment_status.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.payment_status.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                    AidlUtil.getInstance().printText("Payment Status: " + settingMap.get("unpaid_payment_title"), size, isbold, isUnderline, alignment);
                } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                    AidlUtil.getInstance().printText("Payment Status: " + settingMap.get("paid_payment_title"), size, isbold, isUnderline, alignment);
                } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                    AidlUtil.getInstance().printText("Payment Status: " + settingMap.get("partial_payment_title"), size, isbold, isUnderline, alignment);
                }
                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }

        if (structure.order_comment != null) {
            if (structure.order_comment.visibility) {
                switch (structure.order_comment.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.order_comment.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.order_comment.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                    AidlUtil.getInstance().printText("Comment: " + orderDetail.comment, size, isbold, isUnderline, alignment);
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                }
            }
        }
        if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
            AidlUtil.getInstance().printText("Requested Time" + orderDetail.delivery_collection_time_slot, AidlUtil.Size.SIZE1, true, false, AidlUtil.Alignment.LEFT);
        }
        if (structure.footer_order_type != null)
            if (structure.footer_order_type.visibility && kitchenCopy) {
                switch (structure.footer_order_type.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.footer_order_type.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.footer_order_type.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                    AidlUtil.getInstance().printText("** " + orderTypeHeading + " **", size, isbold, isUnderline, alignment);
                }

            }
        // footer table number
        if (structure.footer_table_number != null)
            if (structure.footer_table_number.visibility && kitchenCopy) {
                switch (structure.footer_table_number.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.footer_table_number.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.footer_table_number.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                    AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                    AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number + "\n", size, isbold, isUnderline, alignment);
                }

            }
        // footer order number
        if (structure.footer_order_number != null)
            if (structure.footer_order_number.visibility && kitchenCopy) {
                switch (structure.footer_order_number.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.footer_order_number.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.footer_order_number.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    if (orderDetail._id != 0) {
                        AidlUtil.getInstance().printText("Order No: " + orderDetail._id + "\n", size, isbold, isUnderline, alignment);
                    }
                } else {
                    AidlUtil.getInstance().printText("Order No: " + orderDetail.display_order_id + "\n", size, isbold, isUnderline, alignment);
                }

            }
        if (structure.header_customer_name != null)
            if (structure.header_customer_name.visibility) {
                switch (structure.header_customer_name.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.header_customer_name.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.header_customer_name.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                    AidlUtil.getInstance().printText(orderDetail.customer_name, size, isbold, isUnderline, alignment);
                }
            }

        if (structure.receipt_time != null && structure.receipt_time.visibility && !Validators.isNullOrEmpty(receiptDate)) {
            switch (structure.receipt_time.style) {
                case "bold":
                    isbold = true;
                    isUnderline = false;
                    break;
                case "underline":
                    isbold = false;
                    isUnderline = true;
                    break;
                default:
                    isbold = false;
                    isUnderline = false;
                    break;
            }

            switch (structure.receipt_time.size) {
                case "size1":
                    size = AidlUtil.Size.SIZE1;
                    break;
                case "size2":
                    size = AidlUtil.Size.SIZE2;
                    break;
                case "size3":
                    size = AidlUtil.Size.SIZE3;
                    break;
                case "size4":
                    size = AidlUtil.Size.SIZE4;
                    break;
                case "size5":
                    size = AidlUtil.Size.SIZE5;
                    break;
                default:
                    size = AidlUtil.Size.SIZE0;
                    break;
            }

            switch (structure.receipt_time.alignment) {
                case "center":
                    alignment = AidlUtil.Alignment.CENTER;
                    break;
                case "right":
                    alignment = AidlUtil.Alignment.RIGHT;
                    break;
                default:
                    alignment = AidlUtil.Alignment.LEFT;
                    break;
            }
            AidlUtil.getInstance().printText("Receipt Date :" + receiptDate, size, isbold, isUnderline, alignment);
        }
        if (structure.footer != null)
            if (structure.footer.visibility) {
                switch (structure.footer.style) {
                    case "default":
                        isbold = false;
                        isUnderline = false;
                        break;
                    case "bold":
                        isbold = true;
                        isUnderline = false;
                        break;
                    case "underline":
                        isbold = false;
                        isUnderline = true;
                        break;
                    default:
                        isbold = false;
                        isUnderline = false;
                        break;
                }

                switch (structure.footer.size) {
                    case "size0":
                        size = AidlUtil.Size.SIZE0;
                        break;
                    case "size1":
                        size = AidlUtil.Size.SIZE1;
                        break;
                    case "size2":
                        size = AidlUtil.Size.SIZE2;
                        break;
                    case "size3":
                        size = AidlUtil.Size.SIZE3;
                        break;
                    case "size4":
                        size = AidlUtil.Size.SIZE4;
                        break;
                    case "size5":
                        size = AidlUtil.Size.SIZE5;
                        break;
                    default:
                        size = AidlUtil.Size.SIZE0;
                        break;
                }

                switch (structure.footer.alignment) {
                    case "left":
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = AidlUtil.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = AidlUtil.Alignment.RIGHT;
                        break;
                    default:
                        alignment = AidlUtil.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(footerA)) {
                    AidlUtil.getInstance().printText(footerA, size, isbold, isUnderline, alignment);
                }
                if (!Validators.isNullOrEmpty(footerB)) {
                    AidlUtil.getInstance().printText(footerB, size, isbold, isUnderline, alignment);
                }
            }

        // set print true for local device
        setPrint(myPreferences, true);
        AidlUtil.getInstance().

                CutPaper();

        // prepare send wifi model to order device to listen start
        SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
        SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
        sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
        sendOrderWifiModel.setTitle(title);
        sendOrderWifiModel.setTicketHeaderSetting(ticket_header);
        sendOrderWifiModel.setHeaderAlignment(headerAlignment);
        sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
        sendOrderWifiModel.setOrderDetail(orderDetail);
        sendOrderWifiModel.setCashDrawerOpen(isCashDrawerOpen);
        sendOrderWifiModel.setPrintStructure(structure);
        sendOrderWifiModel.setFooterA(footerA);
        sendOrderWifiModel.setFooterB(footerB);
        sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading);
        sendOrderWifiModel.setSettingsMap(settingMap);
        sendOrderWifiModel.setKitchen(kitchenCopy);
        if (printBlockBill != null) {
            sendOrderWifiModel.setPrintBlockBill(printBlockBill);
        }
        sendOrderWifiModel.setTableNumberOrderIdMode(tableNumberOrderIdMode);
        sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOSNEW);
        sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username);

        sendOrderToWifi(sendOrderWifiModel);

    }

    public void printOrderEposNewFoodHub(ArrayList<PrintStyle> listPrintStructure, Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, PrintStructure structure, boolean printTotalInPrint, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        int style = 0, alignment = 0;
        float size = 0;
        boolean isbold = false, isUnderline = false;

        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }
        String orderDate = null, orderTime = null;
        String receiptDate = null;
        if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
            if (orderDetail.created_at.contains("Z")) {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
            } else {
                orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
            }
        }
        if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
            if (orderDetail.updated_at.contains("Z")) {
                receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
            } else {
                receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
            }
        }
        for (int i = 0; i < listPrintStructure.size(); i++) {
            String key = listPrintStructure.get(i).key;
            boolean priceInItems = listPrintStructure.get(i).price;
            boolean all_separator = listPrintStructure.get(i).all_separator;
            boolean isBlockName = listPrintStructure.get(i).block_name;
            switch (listPrintStructure.get(i).style) {
                case "bold":
                    isbold = true;
                    isUnderline = false;
                    break;
                case "underline":
                    isbold = false;
                    isUnderline = true;
                    break;
                default:
                    isbold = false;
                    isUnderline = false;
                    break;
            }
            switch (listPrintStructure.get(i).size) {
                case "size1":
                    size = AidlUtil.Size.SIZE1;
                    break;
                case "size2":
                    size = AidlUtil.Size.SIZE2;
                    break;
                case "size3":
                    size = AidlUtil.Size.SIZE3;
                    break;
                case "size4":
                    size = AidlUtil.Size.SIZE4;
                    break;
                case "size5":
                    size = AidlUtil.Size.SIZE5;
                    break;
                default:
                    size = AidlUtil.Size.SIZE0;
                    break;
            }
            switch (listPrintStructure.get(i).alignment) {
                case "center":
                    alignment = AidlUtil.Alignment.CENTER;
                    break;
                case "right":
                    alignment = AidlUtil.Alignment.RIGHT;
                    break;
                default:
                    alignment = AidlUtil.Alignment.LEFT;
                    break;
            }
            boolean isSeparator = listPrintStructure.get(i).separator;
            switch (key) {
                case "logo": {
                    if (!kitchenCopy && tiffintomLogo != null) {
                        AidlUtil.getInstance().printBitmap(tiffintomLogo);
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "ticket_header": {
                    if (!Validators.isNullOrEmpty(ticket_header)) {
                        if (!kitchenCopy) {
                            AidlUtil.getInstance().printText(ticket_header, AidlUtil.Size.SIZE0, true, false, headerAlignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                    }
                    break;
                }
                case "header_order_type": {
                    if (kitchenCopy) {
                        if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                            AidlUtil.getInstance().printText("" + orderTypeHeading.toUpperCase() + "", size, isbold, isUnderline, alignment);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "title": {
                    if (kitchenCopy) {
                        if (!Validators.isNullOrEmpty(title)) {
                            AidlUtil.getInstance().printText(title, size, isbold, isUnderline, alignment);
                            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                    }
                    break;
                }
                case "footer_table_number": {
                    if (kitchenCopy) {
                        if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.CENTER);
                            AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                    }
                    break;
                }
                case "footer_order_number": {
                    if (kitchenCopy) {
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            if (orderDetail._id != 0) {
                                AidlUtil.getInstance().printText("Order No: " + orderDetail._id, size, isbold, isUnderline, alignment);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        } else {
                            AidlUtil.getInstance().printText("Order No: " + orderDetail.display_order_id, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                    }
                    break;
                }
                case "header_customer_name": {
                    if (kitchenCopy) {
                        if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            AidlUtil.getInstance().printText(orderDetail.customer_name, size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                    }
                    break;
                }
                case "order_no": {
                    String orderIdText = null;
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        orderIdText = "" + orderDetail._id;
                    } else
                        orderIdText = "" + orderDetail.display_order_id;

                    AidlUtil.getInstance().printText(orderIdText, size, isbold, isUnderline, alignment);

                    if (kitchenCopy) {
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "table_no": {
                    if (orderType == 1) {
                        AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number + "\n", size, isbold, isUnderline, alignment);
                        if (!structure.no_of_diners.visibility) {
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                    }
                    break;
                }
                case "no_of_diners": {
                    if (orderType == 1) {
                        AidlUtil.getInstance().printText("   No of Diner: " + orderDetail.no_guest, size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "order_date": {
                    if (!Validators.isNullOrEmpty(orderDate))
                        if (structure.order_time != null && structure.order_time.visibility) {
                            AidlUtil.getInstance().printText("Date :" + orderDate + " ", size, isbold, isUnderline, alignment);
                        } else {
                            AidlUtil.getInstance().printText("Date :" + orderDate + " ", size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                    break;
                }
                case "order_time": {
                    if (!Validators.isNullOrEmpty(orderTime)) {
                        AidlUtil.getInstance().printText("Time :" + orderTime, size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "receipt_time": {
                    if (!Validators.isNullOrEmpty(receiptDate)) {
                        AidlUtil.getInstance().printText("Receipt Date :" + receiptDate, size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "order_type": {
                    if (orderType > 1) {
                        if (!Validators.isNullOrEmpty(orderDetail.order_type)) {
                            AidlUtil.getInstance().printText("Order Type: " + orderDetail.order_type + "", size, isbold, isUnderline, alignment);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                    }
                    break;
                }
                case "items_header": {
                    AidlUtil.getInstance().printText("Qty Name", size, isbold, isUnderline, alignment);
                    if (isSeparator) {
                        printSeparator();
                    }
                    break;
                }
                case "items": {
                    String itemName = "", price = "", qty = "";
                    String lastBlockId = null;
                    boolean lastItemWasMisc = false;
                    int position = 0;
                    for (OrderItem productDetail : orderDetail.order_items) {
                        switch (structure.items.style) {
                            case "bold":
                                isbold = true;
                                isUnderline = false;
                                break;
                            case "underline":
                                isbold = false;
                                isUnderline = true;
                                break;
                            default:
                                isbold = false;
                                isUnderline = false;
                                break;
                        }
                        switch (structure.items.size) {
                            case "size1":
                                size = AidlUtil.Size.SIZE1;
                                break;
                            case "size2":
                                size = AidlUtil.Size.SIZE2;
                                break;
                            case "size3":
                                size = AidlUtil.Size.SIZE3;
                                break;
                            case "size4":
                                size = AidlUtil.Size.SIZE4;
                                break;
                            case "size5":
                                size = AidlUtil.Size.SIZE5;
                                break;
                            default:
                                size = AidlUtil.Size.SIZE0;
                                break;
                        }
                        switch (structure.items.alignment) {
                            case "center":
                                alignment = AidlUtil.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = AidlUtil.Alignment.RIGHT;
                                break;
                            default:
                                alignment = AidlUtil.Alignment.LEFT;
                                break;
                        }
                        position = position + 1;
                        String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                        //String productQty = String.valueOf(productDetail.quantity);

                        String productQty;
                        if (kitchenCopy) {
                            productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                        } else {
                            productQty = String.valueOf(productDetail.quantity);
                        }
                        // Here we need 16 characters in product name so we send 16 in
                        // @params charactersInLine
                        price = (priceInItems) ? MyApp.df.format(productDetail.total) : "";
                           /* if (kitchenCopy)
                                itemName = getProductNameWithPad(productName, price, 25);
                            else
                                itemName = getProductNameWithPad(productName, price, 28);*/
                        itemName = getProductNameWithPad(productName, price, 28);
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + "x ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + "x ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + "x ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "x";
                        }

                        if (!all_separator) {
                            if (lastBlockId != null) {
                                if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                    if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                        printBlockText(productDetail,isBlockName);
                                }
                            } else {
                                if (lastItemWasMisc && !productDetail.misc) {
                                    if (kitchenCopy)
                                        printBlockText(productDetail,isBlockName);
                                }
                            }
                        }
                        String printItem;
                        printItem = qty + itemName.trim();
                        // if size 0 or 1 format product name
                        if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                            String finalPrice = "  " + price;
                            itemName = calculteNumberOfLines(productName, finalPrice, size, qty);
                            printItem = itemName;
                        }
                        AidlUtil.getInstance().printText(printItem, size, isbold, isUnderline, alignment);
                        if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                            AidlUtil.getInstance().printText("   Instruction: " + productDetail.special_instruction, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);

                        if (productDetail.order_item_addons.size() > 0) {
                            switch (structure.items_subaddon.style) {
                                case "bold":
                                    isbold = true;
                                    isUnderline = false;
                                    break;
                                case "underline":
                                    isbold = false;
                                    isUnderline = true;
                                    break;
                                default:
                                    isbold = false;
                                    isUnderline = false;
                                    break;
                            }
                            switch (structure.items_subaddon.size) {
                                case "size1":
                                    size = AidlUtil.Size.SIZE1;
                                    break;
                                case "size2":
                                    size = AidlUtil.Size.SIZE2;
                                    break;
                                case "size3":
                                    size = AidlUtil.Size.SIZE3;
                                    break;
                                case "size4":
                                    size = AidlUtil.Size.SIZE4;
                                    break;
                                case "size5":
                                    size = AidlUtil.Size.SIZE5;
                                    break;
                                default:
                                    size = AidlUtil.Size.SIZE0;
                                    break;
                            }
                            switch (structure.items_subaddon.alignment) {
                                case "center":
                                    alignment = AidlUtil.Alignment.CENTER;
                                    break;
                                case "right":
                                    alignment = AidlUtil.Alignment.RIGHT;
                                    break;
                                default:
                                    alignment = AidlUtil.Alignment.LEFT;
                                    break;
                            }
                            if (structure.items_subaddon.visibility) {
                                AidlUtil.getInstance().printText("Choose Your Base:", size, isbold, isUnderline, alignment);
                            }
                            for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                    continue;
                                }
                                productQty = orderItemAddon.quantity + "";
                                productName = orderItemAddon.addon_name + "";
                                price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                                if (kitchenCopy)
                                    itemName = getProductNameWithPad(productName, price, 25);
                                else
                                    itemName = getProductNameWithPad(productName, price, 28);
                                qty = productQty;
                                /*if (productQty.length() <= 1) {
                                    qty = " " + productQty + "x ";
                                } else if (productQty.length() <= 2) {
                                    qty = productQty + "x ";

                                } else if (productQty.length() <= 3) {
                                    qty = productQty + "x ";

                                } else if (productQty.length() <= 4) {
                                    qty = productQty + "x";
                                }*/
                                //printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? itemName.trim() : qty + itemName.trim();
                                // adding qty when total or price is zero as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                                    if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                        if (orderItemAddon.quantity > 1) {
                                            printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "  - " + orderItemAddon.quantity + "x");
                                        } else {
                                            if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "");
                                            } else {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "  -   ");
                                            }
                                        }
                                    } else {
                                        if (orderItemAddon.quantity > 1) {
                                            printItem = calculteNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), size, "  - " + orderItemAddon.addon_name + "x");
                                        } else {
                                            printItem = calculteNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), size, "  -   ");
                                        }
                                    }
                                    AidlUtil.getInstance().printText(printItem + "", size, isbold, isUnderline, alignment);
                                } else {
                                    if (orderItemAddon.quantity > 1) {
                                        //printItem = qty + itemName.trim();
                                        printItem = "- " + qty + "x " + itemName.trim();
                                    } else {
                                        if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                            printItem = "" + itemName.trim();
                                        } else {
                                            printItem = "- 1x " + itemName.trim();
                                        }
                                    }
                                    AidlUtil.getInstance().printText(printItem, size, isbold, isUnderline, alignment);
                                }
                            }
                        }

                        for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                            String ingredientName = orderItemIngredient.ingredient_name;
                            if (orderItemIngredient.with) {
                                ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                            }
                            if (orderItemIngredient.without) {
                                ingredientName = "No " + ingredientName;
                            }
                            if (!kitchenCopy) {
                                String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                                AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                            } else {
                                String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                                AidlUtil.getInstance().printText(subdomainPrintText, AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.LEFT);
                            }
                        }

                        lastItemWasMisc = productDetail.misc;
                        lastBlockId = productDetail.block_id;

                        if (all_separator && orderDetail.order_items.size() > position) {
                            AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                        }
                        if (!all_separator && isBlockName) {
                            AidlUtil.getInstance().printText("\n", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                        }
                    }
                    if (isSeparator) {
                        printSeparator();
                    }
                    break;
                }
                case "subtotal":
                case "gratuity":
                case "delivery_charge":
                case "service_charge":
                case "grand_total":
                case "discount": {
                    if (printTotalInPrint) {
                        String formattedValue = "";
                        String titleOfTotal = "";
                        if (key.equalsIgnoreCase("gratuity")) {
                            if (orderDetail.gratuity > 0) {
                                formattedValue = MyApp.df.format(orderDetail.gratuity);
                            }
                            titleOfTotal = "GRATUITY";
                        } else if (key.equalsIgnoreCase("discount")) {
                            if (orderDetail.discount > 0)
                                formattedValue = MyApp.df.format(orderDetail.discount);
                            titleOfTotal = "DISCOUNT";
                        } else if (key.equalsIgnoreCase("grand_total")) {
                            if (orderDetail.total > 0) {
                                formattedValue = MyApp.df.format(orderDetail.total);
                            }
                            titleOfTotal = "TOTAL";
                        } else if (key.equalsIgnoreCase("service_charge")) {
                            if (orderDetail.service_charge > 0)
                                formattedValue = MyApp.df.format(orderDetail.service_charge);
                            titleOfTotal = "SERVICE CHARGE";
                        } else if (key.equalsIgnoreCase("delivery_charge")) {
                            if (orderDetail.delivery_charge > 0)
                                formattedValue = MyApp.df.format(orderDetail.delivery_charge);
                            titleOfTotal = "DELIVERY CHARGE";
                        } else if (key.equalsIgnoreCase("subtotal")) {
                            formattedValue = MyApp.df.format(orderDetail.sub_total);
                            titleOfTotal = "SUB TOTAL";
                        }
                        if (!Validators.isNullOrEmpty(formattedValue)) {
                            int length = formattedValue.length();
                            String price = null;
                            if (length <= 7 && length > 2) {
                                if (length == 4) {
                                    price = "    " + formattedValue;
                                }
                                if (length == 5) {
                                    price = "   " + formattedValue;
                                }

                                if (length == 6) {
                                    price = "  " + formattedValue;
                                }
                                if (length == 7) {
                                    price = " " + formattedValue;
                                }
                            } else {
                                price = formatter.format(orderDetail.sub_total);
                            }
                            /*String finalTitleToPrint ="";
                            if (length == 3){
                                if(size==AidlUtil.Size.SIZE1){
                                    padRightSpaces(titleOfTotal+price, 21);
                                }else {
                                    finalTitleToPrint = getProductNameWithPad( titleOfTotal , price, 41);
                                }
                            }
                            else if (length <= 8 && length >= 4){
                                if(size==AidlUtil.Size.SIZE1){
                                    finalTitleToPrint= padRightSpaces(titleOfTotal, 16)+""+price;
                                }else{
                                    finalTitleToPrint = getProductNameWithPad( titleOfTotal , price, 40);
                                }
                            }
                            else{
                                finalTitleToPrint = getProductNameWithPad( titleOfTotal , price, 39);
                            }*/
                            AidlUtil.getInstance().printText(formatTotal(size, titleOfTotal, price), size, isbold, isUnderline, alignment);
                        }
                        /*if(key.equalsIgnoreCase("grand_total")){
                            if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                                    structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility){
                                AidlUtil.getInstance().printText("-------------------------------------", AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
                            }
                        }*/
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "payment_detail_header": {
                    if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                        AidlUtil.getInstance().printText("Payment Details: ", size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "payment_detail": {
                    if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                        for (OrderPayment orderPayment : orderDetail.order_payments) {
                            String paymentDetailToPrint = null;
                            if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                            } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                            } else {
                                paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                            }
                            AidlUtil.getInstance().printText(paymentDetailToPrint, size, isbold, isUnderline, alignment);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "serve_by": {
                    String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                    AidlUtil.getInstance().printText(toprint, size, isbold, isUnderline, alignment);
                    if (isSeparator) {
                        printSeparator();
                    }
                    break;
                }
                case "customer_detail": {
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        AidlUtil.getInstance().printText("" + orderDetail.customer_name, size, isbold, isUnderline, alignment);
                    }
                    String fulladdress = null;
                    if (orderType == 3) {
                        fulladdress = "" + formatAddress(orderDetail);
                        AidlUtil.getInstance().printText(fulladdress, size, isbold, isUnderline, alignment);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                        AidlUtil.getInstance().printText("" + orderDetail.customer.mobile, size, isbold, isUnderline, alignment);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)) {
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "payment_status": {
                    if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                        AidlUtil.getInstance().printText(settingMap.get("unpaid_payment_title").toUpperCase(), size, isbold, isUnderline, alignment);
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                        AidlUtil.getInstance().printText(settingMap.get("paid_payment_title").toUpperCase(), size, isbold, isUnderline, alignment);
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                        AidlUtil.getInstance().printText(settingMap.get("partial_payment_title").toUpperCase(), size, isbold, isUnderline, alignment);
                    }
                    if (isSeparator) {
                        printSeparator();
                    }
                    break;
                }
                case "order_comment": {
                    if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                        AidlUtil.getInstance().printText("Comment: " + orderDetail.comment, size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                        AidlUtil.getInstance().printText("Requested Time" + orderDetail.delivery_collection_time_slot, AidlUtil.Size.SIZE1, true, false, AidlUtil.Alignment.LEFT);
                    }
                    break;
                }
                case "footer_order_type": {
                    if (!Validators.isNullOrEmpty(orderTypeHeading) && kitchenCopy) {
                        AidlUtil.getInstance().printText("" + orderTypeHeading.toUpperCase() + "", size, isbold, isUnderline, alignment);
                        if (isSeparator) {
                            printSeparator();
                        }
                    }
                    break;
                }
                case "footer": {
                    if (!Validators.isNullOrEmpty(footerA)) {
                        AidlUtil.getInstance().printText(footerA, size, isbold, isUnderline, alignment);
                    }
                    if (!Validators.isNullOrEmpty(footerB)) {
                        AidlUtil.getInstance().printText(footerB, size, isbold, isUnderline, alignment);
                    }
                    if (isSeparator) {
                        printSeparator();
                    }
                    break;
                }

            }
            if (tableNumberOrderIdMode != null) {
                String tableNumberOrderIdText = "";
                if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                    } else
                        tableNumberOrderIdText = "Order ID: " + orderDetail.display_order_id;
                }
                AidlUtil.getInstance().printText(tableNumberOrderIdText, AidlUtil.Size.SIZE0, false, false, AidlUtil.Alignment.LEFT);
            }
        }
        // set print true for local device
        setPrint(myPreferences, true);
        AidlUtil.getInstance().CutPaper();

        // prepare send wifi model to order device to listen start
        SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
        SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
        sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
        sendOrderWifiModel.setTitle(title);
        sendOrderWifiModel.setTicketHeaderSetting(ticket_header);
        sendOrderWifiModel.setHeaderAlignment(headerAlignment);
        sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
        sendOrderWifiModel.setOrderDetail(orderDetail);
        sendOrderWifiModel.setCashDrawerOpen(isCashDrawerOpen);
        sendOrderWifiModel.setPrintStructure(structure);
        sendOrderWifiModel.setFooterA(footerA);
        sendOrderWifiModel.setFooterB(footerB);
        sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading);
        sendOrderWifiModel.setSettingsMap(settingMap);
        sendOrderWifiModel.setKitchen(kitchenCopy);
        if (printBlockBill != null) {
            sendOrderWifiModel.setPrintBlockBill(printBlockBill);
        }
        sendOrderWifiModel.setTableNumberOrderIdMode(tableNumberOrderIdMode);
        sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOSNEW);
        sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username);

        sendOrderToWifi(sendOrderWifiModel);

    }

    public void printOrderEpos(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, boolean printTotalInPrint, String footerA, String footerB, String footerHeading, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        if (!kitchenCopy && tiffintomLogo != null) {
            AidlUtil.getInstance().printBitmap(tiffintomLogo);
        }
        if (!kitchenCopy) {
            AidlUtil.getInstance().printText(ticket_header, 32, true, false, headerAlignment);
        }
        if (kitchenCopy) {
            AidlUtil.getInstance().printText("** " + footerHeading + " **", 40, true, false, AidlUtil.Alignment.CENTER);

            if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                AidlUtil.getInstance().printText(orderDetail.customer_name, 40, false, false, AidlUtil.Alignment.CENTER);
            }
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }

        if (!Validators.isNullOrEmpty(title)) {
            AidlUtil.getInstance().printText(title, 40, false, false, AidlUtil.Alignment.CENTER);
        }
        String tableNumberOrderIdText = "";
        if (tableNumberOrderIdMode != null) {
            if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                } else
                    tableNumberOrderIdText = "Order ID: " + orderDetail.display_order_id;

            }
            if (orderType == 1 && (tableNumberOrderIdMode.equalsIgnoreCase("table_number") || tableNumberOrderIdMode.equalsIgnoreCase("both"))) {
                if (tableNumberOrderIdText.length() > 1) {
                    tableNumberOrderIdText = tableNumberOrderIdText + "\n";
                }
                tableNumberOrderIdText = tableNumberOrderIdText + "Table No: " + orderDetail.table_number + "  No of Diners:  " + orderDetail.no_guest;

            }
            if (tableNumberOrderIdMode.equalsIgnoreCase("none")) {
                tableNumberOrderIdText = "";
            }
            if (tableNumberOrderIdText.length() > 0) {
                if (!Validators.isNullOrEmpty(title))
                    AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
                AidlUtil.getInstance().printText(tableNumberOrderIdText, 32, false, false, AidlUtil.Alignment.LEFT);
                AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
            }
        }

        if (!Validators.isNullOrEmpty(dateTimeMode)) {
            String dateFormat = "dd-MM-yyyy hh:mm a";
            String dateFormatTitle = "Order Date Time: ";
            if (dateTimeMode.equalsIgnoreCase("date_time")) {
                dateFormat = "dd-MM-yyyy hh:mm a";
                dateFormatTitle = "Order Date Time: ";
            }
            if (dateTimeMode.equalsIgnoreCase("time")) {
                dateFormat = "hh:mm a";
                dateFormatTitle = "Order Time: ";
            }
            if (dateTimeMode.equalsIgnoreCase("date")) {
                dateFormat = "dd-MM-yyyy";
                dateFormatTitle = "Order Date: ";
            }
            if (orderDetail.created_at.contains("Z")) {
                AidlUtil.getInstance().printText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat), 32, false, false, AidlUtil.Alignment.LEFT);
            } else {
                AidlUtil.getInstance().printText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, dateFormat), 32, false, false, AidlUtil.Alignment.LEFT);
            }

        }
        if (orderType > 1 && !kitchenCopy) {
            AidlUtil.getInstance().printText("Order Type: " + orderDetail.order_type, 32, false, false, AidlUtil.Alignment.LEFT);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }

        AidlUtil.getInstance().printText("Qty Name", 32, false, false, AidlUtil.Alignment.LEFT);
        String itemName = "", price = "", qty = "";

        String lastBlockId = null;
        boolean lastItemWasMisc = false;

        for (OrderItem productDetail : orderDetail.order_items) {
            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
            String productQty = String.valueOf(productDetail.quantity);
            // Here we need 16 characters in product name so we send 16 in
            // @params charactersInLine
            price = (!kitchenCopy) ? MyApp.df.format(productDetail.total) : "";
            if (kitchenCopy)
                itemName = getProductNameWithPad(productName, price, 25);
            else
                itemName = getProductNameWithPad(productName, price, 28);
            qty = productQty;
            if (productQty.length() <= 1) {
                qty = " " + productQty + " ";
            } else if (productQty.length() <= 2) {
                qty = productQty + " ";

            } else if (productQty.length() <= 3) {
                qty = productQty + " ";

            } else if (productQty.length() <= 4) {
                qty = productQty + "";
            }
            if (lastBlockId != null) {
                if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                    if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                        AidlUtil.getInstance().printText("-----------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
                }
            } else {
                if (lastItemWasMisc && !productDetail.misc) {
                    if (kitchenCopy)
                        AidlUtil.getInstance().printText("-----------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
                }
            }

            String printItem;
            printItem = qty + itemName.trim();
            if (!kitchenCopy) {
                AidlUtil.getInstance().printText(printItem, 30, true, false, AidlUtil.Alignment.LEFT);
                if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                    AidlUtil.getInstance().printText("   Instruction: " + productDetail.special_instruction, 30, true, false, AidlUtil.Alignment.LEFT);
            } else {
                AidlUtil.getInstance().printText(printItem, 40, true, false, AidlUtil.Alignment.LEFT);
                if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                    AidlUtil.getInstance().printText("   Instruction: " + productDetail.special_instruction, 40, true, false, AidlUtil.Alignment.LEFT);
            }

            for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                    continue;
                }
                if (!kitchenCopy) {
                    String subdomainPrintText = getSubaddonWithPad(orderItemAddon.addon_name, 30);
                    AidlUtil.getInstance().printText(subdomainPrintText, 30, true, false, AidlUtil.Alignment.LEFT);
                } else {
                    String subdomainPrintText = getSubaddonWithPad(orderItemAddon.addon_name, 30);
                    AidlUtil.getInstance().printText(subdomainPrintText, 30, true, false, AidlUtil.Alignment.LEFT);
                }
            }

            for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                String ingredientName = orderItemIngredient.ingredient_name;
                if (orderItemIngredient.with) {
                    ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                }
                if (orderItemIngredient.without) {
                    ingredientName = "No " + ingredientName;
                }
                if (!kitchenCopy) {
                    String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                    AidlUtil.getInstance().printText(subdomainPrintText, 30, true, false, AidlUtil.Alignment.LEFT);
                } else {
                    String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                    AidlUtil.getInstance().printText(subdomainPrintText, 30, true, false, AidlUtil.Alignment.LEFT);
                }
            }

            lastItemWasMisc = productDetail.misc;
            lastBlockId = productDetail.block_id;
        }

        if (printTotalInPrint) {
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(padRightSpaces("SubTotal :", 1) + MyApp.df.format(orderDetail.sub_total), 32, false, false, AidlUtil.Alignment.RIGHT);
            if (orderDetail.delivery_charge > 0) {
                AidlUtil.getInstance().printText(padRightSpaces("Delivery charge :", 1) + MyApp.df.format(orderDetail.delivery_charge), 32, false, false, AidlUtil.Alignment.RIGHT);
            }
            if (orderDetail.gratuity > 0) {
                AidlUtil.getInstance().printText(padRightSpaces("Gratuity :", 1) + MyApp.df.format(orderDetail.gratuity), 32, false, false, AidlUtil.Alignment.RIGHT);
            }
            if (orderDetail.service_charge > 0) {
                AidlUtil.getInstance().printText(padRightSpaces("Service charge :", 1) + MyApp.df.format(orderDetail.service_charge), 32, false, false, AidlUtil.Alignment.RIGHT);
            }
            if (orderDetail.discount > 0) {
                AidlUtil.getInstance().printText(padRightSpaces("Discount :", 1) + MyApp.df.format(orderDetail.discount), 32, false, false, AidlUtil.Alignment.RIGHT);
            }

            AidlUtil.getInstance().printText("Total : " + MyApp.df.format(orderDetail.total), 32, true, false, AidlUtil.Alignment.RIGHT);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }

        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {

            AidlUtil.getInstance().printText("Payment Details:", 32, false, false, AidlUtil.Alignment.LEFT);

            for (OrderPayment orderPayment : orderDetail.order_payments) {
                String paymentDetailToPrint = null;
                if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                    paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                    paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                } else {
                    paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                }
                AidlUtil.getInstance().printText(paymentDetailToPrint, 32, false, false, AidlUtil.Alignment.LEFT);

            }
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }

        String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
        AidlUtil.getInstance().printText(toprint, 32, false, false, AidlUtil.Alignment.LEFT);

        AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
            AidlUtil.getInstance().printText("Cust Name:" + orderDetail.customer_name, 32, false, false, AidlUtil.Alignment.LEFT);
        }

        if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
            AidlUtil.getInstance().printText("Cust No:" + orderDetail.customer.mobile, 32, false, false, AidlUtil.Alignment.LEFT);
        }
        if (orderType == 3) {
            String fulladdress = "Address : " + orderDetail.customer.house_no + ","
                    + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                    orderDetail.customer.country + ", " + orderDetail.customer.postcode;
            AidlUtil.getInstance().printText(fulladdress, 32, false, false, AidlUtil.Alignment.LEFT);
        }
        if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
            AidlUtil.getInstance().printText("Payment Status: " + settingMap.get("unpaid_payment_title"), 32, false, false, AidlUtil.Alignment.LEFT);
        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
            AidlUtil.getInstance().printText("Payment Status: " + settingMap.get("paid_payment_title"), 32, false, false, AidlUtil.Alignment.LEFT);
        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
            AidlUtil.getInstance().printText("Payment Status: " + settingMap.get("partial_payment_title"), 32, false, false, AidlUtil.Alignment.LEFT);
        }
        AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        if (!Validators.isNullOrEmpty(orderDetail.comment)) {
            AidlUtil.getInstance().printText("Comment: " + orderDetail.comment, kitchenCopy ? 40 : 32, false, false, AidlUtil.Alignment.LEFT);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }
        if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
            AidlUtil.getInstance().printText("Requested Time" + orderDetail.delivery_collection_time_slot, AidlUtil.Size.SIZE1, true, false, AidlUtil.Alignment.LEFT);
        }
        if (kitchenCopy) {
            AidlUtil.getInstance().printText("** " + footerHeading + " **", 40, true, false, AidlUtil.Alignment.CENTER);
            // footer table number
            if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
                AidlUtil.getInstance().printText("Table No: " + orderDetail.table_number + "\n", 40, true, false, AidlUtil.Alignment.CENTER);
            }
            // footer order number
            if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                if (orderDetail._id != 0) {
                    AidlUtil.getInstance().printText("Order No: " + orderDetail._id + "\n", 40, true, false, AidlUtil.Alignment.CENTER);
                }
            } else {
                AidlUtil.getInstance().printText("Order No: " + orderDetail.display_order_id + "\n", 40, true, false, AidlUtil.Alignment.CENTER);
            }
        }

        if (!Validators.isNullOrEmpty(footerA)) {
            AidlUtil.getInstance().printText(footerA, 32, false, false, AidlUtil.Alignment.CENTER);
        }
        if (!Validators.isNullOrEmpty(footerB)) {
            AidlUtil.getInstance().printText(footerB, 32, false, false, AidlUtil.Alignment.CENTER);
        }
        // set print true for local device
        setPrint(myPreferences, true);
        AidlUtil.getInstance().CutPaper();
    }

    public void printReservationList(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, ArrayList<Object> allReservations, String footerA, String footerB, String fromdate, String todate, MyPreferences myPreferences) {
        try {

            if (tiffintomLogo != null) {
                AidlUtil.getInstance().printBitmap(tiffintomLogo);
            }
            AidlUtil.getInstance().printText(ticket_header, 32, true, false, headerAlignment);
            if (!Validators.isNullOrEmpty(title))
                AidlUtil.getInstance().printText(title, 40, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

            String date = "";
            if (fromdate != null) {
                if (fromdate.equalsIgnoreCase("0") && todate.equalsIgnoreCase("0")) {
                    date = "Show All";
                } else {
                    date = fromdate + " - " + todate;
                }
            } else {
                date = "All";
            }

            AidlUtil.getInstance().printText(date, 32, true, false, AidlUtil.Alignment.LEFT);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

            for (Object obj : allReservations) {
                StringBuilder sb = new StringBuilder();
                if (obj instanceof Reservation) {
                    sb = new StringBuilder();
                    Reservation reservation = (Reservation) obj;
                    sb.append(padRightSpaces("Name: " + reservation.customer_name, 22))
                            .append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy"));

                    if (!Validators.isNullOrEmpty(reservation.telephone)) {
                        if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                            sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 22)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                        } else {
                            sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 22)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                        }
                    } else {
                        if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                            sb.append("\n").append(padRightSpaces("", 22)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                        } else {
                            sb.append("\n").append(padRightSpaces("", 22)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                        }
                    }

                    if (!Validators.isNullOrEmpty(reservation.table_number)) {
                        sb.append("\n").append("Table: ").append(reservation.table_number);
                    }
                    sb.append("\n").append(padRightSpaces("Dinner: " + reservation.diners, 18)).append("Status: ").append(reservation.reservation_status);

                    if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                        sb.append("\n").append("Special Instruction: ").append(reservation.special_instruction);
                    }
                }
                if (obj instanceof OnlineReservation) {

                    sb = new StringBuilder();
                    OnlineReservation reservation = (OnlineReservation) obj;
                    sb.append(padRightSpaces("Name: " + reservation.customer_name, 22))
                            .append(CommonFunctions.formatUnknownDateTime(reservation.booking_date, "yyyy-MM-dd", "dd/MM/yyyy"));

                    if (!Validators.isNullOrEmpty(reservation.booking_phone)) {
                        sb.append("\n").append(padRightSpaces("Number: " + reservation.booking_phone, 22)).append(reservation.booking_time);
                    } else {
                        sb.append("\n").append(padRightSpaces("", 22)).append(reservation.booking_time).append("\n");
                    }
                    sb.append("\n").append(padRightSpaces("Dinner: " + reservation.guest_count, 18)).append("Status: ").append(reservation.status);
                    if (reservation.status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                        sb.append("\n").append("Reason: ").append(reservation.cancel_reason);
                    }
                    if (!Validators.isNullOrEmpty(reservation.booking_instruction) && !reservation.status.equalsIgnoreCase("cancel")) {
                        sb.append("\n").append("Booking Instruction: ").append(reservation.booking_instruction);
                    }

                }
                if (sb.toString().length() > 0) {
                    AidlUtil.getInstance().printText(sb.toString(), 32, true, false, AidlUtil.Alignment.LEFT);
                    AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
                }

            }

            AidlUtil.getInstance().printText(footerA, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(footerB, 32, true, false, AidlUtil.Alignment.CENTER);
            // set print true for local device
            setPrint(myPreferences, true);
            AidlUtil.getInstance().CutPaper();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printReservation(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Reservation reservation, String footerA, String footerB, MyPreferences myPreferences) {
        try {

            if (tiffintomLogo != null) {
                AidlUtil.getInstance().printBitmap(tiffintomLogo);
            }
            AidlUtil.getInstance().printText(ticket_header, 32, true, false, headerAlignment);
            if (!Validators.isNullOrEmpty(title))
                AidlUtil.getInstance().printText(title, 40, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

            AidlUtil.getInstance().printText("Customer Name: " + reservation.customer_name, 32, false, false, AidlUtil.Alignment.LEFT);

            if (!Validators.isNullOrEmpty(reservation.telephone)) {
                AidlUtil.getInstance().printText("Customer Number  : " + reservation.telephone, 32, false, false, AidlUtil.Alignment.LEFT);
            }

            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
            if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                AidlUtil.getInstance().printText("Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd/MM/yyyy"), 32, false, false, AidlUtil.Alignment.LEFT);
                AidlUtil.getInstance().printText("Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"), 32, false, false, AidlUtil.Alignment.LEFT);
            } else {
                AidlUtil.getInstance().printText("Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy"), 32, false, false, AidlUtil.Alignment.LEFT);
                AidlUtil.getInstance().printText("Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"), 32, false, false, AidlUtil.Alignment.LEFT);
            }
            AidlUtil.getInstance().printText("No of Diners     : " + reservation.diners, 32, false, false, AidlUtil.Alignment.LEFT);

            if (!reservation.online_reservation) {
                if (!Validators.isNullOrEmpty(reservation.deposit_type))
                    AidlUtil.getInstance().printText("Deposit Type     : " + reservation.deposit_type, 32, false, false, AidlUtil.Alignment.LEFT);
                AidlUtil.getInstance().printText("Deposit Amount   : " + reservation.deposit_amount, 32, false, false, AidlUtil.Alignment.LEFT);
            }
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

            if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                AidlUtil.getInstance().printText("Special Instructions : " + reservation.special_instruction, 32, false, false, AidlUtil.Alignment.LEFT);
                AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
            }

            AidlUtil.getInstance().printText(footerA, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(footerB, 32, true, false, AidlUtil.Alignment.CENTER);
            // set print true for local device
            setPrint(myPreferences, true);
            AidlUtil.getInstance().CutPaper();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printVoucher(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Voucher voucher, String footerA, String footerB, MyPreferences myPreferences) {
        try {

            if (tiffintomLogo != null) {
                AidlUtil.getInstance().printBitmap(tiffintomLogo);
            }
            AidlUtil.getInstance().printText(ticket_header, 32, true, false, headerAlignment);
            if (!Validators.isNullOrEmpty(title))
                AidlUtil.getInstance().printText(title, 40, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

            AidlUtil.getInstance().printText(voucher.voucher_code, 40, true, false, AidlUtil.Alignment.CENTER);

            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(MyApp.df.format(voucher.voucher_amount), 40, true, false, AidlUtil.Alignment.CENTER);

            StringBuilder sb = new StringBuilder();

            sb.append("Name: ").append(voucher.customer_name).append("\n");

//            if (voucher.customer != null) {
//                sb.append("Number: " + voucher.customer.mobile + "\n");
//                sb.append("Email: " + voucher.customer.email + "\n");
//            }

            sb.append("VALIDITY \n");

            sb.append("VALID FROM : ").append(CommonFunctions.formatUnknownDateTime(voucher.start_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");

            if (Validators.isNullOrEmpty(voucher.end_date) || voucher.end_date.contains("203")) {
                sb.append("VALID Till : No Expiry\n");
            } else {
                sb.append("VALID Till : ").append(CommonFunctions.formatUnknownDateTime(voucher.end_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");
            }

            sb.append("NOT VALID \n");

            if (!Validators.isNullOrEmpty(voucher.week_day)) {
                String[] daystList = voucher.week_day.split(",");
                StringBuilder daysBuilder = new StringBuilder();
                for (String str : daystList) {
                    if (Validators.isNullOrEmpty(str)) continue;
                    if (str.equalsIgnoreCase("1")) {
                        daysBuilder.append("Monday");
                    } else if (str.equalsIgnoreCase("2")) {
                        daysBuilder.append("Tuesday");
                    } else if (str.equalsIgnoreCase("3")) {
                        daysBuilder.append("Wednesday");
                    } else if (str.equalsIgnoreCase("4")) {
                        daysBuilder.append("Thursday");
                    } else if (str.equalsIgnoreCase("5")) {
                        daysBuilder.append("Friday");
                    } else if (str.equalsIgnoreCase("6")) {
                        daysBuilder.append("Saturday");
                    } else if (str.equalsIgnoreCase("0")) {
                        daysBuilder.append("Sunday");
                    }
                    if (daysBuilder.length() > 0) {
                        daysBuilder.append(", ");
                    }

                }
                sb.append("Not Valid on: ").append(daysBuilder.toString()).append("\n");
            }

            if (!Validators.isNullOrEmpty(voucher.order_type_id)) {
                String[] orderList = voucher.order_type_id.split(",");
                StringBuilder ordersBuilder = new StringBuilder();
                for (String str : orderList) {
                    if (Validators.isNullOrEmpty(str)) continue;
                    if (str.equalsIgnoreCase("1"))
                        ordersBuilder.append("Dine In");

                    if (str.equalsIgnoreCase("2"))
                        ordersBuilder.append("Collection");

                    if (str.equalsIgnoreCase("3"))
                        ordersBuilder.append("Delivery");

                    if (str.equalsIgnoreCase("4"))
                        ordersBuilder.append("Bar");

                    if (str.equalsIgnoreCase("5"))
                        ordersBuilder.append("Waiting");

                    if (str.equalsIgnoreCase("6"))
                        ordersBuilder.append("Web Order");

                    if (ordersBuilder.length() > 0) {
                        ordersBuilder.append(", ");
                    }
                }
                sb.append("Not Valid on: ").append(ordersBuilder.toString()).append("\n");
            }
            AidlUtil.getInstance().printText(sb.toString(), 32, false, false, AidlUtil.Alignment.LEFT);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

            AidlUtil.getInstance().printText(footerA, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText(footerB, 32, true, false, AidlUtil.Alignment.CENTER);
            // set print true for local device
            setPrint(myPreferences, true);
            AidlUtil.getInstance().CutPaper();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printFullReport(Bitmap tiffintomLogo, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        if (tiffintomLogo != null) {
            AidlUtil.getInstance().printBitmap(tiffintomLogo);
        }
        AidlUtil.getInstance().printText(header, 32, true, false, headerAlignment);
        if (!Validators.isNullOrEmpty(title))
            AidlUtil.getInstance().printText(title, 40, true, false, AidlUtil.Alignment.CENTER);
        AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

        if (!Validators.isNullOrEmpty(date)) {
            AidlUtil.getInstance().printText("Date: " + date, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }
        if (!Validators.isNullOrEmpty(user)) {
            AidlUtil.getInstance().printText("User name: " + user, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }
        for (Object objct : data) {
            if (objct instanceof ReportTextModel) {
                ReportTextModel textModel = (ReportTextModel) objct;

                String printText;
                if (!textModel.isHeader) {
                    if (!Validators.isNullOrEmpty(textModel.value)) {
                        if (textModel.value.contains(MyApp.currencySymbol)) {
                            printText = getTitleWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 24);
                        } else {
                            printText = getTitleWithPad(textModel.title, textModel.value, 28);
                        }
                    } else printText = getTitleWithPad(textModel.title, "", 28);
                } else {
                    printText = "\n" + textModel.title;
                }
                AidlUtil.getInstance().printText(printText, textModel.isHeader ? 34 : 32, textModel.isHeader, false, AidlUtil.Alignment.LEFT);

            }
            if (objct instanceof SalesReport) {
                SalesReport salesReport = (SalesReport) objct;
                String name = salesReport.product_name;
                if (Validators.isNullOrEmpty(name)) {
                    name = salesReport.category_name;
                }
                String printText;
                printText = getTitleWithPad(name + "x(" + salesReport.count + ")", salesReport.total, 28);
                AidlUtil.getInstance().printText(printText, 32, false, false, AidlUtil.Alignment.LEFT);

            }
        }

        AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

        AidlUtil.getInstance().printText(footerA, 32, true, false, AidlUtil.Alignment.CENTER);
        AidlUtil.getInstance().printText(footerB, 32, true, false, AidlUtil.Alignment.CENTER);
        // set print true for local device
        setPrint(myPreferences, true);
        AidlUtil.getInstance().CutPaper();
    }

    public void printFoodHubFullReport(Bitmap tiffintomLogo, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        if (tiffintomLogo != null) {
            AidlUtil.getInstance().printBitmap(tiffintomLogo);
        }
        AidlUtil.getInstance().printText(header, 32, true, false, headerAlignment);
        if (!Validators.isNullOrEmpty(title))
            AidlUtil.getInstance().printText(title, 40, true, false, AidlUtil.Alignment.CENTER);
        AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

        if (!Validators.isNullOrEmpty(date)) {
            AidlUtil.getInstance().printText("Date: " + date, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }
        if (!Validators.isNullOrEmpty(myPreferences.getRegisteredDevice().name)) {
            AidlUtil.getInstance().printText(myPreferences.getRegisteredDevice().name, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }
        if (!Validators.isNullOrEmpty(user)) {
            AidlUtil.getInstance().printText("User name: " + user, 32, true, false, AidlUtil.Alignment.CENTER);
            AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        }
        AidlUtil.getInstance().printText(reportHeader(AidlUtil.Size.SIZE0), AidlUtil.Size.SIZE0, true, false, AidlUtil.Alignment.CENTER);
        AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
        for (Object objct : data) {
            if (objct instanceof ReportTextModel) {
                ReportTextModel textModel = (ReportTextModel) objct;

                String printText;
                if (!textModel.isHeader) {
                    if (!Validators.isNullOrEmpty(textModel.value)) {
                        if (textModel.value.contains(MyApp.currencySymbol)) {
                            //printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 35);
                            printText = reportDetail(AidlUtil.Size.SIZE0, "", textModel.value, textModel.title);
                        } else {
                            //printText = getProductNameWithPad(textModel.title, textModel.value, 35);
                            printText = reportDetail(AidlUtil.Size.SIZE0, textModel.value, "", textModel.title);
                        }
                    } else {
                        if (!Validators.isNullOrEmpty(textModel.totalPrice) || !Validators.isNullOrEmpty(textModel.orderCount)) {
                            printText = reportDetail(AidlUtil.Size.SIZE0, textModel.orderCount, textModel.totalPrice, textModel.title);
                        } else {
                            printText = getProductNameWithPad(textModel.title, "", 35);
                        }
                    }
                } else {
                    printText = "" + textModel.title;
                }
                if (textModel.isHeader) {
                    AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
                    AidlUtil.getInstance().printText(printText, AidlUtil.Size.SIZE0, textModel.isHeader, false, AidlUtil.Alignment.LEFT);
                    AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);
                } else {
                    AidlUtil.getInstance().printText(printText, AidlUtil.Size.SIZE0, textModel.isHeader, false, AidlUtil.Alignment.LEFT);
                }

            }
            if (objct instanceof SalesReport) {
                SalesReport salesReport = (SalesReport) objct;
                String name = salesReport.product_name;
                if (Validators.isNullOrEmpty(name)) {
                    name = salesReport.category_name;
                }
                String printText;
                printText = getTitleWithPad(name + "x(" + salesReport.count + ")", salesReport.total, 28);
                AidlUtil.getInstance().printText(printText, 32, false, false, AidlUtil.Alignment.LEFT);

            }
        }

        AidlUtil.getInstance().printText("-------------------------------------", 30, false, false, AidlUtil.Alignment.CENTER);

        AidlUtil.getInstance().printText(footerA, 32, true, false, AidlUtil.Alignment.CENTER);
        AidlUtil.getInstance().printText(footerB, 32, true, false, AidlUtil.Alignment.CENTER);
        // set print true for local device
        setPrint(myPreferences, true);
        AidlUtil.getInstance().CutPaper();
    }

    private String reportHeader(float widthSize) {
        String orderTitle = "Orders  ";
        String priceTitle = "   Price";
        float _60Per = widthSize == AidlUtil.Size.SIZE0 ? 22 : 10;
        String orderPriceTitle = "";
        for (int emptySpace = 0; emptySpace < _60Per; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        // 2 space after orders in order to display space between orders and price
        orderPriceTitle = orderPriceTitle + orderTitle + "";
        orderPriceTitle = orderPriceTitle + priceTitle;
        Log.e("orderPriceTitle", "orderPriceTitleorderPriceTitle " + orderPriceTitle.length());
        return orderPriceTitle;
    }

    private String reportDetail(float widthSize, String ordersValue, String priceValue, String titleValue) {
        int _60Per = widthSize == AidlUtil.Size.SIZE0 ? 18 : 10;
        String orderPriceTitle = "";
        int titleLength = _60Per - titleValue.length();
        orderPriceTitle = titleValue + "";
        for (int emptySpace = 0; emptySpace < titleLength; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        Log.e("orderPriceTitle", "titleLengthtitleLength " + orderPriceTitle.length());
        // 2 space after orders in order to display space between orders and price
        if (Validators.isNullOrEmpty(ordersValue)) {
            int different = 10 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 10 - ordersValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + ordersValue;
            /*if(ordersValue.length()==1){
                orderPriceTitle =orderPriceTitle+ "   "+ordersValue+"   ";
            }else if(ordersValue.length()==2 || ordersValue.length()==3){
                orderPriceTitle = orderPriceTitle+"  "+ordersValue+"  ";
            }else {
                orderPriceTitle = orderPriceTitle +  ordersValue;
            }*/
        }
        orderPriceTitle = orderPriceTitle + "";
        if (Validators.isNullOrEmpty(priceValue)) {
            int different = 10 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 10 - priceValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + priceValue;
            /*if(priceValue.length()==1){
                orderPriceTitle = orderPriceTitle+"   "+priceValue+"   ";
            }else if(priceValue.length()==2 || priceValue.length()==3){
                orderPriceTitle = orderPriceTitle+"  "+priceValue+"  ";
            }else {
                orderPriceTitle = orderPriceTitle +  priceValue;
            }*/
        }
        Log.e("orderPriceTitle", "orderPriceTitleorderPriceTitle " + orderPriceTitle.length());
        return orderPriceTitle;
    }

    private String getTitleWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getSubaddonWithPadOnline(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }
                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(parts1[1].trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }

                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(part.trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();

            }

        }
        return subAddonName;
    }

    private void sendOrderToWifi(SendOrderWifiModel sendOrderWifiModel) {
        if (MyApp.getInstance().myPreferences.isSunmiEnabled() && MyApp.getInstance().myPreferences.getWifiConnectionId() != null && "auto".equalsIgnoreCase(MyApp.getInstance().myPreferences.getOrderSyncMode())) {
            Logger.INSTANCE.sendText(MyApp.getInstance().myPreferences.getWifiConnectionId(), new Gson().toJson(sendOrderWifiModel));
        }
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                int index = 0;
                List<String> parts = getParts(String.valueOf(parts1[1]), charatersInLine);
                int appendTill = parts.size();
                for (String partSub : parts) {
                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                    if (index < appendTill - 1) {
                        sb.append("\n");
                    }
                    index++;
                }
                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(parts1[1].trim(), charatersInLine);
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                int index = 0;
                List<String> parts = getParts(part, charatersInLine);
                int appendTill = parts.size();
                for (String partSub : parts) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                    if (index < appendTill - 1) {
                        sb.append("\n");
                    }
                    index++;
                }

                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(part.trim(), charatersInLine);

            }

        }
        return subAddonName;
    }

    public static String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    public static String padLeftSpace(String str, int n) {
        return String.format("%1$" + n + "s", str);
    }


    private static List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    private void writeToFile(String data, Context context) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(context.openFileOutput("print.txt", Context.MODE_PRIVATE));
            outputStreamWriter.write(data);
            outputStreamWriter.close();
        } catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }

    private StringBuffer getDays;
    private StringBuffer getOrderType;

    public void setDays(String string) {
        switch (string) {
            case "0":
                getDays.append("Monday, ");
                break;
            case "1":
                getDays.append("Tuesday, ");
                break;
            case "2":
                getDays.append("Wednesday, ");
                break;
            case "3":
                getDays.append("Thursday, ");
                break;
            case "4":
                getDays.append("Friday, ");
                break;
            case "5":
                getDays.append("Saturday, ");
                break;
            case "6":
                getDays.append("Sunday, ");
                break;
        }
    }

    public void setOrders(String string) {
        switch (string) {
            case "1":
                getOrderType.append("Dine In, ");
                break;
            case "2":
                getOrderType.append("Collection, ");
                break;
            case "3":
                getOrderType.append("Delivery, ");
                break;
            case "4":
                getOrderType.append("Bar, ");
                break;
            case "5":
                getOrderType.append("Waiting, ");
                break;
            case "6":
                getOrderType.append("Web Order, ");
                break;
        }
    }
}
