package com.ubsidi.epos_2021.comman.printer;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.util.Pair;

import com.google.gson.Gson;
import com.sunmi.printerx.SdkException;
import com.sunmi.printerx.api.CanvasApi;
import com.sunmi.printerx.api.LineApi;
import com.sunmi.printerx.enums.Align;
import com.sunmi.printerx.enums.DividingLine;
import com.sunmi.printerx.enums.ImageAlgorithm;
import com.sunmi.printerx.style.BaseStyle;
import com.sunmi.printerx.style.BitmapStyle;
import com.sunmi.printerx.style.TextStyle;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.ReportTextModel;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SalesReport;
import com.ubsidi.epos_2021.models.SendOrderWifiModel;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.SurChargesModel;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderProductDetail;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.Logger;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;

public class SunmiPrinterV3Mix {
    private Context context;
    public MyApp myApp = MyApp.getInstance();
    public SiteSetting printBlockBill = myApp.findSetting("print_block_bill");
    private LineApi lineApi;
    private CanvasApi canvasApi;

    public SunmiPrinterV3Mix(Context context) {
        this.context = context;
        //startService(context);
        if (myApp.selectPrinter != null) {
            try {
                lineApi = myApp.selectPrinter.lineApi();
                lineApi.initLine(BaseStyle.getStyle());
                canvasApi = myApp.selectPrinter.canvasApi();
                canvasApi.initCanvas(BaseStyle.getStyle());
            } catch (SdkException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void openCashDrawer() {
        try {
            myApp.selectPrinter.cashDrawerApi().open(null);
        } catch (SdkException e) {
            e.printStackTrace();
        }
    }

    public void printCardReaderReceipt(Bitmap bm, String rePrintTitle, String title, String header, String header1, int headerAlignment, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1, MyPreferences myPreferences) {
        if (lineApi != null) {
            try {
                if (bm != null)
                    lineApi.printBitmap(bm, BitmapStyle.getStyle().setAlgorithm(ImageAlgorithm.DITHERING));
                if (!Validators.isNullOrEmpty(header)) {
                    printTextHeader(headerAlignment, header);
                }
                if (!Validators.isNullOrEmpty(header1)) {
                    printTextHeader(headerAlignment, header1);
                }
                if (!Validators.isNullOrEmpty(rePrintTitle)) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                    lineApi.printText(rePrintTitle + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false));
                }
                if (!Validators.isNullOrEmpty(title)) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                    lineApi.printText(title + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false));
                }
                printSeperatorImin3Max();
                if (!Validators.isNullOrEmpty(tip_amount)) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                    lineApi.printText(actual_amount + "\n", TextStyle.getStyle().setTextSize(36).enableBold(true).enableUnderline(false));
                    lineApi.printText(tip_amount + "\n", TextStyle.getStyle().setTextSize(36).enableBold(true).enableUnderline(false));
                }
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                lineApi.printText(grand_total + "\n", TextStyle.getStyle().setTextSize(52).enableBold(true).enableUnderline(false));
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                lineApi.printText(main_content + "\n", TextStyle.getStyle().setTextSize(26).enableBold(true).enableUnderline(false));
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                lineApi.printText(please + "\n", TextStyle.getStyle().setTextSize(26).enableBold(true).enableUnderline(false));
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                lineApi.printText(final_date + "\n", TextStyle.getStyle().setTextSize(26).enableBold(true).enableUnderline(false));
                printSeperatorImin3Max();
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                if (!Validators.isNullOrEmpty(footer)) {
                    lineApi.printText(footer + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
                }
                if (!Validators.isNullOrEmpty(footer1)) {
                    lineApi.printText(footer1 + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
                }
                // set print true for local device
                setPrint(myPreferences, true);
                lineApi.addText(" \n \n ", new TextStyle());
                lineApi.autoOut();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setPrint(MyPreferences myPreferences, boolean isPrint) {
        myPreferences.saveIsPrintBill(isPrint);
    }

    public void printMotoReceipt(Bitmap bm, String title, String header, int headerAlignment, String amount, String main_content, String date_final, String please, String footer, String footer1, MyPreferences myPreferences) {
        try {
            if (bm != null) {
                lineApi.printBitmap(bm, BitmapStyle.getStyle().setAlgorithm(ImageAlgorithm.DITHERING));
            }
            printTextHeader(headerAlignment, header);
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            lineApi.addText(title + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false));
            printSeperatorImin3Max();

            amount = amount.replace("£", "");
            amount = amount.replace("\n", "");
            amount = amount + " GBP";
            lineApi.addText(amount + "\n", TextStyle.getStyle().setTextSize(52).enableBold(true).enableUnderline(false).setAlign(Align.CENTER));
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
            lineApi.addText(main_content.replace(" :", ": ") + "\n", TextStyle.getStyle().setTextSize(22).enableBold(true).enableUnderline(false));
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            lineApi.addText(date_final + "\n", TextStyle.getStyle().setTextSize(26).enableBold(true).enableUnderline(false));
            lineApi.addText(please + "\n", TextStyle.getStyle().setTextSize(26).enableBold(true).enableUnderline(false));

            printSeperatorImin3Max();
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            lineApi.addText(footer + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            lineApi.addText(footer1 + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            // set print true for local device
            setPrint(myPreferences, true);
            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printOrderFoodHub(ArrayList<PrintStyle> listPrintStructure, List<PrintSetting> printSettings, Bitmap tiffintomBitmap, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo, String onlineOrderPrintCount, Callable<Void> nextMethod) {
        int style = 0, alignment = 0;
        float size = 0;
        boolean isbold = false, isUnderline = false;
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }
        Align align;
        try {
            if (!orderTiffinTomLogo) {
                if (tiffintomBitmap != null) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                    lineApi.printBitmap(tiffintomBitmap, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
                    lineApi.addText("\n", TextStyle.getStyle());
                }
            } else {
                if (businessLogo != null) {
                    lineApi.printBitmap(businessLogo, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
                    lineApi.addText("\n", TextStyle.getStyle());
                }
            }

            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean priceInItems = listPrintStructure.get(i).price;
                Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(listPrintStructure.get(i).style);
                isbold = boldUnderLine.first;
                isUnderline = boldUnderLine.second;
                size = getSizeCommon(listPrintStructure.get(i).size).intValue();
                align = getAlignCommon(listPrintStructure.get(i).alignment);
                boolean isSeparator = listPrintStructure.get(i).separator;
                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                switch (key) {
                    case "online_title": {
                        String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                        String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                        if (!todayDate.equalsIgnoreCase(orderDateString)) {
                            lineApi.addText("This Order Is Not For Today\n\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeperatorImin3Max();
                        }
                        break;
                    }
                    case "online_site": {
                        lineApi.addText("Tiffintom.com sent you order\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeperatorImin3Max();
                        }
                        break;
                    }
                    case "online_order_type": {
                        lineApi.addText(CommonFunctions.getOnlineOrderType(orderType) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeperatorImin3Max();
                        }
                        break;
                    }
                    case "online_order_no": {
                        lineApi.addText("ORDER NO: " + orderDetail.order_number + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeperatorImin3Max();
                        }
                        break;
                    }
                    case "online_order_date": {
                        if (orderType > 0) {
                            if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                                lineApi.addText("ASAP" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            } else {
                                lineApi.addText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            }
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_items": {

                        String itemName = "", price = "", qty = "", printBlockId = null;
                        int position = 0, productPosition = 0;
                        boolean isLastContainsLine = false;
                        for (OrderProductDetail productDetail : orderDetail.cart_view) {
                            position = position + 1;
                            productPosition = productPosition + 1;
                            if (printBlockId == null) {
                                printBlockId = productDetail.print_block_id;
                            }
                            if (productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                                printBlockId = productDetail.print_block_id;
                                if (orderDetail.cart_view.size() - 1 == productPosition) {
                                    isLastContainsLine = true;
                                }
                                printSeparator();
                            }
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                            String productQty = String.valueOf(productDetail.quantity);
                            String totalPrice = String.valueOf(productDetail.total_price);
                            // Here we need 16 characters in product name so we send 16 in
                            // @params charactersInLine
                            price = (priceInItems) ? MyApp.df.format(productDetail.total_price) : "";
                            //itemName = getProductNameWithPad(productName, price, kitchenCopy ? 20 : 28);
                            qty = productQty;
                            if (productQty.length() <= 1) {
                                qty = " " + productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }
                            String printItem;
                            printItem = qty + itemName + "";
                            int fontSize = 30;
                            if (kitchenCopy) fontSize = 36;
                            if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                                String[] productNameSplit = productName.split(" ");
                                String finalPrice = "  " + price;
                                String secondLine = qty;
                                int lengthForSize;
                                if (size == AidlUtil.Size.SIZE0) {
                                    lengthForSize = 38;
                                } else if (size == AidlUtil.Size.SIZE1) {
                                    lengthForSize = 28;
                                } else {
                                    lengthForSize = 23;
                                }
                                int multiplyLength = 1;
                                int index = 0;
                                for (String s : productNameSplit) {
                                    index = index + 1;
                                    Log.e("finalPrice", "finalPrice " + finalPrice + "string to apend " + s.length());
                                    if (secondLine.length() < (multiplyLength * lengthForSize)) {
                                        if ((secondLine + " " + s + finalPrice).length() > (multiplyLength * lengthForSize)) {
                                            //secondLine = secondLine+secondLine.replace(,"");
                                            int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                                            if (multiplyLength == 1) {
                                                emptySpaceLength = emptySpaceLength - finalPrice.length();
                                                for (int space = 0; space < emptySpaceLength; space++) {
                                                    secondLine = secondLine + (" ");
                                                }
                                                secondLine = secondLine + finalPrice;
                                            } else {
                                                for (int space = 0; space < emptySpaceLength; space++) {
                                                    secondLine = secondLine + (" ");
                                                }
                                            }
                                            multiplyLength = multiplyLength + 1;
                                            secondLine = secondLine + ("\n");
                                            for (int j = 0; j < qty.length(); j++) {
                                                secondLine = secondLine + (" ");
                                            }
                                        }
                                    } else {
                                        multiplyLength = multiplyLength + 1;
                                        secondLine = secondLine + ("\n");
                                        for (int j = 0; j < qty.length(); j++) {
                                            secondLine = secondLine + (" ");
                                        }
                                    }
                                    secondLine = secondLine + " " + s;
                                    if (productNameSplit.length == index && multiplyLength == 1 && secondLine.length() < (multiplyLength * lengthForSize)) {
                                        if (multiplyLength == 1) {
                                            int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                                            emptySpaceLength = emptySpaceLength - finalPrice.length();
                                            for (int space = 0; space < emptySpaceLength; space++) {
                                                secondLine = secondLine + (" ");
                                            }
                                            secondLine = secondLine + finalPrice;
                                        }
                                    }
                                }
                                itemName = secondLine;
                                printItem = itemName;
                            }
                            lineApi.addText(printItem + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));

                            if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                                try {
                                    //String[] parts = menus.get(position).getSubaddonsName().split(",");
                                    String[] parts = productDetail.subaddons_name.split(",");

                                    for (String subAddonPart : parts) {
                                        int fontSizeSub = 30;
                                        int charactersInLine = 20;
                                        if (kitchenCopy) {
                                            fontSizeSub = 36;
                                            charactersInLine = 16;
                                        }
                                        String printedItem = getSubaddonWithPadOnline(" - " + subAddonPart, charactersInLine);
                                        lineApi.addText(printedItem + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                    }
                                } catch (Exception e) {
                                    Log.e("Addon_Error", e.getMessage());
                                }
                            }
                            if (all_separator && orderDetail.cart_view.size() > position) {
                                printSeparator();
                            }
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_sub_total": {
                        lineApi.addText(formatTotal(size, "SubTotal:", MyApp.currencySymbol + MyApp.df.format(orderDetail.order_sub_total)) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_delivery_charge": {
                        if (orderDetail.delivery_charge > 0) {
                            lineApi.addText(formatTotal(size, "Delivery Charge:", MyApp.currencySymbol + MyApp.df.format(orderDetail.delivery_charge)) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_service_charge": {
                        if (orderDetail.service_charge > 0) {
                            if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                                lineApi.addText(formatTotal(size, "Service Charge:", MyApp.currencySymbol + MyApp.df.format(orderDetail.service_charge)) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "online_driver_tip": {
                        if (orderDetail.driver_tip > 0) {
                            lineApi.addText(formatTotal(size, "Driver Tip:", MyApp.currencySymbol + MyApp.df.format(orderDetail.driver_tip)) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_loyalty": {
                        if (orderDetail.reward_offer > 0) {
                            lineApi.addText(formatTotal(size, "Loyalty Point Discount:", MyApp.currencySymbol + MyApp.df.format(orderDetail.reward_offer)) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_offer": {
                        if (orderDetail.offer_amount > 0) {
                            lineApi.addText(formatTotal(size, "Offer:", MyApp.currencySymbol + MyApp.df.format(orderDetail.offer_amount)) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_grand_total": {
                        lineApi.addText(formatTotal(size, "Total:  ", MyApp.currencySymbol + MyApp.df.format(orderDetail.order_grand_total) + "") + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_comment": {
                        if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                            lineApi.addText("Comments: " + orderDetail.order_description + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_delivery_instruction": {
                        if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                            lineApi.addText("Delivery Instructions: " + orderDetail.delivery_instruction + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_customer_details": {
                        lineApi.addText("" + orderDetail.customer_name + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                            lineApi.addText(orderDetail.customer_phone + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_delivery_address": {
                        if (orderType == 1) {
                            String address = orderDetail.address + "\n";
                            String[] parts = address.split("[\\\\s,]+");
                            StringBuilder str = new StringBuilder();

                            for (String name : parts) {
                                str.append(name).append("\n");
                            }
                            if (!Validators.isNullOrEmpty(address)) {
                                lineApi.addText(address + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "online_requested_for": {
                        if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                            lineApi.addText("Requested for: ASAP" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        } else {
                            lineApi.addText("Requested for: " + orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                            lineApi.addText("Confirmed for: " + orderDetail.preparation + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_payment_status": {
                        lineApi.addText(" " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "UNPAID" : "PAID") + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_payment_method": {
                        String paymentName = "";
                        if (orderDetail.payment_method.equalsIgnoreCase("stripe"))
                            paymentName = "ONLINE";
                        if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                        if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                            paymentName = "WALLET";
                        if (orderDetail.payment_method.equalsIgnoreCase("paypal"))
                            paymentName = "PAYPAL";
                        if (!Validators.isNullOrEmpty(paymentName)) {
                            lineApi.addText(" Payment Type : " + paymentName + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_receipt_time": {
                        lineApi.addText("Receipt Time:" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        lineApi.addText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_status": {
                        lineApi.addText("Order status: " + orderDetail.status + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (orderDetail.status.equalsIgnoreCase("failed")) {
                            lineApi.addText("Reason: " + orderDetail.failed_reason + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_restaurant_address": {
                        if (!kitchenCopy) {
                            lineApi.addText(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_failed_reason": {
                        if (orderDetail.status.equalsIgnoreCase("failed")) {
                            lineApi.addText("Reason: " + orderDetail.failed_reason + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_footer": {
                        if (!kitchenCopy) {
                            lineApi.addText("Thanks!" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                }
            }

            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();

            if (kitchenCopy) {
                if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                    //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                    CommonFunctions.functionThatDelay(100);
                    int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                    onlineOrderPrint = onlineOrderPrint - 1;
                    printOrderFoodHub(listPrintStructure, printSettings, tiffintomBitmap, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);
                } else {
                    nextMethod.call();
                }
            } else {
                nextMethod.call();
            }
        } catch (Exception e) {
            System.out.println(e);
            try {
                if (kitchenCopy) {
                    if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                        //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                        CommonFunctions.functionThatDelay(100);
                        int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                        onlineOrderPrint = onlineOrderPrint - 1;
                        printOrderFoodHub(listPrintStructure, printSettings, tiffintomBitmap, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);
                    } else {
                        nextMethod.call();
                    }
                } else {
                    nextMethod.call();
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private String formatTotal(float widthSize, String titleOfTotal, String totalValue) {
        int lengthForSize = (widthSize == AidlUtil.Size.SIZE0 ? 38 : 28) - (titleOfTotal.length() + totalValue.length());
        StringBuilder finalTitle = new StringBuilder(titleOfTotal);
        for (int space = 0; space < lengthForSize; space++) {
            finalTitle.append(" ");
        }
        finalTitle.append(totalValue);
        return finalTitle.toString();
    }

    public void printOrder(PrintStructure structure, List<PrintSetting> printSettings, Bitmap tiffintomBitmap, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean orderTiffinTomLogo, String onlineOrderPrintCount, Callable<Void> nextMethod) {
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }

        try {
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (!orderTiffinTomLogo) {
                if (tiffintomBitmap != null) {
                    lineApi.printBitmap(tiffintomBitmap, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
                }
            } else {
                if (businessLogo != null) {
                    lineApi.printBitmap(businessLogo, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
                }
            }
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (structure.online_title.visibility) {
                String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                if (!todayDate.equalsIgnoreCase(orderDateString)) {
                    lineApi.addText("This Order Is Not For Today\n\n", TextStyle.getStyle().setTextSize(40).enableBold(false).enableUnderline(false));
                }
            }
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (structure.online_site.visibility) {
                lineApi.addText("Tiffintom.com sent you order\n\n", TextStyle.getStyle().setTextSize(26).enableBold(false).enableUnderline(false));
            }

            if (structure.online_order_type.visibility) {
                lineApi.addText(CommonFunctions.getOnlineOrderType(orderType) + "\n", TextStyle.getStyle().setTextSize(36).enableBold(false).enableUnderline(false).setAlign(Align.CENTER));

                printSeperatorImin3Max();
            }

            if (structure.online_order_no.visibility) {
                lineApi.addText("ORDER NO: " + orderDetail.order_number + "\n", TextStyle.getStyle().setTextSize(36).enableBold(false).enableUnderline(false).setAlign(Align.CENTER));
            }

            if (structure.online_order_date.visibility) {
                if (orderType > 0) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                        lineApi.addText("ASAP" + "\n", TextStyle.getStyle().enableBold(false).enableUnderline(false));
                    } else {
                        lineApi.addText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", TextStyle.getStyle().enableBold(false).enableUnderline(false));
                    }
                }
                printSeperatorImin3Max();
            }

            if (structure.online_items.visibility) {
                String itemName = "", price = "", qty = "", printBlockId = null;
                int productPosition = 0;
                boolean isLastContainsLine = false;
                for (OrderProductDetail productDetail : orderDetail.cart_view) {
                    productPosition = productPosition + 1;
                    if (printBlockId == null) {
                        printBlockId = productDetail.print_block_id;
                    }
                    if (productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                        printBlockId = productDetail.print_block_id;
                        if (orderDetail.cart_view.size() - 1 == productPosition) {
                            isLastContainsLine = true;
                        }
                        printSeparator();
                    }
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                    String productQty = String.valueOf(productDetail.quantity);
                    String totalPrice = String.valueOf(productDetail.total_price);
                    // Here we need 16 characters in product name so we send 16 in
                    // @params charactersInLine
                    price = (!kitchenCopy) ? MyApp.df.format(productDetail.total_price) : "";
                    itemName = getProductNameWithPad(productName, price, kitchenCopy ? 20 : 28);
                    qty = productQty;
                    if (productQty.length() <= 1) {
                        qty = " " + productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }
                    String printItem;
                    printItem = qty + itemName + "\n";
                    int fontSize = 30;
                    if (kitchenCopy) fontSize = 36;
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    lineApi.addText(printItem, TextStyle.getStyle().setTextSize(fontSize).enableBold(false).enableUnderline(false));
                    if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                        try {
                            //String[] parts = menus.get(position).getSubaddonsName().split(",");
                            String[] parts = productDetail.subaddons_name.split(",");

                            for (String subAddonPart : parts) {
                                int fontSizeSub = 30;
                                int charactersInLine = 20;
                                if (kitchenCopy) {
                                    fontSizeSub = 36;
                                    charactersInLine = 16;
                                }
                                String printedItem = getSubaddonWithPadOnline(subAddonPart, charactersInLine);
                                lineApi.addText(printedItem + "\n", TextStyle.getStyle().setTextSize(fontSizeSub).enableBold(false).enableUnderline(false));
                            }
                        } catch (Exception e) {
                            Log.e("Addon_Error", e.getMessage());
                        }
                    }
                }
                if (!isLastContainsLine) {
                    printSeperatorImin3Max();
                }
            }
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
            if (structure.online_sub_total.visibility) {
                lineApi.addText(padRightSpaces("SubTotal:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.order_sub_total) + "\n", TextStyle.getStyle().enableBold(false).enableUnderline(false));
            }

            if (structure.online_delivery_charge.visibility) {
                if (orderDetail.delivery_charge > 0) {
                    lineApi.addText(padRightSpaces("Delivery Charge:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.delivery_charge) + "\n", TextStyle.getStyle());
                }
            }

            if (structure.online_service_charge.visibility) {
                if (orderDetail.service_charge > 0) {
                    if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                        lineApi.addText(padRightSpaces("Service Charge:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.service_charge) + "\n", TextStyle.getStyle());
                    }
                }
            }

            if (structure.online_driver_tip.visibility) {
                if (orderDetail.driver_tip > 0) {
                    lineApi.addText(padRightSpaces("Driver Tip:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.driver_tip) + "\n", TextStyle.getStyle());
                }
            }

            if (structure.online_loyalty.visibility) {
                if (orderDetail.reward_offer > 0) {
                    lineApi.addText(padRightSpaces("Loyalty Point Discount:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.reward_offer) + "\n", TextStyle.getStyle());
                }
            }

            if (structure.online_offer.visibility) {
                if (orderDetail.offer_amount > 0) {
                    lineApi.addText(padRightSpaces("Offer:", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.offer_amount) + "\n", TextStyle.getStyle());
                }
            }
            if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                    if (surChargesModel.surcharge_amount > 0) {
                        lineApi.addText(padRightSpaces(surChargesModel.surcharge_name, 16) + MyApp.currencySymbol + MyApp.df.format(surChargesModel.surcharge_amount) + "\n", TextStyle.getStyle());
                    }
                }
            }
            if (structure.online_grand_total.visibility) {
                lineApi.addText(padRightSpaces("Total:  ", 25) + MyApp.currencySymbol + MyApp.df.format(orderDetail.order_grand_total) + "\n", TextStyle.getStyle().setTextSize(36));
                printSeperatorImin3Max();
            }

            if (structure.online_comment.visibility) {
                if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                    lineApi.addText("Comments: " + orderDetail.order_description + "\n", TextStyle.getStyle().enableBold(true).setTextSize(kitchenCopy ? 40 : 32));
                    printSeperatorImin3Max();
                }
            }

            if (structure.online_delivery_instruction.visibility) {
                if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                    lineApi.addText("Delivery Instructions: " + orderDetail.delivery_instruction + "\n", TextStyle.getStyle().enableBold(true).setTextSize(32));
                    printSeperatorImin3Max();
                }
            }

            if (structure.online_customer_details.visibility) {
                lineApi.addText("Cust Name: " + orderDetail.customer_name + "\n", TextStyle.getStyle().enableBold(true).setTextSize(32));
                if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                    lineApi.addText("Cust No: " + orderDetail.customer_phone + "\n", TextStyle.getStyle().enableBold(true).setTextSize(32));
                }
                printSeperatorImin3Max();
            }

            if (structure.online_delivery_address.visibility) {
                if (orderType == 1) {
                    String address = orderDetail.address + "\n";
                    String[] parts = address.split("[\\\\s,]+");
                    StringBuilder str = new StringBuilder();

                    for (String name : parts) {
                        str.append(name).append("\n");
                    }
                    lineApi.addText("Del. address: " + address + "\n", TextStyle.getStyle().enableBold(true).setTextSize(32));
                    printSeperatorImin3Max();
                }
            }

            if (structure.online_requested_for.visibility) {
                if (orderType >= 0) {
                    lineApi.addText("Requested for: " + "\n", TextStyle.getStyle().setTextSize(36));
                    if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                        lineApi.addText("ASAP" + "\n", TextStyle.getStyle().setTextSize(36));
                    } else {
                        lineApi.addText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", TextStyle.getStyle().setTextSize(36));
                    }
                    printSeperatorImin3Max();
                    if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                        lineApi.addText("Confirmed for: " + "\n", TextStyle.getStyle().setTextSize(36));
                        lineApi.addText("" + orderDetail.preparation + "\n", TextStyle.getStyle().setTextSize(36));
                        printSeperatorImin3Max();
                    }
                }
            }

            if (structure.online_payment_status.visibility) {
                lineApi.addText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n", TextStyle.getStyle().enableBold(true).setTextSize(36));
            }

            if (structure.online_payment_method.visibility) {
                String paymentName = "";
                if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
                if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                    paymentName = "WALLET";
                if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";

                lineApi.addText("Payment Type : " + paymentName + "\n", TextStyle.getStyle().enableBold(true).setTextSize(26));
                printSeperatorImin3Max();
            }

            if (structure.online_receipt_time.visibility) {
                lineApi.addText("Receipt Time:\n", TextStyle.getStyle().enableBold(true).setTextSize(32).setAlign(Align.LEFT));
                lineApi.addText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", TextStyle.getStyle().enableBold(true).setTextSize(32));
            }

            if (structure.online_order_status.visibility) {
                lineApi.addText("Order status: " + orderDetail.status + "\n", TextStyle.getStyle().enableBold(false).setTextSize(32));
                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    lineApi.addText("Reason: " + orderDetail.failed_reason + "\n", TextStyle.getStyle().enableBold(false).setTextSize(32));
                }
            }

            if (structure.online_restaurant_address.visibility) {
                lineApi.addText(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address + "\n", TextStyle.getStyle().enableBold(true).setTextSize(28));
            }

            if (structure.online_failed_reason.visibility) {
                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    lineApi.addText("Reason: " + orderDetail.failed_reason + "\n", TextStyle.getStyle().enableBold(false).setTextSize(28));
                }
            }

            if (structure.online_footer.visibility) {
                lineApi.addText("Thanks!\n", TextStyle.getStyle().enableBold(false).setTextSize(28));
            }

            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();

            if (kitchenCopy) {
                if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                    //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                    CommonFunctions.functionThatDelay(100);
                    int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                    onlineOrderPrint = onlineOrderPrint - 1;
                    printOrder(structure, printSettings, tiffintomBitmap, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);
                } else {
                    nextMethod.call();
                }
            } else {
                nextMethod.call();
            }
        } catch (Exception e) {
            System.out.println(e);
            try {
                if (kitchenCopy) {
                    if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                        //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                        CommonFunctions.functionThatDelay(100);
                        int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                        onlineOrderPrint = onlineOrderPrint - 1;
                        printOrder(structure, printSettings, tiffintomBitmap, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), nextMethod);
                    } else {
                        nextMethod.call();
                    }
                } else {
                    nextMethod.call();
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void printSeperatorImin3Max() {
        try {
            //lineApi.addText("-------------------------------------" + "\n", TextStyle.getStyle().enableBold(false).enableUnderline(false).setAlign(Align.CENTER));
            lineApi.printDividingLine(DividingLine.DOTTED, 1);
        } catch (SdkException e) {
            throw new RuntimeException(e);
        }
    }

    public void printOrderEpos(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, MyPreferences myPreferences, float voucherPaymentDoneAmount) {
        if (lineApi != null) {
            int style = 0, alignment = 0;
            Align align;
            int size = 0;
            boolean isbold = false, isUnderline = false;
            int orderType = -1;
            if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
                orderType = 0;
            } else {
                orderType = Integer.parseInt(orderDetail.order_type_id);
            }
            try {
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                if (!kitchenCopy && tiffintomLogo != null) {
                    //AidlUtil.getInstance().printBitmap(tiffintomLogo);
                    lineApi.printBitmap(tiffintomLogo, BitmapStyle.getStyle().setAlgorithm(ImageAlgorithm.DITHERING));
                }
                if (!Validators.isNullOrEmpty(ticket_header))
                    if (!kitchenCopy) {
                        lineApi.addText(ticket_header + "\n", TextStyle.getStyle().enableBold(true).enableUnderline(true).setAlign(Align.CENTER));
                    }

                if (structure.header_order_type.visibility && kitchenCopy) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.header_order_type.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.header_order_type.size).intValue();
                    align = getAlignCommon(structure.header_order_type.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderTypeHeading))
                        lineApi.addText("** " + orderTypeHeading + " **" + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));

                }
                // footer table number
                if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_table_number.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.footer_table_number.size).intValue();
                    align = getAlignCommon(structure.footer_table_number.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                        printSeperatorImin3Max();
                        lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    }
                }
                // footer order number
                if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_order_number.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.footer_order_number.size).intValue();
                    align = getAlignCommon(structure.footer_order_number.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        if (orderDetail._id != 0) {
                            lineApi.addText("Order No: " + orderDetail._id + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                    } else {
                        lineApi.addText("Order No: " + orderDetail.display_order_id + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    }
                }
                if (structure.header_customer_name.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.header_customer_name.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.header_customer_name.size).intValue();
                    align = getAlignCommon(structure.header_customer_name.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        lineApi.addText(orderDetail.customer_name + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    }
                }
                printSeperatorImin3Max();

                if (structure.title.visibility && kitchenCopy) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.title.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.title.size).intValue();
                    align = getAlignCommon(structure.title.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(title)) {
                        lineApi.addText(title + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        printSeperatorImin3Max();
                    }
                }

                if (structure.order_no.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.order_no.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.order_no.size).intValue();
                    align = getAlignCommon(structure.order_no.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        if (orderDetail._id > 0)
                            lineApi.addText("Order No: " + orderDetail._id + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    } else {
                        lineApi.addText("Order No: " + orderDetail.display_order_id + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    }
                    if (kitchenCopy) {
                        printSeperatorImin3Max();
                    }
                }

                if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.table_no.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.table_no.size).intValue();
                    align = getAlignCommon(structure.table_no.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderDetail.table_number))
                        lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));

                    Pair<Boolean, Boolean> no_of_diners = getUnderLineBoldCommon(structure.no_of_diners.style);
                    isbold = no_of_diners.first;
                    isUnderline = no_of_diners.second;
                    size = getSizeCommon(structure.no_of_diners.size).intValue();
                    align = getAlignCommon(structure.no_of_diners.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderDetail.no_guest))
                        lineApi.addText(("   No of Diners: ") + orderDetail.no_guest + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));

                    printSeperatorImin3Max();
                } else if (structure.table_no.visibility && orderType == 1) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.table_no.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.table_no.size).intValue();
                    align = getAlignCommon(structure.table_no.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    lineApi.addText(("Table No: " + orderDetail.table_number) + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    printSeperatorImin3Max();
                } else if (structure.no_of_diners.visibility && orderType == 1) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.no_of_diners.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.no_of_diners.size).intValue();
                    align = getAlignCommon(structure.no_of_diners.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderDetail.no_guest)) {
                        lineApi.addText(("No of Diners: " + orderDetail.no_guest) + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        printSeperatorImin3Max();
                    }
                }
                String orderDate = null, orderTime = null;
                String receiptDate = null;
                if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                    if (orderDetail.created_at.contains("Z")) {
                        orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                        orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                    } else {
                        orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                        orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                    }
                }
                if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                    if (orderDetail.updated_at.contains("Z")) {
                        receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                    } else {
                        receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                    }
                }
                if (structure.order_date != null) {
                    if (structure.order_date.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.order_date.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.order_date.size).intValue();
                        align = getAlignCommon(structure.order_date.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (!Validators.isNullOrEmpty(orderDate))
                            if (structure.order_time != null && structure.order_time.visibility) {
                                lineApi.addText("Date :" + orderDate + " ", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                            } else {
                                lineApi.addText("Date :" + orderDate + " " + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                                printSeperatorImin3Max();
                            }
                    }
                }
                if (structure.order_time != null) {
                    if (structure.order_time.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.order_time.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.order_time.size).intValue();
                        align = getAlignCommon(structure.order_time.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (!Validators.isNullOrEmpty(orderTime)) {
                            lineApi.addText("Time :" + orderTime + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                            printSeperatorImin3Max();
                        }
                    }
                }

                if (orderType > 1 && !kitchenCopy) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    if (!Validators.isNullOrEmpty(orderDetail.order_type))
                        lineApi.addText("Order Type: " + orderDetail.order_type + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    printSeperatorImin3Max();
                }

                if (structure.items_header.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.items_header.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.items_header.size).intValue();
                    align = getAlignCommon(structure.items_header.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    lineApi.addText("Qty Name" + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                }

                if (structure.items.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.items.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.items.size).intValue();
                    align = getAlignCommon(structure.items.alignment);
                    String itemName = "", price = "", qty = "";
                    String lastBlockId = null;
                    boolean lastItemWasMisc = false;

                    for (OrderItem productDetail : orderDetail.order_items) {
                        String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                        //String productQty = String.valueOf(productDetail.quantity);

                        String productQty;
                        if (kitchenCopy) {
                            productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                        } else {
                            productQty = String.valueOf(productDetail.quantity);
                        }
                        // Here we need 16 characters in product name so we send 16 in
                        // @params charactersInLine
                        price = (!kitchenCopy) ? MyApp.df.format(productDetail.total) : "";
                        if (kitchenCopy)
                            itemName = getProductNameWithPad(productName, price, 25);
                        else
                            itemName = getProductNameWithPad(productName, price, 28);
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + " ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "";
                        }
                        if (lastBlockId != null) {
                            if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                            }
                            if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                printSeperatorImin3Max();
                        } else {
                            if (lastItemWasMisc && !productDetail.misc) {
                                if (kitchenCopy)
                                    printSeperatorImin3Max();
                            }
                        }

                        String printItem;
                        printItem = qty + itemName.trim();
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        lineApi.addText(printItem + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                            lineApi.addText("   Instruction: " + productDetail.special_instruction + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(false).setAlign(Align.LEFT).setTextSize((int) AidlUtil.Size.SIZE0));

                        if (productDetail.order_item_addons.size() > 0) {
                            if (structure.items_subaddon.visibility) {
                                Pair<Boolean, Boolean> items_subaddon = getUnderLineBoldCommon(structure.items_header.style);
                                isbold = items_subaddon.first;
                                isUnderline = items_subaddon.second;
                                size = getSizeCommon(structure.items_header.size).intValue();
                                align = getAlignCommon(structure.items_header.alignment);
                                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                                lineApi.addText("Choose Your Base:" + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                            }

                            for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                    continue;
                                }
                                productQty = orderItemAddon.quantity + "";
                                productName = orderItemAddon.addon_name + "";
                                price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                                if (kitchenCopy)
                                    itemName = getProductNameWithPad(productName, price, 25);
                                else
                                    itemName = getProductNameWithPad(productName, price, 28);
                                qty = productQty;
                                if (productQty.length() <= 1) {
                                    qty = " " + productQty + " ";
                                } else if (productQty.length() <= 2) {
                                    qty = productQty + " ";

                                } else if (productQty.length() <= 3) {
                                    qty = productQty + " ";

                                } else if (productQty.length() <= 4) {
                                    qty = productQty + "";
                                }
                                // adding qty when total or price is zero as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                if (orderItemAddon.quantity > 1) {
                                    printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? qty + itemName.trim() : qty + itemName.trim();
                                } else {
                                    printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? itemName.trim() : itemName.trim();
                                }
                                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                                lineApi.addText(printItem + "\n", TextStyle.getStyle().enableBold(true).enableUnderline(false).setTextSize((int) AidlUtil.Size.SIZE0));
                            }
                        }

                        for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                            String ingredientName = orderItemIngredient.ingredient_name;
                            if (orderItemIngredient.with) {
                                ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                            }
                            if (orderItemIngredient.without) {
                                ingredientName = "No " + ingredientName;
                            }
                            String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                            lineApi.addText(subdomainPrintText + "\n", TextStyle.getStyle().enableBold(true).enableUnderline(false).setTextSize((int) AidlUtil.Size.SIZE0));
                        }

                        lastItemWasMisc = productDetail.misc;
                        lastBlockId = productDetail.block_id;
                    }
                    printSeperatorImin3Max();
                }

                if (printTotalInPrint) {
                    if (structure.subtotal.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.subtotal.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.subtotal.size).intValue();
                        align = getAlignCommon(structure.subtotal.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        lineApi.addText(("SubTotal :") + MyApp.df.format(orderDetail.sub_total) + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    }

                    if (structure.gratuity.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.gratuity.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.gratuity.size).intValue();
                        align = getAlignCommon(structure.gratuity.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (orderDetail.gratuity > 0) {
                            lineApi.addText(("Gratuity :") + MyApp.df.format(orderDetail.gratuity) + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                    }

                    if (structure.discount.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.discount.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.discount.size).intValue();
                        align = getAlignCommon(structure.discount.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (orderDetail.discount > 0) {
                            lineApi.addText(("Discount :") + MyApp.df.format(orderDetail.discount) + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                    }

                    if (structure.delivery_charge.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.delivery_charge.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.delivery_charge.size).intValue();
                        align = getAlignCommon(structure.delivery_charge.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (orderDetail.delivery_charge > 0) {
                            lineApi.addText(("Delivery charge :") + MyApp.df.format(orderDetail.delivery_charge) + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                    }

                    if (structure.service_charge.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.service_charge.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.service_charge.size).intValue();
                        align = getAlignCommon(structure.service_charge.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (orderDetail.service_charge > 0) {
                            lineApi.addText(("Service charge :") + MyApp.df.format(orderDetail.service_charge) + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                    }

                    if (structure.grand_total.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.grand_total.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.grand_total.size).intValue();
                        align = getAlignCommon(structure.grand_total.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        lineApi.addText("Total : " + MyApp.df.format(orderDetail.total - voucherPaymentDoneAmount) + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    }

                    if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                            structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility) {
                        printSeperatorImin3Max();
                    }
                }
                if (structure.payment_detail_header != null)
                    if (structure.payment_detail_header.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.payment_detail_header.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.payment_detail_header.size).intValue();
                        align = getAlignCommon(structure.payment_detail_header.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        lineApi.addText("Payment Details: " + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    }

                if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                    if (structure.payment_detail != null) {
                        if (structure.payment_detail.visibility) {
                            Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.payment_detail.style);
                            isbold = boldUnderLine.first;
                            isUnderline = boldUnderLine.second;
                            size = getSizeCommon(structure.payment_detail.size).intValue();
                            align = getAlignCommon(structure.payment_detail.alignment);
                            for (OrderPayment orderPayment : orderDetail.order_payments) {
                                String paymentDetailToPrint = null;
                                if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                    paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                                } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                    paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else {
                                    paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                                }
                                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                                lineApi.addText(paymentDetailToPrint + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                            }
                            printSeperatorImin3Max();
                        } else
                            printSeperatorImin3Max();
                    } else {
                        printSeperatorImin3Max();
                    }
                }
                if (structure.serve_by.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.serve_by.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.serve_by.size).intValue();
                    align = getAlignCommon(structure.serve_by.alignment);
                    String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    lineApi.addText(toprint + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    printSeperatorImin3Max();
                }

                if (structure.customer_detail != null)
                    if (structure.customer_detail.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.customer_detail.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.customer_detail.size).intValue();
                        align = getAlignCommon(structure.customer_detail.alignment);
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                            lineApi.addText("Cust Name:" + orderDetail.customer_name + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }

                        if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                            lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                            lineApi.addText("Cust No:" + orderDetail.customer.mobile + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                        String fulladdress = null;
                        if (orderType == 3) {
                            fulladdress = "Address : " + orderDetail.customer.house_no + ","
                                    + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                    orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                            lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                            lineApi.addText(fulladdress + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress))
                            printSeperatorImin3Max();
                    }

                if (structure.payment_status != null)
                    if (structure.payment_status.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.payment_status.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.payment_status.size).intValue();
                        align = getAlignCommon(structure.payment_status.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                            lineApi.addText("Payment Status: " + settingMap.get("unpaid_payment_title") + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                            lineApi.addText("Payment Status: " + settingMap.get("paid_payment_title") + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                            lineApi.addText("Payment Status: " + settingMap.get("partial_payment_title") + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                        printSeperatorImin3Max();
                    }

                if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    lineApi.addText("Comment: " + orderDetail.comment + "\n", TextStyle.getStyle().enableBold(true).enableUnderline(false).setTextSize((int) (kitchenCopy ? AidlUtil.Size.SIZE1 : AidlUtil.Size.SIZE0)));
                    printSeperatorImin3Max();
                }

                if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    lineApi.addText("Requested Time" + orderDetail.delivery_collection_time_slot + "\n", TextStyle.getStyle().enableBold(true).enableUnderline(false).setTextSize((int) AidlUtil.Size.SIZE1));
                }
                if (structure.footer_order_type != null)
                    if (structure.footer_order_type.visibility && kitchenCopy) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_order_type.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.footer_order_type.size).intValue();
                        align = getAlignCommon(structure.footer_order_type.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                            lineApi.addText("** " + orderTypeHeading + " **" + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }

                    }
                // footer table number
                if (structure.footer_table_number != null)
                    if (structure.footer_table_number.visibility && kitchenCopy) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_table_number.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.footer_table_number.size).intValue();
                        align = getAlignCommon(structure.footer_table_number.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                            printSeperatorImin3Max();
                            lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }

                    }
                // footer order number
                if (structure.footer_order_number != null)
                    if (structure.footer_order_number.visibility && kitchenCopy) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_order_number.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.footer_order_number.size).intValue();
                        align = getAlignCommon(structure.footer_order_number.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            if (orderDetail._id != 0) {
                                lineApi.addText("Order No: " + orderDetail._id + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                            }
                        } else {
                            lineApi.addText("Order No: " + orderDetail.display_order_id + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                    }
                if (structure.header_customer_name != null)
                    if (structure.header_customer_name.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.header_customer_name.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.header_customer_name.size).intValue();
                        align = getAlignCommon(structure.header_customer_name.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            lineApi.addText(orderDetail.customer_name + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                    }

                if (structure.receipt_time != null && structure.receipt_time.visibility && !Validators.isNullOrEmpty(receiptDate)) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.receipt_time.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.receipt_time.size).intValue();
                    align = getAlignCommon(structure.receipt_time.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    lineApi.addText("Receipt Date :" + receiptDate + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                }

                if (structure.footer != null)
                    if (structure.footer.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.footer.size).intValue();
                        align = getAlignCommon(structure.footer.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        if (!Validators.isNullOrEmpty(footerA)) {
                            lineApi.addText(footerA + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                        if (!Validators.isNullOrEmpty(footerB)) {
                            lineApi.addText(footerB + "\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                        }
                    }

                if (!kitchenCopy && MyApp.getInstance().paymentLinkBitmap != null) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    lineApi.addText("\n\n", TextStyle.getStyle().enableBold(isbold).enableUnderline(isUnderline).setTextSize(size));
                    //AidlUtil.getInstance().printBitmap(MyApp.getInstance().paymentLinkBitmap);
                }
                // set print true for local device
                setPrint(myPreferences, true);
                lineApi.addText(" \n \n ", new TextStyle());
                lineApi.autoOut();
            } catch (Exception e) {
                LogUtils.e("PRINT::", Log.getStackTraceString(e));
                System.out.println(e);
            }
        }
    }

    DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);

    public void printSeparator() {
        printSeperatorImin3Max();
    }

    public void printOrderEposFoodHubSeqeunce(ArrayList<PrintStyle> listPrintStructure, Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, MyPreferences myPreferences, float voucherPaymentDoneAmount) {
        int style = 0, alignment = 0;
        Align align;
        float size = 0;
        boolean isbold = false, isUnderline = false;
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }
        try {
            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (orderDetail.updated_at.contains("Z")) {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                } else {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                }
            }
            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                boolean priceInItems = listPrintStructure.get(i).price;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean isBlockName = listPrintStructure.get(i).block_name;
                Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(listPrintStructure.get(i).style);
                isbold = boldUnderLine.first;
                isUnderline = boldUnderLine.second;
                size = getSizeCommon(listPrintStructure.get(i).size).intValue();
                align = getAlignCommon(listPrintStructure.get(i).alignment);
                boolean isSeparator = listPrintStructure.get(i).separator;
                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                switch (key) {
                    case "logo": {
                        if (!kitchenCopy && tiffintomLogo != null) {
                            lineApi.printBitmap(tiffintomLogo, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "ticket_header": {
                        if (!Validators.isNullOrEmpty(ticket_header))
                            if (!kitchenCopy) {
                                printTextHeader(headerAlignment, ticket_header);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        break;
                    }
                    case "header_order_type":
                    case "footer_order_type": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                                lineApi.addText(orderTypeHeading.toUpperCase() + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer_table_number": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                                lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer_order_number": {
                        if (kitchenCopy) {
                            if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                                if (orderDetail._id != 0) {
                                    lineApi.addText("Order No: " + orderDetail._id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                    if (isSeparator) {
                                        printSeparator();
                                    }
                                }
                            } else {
                                lineApi.addText("Order No: " + orderDetail.display_order_id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "header_customer_name": {
                        if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            lineApi.addText(orderDetail.customer_name + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "title": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(title)) {
                                lineApi.addText(title + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "order_no": {
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            if (orderDetail._id > 0)
                                lineApi.addText("" + orderDetail._id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        } else {
                            lineApi.addText("" + orderDetail.display_order_id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "table_no": {
                        if (orderType == 1) {
                            lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (!structure.no_of_diners.visibility) {
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "no_of_diners": {
                        if (orderType == 1) {
                            lineApi.addText("   No of Diner: " + orderDetail.no_guest + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_date": {
                        if (!Validators.isNullOrEmpty(orderDate))
                            if (structure.order_time != null && structure.order_time.visibility) {
                                lineApi.addText("Date :" + orderDate + " " + "", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            } else {
                                lineApi.addText("Date :" + orderDate + " " + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        break;
                    }
                    case "order_time": {
                        if (!Validators.isNullOrEmpty(orderTime)) {
                            lineApi.addText("Time :" + orderTime + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "receipt_time": {
                        if (!Validators.isNullOrEmpty(receiptDate)) {
                            lineApi.addText("Receipt Date :" + receiptDate + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_type": {
                        if (orderType > 1) {
                            if (!Validators.isNullOrEmpty(orderDetail.order_type)) {
                                lineApi.addText("Order Type: " + orderDetail.order_type + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "items_header": {
                        lineApi.addText("Qty Name" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "items": {
                        String itemName = "", price = "", qty = "";
                        String lastBlockId = null;
                        boolean lastItemWasMisc = false;
                        int position = 0;
                        for (OrderItem productDetail : orderDetail.order_items) {
                            Pair<Boolean, Boolean> items = getUnderLineBoldCommon(structure.items.style);
                            isbold = items.first;
                            isUnderline = items.second;
                            size = getSizeCommon(structure.items.size).intValue();
                            align = getAlignCommon(structure.items.alignment);
                            lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                            position = position + 1;
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                            String productQty;
                            if (kitchenCopy) {
                                productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                            } else {
                                productQty = String.valueOf(productDetail.quantity);
                            }
                            price = (priceInItems) ? MyApp.df.format(productDetail.total) : "";
                            itemName = getProductNameWithPad(productName, price, 28);
                            qty = productQty;
                            if (productQty.length() <= 1) {
                                qty = " " + productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }

                            if (!all_separator) {
                                if (lastBlockId != null) {
                                    if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                        if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                            printBlockText(productDetail,isBlockName);
                                    }
                                } else {
                                    if (lastItemWasMisc && !productDetail.misc) {
                                        if (kitchenCopy)
                                            printBlockText(productDetail,isBlockName);
                                    }
                                }
                            }


                            String printItem;
                            printItem = qty + itemName.trim();
                            // if size 0 or 1 format product name
                            if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                                String finalPrice = "  " + price;
                                itemName = calculteNumberOfLines(productName, finalPrice, size, qty);
                                printItem = itemName;
                            }
                            lineApi.addText(printItem + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                lineApi.addText("   Instruction: " + productDetail.special_instruction + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline).setAlign(Align.LEFT));

                            if (productDetail.order_item_addons.size() > 0) {
                                Pair<Boolean, Boolean> itemsSubaddon = getUnderLineBoldCommon(structure.items_subaddon.style);
                                isbold = itemsSubaddon.first;
                                isUnderline = itemsSubaddon.second;
                                size = getSizeCommon(structure.items_subaddon.size).intValue();
                                align = getAlignCommon(structure.items_subaddon.alignment);
                                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                                if (structure.items_subaddon.visibility) {
                                    lineApi.addText("Choose Your Base:" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                }
                                for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                    List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                    if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                        continue;
                                    }
                                    productQty = orderItemAddon.quantity + "";
                                    productName = orderItemAddon.addon_name + "";
                                    price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                                    if (kitchenCopy)
                                        itemName = getProductNameWithPad(productName, price, 25);
                                    else
                                        itemName = getProductNameWithPad(productName, price, 28);
                                    qty = productQty;
                                    //printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? itemName.trim() : qty + itemName.trim();
                                    // adding qty when total or price is zero as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                    if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                                        if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                            if (orderItemAddon.quantity > 1) {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "  - " + orderItemAddon.quantity + "x");
                                            } else {
                                                if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                    printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "");
                                                } else {
                                                    printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "  -   ");
                                                }
                                            }
                                        } else {
                                            if (orderItemAddon.quantity > 1) {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), size, "  - " + orderItemAddon.addon_name + "x");
                                            } else {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), size, "  -   ");
                                            }
                                        }
                                        lineApi.addText(printItem + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                    } else {
                                        if (orderItemAddon.quantity > 1) {
                                            //printItem = qty + itemName.trim();
                                            printItem = "- " + qty + "x " + itemName.trim();
                                        } else {
                                            if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                printItem = "" + itemName.trim();
                                            } else {
                                                printItem = "- 1x " + itemName.trim();
                                            }
                                        }
                                        lineApi.addText(printItem + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                    }
                                }
                            }

                            for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                                String ingredientName = orderItemIngredient.ingredient_name;
                                if (orderItemIngredient.with) {
                                    ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                                }
                                if (orderItemIngredient.without) {
                                    ingredientName = "No " + ingredientName;
                                }
                                String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                                lineApi.addText(subdomainPrintText + "\n", TextStyle.getStyle().setTextSize(30).enableBold(true).enableUnderline(false));
                            }

                            lastItemWasMisc = productDetail.misc;
                            lastBlockId = productDetail.block_id;

                            if (all_separator && orderDetail.order_items.size() > position) {
                                printSeperatorImin3Max();
                            }
                            if (!all_separator && isBlockName) {
                                lineApi.addText("\n", TextStyle.getStyle().enableBold(false).enableUnderline(false));
                            }
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "subtotal":
                    case "gratuity":
                    case "delivery_charge":
                    case "service_charge":
                    case "grand_total":
                    case "discount": {
                        if (printTotalInPrint) {
                            String formattedValue = "";
                            String titleOfTotal = "";
                            if (key.equalsIgnoreCase("gratuity")) {
                                if (orderDetail.gratuity > 0) {
                                    formattedValue = MyApp.df.format(orderDetail.gratuity);
                                }
                                titleOfTotal = "GRATUITY";
                            } else if (key.equalsIgnoreCase("discount")) {
                                if (orderDetail.discount > 0)
                                    formattedValue = MyApp.df.format(orderDetail.discount);
                                titleOfTotal = "DISCOUNT";
                            } else if (key.equalsIgnoreCase("grand_total")) {
                                if (orderDetail.total > 0) {
                                    formattedValue = MyApp.df.format(orderDetail.total - voucherPaymentDoneAmount);
                                }
                                titleOfTotal = "TOTAL";
                            } else if (key.equalsIgnoreCase("service_charge")) {
                                if (orderDetail.service_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.service_charge);
                                titleOfTotal = "SERVICE CHARGE";
                            } else if (key.equalsIgnoreCase("delivery_charge")) {
                                if (orderDetail.delivery_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.delivery_charge);
                                titleOfTotal = "DELIVERY CHARGE";
                            } else if (key.equalsIgnoreCase("subtotal")) {
                                formattedValue = MyApp.df.format(orderDetail.sub_total);
                                titleOfTotal = "SUB TOTAL";
                            }
                            if (!Validators.isNullOrEmpty(formattedValue)) {
                                int length = formattedValue.length();
                                String price = null;
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        price = "    " + formattedValue;
                                    }
                                    if (length == 5) {
                                        price = "   " + formattedValue;
                                    }

                                    if (length == 6) {
                                        price = "  " + formattedValue;
                                    }
                                    if (length == 7) {
                                        price = " " + formattedValue;
                                    }
                                } else {
                                    price = formatter.format(orderDetail.sub_total);
                                }
                                String finalTitleToPrint = "";
                                finalTitleToPrint = formatTotal(size, titleOfTotal, price);
                                lineApi.addText(finalTitleToPrint + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            }
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_detail_header": {
                        lineApi.addText("Payment Details: " + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        break;
                    }
                    case "payment_detail": {
                        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                            for (OrderPayment orderPayment : orderDetail.order_payments) {
                                String paymentDetailToPrint = null;
                                if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                    paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                                } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                    paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else {
                                    paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                                }
                                lineApi.addText(paymentDetailToPrint + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            }
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "serve_by": {
                        String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                        lineApi.addText(toprint + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "customer_detail": {
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            lineApi.addText("" + orderDetail.customer_name + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        String fulladdress = null;
                        if (orderType == 3) {
                            fulladdress = formatAddress(orderDetail);
                            lineApi.addText(fulladdress + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                            lineApi.addText("" + orderDetail.customer.mobile + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)) {
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_status": {
                        if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                            lineApi.addText("" + settingMap.get("unpaid_payment_title").toUpperCase() + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                            lineApi.addText("" + settingMap.get("paid_payment_title").toUpperCase() + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                            lineApi.addText("" + settingMap.get("partial_payment_title").toUpperCase() + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "footer": {
                        if (!Validators.isNullOrEmpty(footerA)) {
                            lineApi.addText(footerA + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (!Validators.isNullOrEmpty(footerB)) {
                            lineApi.addText(footerB + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                lineApi.addText("Comment: " + orderDetail.comment + "\n", TextStyle.getStyle().setTextSize((int) (kitchenCopy ? AidlUtil.Size.SIZE1 : AidlUtil.Size.SIZE0)).enableBold(false).enableUnderline(false));
                printSeperatorImin3Max();
            }
            if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                lineApi.addText("Requested Time" + orderDetail.delivery_collection_time_slot + "\n", TextStyle.getStyle().setTextSize((int) AidlUtil.Size.SIZE1).enableBold(true).enableUnderline(false));
            }
            if (!kitchenCopy && MyApp.getInstance().paymentLinkBitmap != null) {
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                lineApi.addText("\n\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                lineApi.printBitmap(MyApp.getInstance().paymentLinkBitmap, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
            }
            // set print true for local device
            setPrint(myPreferences, true);
            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    private String calculteNumberOfLines(String productName, String price, float size, String qty) {
        String[] productNameSplit = productName.split(" ");
        String finalPrice = "  " + price;
        String secondLine = qty;
        int lengthForSize = size == AidlUtil.Size.SIZE0 ? 38 : 28;
        if (size == AidlUtil.Size.SIZE0) {
            lengthForSize = 38;
        } else if (size == AidlUtil.Size.SIZE1) {
            lengthForSize = 28;
        } else {
            lengthForSize = 22;
        }
        int multiplyLength = 1;
        int index = 0;
        for (String s : productNameSplit) {
            index = index + 1;
            Log.e("finalPrice", "finalPrice " + finalPrice + "string to apend " + s.length());
            if (secondLine.length() < (multiplyLength * lengthForSize)) {
                if ((secondLine + " " + s + finalPrice).length() > (multiplyLength * lengthForSize)) {
                    //secondLine = secondLine+secondLine.replace(,"");
                    int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                    if (multiplyLength == 1) {
                        emptySpaceLength = emptySpaceLength - finalPrice.length();
                        for (int space = 0; space < emptySpaceLength; space++) {
                            secondLine = secondLine + (" ");
                        }
                        secondLine = secondLine + finalPrice;
                    } else {
                        for (int space = 0; space < emptySpaceLength; space++) {
                            secondLine = secondLine + (" ");
                        }
                    }
                    multiplyLength = multiplyLength + 1;
                    secondLine = secondLine + ("\n");
                    for (int j = 0; j < qty.length(); j++) {
                        secondLine = secondLine + (" ");
                    }
                }
            } else {
                multiplyLength = multiplyLength + 1;
                secondLine = secondLine + ("\n");
                for (int j = 0; j < qty.length(); j++) {
                    secondLine = secondLine + (" ");
                }
            }
            secondLine = secondLine + " " + s;
            if (productNameSplit.length == index && multiplyLength == 1 && secondLine.length() < (multiplyLength * lengthForSize)) {
                if (multiplyLength == 1) {
                    int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                    emptySpaceLength = emptySpaceLength - finalPrice.length();
                    for (int space = 0; space < emptySpaceLength; space++) {
                        secondLine = secondLine + (" ");
                    }
                    secondLine = secondLine + finalPrice;
                }
            }
        }
        return secondLine;
    }

    private void printBlockText(OrderItem productDetail,boolean isBlockName){
        try {
            if(Validators.isNullOrEmpty(productDetail.block_name) || !isBlockName){
                lineApi.addText("-------------------------------------" + "\n", TextStyle.getStyle().enableBold(false).enableUnderline(false).setAlign(Align.CENTER));
            }else {
                lineApi.addText(myApp.getBlockText(37,productDetail.block_name)+"\n", TextStyle.getStyle().enableBold(true).enableUnderline(false).setAlign(Align.CENTER));
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private String formatAddress(Order orderDetail) {
        String fulladdress = null;
        if (Validators.isNullOrEmpty(orderDetail.customer.house_no)) {
            fulladdress = orderDetail.customer.street + "\n";
        } else {
            fulladdress = "" + orderDetail.customer.house_no + " " + orderDetail.customer.street + "\n";
        }
        if (!Validators.isNullOrEmpty(orderDetail.customer.city)) {
            fulladdress = fulladdress + "" + orderDetail.customer.city;

            if (!Validators.isNullOrEmpty(orderDetail.customer.postcode)) {
                fulladdress = fulladdress + " " + orderDetail.customer.postcode;
            }
        }
        return fulladdress;
    }

    private Pair<Boolean, Boolean> getUnderLineBoldCommon(String underLineBold) {
        boolean isbold, isUnderline;
        switch (underLineBold) {
            case "bold":
                isbold = true;
                isUnderline = false;
                break;
            case "underline":
                isbold = false;
                isUnderline = true;
                break;
            default:
                isbold = false;
                isUnderline = false;
                break;
        }
        return new Pair(isbold, isUnderline);
    }

    private Align getAlignCommon(String alignment) {
        Align align;
        switch (alignment) {
            case "center":
                align = Align.CENTER;
                break;
            case "right":
                align = Align.RIGHT;
                break;
            default:
                align = Align.LEFT;
                break;
        }
        return align;
    }

    private Float getSizeCommon(String sizeForCompare) {
        float size;
        switch (sizeForCompare) {
            case "size1":
                size = AidlUtil.Size.SIZE1;
                break;
            case "size2":
                size = AidlUtil.Size.SIZE2;
                break;
            case "size3":
                size = AidlUtil.Size.SIZE3;
                break;
            case "size4":
                size = AidlUtil.Size.SIZE4;
                break;
            case "size5":
                size = AidlUtil.Size.SIZE5;
                break;
            default:
                size = AidlUtil.Size.SIZE0;
                break;
        }
        return size;
    }

    public void printOrderEposNew(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, PrintStructure structure, boolean printTotalInPrint, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        try {
            int style = 0, alignment = 0;
            float size = 0;
            boolean isbold = false, isUnderline = false;
            Align align;
            int orderType = -1;
            if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
                orderType = 0;
            } else {
                orderType = Integer.parseInt(orderDetail.order_type_id);
            }

            if (!kitchenCopy && tiffintomLogo != null) {
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
                lineApi.printBitmap(tiffintomLogo, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
            }
            if (!kitchenCopy) {
                printTextHeader(headerAlignment, ticket_header);
            }
            if (kitchenCopy) {
                if (structure.header_order_type.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.header_order_type.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.header_order_type.size);
                    align = getAlignCommon(structure.header_order_type.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderTypeHeading))
                        lineApi.addText("** " + orderTypeHeading + " **" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));

                }
                // footer table number
                if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_table_number.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.footer_table_number.size);
                    align = getAlignCommon(structure.footer_table_number.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                        printSeperatorImin3Max();
                        lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                }
                // footer order number
                if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_order_number.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.footer_order_number.size);
                    align = getAlignCommon(structure.footer_order_number.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        if (orderDetail._id != 0) {
                            lineApi.addText("Order No: " + orderDetail._id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                    } else {
                        lineApi.addText("Order No: " + orderDetail.display_order_id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                }
                if (structure.header_customer_name.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.header_customer_name.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.header_customer_name.size);
                    align = getAlignCommon(structure.header_customer_name.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        lineApi.addText(orderDetail.customer_name + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                }
                printSeperatorImin3Max();

                if (structure.title.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.title.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.title.size);
                    align = getAlignCommon(structure.title.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(title)) {
                        lineApi.addText(title + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        printSeperatorImin3Max();
                    }
                }

            }

            if (structure.order_no != null) {
                if (structure.order_no.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.order_no.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.order_no.size);
                    align = getAlignCommon(structure.order_no.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    String orderIdText = null;
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        orderIdText = "Order ID: " + orderDetail._id;
                    } else
                        orderIdText = "Order ID: " + orderDetail.display_order_id;

                    lineApi.addText(orderIdText + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));

                    if (kitchenCopy)
                        printSeperatorImin3Max();
                }
            } else {
                if (tableNumberOrderIdMode != null) {
                    String tableNumberOrderIdText = "";
                    if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                        } else
                            tableNumberOrderIdText = "Order ID: " + orderDetail.display_order_id;
                    }
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    lineApi.addText(tableNumberOrderIdText + "\n", TextStyle.getStyle().setTextSize((int) AidlUtil.Size.SIZE0).enableBold(false).enableUnderline(false));
                }
            }

            if (structure.table_no != null && structure.no_of_diners != null) {
                if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.table_no.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.table_no.size);
                    align = getAlignCommon(structure.table_no.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));

                    Pair<Boolean, Boolean> no_of_diners = getUnderLineBoldCommon(structure.no_of_diners.style);
                    isbold = no_of_diners.first;
                    isUnderline = no_of_diners.second;
                    size = getSizeCommon(structure.no_of_diners.size);
                    align = getAlignCommon(structure.no_of_diners.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    lineApi.addText("   No of Diner: " + orderDetail.no_guest + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    printSeperatorImin3Max();
                }
            } else {
                if (tableNumberOrderIdMode != null) {
                    String tableNumberOrderIdText = "";
                    if (orderType == 1 && (tableNumberOrderIdMode.equalsIgnoreCase("table_number") || tableNumberOrderIdMode.equalsIgnoreCase("both"))) {
                        if (tableNumberOrderIdText.length() > 1) {
                            tableNumberOrderIdText = tableNumberOrderIdText + "\n";
                        }
                        tableNumberOrderIdText = tableNumberOrderIdText + "Table No: " + orderDetail.table_number + "  No of Diners:  " + orderDetail.no_guest;

                    }
                    if (tableNumberOrderIdMode.equalsIgnoreCase("none")) {
                        tableNumberOrderIdText = "";
                    }
                    if (tableNumberOrderIdText.length() > 0) {
                        if (!Validators.isNullOrEmpty(title))
                            printSeperatorImin3Max();
                        lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                        lineApi.addText(tableNumberOrderIdText + "\n", TextStyle.getStyle().setTextSize((int) AidlUtil.Size.SIZE0).enableBold(false).enableUnderline(false));
                        printSeperatorImin3Max();
                    }
                }
            }

            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (orderDetail.updated_at.contains("Z")) {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                } else {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                }
            }

            if (structure.order_date != null) {
                if (structure.order_date.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.order_date.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.order_date.size);
                    align = getAlignCommon(structure.order_date.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderDate))
                        if (structure.order_time != null && structure.order_time.visibility) {
                            lineApi.addText("Date " + orderDate + " " + "", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        } else {
                            lineApi.addText("Date :" + orderDate + " " + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            printSeperatorImin3Max();
                        }
                }

            }
            if (structure.order_time != null) {
                if (structure.order_time.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.order_time.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.order_time.size);
                    align = getAlignCommon(structure.order_time.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderTime)) {
                        lineApi.addText("Time :" + orderTime + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        printSeperatorImin3Max();
                    }
                }
            }

            if (orderType > 1 && !kitchenCopy) {
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                lineApi.addText("Order Type: " + orderDetail.order_type + "\n", TextStyle.getStyle().setTextSize((int) 32).enableBold(false).enableUnderline(false));
                printSeperatorImin3Max();
            }
            if (structure.items_header != null) {
                if (structure.items_header.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.items_header.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.items_header.size);
                    align = getAlignCommon(structure.items_header.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    lineApi.addText("Qty Name" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                }
            } else {
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                lineApi.addText("Qty Name" + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
            }
            if (structure.items.visibility) {
                Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.items.style);
                isbold = boldUnderLine.first;
                isUnderline = boldUnderLine.second;
                size = getSizeCommon(structure.items.size);
                align = getAlignCommon(structure.items.alignment);
                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                String itemName = "", price = "", qty = "";

                String lastBlockId = null;
                boolean lastItemWasMisc = false;
                for (OrderItem productDetail : orderDetail.order_items) {
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                    String productQty = String.valueOf(productDetail.quantity);
                    // Here we need 16 characters in product name so we send 16 in
                    // @params charactersInLine
                    price = (!kitchenCopy) ? MyApp.df.format(productDetail.total) : "";
                    if (kitchenCopy)
                        itemName = getProductNameWithPad(productName, price, 25);
                    else
                        itemName = getProductNameWithPad(productName, price, 28);
                    qty = productQty;
                    if (productQty.length() <= 1) {
                        qty = " " + productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }
                    if (lastBlockId != null) {
                        if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                            if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                printSeperatorImin3Max();
                        }
                    } else {
                        if (lastItemWasMisc && !productDetail.misc) {
                            if (kitchenCopy)
                                printSeperatorImin3Max();
                        }
                    }

                    String printItem;
                    printItem = qty + itemName.trim();
                    if (!kitchenCopy) {
                        lineApi.addText(printItem, TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                            lineApi.addText("   Instruction: " + productDetail.special_instruction + "\n", TextStyle.getStyle().setTextSize(30).enableBold(true).enableUnderline(false).setAlign(Align.LEFT));
                    } else {
                        lineApi.addText(printItem + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                            lineApi.addText("   Instruction: " + productDetail.special_instruction + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false).setAlign(Align.LEFT));
                    }
                    if (productDetail.order_item_addons.size() > 0) {
                        if (structure.items_subaddon.visibility) {
                            Pair<Boolean, Boolean> items_header = getUnderLineBoldCommon(structure.items_header.style);
                            isbold = items_header.first;
                            isUnderline = items_header.second;
                            size = getSizeCommon(structure.items_header.size);
                            align = getAlignCommon(structure.items_header.alignment);
                            lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                            lineApi.addText("Choose Your Base:" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }

                        for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                            List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                            if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                continue;
                            }
                            productQty = orderItemAddon.quantity + "";
                            productName = orderItemAddon.addon_name + "";
                            price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                            if (kitchenCopy)
                                itemName = getProductNameWithPad(productName, price, 25);
                            else
                                itemName = getProductNameWithPad(productName, price, 28);
                            qty = productQty;
                            if (productQty.length() <= 1) {
                                qty = " " + productQty + " ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + " ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + " ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "";
                            }
                            printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? itemName.trim() : qty + itemName.trim();
                            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                            lineApi.addText(printItem + "\n", TextStyle.getStyle().setTextSize(30).enableBold(true).enableUnderline(false));
                        }
                    }

                    for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                        String ingredientName = orderItemIngredient.ingredient_name;
                        if (orderItemIngredient.with) {
                            ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                        }
                        if (orderItemIngredient.without) {
                            ingredientName = "No " + ingredientName;
                        }
                        String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                        lineApi.addText(subdomainPrintText + "\n", TextStyle.getStyle().setTextSize(30).enableBold(true).enableUnderline(false));
                    }

                    lastItemWasMisc = productDetail.misc;
                    lastBlockId = productDetail.block_id;
                }
                printSeperatorImin3Max();
            }

            if (printTotalInPrint) {
                if (structure.subtotal.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.subtotal.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.subtotal.size);
                    align = getAlignCommon(structure.subtotal.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    lineApi.addText(("SubTotal :") + MyApp.df.format(orderDetail.sub_total) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                }

                if (structure.gratuity.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.gratuity.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.gratuity.size);
                    align = getAlignCommon(structure.gratuity.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (orderDetail.gratuity > 0) {
                        lineApi.addText(("Gratuity :") + MyApp.df.format(orderDetail.gratuity) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                }

                if (structure.discount.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.discount.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.discount.size);
                    align = getAlignCommon(structure.discount.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (orderDetail.discount > 0) {
                        lineApi.addText(("Discount :") + MyApp.df.format(orderDetail.discount) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                }

                if (structure.service_charge.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.service_charge.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.service_charge.size);
                    align = getAlignCommon(structure.service_charge.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (orderDetail.service_charge > 0) {
                        lineApi.addText(("Service charge :") + MyApp.df.format(orderDetail.service_charge) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                }
                if (structure.discount.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.discount.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.discount.size);
                    align = getAlignCommon(structure.discount.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (orderDetail.discount > 0) {
                        lineApi.addText(("Discount :") + MyApp.df.format(orderDetail.discount) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                }

                if (structure.grand_total.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.grand_total.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.grand_total.size);
                    align = getAlignCommon(structure.grand_total.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    lineApi.addText("Total : " + MyApp.df.format(orderDetail.total) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                }
                if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                        structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility) {
                    printSeperatorImin3Max();
                }
            }

            if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                if (structure.payment_detail_header != null)
                    if (structure.payment_detail_header.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.payment_detail_header.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.payment_detail_header.size);
                        align = getAlignCommon(structure.payment_detail_header.alignment);
                        lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                        lineApi.addText("Payment Details: " + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }

                if (structure.payment_detail != null) {
                    if (structure.payment_detail.visibility) {
                        Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.payment_detail.style);
                        isbold = boldUnderLine.first;
                        isUnderline = boldUnderLine.second;
                        size = getSizeCommon(structure.payment_detail.size);
                        align = getAlignCommon(structure.payment_detail.alignment);
                        for (OrderPayment orderPayment : orderDetail.order_payments) {
                            String paymentDetailToPrint = null;
                            if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                            } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                            } else {
                                paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                            }
                            lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                            lineApi.addText(paymentDetailToPrint + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        printSeperatorImin3Max();
                    } else
                        printSeperatorImin3Max();
                } else {
                    printSeperatorImin3Max();
                }
            }

            if (structure.serve_by.visibility) {
                Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.serve_by.style);
                isbold = boldUnderLine.first;
                isUnderline = boldUnderLine.second;
                size = getSizeCommon(structure.serve_by.size);
                align = getAlignCommon(structure.serve_by.alignment);
                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                lineApi.addText(toprint + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                printSeperatorImin3Max();
            }
            if (structure.customer_detail != null)
                if (structure.customer_detail.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.customer_detail.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.customer_detail.size);
                    align = getAlignCommon(structure.customer_detail.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        lineApi.addText("Cust Name:" + orderDetail.customer_name + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }

                    if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                        lineApi.addText("Cust No:" + orderDetail.customer.mobile + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                    String fulladdress = null;
                    if (orderType == 3) {
                        fulladdress = "Address : " + orderDetail.customer.house_no + ","
                                + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                        lineApi.addText(fulladdress + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress))
                        printSeperatorImin3Max();
                }


            if (structure.payment_status != null)
                if (structure.payment_status.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.payment_status.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.payment_status.size);
                    align = getAlignCommon(structure.payment_status.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                        lineApi.addText("Payment Status: " + settingMap.get("unpaid_payment_title") + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                        lineApi.addText("Payment Status: " + settingMap.get("paid_payment_title") + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                        lineApi.addText("Payment Status: " + settingMap.get("partial_payment_title") + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                    printSeperatorImin3Max();
                }

            if (structure.order_comment != null) {
                if (structure.order_comment.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.order_comment.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.order_comment.size);
                    align = getAlignCommon(structure.order_comment.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                        lineApi.addText("Comment: " + orderDetail.comment + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        printSeperatorImin3Max();
                    }
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                lineApi.addText("Requested Time" + orderDetail.delivery_collection_time_slot + "\n", TextStyle.getStyle().setTextSize(40).enableBold(isbold).enableUnderline(isUnderline));
            }
            if (structure.footer_order_type != null)
                if (structure.footer_order_type.visibility && kitchenCopy) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_order_type.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.footer_order_type.size);
                    align = getAlignCommon(structure.footer_order_type.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                        lineApi.addText("** " + orderTypeHeading + " **" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }

                }
            // footer table number
            if (structure.footer_table_number != null)
                if (structure.footer_table_number.visibility && kitchenCopy) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_table_number.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.footer_table_number.size);
                    align = getAlignCommon(structure.footer_table_number.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                        printSeperatorImin3Max();
                        lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }

                }
            // footer order number
            if (structure.footer_order_number != null)
                if (structure.footer_order_number.visibility && kitchenCopy) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer_order_number.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.footer_order_number.size);
                    align = getAlignCommon(structure.footer_order_number.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        if (orderDetail._id != 0) {
                            lineApi.addText("Order No: " + orderDetail._id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                    } else {
                        lineApi.addText("Order No: " + orderDetail.display_order_id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }

                }
            if (structure.header_customer_name != null)
                if (structure.header_customer_name.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.header_customer_name.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.header_customer_name.size);
                    align = getAlignCommon(structure.header_customer_name.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        lineApi.addText(orderDetail.customer_name + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                }

            if (structure.receipt_time != null && structure.receipt_time.visibility && !Validators.isNullOrEmpty(receiptDate)) {
                Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.receipt_time.style);
                isbold = boldUnderLine.first;
                isUnderline = boldUnderLine.second;
                size = getSizeCommon(structure.receipt_time.size);
                align = getAlignCommon(structure.receipt_time.alignment);
                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                lineApi.addText("Receipt Date :" + receiptDate + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
            }
            if (structure.footer != null)
                if (structure.footer.visibility) {
                    Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(structure.footer.style);
                    isbold = boldUnderLine.first;
                    isUnderline = boldUnderLine.second;
                    size = getSizeCommon(structure.footer.size);
                    align = getAlignCommon(structure.footer.alignment);
                    lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                    if (!Validators.isNullOrEmpty(footerA)) {
                        lineApi.addText(footerA + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                    if (!Validators.isNullOrEmpty(footerB)) {
                        lineApi.addText(footerB + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                    }
                }

            // set print true for local device
            setPrint(myPreferences, true);
            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printOrderEposNewFoodHub(ArrayList<PrintStyle> listPrintStructure, Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, PrintStructure structure, boolean printTotalInPrint, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        try {
            int style = 0, alignment = 0;
            Align align;
            float size = 0;
            boolean isbold = false, isUnderline = false;

            int orderType = -1;
            if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
                orderType = 0;
            } else {
                orderType = Integer.parseInt(orderDetail.order_type_id);
            }
            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (orderDetail.updated_at.contains("Z")) {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                } else {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                }
            }
            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                boolean priceInItems = listPrintStructure.get(i).price;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean isBlockName = listPrintStructure.get(i).block_name;
                Pair<Boolean, Boolean> boldUnderLine = getUnderLineBoldCommon(listPrintStructure.get(i).style);
                isbold = boldUnderLine.first;
                isUnderline = boldUnderLine.second;
                size = getSizeCommon(listPrintStructure.get(i).size);
                align = getAlignCommon(listPrintStructure.get(i).alignment);
                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                boolean isSeparator = listPrintStructure.get(i).separator;
                switch (key) {
                    case "logo": {
                        if (!kitchenCopy && tiffintomLogo != null) {
                            lineApi.printBitmap(tiffintomLogo, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "ticket_header": {
                        if (!Validators.isNullOrEmpty(ticket_header)) {
                            if (!kitchenCopy) {
                                printTextHeader(headerAlignment, ticket_header);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "header_order_type": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                                lineApi.addText("" + orderTypeHeading.toUpperCase() + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            }
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "title": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(title)) {
                                lineApi.addText(title + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                printSeparator();
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer_table_number": {
                        if (kitchenCopy) {
                            if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                                printSeparator();
                                lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer_order_number": {
                        if (kitchenCopy) {
                            if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                                if (orderDetail._id != 0) {
                                    lineApi.addText("Order No: " + orderDetail._id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                    if (isSeparator) {
                                        printSeparator();
                                    }
                                }
                            } else {
                                lineApi.addText("Order No: " + orderDetail.display_order_id + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "header_customer_name": {
                        if (kitchenCopy) {
                            if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                                lineApi.addText(orderDetail.customer_name + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "order_no": {
                        String orderIdText = null;
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            orderIdText = "" + orderDetail._id;
                        } else
                            orderIdText = "" + orderDetail.display_order_id;

                        lineApi.addText(orderIdText + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));

                        if (kitchenCopy) {
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "table_no": {
                        if (orderType == 1) {
                            lineApi.addText("Table No: " + orderDetail.table_number + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (!structure.no_of_diners.visibility) {
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "no_of_diners": {
                        if (orderType == 1) {
                            lineApi.addText("   No of Diner: " + orderDetail.no_guest + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_date": {
                        if (!Validators.isNullOrEmpty(orderDate))
                            if (structure.order_time != null && structure.order_time.visibility) {
                                lineApi.addText("Date :" + orderDate + " " + "", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            } else {
                                lineApi.addText("Date :" + orderDate + " " + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        break;
                    }
                    case "order_time": {
                        if (!Validators.isNullOrEmpty(orderTime)) {
                            lineApi.addText("Time :" + orderTime + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "receipt_time": {
                        if (!Validators.isNullOrEmpty(receiptDate)) {
                            lineApi.addText("Receipt Date :" + receiptDate + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_type": {
                        if (orderType > 1) {
                            if (!Validators.isNullOrEmpty(orderDetail.order_type)) {
                                lineApi.addText("Order Type: " + orderDetail.order_type + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "items_header": {
                        lineApi.addText("Qty Name" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "items": {
                        String itemName = "", price = "", qty = "";
                        String lastBlockId = null;
                        boolean lastItemWasMisc = false;
                        int position = 0;
                        for (OrderItem productDetail : orderDetail.order_items) {
                            Pair<Boolean, Boolean> boldUnderLineItems = getUnderLineBoldCommon(structure.items.style);
                            isbold = boldUnderLineItems.first;
                            isUnderline = boldUnderLineItems.second;
                            size = getSizeCommon(structure.items.size);
                            align = getAlignCommon(structure.items.alignment);
                            lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                            position = position + 1;
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                            String productQty;
                            if (kitchenCopy) {
                                productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                            } else {
                                productQty = String.valueOf(productDetail.quantity);
                            }
                            // Here we need 16 characters in product name so we send 16 in
                            // @params charactersInLine
                            price = (priceInItems) ? MyApp.df.format(productDetail.total) : "";
                            itemName = getProductNameWithPad(productName, price, 28);
                            qty = productQty;
                            if (productQty.length() <= 1) {
                                qty = " " + productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }

                            if (!all_separator) {
                                if (lastBlockId != null) {
                                    if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                        if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                            printBlockText(productDetail,isBlockName);
                                    }
                                } else {
                                    if (lastItemWasMisc && !productDetail.misc) {
                                        if (kitchenCopy)
                                            printBlockText(productDetail,isBlockName);
                                    }
                                }
                            }
                            String printItem;
                            printItem = qty + itemName.trim();
                            // if size 0 or 1 format product name
                            if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                                String finalPrice = "  " + price;
                                itemName = calculteNumberOfLines(productName, finalPrice, size, qty);
                                printItem = itemName;
                            }
                            lineApi.addText(printItem + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                lineApi.addText("   Instruction: " + productDetail.special_instruction + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(true).enableUnderline(false).setAlign(Align.LEFT));

                            if (productDetail.order_item_addons.size() > 0) {
                                Pair<Boolean, Boolean> boldUnderLine1 = getUnderLineBoldCommon(structure.items_subaddon.style);
                                isbold = boldUnderLine1.first;
                                isUnderline = boldUnderLine1.second;
                                size = getSizeCommon(structure.items_subaddon.size);
                                align = getAlignCommon(structure.items_subaddon.alignment);
                                lineApi.initLine(BaseStyle.getStyle().setAlign(align));
                                if (structure.items_subaddon.visibility) {
                                    lineApi.addText("Choose Your Base:" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                }
                                for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                    List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                    if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                        continue;
                                    }
                                    productQty = orderItemAddon.quantity + "";
                                    productName = orderItemAddon.addon_name + "";
                                    price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                                    if (kitchenCopy)
                                        itemName = getProductNameWithPad(productName, price, 25);
                                    else
                                        itemName = getProductNameWithPad(productName, price, 28);
                                    qty = productQty;
                                    //printItem = (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? itemName.trim() : qty + itemName.trim();
                                    // adding qty when total or price is zero as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                    if (size == AidlUtil.Size.SIZE0 || size == AidlUtil.Size.SIZE1 || size == AidlUtil.Size.SIZE2) {
                                        if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                            if (orderItemAddon.quantity > 1) {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "  - " + orderItemAddon.quantity + "x");
                                            } else {
                                                if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                    printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "");
                                                } else {
                                                    printItem = calculteNumberOfLines(orderItemAddon.addon_name, "", size, "  -   ");
                                                }
                                            }
                                        } else {
                                            if (orderItemAddon.quantity > 1) {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), size, "  - " + orderItemAddon.addon_name + "x");
                                            } else {
                                                printItem = calculteNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), size, "  -   ");
                                            }
                                        }
                                        lineApi.addText(printItem + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                    } else {
                                        if (orderItemAddon.quantity > 1) {
                                            //printItem = qty + itemName.trim();
                                            printItem = "- " + qty + "x " + itemName.trim();
                                        } else {
                                            if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                printItem = "" + itemName.trim();
                                            } else {
                                                printItem = "- 1x " + itemName.trim();
                                            }
                                        }
                                        lineApi.addText(printItem + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                                    }
                                }
                            }

                            for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                                String ingredientName = orderItemIngredient.ingredient_name;
                                if (orderItemIngredient.with) {
                                    ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                                }
                                if (orderItemIngredient.without) {
                                    ingredientName = "No " + ingredientName;
                                }
                                String subdomainPrintText = getSubaddonWithPad(ingredientName, 30);
                                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                                lineApi.addText(subdomainPrintText + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false));
                            }

                            lastItemWasMisc = productDetail.misc;
                            lastBlockId = productDetail.block_id;

                            if (all_separator && orderDetail.order_items.size() > position) {
                                printSeperatorImin3Max();
                            }
                            if (!all_separator && isBlockName) {
                                lineApi.addText("\n", TextStyle.getStyle().enableBold(false).enableUnderline(false));
                            }
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "subtotal":
                    case "gratuity":
                    case "delivery_charge":
                    case "service_charge":
                    case "grand_total":
                    case "discount": {
                        if (printTotalInPrint) {
                            String formattedValue = "";
                            String titleOfTotal = "";
                            if (key.equalsIgnoreCase("gratuity")) {
                                if (orderDetail.gratuity > 0) {
                                    formattedValue = MyApp.df.format(orderDetail.gratuity);
                                }
                                titleOfTotal = "GRATUITY";
                            } else if (key.equalsIgnoreCase("discount")) {
                                if (orderDetail.discount > 0)
                                    formattedValue = MyApp.df.format(orderDetail.discount);
                                titleOfTotal = "DISCOUNT";
                            } else if (key.equalsIgnoreCase("grand_total")) {
                                if (orderDetail.total > 0) {
                                    formattedValue = MyApp.df.format(orderDetail.total);
                                }
                                titleOfTotal = "TOTAL";
                            } else if (key.equalsIgnoreCase("service_charge")) {
                                if (orderDetail.service_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.service_charge);
                                titleOfTotal = "SERVICE CHARGE";
                            } else if (key.equalsIgnoreCase("delivery_charge")) {
                                if (orderDetail.delivery_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.delivery_charge);
                                titleOfTotal = "DELIVERY CHARGE";
                            } else if (key.equalsIgnoreCase("subtotal")) {
                                formattedValue = MyApp.df.format(orderDetail.sub_total);
                                titleOfTotal = "SUB TOTAL";
                            }
                            if (!Validators.isNullOrEmpty(formattedValue)) {
                                int length = formattedValue.length();
                                String price = null;
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        price = "    " + formattedValue;
                                    }
                                    if (length == 5) {
                                        price = "   " + formattedValue;
                                    }

                                    if (length == 6) {
                                        price = "  " + formattedValue;
                                    }
                                    if (length == 7) {
                                        price = " " + formattedValue;
                                    }
                                } else {
                                    price = formatter.format(orderDetail.sub_total);
                                }
                                lineApi.addText(formatTotal(size, titleOfTotal, price) + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            }
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_detail_header": {
                        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                            lineApi.addText("Payment Details: " + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_detail": {
                        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                            for (OrderPayment orderPayment : orderDetail.order_payments) {
                                String paymentDetailToPrint = null;
                                if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                    paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                                } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                    paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else {
                                    paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount);
                                }
                                lineApi.addText(paymentDetailToPrint + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            }
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "serve_by": {
                        String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                        lineApi.addText(toprint + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "customer_detail": {
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            lineApi.addText("" + orderDetail.customer_name + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        String fulladdress = null;
                        if (orderType == 3) {
                            fulladdress = "" + formatAddress(orderDetail);
                            lineApi.addText(fulladdress + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                            lineApi.addText("" + orderDetail.customer.mobile + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)) {
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_status": {
                        if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                            lineApi.addText(settingMap.get("unpaid_payment_title").toUpperCase() + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                            lineApi.addText(settingMap.get("paid_payment_title").toUpperCase() + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                            lineApi.addText(settingMap.get("partial_payment_title").toUpperCase() + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "order_comment": {
                        if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                            lineApi.addText("Comment: " + orderDetail.comment + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                            lineApi.addText("Requested Time" + orderDetail.delivery_collection_time_slot + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false).setAlign(Align.LEFT));
                        }
                        break;
                    }
                    case "footer_order_type": {
                        if (!Validators.isNullOrEmpty(orderTypeHeading) && kitchenCopy) {
                            lineApi.addText("" + orderTypeHeading.toUpperCase() + "" + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "footer": {
                        if (!Validators.isNullOrEmpty(footerA)) {
                            lineApi.addText(footerA + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (!Validators.isNullOrEmpty(footerB)) {
                            lineApi.addText(footerB + "\n", TextStyle.getStyle().setTextSize((int) size).enableBold(isbold).enableUnderline(isUnderline));
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }

                }
                if (tableNumberOrderIdMode != null) {
                    String tableNumberOrderIdText = "";
                    if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                        } else
                            tableNumberOrderIdText = "Order ID: " + orderDetail.display_order_id;
                    }
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    lineApi.addText(tableNumberOrderIdText + "\n", TextStyle.getStyle().setTextSize(30).enableBold(false).enableUnderline(false));
                }
            }
            // set print true for local device
            setPrint(myPreferences, true);
            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printTextHeader(int headerAlignment, String ticket_header) {
        Align headerAligment;
        switch (headerAlignment) {
            case 0:
                headerAligment = Align.LEFT;
                break;
            case 1:
                headerAligment = Align.CENTER;
                break;
            default:
                headerAligment = Align.RIGHT;
                break;
        }
        try {
            lineApi.initLine(BaseStyle.getStyle().setAlign(headerAligment));
            lineApi.addText(ticket_header + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printReservationList(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, ArrayList<Object> allReservations, String footerA, String footerB, String fromdate, String todate, MyPreferences myPreferences) {
        try {
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (tiffintomLogo != null) {
                lineApi.printBitmap(tiffintomLogo, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
            }
            printTextHeader(headerAlignment, ticket_header);
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (!Validators.isNullOrEmpty(title))
                lineApi.addText(title + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false));
            printSeperatorImin3Max();

            String date = "";
            if (fromdate != null) {
                if (fromdate.equalsIgnoreCase("0") && todate.equalsIgnoreCase("0")) {
                    date = "Show All";
                } else {
                    date = fromdate + " - " + todate;
                }
            } else {
                date = "All";
            }
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
            lineApi.addText(date + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            printSeperatorImin3Max();

            for (Object obj : allReservations) {
                StringBuilder sb = new StringBuilder();
                if (obj instanceof Reservation) {
                    sb = new StringBuilder();
                    Reservation reservation = (Reservation) obj;
                    sb.append(padRightSpaces("Name: " + reservation.customer_name, 22))
                            .append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy"));

                    if (!Validators.isNullOrEmpty(reservation.telephone)) {
                        if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                            sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 22)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                        } else {
                            sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 22)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                        }
                    } else {
                        if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                            sb.append("\n").append(padRightSpaces("", 22)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                        } else {
                            sb.append("\n").append(padRightSpaces("", 22)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                        }
                    }

                    if (!Validators.isNullOrEmpty(reservation.table_number)) {
                        sb.append("\n").append("Table: ").append(reservation.table_number);
                    }
                    sb.append("\n").append(padRightSpaces("Dinner: " + reservation.diners, 18)).append("Status: ").append(reservation.reservation_status);

                    if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                        sb.append("\n").append("Special Instruction: ").append(reservation.special_instruction);
                    }
                }
                if (obj instanceof OnlineReservation) {

                    sb = new StringBuilder();
                    OnlineReservation reservation = (OnlineReservation) obj;
                    sb.append(padRightSpaces("Name: " + reservation.customer_name, 22))
                            .append(CommonFunctions.formatUnknownDateTime(reservation.booking_date, "yyyy-MM-dd", "dd/MM/yyyy"));

                    if (!Validators.isNullOrEmpty(reservation.booking_phone)) {
                        sb.append("\n").append(padRightSpaces("Number: " + reservation.booking_phone, 22)).append(reservation.booking_time);
                    } else {
                        sb.append("\n").append(padRightSpaces("", 22)).append(reservation.booking_time).append("\n");
                    }
                    sb.append("\n").append(padRightSpaces("Dinner: " + reservation.guest_count, 18)).append("Status: ").append(reservation.status);
                    if (reservation.status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                        sb.append("\n").append("Reason: ").append(reservation.cancel_reason);
                    }
                    if (!Validators.isNullOrEmpty(reservation.booking_instruction) && !reservation.status.equalsIgnoreCase("cancel")) {
                        sb.append("\n").append("Booking Instruction: ").append(reservation.booking_instruction);
                    }

                }
                if (sb.toString().length() > 0) {
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    lineApi.addText(sb + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
                    printSeparator();
                }

            }
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            lineApi.addText(footerA + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            lineApi.addText(footerB + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            // set print true for local device
            setPrint(myPreferences, true);
            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printReservation(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Reservation reservation, String footerA, String footerB, MyPreferences myPreferences) {
        try {
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (tiffintomLogo != null) {
                lineApi.printBitmap(tiffintomLogo, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
            }
            printTextHeader(headerAlignment, ticket_header);
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (!Validators.isNullOrEmpty(title))
                lineApi.addText(title + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false).setAlign(Align.CENTER));
            printSeperatorImin3Max();
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
            lineApi.addText("Customer Name: " + reservation.customer_name + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
            if (!Validators.isNullOrEmpty(reservation.telephone)) {
                lineApi.addText("Customer Number  : " + reservation.telephone + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
            }
            printSeperatorImin3Max();
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
            if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                lineApi.addText("Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd/MM/yyyy") + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
                lineApi.addText("Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a") + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
            } else {
                lineApi.addText("Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy") + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
                lineApi.addText("Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a") + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
            }
            lineApi.addText("No of Diners     : " + reservation.diners + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
            if (!reservation.online_reservation) {
                if (!Validators.isNullOrEmpty(reservation.deposit_type))
                    lineApi.addText("Deposit Type     : " + reservation.deposit_type + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
                lineApi.addText("Deposit Amount   : " + reservation.deposit_amount + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
            }
            printSeperatorImin3Max();

            if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                lineApi.addText("Special Instructions : " + reservation.special_instruction + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
                printSeperatorImin3Max();
            }
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            lineApi.addText(footerA + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            lineApi.addText(footerB + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            // set print true for local device
            setPrint(myPreferences, true);
            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printVoucher(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Voucher voucher, String footerA, String footerB, MyPreferences myPreferences) {
        try {
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (tiffintomLogo != null) {
                lineApi.printBitmap(tiffintomLogo, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
            }
            printTextHeader(headerAlignment, ticket_header);
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (!Validators.isNullOrEmpty(title))
                lineApi.addText(title + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false));
            printSeperatorImin3Max();

            lineApi.addText(voucher.voucher_code + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false));
            printSeperatorImin3Max();
            lineApi.addText(MyApp.df.format(voucher.voucher_amount) + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false));
            StringBuilder sb = new StringBuilder();
            sb.append("Name: ").append(voucher.customer_name).append("\n");
            sb.append("VALIDITY \n");
            sb.append("VALID FROM : ").append(CommonFunctions.formatUnknownDateTime(voucher.start_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");
            if (Validators.isNullOrEmpty(voucher.end_date) || voucher.end_date.contains("203")) {
                sb.append("VALID Till : No Expiry\n");
            } else {
                sb.append("VALID Till : ").append(CommonFunctions.formatUnknownDateTime(voucher.end_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");
            }
            sb.append("NOT VALID \n");
            if (!Validators.isNullOrEmpty(voucher.week_day)) {
                String[] daystList = voucher.week_day.split(",");
                StringBuilder daysBuilder = new StringBuilder();
                for (String str : daystList) {
                    if (Validators.isNullOrEmpty(str)) continue;
                    if (str.equalsIgnoreCase("1")) {
                        daysBuilder.append("Monday");
                    } else if (str.equalsIgnoreCase("2")) {
                        daysBuilder.append("Tuesday");
                    } else if (str.equalsIgnoreCase("3")) {
                        daysBuilder.append("Wednesday");
                    } else if (str.equalsIgnoreCase("4")) {
                        daysBuilder.append("Thursday");
                    } else if (str.equalsIgnoreCase("5")) {
                        daysBuilder.append("Friday");
                    } else if (str.equalsIgnoreCase("6")) {
                        daysBuilder.append("Saturday");
                    } else if (str.equalsIgnoreCase("0")) {
                        daysBuilder.append("Sunday");
                    }
                    if (daysBuilder.length() > 0) {
                        daysBuilder.append(", ");
                    }

                }
                sb.append("Not Valid on: ").append(daysBuilder.toString()).append("\n");
            }

            if (!Validators.isNullOrEmpty(voucher.order_type_id)) {
                String[] orderList = voucher.order_type_id.split(",");
                StringBuilder ordersBuilder = new StringBuilder();
                for (String str : orderList) {
                    if (Validators.isNullOrEmpty(str)) continue;
                    if (str.equalsIgnoreCase("1"))
                        ordersBuilder.append("Dine In");

                    if (str.equalsIgnoreCase("2"))
                        ordersBuilder.append("Collection");

                    if (str.equalsIgnoreCase("3"))
                        ordersBuilder.append("Delivery");

                    if (str.equalsIgnoreCase("4"))
                        ordersBuilder.append("Bar");

                    if (str.equalsIgnoreCase("5"))
                        ordersBuilder.append("Waiting");

                    if (str.equalsIgnoreCase("6"))
                        ordersBuilder.append("Web Order");

                    if (ordersBuilder.length() > 0) {
                        ordersBuilder.append(", ");
                    }
                }
                sb.append("Not Valid on: ").append(ordersBuilder).append("\n");
            }
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
            lineApi.addText(sb + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            printSeperatorImin3Max();
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            lineApi.addText(footerA + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            lineApi.addText(footerB + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            // set print true for local device
            setPrint(myPreferences, true);
            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printFoodHubFullReport(Bitmap tiffintomLogo, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        try {
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (tiffintomLogo != null) {
                lineApi.printBitmap(tiffintomLogo, BitmapStyle.getStyle().setAlign(Align.CENTER).setAlgorithm(ImageAlgorithm.DITHERING));
            }
            printTextHeader(headerAlignment, header);
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            if (!Validators.isNullOrEmpty(title))
                lineApi.addText(title + "\n", TextStyle.getStyle().setTextSize(40).enableBold(true).enableUnderline(false));
            printSeperatorImin3Max();

            if (!Validators.isNullOrEmpty(date)) {
                lineApi.addText("Date: " + date + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
                printSeperatorImin3Max();
            }
            if (!Validators.isNullOrEmpty(myPreferences.getRegisteredDevice().name)) {
                lineApi.addText(myPreferences.getRegisteredDevice().name + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
                printSeperatorImin3Max();
            }
            if (!Validators.isNullOrEmpty(user)) {
                lineApi.addText("User name: " + user + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
                printSeperatorImin3Max();
            }
            lineApi.addText(reportHeader(AidlUtil.Size.SIZE0) + "\n", TextStyle.getStyle().setTextSize((int) AidlUtil.Size.SIZE0).enableBold(true).enableUnderline(false));
            printSeperatorImin3Max();
            for (Object objct : data) {
                if (objct instanceof ReportTextModel) {
                    ReportTextModel textModel = (ReportTextModel) objct;

                    String printText;
                    if (!textModel.isHeader) {
                        if (!Validators.isNullOrEmpty(textModel.value)) {
                            if (textModel.value.contains(MyApp.currencySymbol)) {
                                //printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 35);
                                printText = reportDetail(AidlUtil.Size.SIZE0, "", textModel.value, textModel.title);
                            } else {
                                //printText = getProductNameWithPad(textModel.title, textModel.value, 35);
                                printText = reportDetail(AidlUtil.Size.SIZE0, textModel.value, "", textModel.title);
                            }
                        } else {
                            if (!Validators.isNullOrEmpty(textModel.totalPrice) || !Validators.isNullOrEmpty(textModel.orderCount)) {
                                printText = reportDetail(AidlUtil.Size.SIZE0, textModel.orderCount, textModel.totalPrice, textModel.title);
                            } else {
                                printText = getProductNameWithPad(textModel.title, "", 35);
                            }
                        }
                    } else {
                        printText = "" + textModel.title;
                    }
                    lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                    if (textModel.isHeader) {
                        printSeparator();
                        lineApi.addText(printText + "\n", TextStyle.getStyle().setTextSize((int) AidlUtil.Size.SIZE0).enableBold(textModel.isHeader).enableUnderline(false));
                        printSeparator();
                    } else {
                        lineApi.addText(printText + "\n", TextStyle.getStyle().setTextSize((int) AidlUtil.Size.SIZE0).enableBold(false).enableUnderline(false));
                    }

                }
                lineApi.initLine(BaseStyle.getStyle().setAlign(Align.LEFT));
                if (objct instanceof SalesReport) {
                    SalesReport salesReport = (SalesReport) objct;
                    String name = salesReport.product_name;
                    if (Validators.isNullOrEmpty(name)) {
                        name = salesReport.category_name;
                    }
                    String printText;
                    printText = getTitleWithPad(name + "x(" + salesReport.count + ")", salesReport.total, 28);
                    lineApi.addText(printText + "\n", TextStyle.getStyle().setTextSize(32).enableBold(false).enableUnderline(false));
                }
            }

            printSeparator();
            lineApi.initLine(BaseStyle.getStyle().setAlign(Align.CENTER));
            lineApi.addText(footerA + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            lineApi.addText(footerB + "\n", TextStyle.getStyle().setTextSize(32).enableBold(true).enableUnderline(false));
            // set print true for local device
            setPrint(myPreferences, true);
            lineApi.addText(" \n \n ", new TextStyle());
            lineApi.autoOut();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String reportHeader(float widthSize) {
        String orderTitle = "Orders  ";
        String priceTitle = "   Price";
        float _60Per = widthSize == AidlUtil.Size.SIZE0 ? 22 : 10;
        String orderPriceTitle = "";
        for (int emptySpace = 0; emptySpace < _60Per; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        // 2 space after orders in order to display space between orders and price
        orderPriceTitle = orderPriceTitle + orderTitle + "";
        orderPriceTitle = orderPriceTitle + priceTitle;
        return orderPriceTitle;
    }

    private String reportDetail(float widthSize, String ordersValue, String priceValue, String titleValue) {
        int _60Per = widthSize == AidlUtil.Size.SIZE0 ? 18 : 10;
        String orderPriceTitle = "";
        int titleLength = _60Per - titleValue.length();
        orderPriceTitle = titleValue + "";
        for (int emptySpace = 0; emptySpace < titleLength; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        // 2 space after orders in order to display space between orders and price
        if (Validators.isNullOrEmpty(ordersValue)) {
            int different = 10 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 10 - ordersValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + ordersValue;
        }
        orderPriceTitle = orderPriceTitle + "";
        if (Validators.isNullOrEmpty(priceValue)) {
            int different = 10 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 10 - priceValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + priceValue;
        }
        return orderPriceTitle;
    }

    private String getTitleWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getSubaddonWithPadOnline(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }
                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(parts1[1].trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }

                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(part.trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();

            }

        }
        return subAddonName;
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                int index = 0;
                List<String> parts = getParts(String.valueOf(parts1[1]), charatersInLine);
                int appendTill = parts.size();
                for (String partSub : parts) {
                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                    if (index < appendTill - 1) {
                        sb.append("\n");
                    }
                    index++;
                }
                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(parts1[1].trim(), charatersInLine);
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                int index = 0;
                List<String> parts = getParts(part, charatersInLine);
                int appendTill = parts.size();
                for (String partSub : parts) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                    if (index < appendTill - 1) {
                        sb.append("\n");
                    }
                    index++;
                }

                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(part.trim(), charatersInLine);

            }

        }
        return subAddonName;
    }

    public static String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    public static String padLeftSpace(String str, int n) {
        return String.format("%1$" + n + "s", str);
    }


    private static List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }
}
