package com.ubsidi.epos_2021.comman.printer;

import static com.ubsidi.epos_2021.comman.printer.WifiPrinterUtil.Alignment.CENTER;
import static com.ubsidi.epos_2021.comman.printer.WifiPrinterUtil.Alignment.LEFT;
import static com.ubsidi.epos_2021.comman.printer.WifiPrinterUtil.Alignment.RIGHT;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;

import com.google.gson.Gson;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.ReportTextModel;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SalesReport;
import com.ubsidi.epos_2021.models.SendOrderWifiModel;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderProductDetail;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.Logger;
import com.zj.wfsdk.WifiCommunication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class WifiPrinter {
    private static final WifiPrinter wifiPrinter = new WifiPrinter();
    Context context;
    private WifiCommunication wifiCommunication;
    public int connectionFlag = 0;
    public int printingStatus = 0;
    RevMsgThread revThred = null;
    // checkPrintThread cheThread = null;
    private String ip;
    private SiteSetting printBlockBill = MyApp.getInstance().findSetting("print_block_bill");

    public static WifiPrinter getInstance() {
        return wifiPrinter;
    }

    public WifiPrinter() {
        wifiCommunication = new WifiCommunication(mHandler);
    }

    @SuppressLint("HandlerLeak")
    private final Handler mHandler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {

            switch (msg.what) {
                case WifiCommunication.WFPRINTER_CONNECTED:
                    connectionFlag = 1;
                    revThred = new RevMsgThread();
                    revThred.start();
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printer connected "));

                    //Toaster.show(CardReaderPaymentActivity.this, "Connect the WIFI-printer successful", true, Toaster.SUCCESS);

                    //  printer_connection_status.setText("Connect the WIFI-printer successful");
                    // dialog_print.setEnabled(true);


                    break;
                case WifiCommunication.WFPRINTER_DISCONNECTED:
                    connectionFlag = 0;
                    // Toast.makeText(
                    // "Disconnect the WIFI-printer successful",
                    // Toast.LENGTH_SHORT).show();
                    if (wifiCommunication != null && revThred != null) {
                        revThred.interrupt();
                    }
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printer dis connected "));
                    // Toaster.show(CardReaderPaymentActivity.this, "Disconnect the WIFI-printer successful", true, Toaster.SUCCESS);

                    // printer_connection_status.setText("Disconnect the WIFI-printer successful");

                    break;
                case WifiCommunication.SEND_FAILED:
                    if (revThred != null) revThred.interrupt();
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printer send data failed "));

                    // Toaster.show(CardReaderPaymentActivity.this, "Send Data Failed,please reconnect", true, Toaster.DANGER);

                    //  printer_connection_status.setText("Send Data Failed,please reconnect");
                    break;
                case WifiCommunication.WFPRINTER_CONNECTEDERR:
                    connectionFlag = 0;
//                    disconnect();
//
//                    // Toast.makeText( "Connect the WIFI printer get error",
//                    // Toast.LENGTH_SHORT).show();
//                    if (wifiCommunication != null && revThred != null) {
//                        revThred.interrupt();
//                    }
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printer connection error "));
//                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printer reconnecting "));
                    // Toaster.show(CardReaderPaymentActivity.this, "Connect the WIFI-printer error", true, Toaster.DANGER);
                    //printer_connection_status.setText("Connect the WIFI-printer error");
                    //dialog_print.setEnabled(false);
//                    if (ip != null) {
//                        connectionFlag = 0;
//                        disconnect();
//                        wifiCommunication.initSocket(ip, 9100);
//                    }
                    break;

                case WifiCommunication.WFPRINTER_REVMSG:
                    byte revData = (byte) Integer.parseInt(msg.obj.toString());
                    if (((revData >> 6) & 0x01) == 0x01) {
                        break;
                    }
                    // Toast.makeText(getApplicationContext(),
                    // "The printer have no paper", Toast.LENGTH_SHORT)
                    // .show();
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printer has no paper "));
                    //printer_connection_status.setText("The printer has no paper");
                    break;
                default:
                    break;
            }
        }
    };

    class RevMsgThread extends Thread {
        @Override
        public void run() {
            try {
                Message msg = new Message();
                int revData;
                while (true) {
                    revData = wifiCommunication.revByte();
                    if (revData != -1) {
                        msg = mHandler.obtainMessage(WifiCommunication.WFPRINTER_REVMSG);
                        msg.obj = revData;
                        mHandler.sendMessage(msg);
                    }
                    Thread.sleep(20);
                }
            } catch (InterruptedException e) {
                LogUtils.e("PRINT::");
                LogUtils.e("[AndroidPrinter]", Log.getStackTraceString(e));
            }
        }
    }

    public void connect(String ip) {
        new Thread(() -> {
            this.ip = ip;
            try {
                if (connectionFlag == 0) {
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Connecting printer with " + ip));
                    wifiCommunication.initSocket(ip, 9100);
                    Thread.sleep(100);
                } else {
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Already connected " + ip));
                }
                try {

                } catch (Exception e) {
                    e.printStackTrace();
                }
            } catch (Exception ex) {
                LogUtils.e("[AndroidPrinter]", "打印机连接失败", ex.getMessage());
            }
        }).start();
    }

    public void connect(String ip, boolean forcefully) {
        new Thread(() -> {
            this.ip = ip;
            try {
                if (forcefully) {
                    if (connectionFlag == 1) disconnect();
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Connecting printer forcefully with " + ip));
                    wifiCommunication.initSocket(ip, 9100);
                } else {
                    if (connectionFlag == 0) {
                        MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Connecting printer with " + ip));
                        wifiCommunication.initSocket(ip, 9100);
                    } else {
                        MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Already connected " + ip));
                    }
                }
                Thread.sleep(100);
            } catch (Exception ex) {
                LogUtils.e("[AndroidPrinter]", "打印机连接失败", ex.getMessage());
            }
        }).start();
    }

    // disconnect to printer
    public void disconnect() {
        new Thread(() -> {
            try {
                connectionFlag = 0;
                wifiCommunication.close();
            } catch (Exception ex) {
                LogUtils.e("[AndroidPrinter]", "打印机关闭失败", ex.getMessage());
            }
        }).start();
    }


    public void openCashDrawer() {
        new Thread(() -> {
            try {
                printingStatus = 1;
                WifiPrinterUtil.getInstance().CashDrawer(wifiCommunication);
                printingStatus = 0;
                disconnect();
            } catch (Exception e) {
//                FirebaseCrashlytics.getInstance().recordException(e);
                if (wifiCommunication != null && ip != null) {
                    wifiCommunication.initSocket(ip, 9100);
                }
            }
        }).start();
    }

    public void openCashDrawer(boolean close) {
        new Thread(() -> {
            try {
                printingStatus = 1;
                WifiPrinterUtil.getInstance().CashDrawer(wifiCommunication);
                printingStatus = 0;
                if (close)
                    disconnect();
            } catch (Exception e) {
//                FirebaseCrashlytics.getInstance().recordException(e);
//                if (wifiCommunication != null && ip != null) {
//                    wifiCommunication.initSocket(ip, 9100);
//                }
            }
        }).start();
        CommonFunctions.functionThatDelay(200);
    }

    public void printDemo(String title, MyPreferences myPreferences) {
        wifiCommunication = new WifiCommunication(mHandler);
        wifiCommunication.initSocket(ip, 9100);
        wifiCommunication.sndByte(ByteCommand.ESC_Init);
        WifiPrinterUtil.getInstance().printText(wifiCommunication, title, 1, false, false, LEFT);
        WifiPrinterUtil.getInstance().printText(wifiCommunication, "Left Line 1", 1, false, false, LEFT);
        WifiPrinterUtil.getInstance().printText(wifiCommunication, "Center Line 1", 1, false, false, CENTER);
        WifiPrinterUtil.getInstance().printText(wifiCommunication, "Right Line 1", 1, false, false, RIGHT);

        WifiPrinterUtil.getInstance().printText(wifiCommunication, "Bold Left Line 1", 1, true, false, LEFT);
        WifiPrinterUtil.getInstance().printText(wifiCommunication, "Bold Center Line 1", 1, true, false, CENTER);
        WifiPrinterUtil.getInstance().printText(wifiCommunication, "Bold Right Line 1", 1, true, false, RIGHT);
        // set print true for local device
        setPrint(myPreferences, true);
        WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
        disconnect();
    }

    private void setPrint(MyPreferences myPreferences, boolean isPrint) {
        myPreferences.saveIsPrintBill(isPrint);
    }

    public void printDemo1(String title, String ip, boolean close, MyPreferences myPreferences) {
        MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Method called for : " + title));
        printDemoText(title, close, myPreferences);
    }

    public void printDemoText(String title, boolean close, MyPreferences myPreferences) {
        MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printer started for : " + title));
        new Thread(() -> {
            wifiCommunication.sndByte(ByteCommand.ESC_Init);
            printingStatus = 1;
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE4, false, false, LEFT);

            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 0x0", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 0x1", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 0x2", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE2, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 0x3", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE3, false, false, LEFT);

            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 1x0", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 1x1", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 1x2", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE2, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 1x3", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE3, false, false, LEFT);

            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 2x0", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 2x1", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 2x2", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 2x3", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE3, false, false, LEFT);

            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 3x0", WifiPrinterUtil.FontSize.SIZE3, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 3x1", WifiPrinterUtil.FontSize.SIZE3, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 3x2", WifiPrinterUtil.FontSize.SIZE3, WifiPrinterUtil.FontSize.SIZE2, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 3x3", WifiPrinterUtil.FontSize.SIZE3, WifiPrinterUtil.FontSize.SIZE3, false, false, LEFT);

            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 0x0", WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 1x0", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 2x0", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 3x0", WifiPrinterUtil.FontSize.SIZE3, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 0x1", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 1x1", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 2x1", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 3x1", WifiPrinterUtil.FontSize.SIZE3, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);

            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 0x2", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE2, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 1x2", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE2, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 2x2", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 3x2", WifiPrinterUtil.FontSize.SIZE3, WifiPrinterUtil.FontSize.SIZE2, false, false, LEFT);

            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 0x3", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE3, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 1x3", WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE3, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 2x3", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE3, false, false, LEFT);
            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Size 3x3", WifiPrinterUtil.FontSize.SIZE3, WifiPrinterUtil.FontSize.SIZE3, false, false, LEFT);

            // set print true for local device
            setPrint(myPreferences, true);
            WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
            printingStatus = 0;
        }).start();
//        disconnect();
    }

    public void printCardReaderReceipt(Bitmap bitmap, String rePrintTitle, String title, String header, int headerAlignment, String header1, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1, boolean close, MyPreferences myPreferences) {
        actual_amount = actual_amount.replace(MyApp.currencySymbol, "");
        if (!Validators.isNullOrEmpty(tip_amount)) {
            tip_amount = tip_amount.replace(MyApp.currencySymbol, "");
        }
        grand_total = grand_total.replace(MyApp.currencySymbol, "");
        String finalActual_amount = actual_amount;
        String finalTip_amount = tip_amount;
        String finalGrand_total = grand_total;
        new Thread(() -> {
            MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Card Reader Called: " + title));
            try {

                MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Card Reader start : " + title));
                wifiCommunication.sndByte(ByteCommand.ESC_Init);
                printingStatus = 1;
                WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (bitmap != null)
                    WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, bitmap, 320, 0);
                if (!Validators.isNullOrEmpty(header)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                }
                if (!Validators.isNullOrEmpty(header1)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, header1, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                }
                if (!Validators.isNullOrEmpty(rePrintTitle)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, rePrintTitle, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                if (!Validators.isNullOrEmpty(finalTip_amount)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, finalActual_amount, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, finalTip_amount, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, finalGrand_total + " GBP", WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, main_content, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, please, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, final_date, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footer, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footer1, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                if (close) {
                    printingStatus = 0;
                    disconnect();
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Card Reader disconnect: " + title));
                }
                printingStatus = 0;
            } catch (Exception e) {
                printingStatus = 0;
                e.printStackTrace();
//                FirebaseCrashlytics.getInstance().recordException(e);
                if (wifiCommunication != null && ip != null) {
                    wifiCommunication.initSocket(ip, 9100);
                }
            }
        }).start();
    }

    public void printMotoReceipt(Bitmap bitmap, String title, String header, int headerAlignment, final String amount, String main_content, String date_final, String please, String footer, String footer1, boolean close, MyPreferences myPreferences) {
        new Thread(() -> {
            try {
                MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Moto Called : " + title));


                MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Moto start : " + title));

                wifiCommunication.sndByte(ByteCommand.ESC_Init);
                printingStatus = 1;
                WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (bitmap != null)
                    WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, bitmap, 320, 0);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                String amt = amount;
                amt = amt.replace("£", "");
                amt = amt.replace("\n", "");
                amt = amt + " GBP";
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, amt, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, main_content.replace(" :", ": "), WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, date_final, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, please, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footer, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footer1, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                if (close) {
                    printingStatus = 0;
                    disconnect();
                    MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Moto disconnect: " + title));
                }
                printingStatus = 0;

            } catch (Exception e) {
//                FirebaseCrashlytics.getInstance().recordException(e);
                printingStatus = 0;
                if (wifiCommunication != null && ip != null) {
                    wifiCommunication.initSocket(ip, 9100);
                }
                e.printStackTrace();
            }
        }).start();
    }

    public void printReservationList(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, ArrayList<Object> allReservations, String footerA, String footerB, String fromdate, String todate, MyPreferences myPreferences) {
        new Thread(() -> {
            try {
                MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Reservation called : " + title));


                MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Reservation started : " + title));

                wifiCommunication.sndByte(ByteCommand.ESC_Init);
                printingStatus = 1;
                WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (tiffintomLogo != null) {
                    WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                }

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, ticket_header, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);

                if (!Validators.isNullOrEmpty(title)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                String date = "";
                if (fromdate != null) {
                    if (fromdate.equalsIgnoreCase("0") && todate.equalsIgnoreCase("0")) {
                        date = "Show All";
                    } else if (fromdate.equalsIgnoreCase(todate)) {
                        date = fromdate;
                    } else {
                        date = fromdate + " - " + todate;
                    }
                } else {
                    date = "All";
                }

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, date, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);


                for (Object obj : allReservations) {
                    StringBuilder sb = new StringBuilder();
                    if (obj instanceof Reservation) {
                        sb = new StringBuilder();
                        Reservation reservation = (Reservation) obj;
                        sb.append(padRightSpaces("Name: " + reservation.customer_name, 30))
                                .append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy"));

                        if (!Validators.isNullOrEmpty(reservation.telephone)) {
                            if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                                sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 30)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                            } else {
                                sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 30)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                            }
                        } else {
                            if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                                sb.append("\n").append(padRightSpaces("", 20)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                            } else {
                                sb.append("\n").append(padRightSpaces("", 20)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                            }
                        }

                        if (!Validators.isNullOrEmpty(reservation.table_number)) {
                            sb.append("\n").append("Table: ").append(reservation.table_number);
                        }
                        sb.append("\n").append(padRightSpaces("Dinner: " + reservation.diners, 30)).append("Status: ").append(reservation.reservation_status);

                        if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                            sb.append("\n").append("Special Instruction: ").append(reservation.special_instruction);
                        }
                    }
                    if (obj instanceof OnlineReservation) {

                        sb = new StringBuilder();
                        OnlineReservation reservation = (OnlineReservation) obj;
                        sb.append(padRightSpaces("Name: " + reservation.customer_name, 30))
                                .append(CommonFunctions.formatUnknownDateTime(reservation.booking_date, "yyyy-MM-dd", "dd/MM/yyyy"));

                        if (!Validators.isNullOrEmpty(reservation.booking_phone)) {
                            sb.append("\n").append(padRightSpaces("Number: " + reservation.booking_phone, 30)).append(reservation.booking_time);
                        } else {
                            sb.append("\n").append(padRightSpaces("", 30)).append(reservation.booking_time).append("\n");
                        }
                        sb.append("\n").append(padRightSpaces("Dinner: " + reservation.guest_count, 30)).append("Status: ").append(reservation.status);
                        if (reservation.status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                            sb.append("\n").append("Reason: ").append(reservation.cancel_reason);
                        }
                        if (!Validators.isNullOrEmpty(reservation.booking_instruction) && !reservation.status.equalsIgnoreCase("cancel")) {
                            sb.append("\n").append("Booking Instruction: ").append(reservation.booking_instruction);
                        }

                    }
                    if (sb.toString().length() > 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, sb.toString(), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    }

                }

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerA, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerB, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                printingStatus = 0;
                disconnect();
                MyApp.getInstance().notifyCallReceived(context, new Intent("log").putExtra("log", "Printing Reservation disconnect : " + title));

            } catch (Exception e) {
//                FirebaseCrashlytics.getInstance().recordException(e);
                LogUtils.e("PRINT::", "Error in reservation list:");
                e.printStackTrace();
                printingStatus = 0;
                if (wifiCommunication != null && ip != null) {
                    wifiCommunication.initSocket(ip, 9100);
                }
            }
        }).start();
    }

    public void printReservation(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Reservation reservation, String footerA, String footerB, MyPreferences myPreferences) {
        new Thread(() -> {
            try {

                wifiCommunication.sndByte(ByteCommand.ESC_Init);
                printingStatus = 1;
                WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (tiffintomLogo != null) {
                    WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, ticket_header, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);

                if (!Validators.isNullOrEmpty(title)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                String customername = "Customer Name: " + reservation.customer_name;
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, customername, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                if (!Validators.isNullOrEmpty(reservation.telephone)) {
                    String customerno = "Customer Number: " + reservation.telephone;
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, customerno, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd/MM/yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                } else {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "No of Diners     : " + reservation.diners, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                if (!reservation.online_reservation) {
                    if (!Validators.isNullOrEmpty(reservation.deposit_type))
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Deposit Type     : " + reservation.deposit_type, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Deposit Amount   : " + reservation.deposit_amount, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Special Instructions : " + reservation.special_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerA, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerB, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                printingStatus = 0;
                disconnect();

            } catch (Exception e) {
                printingStatus = 0;
//                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
                if (wifiCommunication != null && ip != null) {
                    wifiCommunication.initSocket(ip, 9100);
                }
            }
        }).start();
    }

    public void printVoucher(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Voucher voucher, String footerA, String footerB, MyPreferences myPreferences) {
        new Thread(() -> {
            try {

                wifiCommunication.sndByte(ByteCommand.ESC_Init);
                printingStatus = 1;
                WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (tiffintomLogo != null) {
                    WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                }

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, ticket_header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);

                if (!Validators.isNullOrEmpty(title)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, voucher.voucher_code, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, MyApp.df.format(voucher.voucher_amount) + " GBP", WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                StringBuilder sb = new StringBuilder();

                sb.append("Name: ").append(voucher.customer_name).append("\n");

                sb.append("VALIDITY\n");

                sb.append("VALID FROM : ").append(CommonFunctions.formatUnknownDateTime(voucher.start_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");

                if (Validators.isNullOrEmpty(voucher.end_date) || voucher.end_date.contains("203")) {
                    sb.append("VALID Till : No Expiry\n");
                } else {
                    sb.append("VALID Till : ").append(CommonFunctions.formatUnknownDateTime(voucher.end_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");
                }


                if (!Validators.isNullOrEmpty(voucher.week_day)) {
                    String[] daystList = voucher.week_day.split(",");
                    StringBuilder daysBuilder = new StringBuilder();
                    for (String str : daystList) {
                        if (Validators.isNullOrEmpty(str)) continue;
                        if (str.equalsIgnoreCase("1")) {
                            daysBuilder.append("Monday");
                        } else if (str.equalsIgnoreCase("2")) {
                            daysBuilder.append("Tuesday");
                        } else if (str.equalsIgnoreCase("3")) {
                            daysBuilder.append("Wednesday");
                        } else if (str.equalsIgnoreCase("4")) {
                            daysBuilder.append("Thursday");
                        } else if (str.equalsIgnoreCase("5")) {
                            daysBuilder.append("Friday");
                        } else if (str.equalsIgnoreCase("6")) {
                            daysBuilder.append("Saturday");
                        } else if (str.equalsIgnoreCase("0")) {
                            daysBuilder.append("Sunday");
                        }
                        if (daysBuilder.length() > 0) {
                            daysBuilder.append(", ");
                        }

                    }
                    sb.append("Not Valid on: ").append(daysBuilder.toString()).append("\n");
                }

                if (!Validators.isNullOrEmpty(voucher.order_type_id)) {
                    String[] orderList = voucher.order_type_id.split(",");
                    StringBuilder ordersBuilder = new StringBuilder();
                    for (String str : orderList) {
                        if (Validators.isNullOrEmpty(str)) continue;
                        if (str.equalsIgnoreCase("1"))
                            ordersBuilder.append("Dine In");

                        if (str.equalsIgnoreCase("2"))
                            ordersBuilder.append("Collection");

                        if (str.equalsIgnoreCase("3"))
                            ordersBuilder.append("Delivery");

                        if (str.equalsIgnoreCase("4"))
                            ordersBuilder.append("Bar");

                        if (str.equalsIgnoreCase("5"))
                            ordersBuilder.append("Waiting");

                        if (str.equalsIgnoreCase("6"))
                            ordersBuilder.append("Web Order");

                        if (ordersBuilder.length() > 0) {
                            ordersBuilder.append(", ");
                        }
                    }
                    sb.append("Not Valid on: ").append(ordersBuilder.toString()).append("\n");
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, sb.toString(), WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerA, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerB, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                printingStatus = 0;
                disconnect();

            } catch (Exception e) {
//                FirebaseCrashlytics.getInstance().recordException(e);
                printingStatus = 0;
                e.printStackTrace();
                if (wifiCommunication != null && ip != null) {
                    wifiCommunication.initSocket(ip, 9100);
                }
            }
        }).start();
    }

    public void printFullReport(Bitmap tiffintomLogo, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        new Thread(() -> {

            try {

                wifiCommunication.sndByte(ByteCommand.ESC_Init);
                printingStatus = 1;
                WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (tiffintomLogo != null) {
                    WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                if (!Validators.isNullOrEmpty(title))
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE1, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                if (!Validators.isNullOrEmpty(date)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Date: " + date, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                if (!Validators.isNullOrEmpty(user)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "User name: " + user, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                for (Object objct : data) {
                    if (objct instanceof ReportTextModel) {
                        ReportTextModel textModel = (ReportTextModel) objct;

                        String printText;
                        if (!textModel.isHeader) {
                            if (!Validators.isNullOrEmpty(textModel.value)) {
                                if (textModel.value.contains(MyApp.currencySymbol)) {
                                    printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 36);
                                } else {
                                    printText = getProductNameWithPad(textModel.title, textModel.value, 40);
                                }
                            } else printText = getProductNameWithPad(textModel.title, "", 40);
                        } else {
                            printText = "\n" + textModel.title;
                        }
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printText, textModel.isHeader ? WifiPrinterUtil.FontSize.SIZE0 : WifiPrinterUtil.FontSize.SIZE0, textModel.isHeader ? WifiPrinterUtil.FontSize.SIZE1 : WifiPrinterUtil.FontSize.SIZE0, textModel.isHeader, false, LEFT);

                    }
                    if (objct instanceof SalesReport) {
                        SalesReport salesReport = (SalesReport) objct;
                        String name = salesReport.product_name;
                        if (Validators.isNullOrEmpty(name)) {
                            name = salesReport.category_name;
                        }
                        String printText;
                        printText = getProductNameWithPad(name + " (" + salesReport.count + ")", salesReport.total, 40);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    }
                }

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerA, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerB, WifiPrinterUtil.FontSize.SIZE0, true, false, CENTER);
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                printingStatus = 0;
                disconnect();
            } catch (Exception e) {
//                FirebaseCrashlytics.getInstance().recordException(e);
                printingStatus = 0;
                e.printStackTrace();
                if (wifiCommunication != null && ip != null) {
                    wifiCommunication.initSocket(ip, 9100);
                }
            }
        }).start();
    }

    public void printOrder(Bitmap tiffintomLogo, Bitmap businessLogo, OrderDetail orderDetail, List<PrintSetting> printSettings, boolean kitchenCopy, boolean disconnect, MyPreferences myPreferences, boolean orderTiffinTomLogo) {
        new Thread(() -> {
            PrintStructure structure = null;
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen")) {
                        structure = printSettings.get(i).print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill")) {
                        structure = printSettings.get(i).print_structure;
                    }
                }
            }

            int orderType = -1;
            if (Validators.isNullOrEmpty(orderDetail.order_type)) {
                orderType = 0;
            } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
                orderType = 1;
            } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
                orderType = 2;
            }

            try {
                wifiCommunication.sndByte(ByteCommand.ESC_Init);
                printingStatus = 1;

                if (!orderTiffinTomLogo) {
                    if (tiffintomLogo != null) {
                        WifiPrinterUtil.getInstance().printWifiBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                    } else {
                        LogUtils.e("PRINT::", "Tiffintom Logo null");
                    }
                } else {
                    if (businessLogo != null) {
                        WifiPrinterUtil.getInstance().printWifiBitmap(wifiCommunication, CENTER, businessLogo, 320, 0);
                    } else {
                        LogUtils.e("PRINT::", "Tiffintom Logo null");
                    }
                }

                if (structure.online_title.visibility) {
                    String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                    String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    if (!todayDate.equalsIgnoreCase(orderDateString)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "This order is not for today", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }

                if (structure.online_site.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Tiffintom.com sent you order", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.online_order_type.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, CommonFunctions.getOnlineOrderType(orderType), WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.online_order_no.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "ORDER NO:" + orderDetail.order_number, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                }

                if (structure.online_order_date.visibility) {
                    if (orderType > 0) {
                        if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        } else {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }

                if (structure.online_items.visibility) {
                    String itemName = "", price = "", qty = "";
                    for (OrderProductDetail productDetail : orderDetail.cart_view) {
                        String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                        String productQty = String.valueOf(productDetail.quantity);
                        // Here we need 16 characters in product name so we send 16 in
                        // @params charactersInLine
                        price = (!kitchenCopy) ? MyApp.df.format(productDetail.total_price) : "";
                        if (kitchenCopy)
                            itemName = getProductNameWithPad(productName, price, 15);
                        else
                            itemName = getProductNameWithPad(productName, price, 35);
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + " ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + "  ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "";
                        }
                        String printItem;
                        printItem = qty + itemName;

                        printItem = printItem.replace(MyApp.currencySymbol, "");
                        if (!kitchenCopy)
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        else
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);

                        if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                            try {
                                //String[] parts = menus.get(position).getSubaddonsName().split(",");
                                String[] parts = productDetail.subaddons_name.split(",");

                                for (String subAddonPart : parts) {
                                    if (!kitchenCopy) {
                                        String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                        subdomainPrintText = subdomainPrintText.replace(MyApp.currencySymbol, "");
                                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                    } else {
                                        String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                        subdomainPrintText = subdomainPrintText.replace(MyApp.currencySymbol, "");
                                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                                    }
                                }
                            } catch (Exception e) {
                                Log.e("Addon_Error", e.getMessage());
                            }
                        }
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.online_sub_total.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("SubTotal:", 40) + MyApp.df.format(orderDetail.order_sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }

                if (structure.online_delivery_charge.visibility) {
                    if (orderDetail.delivery_charge > 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Delivery Charge:", 40) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                }

                if (structure.online_service_charge.visibility) {
                    if (orderDetail.service_charge > 0) {
                        if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Service Charge:", 40) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                    }
                }

                if (structure.online_driver_tip.visibility) {
                    if (orderDetail.driver_tip > 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Driver Tip:", 40) + MyApp.df.format(orderDetail.driver_tip), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                }

                if (structure.online_loyalty.visibility) {
                    if (orderDetail.reward_offer > 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Loyalty Point Discount:", 40) + MyApp.df.format(orderDetail.reward_offer), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                }

                if (structure.online_offer.visibility) {
                    if (orderDetail.offer_amount > 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Offer:", 40) + MyApp.df.format(orderDetail.offer_amount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                }

                if (structure.online_grand_total.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Grand Total: " + MyApp.df.format(orderDetail.order_grand_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.online_comment.visibility) {
                    if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                        if (kitchenCopy) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                        } else {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        }
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }

                if (structure.online_delivery_instruction.visibility) {
                    if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Delivery Instructions: " + orderDetail.delivery_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }

                if (structure.online_customer_details.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust Name: " + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust No: " + orderDetail.customer_phone, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.online_delivery_address.visibility) {
                    if (orderType == 1) {
                        String address = orderDetail.address + "\n";
                        String[] parts = address.split("[\\\\s,]+");
                        StringBuilder str = new StringBuilder();

                        for (String name : parts) {
                            str.append(name).append("\n");
                        }
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Del. address: " + orderDetail.address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }

                if (structure.online_requested_for.visibility) {
                    if (orderType >= 0) {
                        if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Requested for: " + "ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        } else {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Requested for: " + orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        }

                        if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Confirmed for: " + orderDetail.preparation, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        }
                    }
                }

                if (structure.online_payment_status.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                }

                if (structure.online_payment_method.visibility) {
                    String paymentName = "";
                    if (orderDetail.payment_method.equalsIgnoreCase("stripe"))
                        paymentName = "ONLINE";
                    if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                    if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                        paymentName = "WALLET";
                    if (orderDetail.payment_method.equalsIgnoreCase("paypal"))
                        paymentName = "PAYPAL";
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Type:  " + paymentName, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.online_receipt_time.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Receipt Time:  " + CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                }

                if (structure.online_order_status.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order status: " + orderDetail.status, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }

                if (structure.online_restaurant_address.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                }

                if (structure.online_failed_reason.visibility) {
                    if (orderDetail.status.equalsIgnoreCase("failed")) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Reason: " + orderDetail.failed_reason, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                }

                if (structure.online_footer.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Thanks", WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                }
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                printingStatus = 0;
                if (disconnect)
                    disconnect();
                Thread.sleep(200);

                // prepare send wifi model to order device to listen start
                SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
                sendOrderWifiModel.setOrderDetailModel(orderDetail);
                sendOrderWifiModel.setPrintSettings(printSettings);
                sendOrderWifiModel.setKitchen(kitchenCopy);
                sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
                if (kitchenCopy) {
                    sendOrderToWifi(sendOrderWifiModel);
                }
            } catch (Exception e) {
                // prepare send wifi model to order device to listen start
                SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
                sendOrderWifiModel.setOrderDetailModel(orderDetail);
                sendOrderWifiModel.setPrintSettings(printSettings);
                sendOrderWifiModel.setKitchen(kitchenCopy);
                sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
                if (kitchenCopy) {
                    sendOrderToWifi(sendOrderWifiModel);
                }
                //Removing temp while testing online order front copy not working but kitchen copy working
//                printingStatus = 0;
////                FirebaseCrashlytics.getInstance().recordException(e);
//                if (wifiCommunication != null && ip != null) {
//                    wifiCommunication.initSocket(ip, 9100);
//                }
            }
        }).start();
    }

    private void sendOrderToWifi(SendOrderWifiModel sendOrderWifiModel) {
        if (MyApp.getInstance().myPreferences.getWifiConnectionId() != null && "auto".equalsIgnoreCase(MyApp.getInstance().myPreferences.getOrderSyncMode())) {
            //Logger.INSTANCE.sendText(MyApp.getInstance().myPreferences.getWifiConnectionId(), new Gson().toJson(sendOrderWifiModel));
        }
    }

    public void printOrder(Bitmap tiffintomLogo, OrderDetail orderDetail, boolean kitchenCopy, boolean disconnect, MyPreferences myPreferences) {
        new Thread(() -> {
            int orderType = -1;
            if (Validators.isNullOrEmpty(orderDetail.order_type)) {
                orderType = 0;
            } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
                orderType = 1;
            } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
                orderType = 2;
            }

            try {
                wifiCommunication.sndByte(ByteCommand.ESC_Init);
                printingStatus = 1;
                WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (tiffintomLogo != null) {
                    WifiPrinterUtil.getInstance().printWifiBitmap(wifiCommunication, CENTER, tiffintomLogo, 320, 0);
                } else {
                    LogUtils.e("PRINT::", "Tiffintom Logo null");
                }
                String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                if (!todayDate.equalsIgnoreCase(orderDateString)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "This order is not for today", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Tiffintom.com sent you order", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, CommonFunctions.getOnlineOrderType(orderType), WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "ORDER NO:" + orderDetail.order_number, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                if (orderType > 0) {
                    if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    } else {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                String itemName = "", price = "", qty = "";
                for (OrderProductDetail productDetail : orderDetail.cart_view) {
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                    String productQty = String.valueOf(productDetail.quantity);
                    // Here we need 16 characters in product name so we send 16 in
                    // @params charactersInLine
                    price = (!kitchenCopy) ? MyApp.df.format(productDetail.total_price) : "";
                    if (kitchenCopy)
                        itemName = getProductNameWithPad(productName, price, 15);
                    else
                        itemName = getProductNameWithPad(productName, price, 35);
                    qty = productQty;
                    if (productQty.length() <= 1) {
                        qty = " " + productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + "  ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }
                    String printItem;
                    printItem = qty + itemName;

                    printItem = printItem.replace(MyApp.currencySymbol, "");
                    if (!kitchenCopy)
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    else
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);

                    if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                        try {
                            //String[] parts = menus.get(position).getSubaddonsName().split(",");
                            String[] parts = productDetail.subaddons_name.split(",");

                            for (String subAddonPart : parts) {
                                if (!kitchenCopy) {
                                    String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                    subdomainPrintText = subdomainPrintText.replace(MyApp.currencySymbol, "");
                                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                } else {
                                    String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                    subdomainPrintText = subdomainPrintText.replace(MyApp.currencySymbol, "");
                                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                                }
                            }
                        } catch (Exception e) {
                            Log.e("Addon_Error", e.getMessage());
                        }
                    }
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("SubTotal:", 40) + MyApp.df.format(orderDetail.order_sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                if (orderDetail.delivery_charge > 0) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Delivery Charge:", 40) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                if (orderDetail.offer_amount > 0) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Offer:", 40) + MyApp.df.format(orderDetail.offer_amount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                if (orderDetail.service_charge > 0) {
                    if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Service Charge:", 40) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                }
                if (orderDetail.driver_tip > 0) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Driver Tip:", 40) + MyApp.df.format(orderDetail.driver_tip), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                if (orderDetail.reward_offer > 0) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Loyalty Point Discount:", 40) + MyApp.df.format(orderDetail.reward_offer), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Grand Total: " + MyApp.df.format(orderDetail.order_grand_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                    if (kitchenCopy) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                    } else {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comments: " + orderDetail.order_description, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Delivery Instructions: " + orderDetail.delivery_instruction, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust Name: " + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust No: " + orderDetail.customer_phone, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                if (orderType == 1) {

                    String address = orderDetail.address + "\n";
                    String[] parts = address.split("[\\\\s,]+");
                    StringBuilder str = new StringBuilder();

                    for (String name : parts) {
                        str.append(name).append("\n");
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Del. address: " + orderDetail.address, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (orderType >= 0) {
                    if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Requested for: " + "ASAP", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    } else {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Requested for: " + orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }

                    if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Confirmed for: " + orderDetail.preparation, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);

                String paymentName = "";
                if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
                if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                    paymentName = "WALLET";
                if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Type:  " + paymentName, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Receipt Time:  " + CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a"), WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order status: " + orderDetail.status, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Reason: " + orderDetail.failed_reason, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Thanks", WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                printingStatus = 0;
                if (disconnect)
                    disconnect();
                Thread.sleep(200);
            } catch (Exception e) {
                //Removing temp while testing online order front copy not working but kitchen copy working
//                printingStatus = 0;
////                FirebaseCrashlytics.getInstance().recordException(e);
//                if (wifiCommunication != null && ip != null) {
//                    wifiCommunication.initSocket(ip, 9100);
//                }
            }
        }).start();
        CommonFunctions.functionThatDelay(100);
    }

    public void printOrderEpos(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, MyPreferences myPreferences) {
        new Thread(() -> {
            int orderType = -1;
            if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
                orderType = 0;
            } else {
                orderType = Integer.parseInt(orderDetail.order_type_id);
            }
            try {
                if (!kitchenCopy && tiffintomLogo != null) {
                    WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 340, 0);
                }

                if (!kitchenCopy) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, ticket_header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                }

                if (structure.header_order_type.visibility && kitchenCopy) {
                    if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "** " + orderTypeHeading + " **", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                    }

                    LogUtils.e("PRINT::", "** " + orderDetail.order_type + " **");
                    if (structure.header_customer_name != null)
                        if ((orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, false, false, CENTER);
                        }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    LogUtils.e("PRINT::", orderDetail.customer_name);
                }

                if (structure.title.visibility && kitchenCopy) {
                    if (!Validators.isNullOrEmpty(title)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }

                if (structure.order_no.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order No: " + orderDetail._id, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Table No: " + orderDetail.table_number + "   No of Diners: " + orderDetail.no_guest, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                } else if (structure.table_no.visibility && orderType == 1) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Table No: " + orderDetail.table_number, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                } else if (structure.no_of_diners.visibility && orderType == 1) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "No of Diners: " + orderDetail.no_guest, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                String orderDate = null, orderTime = null;
                if (!Validators.isNullOrEmpty(orderDetail.created_at))
                    if (orderDetail.created_at.contains("Z")) {
                        orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                        orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                    } else {
                        orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                        orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                    }
                if (structure.order_date != null)
                    if (structure.order_date.visibility) {
                        if (!Validators.isNullOrEmpty(orderDate))
                            if (structure.order_time != null) {
                                if (structure.order_time.visibility) {
                                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Date " + orderDate + " ", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                }
                            } else {
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Date :" + orderDate + " ", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            }


/*
                    if (!Validators.isNullOrEmpty(dateTimeMode)) {
                        String dateFormat = "dd-MM-yyyy hh:mm a";
                        String dateFormatTitle = "Order Date Time: ";
                        if (dateTimeMode.equalsIgnoreCase("date_time")) {
                            dateFormat = "dd-MM-yyyy hh:mm a";
                            dateFormatTitle = "Order Date Time: ";
                        }
                        if (dateTimeMode.equalsIgnoreCase("time")) {
                            dateFormat = "hh:mm a";
                            dateFormatTitle = "Order Time: ";
                        }
                        if (dateTimeMode.equalsIgnoreCase("date")) {
                            dateFormat = "dd-MM-yyyy";
                            dateFormatTitle = "Order Date: ";
                        }

                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    }
*/
                    }
                if (structure.order_time != null)
                    if (structure.order_time.visibility) {
                        if (!Validators.isNullOrEmpty(orderTime))
                            if (structure.order_time != null) {
                                if (structure.order_time.visibility) {
                                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Time :" + orderTime + " ", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                }
                            } else {
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Time :" + orderTime, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            }
                    }

                if (orderType > 1 && !kitchenCopy) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order Type: " + orderDetail.order_type, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.items_header.visibility) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Qty Name", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }

                if (structure.items.visibility) {
                    String itemName = "", price = "", qty = "";
                    String lastBlockId = null;
                    boolean lastItemWasMisc = false;

                    for (OrderItem productDetail : orderDetail.order_items) {
                        String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                        //String productQty = String.valueOf(productDetail.quantity);
                        String productQty;
                        if (kitchenCopy) {
                            productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                        } else {
                            productQty = String.valueOf(productDetail.quantity);
                        }
                        // Here we need 16 characters in product name so we send 16 in
                        // @params charactersInLine
                        price = (!kitchenCopy) ? MyApp.df.format(productDetail.total) : "";
                        if (!kitchenCopy)
                            itemName = getProductNameWithPad(productName, price, 35);
                        else
                            itemName = productName;
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + " ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + "  ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "";
                        }
                        if (lastBlockId != null) {
                            if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "---------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                            }
                        } else {
                            if (lastItemWasMisc && !productDetail.misc) {
                                if (kitchenCopy)
                                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "---------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                            }
                        }

                        String printItem;
                        printItem = qty + itemName;
                        if (!kitchenCopy) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "  " + "Instruction: " + productDetail.special_instruction, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        } else {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "  " + "Instruction: " + productDetail.special_instruction, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        }

                        if (productDetail.order_item_addons.size() > 0) {
                            if (structure.items_subaddon.visibility) {
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Choose Your Base:" + productDetail.special_instruction, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            }

                            for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                    continue;
                                }
                                productQty = orderItemAddon.quantity + "";
                                productName = orderItemAddon.addon_name + "";
                                price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                                if (!kitchenCopy)
                                    itemName = getProductNameWithPad(productName, price, 35);
                                else
                                    itemName = productName;
                                qty = productQty;
                                if (productQty.length() <= 1) {
                                    qty = " " + productQty + " ";
                                } else if (productQty.length() <= 2) {
                                    qty = productQty + "  ";

                                } else if (productQty.length() <= 3) {
                                    qty = productQty + " ";

                                } else if (productQty.length() <= 4) {
                                    qty = productQty + "";
                                }
                                printItem = qty + itemName.trim();
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                               /* if (!kitchenCopy) {
                                    String subdomainPrintText = "   " + orderItemAddon.addon_name.replace(MyApp.currencySymbol, "");
                                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                                } else {
                                    String subdomainPrintText = "   " + orderItemAddon.addon_name.replace(MyApp.currencySymbol, "");
                                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                                }*/
                            }
                        }

                        for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                            String ingredientName = orderItemIngredient.ingredient_name;
                            if (orderItemIngredient.with) {
                                ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                            }
                            if (orderItemIngredient.without) {
                                ingredientName = "  " + "No " + ingredientName;
                            }
                            String subdomainPrintText = ingredientName;
                            if (!kitchenCopy) {
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                            } else {
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                            }
                        }

                        lastItemWasMisc = productDetail.misc;
                        lastBlockId = productDetail.block_id;
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (printTotalInPrint) {
                    if (structure.subtotal.visibility) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("SubTotal :", 1) + MyApp.df.format(orderDetail.sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                    }

                    if (structure.gratuity.visibility) {
                        if (orderDetail.gratuity > 0) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Gratuity :", 1) + MyApp.df.format(orderDetail.gratuity), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        }
                    }

                    if (structure.discount.visibility) {
                        if (orderDetail.discount > 0) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Discount :", 1) + MyApp.df.format(orderDetail.discount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        }
                    }

                    if (structure.delivery_charge.visibility) {
                        if (orderDetail.delivery_charge > 0) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Delivery charge :", 1) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        }
                    }

                    if (structure.service_charge.visibility) {
                        if (orderDetail.service_charge > 0) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Service charge :", 1) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                        }
                    }

                    if (structure.grand_total.visibility) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Total : " + MyApp.df.format(orderDetail.total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                    }

                    if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                            structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }

/*
                if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Details:", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    for (OrderPayment orderPayment : orderDetail.order_payments) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderPayment.payment_method_name + " Payment : " + orderPayment.amount, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
*/
                if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0)
                    if (structure.payment_detail_header.visibility) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Details:  ", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }

                if (structure.payment_detail.visibility) {
                    for (OrderPayment orderPayment : orderDetail.order_payments) {
                        String paymentDetailToPrint = null;
                        if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                            paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                        } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                            paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                        } else {
                            paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                        }
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, paymentDetailToPrint, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                } else {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.serve_by.visibility) {
                    String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, toprint, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }

                if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust Name:" + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }

                if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust No:" + orderDetail.customer.mobile, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }

                if (orderType == 3) {
                    String fulladdress = "Address : " + orderDetail.customer.house_no + ","
                            + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                            orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, fulladdress, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }

                if (structure.payment_status.visibility) {
                    if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Status: " + settingMap.get("unpaid_payment_title"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Status: " + settingMap.get("paid_payment_title"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Status: " + settingMap.get("partial_payment_title"), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                    if (kitchenCopy) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comment: " + orderDetail.comment, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                    } else {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comment: " + orderDetail.comment, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (structure.footer_order_type.visibility && kitchenCopy) {
                    if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "** " + orderTypeHeading + " **", WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                    }

                }
                // footer table number
                if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                    if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Table No: " + orderDetail.table_number + "\n", WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                    }
                }

                // footer order number
                if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                    if (orderDetail._id != 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order No: " + orderDetail._id + "\n", WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                    }
                }

                if (structure.footer.visibility) {
                    if (!Validators.isNullOrEmpty(footerA)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerA, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                    if (!Validators.isNullOrEmpty(footerB)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerB, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
//                if (isCashDrawerOpen) {
//                    openCashDrawer(false);
//                }
                printingStatus = 0;
                LogUtils.e("PRINT::", "END");
                disconnect();
                LogUtils.e("PRINT::", "DISCONNECT");

                // prepare send wifi model to order device to listen start
                SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
                SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
                sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
                sendOrderWifiModel.setTitle(title != null ? title : "");
                sendOrderWifiModel.setTicketHeaderSetting(ticket_header != null ? ticket_header : "");
                sendOrderWifiModel.setHeaderAlignment(headerAlignment);
                sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
                sendOrderWifiModel.setOrderDetail(orderDetail);
                sendOrderWifiModel.setPrintStructure(structure);
                sendOrderWifiModel.setFooterA(footerA != null ? footerA : "");
                sendOrderWifiModel.setFooterB(footerB != null ? footerB : "");
                sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading != null ? orderTypeHeading : "");
                sendOrderWifiModel.setSettingsMap(settingMap);
                sendOrderWifiModel.setKitchen(kitchenCopy);
                if (printBlockBill != null) {
                    sendOrderWifiModel.setPrintBlockBill(printBlockBill);
                }
                sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOS);
                sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username != null ? MyApp.getInstance().myPreferences.getLoggedInUser().username : "");
                sendOrderToWifi(sendOrderWifiModel);
            } catch (Exception e) {
                e.printStackTrace();
                // prepare send wifi model to order device to listen start
                SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
                SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
                sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
                sendOrderWifiModel.setTitle(title != null ? title : "");
                sendOrderWifiModel.setTicketHeaderSetting(ticket_header != null ? ticket_header : "");
                sendOrderWifiModel.setHeaderAlignment(headerAlignment);
                sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
                sendOrderWifiModel.setOrderDetail(orderDetail);
                sendOrderWifiModel.setPrintStructure(structure);
                sendOrderWifiModel.setFooterA(footerA != null ? footerA : "");
                sendOrderWifiModel.setFooterB(footerB != null ? footerB : "");
                sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading != null ? orderTypeHeading : "");
                sendOrderWifiModel.setSettingsMap(settingMap);
                sendOrderWifiModel.setKitchen(kitchenCopy);
                if (printBlockBill != null) {
                    sendOrderWifiModel.setPrintBlockBill(printBlockBill);
                }
                sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOS);
                sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username != null ? MyApp.getInstance().myPreferences.getLoggedInUser().username : "");
                sendOrderToWifi(sendOrderWifiModel);
                LogUtils.e("PRINT::", "error while printing epos order");
                LogUtils.e(Log.getStackTraceString(e));
                printingStatus = 0;
                if (wifiCommunication != null && ip != null) {
                    wifiCommunication.initSocket(ip, 9100);
                }
            }
        }).start();
    }

    public void printOrderEpos(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, boolean printTotalInPrint, String footerA, String footerB, String footerHeading, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        new Thread(() -> {
            try {
                try {

                } catch (Exception e) {
                    e.printStackTrace();
                }
                //if(connectionFlag!=1) return;
                int orderType = -1;
                if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
                    orderType = 0;
                } else {
                    orderType = Integer.parseInt(orderDetail.order_type_id);
                }
                LogUtils.e("PRINT::", "START");
                LogUtils.e("PRINT::", kitchenCopy ? "Kitchen ma" : "No int kitchen", "Header:", ticket_header);
                wifiCommunication.sndByte(ByteCommand.ESC_Init);
                printingStatus = 1;
                WifiPrinterUtil.getInstance().printText(wifiCommunication, "\n", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (!kitchenCopy && tiffintomLogo != null) {
                    WifiPrinterUtil.getInstance().printBitmap(wifiCommunication, CENTER, tiffintomLogo, 340, 0);
                }
                if (!kitchenCopy) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, ticket_header, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, headerAlignment);
                }
                if (kitchenCopy) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "** " + footerHeading + " **", WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                    LogUtils.e("PRINT::", "** " + orderDetail.order_type + " **");
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE2, WifiPrinterUtil.FontSize.SIZE2, false, false, CENTER);
                    }
                    LogUtils.e("PRINT::", orderDetail.customer_name);
                }

                if (!Validators.isNullOrEmpty(title)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, title, WifiPrinterUtil.FontSize.SIZE1, false, false, CENTER);
                }
                String tableNumberOrderIdText = "";
                if (tableNumberOrderIdMode != null) {
                    if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                        if (Validators.isNullOrEmpty(orderDetail.id)) {
                            tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                        } else
                            tableNumberOrderIdText = "Order ID: " + orderDetail.id;

                    }
                    if (orderType == 1 && (tableNumberOrderIdMode.equalsIgnoreCase("table_number") || tableNumberOrderIdMode.equalsIgnoreCase("both"))) {
                        if (tableNumberOrderIdText.length() > 1) {
                            tableNumberOrderIdText = tableNumberOrderIdText + "\n";
                        }
                        tableNumberOrderIdText = tableNumberOrderIdText + "Table No: " + orderDetail.table_number + "  No of Diners:  " + orderDetail.no_guest;

                    }
                    if (tableNumberOrderIdMode.equalsIgnoreCase("none")) {
                        tableNumberOrderIdText = "";
                    }
                    if (tableNumberOrderIdText.length() > 0) {
                        if (!Validators.isNullOrEmpty(title))
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, tableNumberOrderIdText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    }
                }

                if (!Validators.isNullOrEmpty(dateTimeMode)) {
                    String dateFormat = "dd-MM-yyyy hh:mm a";
                    String dateFormatTitle = "Order Date Time: ";
                    if (dateTimeMode.equalsIgnoreCase("date_time")) {
                        dateFormat = "dd-MM-yyyy hh:mm a";
                        dateFormatTitle = "Order Date Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("time")) {
                        dateFormat = "hh:mm a";
                        dateFormatTitle = "Order Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("date")) {
                        dateFormat = "dd-MM-yyyy";
                        dateFormatTitle = "Order Date: ";
                    }

                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                }
                if (orderType > 1 && !kitchenCopy) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order Type: " + orderDetail.order_type, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Qty Name", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                String itemName = "", price = "", qty = "";

                String lastBlockId = null;
                boolean lastItemWasMisc = false;

                for (OrderItem productDetail : orderDetail.order_items) {
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                    String productQty = String.valueOf(productDetail.quantity);
                    // Here we need 16 characters in product name so we send 16 in
                    // @params charactersInLine
                    price = (!kitchenCopy) ? MyApp.df.format(productDetail.total) : "";
                    if (!kitchenCopy)
                        itemName = getProductNameWithPad(productName, price, 35);
                    else
                        itemName = productName;
                    qty = productQty;
                    if (productQty.length() <= 1) {
                        qty = " " + productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + "  ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }
                    if (lastBlockId != null) {
                        if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                            if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "---------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        }
                    } else {
                        if (lastItemWasMisc && !productDetail.misc) {
                            if (kitchenCopy)
                                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "---------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        }
                    }

                    String printItem;
                    printItem = qty + itemName;
                    if (!kitchenCopy) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "  " + "Instruction: " + productDetail.special_instruction, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    } else {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE1, true, false, LEFT);
                        if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "  " + "Instruction: " + productDetail.special_instruction, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                    }


                    for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                        List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                        if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                            continue;
                        }

                        productQty = orderItemAddon.quantity + "";
                        productName = orderItemAddon.addon_name + "";
                        price = (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) ? "" : MyApp.df.format(orderItemAddon.total);
                        if (!kitchenCopy)
                            itemName = getProductNameWithPad(productName, price, 35);
                        else
                            itemName = productName;
                        qty = productQty;
                        if (productQty.length() <= 1) {
                            qty = " " + productQty + " ";
                        } else if (productQty.length() <= 2) {
                            qty = productQty + "  ";

                        } else if (productQty.length() <= 3) {
                            qty = productQty + " ";

                        } else if (productQty.length() <= 4) {
                            qty = productQty + "";
                        }
                        printItem = qty + itemName.trim();
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, printItem, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        /*if (!kitchenCopy) {
                            String subdomainPrintText = "   " + orderItemAddon.addon_name.replace(MyApp.currencySymbol, "");
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        } else {
                            String subdomainPrintText = "   " + orderItemAddon.addon_name.replace(MyApp.currencySymbol, "");
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        }*/
                    }

                    for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                        String ingredientName = orderItemIngredient.ingredient_name;
                        if (orderItemIngredient.with) {
                            ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                        }
                        if (orderItemIngredient.without) {
                            ingredientName = "  " + "No " + ingredientName;
                        }
                        String subdomainPrintText = ingredientName;
                        if (!kitchenCopy) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        } else {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, subdomainPrintText, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, true, false, LEFT);
                        }
                    }

                    lastItemWasMisc = productDetail.misc;
                    lastBlockId = productDetail.block_id;
                }

                if (printTotalInPrint) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("SubTotal :", 1) + MyApp.df.format(orderDetail.sub_total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                    if (orderDetail.delivery_charge > 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Delivery charge :", 1) + MyApp.df.format(orderDetail.delivery_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                    }
                    if (orderDetail.gratuity > 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Gratuity :", 1) + MyApp.df.format(orderDetail.gratuity), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                    }
                    if (orderDetail.service_charge > 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Service charge :", 1) + MyApp.df.format(orderDetail.service_charge), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                    }
                    if (orderDetail.discount > 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, padRightSpaces("Discount :", 1) + MyApp.df.format(orderDetail.discount), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, RIGHT);
                    }

                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Grand Total : " + MyApp.df.format(orderDetail.total), WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE1, true, false, RIGHT);
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {

                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Details:", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                    for (OrderPayment orderPayment : orderDetail.order_payments) {
                        if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, " Paid Via Voucher: : " + orderPayment.amount, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        } else {
                            WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, orderPayment.payment_method_name + " Payment : " + orderPayment.amount, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                        }
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }

                String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, toprint, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);

                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (!Validators.isNullOrEmpty(orderDetail.customer_name)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust Name:" + orderDetail.customer_name, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }

                if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Cust No:" + orderDetail.customer.mobile, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                if (orderType == 3) {
                    String fulladdress = "Address : " + orderDetail.customer.house_no + ","
                            + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                            orderDetail.customer.country + ", " + orderDetail.customer.postcode;
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, fulladdress, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == -1) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Status: Unpaid", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 1) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Status: Paid", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                } else if (CommonFunctions.orderPaymentStatus(orderDetail.total, orderDetail.total_paid) == 0) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Payment Status: Partially Paid", WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                }
                WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                    if (kitchenCopy) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comment: " + orderDetail.comment, WifiPrinterUtil.FontSize.SIZE1, WifiPrinterUtil.FontSize.SIZE1, false, false, LEFT);
                    } else {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Comment: " + orderDetail.comment, WifiPrinterUtil.FontSize.SIZE0, WifiPrinterUtil.FontSize.SIZE0, false, false, LEFT);
                    }
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                if (kitchenCopy) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "** " + footerHeading + " **", WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                }

                // footer table number
                if (kitchenCopy) {
                    if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "------------------------------------------------", WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Table No: " + orderDetail.table_number + "\n", WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                    }
                }

                // footer order number
                if (kitchenCopy) {
                    if (orderDetail._id != 0) {
                        WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, "Order No: " + orderDetail._id + "\n", WifiPrinterUtil.FontSize.SIZE2, true, false, CENTER);
                    }
                }

                if (!Validators.isNullOrEmpty(footerA)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerA, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                if (!Validators.isNullOrEmpty(footerB)) {
                    WifiPrinterUtil.getInstance().printTextPos(wifiCommunication, footerB, WifiPrinterUtil.FontSize.SIZE0, false, false, CENTER);
                }
                // set print true for local device
                setPrint(myPreferences, true);
                WifiPrinterUtil.getInstance().CutPaper(wifiCommunication);
                if (isCashDrawerOpen) {
                    openCashDrawer(false);
                }
                printingStatus = 0;
                LogUtils.e("PRINT::", "END");
                disconnect();
                LogUtils.e("PRINT::", "DISCONNECT");

            } catch (Exception e) {
//                FirebaseCrashlytics.getInstance().recordException(e);
                e.printStackTrace();
                LogUtils.e("PRINT::", "error while printing epos order");
                LogUtils.e(Log.getStackTraceString(e));
                printingStatus = 0;
                if (wifiCommunication != null && ip != null) {
                    wifiCommunication.initSocket(ip, 9100);
                }

            }
        }).start();
    }


    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = part.split(":");

            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                }
                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(parts1[1].trim(), charatersInLine);
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim());
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine));
                    }
                }
                subAddonName = sb.toString();

            } else {
                subAddonName = "   " + padRightSpaces(part.trim(), charatersInLine);

            }

        }
        return subAddonName;
    }

    public static String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    public static String padLeftSpace(String str, int n) {
        return String.format("%1$" + n + "s", str);
    }

    private static List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    private StringBuffer getDays;
    private StringBuffer getOrderType;

    public void setDays(String string) {
        switch (string) {
            case "0":
                getDays.append("Monday, ");
                break;
            case "1":
                getDays.append("Tuesday, ");
                break;
            case "2":
                getDays.append("Wednesday, ");
                break;
            case "3":
                getDays.append("Thursday, ");
                break;
            case "4":
                getDays.append("Friday, ");
                break;
            case "5":
                getDays.append("Saturday, ");
                break;
            case "6":
                getDays.append("Sunday, ");
                break;
        }
    }

    public void setOrders(String string) {
        switch (string) {
            case "1":
                getOrderType.append("Dine In, ");
                break;
            case "2":
                getOrderType.append("Collection, ");
                break;
            case "3":
                getOrderType.append("Delivery, ");
                break;
            case "4":
                getOrderType.append("Bar, ");
                break;
            case "5":
                getOrderType.append("Waiting, ");
                break;
            case "6":
                getOrderType.append("Web Order, ");
                break;
        }
    }
}
