package com.ubsidi.epos_2021.comman.printer;

import android.content.Context;
import android.graphics.Bitmap;

import com.ubsidi.epos_2021.utils.ToastUtils;
import com.zj.wfsdk.WifiCommunication;

import java.io.UnsupportedEncodingException;

public class WifiPrinterUtil {

    public static final class Alignment {
        public static final int LEFT = 0;
        public static final int CENTER = 1;
        public static final int RIGHT = 2;

        public Alignment() {
        }
    }

    public static final class FontSize {
        public static final int SIZE0 = 0;
        public static final int SIZE1 = 1;
        public static final int SIZE2 = 2;
        public static final int SIZE3 = 3;
        public static final int SIZE4 = 4;
        public static final int SIZE5 = 5;
        public static final int SIZE6 = 6;
        public static final int SIZE7 = 7;

        public FontSize() {
        }
    }

    public Context context;

    public WifiPrinterUtil() {
    }

    public static WifiPrinterUtil getInstance() {
        return new WifiPrinterUtil();
    }

    public void CutPaper(WifiCommunication wifiCommunication) {
        if (wifiCommunication == null) return;
        try {
            wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(0, 0));
            wifiCommunication.sndByte("\n\n".getBytes("GBK"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        wifiCommunication.sndByte(ByteCommand.GS_V_m_n);
    }

    public void CashDrawer(Context context, WifiCommunication wifiCommunication) {
        if (wifiCommunication == null) {
            ToastUtils.makeSnackToast(context, "Printer null");
            return;
        }
        wifiCommunication.sndByte(ByteCommand.ESC_Init);
        wifiCommunication.sndByte(ByteCommand.ESC_DRAWER_KICK_OUT);
        wifiCommunication.sndByte(ByteCommand.ESC_DRAWER_KICK_OUT1);
    }

    public void printText(WifiCommunication wifiCommunication, String content, float size, boolean isBold, boolean isUnderLine, int alignement) {
        if (wifiCommunication == null) return;
        if (isBold) {
            wifiCommunication.sndByte(ESCUtil.boldOn());
        } else {
            wifiCommunication.sndByte(ESCUtil.boldOff());
        }
        byte[] alignmentData = ByteCommand.ESC_Align;

        if (alignement == 1) {
            alignmentData[2] = 0x01;
        } else if (alignement == 2) {
            alignmentData[2] = 0x02;
        } else {
            alignmentData[2] = 0x00;
        }

        try {
            wifiCommunication.sndByte((content).getBytes("GBK"));
            wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(0, 0));
            wifiCommunication.sndByte("\n".getBytes("GBK"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        wifiCommunication.sndByte("\n".getBytes());
    }

    public void printBitmap(Context context, WifiCommunication wifiCommunication, int alignement, Bitmap bitmap, int paperWidth, int mode) {
        if (wifiCommunication == null) return;

        byte[] alignmentData = ByteCommand.ESC_Align;

        if (alignement == 1) {
            alignmentData[2] = 0x01;
        } else if (alignement == 2) {
            alignmentData[2] = 0x02;
        } else {
            alignmentData[2] = 0x00;
        }
        wifiCommunication.sndByte(alignmentData);
        byte[] data = PrinterCommand.POS_Print_Bitmap(bitmap, paperWidth, mode);
        wifiCommunication.sndByte(data);
        try {
            wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(0, 0));
            wifiCommunication.sndByte("\n".getBytes("GBK"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void printTextPos(Context context, WifiCommunication wifiCommunication, String content, int size, boolean isBold, boolean isUnderLine, int alignement) {
        if (wifiCommunication == null) {
            ToastUtils.makeSnackToast(context, "Printer null");
            return;
        }
        if (isBold) {
//            wifiCommunication.sndByte(PrinterCommand.POS_Set_Bold(1));
        } else {
//            wifiCommunication.sndByte(PrinterCommand.POS_Set_Bold(0));
        }
        byte[] alignmentData = ByteCommand.ESC_Align;

        if (alignement == 1) {
            alignmentData[2] = 0x01;
        } else if (alignement == 2) {
            alignmentData[2] = 0x02;
        } else {
            alignmentData[2] = 0x00;
        }
        wifiCommunication.sndByte(alignmentData);
        wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(size, size));
        try {
            content.replace("\n", "");
            wifiCommunication.sndByte((content).getBytes("GBK"));
            wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(0, 0));
            if (content.contains("\n")) {
                wifiCommunication.sndByte("\n".getBytes("GBK"));
            }
            wifiCommunication.sndByte("\n".getBytes("GBK"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

    }

    public void printTextPos(WifiCommunication wifiCommunication, String content, int height, int width, boolean isBold, boolean isUnderLine, int alignement) {
        if (wifiCommunication == null) {
            return;
        }
        if (isBold) {
//            wifiCommunication.sndByte(PrinterCommand.POS_Set_Bold(1));
        } else {
//            wifiCommunication.sndByte(PrinterCommand.POS_Set_Bold(0));
        }
        byte[] alignmentData = ByteCommand.ESC_Align;

        if (alignement == 1) {
            alignmentData[2] = 0x01;
        } else if (alignement == 2) {
            alignmentData[2] = 0x02;
        } else {
            alignmentData[2] = 0x00;
        }
        wifiCommunication.sndByte(alignmentData);
        wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(width, height));
        try {
            boolean newLine = false;
            content.replace("\n", "");
            wifiCommunication.sndByte((content).getBytes("GBK"));
            wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(0, 0));
            if (newLine) {
                wifiCommunication.sndByte("\n".getBytes("GBK"));
            }
            wifiCommunication.sndByte("\n".getBytes("GBK"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

    }

    public void CashDrawer(WifiCommunication wifiCommunication) {
        if (wifiCommunication == null) {
            return;
        }
        wifiCommunication.sndByte(ByteCommand.ESC_Init);
        wifiCommunication.sndByte(ByteCommand.ESC_DRAWER_KICK_OUT);
        wifiCommunication.sndByte(ByteCommand.ESC_DRAWER_KICK_OUT1);
    }

    public void printBitmap(WifiCommunication wifiCommunication, int alignement, Bitmap bitmap, int paperWidth, int mode) {
        if (wifiCommunication == null) return;

        byte[] alignmentData = ByteCommand.ESC_Align;

        if (alignement == 1) {
            alignmentData[2] = 0x01;
        } else if (alignement == 2) {
            alignmentData[2] = 0x02;
        } else {
            alignmentData[2] = 0x00;
        }
//        wifiCommunication.sndByte(alignmentData);
//        byte[] data = PrinterCommand.POS_Print_Bitmap(bitmap, paperWidth, mode);
//        try {
//            wifiCommunication.sndByte(data);
//            wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(0, 0));
//            wifiCommunication.sndByte("\n".getBytes("GBK"));
//        } catch (UnsupportedEncodingException e) {
//            e.printStackTrace();
//        }
    }

    public void printWifiBitmap(WifiCommunication wifiCommunication, int alignement, Bitmap bitmap, int paperWidth, int mode) {
        if (wifiCommunication == null) return;
        byte[] alignmentData = ByteCommand.ESC_Align;
        if (alignement == 1) {
            alignmentData[2] = 0x01;
        } else if (alignement == 2) {
            alignmentData[2] = 0x02;
        } else {
            alignmentData[2] = 0x00;
        }
        wifiCommunication.sndByte(alignmentData);
        byte[] data = PrinterCommand.POS_Print_Bitmap(bitmap, paperWidth, mode);
        try {
            wifiCommunication.sndByte(data);
            wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(0, 0));
            wifiCommunication.sndByte("\n".getBytes("GBK"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void printTextPos(WifiCommunication wifiCommunication, String content, int size, boolean isBold, boolean isUnderLine, int alignement) {
        if (wifiCommunication == null) {
            return;
        }
        if (isBold) {
//            wifiCommunication.sndByte(PrinterCommand.POS_Set_Bold(1));
        } else {
//            wifiCommunication.sndByte(PrinterCommand.POS_Set_Bold(0));
        }
        byte[] alignmentData = ByteCommand.ESC_Align;

        if (alignement == 1) {
            alignmentData[2] = 0x01;
        } else if (alignement == 2) {
            alignmentData[2] = 0x02;
        } else {
            alignmentData[2] = 0x00;
        }
        wifiCommunication.sndByte(alignmentData);
        wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(size, size));
        try {
            boolean newLine = false;
            content.replace("\n", "");
            wifiCommunication.sndByte((content).getBytes("GBK"));
            wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(0, 0));
            if (newLine) {
                wifiCommunication.sndByte("\n".getBytes("GBK"));
            }
            wifiCommunication.sndByte("\n".getBytes("GBK"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

    }

    public void printTextByte(WifiCommunication wifiCommunication, String content, int size, boolean isBold, boolean isUnderLine, int alignement) {
        if (wifiCommunication == null) return;
        if (isBold) {
            ByteCommand.GS_ExclamationMark[2] = 0x10;
////            wifiCommunication.sndByte(PrinterCommand.POS_Set_Bold(1));
        } else {
            ByteCommand.GS_ExclamationMark[2] = 0x00;
////            wifiCommunication.sndByte(PrinterCommand.POS_Set_Bold(0));
        }
        wifiCommunication.sndByte(ByteCommand.GS_ExclamationMark);

        ByteCommand.ESC_Align[2] = (byte) alignement;
        wifiCommunication.sndByte(ByteCommand.ESC_Align);

//        wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(size, size));
        try {
            content.replace("\n", "");
            wifiCommunication.sndByte((content).getBytes("GBK"));
            wifiCommunication.sndByte(PrinterCommand.POS_Set_FontSize(0, 0));
            if (content.contains("\n")) {
                wifiCommunication.sndByte("\n".getBytes("GBK"));
            }
            wifiCommunication.sndByte("\n".getBytes("GBK"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        wifiCommunication.sndByte("\n".getBytes());
    }
}
