package com.ubsidi.epos_2021.comman.printer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.Log;

import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.ReportTextModel;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SalesReport;
import com.ubsidi.epos_2021.models.SendOrderWifiModel;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.SurChargesModel;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.models.OrderProductDetail;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.zqprintersdk.PrinterConst;
import com.zqprintersdk.ZQPrinterSDK;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;

public class ZoneRichPrinter {

    public ZQPrinterSDK zonerich;
    public int nRet = -1;
    public Activity activity;
    public SiteSetting printBlockBill = MyApp.getInstance().findSetting("print_block_bill");

    public ZoneRichPrinter(Activity activity) {
        super();
        this.activity = activity;
        zonerich = new ZQPrinterSDK();
    }

    public void connectPrinter(String ip) {
        try {
            // Check for connectivity
            if (nRet == PrinterConst.ErrorCode.SUCCESS) // 0 == Success
            {
                // already connected
                if (zonerich != null) {
                    disconnectPrinter();
                    nRet = zonerich.Prn_Connect(ip + ":9100", activity);
                } else {
                    // re configuration of SDK
                    zonerich = new ZQPrinterSDK();
                    nRet = zonerich.Prn_Connect(ip + ":9100", activity);
                }
            } else {
                // connect printer at first time
                nRet = zonerich.Prn_Connect(ip + ":9100", activity);
            }
            //writeToSDFile("PrinterConst is " + nRet, "zonerichPrinterConst.txt");
        } catch (Exception e) {
            //writeToSDFile("Connect exception is " + e.toString(), "zonerichconnectionexception.txt");
            LogUtils.e("Zonerich Connection error", e.toString());
            ToastUtils.makeToast(activity, e.toString());
        }
    }

    private void writeToSDFile(String text, String fileName) {

        // Find the root of the external storage.
        // See http://developer.android.com/guide/topics/data/data-  storage.html#filesExternal

        File root = android.os.Environment.getExternalStorageDirectory();

        // See http://stackoverflow.com/questions/3551821/android-write-to-sd-card-folder
        File dir = new File(root.getAbsolutePath() + "/download");
        dir.mkdirs();
        File file = new File(dir, fileName);

        try {
            FileOutputStream f = new FileOutputStream(file);
            PrintWriter pw = new PrintWriter(f);
            pw.println(text);
            pw.flush();
            pw.close();
            f.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void disconnectPrinter() {
        zonerich.Prn_Disconnect();
    }

    public void openCashDrawer() {
        zonerich.Prn_OpenCashbox();
        disconnectPrinter();
    }

    public void printDemo() {
        zonerich.Prn_PrintText("Left Line", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        zonerich.Prn_PrintText("Right Line", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        zonerich.Prn_PrintText("Center Line", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        zonerich.Prn_PrintText("Bold Left Line", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        zonerich.Prn_PrintText("Bold Right Line", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        zonerich.Prn_PrintText("Bold Center Line", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        zonerich.Prn_CutPaper();
        disconnectPrinter();

    }

    private void setPrint(MyPreferences myPreferences, boolean isPrint) {
        myPreferences.saveIsPrintBill(isPrint);
    }

    public void printMotoReceipt(Bitmap bm, String title, String header, int headerAlignment, String amount, String main_content, String date_final, String please, String footer, String footer1, MyPreferences myPreferences) {
        try {
            if (bm != null) {
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(bm, PrinterConst.BitmapSize.ZQSIZE0);
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            if (headerAlignment < 2)
                zonerich.Prn_PrintText(header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            else {
                String[] headers = header.split("\n");
                for (String h : headers) {
                    zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            zonerich.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);

            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            amount = amount.replace("£", "");
            amount = amount.replace("\n", "");
            amount = amount + " GBP";

            zonerich.Prn_PrintText(amount + "\n\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
            zonerich.Prn_PrintText(main_content + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText(date_final + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText(please + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText(footer + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText(footer1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);
            // set print true for local device
            setPrint(myPreferences, true);
            zonerich.Prn_CutPaper();
            disconnectPrinter();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printCardReaderReceipt(Bitmap tiffintomLogo, String rePrintTitle, String title, String header, String header1, int headerAlignment, String actual_amount, String tip_amount, String grand_total, String main_content, String please, String final_date, String footer, String footer1, MyPreferences myPreferences) {
        if (tiffintomLogo != null) {
            zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
            zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        }
        if (!Validators.isNullOrEmpty(header)) {
            if (headerAlignment < 2)
                zonerich.Prn_PrintText(header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            else {
                String[] headers = header.split("\n");
                for (String h : headers) {
                    zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
        }
        if (!Validators.isNullOrEmpty(header1)) {
            if (headerAlignment < 2)
                zonerich.Prn_PrintText(header1 + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            else {
                String[] headers = header1.split("\n");
                for (String h : headers) {
                    zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
        }
        if (!Validators.isNullOrEmpty(rePrintTitle)) {
            zonerich.Prn_PrintText(rePrintTitle + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
        }
        zonerich.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);

        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        if (!Validators.isNullOrEmpty(tip_amount)) {
            actual_amount = actual_amount.replace("£", "");
            actual_amount = actual_amount + " GBP";
            zonerich.Prn_PrintText(actual_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);

            tip_amount = tip_amount.replace("£", "");
            tip_amount = tip_amount + " GBP";
            zonerich.Prn_PrintText(tip_amount + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE0);
        }
        grand_total = grand_total.replace("£", "");
        grand_total = grand_total + " GBP";

        zonerich.Prn_PrintText(grand_total + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
        zonerich.Prn_PrintText(main_content + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText(please + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText(final_date + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText(footer + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText(footer1 + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_LineFeed(3);
        // set print true for local device
        setPrint(myPreferences, true);
        zonerich.Prn_CutPaper();
        disconnectPrinter();
    }

    DecimalFormat formatter = (DecimalFormat) NumberFormat.getNumberInstance(Locale.US);

    public Bitmap addPaddingLeftForBitmap(Bitmap bitmap, int paddingLeft) {
        Bitmap outputBitmap = Bitmap.createBitmap(bitmap.getWidth() + paddingLeft, bitmap.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(outputBitmap);
        canvas.drawBitmap(bitmap, paddingLeft, 0, null);
        return outputBitmap;
    }

    public void printOrderFoodHub(ArrayList<PrintStyle> listPrintStructure, List<PrintSetting> printSettings, Bitmap tiffintomLogo, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, MyPreferences myPreferences, boolean orderTiffinTomLogo, String onlineOrderPrintCount, String defaultIp, Callable<Void> nextMethod) {
        int style, widthSize, heightSize, alignment;
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }
        formatter.applyPattern("0.00");
        try {
            if (!orderTiffinTomLogo) {
                if (tiffintomLogo != null) {
                    LogUtils.e("PRINT::", "Tiffintom Logo printing");
                    zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                    zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                    zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                } else {
                    LogUtils.e("PRINT::", "Tiffintom Logo null");
                }
            } else {
                if (businessLogo != null) {
                    LogUtils.e("PRINT::", "Tiffintom Logo printing");
                    zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                    zonerich.Prn_PrintBitmap(businessLogo, PrinterConst.BitmapSize.ZQSIZE0);
                    zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                } else {
                    LogUtils.e("PRINT::", "Tiffintom Logo null");
                }
            }

            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                Log.e("listPrintStructure", "listPrintStructure " + listPrintStructure.get(i).style + " size " + listPrintStructure.get(i).toString());
                switch (listPrintStructure.get(i).style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }
                switch (listPrintStructure.get(i).size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }
                switch (listPrintStructure.get(i).alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                boolean isSeparator = listPrintStructure.get(i).separator;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean priceInItems = listPrintStructure.get(i).price;
                switch (key) {
                    case "online_title": {
                        String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                        String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                        if (!todayDate.equalsIgnoreCase(orderDateString)) {
                            zonerich.Prn_PrintText("This order is not for today" + "\n", alignment, style, heightSize | widthSize);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_site": {
                        zonerich.Prn_PrintText("Tiffintom.com sent you order" + "\n", alignment, style, heightSize | widthSize);
                        break;
                    }
                    case "online_order_type": {
                        zonerich.Prn_PrintText(CommonFunctions.getOnlineOrderType(orderType) + "\n", alignment, style, heightSize | widthSize);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_no": {
                        zonerich.Prn_PrintText("ORDER NO:" + orderDetail.order_number + "\n", alignment, style, heightSize | widthSize);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_date": {
                        if (orderType > 0) {
                            if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                                zonerich.Prn_PrintText("ASAP" + "\n", alignment, style, heightSize | widthSize);
                            } else {
                                zonerich.Prn_PrintText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n",
                                        alignment, style, heightSize | widthSize);
                            }
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_items": {
                        String itemName = "", price = "", qty = "", printBlockId = null;
                        int position = 0;
                        int productPosition = 0;
                        boolean isLastContainsLine = false;
                        for (OrderProductDetail productDetail : orderDetail.cart_view) {
                            position = position + 1;
                            productPosition = productPosition + 1;
                            if (printBlockId == null) {
                                printBlockId = productDetail.print_block_id;
                            }
                            if (printBlockId != null && productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                                printBlockId = productDetail.print_block_id;
                                if (orderDetail.cart_view.size() - 1 == productPosition) {
                                    isLastContainsLine = true;
                                }
                                zonerich.Prn_PrintText("------------------------------------------------\n",
                                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                            }
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                            String productQty = String.valueOf(productDetail.quantity);
                            // Here we need 16 characters in product name so we send 16 in
                            // @params charactersInLine
                            qty = productQty;
                            if (productQty.length() <= 1) {
                                qty = " " + productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }
                            //price = (!kitchenCopy) ? formatter.format(productDetail.total_price) : "";
                            price = priceInItems ? formatter.format(productDetail.total_price) : "";
                            if (widthSize == PrinterConst.WidthSize.SIZE1 || widthSize == PrinterConst.WidthSize.SIZE0) {
                                String[] productNameSplit = productName.split(" ");
                                String finalPrice = "  " + price.trim();
                                String secondLine = qty;
                                int lengthForSize = widthSize == PrinterConst.WidthSize.SIZE0 ? 48 : 24;
                                int multiplyLength = 1;
                                int index = 0;
                                for (String s : productNameSplit) {
                                    index = index + 1;
                                    Log.e("finalPrice", "secondLine " + secondLine + " string to apend " + productName);
                                    if (secondLine.length() < (multiplyLength * lengthForSize)) {
                                        if ((secondLine + " " + s + finalPrice).length() > (multiplyLength * lengthForSize)) {
                                            //secondLine = secondLine+secondLine.replace(,"");
                                            int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                                            if (multiplyLength == 1) {
                                                emptySpaceLength = emptySpaceLength - finalPrice.length();
                                                for (int space = 0; space < emptySpaceLength; space++) {
                                                    secondLine = secondLine + (" ");
                                                }
                                                secondLine = secondLine + finalPrice;
                                            } else {
                                                for (int space = 0; space < emptySpaceLength; space++) {
                                                    secondLine = secondLine + (" ");
                                                }
                                            }
                                            multiplyLength = multiplyLength + 1;
                                            secondLine = secondLine + ("\n");
                                            for (int j = 0; j < qty.length(); j++) {
                                                secondLine = secondLine + (" ");
                                            }
                                        }
                                    } else {
                                        multiplyLength = multiplyLength + 1;
                                        secondLine = secondLine + ("\n");
                                        for (int j = 0; j < qty.length(); j++) {
                                            secondLine = secondLine + (" ");
                                        }
                                    }
                                    secondLine = secondLine + " " + s;
                                    //if(productNameSplit.length==1 && multiplyLength==1 &&secondLine.length() < (multiplyLength * lengthForSize)){
                                    if (productNameSplit.length == index && multiplyLength == 1 && secondLine.length() < (multiplyLength * lengthForSize)) {
                                        if (multiplyLength == 1) {
                                            int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                                            emptySpaceLength = emptySpaceLength - finalPrice.length();
                                            for (int space = 0; space < emptySpaceLength; space++) {
                                                secondLine = secondLine + (" ");
                                            }
                                            secondLine = secondLine + finalPrice;
                                        }
                                    }
                                }
                                itemName = secondLine;
                            } else {
                                itemName = getProductNameWithPad(productName, price, 35);
                            }
                            String printItem;
                            printItem = itemName+ "\n";
                            Log.e("printItemprintItem","printItem "+printItem);
                            //printItem = qty + itemName + "\n";
                            if (!kitchenCopy)
                                zonerich.Prn_PrintText(printItem, alignment, style, heightSize | widthSize);
                            else
                                zonerich.Prn_PrintText(printItem, alignment, style, heightSize | widthSize);

                            if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                                try {
                                    //String[] parts = menus.get(position).getSubaddonsName().split(",");
                                    String[] parts = productDetail.subaddons_name.split(",");

                                    for (String subAddonPart : parts) {
                                        String subdomainPrintText;
                                        if (!kitchenCopy) {
                                            //subdomainPrintText = getSubaddonWithPad(" - " + subAddonPart, 35);
                                            subdomainPrintText = getSubaddonWithPad(" - " + subAddonPart, 20);
                                        } else {
                                            subdomainPrintText = getSubaddonWithPad(" - " + subAddonPart, 20);
                                        }
                                        Log.e("printItemprintItem","subdomainPrintText "+subAddonPart);
                                        zonerich.Prn_PrintText(subdomainPrintText, alignment, style, heightSize | widthSize);
                                    }
                                } catch (Exception e) {
                                    Log.e("Addon_Error", e.getMessage());
                                }
                            }
                            if (all_separator && orderDetail.cart_view.size() > position) {
                                zonerich.Prn_PrintText("------------------------------------------------\n",
                                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                            }
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_sub_total": {
                        zonerich.Prn_PrintText(formatTotal(widthSize, "SubTotal:", orderDetail.order_sub_total) + "\n",
                                alignment, style, widthSize | heightSize);
                        if (isSeparator) {
                            printSeparator();
                        }
                        /*zonerich.Prn_PrintText(padRightSpaces("SubTotal:", 20) + MyApp.df.format(orderDetail.order_sub_total) + "\n",
                                alignment, style, widthSize | heightSize);*/
                        break;
                    }
                    case "online_delivery_charge": {
                        if (orderDetail.delivery_charge > 0) {
                            zonerich.Prn_PrintText(formatTotal(widthSize, "Delivery Charge:", orderDetail.delivery_charge) + "\n",
                                    alignment, style, widthSize | heightSize);
                            if (isSeparator) {
                                printSeparator();
                            }
                           /* zonerich.Prn_PrintText(padRightSpaces("Delivery Charge:", 20) + MyApp.df.format(orderDetail.delivery_charge) + "\n",
                                    alignment, style, widthSize | heightSize);*/
                        }
                        break;
                    }
                    case "online_service_charge": {
                        if (orderDetail.service_charge > 0) {
                            if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                                zonerich.Prn_PrintText(formatTotal(widthSize, "Service Charge:", orderDetail.service_charge) + "\n",
                                        alignment, style, widthSize | heightSize);
                                if (isSeparator) {
                                    printSeparator();
                                }
                               /* zonerich.Prn_PrintText(padRightSpaces("Service Charge:", 20) + MyApp.df.format(orderDetail.service_charge) + "\n",
                                        alignment, style, widthSize | heightSize);*/
                            }
                        }
                        break;
                    }
                    case "online_driver_tip": {
                        if (orderDetail.driver_tip > 0) {
                            zonerich.Prn_PrintText(formatTotal(widthSize, "Driver Tip:", orderDetail.driver_tip) + "\n",
                                    alignment, style, widthSize | heightSize);
                            if (isSeparator) {
                                printSeparator();
                            }
                            /*zonerich.Prn_PrintText(padRightSpaces("Driver Tip:", 20) + MyApp.df.format(orderDetail.driver_tip) + "\n",
                                    alignment, style, widthSize | heightSize);*/
                        }
                        break;
                    }
                    case "online_loyalty": {
                        if (orderDetail.reward_offer > 0) {
                            zonerich.Prn_PrintText(formatTotal(widthSize, "Loyalty Point Discount:", orderDetail.reward_offer) + "\n",
                                    alignment, style, widthSize | heightSize);
                            if (isSeparator) {
                                printSeparator();
                            }
                           /* zonerich.Prn_PrintText(padRightSpaces("Loyalty Point Discount:", 20) + MyApp.df.format(orderDetail.reward_offer) + "\n",
                                    alignment, style, widthSize | heightSize);*/
                        }
                        break;
                    }
                    case "online_offer": {
                        if (orderDetail.offer_amount > 0) {
                            zonerich.Prn_PrintText(formatTotal(widthSize, "Offer:", orderDetail.offer_amount) + "\n",
                                    alignment, style, widthSize | heightSize);
                            if (isSeparator) {
                                printSeparator();
                            }
                            /*zonerich.Prn_PrintText(padRightSpaces("Offer:", 20) + MyApp.df.format(orderDetail.offer_amount) + "\n",
                                    alignment, style, widthSize | heightSize);*/
                        }
                        break;
                    }
                    case "online_grand_total": {
                        if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                            for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                                if (surChargesModel.surcharge_amount > 0) {
                                    zonerich.Prn_PrintText(formatTotal(widthSize, surChargesModel.surcharge_name + ": ", surChargesModel.surcharge_amount) + "\n",
                                            alignment, style, widthSize | heightSize);
                                   /* zonerich.Prn_PrintText(surChargesModel.surcharge_name + ": " + MyApp.df.format(surChargesModel.surcharge_amount) + "\n",
                                            alignment, PrinterConst.Font.DEFAULT, heightSize | widthSize);*/
                                }
                            }
                        }
                        zonerich.Prn_PrintText(formatTotal(widthSize, "Total: ", orderDetail.order_grand_total) + "\n",
                                alignment, style, widthSize | heightSize);
                       /* zonerich.Prn_PrintText("Total: " + MyApp.df.format(orderDetail.order_grand_total) + "\n",
                                alignment, style, heightSize | widthSize);*/
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_comment": {
                        if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                            zonerich.Prn_PrintText("Comments: " + orderDetail.order_description + "\n", alignment, style, widthSize | heightSize);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_delivery_instruction": {
                        if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                            zonerich.Prn_PrintText("Delivery Instructions: " + orderDetail.delivery_instruction + "\n", alignment, style, widthSize | heightSize);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_customer_details": {
                        zonerich.Prn_PrintText("" + orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                        if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                            zonerich.Prn_PrintText("" + orderDetail.customer_phone + "\n", alignment, style, widthSize | heightSize);
                        }
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_delivery_address": {
                        if (orderType == 1) {
                            String address = orderDetail.address + "\n";
                            String[] parts = address.split("[\\\\s,]+");
                            StringBuilder str = new StringBuilder();

                            for (String name : parts) {
                                str.append(name).append("\n");
                            }
                            //zonerich.Prn_PrintText("Del. address:" + address + "\n", alignment, style, heightSize | widthSize);
                            if (!Validators.isNullOrEmpty(address)) {
                                zonerich.Prn_PrintText("" + address + "", alignment, style, heightSize | widthSize);
                                if (isSeparator) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "online_requested_for": {
                        if (orderType >= 0) {
                            //zonerich.Prn_PrintText("Requested for:" + "\n", alignment, style, heightSize | widthSize);
                            if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                                zonerich.Prn_PrintText("Requested for: ASAP" + "\n", alignment, style, heightSize | widthSize);
                               /* zonerich.Prn_PrintText("------------------------------------------------\n",
                                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);*/
                            } else {
                                zonerich.Prn_PrintText("Requested for: " + orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n",
                                        alignment, style, heightSize | widthSize);
                            }

                            if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                                //zonerich.Prn_PrintText("Confirmed for:" + "\n", alignment, style, heightSize | widthSize);
                                zonerich.Prn_PrintText("Confirmed for: " + orderDetail.preparation + "\n", alignment, style, heightSize | widthSize);
                                //zonerich.Prn_PrintText(orderDetail.preparation + "\n", alignment, style, heightSize | widthSize);
                            }
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_payment_status": {
                        zonerich.Prn_PrintText("" + (orderDetail.payment_status.equalsIgnoreCase("np") ? "UNPAID" : "PAID") + "\n",
                                alignment, style, heightSize | widthSize);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_payment_method": {
                        String paymentName = "";
                        if (orderDetail.payment_method.equalsIgnoreCase("stripe"))
                            paymentName = "ONLINE";
                        if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                        if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                            paymentName = "WALLET";
                        if (orderDetail.payment_method.equalsIgnoreCase("paypal"))
                            paymentName = "PAYPAL";

                        zonerich.Prn_PrintText("Payment Type:  " + paymentName + "\n", alignment, style, heightSize | widthSize);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_receipt_time": {
                        zonerich.Prn_PrintText("Receipt Time:" + "\n", alignment, style, heightSize | widthSize);
                        zonerich.Prn_PrintText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", alignment, style, heightSize | widthSize);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_order_status": {
                        zonerich.Prn_PrintText("Order status: " + orderDetail.status + "\n", alignment, style, heightSize | widthSize);
                        if (isSeparator) {
                            printSeparator();
                        }
                        break;
                    }
                    case "online_restaurant_address": {
                        if (!kitchenCopy) {
                            zonerich.Prn_PrintText(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address + "\n",
                                    alignment, style, heightSize | widthSize);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_failed_reason": {
                        if (orderDetail.status.equalsIgnoreCase("failed")) {
                            zonerich.Prn_PrintText("Reason: " + orderDetail.failed_reason + "\n", alignment, style, heightSize | widthSize);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "online_footer": {
                        if (!kitchenCopy) {
                            zonerich.Prn_PrintText("Thanks!" + "\n", alignment, style, heightSize | widthSize);
                            if (isSeparator) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                }
            }
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);

            // set print true for local device
            setPrint(myPreferences, true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();

            if (kitchenCopy) {
                Log.e("onlineOrderPrintCount", "onlineOrderPrintCount " + onlineOrderPrintCount);
                if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                    //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                    //zonerich.Prn_Disconnect();
                    CommonFunctions.functionThatDelay(400);
                    connectPrinter(defaultIp);
                    CommonFunctions.functionThatDelay(400);
                    int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                    onlineOrderPrint = onlineOrderPrint - 1;
                    printOrderFoodHub(listPrintStructure, printSettings, tiffintomLogo, businessLogo, orderDetail, kitchenCopy, myPreferences, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), defaultIp, nextMethod);

                    //}
                } else {
                    //zonerich.Prn_Disconnect();
                    nextMethod.call();
                }
            } else {
                nextMethod.call();
                //zonerich.Prn_Disconnect();
            }

            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            sendOrderWifiModel.setOrderDetailModel(orderDetail);
            sendOrderWifiModel.setPrintSettings(printSettings);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
            if (kitchenCopy) {
                sendOrderToWifi(sendOrderWifiModel);
            }
        } catch (Exception e) {
            try {
                if (kitchenCopy) {
                    Log.e("onlineOrderPrintCount", "onlineOrderPrintCount " + onlineOrderPrintCount);
                    if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                        //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                        zonerich.Prn_Disconnect();
                        CommonFunctions.functionThatDelay(400);
                        connectPrinter(defaultIp);
                        CommonFunctions.functionThatDelay(400);
                        int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                        onlineOrderPrint = onlineOrderPrint - 1;
                        printOrderFoodHub(listPrintStructure, printSettings, tiffintomLogo, businessLogo, orderDetail, kitchenCopy, myPreferences, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), defaultIp, nextMethod);

                        //}
                    } else {
                        zonerich.Prn_Disconnect();
                        nextMethod.call();
                    }
                    Log.e("onlineOrderPrintCount", "onlineOrderPrintCountisNullOrEmpty " + (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 0));
                } else {
                    nextMethod.call();
                    zonerich.Prn_Disconnect();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            sendOrderWifiModel.setOrderDetailModel(orderDetail);
            sendOrderWifiModel.setPrintSettings(printSettings);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
            if (kitchenCopy) {
                sendOrderToWifi(sendOrderWifiModel);
            }
            System.out.println(e);
        }
    }

    private String formatTotal(int widthSize, String titleOfTotal, float totalValue) {
        String formattedValue = "";
        formattedValue = MyApp.df.format(totalValue);
        if (!Validators.isNullOrEmpty(formattedValue)) {
            int length = formattedValue.length();
            String price = null;
            if (length <= 7 && length > 2) {
                if (length == 4) {
                    price = "    " + formattedValue;
                }
                if (length == 5) {
                    price = "   " + formattedValue;
                }

                if (length == 6) {
                    price = "  " + formattedValue;
                }
                if (length == 7) {
                    price = " " + formattedValue;
                }
            } else {
                price = formatter.format(totalValue);
            }
            String finalTitleToPrint = "";
            if (length == 3) {
                if (widthSize == PrinterConst.WidthSize.SIZE1) {
                    padRightSpaces(titleOfTotal + price, 20);
                } else {
                    finalTitleToPrint = getProductNameWithPad(titleOfTotal, price, 40);
                }
            } else if (length <= 8 && length >= 4) {
                if (widthSize == PrinterConst.WidthSize.SIZE1) {
                    finalTitleToPrint = padRightSpaces(titleOfTotal, 16) + "" + price;
                } else {
                    finalTitleToPrint = getProductNameWithPad(titleOfTotal, price, 39);
                }
            } else {
                finalTitleToPrint = getProductNameWithPad(titleOfTotal, price, 38);
            }
            return finalTitleToPrint;
        }
        return "";
    }

    public void printOrder(PrintStructure structure, List<PrintSetting> printSettings, Bitmap tiffintomLogo, Bitmap businessLogo, OrderDetail orderDetail, boolean kitchenCopy, MyPreferences myPreferences, boolean orderTiffinTomLogo, String onlineOrderPrintCount, String defaultIp, Callable<Void> nextMethod) {
        int style, widthSize, heightSize, alignment;
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }
        formatter.applyPattern("0.00");
        try {
            if (!orderTiffinTomLogo) {
                if (tiffintomLogo != null) {
                    LogUtils.e("PRINT::", "Tiffintom Logo printing");
                    zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                    zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                    zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                } else {
                    LogUtils.e("PRINT::", "Tiffintom Logo null");
                }
            } else {
                if (businessLogo != null) {
                    LogUtils.e("PRINT::", "Tiffintom Logo printing");
                    zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                    zonerich.Prn_PrintBitmap(businessLogo, PrinterConst.BitmapSize.ZQSIZE0);
                    zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                } else {
                    LogUtils.e("PRINT::", "Tiffintom Logo null");
                }
            }

            if (structure.online_title.visibility) {
                switch (structure.online_title.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_title.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_title.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
                String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                if (!todayDate.equalsIgnoreCase(orderDateString)) {
                    zonerich.Prn_PrintText("This order is not for today" + "\n", alignment, style, heightSize | widthSize);
                }
            }

            if (structure.online_site.visibility) {
                switch (structure.online_site.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_site.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_site.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Tiffintom.com sent you order" + "\n", alignment, style, heightSize | widthSize);
            }

            if (structure.online_order_type.visibility) {
                switch (structure.online_order_type.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_order_type.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_order_type.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText(CommonFunctions.getOnlineOrderType(orderType) + "\n", alignment, style, heightSize | widthSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.online_order_no.visibility) {
                switch (structure.online_order_no.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_order_no.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_order_no.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("ORDER NO:" + orderDetail.order_number + "\n", alignment, style, heightSize | widthSize);
            }

            if (structure.online_order_date.visibility) {
                switch (structure.online_order_date.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_order_date.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_order_date.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                if (orderType > 0) {
                    if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                        zonerich.Prn_PrintText("ASAP" + "\n", alignment, style, heightSize | widthSize);
                    } else {
                        zonerich.Prn_PrintText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n",
                                alignment, style, heightSize | widthSize);
                    }
                    zonerich.Prn_PrintText("------------------------------------------------" + "\n",
                            PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                }
//                zonerich.Prn_PrintText(CommonFunctions.formatUnknownDateTime(orderDetail.delivery_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a dd-MM-yyyy") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
//                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
//                zonerich.Prn_PrintText("------------------------------------------------\n",
//                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.online_items.visibility) {
                switch (structure.online_items.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_items.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_items.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                String itemName = "", price = "", qty = "", printBlockId = null;
                int productPosition = 0;
                boolean isLastContainsLine = false;
                for (OrderProductDetail productDetail : orderDetail.cart_view) {
                    productPosition = productPosition + 1;
                    if (printBlockId == null) {
                        printBlockId = productDetail.print_block_id;
                    }
                    if (printBlockId != null && productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                        printBlockId = productDetail.print_block_id;
                        if (orderDetail.cart_view.size() - 1 == productPosition) {
                            isLastContainsLine = true;
                        }
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                    String productQty = String.valueOf(productDetail.quantity);
                    // Here we need 16 characters in product name so we send 16 in
                    // @params charactersInLine
                    price = (!kitchenCopy) ? formatter.format(productDetail.total_price) : "";
                    if (kitchenCopy)
                        itemName = productName;
                    else
                        itemName = getProductNameWithPad(productName, price, 35);
                    qty = productQty;
                    if (productQty.length() <= 1) {
                        qty = " " + productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }
                    String printItem;
                    printItem = qty + itemName + "\n";
                    if (!kitchenCopy)
                        zonerich.Prn_PrintText(printItem, alignment, style, heightSize | widthSize);
                    else
                        zonerich.Prn_PrintText(printItem, alignment, style, heightSize | widthSize);

                    if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                        try {
                            //String[] parts = menus.get(position).getSubaddonsName().split(",");
                            String[] parts = productDetail.subaddons_name.split(",");

                            for (String subAddonPart : parts) {
                                if (!kitchenCopy) {
                                    String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                    zonerich.Prn_PrintText(subdomainPrintText, alignment, style, heightSize | widthSize);
                                } else {
                                    String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                    zonerich.Prn_PrintText(subdomainPrintText, alignment, style, heightSize | widthSize);
                                }
                            }
                        } catch (Exception e) {
                            Log.e("Addon_Error", e.getMessage());
                        }
                    }
                }
                if (!isLastContainsLine) {
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (structure.online_sub_total.visibility) {
                switch (structure.online_sub_total.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_sub_total.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_sub_total.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText(padRightSpaces("SubTotal:", 20) + MyApp.df.format(orderDetail.order_sub_total) + "\n",
                        alignment, style, widthSize | heightSize);
            }

            if (structure.online_delivery_charge.visibility) {
                switch (structure.online_delivery_charge.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_delivery_charge.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_delivery_charge.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (orderDetail.delivery_charge > 0) {
                    zonerich.Prn_PrintText(padRightSpaces("Delivery Charge:", 20) + MyApp.df.format(orderDetail.delivery_charge) + "\n",
                            alignment, style, widthSize | heightSize);
                }
            }

            if (structure.online_service_charge.visibility) {
                switch (structure.online_service_charge.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_service_charge.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_service_charge.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (orderDetail.service_charge > 0) {
                    if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                        zonerich.Prn_PrintText(padRightSpaces("Service Charge:", 20) + MyApp.df.format(orderDetail.service_charge) + "\n",
                                alignment, style, widthSize | heightSize);
                    }
                }
            }

            if (structure.online_driver_tip.visibility) {
                switch (structure.online_driver_tip.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_driver_tip.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_driver_tip.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (orderDetail.driver_tip > 0) {
                    zonerich.Prn_PrintText(padRightSpaces("Driver Tip:", 20) + MyApp.df.format(orderDetail.driver_tip) + "\n",
                            alignment, style, widthSize | heightSize);
                }
            }

            if (structure.online_loyalty.visibility) {
                switch (structure.online_loyalty.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_loyalty.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_loyalty.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (orderDetail.reward_offer > 0) {
                    zonerich.Prn_PrintText(padRightSpaces("Loyalty Point Discount:", 20) + MyApp.df.format(orderDetail.reward_offer) + "\n",
                            alignment, style, widthSize | heightSize);
                }
            }

            if (structure.online_offer.visibility) {
                switch (structure.online_offer.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_offer.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_offer.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (orderDetail.offer_amount > 0) {
                    zonerich.Prn_PrintText(padRightSpaces("Offer:", 20) + MyApp.df.format(orderDetail.offer_amount) + "\n",
                            alignment, style, widthSize | heightSize);
                }
            }

            if (structure.online_grand_total.visibility) {
                switch (structure.online_grand_total.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_grand_total.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_grand_total.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (orderDetail.surcharges != null && !orderDetail.surcharges.isEmpty()) {
                    for (SurChargesModel surChargesModel : orderDetail.surcharges) {
                        if (surChargesModel.surcharge_amount > 0) {
                            zonerich.Prn_PrintText(surChargesModel.surcharge_name + ": " + MyApp.df.format(surChargesModel.surcharge_amount) + "\n",
                                    alignment, PrinterConst.Font.DEFAULT, heightSize | widthSize);
                        }
                    }
                }
                zonerich.Prn_PrintText("Total: " + MyApp.df.format(orderDetail.order_grand_total) + "\n",
                        alignment, style, heightSize | widthSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.online_comment.visibility) {
                switch (structure.online_comment.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_comment.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_comment.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                    zonerich.Prn_PrintText("Comments: " + orderDetail.order_description + "\n", alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (structure.online_delivery_instruction.visibility) {
                switch (structure.online_delivery_instruction.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_delivery_instruction.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_delivery_instruction.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                    zonerich.Prn_PrintText("Delivery Instructions: " + orderDetail.delivery_instruction + "\n", alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (structure.online_customer_details.visibility) {
                switch (structure.online_customer_details.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_customer_details.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_customer_details.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Cust Name:" + orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                    zonerich.Prn_PrintText("Cust No:" + orderDetail.customer_phone + "\n", alignment, style, widthSize | heightSize);
                }
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.online_delivery_address.visibility) {
                switch (structure.online_delivery_address.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_delivery_address.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_delivery_address.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                if (orderType == 1) {
                    String address = orderDetail.address + "\n";
                    String[] parts = address.split("[\\\\s,]+");
                    StringBuilder str = new StringBuilder();

                    for (String name : parts) {
                        str.append(name).append("\n");
                    }
                    zonerich.Prn_PrintText("Del. address:" + address + "\n", alignment, style, heightSize | widthSize);
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (structure.online_requested_for.visibility) {
                switch (structure.online_requested_for.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_requested_for.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_requested_for.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                if (orderType >= 0) {
                    zonerich.Prn_PrintText("Requested for:" + "\n", alignment, style, heightSize | widthSize);
                    if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                        zonerich.Prn_PrintText("ASAP" + "\n", alignment, style, heightSize | widthSize);
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    } else {
                        zonerich.Prn_PrintText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n",
                                alignment, style, heightSize | widthSize);
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }

                    if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                        zonerich.Prn_PrintText("Confirmed for:" + "\n", alignment, style, heightSize | widthSize);
                        zonerich.Prn_PrintText(orderDetail.preparation + "\n", alignment, style, heightSize | widthSize);
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }
                }
            }

            if (structure.online_payment_status.visibility) {
                switch (structure.online_payment_status.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_payment_status.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_payment_status.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n",
                        alignment, style, heightSize | widthSize);
            }

            if (structure.online_payment_method.visibility) {
                switch (structure.online_payment_method.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_payment_method.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_payment_method.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                String paymentName = "";
                if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
                if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
                if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                    paymentName = "WALLET";
                if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";

                zonerich.Prn_PrintText("Payment Type:  " + paymentName + "\n", alignment, style, heightSize | widthSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.online_receipt_time.visibility) {
                switch (structure.online_receipt_time.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_receipt_time.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_receipt_time.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Receipt Time:" + "\n", alignment, style, heightSize | widthSize);
                zonerich.Prn_PrintText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", alignment, style, heightSize | widthSize);
            }

            if (structure.online_order_status.visibility) {
                switch (structure.online_order_status.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_order_status.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_order_status.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Order status: " + orderDetail.status + "\n", alignment, style, heightSize | widthSize);
            }

            if (structure.online_restaurant_address.visibility) {
                switch (structure.online_restaurant_address.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_restaurant_address.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_restaurant_address.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address + "\n",
                        alignment, style, heightSize | widthSize);
            }

            if (structure.online_failed_reason.visibility) {
                switch (structure.online_failed_reason.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_failed_reason.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_failed_reason.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (orderDetail.status.equalsIgnoreCase("failed")) {
                    zonerich.Prn_PrintText("Reason: " + orderDetail.failed_reason + "\n", alignment, style, heightSize | widthSize);
                }
            }

            if (structure.online_footer.visibility) {
                switch (structure.online_footer.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.online_footer.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.online_footer.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Thanks!" + "\n", alignment, style, heightSize | widthSize);
            }

            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);

            // set print true for local device
            setPrint(myPreferences, true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();

            if (kitchenCopy) {
                Log.e("onlineOrderPrintCount", "onlineOrderPrintCount " + onlineOrderPrintCount);
                if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                    //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                    //zonerich.Prn_Disconnect();
                    CommonFunctions.functionThatDelay(400);
                    connectPrinter(defaultIp);
                    CommonFunctions.functionThatDelay(400);
                    int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                    onlineOrderPrint = onlineOrderPrint - 1;
                    printOrder(structure, printSettings, tiffintomLogo, businessLogo, orderDetail, kitchenCopy, myPreferences, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), defaultIp, nextMethod);

                    //}
                } else {
                    //zonerich.Prn_Disconnect();
                    nextMethod.call();
                }
            } else {
                nextMethod.call();
                //zonerich.Prn_Disconnect();
            }

            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            sendOrderWifiModel.setOrderDetailModel(orderDetail);
            sendOrderWifiModel.setPrintSettings(printSettings);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
            if (kitchenCopy) {
                sendOrderToWifi(sendOrderWifiModel);
            }
        } catch (Exception e) {
            try {
                if (kitchenCopy) {
                    Log.e("onlineOrderPrintCount", "onlineOrderPrintCount " + onlineOrderPrintCount);
                    if (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 1) {
                        //for (int i = 0; i < Integer.parseInt(onlineOrderPrintCount); i++) {
                        zonerich.Prn_Disconnect();
                        CommonFunctions.functionThatDelay(400);
                        connectPrinter(defaultIp);
                        CommonFunctions.functionThatDelay(400);
                        int onlineOrderPrint = Integer.parseInt(onlineOrderPrintCount);
                        onlineOrderPrint = onlineOrderPrint - 1;
                        printOrder(structure, printSettings, tiffintomLogo, businessLogo, orderDetail, kitchenCopy, myPreferences, orderTiffinTomLogo, String.valueOf(onlineOrderPrint), defaultIp, nextMethod);

                        //}
                    } else {
                        zonerich.Prn_Disconnect();
                        nextMethod.call();
                    }
                    Log.e("onlineOrderPrintCount", "onlineOrderPrintCountisNullOrEmpty " + (!Validators.isNullOrEmpty(onlineOrderPrintCount) && Integer.parseInt(onlineOrderPrintCount) > 0));
                } else {
                    nextMethod.call();
                    zonerich.Prn_Disconnect();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            sendOrderWifiModel.setOrderDetailModel(orderDetail);
            sendOrderWifiModel.setPrintSettings(printSettings);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDER);
            if (kitchenCopy) {
                sendOrderToWifi(sendOrderWifiModel);
            }
            System.out.println(e);
        }
    }

    public void printOrder(Bitmap tiffintomLogo, OrderDetail orderDetail, boolean kitchenCopy, MyPreferences myPreferences) {
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type)) {
            orderType = 0;
        } else if (orderDetail.order_type.equalsIgnoreCase("delivery")) {
            orderType = 1;
        } else if (orderDetail.order_type.equalsIgnoreCase("pickup")) {
            orderType = 2;
        }
        formatter.applyPattern("0.00");
        try {
            if (tiffintomLogo != null) {
                LogUtils.e("PRINT::", "Tiffintom Logo printing");
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            } else {
                LogUtils.e("PRINT::", "Tiffintom Logo null");
            }

            String todayDate = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy");
            String orderDateString = CommonFunctions.formatUnknownDateTime(orderDetail.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
            if (!todayDate.equalsIgnoreCase(orderDateString)) {
                zonerich.Prn_PrintText("This order is not for today" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
            }
            zonerich.Prn_PrintText("Tiffintom.com sent you order\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            zonerich.Prn_PrintText(CommonFunctions.getOnlineOrderType(orderType) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("ORDER NO:" + orderDetail.order_number + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);

            if (orderType > 0) {
                if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                    zonerich.Prn_PrintText("ASAP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                } else {
                    zonerich.Prn_PrintText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                }
                zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }
            String itemName = "", price = "", qty = "", printBlockId = null;
            int productPosition = 0;
            boolean isLastContainsLine = false;
            for (OrderProductDetail productDetail : orderDetail.cart_view) {
                String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.short_name)) ? productDetail.short_name : productDetail.menu_name;
                String productQty = String.valueOf(productDetail.quantity);
                // Here we need 16 characters in product name so we send 16 in
                // @params charactersInLine
                price = (!kitchenCopy) ? formatter.format(productDetail.total_price) : "";
                if (kitchenCopy)
                    itemName = productName;
                else
                    itemName = getProductNameWithPad(productName, price, 35);
                qty = productQty;
                if (productQty.length() <= 1) {
                    qty = " " + productQty + " ";
                } else if (productQty.length() <= 2) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 3) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 4) {
                    qty = productQty + "";
                }
                String printItem;
                printItem = qty + itemName + "\n";
                if (!kitchenCopy)
                    zonerich.Prn_PrintText(printItem, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                else
                    zonerich.Prn_PrintText(printItem, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);

                if (!Validators.isNullOrEmpty(productDetail.subaddons_name)) {
                    try {
                        //String[] parts = menus.get(position).getSubaddonsName().split(",");
                        String[] parts = productDetail.subaddons_name.split(",");

                        for (String subAddonPart : parts) {
                            if (!kitchenCopy) {
                                String subdomainPrintText = getSubaddonWithPad(subAddonPart, 35);
                                zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                            } else {
                                String subdomainPrintText = getSubaddonWithPad(subAddonPart, 20);
                                zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
                            }
                        }
                    } catch (Exception e) {
                        Log.e("Addon_Error", e.getMessage());
                    }
                }
                productPosition = productPosition + 1;
                if (printBlockId == null) {
                    printBlockId = productDetail.print_block_id;
                } else if (productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                    printBlockId = productDetail.print_block_id;
                }
                if (printBlockId == null) {
                    if (orderDetail.cart_view.size() - 1 == productPosition) {
                        isLastContainsLine = true;
                    }
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                } else if (productDetail.print_block_id != null && !Objects.equals(printBlockId, productDetail.print_block_id)) {
                    if (orderDetail.cart_view.size() - 1 == productPosition) {
                        isLastContainsLine = true;
                    }
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            if (!isLastContainsLine) {
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            zonerich.Prn_PrintText(padRightSpaces("SubTotal:", 20) + MyApp.df.format(orderDetail.order_sub_total) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (orderDetail.delivery_charge > 0) {
                zonerich.Prn_PrintText(padRightSpaces("Delivery Charge:", 20) + MyApp.df.format(orderDetail.delivery_charge) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderDetail.offer_amount > 0) {
                zonerich.Prn_PrintText(padRightSpaces("Offer:", 20) + MyApp.df.format(orderDetail.offer_amount) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderDetail.service_charge > 0) {
                if (!"no".equalsIgnoreCase(orderDetail.service_charge_status)) {
                    zonerich.Prn_PrintText(padRightSpaces("Service Charge:", 20) + MyApp.df.format(orderDetail.service_charge) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            if (orderDetail.driver_tip > 0) {
                zonerich.Prn_PrintText(padRightSpaces("Driver Tip:", 20) + MyApp.df.format(orderDetail.driver_tip) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderDetail.reward_offer > 0) {
                zonerich.Prn_PrintText(padRightSpaces("Loyalty Point Discount:", 20) + MyApp.df.format(orderDetail.reward_offer) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            zonerich.Prn_PrintText("Total: " + MyApp.df.format(orderDetail.order_grand_total) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (!Validators.isNullOrEmpty(orderDetail.order_description)) {
                if (kitchenCopy) {
                    zonerich.Prn_PrintText("Comments: " + orderDetail.order_description + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                } else {
                    zonerich.Prn_PrintText("Comments: " + orderDetail.order_description + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
                zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (!Validators.isNullOrEmpty(orderDetail.delivery_instruction)) {
                zonerich.Prn_PrintText("Delivery Instructions: " + orderDetail.delivery_instruction + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            zonerich.Prn_PrintText("Cust Name:" + orderDetail.customer_name + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (!Validators.isNullOrEmpty(orderDetail.customer_phone)) {
                zonerich.Prn_PrintText("Cust No:" + orderDetail.customer_phone + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            if (orderType == 1) {

                String address = orderDetail.address + "\n";
                String[] parts = address.split("[\\\\s,]+");
                StringBuilder str = new StringBuilder();

                for (String name : parts) {
                    str.append(name).append("\n");
                }
                zonerich.Prn_PrintText("Del. address:" + address + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (orderType >= 0) {
                zonerich.Prn_PrintText("Requested for:" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                if (orderDetail.assoonas.equalsIgnoreCase("now")) {
                    zonerich.Prn_PrintText("ASAP" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                } else {
                    zonerich.Prn_PrintText(orderDetail.delivery_time + " " + CommonFunctions.formatUnknownDateTime(orderDetail.delivery_date, "yyyy-MM-dd", "dd-MM-yyyy") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                }

                if (orderDetail.status.equalsIgnoreCase("accepted") && !Validators.isNullOrEmpty(orderDetail.preparation)) {
                    zonerich.Prn_PrintText("Confirmed for:" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    zonerich.Prn_PrintText(orderDetail.preparation + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                    zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                }
            }
            zonerich.Prn_PrintText("Order " + (orderDetail.payment_status.equalsIgnoreCase("np") ? "Unpaid" : "Paid") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);

            String paymentName = "";
            if (orderDetail.payment_method.equalsIgnoreCase("stripe")) paymentName = "ONLINE";
            if (orderDetail.payment_method.equalsIgnoreCase("cod")) paymentName = "COD";
            if (orderDetail.payment_method.equalsIgnoreCase("wallet") || orderDetail.payment_method.equalsIgnoreCase("credit"))
                paymentName = "WALLET";
            if (orderDetail.payment_method.equalsIgnoreCase("paypal")) paymentName = "PAYPAL";

            zonerich.Prn_PrintText("Payment Type:  " + paymentName + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("Receipt Time:\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            zonerich.Prn_PrintText(CommonFunctions.getCurrentTimeFormatted("dd/MM/yyyy hh:mm a") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            zonerich.Prn_PrintText("Order status: " + orderDetail.status + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            if (orderDetail.status.equalsIgnoreCase("failed")) {
                zonerich.Prn_PrintText("Reason: " + orderDetail.failed_reason + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            }

            zonerich.Prn_PrintText(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.name + ", " + MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.address + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);

            zonerich.Prn_PrintText("Thanks!" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);
            // set print true for local device
            setPrint(myPreferences, true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();

        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public void printOrderEpos(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, MyPreferences myPreferences, float voucherPaymentDoneAmount) {
        int style = 0, widthSize = 0, heightSize = 0, alignment = 0;

        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");

        try {
            if (!kitchenCopy && tiffintomLogo != null) {
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            if (!kitchenCopy) {
                if (headerAlignment < 2)
                    zonerich.Prn_PrintText(ticket_header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                else {
                    String[] headers = ticket_header.split("\n");
                    for (String h : headers) {
                        zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            }

            if (structure.header_order_type.visibility && kitchenCopy) {
                switch (structure.header_order_type.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.header_order_type.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.header_order_type.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                    zonerich.Prn_PrintText("** " + orderTypeHeading + " **" + "\n", alignment, style, widthSize | heightSize);
                }

            }

            if (structure.header_customer_name != null) {
                if (structure.header_customer_name.visibility && kitchenCopy) {
                    switch (structure.header_customer_name.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) {
                        zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                    }
                }
            }
            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            if (structure.title.visibility && kitchenCopy) {
                switch (structure.title.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.title.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.title.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(title)) {
                    zonerich.Prn_PrintText("\n" + title + "\n", alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (structure.order_no.visibility) {
                switch (structure.order_no.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.order_no.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.order_no.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    zonerich.Prn_PrintText("Order No: " + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                } else {
                    if (orderDetail._id != 0) {
                        zonerich.Prn_PrintText("Order No: " + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                    }
                }
                if (kitchenCopy)
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                switch (structure.table_no.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.table_no.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.table_no.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Table No: " + orderDetail.table_number, alignment, style, widthSize | heightSize);

                switch (structure.no_of_diners.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.no_of_diners.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.no_of_diners.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                zonerich.Prn_PrintText("   No of Diner: " + orderDetail.no_guest + "\n", alignment, style, widthSize | heightSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            } else if (structure.table_no.visibility && orderType == 1) {
                switch (structure.table_no.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.table_no.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.table_no.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            } else if (structure.no_of_diners.visibility && orderType == 1) {
                switch (structure.no_of_diners.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.no_of_diners.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.no_of_diners.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("No of Diner: " + orderDetail.no_guest + "\n", alignment, style, widthSize | heightSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (orderDetail.updated_at.contains("Z")) {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                } else {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                }
            }
            if (structure.order_date != null) {
                if (structure.order_date.visibility) {
                    switch (structure.order_date.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_date.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_date.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDate))
                        if (structure.order_time != null && structure.order_time.visibility) {
                            zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                        } else {
                            zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                            zonerich.Prn_PrintText("\n------------------------------------------------\n",
                                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                        }
                }

            }
            if (structure.order_time != null) {
                if (structure.order_time.visibility) {
                    switch (structure.order_time.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_time.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderTime)) {
                        zonerich.Prn_PrintText("Time :" + orderTime + "\n", alignment, style, widthSize | heightSize);
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }

            }

/*
            else {
                if (!Validators.isNullOrEmpty(dateTimeMode)) {
                    String dateFormat = "dd-MM-yyyy hh:mm a";
                    String dateFormatTitle = "Order Date Time: ";
                    if (dateTimeMode.equalsIgnoreCase("date_time")) {
                        dateFormat = "dd-MM-yyyy hh:mm a";
                        dateFormatTitle = "Order Date Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("time")) {
                        dateFormat = "hh:mm a";
                        dateFormatTitle = "Order Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("date")) {
                        dateFormat = "dd-MM-yyyy";
                        dateFormatTitle = "Order Date: ";
                    }
                    if (orderDetail.created_at.contains("Z")) {
                        zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat) + "\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);

                    } else {
                        zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, dateFormat) + "\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }
                }

            }
*/
            if (orderType > 1 && !kitchenCopy) {
                zonerich.Prn_PrintText("Order Type: " + orderDetail.order_type + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.items_header.visibility) {
                switch (structure.items_header.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items_header.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items_header.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Qty  Name" + "\n", alignment, style, widthSize | heightSize);
            }

            if (structure.items.visibility) {
                switch (structure.items.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                String itemName = "", price = "", qty = "";
                String lastBlockId = null;
                boolean lastItemWasMisc = false;

                for (OrderItem productDetail : orderDetail.order_items) {
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                    String productQty;
                    if (kitchenCopy) {
                        productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                    } else {
                        productQty = String.valueOf(productDetail.quantity);
                    }

                    qty = productQty;

                    if (productQty.length() <= 1) {
                        qty = productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }

                    int length = String.valueOf(formatter.format(productDetail.total)).length();
                    String format = null;
                    if (length <= 7 && length > 2) {
                        if (length == 4) {
                            format = "    " + formatter.format(productDetail.total);
                        }
                        if (length == 5) {
                            format = "   " + formatter.format(productDetail.total);
                        }

                        if (length == 6) {
                            format = "  " + formatter.format(productDetail.total);
                        }
                        if (length == 7) {
                            format = " " + formatter.format(productDetail.total);
                        }
                    } else {
                        format = formatter.format(productDetail.total);
                    }
                    price = (!kitchenCopy) ? format : "";
                    if (kitchenCopy)
                        itemName = qty + productName;
                    else {
                        if (length == 3)
                            itemName = getProductNameWithPad(qty + productName, price, 40);
                        else if (length <= 8 && length >= 4)
                            itemName = getProductNameWithPad(qty + productName, price, 39);
                        else
                            itemName = getProductNameWithPad(qty + productName, price, 38);
                    }

                    if (lastBlockId != null) {
                        if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                            if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                zonerich.Prn_PrintText("----------------------------------\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                    } else {
                        if (lastItemWasMisc && !productDetail.misc) {
                            if (kitchenCopy)
                                zonerich.Prn_PrintText("----------------------------------\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                    }

                    String printItem;
                    printItem = itemName + "\n";


                    zonerich.Prn_PrintText(printItem, alignment, style, widthSize | heightSize);
                    if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                        zonerich.Prn_PrintText("  " + "Instruction: " + productDetail.special_instruction + "\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);

                    if (productDetail.order_item_addons.size() > 0) {
                        if (structure.items_subaddon.visibility) {
                            int subStyle, subWidthSize, subHeightSize, subAlignment;
                            switch (structure.items_subaddon.style) {
                                case "default":
                                    subStyle = PrinterConst.Font.DEFAULT;
                                    break;
                                case "bold":
                                    subStyle = PrinterConst.Font.BOLD;
                                    break;
                                case "underline":
                                    subStyle = PrinterConst.Font.UNDERLINE;
                                    break;
                                case "reverse":
                                    subStyle = PrinterConst.Font.REVERSE;
                                    break;
                                default:
                                    subStyle = PrinterConst.Font.DEFAULT;
                                    break;
                            }

                            switch (structure.items_subaddon.size) {
                                case "size0":
                                    subWidthSize = PrinterConst.WidthSize.SIZE0;
                                    subHeightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                                case "size1":
                                    subWidthSize = PrinterConst.WidthSize.SIZE1;
                                    subHeightSize = PrinterConst.HeightSize.SIZE1;
                                    break;
                                case "size2":
                                    subWidthSize = PrinterConst.WidthSize.SIZE2;
                                    subHeightSize = PrinterConst.HeightSize.SIZE2;
                                    break;
                                case "size3":
                                    subWidthSize = PrinterConst.WidthSize.SIZE3;
                                    subHeightSize = PrinterConst.HeightSize.SIZE3;
                                    break;
                                default:
                                    subWidthSize = PrinterConst.WidthSize.SIZE0;
                                    subHeightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                            }

                            switch (structure.items_subaddon.alignment) {
                                case "left":
                                    subAlignment = PrinterConst.Alignment.LEFT;
                                    break;
                                case "center":
                                    subAlignment = PrinterConst.Alignment.CENTER;
                                    break;
                                case "right":
                                    subAlignment = PrinterConst.Alignment.RIGHT;
                                    break;
                                default:
                                    subAlignment = PrinterConst.Alignment.LEFT;
                                    break;
                            }
                            zonerich.Prn_PrintText("Choose Your Base:" + "\n", subAlignment, subStyle, subWidthSize | subHeightSize);
                        }

                        for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                            List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                            if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                continue;
                            }

                            String subdomainPrintText;
                            if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                // commenting the condition as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                /*if (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                } else {*/
                                if (orderItemAddon.quantity > 1) {
                                    subdomainPrintText = "  " + orderItemAddon.quantity + " " + orderItemAddon.addon_name + "\n";
                                } else {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                }
                                //}
                            } else {
                                length = String.valueOf(formatter.format(orderItemAddon.total)).length();
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        format = "    " + formatter.format(orderItemAddon.total);
                                    }
                                    if (length == 5) {
                                        format = "   " + formatter.format(orderItemAddon.total);
                                    }

                                    if (length == 6) {
                                        format = "  " + formatter.format(orderItemAddon.total);
                                    }
                                    if (length == 7) {
                                        format = " " + formatter.format(orderItemAddon.total);
                                    }
                                } else {
                                    format = formatter.format(orderItemAddon.total);
                                }
                                productName = orderItemAddon.addon_name;
                                price = (!kitchenCopy) ? format : "";
                                productQty = "" + orderItemAddon.quantity;
                                qty = productQty;

                                if (productQty.length() <= 1) {
                                    qty = productQty + " ";
                                } else if (productQty.length() <= 2) {
                                    qty = productQty + " ";

                                } else if (productQty.length() <= 3) {
                                    qty = productQty + " ";

                                } else if (productQty.length() <= 4) {
                                    qty = productQty + "";
                                }

                                if (kitchenCopy)
                                    itemName = qty + productName;
                                else {
                                    if (length == 3)
                                        itemName = getProductNameWithPad(qty + productName, price, 40);
                                    else if (length <= 8 && length >= 4)
                                        itemName = getProductNameWithPad(qty + productName, price, 39);
                                    else
                                        itemName = getProductNameWithPad(qty + productName, price, 38);
                                }
                                subdomainPrintText = itemName;
                            }
                            zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD,
                                    PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                        }
                    }

                    for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                        String ingredientName = orderItemIngredient.ingredient_name;
                        if (orderItemIngredient.with) {
                            ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                        }
                        if (orderItemIngredient.without) {
                            ingredientName = "  " + "No " + ingredientName;
                        }
                        String subdomainPrintText = ingredientName + "\n";
                        zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }

                    lastItemWasMisc = productDetail.misc;
                    lastBlockId = productDetail.block_id;
                }
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (printTotalInPrint) {
                if (structure.subtotal.visibility) {
                    switch (structure.subtotal.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.subtotal.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.subtotal.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    zonerich.Prn_PrintText("Sub Total: " + MyApp.df.format(orderDetail.sub_total) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.gratuity.visibility) {
                    switch (structure.gratuity.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.gratuity.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.gratuity.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.gratuity > 0)
                        zonerich.Prn_PrintText("Gratuity: " + MyApp.df.format(orderDetail.gratuity) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.discount.visibility) {
                    switch (structure.discount.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.discount.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.discount.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.discount > 0)
                        zonerich.Prn_PrintText("Discount: " + MyApp.df.format(orderDetail.discount) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.delivery_charge.visibility) {
                    switch (structure.delivery_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.delivery_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.delivery_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.delivery_charge > 0)
                        zonerich.Prn_PrintText("Delivery Charge: " + MyApp.df.format(orderDetail.delivery_charge) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.service_charge.visibility) {
                    switch (structure.service_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.service_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.service_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.service_charge > 0)
                        zonerich.Prn_PrintText("Service Charge: " + MyApp.df.format(orderDetail.service_charge) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.grand_total.visibility) {
                    switch (structure.grand_total.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.grand_total.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.grand_total.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    zonerich.Prn_PrintText("Total: " + MyApp.df.format(orderDetail.total - voucherPaymentDoneAmount) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                        structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility)
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                if (structure.payment_detail_header != null)
                    if (structure.payment_detail_header.visibility) {
                        switch (structure.payment_detail_header.style) {
                            case "default":
                                style = PrinterConst.Font.DEFAULT;
                                break;
                            case "bold":
                                style = PrinterConst.Font.BOLD;
                                break;
                            case "underline":
                                style = PrinterConst.Font.UNDERLINE;
                                break;
                            case "reverse":
                                style = PrinterConst.Font.REVERSE;
                                break;
                            default:
                                style = PrinterConst.Font.DEFAULT;
                                break;
                        }

                        switch (structure.payment_detail_header.size) {
                            case "size0":
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                            case "size1":
                                widthSize = PrinterConst.WidthSize.SIZE1;
                                heightSize = PrinterConst.HeightSize.SIZE1;
                                break;
                            case "size2":
                                widthSize = PrinterConst.WidthSize.SIZE2;
                                heightSize = PrinterConst.HeightSize.SIZE2;
                                break;
                            case "size3":
                                widthSize = PrinterConst.WidthSize.SIZE3;
                                heightSize = PrinterConst.HeightSize.SIZE3;
                                break;
                            default:
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                        }

                        switch (structure.payment_detail_header.alignment) {
                            case "left":
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = PrinterConst.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = PrinterConst.Alignment.RIGHT;
                                break;
                            default:
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                        }
                        zonerich.Prn_PrintText("Payment Details: " + "\n", alignment, style, widthSize | heightSize);

                    }

                if (structure.payment_detail != null)
                    if (structure.payment_detail.visibility) {
                        switch (structure.payment_detail.style) {
                            case "default":
                                style = PrinterConst.Font.DEFAULT;
                                break;
                            case "bold":
                                style = PrinterConst.Font.BOLD;
                                break;
                            case "underline":
                                style = PrinterConst.Font.UNDERLINE;
                                break;
                            case "reverse":
                                style = PrinterConst.Font.REVERSE;
                                break;
                            default:
                                style = PrinterConst.Font.DEFAULT;
                                break;
                        }

                        switch (structure.payment_detail.size) {
                            case "size0":
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                            case "size1":
                                widthSize = PrinterConst.WidthSize.SIZE1;
                                heightSize = PrinterConst.HeightSize.SIZE1;
                                break;
                            case "size2":
                                widthSize = PrinterConst.WidthSize.SIZE2;
                                heightSize = PrinterConst.HeightSize.SIZE2;
                                break;
                            case "size3":
                                widthSize = PrinterConst.WidthSize.SIZE3;
                                heightSize = PrinterConst.HeightSize.SIZE3;
                                break;
                            default:
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                        }

                        switch (structure.payment_detail.alignment) {
                            case "left":
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = PrinterConst.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = PrinterConst.Alignment.RIGHT;
                                break;
                            default:
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                        }


                        for (OrderPayment orderPayment : orderDetail.order_payments) {
                            String paymentDetailToPrint = null;
                            if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                            } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                            } else {
                                paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                            }
                            zonerich.Prn_PrintText(paymentDetailToPrint, alignment, style,
                                    widthSize | heightSize);
                        }
                        zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    } else {
                        zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
            }

            if (structure.serve_by.visibility) {
                switch (structure.serve_by.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.serve_by.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.serve_by.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username + "\n",
                        alignment, style, widthSize | heightSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.customer_detail != null)
                if (structure.customer_detail.visibility) {
                    switch (structure.customer_detail.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.customer_detail.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.customer_detail.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name))
                        zonerich.Prn_PrintText("Cust Name: " + orderDetail.customer_name + "\n", alignment, style,
                                widthSize | heightSize);

                    if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                        zonerich.Prn_PrintText("Cust No: " + orderDetail.customer.mobile + "\n", alignment, style,
                                widthSize | heightSize);
                    }

                    String fulladdress = null;
                    if (orderType == 3) {
                        /*fulladdress = "Address: " + orderDetail.customer.house_no + ","
                                + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                orderDetail.customer.country + ", " + orderDetail.customer.postcode;*/
                        fulladdress = formatAddress(orderDetail, widthSize);
                        zonerich.Prn_PrintText(fulladdress + "\n", alignment, style,
                                widthSize | heightSize);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress))
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                }


            if (structure.payment_status.visibility) {
                switch (structure.payment_status.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.payment_status.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.payment_status.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                if (orderDetail.total_paid == 0) {
                    zonerich.Prn_PrintText("Payment Status: " + settingMap.get("unpaid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                    zonerich.Prn_PrintText("Payment Status: " + settingMap.get("paid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                } else if (orderDetail.total_paid > 0) {
                    zonerich.Prn_PrintText("Payment Status: " + settingMap.get("partial_payment_title") + "\n", alignment, style, widthSize | heightSize);
                }
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (structure.order_comment != null) {
                if (structure.order_comment.visibility) {
                    switch (structure.order_comment.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_comment.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_comment.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                        zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", alignment, style,
                                widthSize | heightSize);

                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            } else {
                if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                    if (kitchenCopy) {
                        zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    } else {
                        zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                    zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                zonerich.Prn_PrintText("Requested Time" + orderDetail.delivery_collection_time_slot + "\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
            }
            if (structure.footer_order_type.visibility && kitchenCopy) {
                switch (structure.footer_order_type.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_order_type.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_order_type.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                    zonerich.Prn_PrintText("** " + orderTypeHeading + " **" + "\n", alignment, style, widthSize | heightSize);
                }
            }
            // footer table number
            if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                switch (structure.footer_table_number.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_table_number.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_table_number.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                }
            }
            // footer order number
            if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                switch (structure.footer_order_number.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_order_number.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_order_number.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    zonerich.Prn_PrintText("Order No: " + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                } else {
                    if (orderDetail._id != 0) {
                        zonerich.Prn_PrintText("Order No: " + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                    }
                }
            }
            if (structure.header_customer_name != null) {
                if (structure.header_customer_name.visibility && kitchenCopy) {
                    switch (structure.header_customer_name.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) {
                        zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                    }
                }
            }

            if (structure.receipt_time != null && structure.receipt_time.visibility && !Validators.isNullOrEmpty(receiptDate)) {
                switch (structure.receipt_time.style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.receipt_time.size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.receipt_time.alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Receipt Date :" + receiptDate + "\n", alignment, style, widthSize | heightSize);
            }
            if (structure.footer.visibility) {
                switch (structure.footer.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(footerA)) {
                    zonerich.Prn_PrintText(footerA + "\n", alignment, style, widthSize | heightSize);
                }
                if (!Validators.isNullOrEmpty(footerB)) {
                    zonerich.Prn_PrintText(footerB + "\n", alignment, style, widthSize | heightSize);
                }
            }

            if (!kitchenCopy && MyApp.getInstance().paymentLinkBitmap != null) {
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(MyApp.getInstance().paymentLinkBitmap, PrinterConst.BitmapSize.ZQSIZE0);
            }
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);
            // set print true for local device
            setPrint(myPreferences, true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();
            //writeToSDFile("Prn_CutPaper is " + zonerich.Prn_CutPaper(), "zonerichPrinterCutPaperSuccess.txt");
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title != null ? title : "");
            sendOrderWifiModel.setTicketHeaderSetting(ticket_header != null ? ticket_header : "");
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
            sendOrderWifiModel.setOrderDetail(orderDetail);
            sendOrderWifiModel.setPrintStructure(structure);
            sendOrderWifiModel.setFooterA(footerA != null ? footerA : "");
            sendOrderWifiModel.setFooterB(footerB != null ? footerB : "");
            sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading != null ? orderTypeHeading : "");
            sendOrderWifiModel.setSettingsMap(settingMap);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            if (printBlockBill != null) {
                sendOrderWifiModel.setPrintBlockBill(printBlockBill);
            }
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOS);
            sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username != null ? MyApp.getInstance().myPreferences.getLoggedInUser().username : "");
            sendOrderToWifi(sendOrderWifiModel);
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    public void printOrderEposFoodHub(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, MyPreferences myPreferences, float voucherPaymentDoneAmount) {
        int style = 0, widthSize = 0, heightSize = 0, alignment = 0;

        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");

        try {
            if (!kitchenCopy && tiffintomLogo != null) {
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            if (!kitchenCopy) {
                if (headerAlignment < 2)
                    zonerich.Prn_PrintText(ticket_header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                else {
                    String[] headers = ticket_header.split("\n");
                    for (String h : headers) {
                        zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            }

            if (structure.header_order_type.visibility && kitchenCopy) {
                switch (structure.header_order_type.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.header_order_type.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.header_order_type.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                    zonerich.Prn_PrintText("** " + orderTypeHeading + " **" + "\n", alignment, style, widthSize | heightSize);
                }

            }

            if (structure.header_customer_name != null) {
                if (structure.header_customer_name.visibility && kitchenCopy) {
                    switch (structure.header_customer_name.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) {
                        zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                    }
                }
            }
            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            if (structure.title.visibility && kitchenCopy) {
                switch (structure.title.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.title.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.title.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(title)) {
                    zonerich.Prn_PrintText("\n" + title + "\n", alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (structure.order_no.visibility) {
                switch (structure.order_no.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.order_no.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.order_no.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    zonerich.Prn_PrintText("Order No: " + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                } else {
                    if (orderDetail._id != 0) {
                        zonerich.Prn_PrintText("Order No: " + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                    }
                }
                if (kitchenCopy)
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                switch (structure.table_no.style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.table_no.size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.table_no.alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Table No: " + orderDetail.table_number, alignment, style, widthSize | heightSize);

                switch (structure.no_of_diners.style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.no_of_diners.size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.no_of_diners.alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                zonerich.Prn_PrintText("   No of Diner: " + orderDetail.no_guest + "\n", alignment, style, widthSize | heightSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            } else if (structure.table_no.visibility && orderType == 1) {
                switch (structure.table_no.style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.table_no.size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.table_no.alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            } else if (structure.no_of_diners.visibility && orderType == 1) {
                switch (structure.no_of_diners.style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.no_of_diners.size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.no_of_diners.alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("No of Diner: " + orderDetail.no_guest + "\n", alignment, style, widthSize | heightSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (orderDetail.updated_at.contains("Z")) {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                } else {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                }
            }
            if (structure.order_date != null) {
                if (structure.order_date.visibility) {
                    switch (structure.order_date.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_date.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_date.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDate))
                        if (structure.order_time != null && structure.order_time.visibility) {
                            zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                        } else {
                            zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                            zonerich.Prn_PrintText("\n------------------------------------------------\n",
                                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                        }
                }

            }
            if (structure.order_time != null) {
                if (structure.order_time.visibility) {
                    switch (structure.order_time.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_time.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderTime)) {
                        zonerich.Prn_PrintText("Time :" + orderTime + "\n", alignment, style, widthSize | heightSize);
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }

            }

/*
            else {
                if (!Validators.isNullOrEmpty(dateTimeMode)) {
                    String dateFormat = "dd-MM-yyyy hh:mm a";
                    String dateFormatTitle = "Order Date Time: ";
                    if (dateTimeMode.equalsIgnoreCase("date_time")) {
                        dateFormat = "dd-MM-yyyy hh:mm a";
                        dateFormatTitle = "Order Date Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("time")) {
                        dateFormat = "hh:mm a";
                        dateFormatTitle = "Order Time: ";
                    }
                    if (dateTimeMode.equalsIgnoreCase("date")) {
                        dateFormat = "dd-MM-yyyy";
                        dateFormatTitle = "Order Date: ";
                    }
                    if (orderDetail.created_at.contains("Z")) {
                        zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat) + "\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);

                    } else {
                        zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, dateFormat) + "\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }
                }

            }
*/
            if (orderType > 1 && !kitchenCopy) {
                zonerich.Prn_PrintText("Order Type: " + orderDetail.order_type + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.items_header.visibility) {
                switch (structure.items_header.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items_header.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items_header.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Qty  Name" + "\n", alignment, style, widthSize | heightSize);
            }

            if (structure.items.visibility) {
                switch (structure.items.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                String itemName = "", price = "", qty = "";
                String lastBlockId = null;
                boolean lastItemWasMisc = false;

                for (OrderItem productDetail : orderDetail.order_items) {
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                    String productQty;
                    if (kitchenCopy) {
                        productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                    } else {
                        productQty = String.valueOf(productDetail.quantity);
                    }

                    qty = productQty;

                    if (productQty.length() <= 1) {
                        qty = productQty + "x ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + "x ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + "x ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "x";
                    }

                    int length = String.valueOf(formatter.format(productDetail.total)).length();
                    String format = null;
                    if (length <= 7 && length > 2) {
                        if (length == 4) {
                            format = "    " + formatter.format(productDetail.total);
                        }
                        if (length == 5) {
                            format = "   " + formatter.format(productDetail.total);
                        }

                        if (length == 6) {
                            format = "  " + formatter.format(productDetail.total);
                        }
                        if (length == 7) {
                            format = " " + formatter.format(productDetail.total);
                        }
                    } else {
                        format = formatter.format(productDetail.total);
                    }
                    price = (!kitchenCopy) ? format : "";
                    if (kitchenCopy)
                        itemName = qty + productName;
                    else {
                        if (length == 3)
                            itemName = getProductNameWithPad(qty + productName, price, 40);
                        else if (length <= 8 && length >= 4)
                            itemName = getProductNameWithPad(qty + productName, price, 39);
                        else
                            itemName = getProductNameWithPad(qty + productName, price, 38);
                    }

                    if (lastBlockId != null) {
                        if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                            if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                zonerich.Prn_PrintText("----------------------------------\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                    } else {
                        if (lastItemWasMisc && !productDetail.misc) {
                            if (kitchenCopy)
                                zonerich.Prn_PrintText("----------------------------------\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                    }

                    String printItem;
                    printItem = itemName + "\n";


                    zonerich.Prn_PrintText(printItem, alignment, style, widthSize | heightSize);
                    if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                        zonerich.Prn_PrintText("  " + "Instruction: " + productDetail.special_instruction + "\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);

                    if (productDetail.order_item_addons.size() > 0) {
                        if (structure.items_subaddon.visibility) {
                            int subStyle, subWidthSize, subHeightSize, subAlignment;
                            switch (structure.items_subaddon.style) {
                                case "bold":
                                    subStyle = PrinterConst.Font.BOLD;
                                    break;
                                case "underline":
                                    subStyle = PrinterConst.Font.UNDERLINE;
                                    break;
                                case "reverse":
                                    subStyle = PrinterConst.Font.REVERSE;
                                    break;
                                default:
                                    subStyle = PrinterConst.Font.DEFAULT;
                                    break;
                            }

                            switch (structure.items_subaddon.size) {
                                case "size1":
                                    subWidthSize = PrinterConst.WidthSize.SIZE1;
                                    subHeightSize = PrinterConst.HeightSize.SIZE1;
                                    break;
                                case "size2":
                                    subWidthSize = PrinterConst.WidthSize.SIZE2;
                                    subHeightSize = PrinterConst.HeightSize.SIZE2;
                                    break;
                                case "size3":
                                    subWidthSize = PrinterConst.WidthSize.SIZE3;
                                    subHeightSize = PrinterConst.HeightSize.SIZE3;
                                    break;
                                default:
                                    subWidthSize = PrinterConst.WidthSize.SIZE0;
                                    subHeightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                            }

                            switch (structure.items_subaddon.alignment) {
                                case "center":
                                    subAlignment = PrinterConst.Alignment.CENTER;
                                    break;
                                case "right":
                                    subAlignment = PrinterConst.Alignment.RIGHT;
                                    break;
                                default:
                                    subAlignment = PrinterConst.Alignment.LEFT;
                                    break;
                            }
                            zonerich.Prn_PrintText("Choose Your Base:" + "\n", subAlignment, subStyle, subWidthSize | subHeightSize);
                        }

                        for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                            List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                            if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                continue;
                            }

                            String subdomainPrintText;
                            if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                // commenting the condition as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                /*if (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                } else {*/
                                if (orderItemAddon.quantity > 1) {
                                    subdomainPrintText = "  " + orderItemAddon.quantity + " " + orderItemAddon.addon_name + "\n";
                                } else {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                }
                                //}
                            } else {
                                length = String.valueOf(formatter.format(orderItemAddon.total)).length();
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        format = "    " + formatter.format(orderItemAddon.total);
                                    }
                                    if (length == 5) {
                                        format = "   " + formatter.format(orderItemAddon.total);
                                    }

                                    if (length == 6) {
                                        format = "  " + formatter.format(orderItemAddon.total);
                                    }
                                    if (length == 7) {
                                        format = " " + formatter.format(orderItemAddon.total);
                                    }
                                } else {
                                    format = formatter.format(orderItemAddon.total);
                                }
                                productName = orderItemAddon.addon_name;
                                price = (!kitchenCopy) ? format : "";
                                productQty = "" + orderItemAddon.quantity;
                                qty = productQty;

                                if (productQty.length() <= 1) {
                                    qty = productQty + "x ";
                                } else if (productQty.length() <= 2) {
                                    qty = productQty + "x ";

                                } else if (productQty.length() <= 3) {
                                    qty = productQty + "x ";

                                } else if (productQty.length() <= 4) {
                                    qty = productQty + "x";
                                }

                                if (kitchenCopy)
                                    itemName = qty + productName;
                                else {
                                    if (length == 3)
                                        itemName = getProductNameWithPad(qty + productName, price, 40);
                                    else if (length <= 8 && length >= 4)
                                        itemName = getProductNameWithPad(qty + productName, price, 39);
                                    else
                                        itemName = getProductNameWithPad(qty + productName, price, 38);
                                }
                                subdomainPrintText = itemName;
                            }
                            zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD,
                                    PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                        }
                    }

                    for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                        String ingredientName = orderItemIngredient.ingredient_name;
                        if (orderItemIngredient.with) {
                            ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                        }
                        if (orderItemIngredient.without) {
                            ingredientName = "  " + "No " + ingredientName;
                        }
                        String subdomainPrintText = ingredientName + "\n";
                        zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }

                    lastItemWasMisc = productDetail.misc;
                    lastBlockId = productDetail.block_id;
                }
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (printTotalInPrint) {
                if (structure.subtotal.visibility) {
                    switch (structure.subtotal.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.subtotal.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.subtotal.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    zonerich.Prn_PrintText("Sub Total: " + MyApp.df.format(orderDetail.sub_total) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.gratuity.visibility) {
                    switch (structure.gratuity.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.gratuity.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.gratuity.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.gratuity > 0)
                        zonerich.Prn_PrintText("Gratuity: " + MyApp.df.format(orderDetail.gratuity) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.discount.visibility) {
                    switch (structure.discount.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.discount.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.discount.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.discount > 0)
                        zonerich.Prn_PrintText("Discount: " + MyApp.df.format(orderDetail.discount) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.delivery_charge.visibility) {
                    switch (structure.delivery_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.delivery_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.delivery_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.delivery_charge > 0)
                        zonerich.Prn_PrintText("Delivery Charge: " + MyApp.df.format(orderDetail.delivery_charge) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.service_charge.visibility) {
                    switch (structure.service_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.service_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.service_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.service_charge > 0)
                        zonerich.Prn_PrintText("Service Charge: " + MyApp.df.format(orderDetail.service_charge) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.grand_total.visibility) {
                    switch (structure.grand_total.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.grand_total.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.grand_total.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    zonerich.Prn_PrintText("Total: " + MyApp.df.format(orderDetail.total - voucherPaymentDoneAmount) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                        structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility)
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                if (structure.payment_detail_header != null)
                    if (structure.payment_detail_header.visibility) {
                        switch (structure.payment_detail_header.style) {
                            case "default":
                                style = PrinterConst.Font.DEFAULT;
                                break;
                            case "bold":
                                style = PrinterConst.Font.BOLD;
                                break;
                            case "underline":
                                style = PrinterConst.Font.UNDERLINE;
                                break;
                            case "reverse":
                                style = PrinterConst.Font.REVERSE;
                                break;
                            default:
                                style = PrinterConst.Font.DEFAULT;
                                break;
                        }

                        switch (structure.payment_detail_header.size) {
                            case "size0":
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                            case "size1":
                                widthSize = PrinterConst.WidthSize.SIZE1;
                                heightSize = PrinterConst.HeightSize.SIZE1;
                                break;
                            case "size2":
                                widthSize = PrinterConst.WidthSize.SIZE2;
                                heightSize = PrinterConst.HeightSize.SIZE2;
                                break;
                            case "size3":
                                widthSize = PrinterConst.WidthSize.SIZE3;
                                heightSize = PrinterConst.HeightSize.SIZE3;
                                break;
                            default:
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                        }

                        switch (structure.payment_detail_header.alignment) {
                            case "left":
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = PrinterConst.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = PrinterConst.Alignment.RIGHT;
                                break;
                            default:
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                        }
                        zonerich.Prn_PrintText("Payment Details: " + "\n", alignment, style, widthSize | heightSize);

                    }

                if (structure.payment_detail != null)
                    if (structure.payment_detail.visibility) {
                        switch (structure.payment_detail.style) {
                            case "default":
                                style = PrinterConst.Font.DEFAULT;
                                break;
                            case "bold":
                                style = PrinterConst.Font.BOLD;
                                break;
                            case "underline":
                                style = PrinterConst.Font.UNDERLINE;
                                break;
                            case "reverse":
                                style = PrinterConst.Font.REVERSE;
                                break;
                            default:
                                style = PrinterConst.Font.DEFAULT;
                                break;
                        }

                        switch (structure.payment_detail.size) {
                            case "size0":
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                            case "size1":
                                widthSize = PrinterConst.WidthSize.SIZE1;
                                heightSize = PrinterConst.HeightSize.SIZE1;
                                break;
                            case "size2":
                                widthSize = PrinterConst.WidthSize.SIZE2;
                                heightSize = PrinterConst.HeightSize.SIZE2;
                                break;
                            case "size3":
                                widthSize = PrinterConst.WidthSize.SIZE3;
                                heightSize = PrinterConst.HeightSize.SIZE3;
                                break;
                            default:
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                        }

                        switch (structure.payment_detail.alignment) {
                            case "left":
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = PrinterConst.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = PrinterConst.Alignment.RIGHT;
                                break;
                            default:
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                        }


                        for (OrderPayment orderPayment : orderDetail.order_payments) {
                            String paymentDetailToPrint = null;
                            if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                            } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                            } else {
                                paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                            }
                            zonerich.Prn_PrintText(paymentDetailToPrint, alignment, style,
                                    widthSize | heightSize);
                        }
                        zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    } else {
                        zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
            }

            if (structure.serve_by.visibility) {
                switch (structure.serve_by.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.serve_by.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.serve_by.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username + "\n",
                        alignment, style, widthSize | heightSize);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.customer_detail != null)
                if (structure.customer_detail.visibility) {
                    switch (structure.customer_detail.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.customer_detail.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.customer_detail.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name))
                        zonerich.Prn_PrintText("" + orderDetail.customer_name + "\n", alignment, style,
                                widthSize | heightSize);

                    if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                        zonerich.Prn_PrintText("" + orderDetail.customer.mobile + "\n", alignment, style,
                                widthSize | heightSize);
                    }

                    String fulladdress = null;
                    if (orderType == 3) {
                     /*   fulladdress = "" + orderDetail.customer.house_no + ","
                                + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                orderDetail.customer.country + ", " + orderDetail.customer.postcode;*/
                        fulladdress = formatAddress(orderDetail, widthSize);
                        zonerich.Prn_PrintText(fulladdress + "\n", alignment, style,
                                widthSize | heightSize);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress))
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                }


            if (structure.payment_status.visibility) {
                switch (structure.payment_status.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.payment_status.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.payment_status.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                if (orderDetail.total_paid == 0) {
                    //zonerich.Prn_PrintText("Payment Status: " + settingMap.get("unpaid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("" + settingMap.get("unpaid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                    //zonerich.Prn_PrintText("Payment Status: " + settingMap.get("paid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("" + settingMap.get("paid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                } else if (orderDetail.total_paid > 0) {
                    //zonerich.Prn_PrintText("Payment Status: " + settingMap.get("partial_payment_title") + "\n", alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("" + settingMap.get("partial_payment_title") + "\n", alignment, style, widthSize | heightSize);
                }
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (structure.order_comment != null) {
                if (structure.order_comment.visibility) {
                    switch (structure.order_comment.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_comment.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_comment.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                        zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", alignment, style,
                                widthSize | heightSize);

                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            } else {
                if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                    if (kitchenCopy) {
                        zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    } else {
                        zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                    zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                zonerich.Prn_PrintText("Requested Time" + orderDetail.delivery_collection_time_slot + "\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
            }
            if (structure.footer_order_type.visibility && kitchenCopy) {
                switch (structure.footer_order_type.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_order_type.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_order_type.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTypeHeading)) {
                    zonerich.Prn_PrintText("** " + orderTypeHeading + " **" + "\n", alignment, style, widthSize | heightSize);
                }
            }
            // footer table number
            if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                switch (structure.footer_table_number.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_table_number.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_table_number.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                }
            }
            // footer order number
            if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                switch (structure.footer_order_number.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_order_number.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_order_number.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    zonerich.Prn_PrintText("Order No: " + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                } else {
                    if (orderDetail._id != 0) {
                        zonerich.Prn_PrintText("Order No: " + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                    }
                }
            }
            if (structure.header_customer_name != null) {
                if (structure.header_customer_name.visibility && kitchenCopy) {
                    switch (structure.header_customer_name.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) {
                        zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                    }
                }
            }
            if (structure.receipt_time != null && structure.receipt_time.visibility && !Validators.isNullOrEmpty(receiptDate)) {
                switch (structure.receipt_time.style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.receipt_time.size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.receipt_time.alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Receipt Date :" + receiptDate + "\n", alignment, style, widthSize | heightSize);
            }
            if (structure.footer.visibility) {
                switch (structure.footer.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(footerA)) {
                    zonerich.Prn_PrintText(footerA + "\n", alignment, style, widthSize | heightSize);
                }
                if (!Validators.isNullOrEmpty(footerB)) {
                    zonerich.Prn_PrintText(footerB + "\n", alignment, style, widthSize | heightSize);
                }
            }

            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);
            // set print true for local device
            setPrint(myPreferences, true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();
            //writeToSDFile("Prn_CutPaper is " + zonerich.Prn_CutPaper(), "zonerichPrinterCutPaperSuccess.txt");
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title != null ? title : "");
            sendOrderWifiModel.setTicketHeaderSetting(ticket_header != null ? ticket_header : "");
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
            sendOrderWifiModel.setOrderDetail(orderDetail);
            sendOrderWifiModel.setPrintStructure(structure);
            sendOrderWifiModel.setFooterA(footerA != null ? footerA : "");
            sendOrderWifiModel.setFooterB(footerB != null ? footerB : "");
            sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading != null ? orderTypeHeading : "");
            sendOrderWifiModel.setSettingsMap(settingMap);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            if (printBlockBill != null) {
                sendOrderWifiModel.setPrintBlockBill(printBlockBill);
            }
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOS);
            sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username != null ? MyApp.getInstance().myPreferences.getLoggedInUser().username : "");
            sendOrderToWifi(sendOrderWifiModel);
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    public void printSeparator() {
        zonerich.Prn_PrintText("------------------------------------------------\n",
                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
    }

    public void printOrderEposFoodHubSeqeunce(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String dateTimeMode, boolean printTotalInPrint, Order orderDetail, PrintStructure structure, ArrayList<PrintStyle> listPrintStructure, String footerA, String footerB, String orderTypeHeading, HashMap<String, String> settingMap, boolean kitchenCopy, MyPreferences myPreferences, float voucherPaymentDoneAmount) {
        int style = 0, widthSize = 0, heightSize = 0, alignment = 0;

        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");

        try {
            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (orderDetail.updated_at.contains("Z")) {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                } else {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                }
            }
            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                switch (listPrintStructure.get(i).style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }
                switch (listPrintStructure.get(i).size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }
                switch (listPrintStructure.get(i).alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                boolean isSpeartor = listPrintStructure.get(i).separator;
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean priceInItems = listPrintStructure.get(i).price;
                boolean isBlockName = listPrintStructure.get(i).block_name;
                switch (key) {
                    case "logo": {
                        if (!kitchenCopy && tiffintomLogo != null) {
                            zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                            zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "ticket_header": {
                        if (!kitchenCopy && !Validators.isNullOrEmpty(ticket_header)) {
                            if (headerAlignment < 2)
                                zonerich.Prn_PrintText(ticket_header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                            else {
                                String[] headers = ticket_header.split("\n");
                                for (String h : headers) {
                                    zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                                }
                            }
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "header_order_type": {
                        if (!Validators.isNullOrEmpty(orderTypeHeading) && kitchenCopy) {
                            zonerich.Prn_PrintText("" + orderTypeHeading.toUpperCase() + "" + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "header_customer_name": {
                        if (kitchenCopy) {
                            zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "title": {
                        if (!Validators.isNullOrEmpty(title) && kitchenCopy) {
                            zonerich.Prn_PrintText("\n" + title + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_no": {
                        if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            zonerich.Prn_PrintText("" + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                        } else {
                            zonerich.Prn_PrintText("" + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                        }
                        //if(kitchenCopy){
                        if (isSpeartor) {
                            printSeparator();
                        }
                        //}
                        break;
                    }
                    case "table_no": {
                        if (orderType == 1) {
                            zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                                /*if(!structure.no_of_diners.visibility){
                                    zonerich.Prn_PrintText("------------------------------------------------\n",
                                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                                }*/
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "no_of_diners": {
                        if (orderType == 1) {
                            zonerich.Prn_PrintText("No of Diner: " + orderDetail.no_guest + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_date": {
                        if (!Validators.isNullOrEmpty(orderDate))
                            if (structure.order_time != null && structure.order_time.visibility) {
                                zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                            } else {
                                zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                        break;
                    }
                    case "receipt_time": {
                        if (!Validators.isNullOrEmpty(receiptDate)) {
                            zonerich.Prn_PrintText("Receipt Date :" + receiptDate + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_time": {
                        if (!Validators.isNullOrEmpty(orderTime)) {
                            zonerich.Prn_PrintText("Time :" + orderTime + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_type": {
                        if (orderType > 1) {
                            zonerich.Prn_PrintText("Order Type: " + orderDetail.order_type + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "items_header": {
                        zonerich.Prn_PrintText("Qty  Name" + "\n", alignment, style, widthSize | heightSize);
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "items": {
                        String itemName = "", price = "", qty = "";
                        String lastBlockId = null;
                        boolean lastItemWasMisc = false;
                        int position = 0;
                        Log.e("priceInItems", "priceInItems " + priceInItems);
                        for (OrderItem productDetail : orderDetail.order_items) {
                            position = position + 1;
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                            String productQty;
                            if (kitchenCopy) {
                                productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                            } else {
                                productQty = String.valueOf(productDetail.quantity);
                            }

                            qty = productQty;

                            if (productQty.length() <= 1) {
                                qty = productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }

                            int length = String.valueOf(formatter.format(productDetail.total)).length();
                            String format = null;
                            format = (priceInItems) ? formatter.format(productDetail.total) : "";

                            //price = (!kitchenCopy) ? format : "";
                            price = (priceInItems) ? format : "";
                            if (widthSize == PrinterConst.WidthSize.SIZE1 || widthSize == PrinterConst.WidthSize.SIZE0) {
                                itemName = calculateNumberOfLines(productName, format, widthSize, qty);
                            } else {
                                if (length == 3)
                                    itemName = getProductNameWithPad(qty + productName, price, 40);
                                else if (length <= 8 && length >= 4)
                                    itemName = getProductNameWithPad(qty + productName, price, 39);
                                else
                                    itemName = getProductNameWithPad(qty + productName, price, 38);
                            }
                            if (!all_separator) {
                                if (lastBlockId != null) {
                                    if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                        if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes"))){
                                            printBlockText(productDetail,isBlockName);
                                        }
                                    }
                                } else {
                                    if ((lastItemWasMisc && !productDetail.misc) || (productDetail.block_id!=null && lastBlockId==null)) {
                                        if (kitchenCopy)
                                            printBlockText(productDetail,isBlockName);
                                    }
                                }
                            }

                            String printItem;
                            printItem = itemName + "\n";


                            zonerich.Prn_PrintText(printItem, alignment, style, widthSize | heightSize);
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                zonerich.Prn_PrintText("  " + "Instruction: " + productDetail.special_instruction + "\n",
                                        PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);

                            if (productDetail.order_item_addons.size() > 0) {
                                int subStyle, subWidthSize, subHeightSize, subAlignment;
                                switch (structure.items_subaddon.style) {
                                    case "bold":
                                        subStyle = PrinterConst.Font.BOLD;
                                        break;
                                    case "underline":
                                        subStyle = PrinterConst.Font.UNDERLINE;
                                        break;
                                    case "reverse":
                                        subStyle = PrinterConst.Font.REVERSE;
                                        break;
                                    default:
                                        subStyle = PrinterConst.Font.DEFAULT;
                                        break;
                                }
                                switch (structure.items_subaddon.size) {
                                    case "size1":
                                        subWidthSize = PrinterConst.WidthSize.SIZE1;
                                        subHeightSize = PrinterConst.HeightSize.SIZE1;
                                        break;
                                    case "size2":
                                        subWidthSize = PrinterConst.WidthSize.SIZE2;
                                        subHeightSize = PrinterConst.HeightSize.SIZE2;
                                        break;
                                    case "size3":
                                        subWidthSize = PrinterConst.WidthSize.SIZE3;
                                        subHeightSize = PrinterConst.HeightSize.SIZE3;
                                        break;
                                    default:
                                        subWidthSize = PrinterConst.WidthSize.SIZE0;
                                        subHeightSize = PrinterConst.HeightSize.SIZE0;
                                        break;
                                }
                                switch (structure.items_subaddon.alignment) {
                                    case "center":
                                        subAlignment = PrinterConst.Alignment.CENTER;
                                        break;
                                    case "right":
                                        subAlignment = PrinterConst.Alignment.RIGHT;
                                        break;
                                    default:
                                        subAlignment = PrinterConst.Alignment.LEFT;
                                        break;
                                }
                                if (structure.items_subaddon.visibility) {
                                    zonerich.Prn_PrintText("Choose Your Base:" + "\n", subAlignment, subStyle, subWidthSize | subHeightSize);
                                }
                                for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                    List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                    if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                        continue;
                                    }

                                    String subdomainPrintText;
                                    if (subWidthSize == PrinterConst.WidthSize.SIZE1 || subWidthSize == PrinterConst.WidthSize.SIZE0) {
                                        if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                            if (orderItemAddon.quantity > 1) {
                                                subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, "", subWidthSize, "  - " + orderItemAddon.quantity + "x");
                                            } else {
                                                if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                    subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, "", subWidthSize, "");
                                                } else {
                                                    subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, "", subWidthSize, "  -   ");
                                                }
                                            }
                                        } else {
                                            if (orderItemAddon.quantity > 1) {
                                                subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), subWidthSize, "  - " + orderItemAddon.addon_name + "x");
                                            } else {
                                                subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), subWidthSize, "  -   ");
                                            }
                                        }
                                        zonerich.Prn_PrintText(subdomainPrintText + "\n", subAlignment, subStyle, subWidthSize | subHeightSize);
                                    } else {
                                        if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                            // commenting the condition as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                /*if (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                } else {*/
                                            if (orderItemAddon.quantity > 1) {
                                                subdomainPrintText = "- " + orderItemAddon.quantity + "x " + orderItemAddon.addon_name + "\n";
                                            } else {
                                                if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                    subdomainPrintText = "" + orderItemAddon.addon_name + "\n";
                                                } else {
                                                    subdomainPrintText = "- 1x " + orderItemAddon.addon_name + "\n";
                                                }
                                            }
                                            //}
                                        } else {
                                            length = String.valueOf(formatter.format(orderItemAddon.total)).length();
                                            if (length <= 7 && length > 2) {
                                                if (length == 4) {
                                                    format = "    " + formatter.format(orderItemAddon.total);
                                                }
                                                if (length == 5) {
                                                    format = "   " + formatter.format(orderItemAddon.total);
                                                }

                                                if (length == 6) {
                                                    format = "  " + formatter.format(orderItemAddon.total);
                                                }
                                                if (length == 7) {
                                                    format = " " + formatter.format(orderItemAddon.total);
                                                }
                                            } else {
                                                format = formatter.format(orderItemAddon.total);
                                            }
                                            productName = orderItemAddon.addon_name;
                                            price = (!kitchenCopy) ? format : "";
                                            productQty = "" + orderItemAddon.quantity;
                                            qty = productQty;

                                            if (productQty.length() <= 1) {
                                                qty = "- " + productQty + "x ";
                                            } else if (productQty.length() <= 2) {
                                                qty = "- " + productQty + "x ";

                                            } else if (productQty.length() <= 3) {
                                                qty = "- " + productQty + "x ";

                                            } else if (productQty.length() <= 4) {
                                                qty = "- " + productQty + "x";
                                            }

                                            if (kitchenCopy)
                                                itemName = qty + productName;
                                            else {
                                                if (length == 3)
                                                    itemName = getProductNameWithPad(qty + productName, price, 40);
                                                else if (length <= 8 && length >= 4)
                                                    itemName = getProductNameWithPad(qty + productName, price, 39);
                                                else
                                                    itemName = getProductNameWithPad(qty + productName, price, 38);
                                            }
                                            subdomainPrintText = itemName;
                                        }
                                        zonerich.Prn_PrintText(subdomainPrintText, subAlignment, subStyle, subWidthSize | subHeightSize);
                                    }
                                }
                            }

                            for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                                String ingredientName = orderItemIngredient.ingredient_name;
                                if (orderItemIngredient.with) {
                                    ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                                }
                                if (orderItemIngredient.without) {
                                    ingredientName = "  " + "No " + ingredientName;
                                }
                                String subdomainPrintText = ingredientName + "\n";
                                zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                            }

                            lastItemWasMisc = productDetail.misc;
                            lastBlockId = productDetail.block_id;


                            if (all_separator && orderDetail.order_items.size() > position) {
                                zonerich.Prn_PrintText("------------------------------------------------\n",
                                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                            }
                            if (!all_separator && isBlockName) {
                                zonerich.Prn_PrintText("\n", alignment, style, widthSize | heightSize);
                            }
                        }
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "subtotal":
                    case "gratuity":
                    case "delivery_charge":
                    case "service_charge":
                    case "grand_total":
                    case "discount": {
                        if (printTotalInPrint) {
                            String formattedValue = "";
                            String titleOfTotal = "";
                            if (key.equalsIgnoreCase("gratuity")) {
                                if (orderDetail.gratuity > 0) {
                                    formattedValue = MyApp.df.format(orderDetail.gratuity);
                                }
                                titleOfTotal = "GRATUITY";
                            } else if (key.equalsIgnoreCase("discount")) {
                                if (orderDetail.discount > 0)
                                    formattedValue = MyApp.df.format(orderDetail.discount);
                                titleOfTotal = "DISCOUNT";
                            } else if (key.equalsIgnoreCase("grand_total")) {
                                if (orderDetail.total > 0)
                                    formattedValue = MyApp.df.format(orderDetail.total - voucherPaymentDoneAmount);
                                titleOfTotal = "TOTAL";
                            } else if (key.equalsIgnoreCase("service_charge")) {
                                if (orderDetail.service_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.service_charge);
                                titleOfTotal = "SERVICE CHARGE";
                            } else if (key.equalsIgnoreCase("delivery_charge")) {
                                if (orderDetail.delivery_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.delivery_charge);
                                titleOfTotal = "DELIVERY CHARGE";
                            } else if (key.equalsIgnoreCase("subtotal")) {
                                formattedValue = MyApp.df.format(orderDetail.sub_total);
                                titleOfTotal = "SUB TOTAL";
                            }
                            if (!Validators.isNullOrEmpty(formattedValue)) {
                                int length = formattedValue.length();
                                String price = null;
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        price = "    " + formattedValue;
                                    }
                                    if (length == 5) {
                                        price = "   " + formattedValue;
                                    }

                                    if (length == 6) {
                                        price = "  " + formattedValue;
                                    }
                                    if (length == 7) {
                                        price = " " + formattedValue;
                                    }
                                } else {
                                    price = formatter.format(orderDetail.sub_total);
                                }
                                String finalTitleToPrint = "";
                                if (length == 3) {
                                    if (widthSize == PrinterConst.WidthSize.SIZE1) {
                                        padRightSpaces(titleOfTotal + price, 20);
                                    } else {
                                        finalTitleToPrint = getProductNameWithPad(titleOfTotal, price, 40);
                                    }
                                } else if (length <= 8 && length >= 4) {
                                    if (widthSize == PrinterConst.WidthSize.SIZE1) {
                                        finalTitleToPrint = padRightSpaces(titleOfTotal, 16) + "" + price;
                                    } else {
                                        finalTitleToPrint = getProductNameWithPad(titleOfTotal, price, 39);
                                    }
                                } else {
                                    finalTitleToPrint = getProductNameWithPad(titleOfTotal, price, 38);
                                }
                                zonerich.Prn_PrintText(finalTitleToPrint + "\n", alignment, style, widthSize | heightSize);

                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                                /*if(key.equalsIgnoreCase("grand_total")){
                                    if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                                            structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility){
                                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                                    }
                                }*/
                        }
                        break;
                    }
                    case "payment_detail": {
                        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                            if (Objects.equals(key, "payment_detail_header")) {
                                zonerich.Prn_PrintText("Payment Details: " + "\n", alignment, style, widthSize | heightSize);
                            }
                            if (structure.payment_detail.visibility) {
                                if (Objects.equals(key, "payment_detail")) {
                                    zonerich.Prn_PrintText("Payment Details: " + "\n", alignment, style, widthSize | heightSize);
                                    for (OrderPayment orderPayment : orderDetail.order_payments) {
                                        String paymentDetailToPrint = null;
                                        if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                            paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                        } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                            paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                        } else {
                                            paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                        }
                                        zonerich.Prn_PrintText(paymentDetailToPrint, alignment, style,
                                                widthSize | heightSize);
                                    }
                                    //zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                                }
                            } else {
                                //zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                            }
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "serve_by": {
                        zonerich.Prn_PrintText("Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username + "\n",
                                alignment, style, widthSize | heightSize);
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "customer_detail": {
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name))
                            zonerich.Prn_PrintText("" + orderDetail.customer_name + "\n", alignment, style,
                                    widthSize | heightSize);

                        String fulladdress = null;
                        if (orderType == 3) {
                               /*     fulladdress = "" + orderDetail.customer.house_no + ","
                                            + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                            orderDetail.customer.country + ", " + orderDetail.customer.postcode;*/
                            //fulladdress =  formatAddress(orderDetail,widthSize);
                            fulladdress = formatAddress(orderDetail);
                            zonerich.Prn_PrintText(fulladdress + "\n", alignment, style,
                                    widthSize | heightSize);
                        }
                        if (orderDetail.customer != null) {
                            if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                                zonerich.Prn_PrintText("" + orderDetail.customer.mobile + "\n", alignment, style,
                                        widthSize | heightSize);
                            }
                            if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress))
                                if (isSpeartor) {
                                    printSeparator();
                                }
                        }
                        break;
                    }
                    case "payment_status": {
                        if (orderDetail.total_paid == 0) {
                            //zonerich.Prn_PrintText("Payment Status: " + settingMap.get("unpaid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                            zonerich.Prn_PrintText("" + settingMap.get("unpaid_payment_title").toUpperCase() + "\n", alignment, style, widthSize | heightSize);
                        } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                            //zonerich.Prn_PrintText("Payment Status: " + settingMap.get("paid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                            zonerich.Prn_PrintText("" + settingMap.get("paid_payment_title").toUpperCase() + "\n", alignment, style, widthSize | heightSize);
                        } else if (orderDetail.total_paid > 0) {
                            //zonerich.Prn_PrintText("Payment Status: " + settingMap.get("partial_payment_title") + "\n", alignment, style, widthSize | heightSize);
                            zonerich.Prn_PrintText("" + settingMap.get("partial_payment_title").toUpperCase() + "\n", alignment, style, widthSize | heightSize);
                        }
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "order_comment": {
                        if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                            zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", alignment, style,
                                    widthSize | heightSize);

                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                            zonerich.Prn_PrintText("Requested Time" + orderDetail.delivery_collection_time_slot + "\n",
                                    PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
                        }
                        break;
                    }
                    case "footer_order_type": {
                        if (!Validators.isNullOrEmpty(orderTypeHeading) && kitchenCopy) {
                            zonerich.Prn_PrintText("" + orderTypeHeading.toUpperCase() + "" + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "footer_table_number": {
                        if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                            zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "footer_order_number": {
                        if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            zonerich.Prn_PrintText("Order No: " + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        } else {
                            if (orderDetail._id != 0) {
                                zonerich.Prn_PrintText("Order No: " + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer": {
                        if (!Validators.isNullOrEmpty(footerA)) {
                            zonerich.Prn_PrintText(footerA + "\n", alignment, style, widthSize | heightSize);
                        }
                        if (!Validators.isNullOrEmpty(footerB)) {
                            zonerich.Prn_PrintText(footerB + "\n", alignment, style, widthSize | heightSize);
                        }
                    }
                    if (isSpeartor) {
                        printSeparator();
                    }
                    break;
                }

            }

            if (printTotalInPrint) {
                if (structure.order_comment == null) {
                    if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                        if (kitchenCopy) {
                            zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                    PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                        } else {
                            zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                        zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            }
            if (structure.header_customer_name != null) {
                if (structure.header_customer_name.visibility && kitchenCopy) {
                    switch (structure.header_customer_name.style) {
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") || orderDetail.order_type_id.equalsIgnoreCase("5")) {
                        zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                    }
                }
            }
            if (!kitchenCopy && MyApp.getInstance().paymentLinkBitmap != null) {
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(MyApp.getInstance().paymentLinkBitmap, PrinterConst.BitmapSize.ZQSIZE0);
            }
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);
            // set print true for local device
            setPrint(myPreferences, true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();
            //writeToSDFile("Prn_CutPaper is " + zonerich.Prn_CutPaper(), "zonerichPrinterCutPaperSuccess.txt");
            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title != null ? title : "");
            sendOrderWifiModel.setTicketHeaderSetting(ticket_header != null ? ticket_header : "");
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
            sendOrderWifiModel.setOrderDetail(orderDetail);
            sendOrderWifiModel.setPrintStructure(structure);
            sendOrderWifiModel.setFooterA(footerA != null ? footerA : "");
            sendOrderWifiModel.setFooterB(footerB != null ? footerB : "");
            sendOrderWifiModel.setOrderTypeHeading(orderTypeHeading != null ? orderTypeHeading : "");
            sendOrderWifiModel.setSettingsMap(settingMap);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            if (printBlockBill != null) {
                sendOrderWifiModel.setPrintBlockBill(printBlockBill);
            }
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOS);
            sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username != null ? MyApp.getInstance().myPreferences.getLoggedInUser().username : "");
            sendOrderToWifi(sendOrderWifiModel);
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    private void printBlockText(OrderItem productDetail,boolean isBlockName){
        if(Validators.isNullOrEmpty(productDetail.block_name) || !isBlockName){
            zonerich.Prn_PrintText("----------------------------------\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }else {
            zonerich.Prn_PrintText(MyApp.getInstance().getBlockText(34,productDetail.block_name)+"\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
    }

    private String calculateNumberOfLines(String productName, String format, int widthSize, String qty) {
        String[] productNameSplit = productName.split(" ");
        String finalPrice = "  " + format.trim();
        String secondLine = qty;
        int lengthForSize = widthSize == PrinterConst.WidthSize.SIZE0 ? 48 : 24;
        int multiplyLength = 1;
        int index = 0;
        for (String s : productNameSplit) {
            index = index + 1;
            Log.e("finalPrice", "finalPrice " + finalPrice + "string to apend " + s.length());
            if (secondLine.length() < (multiplyLength * lengthForSize)) {
                if ((secondLine + " " + s + finalPrice).length() > (multiplyLength * lengthForSize)) {
                    //secondLine = secondLine+secondLine.replace(,"");
                    int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                    if (multiplyLength == 1) {
                        emptySpaceLength = emptySpaceLength - finalPrice.length();
                        for (int space = 0; space < emptySpaceLength; space++) {
                            secondLine = secondLine + (" ");
                        }
                        secondLine = secondLine + finalPrice;
                    } else {
                        for (int space = 0; space < emptySpaceLength; space++) {
                            secondLine = secondLine + (" ");
                        }
                    }
                    multiplyLength = multiplyLength + 1;
                    secondLine = secondLine + ("\n");
                    for (int j = 0; j < qty.length(); j++) {
                        secondLine = secondLine + (" ");
                    }
                }
            } else {
                multiplyLength = multiplyLength + 1;
                secondLine = secondLine + ("\n");
                for (int j = 0; j < qty.length(); j++) {
                    secondLine = secondLine + (" ");
                }
            }
            secondLine = secondLine + " " + s;
            //if(productNameSplit.length==1 && multiplyLength==1 &&secondLine.length() < (multiplyLength * lengthForSize)){
            // in last index need to compare length of the item with numbers of line in print
            if (productNameSplit.length == index && multiplyLength == 1 && secondLine.length() < (multiplyLength * lengthForSize)) {
                if (multiplyLength == 1) {
                    int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                    emptySpaceLength = emptySpaceLength - finalPrice.length();
                    for (int space = 0; space < emptySpaceLength; space++) {
                        secondLine = secondLine + (" ");
                    }
                    secondLine = secondLine + finalPrice;
                }
            }
        }
        return secondLine;
    }

    private void sendOrderToWifi(SendOrderWifiModel sendOrderWifiModel) {
        if (MyApp.getInstance().myPreferences.getWifiConnectionId() != null && "auto".equalsIgnoreCase(MyApp.getInstance().myPreferences.getOrderSyncMode())) {
            //Logger.INSTANCE.sendText(MyApp.getInstance().myPreferences.getWifiConnectionId(), new Gson().toJson(sendOrderWifiModel));
        }
    }

    public void printOrderEposNew(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, PrintStructure structure, boolean printTotalInPrint, String footerA, String footerB, String orderTypeHeader, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        int style = 0, widthSize = 0, heightSize = 0, alignment = 0;

        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");
        try {
            if (!kitchenCopy && tiffintomLogo != null) {
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            if (!kitchenCopy) {

                if (headerAlignment < 2)
                    zonerich.Prn_PrintText(ticket_header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                else {
                    String[] headers = ticket_header.split("\n");
                    for (String h : headers) {
                        zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            }
            if (kitchenCopy) {
                if (structure.header_order_type.visibility && kitchenCopy) {
                    switch (structure.header_order_type.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_order_type.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_order_type.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderTypeHeader)) {
                        zonerich.Prn_PrintText("** " + orderTypeHeader + " **" + "\n", alignment, style, widthSize | heightSize);
                    }

                }
                // footer table number
                if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                    switch (structure.footer_table_number.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.footer_table_number.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.footer_table_number.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                    }
                }
                // footer order number
                if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                    switch (structure.footer_order_number.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.footer_order_number.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.footer_order_number.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        zonerich.Prn_PrintText("Order No: " + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                    } else {
                        if (orderDetail._id != 0) {
                            zonerich.Prn_PrintText("Order No: " + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                        }
                    }
                }
                if (structure.header_customer_name != null) {
                    if (structure.header_customer_name.visibility && kitchenCopy) {
                        switch (structure.header_customer_name.style) {
                            case "default":
                                style = PrinterConst.Font.DEFAULT;
                                break;
                            case "bold":
                                style = PrinterConst.Font.BOLD;
                                break;
                            case "underline":
                                style = PrinterConst.Font.UNDERLINE;
                                break;
                            case "reverse":
                                style = PrinterConst.Font.REVERSE;
                                break;
                            default:
                                style = PrinterConst.Font.DEFAULT;
                                break;
                        }

                        switch (structure.header_customer_name.size) {
                            case "size0":
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                            case "size1":
                                widthSize = PrinterConst.WidthSize.SIZE1;
                                heightSize = PrinterConst.HeightSize.SIZE1;
                                break;
                            case "size2":
                                widthSize = PrinterConst.WidthSize.SIZE2;
                                heightSize = PrinterConst.HeightSize.SIZE2;
                                break;
                            case "size3":
                                widthSize = PrinterConst.WidthSize.SIZE3;
                                heightSize = PrinterConst.HeightSize.SIZE3;
                                break;
                            default:
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                        }

                        switch (structure.header_customer_name.alignment) {
                            case "left":
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = PrinterConst.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = PrinterConst.Alignment.RIGHT;
                                break;
                            default:
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                        }
                        if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                        }
                    }
                }
            }
            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            if (structure.title.visibility) {
                switch (structure.title.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.title.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.title.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(title)) {
                    zonerich.Prn_PrintText("\n" + title + "\n", alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            if (structure.order_no != null) {
                if (structure.order_no.visibility) {
                    switch (structure.order_no.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_no.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_no.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    String orderIdText = null;
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        orderIdText = "Order ID: " + orderDetail._id;
                    } else
                        orderIdText = "Order ID: " + orderDetail.display_order_id;

                    zonerich.Prn_PrintText(orderIdText + "\n", alignment, style, widthSize | heightSize);
                    if (kitchenCopy)
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            } else {
                if (tableNumberOrderIdMode != null) {
                    String tableNumberOrderIdText = "";
                    if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                        } else
                            tableNumberOrderIdText = "Order ID: " + orderDetail.display_order_id;
                    }
                    zonerich.Prn_PrintText(tableNumberOrderIdText, PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (structure.table_no != null && structure.no_of_diners != null) {
                if (structure.table_no.visibility && structure.no_of_diners.visibility && orderType == 1) {
                    switch (structure.table_no.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.table_no.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.table_no.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    zonerich.Prn_PrintText("Table No: " + orderDetail.table_number, alignment, style, widthSize | heightSize);

                    switch (structure.no_of_diners.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.no_of_diners.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.no_of_diners.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    zonerich.Prn_PrintText("   No of Diner: " + orderDetail.no_guest + "\n", alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            } else {
                if (tableNumberOrderIdMode != null) {
                    String tableNumberOrderIdText = "";
                    if (orderType == 1 && (tableNumberOrderIdMode.equalsIgnoreCase("table_number") || tableNumberOrderIdMode.equalsIgnoreCase("both"))) {
                        if (tableNumberOrderIdText.length() > 1) {
                            tableNumberOrderIdText = tableNumberOrderIdText + "\n";
                        }
                        tableNumberOrderIdText = tableNumberOrderIdText + "Table No: " + orderDetail.table_number + "  No of Diners:  " + orderDetail.no_guest;
                    }

                    if (tableNumberOrderIdMode.equalsIgnoreCase("none")) {
                        tableNumberOrderIdText = "";
                    }

                    if (tableNumberOrderIdMode.length() > 0) {
                        if (!Validators.isNullOrEmpty(title)) {
                            tableNumberOrderIdText = "\n------------------------------------------------\n" + tableNumberOrderIdText + "\n------------------------------------------------\n";
                        } else {
                            tableNumberOrderIdText = tableNumberOrderIdText + "\n------------------------------------------------\n";
                        }
                        zonerich.Prn_PrintText(tableNumberOrderIdText, PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }

                }

            }
            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                    if (orderDetail.updated_at.contains("Z")) {
                        receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                    } else {
                        receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                    }
                }
            }

            if (structure.order_date != null) {
                if (structure.order_date.visibility) {
                    switch (structure.order_date.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_date.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_date.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDate))
                        if (structure.order_time != null && structure.order_time.visibility) {
                            zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                        } else {
                            zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                            zonerich.Prn_PrintText("\n------------------------------------------------\n",
                                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                        }
                }

            }
            if (structure.order_time != null) {
                if (structure.order_time.visibility) {
                    switch (structure.order_time.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_time.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }
                    switch (structure.order_time.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    if (!Validators.isNullOrEmpty(orderTime)) {
                        zonerich.Prn_PrintText("Time :" + orderTime + "\n", alignment, style, widthSize | heightSize);
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            }

/*
            if (!Validators.isNullOrEmpty(dateTimeMode)) {
                String dateFormat = "dd-MM-yyyy hh:mm a";
                String dateFormatTitle = "Order Date Time: ";
                if (dateTimeMode.equalsIgnoreCase("date_time")) {
                    dateFormat = "dd-MM-yyyy hh:mm a";
                    dateFormatTitle = "Order Date Time: ";
                }
                if (dateTimeMode.equalsIgnoreCase("time")) {
                    dateFormat = "hh:mm a";
                    dateFormatTitle = "Order Time: ";
                }
                if (dateTimeMode.equalsIgnoreCase("date")) {
                    dateFormat = "dd-MM-yyyy";
                    dateFormatTitle = "Order Date: ";
                }
                if (orderDetail.created_at.contains("Z")) {
                    zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                } else {
                    zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, dateFormat) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
*/
            if (orderType > 1 && !kitchenCopy) {
                zonerich.Prn_PrintText("Order Type: " + orderDetail.order_type + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.items_header.visibility) {
                switch (structure.items_header.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items_header.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items_header.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Qty  Name" + "\n", alignment, style, widthSize | heightSize);
            }

            if (structure.items.visibility) {
                switch (structure.items.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.items.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.items.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }

                String itemName = "", price = "", qty = "";
                String lastBlockId = null;
                boolean lastItemWasMisc = false;

                for (OrderItem productDetail : orderDetail.order_items) {
                    String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                    String productQty = String.valueOf(productDetail.quantity);
                    qty = productQty;

                    if (productQty.length() <= 1) {
                        qty = productQty + " ";
                    } else if (productQty.length() <= 2) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 3) {
                        qty = productQty + " ";

                    } else if (productQty.length() <= 4) {
                        qty = productQty + "";
                    }

                    int length = String.valueOf(formatter.format(productDetail.total)).length();
                    String format = null;
                    if (length <= 7 && length > 2) {
                        if (length == 4) {
                            format = "    " + formatter.format(productDetail.total);
                        }
                        if (length == 5) {
                            format = "   " + formatter.format(productDetail.total);
                        }

                        if (length == 6) {
                            format = "  " + formatter.format(productDetail.total);
                        }
                        if (length == 7) {
                            format = " " + formatter.format(productDetail.total);
                        }
                    } else {
                        format = formatter.format(productDetail.total);
                    }
                    price = (!kitchenCopy) ? format : "";
                    if (kitchenCopy)
                        itemName = qty + productName;
                    else {
                        if (length == 3)
                            itemName = getProductNameWithPad(qty + productName, price, 40);
                        else if (length <= 8 && length >= 4)
                            itemName = getProductNameWithPad(qty + productName, price, 39);
                        else
                            itemName = getProductNameWithPad(qty + productName, price, 38);
                    }

                    if (lastBlockId != null) {
                        if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                            if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                zonerich.Prn_PrintText("----------------------------------\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                    } else {
                        if (lastItemWasMisc && !productDetail.misc) {
                            if (kitchenCopy)
                                zonerich.Prn_PrintText("----------------------------------\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                    }

                    String printItem;
                    printItem = itemName + "\n";


                    zonerich.Prn_PrintText(printItem, alignment, style, widthSize | heightSize);
                    if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                        zonerich.Prn_PrintText("  " + "Instruction: " + productDetail.special_instruction + "\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);

                    if (productDetail.order_item_addons.size() > 0) {
                        if (structure.items_subaddon.visibility) {
                            int subStyle, subWidthSize, subHeightSize, subAlignment;
                            switch (structure.items_subaddon.style) {
                                case "default":
                                    subStyle = PrinterConst.Font.DEFAULT;
                                    break;
                                case "bold":
                                    subStyle = PrinterConst.Font.BOLD;
                                    break;
                                case "underline":
                                    subStyle = PrinterConst.Font.UNDERLINE;
                                    break;
                                case "reverse":
                                    subStyle = PrinterConst.Font.REVERSE;
                                    break;
                                default:
                                    subStyle = PrinterConst.Font.DEFAULT;
                                    break;
                            }

                            switch (structure.items_subaddon.size) {
                                case "size0":
                                    subWidthSize = PrinterConst.WidthSize.SIZE0;
                                    subHeightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                                case "size1":
                                    subWidthSize = PrinterConst.WidthSize.SIZE1;
                                    subHeightSize = PrinterConst.HeightSize.SIZE1;
                                    break;
                                case "size2":
                                    subWidthSize = PrinterConst.WidthSize.SIZE2;
                                    subHeightSize = PrinterConst.HeightSize.SIZE2;
                                    break;
                                case "size3":
                                    subWidthSize = PrinterConst.WidthSize.SIZE3;
                                    subHeightSize = PrinterConst.HeightSize.SIZE3;
                                    break;
                                default:
                                    subWidthSize = PrinterConst.WidthSize.SIZE0;
                                    subHeightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                            }

                            switch (structure.items_subaddon.alignment) {
                                case "left":
                                    subAlignment = PrinterConst.Alignment.LEFT;
                                    break;
                                case "center":
                                    subAlignment = PrinterConst.Alignment.CENTER;
                                    break;
                                case "right":
                                    subAlignment = PrinterConst.Alignment.RIGHT;
                                    break;
                                default:
                                    subAlignment = PrinterConst.Alignment.LEFT;
                                    break;
                            }
                            zonerich.Prn_PrintText("Choose Your Base:" + "\n", subAlignment, subStyle, subWidthSize | subHeightSize);

                            for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                    continue;
                                }

                                String subdomainPrintText;
                                if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                    if (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                        subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                    } else {
                                        subdomainPrintText = "  " + orderItemAddon.quantity + " " + orderItemAddon.addon_name + "\n";
                                    }
                                } else {
                                    length = String.valueOf(formatter.format(orderItemAddon.total)).length();
                                    if (length <= 7 && length > 2) {
                                        if (length == 4) {
                                            format = "    " + formatter.format(orderItemAddon.total);
                                        }
                                        if (length == 5) {
                                            format = "   " + formatter.format(orderItemAddon.total);
                                        }

                                        if (length == 6) {
                                            format = "  " + formatter.format(orderItemAddon.total);
                                        }
                                        if (length == 7) {
                                            format = " " + formatter.format(orderItemAddon.total);
                                        }
                                    } else {
                                        format = formatter.format(orderItemAddon.total);
                                    }
                                    productName = orderItemAddon.addon_name;
                                    price = (!kitchenCopy) ? format : "";
                                    productQty = "" + orderItemAddon.quantity;
                                    qty = productQty;

                                    if (productQty.length() <= 1) {
                                        qty = productQty + " ";
                                    } else if (productQty.length() <= 2) {
                                        qty = productQty + " ";

                                    } else if (productQty.length() <= 3) {
                                        qty = productQty + " ";

                                    } else if (productQty.length() <= 4) {
                                        qty = productQty + "";
                                    }

                                    if (kitchenCopy)
                                        itemName = qty + productName;
                                    else {
                                        if (length == 3)
                                            itemName = getProductNameWithPad(qty + productName, price, 40);
                                        else if (length <= 8 && length >= 4)
                                            itemName = getProductNameWithPad(qty + productName, price, 39);
                                        else
                                            itemName = getProductNameWithPad(qty + productName, price, 38);
                                    }
                                    subdomainPrintText = itemName;
                                }

                                //String subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                zonerich.Prn_PrintText(subdomainPrintText, subAlignment, subStyle, subWidthSize | subHeightSize);
                            }
                        }
                    }

                    for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                        String ingredientName = orderItemIngredient.ingredient_name;
                        if (orderItemIngredient.with) {
                            ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                        }
                        if (orderItemIngredient.without) {
                            ingredientName = "  " + "No " + ingredientName;
                        }
                        String subdomainPrintText = ingredientName + "\n";
                        zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }

                    lastItemWasMisc = productDetail.misc;
                    lastBlockId = productDetail.block_id;
                }
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (printTotalInPrint) {
                if (structure.subtotal.visibility) {
                    switch (structure.subtotal.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.subtotal.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.subtotal.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    zonerich.Prn_PrintText("Sub Total: " + MyApp.df.format(orderDetail.sub_total) + "\n", alignment, style, widthSize | heightSize);
                }
                if (structure.delivery_charge.visibility) {
                    switch (structure.delivery_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.delivery_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.delivery_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.delivery_charge > 0)
                        zonerich.Prn_PrintText("Delivery Charge: " + MyApp.df.format(orderDetail.delivery_charge) + "\n", alignment, style, widthSize | heightSize);
                }
                if (structure.gratuity.visibility) {
                    switch (structure.gratuity.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.gratuity.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.gratuity.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.gratuity > 0)
                        zonerich.Prn_PrintText("Gratuity: " + MyApp.df.format(orderDetail.gratuity) + "\n", alignment, style, widthSize | heightSize);
                }
                if (structure.service_charge.visibility) {
                    switch (structure.service_charge.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.service_charge.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.service_charge.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.service_charge > 0)
                        zonerich.Prn_PrintText("Service Charge: " + MyApp.df.format(orderDetail.service_charge) + "\n", alignment, style, widthSize | heightSize);
                }
                if (structure.discount.visibility) {
                    switch (structure.discount.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.discount.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.discount.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.discount > 0)
                        zonerich.Prn_PrintText("Discount: " + MyApp.df.format(orderDetail.discount) + "\n", alignment, style, widthSize | heightSize);
                }
                if (structure.grand_total.visibility) {
                    switch (structure.grand_total.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.grand_total.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.grand_total.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    zonerich.Prn_PrintText("Total: " + MyApp.df.format(orderDetail.total) + "\n", alignment, style, widthSize | heightSize);
                }

                if (structure.subtotal.visibility || structure.discount.visibility || structure.delivery_charge.visibility ||
                        structure.service_charge.visibility || structure.gratuity.visibility || structure.grand_total.visibility)
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.payment_detail != null) {
                if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                    if (structure.payment_detail_header != null)
                        if (structure.payment_detail_header.visibility) {
                            switch (structure.payment_detail_header.style) {
                                case "default":
                                    style = PrinterConst.Font.DEFAULT;
                                    break;
                                case "bold":
                                    style = PrinterConst.Font.BOLD;
                                    break;
                                case "underline":
                                    style = PrinterConst.Font.UNDERLINE;
                                    break;
                                case "reverse":
                                    style = PrinterConst.Font.REVERSE;
                                    break;
                                default:
                                    style = PrinterConst.Font.DEFAULT;
                                    break;
                            }

                            switch (structure.payment_detail_header.size) {
                                case "size0":
                                    widthSize = PrinterConst.WidthSize.SIZE0;
                                    heightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                                case "size1":
                                    widthSize = PrinterConst.WidthSize.SIZE1;
                                    heightSize = PrinterConst.HeightSize.SIZE1;
                                    break;
                                case "size2":
                                    widthSize = PrinterConst.WidthSize.SIZE2;
                                    heightSize = PrinterConst.HeightSize.SIZE2;
                                    break;
                                case "size3":
                                    widthSize = PrinterConst.WidthSize.SIZE3;
                                    heightSize = PrinterConst.HeightSize.SIZE3;
                                    break;
                                default:
                                    widthSize = PrinterConst.WidthSize.SIZE0;
                                    heightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                            }

                            switch (structure.payment_detail_header.alignment) {
                                case "left":
                                    alignment = PrinterConst.Alignment.LEFT;
                                    break;
                                case "center":
                                    alignment = PrinterConst.Alignment.CENTER;
                                    break;
                                case "right":
                                    alignment = PrinterConst.Alignment.RIGHT;
                                    break;
                                default:
                                    alignment = PrinterConst.Alignment.LEFT;
                                    break;
                            }
                            zonerich.Prn_PrintText("Payment Details: " + "\n", alignment, style, widthSize | heightSize);

                        }

                    if (structure.payment_detail != null)
                        if (structure.payment_detail.visibility) {
                            switch (structure.payment_detail.style) {
                                case "default":
                                    style = PrinterConst.Font.DEFAULT;
                                    break;
                                case "bold":
                                    style = PrinterConst.Font.BOLD;
                                    break;
                                case "underline":
                                    style = PrinterConst.Font.UNDERLINE;
                                    break;
                                case "reverse":
                                    style = PrinterConst.Font.REVERSE;
                                    break;
                                default:
                                    style = PrinterConst.Font.DEFAULT;
                                    break;
                            }

                            switch (structure.payment_detail.size) {
                                case "size0":
                                    widthSize = PrinterConst.WidthSize.SIZE0;
                                    heightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                                case "size1":
                                    widthSize = PrinterConst.WidthSize.SIZE1;
                                    heightSize = PrinterConst.HeightSize.SIZE1;
                                    break;
                                case "size2":
                                    widthSize = PrinterConst.WidthSize.SIZE2;
                                    heightSize = PrinterConst.HeightSize.SIZE2;
                                    break;
                                case "size3":
                                    widthSize = PrinterConst.WidthSize.SIZE3;
                                    heightSize = PrinterConst.HeightSize.SIZE3;
                                    break;
                                default:
                                    widthSize = PrinterConst.WidthSize.SIZE0;
                                    heightSize = PrinterConst.HeightSize.SIZE0;
                                    break;
                            }

                            switch (structure.payment_detail.alignment) {
                                case "left":
                                    alignment = PrinterConst.Alignment.LEFT;
                                    break;
                                case "center":
                                    alignment = PrinterConst.Alignment.CENTER;
                                    break;
                                case "right":
                                    alignment = PrinterConst.Alignment.RIGHT;
                                    break;
                                default:
                                    alignment = PrinterConst.Alignment.LEFT;
                                    break;
                            }


                            for (OrderPayment orderPayment : orderDetail.order_payments) {
                                String paymentDetailToPrint = null;
                                if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                    paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                    paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                } else {
                                    paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                }
                                zonerich.Prn_PrintText(paymentDetailToPrint, alignment, style,
                                        widthSize | heightSize);
                            }
                            zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        } else {
                            zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        }
                }

            } else {
                if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {

                    zonerich.Prn_PrintText("Payment Details:" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    for (OrderPayment orderPayment : orderDetail.order_payments) {
                        String paymentDetailToPrint = null;
                        if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                            paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                        } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                            paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                        } else {
                            paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                        }
                        zonerich.Prn_PrintText(paymentDetailToPrint, PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                    zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }

            }
            if (structure.serve_by != null) {
                if (structure.serve_by.visibility) {
                    switch (structure.serve_by.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.serve_by.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.serve_by.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    zonerich.Prn_PrintText("Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username + "\n",
                            alignment, style, widthSize | heightSize);
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            } else {
                String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
                zonerich.Prn_PrintText(toprint + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.customer_detail != null) {
                if (structure.customer_detail.visibility) {
                    switch (structure.customer_detail.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.customer_detail.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.customer_detail.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name))
                        zonerich.Prn_PrintText("Cust Name: " + orderDetail.customer_name + "\n", alignment, style,
                                widthSize | heightSize);

                    if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                        zonerich.Prn_PrintText("Cust No: " + orderDetail.customer.mobile + "\n", alignment, style,
                                widthSize | heightSize);
                    }

                    String fulladdress = null;
                    if (orderType == 3) {
                       /* fulladdress = "Address: " + orderDetail.customer.house_no + ","
                                + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                orderDetail.customer.country + ", " + orderDetail.customer.postcode;*/
                        fulladdress = formatAddress(orderDetail, widthSize);
                        zonerich.Prn_PrintText(fulladdress + "\n", alignment, style,
                                widthSize | heightSize);
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress))
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                }
            } else {
                if (!Validators.isNullOrEmpty(orderDetail.customer_name))
                    zonerich.Prn_PrintText("Cust Name:" + orderDetail.customer_name + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                    zonerich.Prn_PrintText("Cust No:" + orderDetail.customer.mobile + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
                String fulladdress = null;
                if (orderType == 3) {
                  /*  fulladdress = "Address : " + orderDetail.customer.house_no + ","
                            + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                            orderDetail.customer.country + ", " + orderDetail.customer.postcode;*/
                    fulladdress = formatAddress(orderDetail, widthSize);
                    zonerich.Prn_PrintText(fulladdress + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }

                if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress))
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (structure.payment_status != null) {
                if (structure.payment_status.visibility) {
                    switch (structure.payment_status.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.payment_status.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.payment_status.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }

                    if (orderDetail.total_paid == 0) {
                        zonerich.Prn_PrintText("Payment Status: " + settingMap.get("unpaid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                    } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                        zonerich.Prn_PrintText("Payment Status: " + settingMap.get("paid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                    } else if (orderDetail.total_paid > 0) {
                        zonerich.Prn_PrintText("Payment Status: " + settingMap.get("partial_payment_title") + "\n", alignment, style, widthSize | heightSize);
                    }
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }

            }
            if (structure.order_comment != null) {
                if (structure.order_comment.visibility) {
                    switch (structure.order_comment.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.order_comment.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.order_comment.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                        zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", alignment, style,
                                widthSize | heightSize);

                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            } else {
                if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                    if (kitchenCopy) {
                        zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    } else {
                        zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                    zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                zonerich.Prn_PrintText("Requested Time" + orderDetail.delivery_collection_time_slot + "\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
            }

            if (structure.footer_order_type.visibility && kitchenCopy) {
                switch (structure.footer_order_type.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer_order_type.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer_order_type.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(orderTypeHeader)) {
                    zonerich.Prn_PrintText("** " + orderTypeHeader + " **" + "\n", alignment, style, widthSize | heightSize);
                }
            }
            if (structure.header_customer_name != null) {
                if (structure.header_customer_name.visibility && kitchenCopy) {
                    switch (structure.header_customer_name.style) {
                        case "default":
                            style = PrinterConst.Font.DEFAULT;
                            break;
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_customer_name.size) {
                        case "size0":
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_customer_name.alignment) {
                        case "left":
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                        zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                    }
                }
            }

            if (structure.receipt_time != null && structure.receipt_time.visibility && !Validators.isNullOrEmpty(receiptDate)) {
                switch (structure.receipt_time.style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.receipt_time.size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.receipt_time.alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                zonerich.Prn_PrintText("Receipt Date :" + receiptDate + "\n", alignment, style, widthSize | heightSize);
            }

            if (structure.footer.visibility) {
                switch (structure.footer.style) {
                    case "default":
                        style = PrinterConst.Font.DEFAULT;
                        break;
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }

                switch (structure.footer.size) {
                    case "size0":
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }

                switch (structure.footer.alignment) {
                    case "left":
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                if (!Validators.isNullOrEmpty(footerA)) {
                    zonerich.Prn_PrintText(footerA + "\n", alignment, style, widthSize | heightSize);
                }
                if (!Validators.isNullOrEmpty(footerB)) {
                    zonerich.Prn_PrintText(footerB + "\n", alignment, style, widthSize | heightSize);
                }
            }

            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);

            if (isCashDrawerOpen) {
                zonerich.Prn_OpenCashbox();
            }
            // set print true for local device
            setPrint(myPreferences, true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();

            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title);
            sendOrderWifiModel.setTicketHeaderSetting(ticket_header);
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
            sendOrderWifiModel.setOrderDetail(orderDetail);
            sendOrderWifiModel.setCashDrawerOpen(isCashDrawerOpen);
            sendOrderWifiModel.setPrintStructure(structure);
            sendOrderWifiModel.setFooterA(footerA);
            sendOrderWifiModel.setFooterB(footerB);
            sendOrderWifiModel.setOrderTypeHeading(orderTypeHeader);
            sendOrderWifiModel.setSettingsMap(settingMap);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            if (printBlockBill != null) {
                sendOrderWifiModel.setPrintBlockBill(printBlockBill);
            }
            sendOrderWifiModel.setTableNumberOrderIdMode(tableNumberOrderIdMode);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOSNEW);
            sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username);
            sendOrderToWifi(sendOrderWifiModel);
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    public void printOrderEposNewFoodHub(ArrayList<PrintStyle> listPrintStructure, Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, PrintStructure structure, boolean printTotalInPrint, String footerA, String footerB, String orderTypeHeader, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        int style = 0, widthSize = 0, heightSize = 0, alignment = 0;

        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");
        try {
            if (kitchenCopy) {
                if (structure.header_order_type.visibility && kitchenCopy) {
                    switch (structure.header_order_type.style) {
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.header_order_type.size) {
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.header_order_type.alignment) {
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderTypeHeader)) {
                        zonerich.Prn_PrintText("** " + orderTypeHeader + " **" + "\n", alignment, style, widthSize | heightSize);
                    }

                }
                // footer table number
                if (structure.footer_table_number != null && structure.footer_table_number.visibility && kitchenCopy) {
                    switch (structure.footer_table_number.style) {
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.footer_table_number.size) {
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.footer_table_number.alignment) {
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                        zonerich.Prn_PrintText("------------------------------------------------\n",
                                PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                        zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                    }
                }
                // footer order number
                if (structure.footer_order_number != null && structure.footer_order_number.visibility && kitchenCopy) {
                    switch (structure.footer_order_number.style) {
                        case "bold":
                            style = PrinterConst.Font.BOLD;
                            break;
                        case "underline":
                            style = PrinterConst.Font.UNDERLINE;
                            break;
                        case "reverse":
                            style = PrinterConst.Font.REVERSE;
                            break;
                        default:
                            style = PrinterConst.Font.DEFAULT;
                            break;
                    }

                    switch (structure.footer_order_number.size) {
                        case "size1":
                            widthSize = PrinterConst.WidthSize.SIZE1;
                            heightSize = PrinterConst.HeightSize.SIZE1;
                            break;
                        case "size2":
                            widthSize = PrinterConst.WidthSize.SIZE2;
                            heightSize = PrinterConst.HeightSize.SIZE2;
                            break;
                        case "size3":
                            widthSize = PrinterConst.WidthSize.SIZE3;
                            heightSize = PrinterConst.HeightSize.SIZE3;
                            break;
                        default:
                            widthSize = PrinterConst.WidthSize.SIZE0;
                            heightSize = PrinterConst.HeightSize.SIZE0;
                            break;
                    }

                    switch (structure.footer_order_number.alignment) {
                        case "center":
                            alignment = PrinterConst.Alignment.CENTER;
                            break;
                        case "right":
                            alignment = PrinterConst.Alignment.RIGHT;
                            break;
                        default:
                            alignment = PrinterConst.Alignment.LEFT;
                            break;
                    }
                    if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        zonerich.Prn_PrintText("Order No: " + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                    } else {
                        if (orderDetail._id != 0) {
                            zonerich.Prn_PrintText("Order No: " + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                        }
                    }
                }
                if (structure.header_customer_name != null) {
                    if (structure.header_customer_name.visibility && kitchenCopy) {
                        switch (structure.header_customer_name.style) {
                            case "bold":
                                style = PrinterConst.Font.BOLD;
                                break;
                            case "underline":
                                style = PrinterConst.Font.UNDERLINE;
                                break;
                            case "reverse":
                                style = PrinterConst.Font.REVERSE;
                                break;
                            default:
                                style = PrinterConst.Font.DEFAULT;
                                break;
                        }

                        switch (structure.header_customer_name.size) {
                            case "size1":
                                widthSize = PrinterConst.WidthSize.SIZE1;
                                heightSize = PrinterConst.HeightSize.SIZE1;
                                break;
                            case "size2":
                                widthSize = PrinterConst.WidthSize.SIZE2;
                                heightSize = PrinterConst.HeightSize.SIZE2;
                                break;
                            case "size3":
                                widthSize = PrinterConst.WidthSize.SIZE3;
                                heightSize = PrinterConst.HeightSize.SIZE3;
                                break;
                            default:
                                widthSize = PrinterConst.WidthSize.SIZE0;
                                heightSize = PrinterConst.HeightSize.SIZE0;
                                break;
                        }

                        switch (structure.header_customer_name.alignment) {
                            case "left":
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                            case "center":
                                alignment = PrinterConst.Alignment.CENTER;
                                break;
                            case "right":
                                alignment = PrinterConst.Alignment.RIGHT;
                                break;
                            default:
                                alignment = PrinterConst.Alignment.LEFT;
                                break;
                        }
                        if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                            zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                        }
                    }
                }
            }
            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            String orderDate = null, orderTime = null;
            String receiptDate = null;
            if (!Validators.isNullOrEmpty(orderDetail.created_at)) {
                if (orderDetail.created_at.contains("Z")) {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a");
                } else {
                    orderDate = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy");
                    orderTime = CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, "hh:mm a");
                }
            }
            if (!Validators.isNullOrEmpty(orderDetail.updated_at)) {
                if (orderDetail.updated_at.contains("Z")) {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd-MM-yyyy hh:mm a");
                } else {
                    receiptDate = CommonFunctions.formatUnknownDateTime(orderDetail.updated_at, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy hh:mm a");
                }
            }
            for (int i = 0; i < listPrintStructure.size(); i++) {
                String key = listPrintStructure.get(i).key;
                Log.e("listPrintStructure", "listPrintStructure " + listPrintStructure.get(i).style + " size " + listPrintStructure.get(i).toString());
                switch (listPrintStructure.get(i).style) {
                    case "bold":
                        style = PrinterConst.Font.BOLD;
                        break;
                    case "underline":
                        style = PrinterConst.Font.UNDERLINE;
                        break;
                    case "reverse":
                        style = PrinterConst.Font.REVERSE;
                        break;
                    default:
                        style = PrinterConst.Font.DEFAULT;
                        break;
                }
                switch (listPrintStructure.get(i).size) {
                    case "size1":
                        widthSize = PrinterConst.WidthSize.SIZE1;
                        heightSize = PrinterConst.HeightSize.SIZE1;
                        break;
                    case "size2":
                        widthSize = PrinterConst.WidthSize.SIZE2;
                        heightSize = PrinterConst.HeightSize.SIZE2;
                        break;
                    case "size3":
                        widthSize = PrinterConst.WidthSize.SIZE3;
                        heightSize = PrinterConst.HeightSize.SIZE3;
                        break;
                    default:
                        widthSize = PrinterConst.WidthSize.SIZE0;
                        heightSize = PrinterConst.HeightSize.SIZE0;
                        break;
                }
                switch (listPrintStructure.get(i).alignment) {
                    case "center":
                        alignment = PrinterConst.Alignment.CENTER;
                        break;
                    case "right":
                        alignment = PrinterConst.Alignment.RIGHT;
                        break;
                    default:
                        alignment = PrinterConst.Alignment.LEFT;
                        break;
                }
                boolean all_separator = listPrintStructure.get(i).all_separator;
                boolean priceInItems = listPrintStructure.get(i).price;
                boolean isSpeartor = listPrintStructure.get(i).separator;
                boolean isBlockName = listPrintStructure.get(i).block_name;
                switch (key) {
                    case "logo": {
                        if (!kitchenCopy && tiffintomLogo != null) {
                            zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                            zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "ticket_header": {
                        if (!kitchenCopy && !Validators.isNullOrEmpty(ticket_header)) {

                            if (headerAlignment < 2)
                                zonerich.Prn_PrintText(ticket_header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                            else {
                                String[] headers = ticket_header.split("\n");
                                for (String h : headers) {
                                    zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                                }
                            }
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "header_order_type": {
                        if (!Validators.isNullOrEmpty(orderTypeHeader) && kitchenCopy) {
                            zonerich.Prn_PrintText("" + orderTypeHeader.toUpperCase() + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "header_customer_name": {
                        if (kitchenCopy) {
                            zonerich.Prn_PrintText(orderDetail.customer_name + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "title": {
                        if (!Validators.isNullOrEmpty(title) && kitchenCopy) {
                            zonerich.Prn_PrintText("\n" + title + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_no": {
                        if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            zonerich.Prn_PrintText("" + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                        } else {
                            zonerich.Prn_PrintText("" + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                        }
                        if (kitchenCopy) {
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "table_no": {
                        if (orderType == 1) {
                            zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                            if (!structure.no_of_diners.visibility) {
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "no_of_diners": {
                        if (orderType == 1) {
                            zonerich.Prn_PrintText("   No of Diner: " + orderDetail.no_guest + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_date": {
                        if (!Validators.isNullOrEmpty(orderDate))
                            if (structure.order_time != null && structure.order_time.visibility) {
                                zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                            } else {
                                zonerich.Prn_PrintText("Date :" + orderDate + " ", alignment, style, widthSize | heightSize);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                        break;
                    }
                    case "receipt_time": {
                        if (!Validators.isNullOrEmpty(receiptDate)) {
                            zonerich.Prn_PrintText("Receipt Date :" + receiptDate + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_time": {
                        if (!Validators.isNullOrEmpty(orderTime)) {
                            zonerich.Prn_PrintText("Time :" + orderTime + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "order_type": {
                        if (orderType > 1) {
                            zonerich.Prn_PrintText("Order Type: " + orderDetail.order_type + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "items_header": {
                        zonerich.Prn_PrintText("Qty  Name" + "\n", alignment, style, widthSize | heightSize);
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "items": {
                        String itemName = "", price = "", qty = "";
                        String lastBlockId = null;
                        boolean lastItemWasMisc = false;
                        int position = 0;
                        for (OrderItem productDetail : orderDetail.order_items) {
                            position = position + 1;
                            String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                            String productQty;
                            if (kitchenCopy) {
                                productQty = productDetail.sent_to_kitchen_quantity_for_local_use == 0 ? String.valueOf(productDetail.quantity) : String.valueOf(productDetail.sent_to_kitchen_quantity_for_local_use);
                            } else {
                                productQty = String.valueOf(productDetail.quantity);
                            }

                            qty = productQty;

                            if (productQty.length() <= 1) {
                                qty = productQty + "x ";
                            } else if (productQty.length() <= 2) {
                                qty = productQty + "x";

                            } else if (productQty.length() <= 3) {
                                qty = productQty + "x ";

                            } else if (productQty.length() <= 4) {
                                qty = productQty + "x";
                            }

                            int length = String.valueOf(formatter.format(productDetail.total)).length();
                            String format = null;
                            format = (priceInItems) ? formatter.format(productDetail.total) : "";
                            price = (priceInItems) ? format : "";
                            if (widthSize == PrinterConst.WidthSize.SIZE1 || widthSize == PrinterConst.WidthSize.SIZE0) {
                                itemName = calculateNumberOfLines(productName, format, widthSize, qty);
                            } else {
                                if (length == 3)
                                    itemName = getProductNameWithPad(qty + productName, price, 40);
                                else if (length <= 8 && length >= 4)
                                    itemName = getProductNameWithPad(qty + productName, price, 39);
                                else
                                    itemName = getProductNameWithPad(qty + productName, price, 38);
                            }
                            if (!all_separator) {
                                if (lastBlockId != null) {
                                    if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                                        if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                                            printBlockText(productDetail,isBlockName);
                                    }
                                } else {
                                    if ((lastItemWasMisc && !productDetail.misc) || (productDetail.block_id!=null && lastBlockId==null)) {
                                        if (kitchenCopy)
                                            printBlockText(productDetail,isBlockName);
                                    }
                                }
                            }

                            String printItem;
                            printItem = itemName + "\n";

                            zonerich.Prn_PrintText(printItem, alignment, style, widthSize | heightSize);
                            if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                                zonerich.Prn_PrintText("  " + "Instruction: " + productDetail.special_instruction + "\n",
                                        PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);

                            if (productDetail.order_item_addons.size() > 0) {
                                int subStyle, subWidthSize, subHeightSize, subAlignment;
                                switch (structure.items_subaddon.style) {
                                    case "bold":
                                        subStyle = PrinterConst.Font.BOLD;
                                        break;
                                    case "underline":
                                        subStyle = PrinterConst.Font.UNDERLINE;
                                        break;
                                    case "reverse":
                                        subStyle = PrinterConst.Font.REVERSE;
                                        break;
                                    default:
                                        subStyle = PrinterConst.Font.DEFAULT;
                                        break;
                                }
                                switch (structure.items_subaddon.size) {
                                    case "size1":
                                        subWidthSize = PrinterConst.WidthSize.SIZE1;
                                        subHeightSize = PrinterConst.HeightSize.SIZE1;
                                        break;
                                    case "size2":
                                        subWidthSize = PrinterConst.WidthSize.SIZE2;
                                        subHeightSize = PrinterConst.HeightSize.SIZE2;
                                        break;
                                    case "size3":
                                        subWidthSize = PrinterConst.WidthSize.SIZE3;
                                        subHeightSize = PrinterConst.HeightSize.SIZE3;
                                        break;
                                    default:
                                        subWidthSize = PrinterConst.WidthSize.SIZE0;
                                        subHeightSize = PrinterConst.HeightSize.SIZE0;
                                        break;
                                }
                                switch (structure.items_subaddon.alignment) {
                                    case "center":
                                        subAlignment = PrinterConst.Alignment.CENTER;
                                        break;
                                    case "right":
                                        subAlignment = PrinterConst.Alignment.RIGHT;
                                        break;
                                    default:
                                        subAlignment = PrinterConst.Alignment.LEFT;
                                        break;
                                }
                                if (structure.items_subaddon.visibility) {
                                    zonerich.Prn_PrintText("Choose Your Base:" + "\n", subAlignment, subStyle, subWidthSize | subHeightSize);
                                }
                                for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                                    List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                                    if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                                        continue;
                                    }

                                    String subdomainPrintText;
                                    if (subWidthSize == PrinterConst.WidthSize.SIZE1 || subWidthSize == PrinterConst.WidthSize.SIZE0) {
                                        if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                            if (orderItemAddon.quantity > 1) {
                                                subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, "", subWidthSize, "  - " + orderItemAddon.quantity + "x");
                                            } else {
                                                if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                    subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, "", subWidthSize, "");
                                                } else {
                                                    subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, "", subWidthSize, "  -   ");
                                                }
                                            }
                                        } else {
                                            if (orderItemAddon.quantity > 1) {
                                                subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), subWidthSize, "  - " + orderItemAddon.addon_name + "x");
                                            } else {
                                                subdomainPrintText = calculateNumberOfLines(orderItemAddon.addon_name, formatter.format(orderItemAddon.total), subWidthSize, "  -   ");
                                            }
                                        }
                                        zonerich.Prn_PrintText(subdomainPrintText + "\n", subAlignment, subStyle, subWidthSize | subHeightSize);
                                    } else {
                                        if (kitchenCopy || orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                            // commenting the condition as suggested by kamal sir (issue reported by arjun) (change done by arbaz 22-05-2023)
                                /*if (orderItemAddon.price <= 0 || orderItemAddon.total <= 0) {
                                    subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                                } else {*/
                                            if (orderItemAddon.quantity > 1) {
                                                subdomainPrintText = "- " + orderItemAddon.quantity + "x " + orderItemAddon.addon_name + "\n";
                                            } else {
                                                if (addonHeader.size() > 0 && MyApp.getInstance().getSubAddonStatus()) {
                                                    subdomainPrintText = "" + orderItemAddon.addon_name + "\n";
                                                } else {
                                                    subdomainPrintText = "- 1x " + orderItemAddon.addon_name + "\n";
                                                }
                                            }
                                            //}
                                        } else {
                                            length = String.valueOf(formatter.format(orderItemAddon.total)).length();
                                            if (length <= 7 && length > 2) {
                                                if (length == 4) {
                                                    format = "    " + formatter.format(orderItemAddon.total);
                                                }
                                                if (length == 5) {
                                                    format = "   " + formatter.format(orderItemAddon.total);
                                                }

                                                if (length == 6) {
                                                    format = "  " + formatter.format(orderItemAddon.total);
                                                }
                                                if (length == 7) {
                                                    format = " " + formatter.format(orderItemAddon.total);
                                                }
                                            } else {
                                                format = formatter.format(orderItemAddon.total);
                                            }
                                            productName = orderItemAddon.addon_name;
                                            price = (!kitchenCopy) ? format : "";
                                            productQty = "" + orderItemAddon.quantity;
                                            qty = productQty;

                                            if (productQty.length() <= 1) {
                                                qty = "- " + productQty + "x ";
                                            } else if (productQty.length() <= 2) {
                                                qty = "- " + productQty + "x ";

                                            } else if (productQty.length() <= 3) {
                                                qty = "- " + productQty + "x ";

                                            } else if (productQty.length() <= 4) {
                                                qty = "- " + productQty + "x";
                                            }

                                            if (kitchenCopy)
                                                itemName = qty + productName;
                                            else {
                                                if (length == 3)
                                                    itemName = getProductNameWithPad(qty + productName, price, 40);
                                                else if (length <= 8 && length >= 4)
                                                    itemName = getProductNameWithPad(qty + productName, price, 39);
                                                else
                                                    itemName = getProductNameWithPad(qty + productName, price, 38);
                                            }
                                            subdomainPrintText = itemName;
                                        }
                                        zonerich.Prn_PrintText(subdomainPrintText, subAlignment, subStyle, subWidthSize | subHeightSize);
                                    }
                                }
                            }

                            for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                                String ingredientName = orderItemIngredient.ingredient_name;
                                if (orderItemIngredient.with) {
                                    ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                                }
                                if (orderItemIngredient.without) {
                                    ingredientName = "  " + "No " + ingredientName;
                                }
                                String subdomainPrintText = ingredientName + "\n";
                                zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                            }

                            lastItemWasMisc = productDetail.misc;
                            lastBlockId = productDetail.block_id;
                            if (all_separator && orderDetail.order_items.size() > position) {
                                zonerich.Prn_PrintText("------------------------------------------------\n",
                                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                            }
                            if (!all_separator && isBlockName) {
                                zonerich.Prn_PrintText("\n", alignment, style, widthSize | heightSize);
                            }
                        }
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "subtotal":
                    case "gratuity":
                    case "delivery_charge":
                    case "service_charge":
                    case "grand_total":
                    case "discount": {
                        if (printTotalInPrint) {
                            String formattedValue = "";
                            String titleOfTotal = "";
                            if (key.equalsIgnoreCase("gratuity")) {
                                if (orderDetail.gratuity > 0) {
                                    formattedValue = MyApp.df.format(orderDetail.gratuity);
                                }
                                titleOfTotal = "GRATUITY";
                            } else if (key.equalsIgnoreCase("discount")) {
                                if (orderDetail.discount > 0)
                                    formattedValue = MyApp.df.format(orderDetail.discount);
                                titleOfTotal = "DISCOUNT";
                            } else if (key.equalsIgnoreCase("grand_total")) {
                                if (orderDetail.total > 0)
                                    formattedValue = MyApp.df.format(orderDetail.total);
                                titleOfTotal = "TOTAL";
                            } else if (key.equalsIgnoreCase("service_charge")) {
                                if (orderDetail.service_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.service_charge);
                                titleOfTotal = "SERVICE CHARGE";
                            } else if (key.equalsIgnoreCase("delivery_charge")) {
                                if (orderDetail.delivery_charge > 0)
                                    formattedValue = MyApp.df.format(orderDetail.delivery_charge);
                                titleOfTotal = "DELIVERY CHARGE";
                            } else if (key.equalsIgnoreCase("subtotal")) {
                                formattedValue = MyApp.df.format(orderDetail.sub_total);
                                titleOfTotal = "SUB TOTAL";
                            }
                            if (!Validators.isNullOrEmpty(formattedValue)) {
                                int length = formattedValue.length();
                                String price = null;
                                if (length <= 7 && length > 2) {
                                    if (length == 4) {
                                        price = "    " + formattedValue;
                                    }
                                    if (length == 5) {
                                        price = "   " + formattedValue;
                                    }

                                    if (length == 6) {
                                        price = "  " + formattedValue;
                                    }
                                    if (length == 7) {
                                        price = " " + formattedValue;
                                    }
                                } else {
                                    price = formatter.format(orderDetail.sub_total);
                                }
                                String finalTitleToPrint = "";
                                if (length == 3) {
                                    if (widthSize == PrinterConst.WidthSize.SIZE1) {
                                        padRightSpaces(titleOfTotal + price, 20);
                                    } else {
                                        finalTitleToPrint = getProductNameWithPad(titleOfTotal, price, 40);
                                    }
                                } else if (length <= 8 && length >= 4) {
                                    if (widthSize == PrinterConst.WidthSize.SIZE1) {
                                        finalTitleToPrint = padRightSpaces(titleOfTotal, 16) + "" + price;
                                    } else {
                                        finalTitleToPrint = getProductNameWithPad(titleOfTotal, price, 39);
                                    }
                                } else {
                                    finalTitleToPrint = getProductNameWithPad(titleOfTotal, price, 38);
                                }
                                zonerich.Prn_PrintText(finalTitleToPrint + "\n", alignment, style, widthSize | heightSize);
                            }
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_detail": {
                        if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {
                            if (Objects.equals(key, "payment_detail_header")) {
                                zonerich.Prn_PrintText("Payment Details: " + "\n", alignment, style, widthSize | heightSize);
                            }
                            if (structure.payment_detail.visibility) {
                                if (Objects.equals(key, "payment_detail")) {
                                    zonerich.Prn_PrintText("Payment Details: " + "\n", alignment, style, widthSize | heightSize);
                                    for (OrderPayment orderPayment : orderDetail.order_payments) {
                                        String paymentDetailToPrint = null;
                                        if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                                            paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                        } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                                            paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                                        } else {
                                            paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                                        }
                                        zonerich.Prn_PrintText(paymentDetailToPrint, alignment, style,
                                                widthSize | heightSize);
                                    }
                                    //zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                                }
                            } else {
                                //zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                            }
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "serve_by": {
                        zonerich.Prn_PrintText("Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username + "\n",
                                alignment, style, widthSize | heightSize);
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "customer_detail": {
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name))
                            zonerich.Prn_PrintText("" + orderDetail.customer_name + "\n", alignment, style,
                                    widthSize | heightSize);

                        String fulladdress = null;
                        if (orderType == 3) {
                            /*fulladdress = "" + orderDetail.customer.house_no + ","
                                    + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                                    orderDetail.customer.country + ", " + orderDetail.customer.postcode;*/
                            fulladdress = formatAddress(orderDetail);
                            zonerich.Prn_PrintText(fulladdress + "\n", alignment, style,
                                    widthSize | heightSize);
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                            zonerich.Prn_PrintText("" + orderDetail.customer.mobile + "\n", alignment, style,
                                    widthSize | heightSize);
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.customer_name) || !Validators.isNullOrEmpty(orderDetail.customer.mobile) || !Validators.isNullOrEmpty(fulladdress)) {
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "payment_status": {
                        if (orderDetail.total_paid == 0) {
                            //zonerich.Prn_PrintText("Payment Status: " + settingMap.get("unpaid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                            zonerich.Prn_PrintText("" + settingMap.get("unpaid_payment_title").toUpperCase() + "\n", alignment, style, widthSize | heightSize);
                        } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                            //zonerich.Prn_PrintText("Payment Status: " + settingMap.get("paid_payment_title") + "\n", alignment, style, widthSize | heightSize);
                            zonerich.Prn_PrintText("" + settingMap.get("paid_payment_title").toUpperCase() + "\n", alignment, style, widthSize | heightSize);
                        } else if (orderDetail.total_paid > 0) {
                            //zonerich.Prn_PrintText("Payment Status: " + settingMap.get("partial_payment_title") + "\n", alignment, style, widthSize | heightSize);
                            zonerich.Prn_PrintText("" + settingMap.get("partial_payment_title").toUpperCase() + "\n", alignment, style, widthSize | heightSize);
                        }
                        if (isSpeartor) {
                            printSeparator();
                        }
                        break;
                    }
                    case "order_comment": {
                        if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                            zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", alignment, style,
                                    widthSize | heightSize);

                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        if (!Validators.isNullOrEmpty(orderDetail.delivery_collection_time_slot)) {
                            zonerich.Prn_PrintText("Requested Time" + orderDetail.delivery_collection_time_slot + "\n",
                                    PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
                        }
                        break;
                    }
                    case "footer_order_type": {
                        if (!Validators.isNullOrEmpty(orderTypeHeader) && kitchenCopy) {
                            zonerich.Prn_PrintText("" + orderTypeHeader.toUpperCase() + "" + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "footer_table_number": {
                        if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                            zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                        break;
                    }
                    case "footer_order_number": {
                        if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                            zonerich.Prn_PrintText("Order No: " + orderDetail.display_order_id + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        } else {
                            if (orderDetail._id != 0) {
                                zonerich.Prn_PrintText("Order No: " + orderDetail._id + "\n", alignment, style, widthSize | heightSize);
                                if (isSpeartor) {
                                    printSeparator();
                                }
                            }
                        }
                        break;
                    }
                    case "footer": {
                        if (!Validators.isNullOrEmpty(footerA)) {
                            zonerich.Prn_PrintText(footerA + "\n", alignment, style, widthSize | heightSize);
                        }
                        if (!Validators.isNullOrEmpty(footerB)) {
                            zonerich.Prn_PrintText(footerB + "\n", alignment, style, widthSize | heightSize);
                            if (isSpeartor) {
                                printSeparator();
                            }
                        }
                    }
                    break;
                }

            }

            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);

            if (isCashDrawerOpen) {
                zonerich.Prn_OpenCashbox();
            }
            // set print true for local device
            setPrint(myPreferences, true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();

            // prepare send wifi model to order device to listen start
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel();
            SiteSetting logoSetting = MyApp.getInstance().findSetting("logo");
            sendOrderWifiModel.setBusinessLogo(logoSetting == null || Validators.isNullOrEmpty(logoSetting.value) ? "" : logoSetting.value);
            sendOrderWifiModel.setTitle(title);
            sendOrderWifiModel.setTicketHeaderSetting(ticket_header);
            sendOrderWifiModel.setHeaderAlignment(headerAlignment);
            sendOrderWifiModel.setPrintTotalInPrint(printTotalInPrint);
            sendOrderWifiModel.setOrderDetail(orderDetail);
            sendOrderWifiModel.setCashDrawerOpen(isCashDrawerOpen);
            sendOrderWifiModel.setPrintStructure(structure);
            sendOrderWifiModel.setFooterA(footerA);
            sendOrderWifiModel.setFooterB(footerB);
            sendOrderWifiModel.setOrderTypeHeading(orderTypeHeader);
            sendOrderWifiModel.setSettingsMap(settingMap);
            sendOrderWifiModel.setKitchen(kitchenCopy);
            if (printBlockBill != null) {
                sendOrderWifiModel.setPrintBlockBill(printBlockBill);
            }
            sendOrderWifiModel.setTableNumberOrderIdMode(tableNumberOrderIdMode);
            sendOrderWifiModel.setPrintMethodName(Constants.PRINTORDEREPOSNEW);
            sendOrderWifiModel.setLoginUserName(MyApp.getInstance().myPreferences.getLoggedInUser().username);
            sendOrderToWifi(sendOrderWifiModel);
        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    public void printOrderEpos(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, String tableNumberOrderIdMode, String dateTimeMode, Order orderDetail, boolean printTotalInPrint, String footerA, String footerB, String orderTypeHeader, HashMap<String, String> settingMap, boolean kitchenCopy, boolean isCashDrawerOpen, MyPreferences myPreferences) {
        int orderType = -1;
        if (Validators.isNullOrEmpty(orderDetail.order_type_id)) {
            orderType = 0;
        } else {
            orderType = Integer.parseInt(orderDetail.order_type_id);
        }

        formatter.applyPattern("0.00");
        try {
            if (!kitchenCopy && tiffintomLogo != null) {
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            if (!kitchenCopy) {

                if (headerAlignment < 2)
                    zonerich.Prn_PrintText(ticket_header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                else {
                    String[] headers = ticket_header.split("\n");
                    for (String h : headers) {
                        zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }
            }
            if (kitchenCopy) {
                if (!Validators.isNullOrEmpty(orderTypeHeader))
                    zonerich.Prn_PrintText("** " + orderTypeHeader + " **\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                if (orderDetail.order_type_id.equalsIgnoreCase("2") && !Validators.isNullOrEmpty(orderDetail.customer_name)) {
                    zonerich.Prn_PrintText(orderDetail.customer_name + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                }

                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (!Validators.isNullOrEmpty(title)) {
                zonerich.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);

            }

            String tableNumberOrderIdText = "";
            if (tableNumberOrderIdMode != null) {

                if (tableNumberOrderIdMode.equalsIgnoreCase("order_number") || tableNumberOrderIdMode.equalsIgnoreCase("both")) {
                    if (Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                        tableNumberOrderIdText = "Order ID: " + orderDetail._id;
                    } else
                        tableNumberOrderIdText = "Order ID: " + orderDetail.display_order_id;

                }
                if (orderType == 1 && (tableNumberOrderIdMode.equalsIgnoreCase("table_number") || tableNumberOrderIdMode.equalsIgnoreCase("both"))) {
                    if (tableNumberOrderIdText.length() > 1) {
                        tableNumberOrderIdText = tableNumberOrderIdText + "\n";
                    }
                    tableNumberOrderIdText = tableNumberOrderIdText + "Table No: " + orderDetail.table_number + "  No of Diners:  " + orderDetail.no_guest;

                }
                if (tableNumberOrderIdMode.equalsIgnoreCase("none")) {
                    tableNumberOrderIdText = "";
                }
                if (tableNumberOrderIdMode.length() > 0) {
                    if (!Validators.isNullOrEmpty(title)) {
                        tableNumberOrderIdText = "\n------------------------------------------------\n" + tableNumberOrderIdText + "\n------------------------------------------------\n";
                    } else {
                        tableNumberOrderIdText = tableNumberOrderIdText + "\n------------------------------------------------\n";
                    }
                    zonerich.Prn_PrintText(tableNumberOrderIdText, PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (!Validators.isNullOrEmpty(dateTimeMode)) {
                String dateFormat = "dd-MM-yyyy hh:mm a";
                String dateFormatTitle = "Order Date Time: ";
                if (dateTimeMode.equalsIgnoreCase("date_time")) {
                    dateFormat = "dd-MM-yyyy hh:mm a";
                    dateFormatTitle = "Order Date Time: ";
                }
                if (dateTimeMode.equalsIgnoreCase("time")) {
                    dateFormat = "hh:mm a";
                    dateFormatTitle = "Order Time: ";
                }
                if (dateTimeMode.equalsIgnoreCase("date")) {
                    dateFormat = "dd-MM-yyyy";
                    dateFormatTitle = "Order Date: ";
                }
                if (orderDetail.created_at.contains("Z")) {
                    zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, dateFormat) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                } else {
                    zonerich.Prn_PrintText(dateFormatTitle + CommonFunctions.formatUnknownDateTime(orderDetail.created_at, Constants.PHP_DATE_TIME_FORMAT, dateFormat) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            if (orderType > 1 && !kitchenCopy) {
                zonerich.Prn_PrintText("Order Type: " + orderDetail.order_type + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            zonerich.Prn_PrintText("Qty  Name" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            String itemName = "", price = "", qty = "";

            String lastBlockId = null;
            boolean lastItemWasMisc = false;

            for (OrderItem productDetail : orderDetail.order_items) {
                String productName = (kitchenCopy && !Validators.isNullOrEmpty(productDetail.product_short_name)) ? productDetail.product_short_name : productDetail.product_name;
                String productQty = String.valueOf(productDetail.quantity);
                // Here we need 16 characters in product name so we send 16 in
                // @params charactersInLine
                price = (!kitchenCopy) ? formatter.format(productDetail.total) : "";
                if (kitchenCopy)
                    itemName = productName;
                else
                    itemName = getProductNameWithPad(productName, price, 35);
                qty = productQty;
                if (productQty.length() <= 1) {
                    qty = " " + productQty + " ";
                } else if (productQty.length() <= 2) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 3) {
                    qty = productQty + " ";

                } else if (productQty.length() <= 4) {
                    qty = productQty + "";
                }
                if (lastBlockId != null) {
                    if (!lastBlockId.equalsIgnoreCase(productDetail.block_id)) {
                        if (kitchenCopy || (printBlockBill != null && printBlockBill.value != null && printBlockBill.value.equalsIgnoreCase("yes")))
                            zonerich.Prn_PrintText("----------------------------------\n",
                                    PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                } else {
                    if (lastItemWasMisc && !productDetail.misc) {
                        if (kitchenCopy)
                            zonerich.Prn_PrintText("----------------------------------\n",
                                    PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    }
                }

                String printItem;
                printItem = qty + itemName + "\n";
                if (!kitchenCopy) {
                    zonerich.Prn_PrintText(printItem, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                        zonerich.Prn_PrintText("  " + "Instruction: " + productDetail.special_instruction + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                } else {
                    zonerich.Prn_PrintText(printItem, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE1 | PrinterConst.WidthSize.SIZE1);
                    if (!Validators.isNullOrEmpty(productDetail.special_instruction))
                        zonerich.Prn_PrintText("  " + "Instruction: " + productDetail.special_instruction + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                }

                for (OrderItemAddon orderItemAddon : productDetail.order_item_addons) {
                    List<Addon> addonHeader = MyApp.getInstance().appDatabase.addonDao().list(orderItemAddon.addon_id);
                    if (addonHeader.size() > 0 && !MyApp.getInstance().getSubAddonStatus()) {
                        continue;
                    }
                    if (!kitchenCopy) {
                        String subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                        zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    } else {
                        String subdomainPrintText = "  " + orderItemAddon.addon_name + "\n";
                        zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }
                }

                for (OrderItemIngredient orderItemIngredient : productDetail.order_item_ingredients) {
                    String ingredientName = orderItemIngredient.ingredient_name;
                    if (orderItemIngredient.with) {
                        ingredientName = "  " + orderItemIngredient.quantity + " Extra " + ingredientName;
                    }
                    if (orderItemIngredient.without) {
                        ingredientName = "  " + "No " + ingredientName;
                    }
                    String subdomainPrintText = ingredientName + "\n";
                    if (!kitchenCopy) {
                        zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    } else {
                        zonerich.Prn_PrintText(subdomainPrintText, PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
                    }
                }

                lastItemWasMisc = productDetail.misc;
                lastBlockId = productDetail.block_id;
            }
            if (printTotalInPrint) {
                zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                zonerich.Prn_PrintText(padRightSpaces("SubTotal:", 20) + MyApp.df.format(orderDetail.sub_total) + "\n", PrinterConst.Alignment.RIGHT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                if (orderDetail.delivery_charge > 0) {
                    zonerich.Prn_PrintText(padRightSpaces("Delivery Charge:", 20) + MyApp.df.format(orderDetail.delivery_charge) + "\n", PrinterConst.Alignment.RIGHT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
                if (orderDetail.gratuity > 0) {
                    zonerich.Prn_PrintText(padRightSpaces("Gratuity :", 20) + MyApp.df.format(orderDetail.gratuity) + "\n", PrinterConst.Alignment.RIGHT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
                if (orderDetail.service_charge > 0) {
                    zonerich.Prn_PrintText(padRightSpaces("Service charge :", 20) + MyApp.df.format(orderDetail.service_charge) + "\n", PrinterConst.Alignment.RIGHT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
                if (orderDetail.discount > 0) {
                    zonerich.Prn_PrintText(padRightSpaces("Discount :", 20) + MyApp.df.format(orderDetail.discount) + "\n", PrinterConst.Alignment.RIGHT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }

                zonerich.Prn_PrintText("Total: " + MyApp.df.format(orderDetail.total) + "\n", PrinterConst.Alignment.RIGHT, PrinterConst.Font.BOLD, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE1);
                zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            if (orderDetail.order_payments != null && orderDetail.order_payments.size() > 0) {

                zonerich.Prn_PrintText("Payment Details:" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                for (OrderPayment orderPayment : orderDetail.order_payments) {
                    String paymentDetailToPrint = null;
                    if (orderPayment.payment_method_name.equalsIgnoreCase("cash")) {
                        paymentDetailToPrint = settingMap.get("cash_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                    } else if (orderPayment.payment_method_name.equalsIgnoreCase("Voucher")) {
                        paymentDetailToPrint = "Paid Via Voucher: " + MyApp.df.format(orderPayment.amount) + "\n";
                    } else {
                        paymentDetailToPrint = settingMap.get("card_payment_type") + " Payment : " + MyApp.df.format(orderPayment.amount) + "\n";
                    }
                    zonerich.Prn_PrintText(paymentDetailToPrint, PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
                zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            String toprint = "Served By: " + MyApp.getInstance().myPreferences.getLoggedInUser().username;
            zonerich.Prn_PrintText(toprint + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (!Validators.isNullOrEmpty(orderDetail.customer_name))
                zonerich.Prn_PrintText("Cust Name:" + orderDetail.customer_name + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            if (!Validators.isNullOrEmpty(orderDetail.customer.mobile)) {
                zonerich.Prn_PrintText("Cust No:" + orderDetail.customer.mobile + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderType == 3) {
               /* String fulladdress = "Address : " + orderDetail.customer.house_no + ","
                        + orderDetail.customer.street + ", " + orderDetail.customer.state + ", " +
                        orderDetail.customer.country + ", " + orderDetail.customer.postcode;*/
                String fulladdress = formatAddress(orderDetail, PrinterConst.WidthSize.SIZE0);
                zonerich.Prn_PrintText(fulladdress + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (orderDetail.total_paid == 0) {
                zonerich.Prn_PrintText("Payment Status: " + settingMap.get("unpaid_payment_title") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            } else if (MyApp.df.format(orderDetail.total).equalsIgnoreCase(MyApp.df.format(orderDetail.total_paid))) {
                zonerich.Prn_PrintText("Payment Status: " + settingMap.get("paid_payment_title") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            } else if (orderDetail.total_paid > 0) {
                zonerich.Prn_PrintText("Payment Status: " + settingMap.get("partial_payment_title") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (!Validators.isNullOrEmpty(orderDetail.comment)) {
                if (kitchenCopy) {
                    zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                } else {
                    zonerich.Prn_PrintText("Comment: " + orderDetail.comment + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
                zonerich.Prn_PrintText("------------------------------------------------\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
            if (kitchenCopy) {
                zonerich.Prn_PrintText("** " + orderTypeHeader + " **\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                // footer table number
                if (!Validators.isNullOrEmpty(orderDetail.table_number)) {
                    zonerich.Prn_PrintText("------------------------------------------------\n",
                            PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText("Table No: " + orderDetail.table_number + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                }
                // footer order number
                if (!Validators.isNullOrEmpty(orderDetail.display_order_id)) {
                    zonerich.Prn_PrintText("Order No: " + orderDetail.display_order_id + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                } else {
                    if (orderDetail._id != 0) {
                        zonerich.Prn_PrintText("Order No: " + orderDetail._id + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                                PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
                    }
                }
            }
            if (!Validators.isNullOrEmpty(footerA)) {
                zonerich.Prn_PrintText(footerA + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }
            if (!Validators.isNullOrEmpty(footerB)) {
                zonerich.Prn_PrintText(footerB + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);

            if (isCashDrawerOpen) {
                zonerich.Prn_OpenCashbox();
            }

            // set print set for print in local device
            myPreferences.saveIsPrintBill(true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();

        } catch (Exception e) {
            LogUtils.e("PRINT::", Log.getStackTraceString(e));
            System.out.println(e);
        }
    }

    private String formatAddress(Order orderDetail) {
        String fulladdress = "";
        if (orderDetail.customer != null) {

            if (Validators.isNullOrEmpty(orderDetail.customer.house_no)) {
                fulladdress = orderDetail.customer.street + "\n";
            } else {
                fulladdress = "" + orderDetail.customer.house_no + " " + orderDetail.customer.street + "\n";
            }
            if (!Validators.isNullOrEmpty(orderDetail.customer.city)) {
                fulladdress = fulladdress + "" + orderDetail.customer.city;

                if (!Validators.isNullOrEmpty(orderDetail.customer.postcode)) {
                    fulladdress = fulladdress + " " + orderDetail.customer.postcode;
                }
            }
        }
        return fulladdress;
    }

    private String formatAddress(Order orderDetail, int widthSize) {
        int lengthForSize = widthSize == PrinterConst.WidthSize.SIZE0 ? 48 : 24;
        int multiplyLength = 1;
        String fulladdress = "Address : ";
        String secondLine = fulladdress;
        if (!Validators.isNullOrEmpty(orderDetail.customer.house_no)) {
            if ((secondLine + " " + orderDetail.customer.house_no + ",").length() > (multiplyLength * lengthForSize)) {
                int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                for (int space = 0; space < emptySpaceLength; space++) {
                    secondLine = secondLine + (" ");
                }
                multiplyLength = multiplyLength + 1;
                secondLine = secondLine + ("\n");
            }
            secondLine = secondLine + orderDetail.customer.house_no + ", ";
        }
        if (!Validators.isNullOrEmpty(orderDetail.customer.street)) {
            String[] splitWithSpace = orderDetail.customer.street.split(" ");
            int index = 0;
            for (String s : splitWithSpace) {
                index = index + 1;
                if ((secondLine + " " + s).length() > (multiplyLength * lengthForSize)) {
                    int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                    for (int space = 0; space < emptySpaceLength; space++) {
                        secondLine = secondLine + (" ");
                    }
                    multiplyLength = multiplyLength + 1;
                    secondLine = secondLine + ("\n");
                }
                if (splitWithSpace.length == (index)) {
                    secondLine = secondLine + s + ", ";
                } else {
                    secondLine = secondLine + s;
                }
            }
        }
        if (!Validators.isNullOrEmpty(orderDetail.customer.city)) {
            if ((secondLine + " " + orderDetail.customer.city + ", ").length() > (multiplyLength * lengthForSize)) {
                int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                for (int space = 0; space < emptySpaceLength; space++) {
                    secondLine = secondLine + (" ");
                }
                multiplyLength = multiplyLength + 1;
                secondLine = secondLine + ("\n");
            }
            secondLine = secondLine + orderDetail.customer.city + ", ";
        }
        if (!Validators.isNullOrEmpty(orderDetail.customer.state)) {
            if ((secondLine + " " + orderDetail.customer.state + ", ").length() > (multiplyLength * lengthForSize)) {
                int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                for (int space = 0; space < emptySpaceLength; space++) {
                    secondLine = secondLine + (" ");
                }
                multiplyLength = multiplyLength + 1;
                secondLine = secondLine + ("\n");
            }
            secondLine = secondLine + orderDetail.customer.state + ", ";
        }
        if (!Validators.isNullOrEmpty(orderDetail.customer.postcode)) {
            if ((secondLine + " " + orderDetail.customer.postcode + ", ").length() > (multiplyLength * lengthForSize)) {
                int emptySpaceLength = (multiplyLength * lengthForSize) - (secondLine).length();
                for (int space = 0; space < emptySpaceLength; space++) {
                    secondLine = secondLine + (" ");
                }
                multiplyLength = multiplyLength + 1;
                secondLine = secondLine + ("\n");
            }
            secondLine = secondLine + orderDetail.customer.postcode + "";
        }
        return secondLine;
    }

    public void printReservationList(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, ArrayList<Object> allReservations, String footerA, String footerB, String fromdate, String todate, MyPreferences myPreferences) {
        try {

            if (tiffintomLogo != null) {
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            if (headerAlignment < 2)
                zonerich.Prn_PrintText(ticket_header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            else {
                String[] headers = ticket_header.split("\n");
                for (String h : headers) {
                    zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (!Validators.isNullOrEmpty(title)) {
                zonerich.Prn_PrintText(title + "\n\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE2 | PrinterConst.HeightSize.SIZE2);
            }

            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            String date = "";
            if (fromdate != null) {
                if (fromdate.equalsIgnoreCase("0") && todate.equalsIgnoreCase("0")) {
                    date = "Show All";
                } else {
                    date = fromdate + " - " + todate;
                }
            } else {
                date = "All";
            }


            zonerich.Prn_PrintText(date + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            for (Object obj : allReservations) {
                StringBuilder sb = new StringBuilder();
                if (obj instanceof Reservation) {
                    sb = new StringBuilder();
                    Reservation reservation = (Reservation) obj;
                    sb.append(padRightSpaces("Name: " + reservation.customer_name, 30))
                            .append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy"));

                    if (!Validators.isNullOrEmpty(reservation.telephone)) {
                        if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                            sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 30)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                        } else {
                            sb.append("\n").append(padRightSpaces("Number: " + reservation.telephone, 30)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                        }
                    } else {
                        if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                            sb.append("\n").append(padRightSpaces("", 20)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                        } else {
                            sb.append("\n").append(padRightSpaces("", 20)).append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a"));
                        }
                    }

                    if (!Validators.isNullOrEmpty(reservation.table_number)) {
                        sb.append("\n").append("Table: ").append(reservation.table_number);
                    }
                    sb.append("\n").append(padRightSpaces("Dinner: " + reservation.diners, 30)).append("Status: ").append(reservation.reservation_status);

                    if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                        sb.append("\n").append("Special Instruction: ").append(reservation.special_instruction);
                    }
                }
                if (obj instanceof OnlineReservation) {

                    sb = new StringBuilder();
                    OnlineReservation reservation = (OnlineReservation) obj;
                    sb.append(padRightSpaces("Name: " + reservation.customer_name, 30))
                            .append(CommonFunctions.formatUnknownDateTime(reservation.booking_date, "yyyy-MM-dd", "dd/MM/yyyy"));

                    if (!Validators.isNullOrEmpty(reservation.booking_phone)) {
                        sb.append("\n").append(padRightSpaces("Number: " + reservation.booking_phone, 30)).append(reservation.booking_time);
                    } else {
                        sb.append("\n").append(padRightSpaces("", 30)).append(reservation.booking_time).append("\n");
                    }
                    sb.append("\n").append(padRightSpaces("Dinner: " + reservation.guest_count, 30)).append("Status: ").append(reservation.status);
                    if (reservation.status.equalsIgnoreCase("cancel") && !Validators.isNullOrEmpty(reservation.cancel_reason)) {
                        sb.append("\n").append("Reason: ").append(reservation.cancel_reason);
                    }
                    if (!Validators.isNullOrEmpty(reservation.booking_instruction) && !reservation.status.equalsIgnoreCase("cancel")) {
                        sb.append("\n").append("Booking Instruction: ").append(reservation.booking_instruction);
                    }

                }
                if (sb.toString().length() > 0) {
                    zonerich.Prn_PrintText(sb.toString() + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText("----------------------------\n",
                            PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }

            }

            zonerich.Prn_PrintText(footerA + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText(footerB + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);
            // set print set for print in local device
            myPreferences.saveIsPrintBill(true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printReservation(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Reservation reservation, String footerA, String footerB, MyPreferences myPreferences) {
        try {

            if (tiffintomLogo != null) {
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            if (headerAlignment < 2)
                zonerich.Prn_PrintText(ticket_header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            else {
                String[] headers = ticket_header.split("\n");
                for (String h : headers) {
                    zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (!Validators.isNullOrEmpty(title)) {
                zonerich.Prn_PrintText(title + "\n\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE2 | PrinterConst.HeightSize.SIZE2);
            }

            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            String customername = "Customer Name: " + reservation.customer_name;
            zonerich.Prn_PrintText(customername + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            if (!Validators.isNullOrEmpty(reservation.telephone)) {
                String customerno = "Customer Number: " + reservation.telephone;
                zonerich.Prn_PrintText(customerno + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (!Validators.isNullOrEmpty(reservation.reservation_date_time)) {
                if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                    zonerich.Prn_PrintText("Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd/MM/yyyy") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText("Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                } else {
                    zonerich.Prn_PrintText("Reservation Date : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "dd/MM/yyyy") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText("Reservation Time : " + CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, "yyyy-MM-dd HH:mm:ss", "hh:mm a") + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            zonerich.Prn_PrintText("No of Diners     : " + reservation.diners + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            if (!reservation.online_reservation) {
                if (!Validators.isNullOrEmpty(reservation.deposit_type))
                    zonerich.Prn_PrintText("Deposit Type     : " + reservation.deposit_type + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                            PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                zonerich.Prn_PrintText("Deposit Amount   : " + reservation.deposit_amount + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                zonerich.Prn_PrintText("Special Instructions : " + "\n" + reservation.special_instruction + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

                zonerich.Prn_PrintText("------------------------------------------------\n",
                        PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }

            zonerich.Prn_PrintText(footerA + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText(footerB + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            zonerich.Prn_LineFeed(3);

            // set print set for print in local device
            myPreferences.saveIsPrintBill(true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printVoucher(Bitmap tiffintomLogo, String title, String ticket_header, int headerAlignment, Voucher voucher, String footerA, String footerB, MyPreferences myPreferences) {
        try {

            if (tiffintomLogo != null) {
                zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
                zonerich.Prn_PrintBitmap(tiffintomLogo, PrinterConst.BitmapSize.ZQSIZE0);
                zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
            }

            if (headerAlignment < 2)
                zonerich.Prn_PrintText(ticket_header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            else {
                String[] headers = ticket_header.split("\n");
                for (String h : headers) {
                    zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }

            if (!Validators.isNullOrEmpty(title)) {
                zonerich.Prn_PrintText(title + "\n\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                        PrinterConst.WidthSize.SIZE2 | PrinterConst.HeightSize.SIZE2);
            }

            zonerich.Prn_PrintText(voucher.voucher_code + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);

            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);


            zonerich.Prn_PrintText(MyApp.df.format(voucher.voucher_amount) + " GBP\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE2 | PrinterConst.HeightSize.SIZE2);

            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            StringBuilder sb = new StringBuilder();

            sb.append("Name: ").append(voucher.customer_name).append("\n");

//            if (voucher.customer != null) {
//                sb.append("Number: " + voucher.customer.mobile + "\n");
//                sb.append("Email: " + voucher.customer.email + "\n");
//            }

            sb.append("VALIDITY \n");

            sb.append("VALID FROM : ").append(CommonFunctions.formatUnknownDateTime(voucher.start_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");

            if (Validators.isNullOrEmpty(voucher.end_date) || voucher.end_date.contains("203")) {
                sb.append("VALID Till : No Expiry\n");
            } else {
                sb.append("VALID Till : ").append(CommonFunctions.formatUnknownDateTime(voucher.end_date, Constants.PHP_DATE_TIME_FORMAT, "dd/MM/yyyy")).append("\n");
            }

            if (!Validators.isNullOrEmpty(voucher.week_day)) {
                String[] daystList = voucher.week_day.split(",");
                StringBuilder daysBuilder = new StringBuilder();
                for (String str : daystList) {
                    if (Validators.isNullOrEmpty(str)) continue;
                    if (str.equalsIgnoreCase("1")) {
                        daysBuilder.append("Monday");
                    } else if (str.equalsIgnoreCase("2")) {
                        daysBuilder.append("Tuesday");
                    } else if (str.equalsIgnoreCase("3")) {
                        daysBuilder.append("Wednesday");
                    } else if (str.equalsIgnoreCase("4")) {
                        daysBuilder.append("Thursday");
                    } else if (str.equalsIgnoreCase("5")) {
                        daysBuilder.append("Friday");
                    } else if (str.equalsIgnoreCase("6")) {
                        daysBuilder.append("Saturday");
                    } else if (str.equalsIgnoreCase("0")) {
                        daysBuilder.append("Sunday");
                    }
                    if (daysBuilder.length() > 0) {
                        daysBuilder.append(", ");
                    }

                }
                sb.append("Not Valid on: ").append(daysBuilder.toString()).append("\n");
            }

            if (!Validators.isNullOrEmpty(voucher.order_type_id)) {
                String[] orderList = voucher.order_type_id.split(",");
                StringBuilder ordersBuilder = new StringBuilder();
                for (String str : orderList) {
                    if (Validators.isNullOrEmpty(str)) continue;
                    if (str.equalsIgnoreCase("1"))
                        ordersBuilder.append("Dine In");

                    if (str.equalsIgnoreCase("2"))
                        ordersBuilder.append("Collection");

                    if (str.equalsIgnoreCase("3"))
                        ordersBuilder.append("Delivery");

                    if (str.equalsIgnoreCase("4"))
                        ordersBuilder.append("Bar");

                    if (str.equalsIgnoreCase("5"))
                        ordersBuilder.append("Waiting");

                    if (str.equalsIgnoreCase("6"))
                        ordersBuilder.append("Web Order");

                    if (ordersBuilder.length() > 0) {
                        ordersBuilder.append(", ");
                    }
                }
                sb.append("Not Valid on: ").append(ordersBuilder.toString()).append("\n");
            }

            zonerich.Prn_PrintText(sb.toString(), PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            zonerich.Prn_PrintText("------------------------------------------------\n",
                    PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

            zonerich.Prn_PrintText(footerA + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText(footerB + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                    PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_LineFeed(3);

            // set print set for print in local device
            myPreferences.saveIsPrintBill(true);
            zonerich.Prn_CutPaper();
            zonerich.Prn_Disconnect();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getProductNameWithPad(String productName, String price, int charactersInLine) {
        String itemName = "";
        boolean priceAdded = false;
        if (productName.length() > charactersInLine) {
            StringBuilder sb = new StringBuilder();
            for (String part : getParts(productName, charactersInLine)) {

                if (part.length() >= charactersInLine) {
                    sb.append(part);
                    if (!priceAdded) {
                        sb.append(" ").append(price);
                        priceAdded = true;
                    }
                    sb.append("\n");
                } else {
                    sb.append("   ").append(padRightSpaces(part, charactersInLine));
                }
            }
            itemName = sb.toString();
        } else {
            itemName = padRightSpaces(productName, charactersInLine) + " " + price;
        }
        return itemName;
    }

    private String getSubaddonWithPad(String part, int charatersInLine) {
        String subAddonName = "";
        if (part.contains(":")) {
            String[] parts1 = part.split(":");
            parts1[1] = " -"+parts1[1];
            if (parts1[1].length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(String.valueOf(parts1[1]), charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }
                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(parts1[1].trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();
            }

        } else {
            if (part.length() > charatersInLine) {

                StringBuilder sb = new StringBuilder();
                for (String partSub : getParts(part, charatersInLine)) {

                    if (partSub.length() >= charatersInLine) {
                        sb.append("   ").append(partSub.trim()).append("\n");
                    } else {
                        sb.append("   ").append(padRightSpaces(partSub.trim(), charatersInLine)).append("\n");
                    }
                }

                subAddonName = sb.toString();

            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(padRightSpaces(part.trim(), charatersInLine)).append("\n");
                subAddonName = sb.toString();

            }

        }
        return subAddonName;
    }

    public String padRightSpaces(String str, int n) {
        return String.format("%1$-" + n + "s", str);
    }

    public String padLeftSpace(String str, int n) {
        return String.format("%1$" + n + "s", str);
    }

    private List<String> getParts(String string, int partitionSize) {
        List<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    public void printFullReport(Bitmap bm, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        if (bm != null) {
            zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
            zonerich.Prn_PrintBitmap(bm, PrinterConst.BitmapSize.ZQSIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        }

        if (headerAlignment < 2)
            zonerich.Prn_PrintText(header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        else {
            String[] headers = header.split("\n");
            for (String h : headers) {
                zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
        }
        if (!Validators.isNullOrEmpty(title))
            zonerich.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

        if (!Validators.isNullOrEmpty(date)) {
            zonerich.Prn_PrintText("" + date + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            //zonerich.Prn_PrintText("" + CommonFunctions.formatMiliToDesireFormat(Calendar.getInstance().getTimeInMillis(),"hh:mm a") + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        //reportHeader(PrinterConst.WidthSize.SIZE0);
        if (!Validators.isNullOrEmpty(user)) {
            zonerich.Prn_PrintText("User name: " + user + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        for (Object objct : data) {
            if (objct instanceof ReportTextModel) {
                ReportTextModel textModel = (ReportTextModel) objct;

                String printText;
                if (!textModel.isHeader) {
                    if (!Validators.isNullOrEmpty(textModel.value)) {
                        if (textModel.value.contains(MyApp.currencySymbol)) {
                            printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 35);
                        } else {
                            printText = getProductNameWithPad(textModel.title, textModel.value, 35);
                        }
                    } else printText = getProductNameWithPad(textModel.title, "", 35);
                } else {
                    printText = textModel.title;
                }
                if (textModel.isHeader)
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                else {
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            if (objct instanceof SalesReport) {
                SalesReport salesReport = (SalesReport) objct;
                String name = salesReport.product_name;
                if (Validators.isNullOrEmpty(name)) {
                    name = salesReport.category_name;
                }
                String printText;
                printText = getProductNameWithPad(name + "x(" + salesReport.count + ")", salesReport.total, 35);
                zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
        }

        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText(footerA + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText(footerB + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_LineFeed(3);
        // set print true for local device
        setPrint(myPreferences, true);
        zonerich.Prn_CutPaper();
        disconnectPrinter();
    }

    public void printFoodHubFullReport(Bitmap bm, String header, int headerAlignment, String title, String date, String user, ArrayList<Object> data, String footerA, String footerB, MyPreferences myPreferences) {
        if (bm != null) {
            zonerich.Prn_SetAlignment(PrinterConst.Alignment.CENTER);
            zonerich.Prn_PrintBitmap(bm, PrinterConst.BitmapSize.ZQSIZE0);
            zonerich.Prn_PrintText("\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.HeightSize.SIZE0 | PrinterConst.WidthSize.SIZE0);
        }

        if (headerAlignment < 2)
            zonerich.Prn_PrintText(header + "\n", headerAlignment, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        else {
            String[] headers = header.split("\n");
            for (String h : headers) {
                zonerich.Prn_PrintText(padLeftSpace(h, 35) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
        }
        if (!Validators.isNullOrEmpty(title))
            zonerich.Prn_PrintText(title + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE1 | PrinterConst.HeightSize.SIZE1);
        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);

        if (!Validators.isNullOrEmpty(date)) {
            zonerich.Prn_PrintText("" + date + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            //zonerich.Prn_PrintText("" + CommonFunctions.formatMiliToDesireFormat(Calendar.getInstance().getTimeInMillis(),"hh:mm a") + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        if (!Validators.isNullOrEmpty(myPreferences.getRegisteredDevice().name)) {
            zonerich.Prn_PrintText("" + myPreferences.getRegisteredDevice().name + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        //reportHeader(PrinterConst.WidthSize.SIZE0);
        if (!Validators.isNullOrEmpty(user)) {
            zonerich.Prn_PrintText("User name: " + user + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        }
        zonerich.Prn_PrintText(reportHeader(PrinterConst.WidthSize.SIZE0) + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        for (Object objct : data) {
            if (objct instanceof ReportTextModel) {
                ReportTextModel textModel = (ReportTextModel) objct;

                String printText;
                if (!textModel.isHeader) {
                    if (!Validators.isNullOrEmpty(textModel.value)) {
                        if (textModel.value.contains(MyApp.currencySymbol)) {
                            //printText = getProductNameWithPad(textModel.title, textModel.value.replace(MyApp.currencySymbol, "") + " GBP", 35);
                            printText = reportDetail(PrinterConst.WidthSize.SIZE0, "", textModel.value, textModel.title);
                        } else {
                            //printText = getProductNameWithPad(textModel.title, textModel.value, 35);
                            printText = reportDetail(PrinterConst.WidthSize.SIZE0, textModel.value, "", textModel.title);
                        }
                    } else {
                        if (!Validators.isNullOrEmpty(textModel.totalPrice) || !Validators.isNullOrEmpty(textModel.orderCount)) {
                            printText = reportDetail(PrinterConst.WidthSize.SIZE0, textModel.orderCount, textModel.totalPrice, textModel.title);
                        } else {
                            printText = getProductNameWithPad(textModel.title, "", 35);
                        }
                    }
                } else {
                    printText = textModel.title;
                }
                if (textModel.isHeader) {
                    zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.BOLD, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                    zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                } else {
                    zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
                }
            }
            if (objct instanceof SalesReport) {
                SalesReport salesReport = (SalesReport) objct;
                String name = salesReport.product_name;
                if (Validators.isNullOrEmpty(name)) {
                    name = salesReport.category_name;
                }
                String printText;
                printText = getProductNameWithPad(name + "x(" + salesReport.count + ")", salesReport.total, 35);
                zonerich.Prn_PrintText(printText + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
            }
        }

        zonerich.Prn_PrintText("------------------------------------------------" + "\n", PrinterConst.Alignment.LEFT, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText(footerA + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText(footerB + "\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT, PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_PrintText("\n", PrinterConst.Alignment.CENTER, PrinterConst.Font.DEFAULT,
                PrinterConst.WidthSize.SIZE0 | PrinterConst.HeightSize.SIZE0);
        zonerich.Prn_LineFeed(3);
        // set print true for local device
        setPrint(myPreferences, true);
        zonerich.Prn_CutPaper();
        disconnectPrinter();
    }

    private String reportHeader(int widthSize) {
        String orderTitle = "Orders  ";
        String priceTitle = "   Price";
        int lengthForSize = widthSize == PrinterConst.WidthSize.SIZE0 ? 48 : 24;
        float _60Per = widthSize == PrinterConst.WidthSize.SIZE0 ? 32 : 10;
        String orderPriceTitle = "";
        for (int emptySpace = 0; emptySpace < _60Per; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        // 2 space after orders in order to display space between orders and price
        orderPriceTitle = orderPriceTitle + orderTitle + "";
        orderPriceTitle = orderPriceTitle + priceTitle;
        Log.e("orderPriceTitle", "orderPriceTitleorderPriceTitle " + orderPriceTitle.length());
        return orderPriceTitle;
    }

    private String reportDetail(int widthSize, String ordersValue, String priceValue, String titleValue) {
        int _60Per = widthSize == PrinterConst.WidthSize.SIZE0 ? 28 : 10;
        String orderPriceTitle = "";
        int titleLength = _60Per - titleValue.length();
        orderPriceTitle = titleValue + "";
        for (int emptySpace = 0; emptySpace < titleLength; emptySpace++) {
            orderPriceTitle = orderPriceTitle + " ";
        }
        Log.e("orderPriceTitle", "titleLengthtitleLength " + orderPriceTitle.length());
        // 2 space after orders in order to display space between orders and price
        if (Validators.isNullOrEmpty(ordersValue)) {
            int different = 10 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 10 - ordersValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + ordersValue;
            /*if(ordersValue.length()==1){
                orderPriceTitle =orderPriceTitle+ "   "+ordersValue+"   ";
            }else if(ordersValue.length()==2 || ordersValue.length()==3){
                orderPriceTitle = orderPriceTitle+"  "+ordersValue+"  ";
            }else {
                orderPriceTitle = orderPriceTitle +  ordersValue;
            }*/
        }
        orderPriceTitle = orderPriceTitle + "";
        if (Validators.isNullOrEmpty(priceValue)) {
            int different = 10 - 1;
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + "-";
        } else {
            int different = 10 - priceValue.length();
            for (int i = 0; i < different; i++) {
                orderPriceTitle = orderPriceTitle + " ";
            }
            orderPriceTitle = orderPriceTitle + priceValue;
            /*if(priceValue.length()==1){
                orderPriceTitle = orderPriceTitle+"   "+priceValue+"   ";
            }else if(priceValue.length()==2 || priceValue.length()==3){
                orderPriceTitle = orderPriceTitle+"  "+priceValue+"  ";
            }else {
                orderPriceTitle = orderPriceTitle +  priceValue;
            }*/
        }
        Log.e("orderPriceTitle", "orderPriceTitleorderPriceTitle " + orderPriceTitle.length());
        return orderPriceTitle;
    }
}
