package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.Addon;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface AddonDao {
    @Query("SELECT * FROM Addon ORDER BY sequence ASC")
    public List<Addon> listAll();

    @Query("SELECT * FROM Addon  WHERE parent_id=:parentId ORDER BY sequence ASC")
    public List<Addon> list(String parentId);

    @Query("SELECT * FROM Addon where `id`=:id")
    public Addon view(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(Addon addon);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<Addon> addons);

    @Query("DELETE FROM Addon")
    public void deleteAll();

    @Delete
    public void deleteMultiple(List<Addon> addons);
}
