package com.ubsidi.epos_2021.daos;

import androidx.room.Database;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;

import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Category;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.DeviceInfo;
import com.ubsidi.epos_2021.models.Discount;
import com.ubsidi.epos_2021.models.Floor;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderExternalPayment;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.OrderStatuses;
import com.ubsidi.epos_2021.models.PaymentMethod;
import com.ubsidi.epos_2021.models.PrepLocation;
import com.ubsidi.epos_2021.models.PrintBlock;
import com.ubsidi.epos_2021.models.Product;
import com.ubsidi.epos_2021.models.ProductAddon;
import com.ubsidi.epos_2021.models.ProductIngredient;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.models.User;
import com.ubsidi.epos_2021.models.Voucher;

/**
 * Created by Amrish on 19-05-2021.
 */

@Database(entities =
        {
                User.class,
                Order.class,
                Customer.class,
                OrderItem.class,
                OrderItemAddon.class,
                OrderItemIngredient.class,
                OrderSplit.class,
                OrderPayment.class,
                SiteSetting.class,

                Addon.class,
                Product.class,
                ProductAddon.class,
                ProductIngredient.class,
                Category.class,
                Floor.class,
                Table.class,
                TableStatus.class,
                PrepLocation.class,
                PaymentMethod.class,
                PrintBlock.class,
                CallLogs.class,
                Reservation.class,
                Discount.class,
                Voucher.class,

                OrderStatuses.class,
                DeviceInfo.class,
                OrderExternalPayment.class,
        },
        version = 34, exportSchema = false)

public abstract class AppDatabase extends RoomDatabase {
    public abstract CustomerDao customerDao();

    public abstract OrderDao orderDao();

    public abstract OrderItemDao orderItemDao();

    public abstract OrderItemAddonDao orderItemAddonDao();

    public abstract OrderItemIngredientDao orderItemIngredientDao();

    public abstract OrderSplitDao orderSplitDao();

    public abstract OrderPaymentDao orderPaymentDao();

    public abstract SiteSettingDao siteSettingDao();

    public abstract AddonDao addonDao();

    public abstract ProductDao productDao();

    public abstract ProductAddonDao productAddonDao();

    public abstract ProductIngredientDao productIngredientDao();

    public abstract PrepLocationDao prepLocationDao();

    public abstract VoucherDao voucherDao();

    public abstract CategoryDao categoryDao();

    public abstract FloorDao floorDao();

    public abstract TableDao tableDao();

    public abstract TableStatusDao tableStatusDao();

    public abstract UserDao userDao();

    public abstract OrderExternalPaymentDao orderExternalPaymentDao();

    public abstract PaymentMethodDao paymentMethodDao();

    public abstract EmptyPulledDao emptyPulledDao();

    public abstract PrintBlockDao printBlockDao();

    public abstract CalllogDao calllogDao();

    public abstract ResetDeviceOnDailyDao resetDeviceOnDailyDao();

    public abstract ReservationDao reservationDao();

    public abstract DiscountDao discountDao();

    public abstract ReportDao reportDao();

    public abstract OrderStatuesDao orderStatuesDao();

    public static final Migration MIGRATION_1_2 = new Migration(1, 2) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE Floor ADD sequence INT NOT NULL DEFAULT 0");
        }
    };
    public static final Migration MIGRATION_2_3 = new Migration(2, 3) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("CREATE TABLE IF NOT EXISTS `Discount` (`id` TEXT NOT NULL, `order_type_id` TEXT, `week_day` TEXT, `start_date` TEXT, `end_date` TEXT, `discount` REAL NOT NULL, `minimum_value` REAL NOT NULL, `discount_type` TEXT, PRIMARY KEY(`id`))");
        }
    };
    public static final Migration MIGRATION_3_4 = new Migration(3, 4) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Order` ADD is_archived INT NOT NULL DEFAULT 0");
        }
    };
    public static final Migration MIGRATION_4_5 = new Migration(4, 5) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Table` ADD last_order_total REAL NOT NULL DEFAULT 0");
            database.execSQL("ALTER TABLE `Table` ADD last_order_created_at TEXT");
        }
    };
    public static final Migration MIGRATION_5_6 = new Migration(5, 6) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Order` ADD updated_at TEXT");
        }
    };
    public static final Migration MIGRATION_6_7 = new Migration(6, 7) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Product` ADD auto_addon INT NOT NULL DEFAULT 0");
            database.execSQL("ALTER TABLE `Table` ADD locked INT NOT NULL DEFAULT 0");
        }
    };
    public static final Migration MIGRATION_7_8 = new Migration(7, 8) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
//            database.execSQL("CREATE TABLE IF NOT EXISTS `Voucher` (`_id` INTEGER PRIMARY KEY AUTOINCREMENT,`_customer_id` INTEGER NOT NULL, `id` TEXT NOT NULL, `customer_id` TEXT, `order_type_id` TEXT, `week_day` TEXT,`voucher_code` TEXT,`customer_name` TEXT,`customer_mobile` TEXT, `customer_email` TEXT,`start_date` TEXT, `end_date` TEXT, `voucher_amount` REAL NOT NULL, `minimum_order_value` REAL NOT NULL,uploadable INT NOT NULL DEFAULT 0)");
            database.execSQL("CREATE TABLE IF NOT EXISTS `Voucher` (" +
                    "`_id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT," +
                    "`_customer_id` INTEGER NOT NULL, " +
                    "`id` TEXT, `customer_id` TEXT, " +
                    "`order_type_id` TEXT, `week_day` TEXT," +
                    "`voucher_code` TEXT,`customer_name` TEXT," +
                    "`customer_mobile` TEXT, " +
                    "`customer_email` TEXT," +
                    "`start_date` TEXT, " +
                    "`end_date` TEXT, " +
                    "`voucher_amount` REAL NOT NULL, " +
                    "`minimum_order_value` REAL NOT NULL" +
                    ")"
            );
        }
    };
    public static final Migration MIGRATION_8_9 = new Migration(8, 9) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
//            database.execSQL("ALTER TABLE `Voucher` ADD uploadable INTEGER NOT NULL DEFAULT 0");
        }
    };
    public static final Migration MIGRATION_9_10 = new Migration(9, 10) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Voucher` ADD uploadable INT NOT NULL DEFAULT 0");
        }
    };
    public static final Migration MIGRATION_10_11 = new Migration(10, 11) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Voucher` ADD created_at TEXT");
            database.execSQL("ALTER TABLE `Voucher` ADD updated_at TEXT");
        }
    };
    public static final Migration MIGRATION_11_12 = new Migration(11, 12) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Voucher` ADD disabled INT NOT NULL DEFAULT 0");
        }
    };
    public static final Migration MIGRATION_12_13 = new Migration(12, 13) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("CREATE TABLE IF NOT EXISTS `OrderStatuses` (" +
                    "`_id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT," +
                    "`id` TEXT, `status` TEXT, " +
                    "`top_color` TEXT, `bottom_color` TEXT," +
                    "`created_at` TEXT" +
                    ")"
            );
        }
    };
    public static final Migration MIGRATION_13_14 = new Migration(13, 14) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Product` ADD collection_preparation_location_id TEXT");
            database.execSQL("ALTER TABLE `Product` ADD delivery_preparation_location_id TEXT");
            database.execSQL("ALTER TABLE `Product` ADD banquet_preparation_location_id TEXT");
        }
    };
    public static final Migration MIGRATION_14_15 = new Migration(14, 15) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Order` ADD print_id TEXT");
        }
    };

    public static final Migration MIGRATION_15_16 = new Migration(15, 16) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            //database.execSQL("ALTER TABLE `Customer` ADD news_letter INT NOT NULL DEFAULT 0");
        }
    };

    public static final Migration MIGRATION_16_17 = new Migration(16, 17) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            // Create the new table
            database.execSQL(
                    "CREATE TABLE Customer_new (_id INTEGER PRIMARY KEY NOT NULL,id TEXT, name TEXT,mobile TEXT, email TEXT,landline TEXT, birth_date TEXT,anniversary_date TEXT, house_no TEXT,street TEXT,postcode TEXT,distance TEXT, city TEXT," +
                            "country TEXT,state TEXT,membership_no TEXT,membership_points TEXT,available_credit TEXT,news_letter INT NOT NULL DEFAULT 0)");
            // Copy the data
            database.execSQL(
                    "INSERT INTO Customer_new (id,name,mobile,email,landline,birth_date,anniversary_date,house_no,street,postcode,distance,city,country,state,membership_no,membership_points,available_credit,news_letter) SELECT id,name,mobile,email,landline,birth_date,anniversary_date,house_no,street,postcode,distance,city,country,state,membership_no,membership_points,available_credit,news_letter FROM Customer");
            // Remove the old table
            database.execSQL("DROP TABLE Customer");
            // Change the table name to the correct one
            database.execSQL("ALTER TABLE Customer_new RENAME TO Customer");

        }
    };

    public static final Migration MIGRATION_17_18 = new Migration(17, 18) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Product` ADD barcode TEXT");
        }
    };

    public static final Migration MIGRATION_18_19 = new Migration(18, 19) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Order` ADD is_uploaded_on_server INTEGER NOT NULL DEFAULT 1");
            database.execSQL("ALTER TABLE `Order` ADD unique_id TEXT");
        }
    };

    public static final Migration MIGRATION_19_20 = new Migration(19, 20) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Addon` ADD quantity INTEGER NOT NULL DEFAULT 0");
        }
    };

    public static final Migration MIGRATION_20_21 = new Migration(20, 21) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `OrderItem` ADD sent_to_kitchen_quantity INTEGER NOT NULL DEFAULT 0");
            //database.execSQL("ALTER TABLE `OrderItem` ADD sent_to_kitchen_quantity_for_local_use INTEGER NOT NULL DEFAULT 0");
        }
    };

    public static final Migration MIGRATION_21_22 = new Migration(21, 22) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Reservation` ADD past_days INTEGER  NOT NULL DEFAULT 0");
            //database.execSQL("ALTER TABLE `OrderItem` ADD sent_to_kitchen_quantity_for_local_use INTEGER NOT NULL DEFAULT 0");
        }
    };

    public static final Migration MIGRATION_22_23 = new Migration(22, 23) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Order` ADD is_table_swap INTEGER  NOT NULL DEFAULT 0");
            //database.execSQL("ALTER TABLE `OrderItem` ADD sent_to_kitchen_quantity_for_local_use INTEGER NOT NULL DEFAULT 0");
        }
    };

    public static final Migration MIGRATION_23_24 = new Migration(23, 24) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            //database.execSQL("ALTER TABLE `OrderItem` ADD table_type TEXT");
            database.execSQL("ALTER TABLE `Table` ADD merge_table_id TEXT");
            database.execSQL("ALTER TABLE `Table` ADD merge_table_name TEXT");
            database.execSQL("ALTER TABLE `OrderItem` ADD unique_id TEXT");
            database.execSQL("ALTER TABLE `OrderSplit` ADD unique_id TEXT");
            database.execSQL("ALTER TABLE `OrderPayment` ADD unique_id TEXT");
            database.execSQL("ALTER TABLE `Order` ADD socket_type TEXT");
            //database.execSQL("ALTER TABLE `OrderItem` ADD sent_to_kitchen_quantity_for_local_use INTEGER NOT NULL DEFAULT 0");
        }
    };

    public static final Migration MIGRATION_24_25 = new Migration(24, 25) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("CREATE TABLE IF NOT EXISTS `DeviceInfo` (`id` INTEGER NOT NULL, `resetDate` TEXT,`customerPushData` TEXT, PRIMARY KEY(`id`))");
        }
    };

    public static final Migration MIGRATION_25_26 = new Migration(25, 26) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Table` ADD updater_id TEXT");
        }
    };

    public static final Migration MIGRATION_26_27 = new Migration(26, 27) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Addon` ADD top_color TEXT");
            database.execSQL("ALTER TABLE `Addon` ADD bottom_color TEXT");
        }
    };

    public static final Migration MIGRATION_27_28 = new Migration(27, 28) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Order` ADD delivery_collection_time_slot TEXT");
            database.execSQL("ALTER TABLE `Order` ADD is_delivery_collection_ask INTEGER  NOT NULL DEFAULT 0");
        }
    };

    public static final Migration MIGRATION_28_29 = new Migration(28, 29) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("CREATE TABLE IF NOT EXISTS `OrderExternalPayment` (`_id` INTEGER NOT NULL, `payment_method_name` TEXT, `updater_id` TEXT, `payment_method_id` TEXT, `payment_status` TEXT,`amount` REAL NOT NULL, PRIMARY KEY(`_id`))");
        }
    };

    public static final Migration MIGRATION_29_30 = new Migration(29, 30) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `User` ADD is_loggin INTEGER NOT NULL DEFAULT 0");
        }
    };

    public static final Migration MIGRATION_30_31 = new Migration(30, 31) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `Order` ADD display_order_id TEXT");
            database.execSQL("ALTER TABLE User ADD preffix TEXT");
        }
    };

    public static final Migration MIGRATION_31_32 = new Migration(31, 32) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `ProductIngredient` ADD contain INTEGER  NOT NULL DEFAULT 0");
            database.execSQL("ALTER TABLE `ProductAddon` ADD contain INTEGER  NOT NULL DEFAULT 0");
            database.execSQL("ALTER TABLE `ProductAddon` ADD parent_id TEXT");
        }
    };

    public static final Migration MIGRATION_32_33 = new Migration(32, 33) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `OrderItem` ADD block_name TEXT");
        }
    };

    public static final Migration MIGRATION_33_34 = new Migration(33, 34) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `OrderItem` ADD created_at TEXT");
            database.execSQL("ALTER TABLE `OrderItem` ADD updated_at TEXT");
            database.execSQL("ALTER TABLE `OrderItem` ADD is_delete INTEGER  NOT NULL DEFAULT 0");
            database.execSQL("ALTER TABLE `Order` ADD is_auto_service_charge_remove INTEGER  NOT NULL DEFAULT 0");
        }
    };
}