package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.ubsidi.epos_2021.models.CallLogs;

import java.util.List;

/**
 * Created by Amrish on 15-06-2021.
 */
@Dao
public interface CalllogDao {
    @Query("SELECT * FROM CallLogs Order By _id ASC")
    public List<CallLogs> uploadableList();

    @Query("SELECT * FROM CallLogs WHERE uploadable=1 Order By _id ASC LIMIT 1 ")
    public CallLogs uploadableFirst();

    @Query("SELECT * FROM CallLogs WHERE status='parked' Order By _id ASC LIMIT 1 ")
    public List<CallLogs> getParkedCalls();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public long insert(CallLogs callLogs);

    @Update
    public int update(CallLogs callLogs);

    @Delete
    public void delete(CallLogs callLogs);
}
