package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Transaction;

import com.ubsidi.epos_2021.daos.relations.CategoryWithChildren;
import com.ubsidi.epos_2021.models.Category;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface CategoryDao {
    @Query("SELECT * FROM Category WHERE disabled=0 ORDER BY sequence ASC")
    public List<Category> listAll();

    @Query("SELECT * FROM Category  WHERE parent_id=:parentId AND disabled=0 ORDER BY sequence ASC")
    public List<Category> list(String parentId);

    @Transaction
    @Query("SELECT * FROM Category  WHERE parent_id==0 OR parent_id IS NULL AND disabled=0 ORDER BY sequence ASC")
    public List<CategoryWithChildren> listWithChild();

    @Transaction
    @Query("SELECT * FROM Category  WHERE parent_id IS NULL AND disabled=0 AND print_block_id=:print_block_id ORDER BY sequence ASC")
    public List<CategoryWithChildren> listWithChild(String print_block_id);

    @Transaction
    @Query("SELECT * FROM Category  WHERE parent_id IS NULL AND disabled=0 AND parent_id=:parentId ORDER BY sequence ASC")
    public CategoryWithChildren viewWithChild(String parentId);

    @Query("SELECT * FROM Category where `id`=:id")
    public Category view(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(Category category);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<Category> categories);

    @Query("DELETE FROM Category")
    public void deleteAll();

    @Delete
    public void deleteMultiple(List<Category> categories);

    @Query("SELECT * FROM Category WHERE parent_id==0 OR parent_id IS NULL AND disabled=0 AND is_collection=:is ORDER BY sequence ASC")
    public List<CategoryWithChildren> collectionCategory(boolean is);

    @Query("SELECT * FROM Category WHERE parent_id==0 OR parent_id IS NULL AND disabled=0 AND is_delivery=:is ORDER BY sequence ASC")
    public List<CategoryWithChildren> deliveryCategory(boolean is);

    @Query("SELECT * FROM Category WHERE parent_id==0 OR parent_id IS NULL AND disabled=0 AND is_dinein=:is ORDER BY sequence ASC")
    public List<CategoryWithChildren> dineInCategory(boolean is);

    @Query("SELECT * FROM Category WHERE parent_id==0 OR parent_id IS NULL AND disabled=0 AND is_banquet=:is ORDER BY sequence ASC")
    public List<CategoryWithChildren> waitingCategory(boolean is);
}
