package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.ubsidi.epos_2021.models.Customer;

import java.util.List;

/**
 * Created by Amrish on 19-05-2021.
 */
@Dao
public interface CustomerDao {
    @Query("SELECT * FROM Customer ORDER BY _id DESC")
    List<Customer> list();

    @Query("SELECT * FROM Customer WHERE mobile IS NOT NULL AND name IS NOT NULL AND (LENGTH(name)>=3 OR LENGTH(mobile)>=3) ORDER BY _id DESC")
    List<Customer> listNoNull();

    @Query("SELECT * FROM Customer WHERE name LIKE :query OR mobile LIKE :query ORDER BY _id DESC")
    List<Customer> list(String query);

    @Query("SELECT * FROM Customer WHERE id IS NULL")
    List<Customer> uploadableList();

    @Query("SELECT * FROM Customer WHERE _id=:id")
    Customer view(int id);

    @Query("SELECT * FROM Customer WHERE id=:id ORDER BY _id DESC LIMIT 1")
    Customer view(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(Customer customer);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertMultiple(List<Customer> customers);

    @Update
    void update(Customer customer);

    @Query("UPDATE Customer set id=:customer_id WHERE _id=:customerId")
    void updateCustomerId(String customer_id, int customerId);

    @Query("DELETE FROM Customer WHERE id NOT IN (:ids)")
    void deleteButNotThisIds(List<String> ids);

    @Query("DELETE FROM Customer WHERE id =:id")
    void delete(String id);

    @Query("DELETE FROM Customer WHERE _id =:id")
    void delete(int id);

    @Query("SELECT id FROM Customer WHERE id IS NOT NULL")
    List<String> customerIds();

    @Query("SELECT * FROM Customer WHERE mobile=:number ORDER BY _id DESC LIMIT 1")
    Customer find(String number);

    @Query("DELETE FROM Customer WHERE (mobile=:mobileName and name=:mobileName) OR (mobile=:name and name=:name) OR (mobile=0 and name=:mobileName) OR (mobile=:mobileName and email=:mobileName and house_no=:mobileName and street=:mobileName and postcode=:mobileName)")
    void deleteBlankNameAndMobileNumber(String mobileName, String name);
}
