package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.Discount;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface DiscountDao {
    @Query("SELECT * FROM Discount ORDER BY id ASC")
    public List<Discount> list();

    @Query("SELECT * FROM Discount where `id`=:id")
    public Discount view(String id);

    @Query("SELECT * FROM Discount WHERE (week_day IS NULL OR week_day LIKE :week_days) AND (minimum_value<=:minimum_value OR minimum_value=0) AND (order_type_id IS NULL OR order_type_id LIKE :order_type_id) AND (start_date IS NULL OR date(start_date)<=:start_date) AND (end_date IS NULL OR date(end_date)>=:end_date) ORDER BY discount DESC, minimum_value ASC")
    public List<Discount> eligibleDiscounts(String week_days, String order_type_id, float minimum_value, String start_date, String end_date);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(Discount discount);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<Discount> discounts);

    @Delete
    public void deleteMultiple(List<Discount> discounts);

    @Query("DELETE FROM Discount")
    public void deleteAll();

}
