package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Transaction;

import com.ubsidi.epos_2021.daos.relations.FloorWithTables;
import com.ubsidi.epos_2021.models.Floor;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface FloorDao {
    @Query("SELECT * FROM Floor ORDER BY sequence ASC, id ASC")
    public List<Floor> list();

    @Query("SELECT * FROM Floor where `id`=:id")
    public Floor view(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(Floor floor);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<Floor> floors);

    @Delete
    public void deleteMultiple(List<Floor> floors);

    @Transaction
    @Query("SELECT * FROM Floor where `id`=:id")
    public FloorWithTables viewWithTable(String id);

    @Query("DELETE FROM Floor")
    public void deleteAll();
}
