package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.ubsidi.epos_2021.models.OrderItemAddon;

import java.util.List;

/**
 * Created by Amrish on 19-05-2021.
 */
@Dao
public interface OrderItemAddonDao {
    @Query("SELECT * FROM OrderItemAddon WHERE _order_item_id=:orderItemId ORDER BY _id ASC")
    List<OrderItemAddon> list(int orderItemId);

    @Query("SELECT * FROM OrderItemAddon WHERE order_item_id=:orderItemId")
    List<OrderItemAddon> list(String orderItemId);

    @Query("SELECT * FROM OrderItemAddon WHERE addon_id=:productAddonId AND _order_item_id=:order_item_id")
    OrderItemAddon find(int order_item_id, String productAddonId);

    @Query("SELECT * FROM OrderItemAddon WHERE id=:orderItemAddonId")
    OrderItemAddon view(String orderItemAddonId);

    @Query("SELECT * FROM OrderItemAddon WHERE _id=:orderItemAddonId")
    OrderItemAddon view(int orderItemAddonId);


    @Query("DELETE FROM OrderItemAddon WHERE order_item_id=:orderItemId")
    void deleteAll(String orderItemId);

    @Query("DELETE FROM OrderItemAddon WHERE _order_item_id=:orderItemId")
    void deleteAll(int orderItemId);

    @Query("DELETE FROM OrderItemAddon WHERE _order_item_id=:orderItemId AND id NOT IN(:ids)")
    void deleteOtherIdsButNotThis(int orderItemId, List<String> ids);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(OrderItemAddon orderItemAddon);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    void update(OrderItemAddon orderItemAddon);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertAll(List<OrderItemAddon> orderItemAddons);
}
