package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.RewriteQueriesToDropUnusedColumns;
import androidx.room.Update;

import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;

import java.util.List;

/**
 * Created by Amrish on 19-05-2021.
 */
@Dao
public interface OrderItemDao {
    @Query("SELECT * FROM OrderItem WHERE _order_id=:orderId")
    List<OrderItem> list(int orderId);

    @Query("SELECT * FROM OrderItem WHERE order_id=:orderId")
    List<OrderItem> list(String orderId);

    @Delete
    void delete(OrderItem orderItem);

    @Query("DELETE FROM OrderItem WHERE order_id=:orderId")
    void deleteAll(String orderId);

    @Query("DELETE FROM OrderItem WHERE _order_id=:orderId")
    void deleteAll(int orderId);

    @Query("DELETE FROM OrderItem WHERE _order_id=:orderId AND product_id=:productId")
    void deleteSingleOrderItem(int orderId, String productId);

    @Update
    int update(OrderItem orderItem);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(OrderItem orderItem);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertMultiple(List<OrderItem> orderItems);

    @Query("DELETE FROM OrderItem WHERE _order_id=:orderId AND _id NOT IN (:orderItemIds)")
    void deleteButNotTheseIds(int orderId, List<Integer> orderItemIds);

    @Insert
    void insert_addons(OrderItemAddon... orderItemAddons);

    @Query("UPDATE OrderItem SET " +
            "ingredients_price =:ingredientTotal," +
            "addons_price = :addonTotal," +
            "total=(sub_total+:addonTotal+:ingredientTotal+(instruction_price*quantity)) " +
            "WHERE _id=:orderItemId")
    void updateOrderItemTotal(int orderItemId, float addonTotal, float ingredientTotal);

    @Insert
    void insert_ingredients(OrderItemIngredient... orderItemIngredients);

    @Update
    void update_ingredients(OrderItemIngredient orderItemIngredient);

    @Query("SELECT * FROM OrderItem WHERE _id=:orderItemId")
    OrderItem view(int orderItemId);

    @Query("SELECT * FROM OrderItem WHERE id=:orderItemId")
    OrderItem view(String orderItemId);

    @Query("SELECT * FROM OrderItem WHERE _order_id=:orderId")
    OrderItem viewByOrderId(int orderId);

    @Query("SELECT * FROM OrderItem WHERE _order_id=:orderId AND product_id=:prdId")
    OrderItem viewOrderProduct(int orderId, String prdId);

    @Query("SELECT * FROM OrderItem WHERE _order_id=:orderId AND product_id=:prdId " +
            "AND (special_instruction IS NULL OR special_instruction='') " +
            "AND (order_split_id IS NULL OR order_split_id='') " +
            "AND _order_split_id=0 " +
            "AND _id NOT IN (SELECT _order_item_id FROM OrderItemAddon) " +
            "AND _id NOT IN (SELECT _order_item_id FROM OrderItemIngredient) " +
            "ORDER BY _id DESC")
    OrderItem findOldItemToIncrement(int orderId, String prdId);

    @Query("SELECT * FROM OrderItem WHERE _order_id=:orderId AND product_id=:prdId " +
            "AND (special_instruction IS NULL OR special_instruction='') " +
            "AND (order_split_id IS NULL OR order_split_id='') " +
            "AND _order_split_id=0 " +
            "ORDER BY _id DESC")
    OrderItem findOldItemToIncrementWithoutAddonsIngredient(int orderId, String prdId);

    @Query("SELECT * FROM OrderItem WHERE _order_id=:orderId AND product_id=:prdId " +
            "AND (special_instruction IS NULL OR special_instruction='') " +
            "AND (order_split_id IS NULL OR order_split_id='') " +
            "AND _order_split_id=0 " +
            "AND is_delete=0 " +
            "ORDER BY _id DESC")
    List<OrderItem> findOldItemsToIncrementWithoutAddonsIngredient(int orderId, String prdId);

    @Query("UPDATE OrderItem SET order_split_id=:splitId WHERE _order_split_id=:intSplitId")
    void updateSplitIds(int intSplitId, String splitId);

    @Query("SELECT * FROM OrderItem WHERE _order_id=:orderId AND _order_split_id=0 ORDER BY _id DESC")
    List<OrderItem> listNonSplitItems(int orderId);

    @Query("SELECT COUNT(*) FROM OrderItem WHERE _order_id=:orderId AND _order_split_id=0")
    int listNonSplitItemsCount(int orderId);

    //For DineIn Order...
    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id,PrintBlock.name as block_name FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +
            "WHERE OrderItem.misc=0 " +
            "AND Product.preparation_location_id=:prep_id " +
            "AND OrderItem._order_id=:order_id " +
            "AND OrderItem.is_delete=0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
    List<OrderItem> orderItemProductForPrepLocations(int order_id, String prep_id);

    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id,PrintBlock.name as block_name  FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +
            "WHERE OrderItem.misc=0 " +
            "AND Product.preparation_location_id=:prep_id " +
            "AND OrderItem._order_id=:order_id " +
            "AND OrderItem.is_delete=0 " +
            //"AND sent_to_kitchen=:sentToKichen " +
            "AND sent_to_kitchen_quantity>0 " +
            "AND OrderItem.is_delete=0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
        //List<OrderItem> orderItemProductForPrepLocations(int order_id, String prep_id, boolean sentToKichen);
    List<OrderItem> orderItemProductForPrepLocationsKitchen(int order_id, String prep_id);

    @Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND is_delete=0 AND preparation_location_id=:prep_id")
    List<OrderItem> orderItemsForPrepLocations(int order_id, String prep_id);

    //@Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND preparation_location_id=:prep_id AND sent_to_kitchen=:sentToKichen")
    @Query("SELECT * FROM OrderItem WHERE misc=1 AND is_delete=0 AND _order_id=:order_id AND preparation_location_id=:prep_id AND sent_to_kitchen_quantity>0")
    //List<OrderItem> orderItemsForPrepLocationsKitchen(int order_id, String prep_id, boolean sentToKichen);
    List<OrderItem> orderItemsForPrepLocationsKitchen(int order_id, String prep_id);

    //For Delivery Order...
    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id,PrintBlock.name as block_name  FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +
            "WHERE OrderItem.misc=0 " +
            "AND Product.delivery_preparation_location_id=:prep_id " +
            "AND OrderItem._order_id=:order_id " +
            "AND OrderItem.is_delete=0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
    List<OrderItem> orderItemProductForPrepLocationsDelivery(int order_id, String prep_id);

    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id,PrintBlock.name as block_name  FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +
            "WHERE OrderItem.misc=0 " +
            "AND Product.delivery_preparation_location_id=:prep_id " +
            "AND OrderItem._order_id=:order_id " +
            "AND OrderItem.is_delete=0 " +
//            "AND sent_to_kitchen=:sentToKichen " +
            "AND sent_to_kitchen_quantity>0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
        //List<OrderItem> orderItemProductForPrepLocationsDeliveryKitchen(int order_id, String prep_id, boolean sentToKichen);
    List<OrderItem> orderItemProductForPrepLocationsDeliveryKitchen(int order_id, String prep_id);

    @Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND delivery_preparation_location_id=:prep_id")
    List<OrderItem> orderItemsForPrepLocationsDelivery(int order_id, String prep_id);

    @Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND delivery_preparation_location_id=:prep_id AND sent_to_kitchen=:sentToKichen")
    List<OrderItem> orderItemsForPrepLocationsDelivery(int order_id, String prep_id, boolean sentToKichen);

    //For Collection Order...
    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id,PrintBlock.name as block_name FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +
            "WHERE OrderItem.misc=0 " +
            "AND Product.collection_preparation_location_id=:prep_id " +
            "AND OrderItem._order_id=:order_id " +
            "AND OrderItem.is_delete=0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
    List<OrderItem> orderItemProductForPrepLocationsCollection(int order_id, String prep_id);

    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id,PrintBlock.name as block_name FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +
            "WHERE OrderItem.misc=0 " +
            "AND Product.collection_preparation_location_id=:prep_id " +
            "AND OrderItem._order_id=:order_id " +
            "AND OrderItem.is_delete=0 " +
//            "AND sent_to_kitchen=:sentToKichen " +
            "AND sent_to_kitchen_quantity>0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
        //List<OrderItem> orderItemProductForPrepLocationsCollectionKitchen(int order_id, String prep_id, boolean sentToKichen);
    List<OrderItem> orderItemProductForPrepLocationsCollectionKitchen(int order_id, String prep_id);

    @Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND collection_preparation_location_id=:prep_id")
    List<OrderItem> orderItemsForPrepLocationsCollection(int order_id, String prep_id);

    @Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND collection_preparation_location_id=:prep_id AND sent_to_kitchen=:sentToKichen")
    List<OrderItem> orderItemsForPrepLocationsCollection(int order_id, String prep_id, boolean sentToKichen);


    //For Banquet Order...
    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id,PrintBlock.name as block_name  FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +
            "WHERE OrderItem.misc=0 " +
            "AND Product.banquet_preparation_location_id=:prep_id " +
            "AND OrderItem._order_id=:order_id " +
            "AND OrderItem.is_delete=0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
    List<OrderItem> orderItemProductForPrepLocationsBanquet(int order_id, String prep_id);

    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id,PrintBlock.name as block_name  FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +
            "WHERE OrderItem.misc=0 " +
            "AND Product.banquet_preparation_location_id=:prep_id " +
            "AND OrderItem._order_id=:order_id " +
            "AND OrderItem.is_delete=0 " +
            //"AND sent_to_kitchen=:sentToKichen " +
            "AND sent_to_kitchen_quantity>0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
    //List<OrderItem> orderItemProductForPrepLocationsBanquet(int order_id, String prep_id, boolean sentToKichen);
    List<OrderItem> orderItemProductForPrepLocationsBanquetKitchen(int order_id, String prep_id);

    @Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND banquet_preparation_location_id=:prep_id")
    List<OrderItem> orderItemsForPrepLocationsBanquet(int order_id, String prep_id);

    @Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND banquet_preparation_location_id=:prep_id AND sent_to_kitchen=:sentToKichen")
    List<OrderItem> orderItemsForPrepLocationsBanquet(int order_id, String prep_id, boolean sentToKichen);

    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +

            "WHERE OrderItem._order_id=:order_id " +
            "AND OrderItem.is_delete=0 " +
            "AND OrderItem.misc=0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
    List<OrderItem> orderItemProductForPrint(int order_id);

    @Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND is_delete=0")
    List<OrderItem> orderItemsMiscForPrint(int order_id);

    @RewriteQueriesToDropUnusedColumns
    @Query("SELECT *,Category.print_block_id as block_id FROM OrderItem " +
            "LEFT JOIN Product on OrderItem.product_id = Product.id " +
            "LEFT JOIN Category on Category.id = Product.category_id " +
            "LEFT JOIN PrintBlock on PrintBlock.id = Category.print_block_id " +

            "WHERE OrderItem._order_id=:order_id " +
            "AND OrderItem.misc=0 " +
            "AND OrderItem._order_split_id=:split_id " +
            "AND OrderItem.is_delete=0 " +
            "ORDER BY " +
            "PrintBlock.sequence ASC, " +
            "CASE " +
            "WHEN OrderItem.block_id IS NULL THEN 0 " +
            "WHEN OrderItem.block_id ='' THEN 0 " +
            "END ASC ")
    List<OrderItem> orderItemProductForPrint(int order_id, int split_id);

    @Query("SELECT * FROM OrderItem WHERE misc=1 AND _order_id=:order_id AND _order_split_id=:split_id AND is_delete=0")
    List<OrderItem> orderItemsMiscForPrint(int order_id, int split_id);

    @Query("SELECT * FROM OrderItem WHERE _order_split_id=:splitId ORDER BY _id DESC")
    List<OrderItem> listSplitItems(int splitId);

    @Query("SELECT COUNT(*) FROM OrderItem WHERE _order_split_id=:splitId")
    int count(int splitId);
}
