package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.ubsidi.epos_2021.models.OrderItemIngredient;

import java.util.List;

/**
 * Created by Amrish on 19-05-2021.
 */
@Dao
public interface OrderItemIngredientDao {
    @Query("SELECT * FROM OrderItemIngredient WHERE _order_item_id=:orderItemId ORDER BY _id ASC")
    List<OrderItemIngredient> list(int orderItemId);

    @Query("SELECT * FROM OrderItemIngredient WHERE order_item_id=:orderItemId")
    List<OrderItemIngredient> list(String orderItemId);

    @Query("SELECT * FROM OrderItemIngredient WHERE id=:orderItemIngredientId")
    OrderItemIngredient view(String orderItemIngredientId);

    @Query("SELECT * FROM OrderItemIngredient WHERE  product_ingredient_id=:productIngredientId AND _order_item_id=:order_item_id")
    OrderItemIngredient find(int order_item_id, String productIngredientId);

    @Query("DELETE FROM OrderItemIngredient WHERE order_item_id=:orderItemId")
    void deleteAll(String orderItemId);

    @Query("DELETE FROM OrderItemIngredient WHERE _order_item_id=:orderItemId")
    void deleteAll(int orderItemId);

    @Query("DELETE FROM OrderItemIngredient WHERE _order_item_id=:orderItemId AND product_ingredient_id NOT IN(:ids)")
    void deleteOtherIdsButNotThis(int orderItemId, List<String> ids);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(OrderItemIngredient orderItemIngredient);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    void update(OrderItemIngredient orderItemIngredient);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertAll(List<OrderItemIngredient> orderItemIngredients);
}
