package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.ubsidi.epos_2021.models.OrderPayment;

import java.util.List;

/**
 * Created by Amrish on 21-05-2021.
 */
@Dao
public interface OrderPaymentDao {
    @Query("SELECT * FROM OrderPayment WHERE _order_id=:orderId")
    List<OrderPayment> list(int orderId);

    @Query("SELECT * FROM OrderPayment WHERE order_id=:orderId")
    List<OrderPayment> list(String orderId);

    @Query("SELECT * FROM OrderPayment WHERE _order_split_id=:splitId")
    List<OrderPayment> listBySplit(int splitId);

    @Query("SELECT * FROM OrderPayment WHERE order_split_id=:splitId")
    List<OrderPayment> listBySplit(String splitId);

    @Query("SELECT * FROM OrderPayment WHERE _id=:paymentId")
    OrderPayment view(int paymentId);

    @Query("SELECT * FROM OrderPayment WHERE id=:paymentId")
    OrderPayment view(String paymentId);

    @Query("SELECT * FROM OrderPayment WHERE payment_method_id=:methodId AND _order_id=:orderId ORDER BY _id DESC")
    OrderPayment findByMethod(int orderId, String methodId);

    @Query("SELECT * FROM OrderPayment WHERE payment_method_id=:methodId AND voucher_id=:voucherId ORDER BY _id DESC")
    OrderPayment findVoucher(String voucherId, String methodId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(OrderPayment orderPayment);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertMultiple(List<OrderPayment> orderPayments);

    @Query("DELETE FROM OrderPayment WHERE _order_id =:orderId AND id NOT IN(:ids)")
    void deleteOtherIdsButNotThis(int orderId, List<String> ids);

    @Update
    void update(OrderPayment orderPayment);

    @Delete
    void delete(OrderPayment orderPayment);

    @Query("DELETE FROM OrderPayment WHERE _order_id=:orderId AND payment_method_id=:paymentMethodId")
    void deletePaymentMethodPayment(int orderId, String paymentMethodId);

    @Query("DELETE FROM OrderPayment WHERE order_id=:orderId")
    void deleteAll(String orderId);

    @Query("DELETE FROM OrderPayment WHERE _order_id=:orderId")
    void deleteAll(int orderId);

    @Query("SELECT SUM(amount) FROM OrderPayment WHERE _order_id=:orderId")
    float getTotalPaidAmount(int orderId);

    @Query("SELECT SUM(amount) FROM OrderPayment WHERE _order_id=:orderId AND _order_split_id=:splitId")
    float getSplitTotalPaidAmount(int orderId, int splitId);

    @Query("UPDATE OrderPayment SET order_split_id=:splitId WHERE _order_split_id=:intSplitId AND _order_id=:orderId")
    void updateSplitIds(int orderId, int intSplitId, String splitId);

    @Query("UPDATE OrderPayment SET order_id=:orderId WHERE _order_id=:intOderId")
    void updateOrderId(int intOderId, String orderId);
}
