package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.ubsidi.epos_2021.models.OrderSplit;

import java.util.List;

/**
 * Created by Amrish on 21-05-2021.
 */
@Dao
public interface OrderSplitDao {
    @Query("SELECT * FROM OrderSplit WHERE _order_id=:orderId")
    List<OrderSplit> list(int orderId);

    @Query("SELECT * FROM OrderSplit WHERE order_id=:orderId")
    List<OrderSplit> list(String orderId);

    @Query("SELECT * FROM OrderSplit WHERE order_id=:orderId AND group_name=:name")
    OrderSplit find(String orderId, String name);

    @Query("SELECT * FROM OrderSplit WHERE _id=:split_id")
    OrderSplit view(int split_id);

    @Query("SELECT * FROM OrderSplit WHERE id=:split_id")
    OrderSplit view(String split_id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(OrderSplit orderSplit);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertMultiple(List<OrderSplit> orderSplits);

    @Query("DELETE FROM OrderSplit WHERE _order_id =:orderId AND id NOT IN(:ids)")
    void deleteOtherIdsButNotThis(int orderId, List<String> ids);

    @Update
    void update(OrderSplit orderSplit);

    @Delete
    void delete(OrderSplit orderSplit);


    @Query("DELETE FROM OrderSplit WHERE order_id=:orderId")
    void deleteAll(String orderId);

    @Query("DELETE FROM OrderSplit WHERE _order_id=:orderId")
    void deleteAll(int orderId);

    @Query("UPDATE OrderSplit SET order_id=:orderId WHERE _order_id=:intOderId")
    void updateOrderId(int intOderId, String orderId);

    @Query("UPDATE OrderSplit SET total=(SELECT IFNULL(SUM(total),0) FROM OrderItem WHERE _order_id=:orderId AND _order_split_id=:orderSplitId AND is_delete=0) WHERE _id=:orderSplitId")
    void updateTotalAmount(int orderId, int orderSplitId);

    @Query("UPDATE OrderSplit SET paid_amount=(SELECT IFNULL(SUM(amount),0) FROM OrderPayment WHERE _order_id=:orderId AND _order_split_id= OrderSplit._id) WHERE _order_id=:orderId")
    void updatePaidAmount(int orderId);

    @Query("UPDATE OrderSplit SET paid_amount=(SELECT SUM(amount) FROM OrderPayment WHERE _order_id=:orderId AND _order_split_id= :splitId) WHERE _order_id=:orderId")
    void updatePaidAmount(int orderId, int splitId);
}
